/*
 * Decompiled with CFR 0.152.
 */
package jm.kidney;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jm.cepstrum.BicubicInterpolation;
import jm.extension.ExJButton;
import jm.extension.ExStackWindow;
import jm.util.GridBagConstraints2;

public class ManualMover
extends JFrame
implements ActionListener,
ChangeListener {
    private ImagePlus imagePlus;
    private ImageStack imageStack;
    private ExStackWindow stackWindow;
    private int imageNr;
    private int half;
    private int width;
    private int height;
    private short[] orgPixel;
    private short[] newPixel;
    private double moveAmountX;
    private double moveAmountY;
    private double moveStep;
    private Rectangle windowPos;
    private BicubicInterpolation bic;
    private ImageIcon ImageIconUp = new ImageIcon((class$jm$kidney$ManualMover == null ? (class$jm$kidney$ManualMover = ManualMover.class$("jm.kidney.ManualMover")) : class$jm$kidney$ManualMover).getResource("ArrowUp.gif"));
    private ImageIcon ImageIconDown = new ImageIcon((class$jm$kidney$ManualMover == null ? (class$jm$kidney$ManualMover = ManualMover.class$("jm.kidney.ManualMover")) : class$jm$kidney$ManualMover).getResource("ArrowDown.gif"));
    private ImageIcon ImageIconLeft = new ImageIcon((class$jm$kidney$ManualMover == null ? (class$jm$kidney$ManualMover = ManualMover.class$("jm.kidney.ManualMover")) : class$jm$kidney$ManualMover).getResource("ArrowLeft.gif"));
    private ImageIcon ImageIconRight = new ImageIcon((class$jm$kidney$ManualMover == null ? (class$jm$kidney$ManualMover = ManualMover.class$("jm.kidney.ManualMover")) : class$jm$kidney$ManualMover).getResource("ArrowRight.gif"));
    JPanel jPanelMain = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JSlider jSliderStepping = new JSlider();
    JLabel jLabelStepping = new JLabel();
    JButton jButtonUp = new JButton(this.ImageIconUp);
    JButton jButtonDown = new JButton(this.ImageIconDown);
    JButton jButtonLeft = new JButton(this.ImageIconLeft);
    JButton jButtonRight = new JButton(this.ImageIconRight);
    JLabel jLabelAmountX = new JLabel();
    JLabel jLabelAmountY = new JLabel();
    JPanel jPanelButtons = new JPanel();
    ExJButton jButtonCancel = new ExJButton();
    ExJButton jButtonOk = new ExJButton();
    static /* synthetic */ Class class$jm$kidney$ManualMover;

    public ManualMover(ImagePlus imp, int nr, int h, Rectangle bounds) {
        try {
            this.imagePlus = imp;
            this.width = this.imagePlus.getWidth();
            this.height = this.imagePlus.getHeight();
            this.imageStack = this.imagePlus.getStack();
            this.stackWindow = (ExStackWindow)this.imagePlus.getWindow();
            this.windowPos = bounds;
            this.imageNr = nr + 1;
            this.half = h;
            this.newPixel = (short[])this.imageStack.getPixels(this.imageNr);
            this.orgPixel = new short[this.width * this.height];
            System.arraycopy(this.newPixel, 0, this.orgPixel, 0, this.width * this.height);
            this.bic = new BicubicInterpolation(this.newPixel, this.width, this.height);
            this.moveAmountX = 0.0;
            this.moveAmountY = 0.0;
            this.moveStep = 1.0;
            this.stackWindow.lock();
            this.jbInit();
            this.guiInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setForeground(Color.lightGray);
        this.setBackground(Color.black);
        this.jPanelMain.setForeground(Color.lightGray);
        this.jPanelMain.setBackground(Color.black);
        this.jPanelMain.setLayout(this.gridBagLayout1);
        this.jPanelMain.setFont(new Font("Dialog", 1, 11));
        this.jSliderStepping.setMaximum(20);
        this.jSliderStepping.setMinimum(1);
        this.jSliderStepping.setRequestFocusEnabled(false);
        this.jSliderStepping.setForeground(Color.lightGray);
        this.jSliderStepping.setBackground(Color.black);
        this.jSliderStepping.setToolTipText("Movement per Mouseclick in Pixels");
        this.jLabelStepping.setText("-  Move Stepping: 0,1 Pixel  +");
        this.jLabelStepping.setForeground(Color.lightGray);
        this.jLabelStepping.setBackground(Color.black);
        this.jLabelStepping.setFont(new Font("Dialog", 1, 11));
        this.jButtonUp.setText("");
        this.jButtonUp.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonUp.setBackground(Color.black);
        this.jButtonUp.setToolTipText("move up");
        this.jButtonUp.setFocusPainted(false);
        this.jButtonLeft.setText("");
        this.jButtonLeft.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonLeft.setBackground(Color.black);
        this.jButtonLeft.setToolTipText("move left");
        this.jButtonLeft.setFocusPainted(false);
        this.jButtonRight.setText("");
        this.jButtonRight.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonRight.setBackground(Color.black);
        this.jButtonRight.setToolTipText("move right");
        this.jButtonRight.setFocusPainted(false);
        this.jLabelAmountX.setText(" X: +0,0");
        this.jLabelAmountX.setForeground(Color.white);
        this.jLabelAmountX.setBackground(Color.black);
        this.jLabelAmountX.setFont(new Font("Monospaced", 0, 11));
        this.jLabelAmountX.setToolTipText("Amount moved");
        this.jLabelAmountY.setText(" Y: +0,0");
        this.jLabelAmountY.setForeground(Color.white);
        this.jLabelAmountY.setBackground(Color.black);
        this.jLabelAmountY.setFont(new Font("Monospaced", 0, 11));
        this.jLabelAmountY.setToolTipText("Amount moved");
        this.jButtonDown.setText("");
        this.jButtonDown.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonDown.setBackground(Color.black);
        this.jButtonDown.setToolTipText("move down");
        this.jButtonDown.setFocusPainted(false);
        this.jPanelButtons.setBackground(Color.black);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setPreferredSize(new Dimension(75, 20));
        this.jButtonCancel.setForeground(Color.lightGray);
        this.jButtonCancel.setBackground(Color.black);
        this.jButtonCancel.setFont(new Font("Dialog", 1, 11));
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setPreferredSize(new Dimension(75, 20));
        this.jButtonOk.setForeground(Color.lightGray);
        this.jButtonOk.setBackground(Color.black);
        this.jButtonOk.setFont(new Font("Dialog", 1, 11));
        this.getContentPane().add((Component)this.jPanelMain, null);
        this.jPanelMain.add((Component)this.jSliderStepping, new GridBagConstraints2(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelStepping, new GridBagConstraints2(0, 1, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 15, 0), 0, 0));
        this.jPanelMain.add((Component)this.jButtonUp, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jButtonLeft, new GridBagConstraints2(0, 3, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jButtonRight, new GridBagConstraints2(2, 3, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelAmountX, new GridBagConstraints2(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelAmountY, new GridBagConstraints2(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jButtonDown, new GridBagConstraints2(1, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jPanelButtons, new GridBagConstraints2(0, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCancel, null);
        this.jPanelButtons.add((Component)this.jButtonOk, null);
    }

    public void guiInit() {
        this.jButtonCancel.addActionListener(this);
        this.jButtonOk.addActionListener(this);
        this.jButtonUp.addActionListener(this);
        this.jButtonDown.addActionListener(this);
        this.jButtonLeft.addActionListener(this);
        this.jButtonRight.addActionListener(this);
        this.jSliderStepping.addChangeListener(this);
        this.jSliderStepping.setValue((int)(this.moveStep * 10.0));
        this.setTitle(" Adjuster");
        this.pack();
        this.setResizable(false);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = this.getBounds();
        rect.y = this.windowPos.y;
        rect.x = this.windowPos.x + this.windowPos.width + 1;
        if (this.windowPos.x + this.windowPos.width > screensize.width - 50) {
            rect.x = this.windowPos.x - rect.width - 1;
        }
        this.setBounds(rect);
        this.setVisible(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            if (src == this.jButtonOk) {
                this.stackWindow.unlock();
                this.setVisible(false);
                this.dispose();
            }
            if (src == this.jButtonCancel) {
                System.arraycopy(this.orgPixel, 0, this.newPixel, 0, this.width * this.height);
                this.imagePlus.updateAndRepaintWindow();
                this.stackWindow.unlock();
                this.setVisible(false);
                this.dispose();
            }
            if (src == this.jButtonUp) {
                this.moveAmountY -= this.moveStep;
                this.applyShift(this.moveAmountX * -1.0, this.moveAmountY * -1.0);
            }
            if (src == this.jButtonDown) {
                this.moveAmountY += this.moveStep;
                this.applyShift(this.moveAmountX * -1.0, this.moveAmountY * -1.0);
            }
            if (src == this.jButtonLeft) {
                this.moveAmountX += this.moveStep;
                this.applyShift(this.moveAmountX * -1.0, this.moveAmountY * -1.0);
            }
            if (src == this.jButtonRight) {
                this.moveAmountX -= this.moveStep;
                this.applyShift(this.moveAmountX * -1.0, this.moveAmountY * -1.0);
            }
            if (this.moveAmountX <= 0.0) {
                this.jLabelAmountX.setText(" X: +" + this.d2s(Math.abs(this.moveAmountX), 1));
            } else {
                this.jLabelAmountX.setText(" X: -" + this.d2s(this.moveAmountX, 1));
            }
            if (this.moveAmountY < 0.0) {
                this.jLabelAmountY.setText(" Y: -" + this.d2s(Math.abs(this.moveAmountY), 1));
            } else {
                this.jLabelAmountY.setText(" Y: +" + this.d2s(this.moveAmountY, 1));
            }
        }
    }

    private int s2i(String input) {
        int result = -1;
        String filter = "";
        int i = 0;
        while (i < input.length()) {
            if (Character.isDigit(input.charAt(i))) {
                filter = filter + input.charAt(i);
            }
            ++i;
        }
        while (filter.length() > 0 && filter.charAt(0) == '0') {
            filter = filter.substring(1);
        }
        IJ.wait((int)5);
        if (filter.length() == 0) {
            return 0;
        }
        result = Integer.valueOf(filter);
        return result;
    }

    private String d2s(double d, int l) {
        String result = IJ.d2s((double)d, (int)l);
        result = result.replace('.', ',');
        while (result.length() > 1 && result.charAt(0) == '0' && result.charAt(1) != ',') {
            result = result.substring(1);
        }
        return result;
    }

    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JSlider && src == this.jSliderStepping) {
            this.moveStep = (double)this.jSliderStepping.getValue() / 10.0;
            String text = "-  Move Stepping: ";
            text = text + this.d2s(this.moveStep, 1);
            text = text + " Pixel  +";
            this.jLabelStepping.setText(text);
        }
    }

    private void applyShift(double shiftX, double shiftY) {
        int stop_half;
        int start_half;
        if (this.half == 0) {
            start_half = 0;
            stop_half = this.width / 2;
        } else {
            start_half = this.width / 2;
            stop_half = this.width;
        }
        int start_x = start_half;
        int stop_x = stop_half;
        int adder_x = 1;
        int start_y = 0;
        int stop_y = this.height;
        int adder_y = 1;
        if (shiftX > 0.0) {
            start_x = stop_half - 1;
            stop_x = start_half - 1;
            adder_x = -1;
        }
        if (shiftY > 0.0) {
            start_y = this.height - 1;
            stop_y = -1;
            adder_y = -1;
        }
        int y = start_y;
        while (y != stop_y) {
            int x = start_x;
            while (x != stop_x) {
                int val = this.bic.getPixel((double)x - shiftX, (double)y + shiftY);
                this.newPixel[y * this.width + x] = (short)val;
                x += adder_x;
            }
            y += adder_y;
        }
        this.imagePlus.updateAndRepaintWindow();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

