/*
 * Decompiled with CFR 0.152.
 */
package jm.kidney;

import ij.IJ;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jm.extension.ExJButton;
import jm.kidney.AnalysisDialog;
import jm.util.GridBagConstraints2;

public class PresetsDialog
extends JFrame
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener,
FocusListener {
    public int minDiffSwitch = 10;
    public int ignoreFirst = 3;
    public double classificationRange = 0.5;
    public double cepstrumAccuracy = 2.0;
    public int threadPriority = 10;
    public boolean rasterTransformation = false;
    public boolean verboseText = false;
    public boolean newWindow = false;
    public boolean interpolateMissing = false;
    public boolean showNullValues = false;
    public boolean secondChance = true;
    public boolean writeLog = false;
    public boolean minDiff = true;
    public boolean verboseSIT = false;
    public boolean splashScreen = true;
    public boolean okPressed = false;
    private AnalysisDialog analysisDialog = null;
    JTabbedPane jTabbedPane = new JTabbedPane();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    ExJButton jButtonCancel = new ExJButton();
    ExJButton jButtonOk = new ExJButton();
    JPanel jPanelButtons = new JPanel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JPanel jTabCepstrum = new JPanel();
    JPanel jTabCPU = new JPanel();
    JLabel jLabelIgnoreImages = new JLabel();
    JRadioButton checkboxMinimumDiff = new JRadioButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jTabSIT = new JPanel();
    JTextField jTextFieldIgnore = new JTextField();
    JLabel jLabelIgnore = new JLabel();
    JPanel jPanelMinimumDiff = new JPanel();
    JTextField jTextFieldMinDiff = new JTextField();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JLabel jLabelIgnoreImages1 = new JLabel();
    JRadioButton checkboxSecondChance = new JRadioButton();
    JRadioButton checkboxRasterTransform = new JRadioButton();
    JRadioButton checkboxNewWindow = new JRadioButton();
    JRadioButton checkboxVerboseText = new JRadioButton();
    JPanel jPanelIgnore = new JPanel();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JRadioButton checkboxShowNull = new JRadioButton();
    JRadioButton checkboxInterpolateMissing = new JRadioButton();
    JSlider jSliderClassificationRange = new JSlider();
    JLabel jLabelClassificationRange = new JLabel();
    JRadioButton jRadioButtonCPUHigh = new JRadioButton();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    JLabel jLabelThreadState = new JLabel();
    JRadioButton jRadioButtonCPUMid = new JRadioButton();
    JRadioButton jRadioButtonCPULow = new JRadioButton();
    ButtonGroup cpuPriorityButtons = new ButtonGroup();
    ExJButton jButtonReset = new ExJButton();
    JSlider jSliderDefaultAccuracy = new JSlider();
    JLabel jLabelDefaultAccuracy = new JLabel();
    JRadioButton checkboxWriteLog = new JRadioButton();
    JRadioButton checkboxVerboseSIT = new JRadioButton();
    JRadioButton checkboxSplashScreen = new JRadioButton();

    public PresetsDialog(AnalysisDialog dlg) {
        try {
            this.analysisDialog = dlg;
            this.jbInit();
            if (!this.loadPresetFile()) {
                this.setDefaultValues(false);
            }
            this.guiInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setForeground(Color.black);
        this.setBackground(Color.black);
        this.getContentPane().setLayout(this.gridBagLayout3);
        this.jTabbedPane.setBackground(Color.gray);
        this.jTabbedPane.setFont(new Font("Dialog", 1, 11));
        this.jTabbedPane.setToolTipText("");
        this.jTabbedPane.setMinimumSize(new Dimension(184, 111));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 24, 2, 24));
        this.jButtonCancel.setForeground(Color.lightGray);
        this.jButtonCancel.setBackground(Color.black);
        this.jButtonCancel.setFont(new Font("Dialog", 1, 11));
        this.jButtonCancel.setToolTipText("close Window (don't save changed Presets) ");
        this.jButtonOk.setText("OK");
        this.jButtonOk.setMargin(new Insets(2, 34, 2, 34));
        this.jButtonOk.setForeground(Color.lightGray);
        this.jButtonOk.setBackground(Color.black);
        this.jButtonOk.setFont(new Font("Dialog", 1, 11));
        this.jButtonOk.setToolTipText("close Window (save changed Presets) ");
        this.jPanelButtons.setForeground(Color.lightGray);
        this.jPanelButtons.setBackground(Color.black);
        this.jTabCepstrum.setPreferredSize(new Dimension(10, 10));
        this.jTabCepstrum.setForeground(Color.lightGray);
        this.jTabCepstrum.setBackground(Color.black);
        this.jTabCepstrum.setMinimumSize(new Dimension(200, 100));
        this.jTabCPU.setForeground(Color.lightGray);
        this.jTabCPU.setBackground(Color.black);
        this.jTabCPU.setLayout(this.gridBagLayout7);
        this.jTabCepstrum.setLayout(this.gridBagLayout1);
        this.jLabelIgnoreImages.setText("images");
        this.jLabelIgnoreImages.setForeground(Color.lightGray);
        this.jLabelIgnoreImages.setBackground(Color.black);
        this.jLabelIgnoreImages.setFont(new Font("Dialog", 1, 11));
        this.jLabelIgnoreImages.setOpaque(true);
        this.checkboxMinimumDiff.setRequestFocusEnabled(false);
        this.checkboxMinimumDiff.setForeground(Color.lightGray);
        this.checkboxMinimumDiff.setFont(new Font("Dialog", 1, 11));
        this.checkboxMinimumDiff.setOpaque(false);
        this.checkboxMinimumDiff.setFocusPainted(false);
        this.checkboxMinimumDiff.setBackground(Color.darkGray);
        this.checkboxMinimumDiff.setText("Switch to Minimum Difference after");
        this.jTabSIT.setBackground(Color.black);
        this.jTextFieldMinDiff.setHorizontalAlignment(4);
        this.jTextFieldMinDiff.setText("  10");
        this.jTextFieldMinDiff.setForeground(Color.white);
        this.jTextFieldMinDiff.setBackground(Color.darkGray);
        this.jTextFieldMinDiff.setFont(new Font("Monospaced", 0, 12));
        this.jTextFieldMinDiff.setToolTipText("klick to edit");
        this.jLabelIgnoreImages1.setOpaque(true);
        this.checkboxSecondChance.setFont(new Font("Dialog", 1, 11));
        this.checkboxSecondChance.setOpaque(false);
        this.checkboxSecondChance.setFocusPainted(false);
        this.checkboxSecondChance.setRequestFocusEnabled(false);
        this.checkboxSecondChance.setForeground(Color.lightGray);
        this.checkboxSecondChance.setText("Second Chance if fails (recommended)");
        this.checkboxSecondChance.setBackground(Color.darkGray);
        this.checkboxRasterTransform.setRequestFocusEnabled(false);
        this.checkboxRasterTransform.setEnabled(false);
        this.checkboxRasterTransform.setForeground(Color.white);
        this.checkboxRasterTransform.setFont(new Font("Dialog", 1, 11));
        this.checkboxRasterTransform.setOpaque(false);
        this.checkboxRasterTransform.setFocusPainted(false);
        this.checkboxRasterTransform.setText("Use Rastertransformation for Fineadjustement");
        this.checkboxRasterTransform.setBackground(Color.darkGray);
        this.checkboxNewWindow.setRequestFocusEnabled(false);
        this.checkboxNewWindow.setEnabled(false);
        this.checkboxNewWindow.setForeground(Color.lightGray);
        this.checkboxNewWindow.setFont(new Font("Dialog", 1, 11));
        this.checkboxNewWindow.setOpaque(false);
        this.checkboxNewWindow.setFocusPainted(false);
        this.checkboxNewWindow.setText("Show corrected Series in new Window");
        this.checkboxNewWindow.setBackground(Color.darkGray);
        this.checkboxVerboseText.setFont(new Font("Dialog", 1, 11));
        this.checkboxVerboseText.setOpaque(false);
        this.checkboxVerboseText.setFocusPainted(false);
        this.checkboxVerboseText.setRequestFocusEnabled(false);
        this.checkboxVerboseText.setForeground(Color.lightGray);
        this.checkboxVerboseText.setText("Verbose Results in ImageJ-Window");
        this.checkboxVerboseText.setBackground(Color.darkGray);
        this.jPanelIgnore.setBackground(Color.black);
        this.checkboxShowNull.setRequestFocusEnabled(false);
        this.checkboxShowNull.setForeground(Color.lightGray);
        this.checkboxShowNull.setFont(new Font("Dialog", 1, 11));
        this.checkboxShowNull.setOpaque(false);
        this.checkboxShowNull.setFocusPainted(false);
        this.checkboxShowNull.setBackground(Color.darkGray);
        this.checkboxShowNull.setText("Show Null Values");
        this.checkboxInterpolateMissing.setRequestFocusEnabled(false);
        this.checkboxInterpolateMissing.setForeground(Color.lightGray);
        this.checkboxInterpolateMissing.setFont(new Font("Dialog", 1, 11));
        this.checkboxInterpolateMissing.setOpaque(false);
        this.checkboxInterpolateMissing.setSelected(true);
        this.checkboxInterpolateMissing.setFocusPainted(false);
        this.checkboxInterpolateMissing.setText("Interpolate missing Values");
        this.checkboxInterpolateMissing.setBackground(Color.darkGray);
        this.jSliderClassificationRange.setValue(5);
        this.jSliderClassificationRange.setMaximum(9);
        this.jSliderClassificationRange.setMinimum(2);
        this.jSliderClassificationRange.setMajorTickSpacing(1);
        this.jSliderClassificationRange.setMinorTickSpacing(1);
        this.jSliderClassificationRange.setRequestFocusEnabled(false);
        this.jSliderClassificationRange.setForeground(Color.lightGray);
        this.jSliderClassificationRange.setBackground(Color.black);
        this.jLabelClassificationRange.setText("Classification Range: 0.5 - 1.5");
        this.jLabelClassificationRange.setForeground(Color.lightGray);
        this.jLabelClassificationRange.setBackground(Color.black);
        this.jLabelClassificationRange.setFont(new Font("Dialog", 1, 11));
        this.jLabelClassificationRange.setOpaque(true);
        this.jRadioButtonCPUHigh.setRequestFocusEnabled(false);
        this.jRadioButtonCPUHigh.setText("high (recommended)");
        this.jRadioButtonCPUHigh.setForeground(Color.lightGray);
        this.jRadioButtonCPUHigh.setBackground(new Color(0, 161, 0));
        this.jRadioButtonCPUHigh.setFont(new Font("Dialog", 1, 11));
        this.jRadioButtonCPUHigh.setOpaque(false);
        this.jRadioButtonCPUHigh.setFocusPainted(false);
        this.jLabelThreadState.setText("Thread CPU Priority");
        this.jLabelThreadState.setForeground(Color.lightGray);
        this.jLabelThreadState.setBackground(Color.black);
        this.jLabelThreadState.setFont(new Font("Dialog", 1, 11));
        this.jLabelThreadState.setOpaque(true);
        this.jRadioButtonCPUMid.setRequestFocusEnabled(false);
        this.jRadioButtonCPUMid.setText("mid");
        this.jRadioButtonCPUMid.setForeground(Color.lightGray);
        this.jRadioButtonCPUMid.setBackground(new Color(200, 145, 0));
        this.jRadioButtonCPUMid.setFont(new Font("Dialog", 1, 11));
        this.jRadioButtonCPUMid.setOpaque(false);
        this.jRadioButtonCPUMid.setFocusPainted(false);
        this.jRadioButtonCPULow.setRequestFocusEnabled(false);
        this.jRadioButtonCPULow.setText("low");
        this.jRadioButtonCPULow.setForeground(Color.lightGray);
        this.jRadioButtonCPULow.setBackground(new Color(128, 0, 0));
        this.jRadioButtonCPULow.setFont(new Font("Dialog", 1, 11));
        this.jRadioButtonCPULow.setOpaque(false);
        this.jRadioButtonCPULow.setFocusPainted(false);
        this.jButtonReset.setText("Default Values");
        this.jButtonReset.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonReset.setForeground(Color.lightGray);
        this.jSliderDefaultAccuracy.setValue(20);
        this.jSliderDefaultAccuracy.setMaximum(40);
        this.jSliderDefaultAccuracy.setMinimum(10);
        this.jSliderDefaultAccuracy.setRequestFocusEnabled(false);
        this.jSliderDefaultAccuracy.setForeground(Color.lightGray);
        this.jSliderDefaultAccuracy.setBackground(Color.black);
        this.jSliderDefaultAccuracy.setFont(new Font("Dialog", 1, 11));
        this.jLabelDefaultAccuracy.setText("-   default Cepstrum accuracy 1.0  +");
        this.jLabelDefaultAccuracy.setForeground(Color.lightGray);
        this.jLabelDefaultAccuracy.setBackground(Color.black);
        this.jLabelDefaultAccuracy.setFont(new Font("Dialog", 1, 11));
        this.checkboxWriteLog.setFont(new Font("Dialog", 1, 11));
        this.checkboxWriteLog.setOpaque(false);
        this.checkboxWriteLog.setSelected(true);
        this.checkboxWriteLog.setFocusPainted(false);
        this.checkboxVerboseSIT.setForeground(Color.lightGray);
        this.checkboxVerboseSIT.setFont(new Font("Dialog", 1, 11));
        this.checkboxVerboseSIT.setOpaque(false);
        this.checkboxVerboseSIT.setSelected(true);
        this.checkboxVerboseSIT.setFocusPainted(false);
        this.checkboxSplashScreen.setFont(new Font("Dialog", 1, 11));
        this.checkboxSplashScreen.setOpaque(false);
        this.checkboxSplashScreen.setSelected(true);
        this.checkboxSplashScreen.setFocusPainted(false);
        this.checkboxSplashScreen.setRequestFocusEnabled(false);
        this.checkboxSplashScreen.setForeground(Color.lightGray);
        this.checkboxSplashScreen.setText("Show Splashscreen");
        this.checkboxSplashScreen.setBackground(Color.darkGray);
        this.checkboxVerboseSIT.setText("Verbose Results in ImageJ-Window");
        this.checkboxVerboseSIT.setBackground(Color.darkGray);
        this.checkboxWriteLog.setRequestFocusEnabled(false);
        this.checkboxWriteLog.setForeground(Color.lightGray);
        this.checkboxWriteLog.setText("Write Results to Logfile");
        this.checkboxWriteLog.setBackground(Color.black);
        this.jButtonReset.setBackground(Color.black);
        this.jButtonReset.setFont(new Font("Dialog", 1, 11));
        this.jButtonReset.setToolTipText("restore default Values");
        this.jPanelIgnore.setLayout(this.gridBagLayout6);
        this.jLabelIgnoreImages1.setFont(new Font("Dialog", 1, 11));
        this.jLabelIgnoreImages1.setBackground(Color.black);
        this.jLabelIgnoreImages1.setForeground(Color.lightGray);
        this.jLabelIgnoreImages1.setText("images");
        this.jTextFieldMinDiff.setCaretColor(Color.orange);
        this.jTextFieldIgnore.setHorizontalAlignment(4);
        this.jTextFieldIgnore.setText("   3");
        this.jTextFieldIgnore.setForeground(Color.white);
        this.jTextFieldIgnore.setBackground(Color.darkGray);
        this.jTextFieldIgnore.setFont(new Font("Monospaced", 0, 12));
        this.jTextFieldIgnore.setToolTipText("klick to edit");
        this.jLabelIgnore.setText("Ignore first");
        this.jLabelIgnore.setForeground(Color.lightGray);
        this.jLabelIgnore.setBackground(Color.black);
        this.jLabelIgnore.setFont(new Font("Dialog", 1, 11));
        this.jPanelMinimumDiff.setBackground(Color.black);
        this.jPanelMinimumDiff.setLayout(this.gridBagLayout5);
        this.jTextFieldIgnore.setCaretColor(Color.orange);
        this.jTabSIT.setLayout(this.gridBagLayout2);
        this.jPanelButtons.setLayout(this.gridBagLayout4);
        this.getContentPane().add((Component)this.jTabbedPane, new GridBagConstraints2(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 240, 180));
        this.jTabbedPane.addTab("Cepstrum Settings", this.jTabCepstrum);
        this.jTabCepstrum.add((Component)this.jPanelMinimumDiff, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMinimumDiff.add((Component)this.checkboxMinimumDiff, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMinimumDiff.add((Component)this.jTextFieldMinDiff, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMinimumDiff.add((Component)this.jLabelIgnoreImages1, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.jTabCepstrum.add((Component)this.checkboxSecondChance, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCepstrum.add((Component)this.checkboxRasterTransform, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCepstrum.add((Component)this.checkboxNewWindow, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCepstrum.add((Component)this.checkboxVerboseText, new GridBagConstraints2(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCepstrum.add((Component)this.jPanelIgnore, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelIgnore.add((Component)this.jLabelIgnore, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 7), 0, 0));
        this.jPanelIgnore.add((Component)this.jTextFieldIgnore, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelIgnore.add((Component)this.jLabelIgnoreImages, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.jTabCepstrum.add((Component)this.jSliderDefaultAccuracy, new GridBagConstraints2(0, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 98), 0, 0));
        this.jTabCepstrum.add((Component)this.jLabelDefaultAccuracy, new GridBagConstraints2(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 80), 0, 0));
        this.jTabCepstrum.add((Component)this.checkboxWriteLog, new GridBagConstraints2(0, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabbedPane.addTab("SIT Settings", this.jTabSIT);
        this.jTabSIT.add((Component)this.checkboxShowNull, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabSIT.add((Component)this.checkboxInterpolateMissing, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabSIT.add((Component)this.jSliderClassificationRange, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabSIT.add((Component)this.jLabelClassificationRange, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabSIT.add((Component)this.checkboxVerboseSIT, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanelButtons, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCancel, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonOk, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonReset, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jTabbedPane.addTab("Other Settings", this.jTabCPU);
        this.jTabCPU.add((Component)this.jRadioButtonCPULow, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCPU.add((Component)this.jRadioButtonCPUMid, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCPU.add((Component)this.jRadioButtonCPUHigh, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabCPU.add((Component)this.jLabelThreadState, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.jTabCPU.add((Component)this.checkboxSplashScreen, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
    }

    public void guiInit() {
        this.cpuPriorityButtons.add(this.jRadioButtonCPUHigh);
        this.cpuPriorityButtons.add(this.jRadioButtonCPUMid);
        this.cpuPriorityButtons.add(this.jRadioButtonCPULow);
        this.checkboxMinimumDiff.addMouseListener(this);
        this.checkboxMinimumDiff.addKeyListener(this);
        this.checkboxInterpolateMissing.addMouseListener(this);
        this.checkboxNewWindow.addMouseListener(this);
        this.checkboxRasterTransform.addMouseListener(this);
        this.checkboxSecondChance.addMouseListener(this);
        this.checkboxShowNull.addMouseListener(this);
        this.checkboxVerboseText.addMouseListener(this);
        this.checkboxWriteLog.addMouseListener(this);
        this.jRadioButtonCPUHigh.addActionListener(this);
        this.jRadioButtonCPUMid.addActionListener(this);
        this.jRadioButtonCPULow.addActionListener(this);
        this.jTextFieldIgnore.addActionListener(this);
        this.jTextFieldIgnore.addFocusListener(this);
        this.jTextFieldMinDiff.addActionListener(this);
        this.jTextFieldMinDiff.addFocusListener(this);
        this.jButtonOk.addActionListener(this);
        this.jButtonCancel.addActionListener(this);
        this.jButtonReset.addActionListener(this);
        this.jSliderClassificationRange.addChangeListener(this);
        this.jSliderDefaultAccuracy.addChangeListener(this);
        this.setTitle(" Presets");
        this.pack();
        this.setResizable(false);
        this.jTabbedPane.setSelectedIndex(1);
        this.repaint();
        IJ.wait((int)100);
        this.jTabbedPane.setSelectedIndex(2);
        this.repaint();
        IJ.wait((int)100);
        this.jTabbedPane.setSelectedIndex(1);
        this.repaint();
        IJ.wait((int)100);
        this.jTabbedPane.setSelectedIndex(0);
        this.repaint();
        IJ.wait((int)100);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            if (this.jRadioButtonCPUHigh.isSelected()) {
                this.threadPriority = 10;
            }
            if (this.jRadioButtonCPUMid.isSelected()) {
                this.threadPriority = 5;
            }
            if (this.jRadioButtonCPULow.isSelected()) {
                this.threadPriority = 1;
            }
            if (src == this.jButtonOk) {
                this.okPressed = true;
                this.savePresetFile();
                this.setVisible(false);
                this.analysisDialog.presetsDialogClosed();
            }
            if (src == this.jButtonCancel) {
                this.okPressed = false;
                this.setVisible(false);
                this.analysisDialog.presetsDialogClosed();
            }
            if (src == this.jButtonReset) {
                this.setDefaultValues(true);
            }
        }
        if (src instanceof JTextField) {
            this.handleTextFieldInputs((JTextField)src);
        }
    }

    private void handleTextFieldInputs(JTextField tf) {
        JTextField jTextField = this.jTextFieldIgnore;
        if (tf == this.jTextFieldMinDiff) {
            jTextField = this.jTextFieldMinDiff;
        }
        String input = jTextField.getText();
        int pos = -1;
        try {
            pos = this.analyseNumericInput(input);
            if (pos > -1) {
                IJ.write((String)"war wohl falsche Eingabe");
                jTextField.setCaretPosition(pos);
                jTextField.setSelectionStart(pos);
                jTextField.setSelectionEnd(pos + 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pos == -1) {
            int newValue = this.s2i(input);
            if (tf == this.jTextFieldMinDiff) {
                if (newValue < 12) {
                    JOptionPane.showMessageDialog(null, "Please enter a value greater than 12 !", " Value to small", 0);
                } else {
                    this.minDiffSwitch = newValue;
                }
            } else if (newValue < 0 || newValue > 10) {
                JOptionPane.showMessageDialog(null, "Please enter a value between 0 and 10 !", " Wrong Value", 0);
            } else {
                this.ignoreFirst = newValue;
            }
            while (input.length() < 4) {
                input = " " + input;
            }
            jTextField.setText(input);
            jTextField.repaint();
        }
    }

    private int analyseNumericInput(String input) {
        int result = -1;
        int i = 0;
        while (i <= input.length()) {
            if (input.charAt(i) != ' ' && !Character.isDigit(input.charAt(i))) {
                result = i;
                i = input.length() + 1;
            }
            ++i;
        }
        return result;
    }

    private int s2i(String input) {
        int result = -1;
        String filter = "";
        int i = 0;
        while (i < input.length()) {
            if (Character.isDigit(input.charAt(i))) {
                filter = filter + input.charAt(i);
            }
            ++i;
        }
        while (filter.length() > 0 && filter.charAt(0) == '0') {
            filter = filter.substring(1);
        }
        IJ.wait((int)5);
        if (filter.length() == 0) {
            return 0;
        }
        result = Integer.valueOf(filter);
        return result;
    }

    private String d2s(double d, int l) {
        String result = IJ.d2s((double)d, (int)l);
        result = result.replace(',', '.');
        while (result.length() > 1 && result.charAt(0) == '0' && result.charAt(1) != '.') {
            result = result.substring(1);
        }
        return result;
    }

    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JSlider) {
            if (src == this.jSliderClassificationRange) {
                this.classificationRange = (double)this.jSliderClassificationRange.getValue() / 10.0;
                double min = 1.0 - this.classificationRange + 0.01;
                double max = 1.0 + this.classificationRange;
                String text = "Classification Range: ";
                text = text + this.d2s(min, 1);
                text = text + " - ";
                text = text + this.d2s(max, 1);
                this.jLabelClassificationRange.setText(text);
            }
            if (src == this.jSliderDefaultAccuracy) {
                this.cepstrumAccuracy = (double)this.jSliderDefaultAccuracy.getValue() / 10.0;
                String text = "-   default Cepstrum accuracy ";
                text = text + this.d2s(this.cepstrumAccuracy, 1);
                text = text + "  +";
                this.jLabelDefaultAccuracy.setText(text);
            }
        }
    }

    public void focusLost(FocusEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JTextField) {
            this.handleTextFieldInputs((JTextField)src);
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JRadioButton && src == this.checkboxMinimumDiff) {
            this.enableMinDiffField(this.checkboxMinimumDiff.isSelected());
        }
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JRadioButton && src == this.checkboxMinimumDiff) {
            this.enableMinDiffField(this.checkboxMinimumDiff.isSelected());
        }
        this.interpolateMissing = this.checkboxInterpolateMissing.isSelected();
        this.newWindow = this.checkboxNewWindow.isSelected();
        this.rasterTransformation = this.checkboxRasterTransform.isSelected();
        this.secondChance = this.checkboxSecondChance.isSelected();
        this.showNullValues = this.checkboxShowNull.isSelected();
        this.verboseText = this.checkboxVerboseText.isSelected();
        this.verboseSIT = this.checkboxVerboseSIT.isSelected();
    }

    private void enableMinDiffField(boolean enabled) {
        if (enabled) {
            this.jTextFieldMinDiff.setEnabled(true);
            this.jTextFieldMinDiff.setEditable(true);
            this.jTextFieldMinDiff.setBackground(Color.darkGray);
            this.jTextFieldMinDiff.setForeground(Color.white);
        } else {
            this.jTextFieldMinDiff.setEnabled(false);
            this.jTextFieldMinDiff.setEditable(false);
            this.jTextFieldMinDiff.setBackground(Color.black);
            this.jTextFieldMinDiff.setForeground(Color.lightGray);
        }
        this.jTextFieldMinDiff.repaint();
        this.minDiff = this.checkboxMinimumDiff.isSelected();
    }

    private void setDefaultValues(boolean showWarning) {
        if (showWarning) {
            int questionResult = 0;
            Object[] msg = new Object[]{"Are you sure to load the default Settings ?", " ", "All previous settings will be overwritten !"};
            String title = " Warning";
            questionResult = JOptionPane.showConfirmDialog(null, msg, title, 2);
            if (questionResult == 2) {
                return;
            }
        }
        this.jTextFieldMinDiff.setText("  12");
        this.minDiffSwitch = 12;
        this.jTextFieldIgnore.setText("   3");
        this.ignoreFirst = 3;
        this.checkboxInterpolateMissing.setSelected(true);
        this.checkboxMinimumDiff.setSelected(true);
        this.enableMinDiffField(this.checkboxMinimumDiff.isSelected());
        this.checkboxNewWindow.setSelected(false);
        this.checkboxRasterTransform.setSelected(false);
        this.checkboxSecondChance.setSelected(true);
        this.checkboxShowNull.setSelected(false);
        this.checkboxVerboseText.setSelected(true);
        this.checkboxVerboseSIT.setSelected(true);
        this.checkboxWriteLog.setSelected(true);
        this.jRadioButtonCPUHigh.setSelected(true);
        this.jRadioButtonCPUMid.setSelected(false);
        this.jRadioButtonCPULow.setSelected(false);
        this.jSliderClassificationRange.setValue(5);
        this.classificationRange = 0.5;
        double min = 1.0 - this.classificationRange + 0.01;
        double max = 1.0 + this.classificationRange;
        String text = "Classification Range: ";
        text = text + Double.toString(min).substring(0, 3);
        text = text + " - ";
        text = text + Double.toString(max).substring(0, 3);
        this.jLabelClassificationRange.setText(text);
        this.jSliderDefaultAccuracy.setValue(20);
        this.cepstrumAccuracy = 2.0;
        text = "-   default Cepstrum accuracy ";
        text = text + this.d2s(this.cepstrumAccuracy, 1);
        text = text + "  +";
        this.jLabelDefaultAccuracy.setText(text);
    }

    private boolean savePresetFile() {
        boolean result = true;
        File saveFile = new File(System.getProperty("user.dir") + File.separator + "RenalFunctionAnalysis.properties");
        FileWriter w = null;
        try {
            w = new FileWriter(saveFile.getPath(), false);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        try {
            w.write("Ignore Images at Start = " + this.ignoreFirst + "\r\n");
            w.write("Switch to Minimum Difference = " + this.minDiffSwitch + "\r\n");
            w.write("Enable Minimum Difference = ");
            if (this.checkboxMinimumDiff.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Second Chance  = ");
            if (this.checkboxSecondChance.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Enable Raster Transformation = ");
            if (this.checkboxRasterTransform.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Enable New Window = ");
            if (this.checkboxNewWindow.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Verbose Text = ");
            if (this.checkboxVerboseText.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Show Null Values = ");
            if (this.checkboxShowNull.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Interpolate missing Values = ");
            if (this.checkboxInterpolateMissing.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Thread CPU Priority = ");
            if (this.jRadioButtonCPUHigh.isSelected()) {
                w.write("3\r\n");
            }
            if (this.jRadioButtonCPUMid.isSelected()) {
                w.write("2\r\n");
            }
            if (this.jRadioButtonCPULow.isSelected()) {
                w.write("1\r\n");
            }
            w.write("Classification Range = " + this.jSliderClassificationRange.getValue() + "\r\n");
            w.write("Default Accuracy = " + this.jSliderDefaultAccuracy.getValue() + "\r\n");
            w.write("Write Logfile = ");
            if (this.checkboxWriteLog.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Verbose SIT = ");
            if (this.checkboxVerboseSIT.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("Show Splashscreen = ");
            if (this.checkboxSplashScreen.isSelected()) {
                w.write("1\r\n");
            } else {
                w.write("0\r\n");
            }
            w.write("\r\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            result = false;
        }
        try {
            ((Writer)w).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            result = false;
        }
        return result;
    }

    private boolean loadPresetFile() {
        boolean result = true;
        File loadFile = new File(System.getProperty("user.dir") + File.separator + "RenalFunctionAnalysis.properties");
        FileReader r = null;
        try {
            r = new FileReader(loadFile.getPath());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        try {
            char[] input = new char[4096];
            ((Reader)r).read(input, 0, 4096);
            String data = new String(input);
            int index = data.indexOf("\n");
            String temp = data.substring(0, index);
            data = data.substring(index + 1);
            this.ignoreFirst = this.s2i(temp);
            temp = String.valueOf(this.ignoreFirst).toString();
            while (temp.length() < 4) {
                temp = " " + temp;
            }
            this.jTextFieldIgnore.setText(temp);
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            this.minDiffSwitch = this.s2i(temp);
            temp = String.valueOf(this.minDiffSwitch).toString();
            while (temp.length() < 4) {
                temp = " " + temp;
            }
            this.jTextFieldMinDiff.setText(temp);
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            int val = this.s2i(temp);
            this.checkboxMinimumDiff.setSelected(val == 1);
            if (val == 1) {
                this.enableMinDiffField(true);
            } else {
                this.enableMinDiffField(false);
            }
            this.minDiff = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxSecondChance.setSelected(val == 1);
            this.secondChance = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxRasterTransform.setSelected(val == 1);
            this.rasterTransformation = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxNewWindow.setSelected(val == 1);
            this.newWindow = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxVerboseText.setSelected(val == 1);
            this.verboseText = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxShowNull.setSelected(val == 1);
            this.showNullValues = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxInterpolateMissing.setSelected(val == 1);
            this.interpolateMissing = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            if (val == 1) {
                this.jRadioButtonCPULow.setSelected(true);
            }
            if (val == 2) {
                this.jRadioButtonCPUMid.setSelected(true);
            }
            if (val == 3) {
                this.jRadioButtonCPUHigh.setSelected(true);
            }
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.jSliderClassificationRange.setValue(val);
            this.classificationRange = (double)val / 10.0;
            double min = 1.0 - this.classificationRange + 0.01;
            double max = 1.0 + this.classificationRange;
            String text = "Classification Range: ";
            text = text + Double.toString(min).substring(0, 3);
            text = text + " - ";
            text = text + Double.toString(max).substring(0, 3);
            this.jLabelClassificationRange.setText(text);
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.jSliderDefaultAccuracy.setValue(val);
            this.cepstrumAccuracy = (double)val / 10.0;
            text = "-   default Cepstrum accuracy ";
            text = text + this.d2s(this.cepstrumAccuracy, 1);
            text = text + "  +";
            this.jLabelDefaultAccuracy.setText(text);
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxWriteLog.setSelected(val == 1);
            this.writeLog = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxVerboseSIT.setSelected(val == 1);
            this.verboseSIT = val == 1;
            index = data.indexOf("\n");
            temp = data.substring(0, index);
            data = data.substring(index + 1);
            val = this.s2i(temp);
            this.checkboxSplashScreen.setSelected(val == 1);
            this.splashScreen = val == 1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            result = false;
        }
        try {
            ((Reader)r).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            result = false;
        }
        return result;
    }
}

