/*
 * Decompiled with CFR 0.152.
 */
package jm.scaler;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jm.util.GridBagConstraints2;

public class ScaleDialog
extends JDialog
implements ActionListener,
FocusListener,
KeyListener {
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonMinusX = new JButton();
    JButton jButtonMinusY = new JButton();
    JTextField jTextFieldScaleX = new JTextField();
    JTextField jTextFieldScaleY = new JTextField();
    JButton jButtonPlusY = new JButton();
    JButton jButtonPlusX = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonOk = new JButton();
    JLabel jLabelScaleX = new JLabel();
    JLabel jLabelScaleY = new JLabel();
    JCheckBox jCheckBoxNewWindow = new JCheckBox();
    JLabel jLabelPixelY = new JLabel();
    JLabel jLabelPixelX = new JLabel();
    JTextField jTextFieldPixelX = new JTextField();
    JTextField jTextFieldPixelY = new JTextField();
    JCheckBox jCheckBoxProportions = new JCheckBox();
    JButton jButtonPlusPixX = new JButton();
    JButton jButtonMinusPixX = new JButton();
    JButton jButtonMinusPixY = new JButton();
    JButton jButtonPlusPixY = new JButton();
    JLabel jLabelNewSize = new JLabel();
    JLabel jLabelOldSize = new JLabel();
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double oldScaleX = 1.0;
    private double oldScaleY = 1.0;
    public int pixelX = 256;
    public int pixelY = 256;
    private int oldPixelX = 256;
    private int oldPixelY = 256;
    private int orgPixelX = 256;
    private int orgPixelY = 256;
    private double minScaleX = 0.05;
    private double minScaleY = 0.05;
    private double maxScaleX = 1000.0;
    private double maxScaleY = 1000.0;
    private int minPixX = 10;
    private int minPixY = 10;
    private int maxPixX = 10000000;
    private int maxPixY = 10000000;
    private ImageWindow win = null;
    private ImagePlus imp = null;
    private int oldImageSize = 0;
    private int newImageSize = 0;
    private int imageType = 0;
    private String oldImageString = "";
    private String newImageString = "";
    private int maxImageSize = 65535;
    private ImageStack newStack = null;
    public boolean okPressed = false;
    public boolean newwindow = true;

    public ScaleDialog(ImagePlus i) {
        this.imp = i;
        this.pixelX = this.imp.getWidth();
        this.pixelY = this.imp.getHeight();
        this.imageType = this.imp.getType();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.orgPixelX = this.pixelX;
        this.orgPixelY = this.pixelY;
        this.oldImageSize = this.getImageSize();
        this.oldImageString = "   original Image Size: " + this.oldImageSize + "K";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IJ.wait((int)250);
        this.updateTextFields();
        while (this.isVisible()) {
        }
        if (this != null) {
            this.dispose();
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jButtonMinusX.setText("-");
        this.jButtonMinusY.setText("-");
        this.jLabelScaleX.setText("new X-scale:");
        this.jLabelScaleY.setText("new Y-scale:");
        this.jCheckBoxNewWindow.setText("create new window");
        this.jTextFieldScaleX.setText("1000.00");
        this.jTextFieldScaleX.setFont(new Font("Monospaced", 0, 12));
        this.jTextFieldScaleY.setText("1000.00");
        this.jTextFieldScaleY.setFont(new Font("Monospaced", 0, 12));
        this.jLabelPixelY.setText("Pixel Y:");
        this.jLabelPixelX.setText("Pixel X:");
        this.jTextFieldPixelX.setText("1000000");
        this.jTextFieldPixelX.setFont(new Font("Monospaced", 0, 12));
        this.jTextFieldPixelY.setText("1000000");
        this.jTextFieldPixelY.setFont(new Font("Monospaced", 0, 12));
        this.jCheckBoxProportions.setText("preserve proportions");
        this.jButtonPlusPixX.setText("+");
        this.jButtonMinusPixX.setText("-");
        this.jButtonMinusPixY.setText("-");
        this.jButtonPlusPixY.setText("+");
        this.jLabelNewSize.setForeground(SystemColor.windowText);
        this.jLabelOldSize.setForeground(SystemColor.windowText);
        this.jButtonPlusY.setText("+");
        this.jButtonPlusX.setText("+");
        this.jButtonCancel.setText("Cancel");
        this.jButtonOk.setText("Ok");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jButtonMinusX, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonMinusY, new GridBagConstraints2(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldScaleX, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldScaleY, new GridBagConstraints2(3, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonPlusY, new GridBagConstraints2(4, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonPlusX, new GridBagConstraints2(4, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonCancel, new GridBagConstraints2(0, 8, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonOk, new GridBagConstraints2(3, 8, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabelScaleX, new GridBagConstraints2(1, 4, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.jPanel1.add((Component)this.jLabelScaleY, new GridBagConstraints2(2, 5, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.jPanel1.add((Component)this.jCheckBoxNewWindow, new GridBagConstraints2(2, 7, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabelPixelY, new GridBagConstraints2(2, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.jPanel1.add((Component)this.jLabelPixelX, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldPixelX, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldPixelY, new GridBagConstraints2(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jCheckBoxProportions, new GridBagConstraints2(2, 6, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonPlusPixX, new GridBagConstraints2(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonMinusPixX, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonMinusPixY, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonPlusPixY, new GridBagConstraints2(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabelNewSize, new GridBagConstraints2(0, 1, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabelOldSize, new GridBagConstraints2(0, 0, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jButtonMinusPixX.addActionListener(this);
        this.jButtonMinusPixY.addActionListener(this);
        this.jButtonMinusX.addActionListener(this);
        this.jButtonMinusY.addActionListener(this);
        this.jButtonPlusPixX.addActionListener(this);
        this.jButtonPlusPixY.addActionListener(this);
        this.jButtonPlusX.addActionListener(this);
        this.jButtonPlusY.addActionListener(this);
        this.jButtonOk.addActionListener(this);
        this.jButtonCancel.addActionListener(this);
        this.jTextFieldScaleX.addActionListener(this);
        this.jTextFieldScaleY.addActionListener(this);
        this.jTextFieldPixelX.addActionListener(this);
        this.jTextFieldPixelY.addActionListener(this);
        this.jTextFieldScaleX.addFocusListener(this);
        this.jTextFieldScaleY.addFocusListener(this);
        this.jTextFieldPixelX.addFocusListener(this);
        this.jTextFieldPixelY.addFocusListener(this);
        this.jButtonOk.addFocusListener(this);
        this.jButtonOk.addKeyListener(this);
        this.jTextFieldScaleX.setRequestFocusEnabled(true);
        this.jTextFieldScaleY.setRequestFocusEnabled(true);
        this.jTextFieldPixelX.setRequestFocusEnabled(true);
        this.jTextFieldPixelY.setRequestFocusEnabled(true);
        this.jButtonOk.setRequestFocusEnabled(true);
        this.jCheckBoxNewWindow.setSelected(true);
        this.jCheckBoxProportions.setSelected(true);
        this.jTextFieldScaleX.setHorizontalAlignment(4);
        this.jTextFieldScaleY.setHorizontalAlignment(4);
        this.jTextFieldPixelX.setHorizontalAlignment(4);
        this.jTextFieldPixelY.setHorizontalAlignment(4);
        this.setTitle(" Scale Image");
        this.pack();
        GUI.center((Window)this);
        Rectangle rec = this.getBounds();
        rec.width += 10;
        rec.height += 10;
        this.setBounds(rec);
        this.setResizable(false);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
        this.show();
    }

    private int getImageSize() {
        int result = 0;
        if (this.imp == null) {
            return result;
        }
        int size = this.pixelX * this.pixelY * this.imp.getStackSize() / 1024;
        switch (this.imageType) {
            case 0: {
                break;
            }
            case 1: {
                size *= 2;
                break;
            }
            case 2: {
                size *= 4;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                size *= 4;
            }
        }
        if (size == 0) {
            ++size;
        }
        return size;
    }

    private void updateTextFields() {
        try {
            String s = "";
            int pos = 0;
            s = IJ.d2s((double)this.scaleX, (int)2);
            IJ.wait((int)50);
            pos = s.lastIndexOf(",");
            if (pos > 0) {
                s = s.substring(0, pos) + "." + s.substring(pos + 1);
            }
            this.jTextFieldScaleX.setText(s);
            s = IJ.d2s((double)this.scaleY, (int)2);
            IJ.wait((int)50);
            pos = s.lastIndexOf(",");
            if (pos > 0) {
                s = s.substring(0, pos) + "." + s.substring(pos + 1);
            }
            this.jTextFieldScaleY.setText(s);
            this.jTextFieldPixelX.setText(Integer.toString(this.pixelX));
            this.jTextFieldPixelY.setText(Integer.toString(this.pixelY));
            this.jLabelOldSize.setText(this.oldImageString);
            this.newImageString = "   new Image Size:    " + this.getImageSize() + "K";
            this.jLabelNewSize.setText(this.newImageString);
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.write((String)"Fehler in updateTextFields aufgetreten!");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            if (src == this.jButtonMinusX && this.scaleX > this.minScaleX) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.scaleX -= 0.05;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonPlusX && this.scaleX < this.maxScaleX) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.scaleX += 0.05;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonMinusY && this.scaleY > this.minScaleY) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.scaleY -= 0.05;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonPlusY && this.scaleY < this.maxScaleY) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.scaleY += 0.05;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonMinusPixX && this.pixelX > this.minPixX) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.pixelX -= 10;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonPlusPixX && this.pixelX < this.maxPixX) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.pixelX += 10;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonMinusPixY && this.pixelY > this.minPixY) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.pixelY -= 10;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonPlusPixY && this.pixelY < this.maxPixY) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                this.pixelY += 10;
                this.checkAllValues(src);
                this.updateTextFields();
            }
            if (src == this.jButtonCancel) {
                this.setVisible(false);
                this.dispose();
            }
            if (src == this.jButtonOk) {
                this.okPressed = true;
                this.newwindow = this.jCheckBoxNewWindow.isSelected();
                this.setVisible(false);
                this.dispose();
            }
        }
        if (src instanceof JTextField) {
            int pos;
            String input;
            if (src == this.jTextFieldPixelX) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                input = this.jTextFieldPixelX.getText();
                pos = -1;
                try {
                    pos = this.analysePixelInput(input);
                    if (pos > -1) {
                        this.jTextFieldPixelX.setCaretPosition(pos);
                        this.jTextFieldPixelX.setSelectionStart(pos);
                        this.jTextFieldPixelX.setSelectionEnd(pos + 1);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pos == -1) {
                    this.pixelX = Integer.valueOf(input);
                    if (this.pixelX > this.maxPixX) {
                        this.pixelX = this.maxPixX;
                    }
                    if (this.pixelX < this.minPixX) {
                        this.pixelX = this.minPixX;
                    }
                    this.checkAllValues(src);
                    this.updateTextFields();
                    this.jTextFieldPixelY.requestFocus();
                }
            }
            if (src == this.jTextFieldPixelY) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                input = this.jTextFieldPixelY.getText();
                pos = -1;
                try {
                    pos = this.analysePixelInput(input);
                    if (pos > -1) {
                        this.jTextFieldPixelY.setCaretPosition(pos);
                        this.jTextFieldPixelY.setSelectionStart(pos);
                        this.jTextFieldPixelY.setSelectionEnd(pos + 1);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pos == -1) {
                    this.pixelY = Integer.valueOf(input);
                    if (this.pixelY > this.maxPixY) {
                        this.pixelY = this.maxPixY;
                    }
                    if (this.pixelY < this.minPixY) {
                        this.pixelY = this.minPixY;
                    }
                    this.checkAllValues(src);
                    this.updateTextFields();
                    this.jButtonOk.requestFocus();
                }
            }
            if (src == this.jTextFieldScaleX) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                input = this.jTextFieldScaleX.getText();
                pos = -1;
                try {
                    pos = this.analyseScaleInput(input);
                    if (pos > -1) {
                        this.jTextFieldScaleX.setCaretPosition(pos);
                        this.jTextFieldScaleX.setSelectionStart(pos);
                        this.jTextFieldScaleX.setSelectionEnd(pos + 1);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pos == -1) {
                    this.scaleX = Double.valueOf(input);
                    if (this.scaleX > this.maxScaleX) {
                        this.scaleX = this.maxScaleX;
                    }
                    if (this.scaleX < this.minScaleX) {
                        this.scaleX = this.minScaleX;
                    }
                    this.checkAllValues(src);
                    this.updateTextFields();
                    this.jTextFieldScaleY.requestFocus();
                }
            }
            if (src == this.jTextFieldScaleY) {
                this.oldScaleX = this.scaleX;
                this.oldScaleY = this.scaleY;
                this.oldPixelX = this.pixelX;
                this.oldPixelY = this.pixelY;
                input = this.jTextFieldScaleY.getText();
                pos = -1;
                try {
                    pos = this.analyseScaleInput(input);
                    if (pos > -1) {
                        this.jTextFieldScaleY.setCaretPosition(pos);
                        this.jTextFieldScaleY.setSelectionStart(pos);
                        this.jTextFieldScaleY.setSelectionEnd(pos + 1);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pos == -1) {
                    this.scaleY = Double.valueOf(input);
                    if (this.scaleY > this.maxScaleY) {
                        this.scaleY = this.maxScaleY;
                    }
                    if (this.scaleY < this.minScaleY) {
                        this.scaleY = this.minScaleY;
                    }
                    this.checkAllValues(src);
                    this.updateTextFields();
                    this.jButtonOk.requestFocus();
                }
            }
        }
    }

    public void focusLost(FocusEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JTextField) {
            ActionEvent actionEvent = new ActionEvent(src, evt.getID(), evt.paramString());
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    private int analysePixelInput(String input) {
        int result = -1;
        int i = 0;
        while (i <= input.length()) {
            if (!Character.isDigit(input.charAt(i))) {
                result = i;
                i = input.length() + 1;
            }
            ++i;
        }
        return result;
    }

    private int analyseScaleInput(String input) {
        int result = -1;
        boolean hasKomma = false;
        int i = 0;
        while (i <= input.length()) {
            if (!Character.isDigit(input.charAt(i))) {
                if (input.charAt(i) == '.') {
                    if (hasKomma) {
                        result = i;
                        i = input.length() + 1;
                    } else {
                        hasKomma = true;
                    }
                } else {
                    result = i;
                    i = input.length() + 1;
                }
            }
            ++i;
        }
        return result;
    }

    private void checkAllValues(Object src) {
        if (src == this.jTextFieldPixelX || src == this.jButtonMinusPixX || src == this.jButtonPlusPixX) {
            if (this.jCheckBoxProportions.isSelected()) {
                this.pixelY = this.oldPixelY * this.pixelX / this.oldPixelX;
                this.scaleX = (double)this.pixelX / (double)this.orgPixelX;
                this.scaleY = (double)this.pixelY / (double)this.orgPixelY;
            } else {
                this.scaleX = (double)this.pixelX / (double)this.orgPixelX;
            }
            if (this.pixelX == 0 || this.pixelY == 0 || this.getImageSize() > this.maxImageSize) {
                this.pixelX = this.oldPixelX;
                this.pixelY = this.oldPixelY;
                this.scaleX = this.oldScaleX;
                this.scaleY = this.oldScaleY;
            }
        }
        if (src == this.jTextFieldPixelY || src == this.jButtonMinusPixY || src == this.jButtonPlusPixY) {
            if (this.jCheckBoxProportions.isSelected()) {
                this.pixelX = this.oldPixelX * this.pixelY / this.oldPixelY;
                this.scaleY = (double)this.pixelY / (double)this.orgPixelY;
                this.scaleX = (double)this.pixelX / (double)this.orgPixelX;
            } else {
                this.scaleY = (double)this.pixelY / (double)this.orgPixelY;
            }
            if (this.pixelX == 0 || this.pixelY == 0 || this.getImageSize() > this.maxImageSize) {
                this.pixelX = this.oldPixelX;
                this.pixelY = this.oldPixelY;
                this.scaleX = this.oldScaleX;
                this.scaleY = this.oldScaleY;
            }
        }
        if (src == this.jTextFieldScaleX || src == this.jButtonMinusX || src == this.jButtonPlusX) {
            if (this.jCheckBoxProportions.isSelected()) {
                this.scaleY = this.oldScaleY * this.scaleX / this.oldScaleX;
                this.pixelX = (int)((double)this.orgPixelX * this.scaleX);
                this.pixelY = (int)((double)this.orgPixelY * this.scaleY);
            } else {
                this.pixelX = (int)((double)this.orgPixelX * this.scaleX);
            }
            if (this.pixelX == 0 || this.pixelY == 0 || this.getImageSize() > this.maxImageSize) {
                this.pixelX = this.oldPixelX;
                this.pixelY = this.oldPixelY;
                this.scaleX = this.oldScaleX;
                this.scaleY = this.oldScaleY;
            }
        }
        if (src == this.jTextFieldScaleY || src == this.jButtonMinusY || src == this.jButtonPlusY) {
            if (this.jCheckBoxProportions.isSelected()) {
                this.scaleX = this.oldScaleX * this.scaleY / this.oldScaleY;
                this.pixelY = (int)((double)this.orgPixelY * this.scaleY);
                this.pixelX = (int)((double)this.orgPixelX * this.scaleX);
            } else {
                this.pixelY = (int)((double)this.orgPixelY * this.scaleY);
            }
            if (this.pixelX == 0 || this.pixelY == 0 || this.getImageSize() > this.maxImageSize) {
                this.pixelX = this.oldPixelX;
                this.pixelY = this.oldPixelY;
                this.scaleX = this.oldScaleX;
                this.scaleY = this.oldScaleY;
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        Object src = evt.getSource();
        if (src == this.jButtonOk) {
            IJ.write((String)"Holla return");
            ActionEvent dummy = new ActionEvent(src, evt.getID(), evt.paramString());
            this.actionPerformed(dummy);
        }
    }

    public void keyTyped(KeyEvent evt) {
    }
}

