/*
 * Decompiled with CFR 0.152.
 */
package jm.segmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jm.segmentation.DoubleLine;

public class KidneyExtraction {
    private ImagePlus curImage;
    private final double fDegreeStep = 4.0;
    private Point ptStart;
    private PolygonRoi roi;
    private boolean bSetRoi = true;
    private boolean bMaskArea = false;
    private ShortProcessor vertikalKernel = null;
    private ShortProcessor diagonalKernel = null;
    private ShortProcessor sobelKernel = null;
    private ShortProcessor aktSobelIp = null;
    private ShortProcessor aktIp = null;
    private short[] aktPixel = null;
    private int lastDeg;
    private double lastLength;
    private int[] xpoints = null;
    private int[] ypoints = null;
    private int numPoints = 0;
    private double[] ptDistances = null;
    private double[] ptAngles = null;
    private double[] ptLengths = null;
    private double midDistance = 0.0;
    private double midAngle = 0.0;
    private double midLength = 0.0;

    public KidneyExtraction(ImagePlus imp) {
        this.curImage = imp;
    }

    private void calcAllAngles() {
        this.midAngle = 0.0;
        this.ptAngles = new double[this.numPoints];
        int iPoint = 0;
        while (iPoint < this.numPoints) {
            int prevIndex = iPoint - 1;
            if (prevIndex < 0) {
                prevIndex = this.numPoints - 1;
            }
            int nextIndex = (iPoint + 1) % this.numPoints;
            double g = this.calcAngle(this.xpoints[prevIndex], this.ypoints[prevIndex], this.xpoints[iPoint], this.ypoints[iPoint], this.xpoints[nextIndex], this.ypoints[nextIndex]);
            if (this.ptLengths[prevIndex] >= this.ptLengths[iPoint] && this.ptLengths[nextIndex] >= this.ptLengths[iPoint]) {
                g = 360.0 - g;
            }
            this.midAngle += g;
            this.ptAngles[iPoint] = g;
            ++iPoint;
        }
        this.midAngle /= (double)this.numPoints;
    }

    private void calcAllLengths() {
        this.midLength = 0.0;
        this.ptLengths = new double[this.numPoints];
        int iPoint = 0;
        while (iPoint < this.numPoints) {
            double d = this.calcDistance(this.xpoints[iPoint], this.ypoints[iPoint], this.ptStart.x, this.ptStart.y);
            this.midLength += d;
            this.ptLengths[iPoint] = d;
            ++iPoint;
        }
        this.midLength /= (double)this.numPoints;
        IJ.write((String)("mittlere Laenge: " + this.midLength));
    }

    private void calcAllDistances() {
        this.midDistance = 0.0;
        this.ptDistances = new double[this.numPoints];
        int iPoint = 0;
        while (iPoint < this.numPoints) {
            int prevIndex = iPoint - 1;
            if (prevIndex < 0) {
                prevIndex = this.numPoints + prevIndex;
            }
            double d = this.calcDistance(this.xpoints[iPoint], this.ypoints[iPoint], this.xpoints[prevIndex], this.ypoints[prevIndex]);
            this.midDistance += d;
            this.ptDistances[iPoint] = d;
            ++iPoint;
        }
        this.midDistance /= (double)this.numPoints;
        IJ.write((String)("mittlere Distanz: " + this.midDistance));
    }

    private double degToRad(float f) {
        return (double)f * Math.PI / 180.0;
    }

    private double radToDeg(double f) {
        return f * 180.0 / Math.PI;
    }

    private double calcDistance(int pointX1, int pointY1, int pointX2, int pointY2) {
        return Math.sqrt((double)((pointX1 - pointX2) * (pointX1 - pointX2)) + (double)((pointY1 - pointY2) * (pointY1 - pointY2)));
    }

    private double calcAngle(int pointX1, int pointY1, int pointX2, int pointY2, int pointX3, int pointY3) {
        double c = this.calcDistance(pointX1, pointY1, pointX3, pointY3);
        double a = this.calcDistance(pointX1, pointY1, pointX2, pointY2);
        double b = this.calcDistance(pointX2, pointY2, pointX3, pointY3);
        double g = 180.0;
        if (a != 0.0 && b != 0.0) {
            double cosg = (a * a + b * b - c * c) / (2.0 * a * b);
            g = this.radToDeg(Math.acos(cosg));
        }
        return g;
    }

    private ImageProcessor medianFilter(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        ShortProcessor result = null;
        short[] median = new short[width * height];
        short[] pix = (short[])ip.getPixels();
        int[] p = new int[10];
        int tmp = 0;
        int y = 1;
        while (y < height - 1) {
            int x = 1;
            while (x < width - 1) {
                if (x == 1) {
                    p[1] = pix[(y - 1) * width + (x - 1)];
                    p[2] = pix[(y - 1) * width + x];
                    p[3] = pix[(y - 1) * width + (x + 1)];
                    p[4] = pix[y * width + (x - 1)];
                    p[5] = pix[y * width + x];
                    p[6] = pix[y * width + (x + 1)];
                    p[7] = pix[y * width + (x - 1)];
                    p[8] = pix[(y + 1) * width + x];
                    p[9] = pix[(y + 1) * width + (x + 1)];
                } else {
                    p[1] = p[2];
                    p[2] = p[3];
                    p[3] = pix[(y - 1) * width + (x + 1)];
                    p[4] = p[5];
                    p[5] = p[6];
                    p[6] = pix[y * width + (x + 1)];
                    p[7] = p[8];
                    p[8] = p[9];
                    p[9] = pix[(y + 1) * width + (x + 1)];
                }
                int i = 1;
                while (i < 9) {
                    if (p[i] > p[i + 1]) {
                        tmp = p[i];
                        p[i] = p[i + 1];
                        p[i + 1] = tmp;
                    }
                    ++i;
                }
                median[y * width + x] = (short)p[4];
                ++x;
            }
            ++y;
        }
        result = new ShortProcessor(width, height, median, ip.getColorModel(), false);
        return result;
    }

    public void doSegmentation(ImageProcessor ip) {
        try {
            Polygon poly_org;
            double maxSteig;
            int width = ip.getWidth();
            int height = ip.getHeight();
            this.aktIp = (ShortProcessor)this.medianFilter(ip);
            this.aktPixel = (short[])this.aktIp.getPixels();
            this.initKernels();
            Roi roi = this.curImage.getRoi();
            Rectangle rr = roi.getBoundingRect();
            this.ptStart = new Point();
            this.ptStart.x = rr.x + rr.width / 2;
            this.ptStart.y = rr.y + rr.height / 2;
            double startDegree = 0.0;
            if (this.ptStart.x < width / 2) {
                startDegree = 180.0;
            }
            if ((maxSteig = (double)(rr.y - this.ptStart.y) / (double)(rr.x + rr.width - this.ptStart.x)) < 0.0) {
                maxSteig *= -1.0;
            }
            this.numPoints = 90;
            this.xpoints = new int[this.numPoints];
            this.ypoints = new int[this.numPoints];
            double[] degreeValues = new double[this.numPoints];
            int iPoint = 0;
            float fDegree = (float)startDegree;
            while (iPoint < this.numPoints) {
                double rad = this.degToRad(fDegree);
                double si = Math.sin(rad);
                double cs = Math.cos(rad);
                double len = Math.max(rr.height, rr.width) / 2;
                int xd = (int)(len * cs);
                int yd = (int)(len * si);
                Point ptEnd = new Point(this.ptStart.x + xd, this.ptStart.y + yd);
                double[] line1 = this.aktIp.getLine((double)this.ptStart.x, (double)this.ptStart.y, (double)ptEnd.x, (double)ptEnd.y);
                ShortProcessor sIp = this.getRotateSobel(fDegree);
                double[] line2 = sIp.getLine((double)this.ptStart.x, (double)this.ptStart.y, (double)ptEnd.x, (double)ptEnd.y);
                DoubleLine sl = new DoubleLine(line1, line2);
                sl.smoothLines(3);
                int endll = rr.height / 2;
                int d = ptEnd.x - this.ptStart.x;
                double steigung = d != 0 ? (double)(ptEnd.y - this.ptStart.y) / (double)d : Double.MAX_VALUE;
                if (steigung >= -1.0 && steigung <= 1.0) {
                    endll = rr.width / 2;
                }
                int startll = 3 * (endll / 5);
                int ll = sl.findBestPoint(startll, endll);
                int xd2 = (int)((double)ll * cs);
                int yd2 = (int)((double)ll * si);
                this.xpoints[iPoint] = this.ptStart.x + xd2;
                this.ypoints[iPoint] = this.ptStart.y + yd2;
                degreeValues[iPoint] = fDegree;
                if ((double)(fDegree = (float)((double)fDegree + 4.0)) >= 360.0) {
                    fDegree %= 360.0f;
                }
                ++iPoint;
            }
            int grosseSchleife = 1;
            while (grosseSchleife <= 1) {
                int i;
                Polygon poly = new Polygon(this.xpoints, this.ypoints, this.numPoints);
                roi = new PolygonRoi(poly.xpoints, poly.ypoints, poly.npoints, this.curImage, 2);
                this.curImage.setRoi(roi);
                this.curImage.updateAndRepaintWindow();
                this.calcAllDistances();
                this.calcAllLengths();
                this.calcAllAngles();
                int index = 0;
                while (index < this.numPoints) {
                    int prevIndex = index - 1;
                    if (prevIndex < 0) {
                        prevIndex = this.numPoints + prevIndex;
                    }
                    int nextIndex = (index + 1) % this.numPoints;
                    double maxPercentDev = 20.0;
                    double diffPercentPrev = Math.abs(this.ptLengths[prevIndex] - this.ptLengths[index]) * 100.0 / this.ptLengths[prevIndex];
                    double diffPercentNext = Math.abs(this.ptLengths[nextIndex] - this.ptLengths[index]) * 100.0 / this.ptLengths[nextIndex];
                    if (Math.abs(this.ptAngles[index] - 180.0) > 130.0 && (diffPercentPrev > maxPercentDev || diffPercentNext > maxPercentDev)) {
                        int p1 = ip.getPixel(this.xpoints[index], this.ypoints[index]);
                        ip.putPixel(this.xpoints[index], this.ypoints[index], 255);
                        this.curImage.updateAndRepaintWindow();
                        ip.putPixel(this.xpoints[index], this.ypoints[index], p1);
                        double d = this.calcDistance(this.xpoints[prevIndex], this.ypoints[prevIndex], this.xpoints[nextIndex], this.ypoints[nextIndex]);
                        i = 0;
                        double xvecC = this.xpoints[nextIndex] - this.xpoints[prevIndex];
                        double yvecC = this.ypoints[nextIndex] - this.ypoints[prevIndex];
                        double partofd = d / 2.0;
                        int newposx = this.xpoints[prevIndex] + (int)(partofd / d * xvecC);
                        int newposy = this.ypoints[prevIndex] + (int)(partofd / d * yvecC);
                        this.xpoints[index] = newposx;
                        this.ypoints[index] = newposy;
                    }
                    ++index;
                }
                IJ.write((String)"Suche laengste Strecke...");
                int pos = 0;
                int[] bestStart = new int[this.numPoints];
                int[] bestEnd = new int[this.numPoints];
                iPoint = 1;
                while (iPoint < this.numPoints) {
                    bestStart[pos] = iPoint - 1;
                    bestEnd[pos] = iPoint - 1;
                    double d = this.ptDistances[iPoint];
                    int counter = 0;
                    while (d <= this.midDistance && counter < this.numPoints) {
                        bestEnd[pos] = (iPoint + counter) % this.numPoints;
                        int arrayPos = (iPoint + ++counter) % this.numPoints;
                        d = this.ptDistances[arrayPos];
                    }
                    iPoint += counter;
                    ++pos;
                    ++iPoint;
                }
                IJ.write((String)"Suche besten Positionen...");
                int maxLength = 0;
                int bestPosStart = 0;
                int bestPosEnd = 0;
                i = 0;
                while (i < pos) {
                    int alen = bestStart[i] <= bestEnd[i] ? bestEnd[i] - bestStart[i] : bestEnd[i] + this.numPoints - bestStart[i];
                    if (alen > maxLength) {
                        maxLength = alen;
                        bestPosStart = bestStart[i];
                        bestPosEnd = bestEnd[i];
                    }
                    ++i;
                }
                if (maxLength < 5) {
                    IJ.error((String)"Segmentation of the kidneys was not succesful.\nPlease select the ROI manually !!!");
                }
                IJ.write((String)("Start/End/numPoints: " + bestPosStart + "/" + bestPosEnd + "/" + this.numPoints));
                iPoint = bestPosStart;
                pos = 0;
                while (pos <= maxLength) {
                    iPoint = (iPoint + 1) % this.numPoints;
                    ++pos;
                }
                boolean[] ptBad = new boolean[this.numPoints];
                i = 0;
                while (i < this.numPoints) {
                    ptBad[i] = false;
                    ++i;
                }
                iPoint = bestPosEnd;
                startDegree = degreeValues[bestPosEnd];
                fDegree = (float)startDegree;
                int endPos = bestPosStart - 1;
                if (endPos < 0) {
                    endPos = this.numPoints - endPos;
                }
                while (iPoint != endPos) {
                    int prev3;
                    int prev2;
                    poly = new Polygon(this.xpoints, this.ypoints, this.numPoints);
                    roi = new PolygonRoi(poly.xpoints, poly.ypoints, poly.npoints, this.curImage, 2);
                    this.curImage.setRoi(roi);
                    this.curImage.updateAndRepaintWindow();
                    double midLenLast5 = 0.0;
                    double midWinkelLast5 = 0.0;
                    pos = 0;
                    while (pos < 5) {
                        int arrayPos = iPoint - pos;
                        if (arrayPos < 0) {
                            arrayPos = this.numPoints + arrayPos;
                        }
                        midLenLast5 += this.ptLengths[arrayPos];
                        midWinkelLast5 += this.ptAngles[arrayPos];
                        ++pos;
                    }
                    midLenLast5 /= 5.0;
                    midWinkelLast5 /= 5.0;
                    iPoint = (iPoint + 1) % this.numPoints;
                    fDegree = (float)degreeValues[iPoint];
                    double rad = this.degToRad(fDegree);
                    double si = Math.sin(rad);
                    double cs = Math.cos(rad);
                    double len = Math.max(rr.height, rr.width) / 2;
                    int xd = (int)(len * cs);
                    int yd = (int)(len * si);
                    Point ptEnd = new Point(this.ptStart.x + xd, this.ptStart.y + yd);
                    boolean xgood = false;
                    boolean ygood = false;
                    double factor = 1.4;
                    double maxAngleDev = 45.0;
                    double maxLengthPercentDev = 25.0;
                    int ptBadStart = 0;
                    int ptBadAnz = 0;
                    double d = this.calcDistance(this.xpoints[iPoint], this.ypoints[iPoint], this.ptStart.x, this.ptStart.y);
                    double percentDev = Math.abs(midLenLast5 - d) * 100.0 / midLenLast5;
                    int prev = iPoint - 1;
                    if (prev < 0) {
                        prev = this.numPoints + prev;
                    }
                    if ((prev2 = iPoint - 2) < 0) {
                        prev = this.numPoints + prev2;
                    }
                    if ((prev3 = iPoint - 3) < 0) {
                        prev = this.numPoints + prev3;
                    }
                    double prevw = this.calcAngle(this.xpoints[prev3], this.ypoints[prev3], this.xpoints[prev2], this.ypoints[prev2], this.xpoints[prev], this.ypoints[prev]);
                    if (this.ptLengths[prev3] >= this.ptLengths[prev2] && this.ptLengths[prev] >= this.ptLengths[prev2]) {
                        prevw = 360.0 - prevw;
                    }
                    double w = this.calcAngle(this.xpoints[iPoint], this.ypoints[iPoint], this.xpoints[prev], this.ypoints[prev], this.xpoints[prev2], this.ypoints[prev2]);
                    if (this.ptLengths[iPoint] >= this.ptLengths[prev] && this.ptLengths[prev2] >= this.ptLengths[prev]) {
                        int p1 = ip.getPixel(this.xpoints[iPoint], this.ypoints[iPoint]);
                        ip.putPixel(this.xpoints[iPoint], this.ypoints[iPoint], 255);
                        int p2 = ip.getPixel(this.xpoints[prev], this.ypoints[prev]);
                        ip.putPixel(this.xpoints[prev], this.ypoints[prev], 255);
                        int p3 = ip.getPixel(this.xpoints[prev2], this.ypoints[prev2]);
                        ip.putPixel(this.xpoints[prev2], this.ypoints[prev2], 255);
                        int p4 = ip.getPixel(this.ptStart.x, this.ptStart.y);
                        ip.putPixel(this.ptStart.x, this.ptStart.y, 255);
                        this.curImage.updateAndRepaintWindow();
                        ip.putPixel(this.xpoints[iPoint], this.ypoints[iPoint], p1);
                        ip.putPixel(this.xpoints[prev], this.ypoints[prev], p2);
                        ip.putPixel(this.xpoints[prev2], this.ypoints[prev2], p3);
                        ip.putPixel(this.ptStart.x, this.ptStart.y, p4);
                        this.curImage.updateAndRepaintWindow();
                        w = 360.0 - w;
                    }
                    double wDev = Math.abs(midWinkelLast5 - (w += (midWinkelLast5 - prevw) / 2.0));
                    if (this.ptDistances[iPoint] > this.midDistance * factor && wDev > maxAngleDev || percentDev > maxLengthPercentDev) {
                        IJ.write((String)("__________________\n  Nummer der ersten ptBad: " + iPoint));
                        IJ.write((String)("Winkel neu: " + w + "\n  Winkel Deviation: " + wDev + "\n  Mittlerer Winkel Last5: " + midWinkelLast5));
                        IJ.write((String)("Winkel alt: " + (w - (midWinkelLast5 - prevw) / 2.0) + "\n  Laenge Last5:" + midLenLast5 + "\n  Prozent Laegenabweichung: " + percentDev + "\n  Voriger Winkel: " + prevw));
                        IJ.write((String)("Mittlere Distanz: " + this.midDistance + "\n  midDistance * factor: " + this.midDistance * factor));
                        ptBadStart = iPoint;
                        ++ptBadAnz;
                        ptBad[iPoint] = true;
                        this.curImage.updateAndRepaintWindow();
                        iPoint = (iPoint + 1) % this.numPoints;
                        d = this.calcDistance(this.xpoints[iPoint], this.ypoints[iPoint], this.ptStart.x, this.ptStart.y);
                        percentDev = Math.abs(midLenLast5 - d) * 100.0 / midLenLast5;
                        w = this.calcAngle(this.xpoints[iPoint], this.ypoints[iPoint], this.xpoints[prev], this.ypoints[prev], this.xpoints[prev2], this.ypoints[prev2]);
                        if (this.ptLengths[iPoint] >= this.ptLengths[prev] && this.ptLengths[prev2] >= this.ptLengths[prev]) {
                            w = 360.0 - w;
                        }
                        wDev = Math.abs(midWinkelLast5 - (w += (midWinkelLast5 - prevw) / 2.0));
                        while (this.ptDistances[iPoint] <= this.midDistance * factor && wDev > maxAngleDev && iPoint != endPos && percentDev > maxLengthPercentDev) {
                            IJ.write((String)("(o)w: " + w + " wDev: " + wDev + " mw5: " + midWinkelLast5));
                            IJ.write((String)("(n)w:" + (w - (midWinkelLast5 - prevw) / 2.0) + " %d: " + percentDev + " pw: " + prevw));
                            ++ptBadAnz;
                            ptBad[iPoint] = true;
                            iPoint = (iPoint + 1) % this.numPoints;
                            d = this.calcDistance(this.xpoints[iPoint], this.ypoints[iPoint], this.ptStart.x, this.ptStart.y);
                            percentDev = Math.abs(midLenLast5 - d) * 100.0 / midLenLast5;
                            w = this.calcAngle(this.xpoints[iPoint], this.ypoints[iPoint], this.xpoints[prev], this.ypoints[prev], this.xpoints[prev2], this.ypoints[prev2]);
                            if (this.ptLengths[iPoint] >= this.ptLengths[prev] || this.ptLengths[prev] >= this.ptLengths[prev2]) {
                                w = 360.0 - w;
                            }
                            wDev = Math.abs(midWinkelLast5 - (w += (midWinkelLast5 - prevw) / 2.0));
                        }
                    }
                    if (ptBadAnz <= 0) continue;
                    int startPos = ptBadStart - 1;
                    if (startPos < 0) {
                        startPos = this.numPoints - startPos;
                    }
                    d = this.calcDistance(this.xpoints[startPos], this.ypoints[startPos], this.xpoints[iPoint], this.ypoints[iPoint]);
                    i = 0;
                    while (i < ptBadAnz) {
                        int prevprevIndex;
                        pos = (ptBadStart + i) % this.numPoints;
                        double xvecC = this.xpoints[iPoint] - this.xpoints[startPos];
                        double yvecC = this.ypoints[iPoint] - this.ypoints[startPos];
                        double partofd = (double)(i + 1) * d / (double)(ptBadAnz + 1);
                        int newposx = this.xpoints[startPos] + (int)(partofd / d * xvecC);
                        int newposy = this.ypoints[startPos] + (int)(partofd / d * yvecC);
                        this.xpoints[pos] = newposx;
                        this.ypoints[pos] = newposy;
                        this.ptLengths[pos] = this.calcDistance(this.xpoints[pos], this.ypoints[pos], this.ptStart.x, this.ptStart.y);
                        prev = pos - 1;
                        if (prev < 0) {
                            prev = this.numPoints + prev;
                        }
                        this.ptDistances[pos] = this.calcDistance(this.xpoints[prev], this.ypoints[prev], this.xpoints[pos], this.ypoints[pos]);
                        int prevIndex = pos - 1;
                        if (prevIndex < 0) {
                            prevIndex = this.numPoints + prevIndex;
                        }
                        if ((prevprevIndex = pos - 2) < 0) {
                            prevprevIndex = this.numPoints + prevprevIndex;
                        }
                        int nextIndex = (pos + 1) % this.numPoints;
                        int nextnextIndex = (pos + 2) % this.numPoints;
                        double g = this.calcAngle(this.xpoints[prevprevIndex], this.ypoints[prevprevIndex], this.xpoints[prevIndex], this.ypoints[prevIndex], this.xpoints[pos], this.ypoints[pos]);
                        if (this.ptLengths[prevprevIndex] >= this.ptLengths[prevIndex] || this.ptLengths[prevIndex] >= this.ptLengths[pos]) {
                            g = 360.0 - g;
                        }
                        this.ptAngles[prevIndex] = g;
                        g = this.calcAngle(this.xpoints[prevIndex], this.ypoints[prevIndex], this.xpoints[pos], this.ypoints[pos], this.xpoints[nextIndex], this.ypoints[nextIndex]);
                        if (this.ptLengths[prevIndex] >= this.ptLengths[pos] || this.ptLengths[pos] >= this.ptLengths[nextIndex]) {
                            g = 360.0 - g;
                        }
                        this.ptAngles[pos] = g;
                        g = this.calcAngle(this.xpoints[pos], this.ypoints[pos], this.xpoints[nextIndex], this.ypoints[nextIndex], this.xpoints[nextnextIndex], this.ypoints[nextnextIndex]);
                        if (this.ptLengths[pos] >= this.ptLengths[nextIndex] || this.ptLengths[nextIndex] >= this.ptLengths[nextnextIndex]) {
                            g = 360.0 - g;
                        }
                        this.ptAngles[nextIndex] = g;
                        poly = new Polygon(this.xpoints, this.ypoints, this.numPoints);
                        roi = new PolygonRoi(poly.xpoints, poly.ypoints, poly.npoints, this.curImage, 2);
                        this.curImage.setRoi(roi);
                        this.curImage.updateAndRepaintWindow();
                        ++i;
                    }
                }
                ++grosseSchleife;
            }
            Polygon poly = poly_org = new Polygon(this.xpoints, this.ypoints, this.numPoints);
            if (this.bSetRoi) {
                roi = new PolygonRoi(poly.xpoints, poly.ypoints, poly.npoints, this.curImage, 2);
                this.curImage.setRoi(roi);
                this.curImage.draw();
            }
        }
        catch (Exception ex0) {
            ex0.printStackTrace(System.out);
        }
    }

    private Polygon smoothPolygon(Polygon p) {
        int i = 1;
        int n = p.npoints;
        int r = 1;
        int[] xp = new int[n];
        int[] yp = new int[n];
        xp[0] = p.xpoints[0];
        yp[0] = p.ypoints[0];
        while (i < n - 1) {
            int x1 = p.xpoints[i - 1];
            int y1 = p.ypoints[i - 1];
            int x2 = p.xpoints[i];
            int y2 = p.ypoints[i];
            int x3 = p.xpoints[i + 1];
            int y3 = p.ypoints[i + 1];
            int x2a = (x1 + x3) / 2;
            int y2a = (y1 + y3) / 2;
            int x2b = (x2 + x2a) / 2;
            int y2b = (y2 + y2a) / 2;
            xp[r] = x2b;
            yp[r] = y2b;
            ++r;
            ++i;
        }
        xp[n - 1] = p.xpoints[n - 1];
        yp[n - 1] = p.ypoints[n - 1];
        return new Polygon(xp, yp, ++r);
    }

    private Polygon reducePolygon(Polygon p) {
        int i = 1;
        int n = p.npoints;
        int r = 1;
        int[] xp = new int[n];
        int[] yp = new int[n];
        xp[0] = p.xpoints[0];
        yp[0] = p.ypoints[0];
        int x1 = p.xpoints[i - 1];
        int y1 = p.ypoints[i - 1];
        while (i < n - 1) {
            int x2 = p.xpoints[i];
            int y2 = p.ypoints[i];
            int x3 = p.xpoints[i + 1];
            int y3 = p.ypoints[i + 1];
            double a = 0.5 * (double)(x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
            boolean bDiscard = false;
            if (Math.abs(a) < 6.0) {
                bDiscard = true;
            }
            if (bDiscard) {
                ++i;
                continue;
            }
            xp[r] = x2;
            yp[r] = y2;
            ++r;
            ++i;
            x1 = x2;
            y1 = y2;
        }
        return new Polygon(xp, yp, r);
    }

    private void initKernels() {
        int y;
        this.vertikalKernel = new ShortProcessor(5, 5, false);
        this.diagonalKernel = new ShortProcessor(5, 5, false);
        int x = 0;
        while (x < 5) {
            y = 0;
            while (y < 5) {
                this.diagonalKernel.putPixel(x, y, 0);
                this.vertikalKernel.putPixel(x, y, 0);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 2) {
            y = 0;
            while (y < 5) {
                this.vertikalKernel.putPixel(x, y, 1);
                ++y;
            }
            ++x;
        }
        this.vertikalKernel.putPixel(1, 2, 2);
        x = 3;
        while (x < 5) {
            y = 0;
            while (y < 5) {
                this.vertikalKernel.putPixel(x, y, -1);
                ++y;
            }
            ++x;
        }
        this.vertikalKernel.putPixel(3, 2, -2);
        y = 0;
        x = 0;
        while (x < 4) {
            this.diagonalKernel.putPixel(x, y, 1);
            ++x;
        }
        y = 1;
        x = 0;
        while (x < 3) {
            this.diagonalKernel.putPixel(x, y, 1);
            ++x;
        }
        this.diagonalKernel.putPixel(0, 2, 1);
        this.diagonalKernel.putPixel(1, 2, 1);
        this.diagonalKernel.putPixel(0, 3, 1);
        y = 4;
        x = 1;
        while (x < 5) {
            this.diagonalKernel.putPixel(x, y, -1);
            ++x;
        }
        y = 3;
        x = 2;
        while (x < 5) {
            this.diagonalKernel.putPixel(x, y, -1);
            ++x;
        }
        this.diagonalKernel.putPixel(4, 2, -1);
        this.diagonalKernel.putPixel(3, 2, -1);
        this.diagonalKernel.putPixel(4, 1, -1);
    }

    private ShortProcessor getRotateSobel(double degrees) {
        int deg = (int)(degrees + 22.5) % 360;
        if (deg >= 0 && deg < 45) {
            if (this.sobelKernel != null && this.lastDeg >= 0 && this.lastDeg < 45) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = new ShortProcessor(5, 5, false);
            int nx = 4;
            int x = 0;
            while (x < 5) {
                int y = 0;
                while (y < 5) {
                    this.sobelKernel.putPixel(nx, y, this.vertikalKernel.getPixel(x, y));
                    ++y;
                }
                --nx;
                ++x;
            }
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 45 && deg < 90) {
            if (this.sobelKernel != null && this.lastDeg >= 45 && this.lastDeg < 90) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = new ShortProcessor(5, 5, false);
            int nx = 4;
            int x = 0;
            while (x < 5) {
                int ny = 4;
                int y = 0;
                while (y < 5) {
                    this.sobelKernel.putPixel(nx, ny, this.diagonalKernel.getPixel(x, y));
                    --ny;
                    ++y;
                }
                --nx;
                ++x;
            }
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 90 && deg < 135) {
            if (this.sobelKernel != null && this.lastDeg >= 90 && this.lastDeg < 135) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = new ShortProcessor(5, 5, false);
            int nx = 4;
            int x = 0;
            while (x < 5) {
                int ny = 0;
                int y = 0;
                while (y < 5) {
                    this.sobelKernel.putPixel(ny, nx, this.vertikalKernel.getPixel(x, y));
                    ++ny;
                    ++y;
                }
                --nx;
                ++x;
            }
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 135 && deg < 180) {
            if (this.sobelKernel != null && this.lastDeg >= 135 && this.lastDeg < 180) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = new ShortProcessor(5, 5, false);
            int nx = 4;
            int x = 0;
            while (x < 5) {
                int ny = 0;
                int y = 0;
                while (y < 5) {
                    this.sobelKernel.putPixel(ny, nx, this.diagonalKernel.getPixel(x, y));
                    ++ny;
                    ++y;
                }
                --nx;
                ++x;
            }
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 180 && deg < 225) {
            if (this.sobelKernel != null && this.lastDeg >= 180 && this.lastDeg < 225) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = this.vertikalKernel;
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 225 && deg < 270) {
            if (this.sobelKernel != null && this.lastDeg >= 225 && this.lastDeg < 270) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = this.diagonalKernel;
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 270 && deg < 315) {
            if (this.sobelKernel != null && this.lastDeg >= 270 && this.lastDeg < 315) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = new ShortProcessor(5, 5, false);
            int x = 0;
            while (x < 5) {
                int ny = 4;
                int y = 0;
                while (y < 5) {
                    this.sobelKernel.putPixel(ny, x, this.vertikalKernel.getPixel(x, y));
                    --ny;
                    ++y;
                }
                ++x;
            }
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        if (deg >= 315 && deg < 360) {
            if (this.sobelKernel != null && this.lastDeg >= 315 && this.lastDeg < 360) {
                this.lastDeg = deg;
                return this.aktSobelIp;
            }
            this.sobelKernel = new ShortProcessor(5, 5, false);
            int nx = 4;
            int x = 0;
            while (x < 5) {
                int ny = 4;
                int y = 0;
                while (y < 5) {
                    this.sobelKernel.putPixel(ny, x, this.diagonalKernel.getPixel(x, y));
                    --ny;
                    ++y;
                }
                ++x;
            }
            this.lastDeg = deg;
            this.aktSobelIp = this.getSobel(this.aktIp, this.sobelKernel);
            return this.aktSobelIp;
        }
        return this.aktSobelIp;
    }

    private ShortProcessor getSobel(ShortProcessor org, ShortProcessor kernel) {
        int val;
        int y;
        short[] res = new short[org.getWidth() * org.getHeight()];
        int x = 0;
        while (x < org.getWidth() - 5) {
            y = 0;
            while (y < org.getHeight() - 5) {
                val = 0;
                int i = 0;
                while (i < 5) {
                    int j = 0;
                    while (j < 5) {
                        val += this.aktPixel[(y + j) * org.getWidth() + x + i] * kernel.getPixel(i, j);
                        ++j;
                    }
                    ++i;
                }
                if (val < 0) {
                    val = 0;
                }
                res[(y + 2) * org.getWidth() + x + 2] = (short)val;
                ++y;
            }
            ++x;
        }
        String k = "\n";
        y = 0;
        while (y < 5) {
            x = 0;
            while (x < 5) {
                val = kernel.getPixel(x, y);
                if (val >= 0) {
                    k = k + val + " ";
                }
                if (val == -1) {
                    k = k + "# ";
                }
                ++x;
            }
            k = k + "\n";
            ++y;
        }
        ShortProcessor result = new ShortProcessor(org.getWidth(), org.getHeight(), res, org.getColorModel(), false);
        return result;
    }
}

