/*
 * Decompiled with CFR 0.152.
 */
package jm.sit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLabel
extends Canvas {
    private Image image;
    private Image offscreenImage;
    private static String defaultImageString = "http://java.sun.com/lib/images/logo.java.color-transp.55x60.gif";
    private String imageString = "<Existing Image>";
    private boolean debug = false;
    private int border = 0;
    private Color borderColor = null;
    private int width;
    private int height;
    private boolean explicitSize = false;
    private int explicitWidth = 0;
    private int explicitHeight = 0;
    private MediaTracker tracker;
    private static int lastTrackerID = 0;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public ImageLabel() {
        this(defaultImageString);
    }

    public ImageLabel(String imageURLString) {
        this(ImageLabel.makeURL(imageURLString));
    }

    public ImageLabel(URL imageURL) {
        this(ImageLabel.loadImage(imageURL));
        this.imageString = imageURL.toExternalForm();
    }

    public ImageLabel(URL imageDirectory, String file) {
        this(ImageLabel.makeURL(imageDirectory, file));
        this.imageString = file;
    }

    public ImageLabel(Image image) {
        this.image = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
    }

    public void waitForImage(boolean doLayout) {
        if (!this.doneLoading) {
            this.debug("[waitForImage] - Resizing and waiting for " + this.imageString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                System.out.println("Error loading " + this.imageString + ": " + e.getMessage());
                e.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.imageString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.border;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.border;
            this.setSize(this.width, this.height);
            this.debug("[waitForImage] - " + this.imageString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && doLayout) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.doLayout();
            }
        }
    }

    public void centerAt(int x, int y) {
        this.debug("Placing center of " + this.imageString + " at (" + x + "," + y + ")");
        this.setLocation(x - this.width / 2, y - this.height / 2);
    }

    public synchronized boolean contains(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    public void paint(Graphics g) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else {
            if (this.offscreenImage != null) {
                this.image = this.offscreenImage;
            }
            if (this.explicitSize) {
                g.drawImage(this.image, this.border + 12, this.border + 12, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                g.drawImage(this.image, this.border, this.border, this);
                this.drawRect(g, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getMinimumSize();
    }

    public void setSize(int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setSize(width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setBounds(x, y, width, height);
    }

    protected void drawRect(Graphics g, int left, int top, int width, int height, int lineThickness, Color rectangleColor) {
        g.setColor(rectangleColor);
        int i = 0;
        while (i < lineThickness) {
            g.drawRect(left, top, width, height);
            if (i < lineThickness - 1) {
                ++left;
                ++top;
                width -= 2;
                height -= 2;
            }
            ++i;
        }
    }

    protected void debug(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private static URL makeURL(String s) {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + s + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static URL makeURL(URL directory, String file) {
        URL u = null;
        try {
            u = new URL(directory, file);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + directory.toExternalForm() + ", " + file + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static Image loadImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image img) {
        Image oldImage = this.offscreenImage;
        this.offscreenImage = img;
        this.update(this.getGraphics());
        if (oldImage != null) {
            oldImage.flush();
            Object var2_2 = null;
        }
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public static String getDefaultImageString() {
        return defaultImageString;
    }

    public static void setDefaultImageString(String file) {
        defaultImageString = file;
    }

    protected String getImageString() {
        return this.imageString;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setIsDebugging(boolean debug) {
        this.debug = debug;
    }
}

