/*
 * Decompiled with CFR 0.152.
 */
package jm.sit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;

public class JLabelResults
extends JLabel
implements MouseListener,
MouseMotionListener {
    private int xMarks = 25;
    private int yMarks = 10;
    private int space = 4;
    private Font verySmallFont = new Font("Dialog", 0, 8);
    private Font smallFont = new Font("Dialog", 0, 10);
    private Font normalFont = new Font("Dialog", 0, 12);
    private Color colorAverageLeft = new Color(120, 0, 0);
    private Color colorDeviationLeft = new Color(0, 120, 0);
    private Color colorAverageRight = new Color(100, 0, 0);
    private Color colorDeviationRight = new Color(0, 100, 0);
    private Rectangle rec = null;
    private int x;
    private int y;
    private int w;
    private int h;
    private int a;
    private String infoLine = null;
    private double[] averageGrayLeft = null;
    private double[] standardDevLeft = null;
    private double[] averageGrayRight = null;
    private double[] standardDevRight = null;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private boolean showAverageGray = false;
    private boolean showStandardDeviation = false;
    private boolean showMarks = true;
    private boolean showNullValues = true;
    private int mouseX;
    private int mouseY;
    private boolean mouseOver = false;
    private double devScaleFactor = 1.0;

    public JLabelResults() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        int i;
        this.rec = g.getClipBounds();
        this.a = this.space;
        this.x = this.rec.x;
        this.y = this.rec.y;
        this.w = this.rec.width;
        this.h = this.rec.height;
        g.setColor(this.getBackground());
        g.fillRect(this.x, this.y, this.w, this.h);
        g.setColor(this.getForeground());
        g.drawLine(0 + this.a, 0, 0 + this.a, this.h);
        g.drawLine(0, this.h - this.a - 1, this.w, this.h - this.a - 1);
        double adder = (double)(this.h - this.a - 1) / (double)(this.yMarks - 1);
        double pos = 0.0;
        while (pos < (double)(this.h - this.a - 1)) {
            i = (int)Math.round(pos);
            g.drawLine(0, i, 0 + this.a, i);
            pos += adder;
        }
        adder = (double)(this.w - this.a - 1) / (double)(this.xMarks - 1);
        pos = this.w - 1;
        while (pos > (double)this.a) {
            i = (int)Math.round(pos);
            g.drawLine(i, this.h - 1, i, this.h - this.a - 1);
            pos -= adder;
        }
        g.setFont(this.smallFont);
        if (this.infoLine != null) {
            g.drawString(this.infoLine, this.a + 8, 8);
        }
        this.drawIndex(g);
        this.drawCoordinates(g);
        boolean noCurveDrawn = true;
        boolean averageDataAvailable = false;
        boolean deviationDataAvailable = false;
        if (this.showAverageGray) {
            averageDataAvailable = true;
            if (this.averageGrayLeft != null) {
                this.drawGraph(g, "o", this.colorAverageLeft, this.averageGrayLeft);
                noCurveDrawn = false;
            }
            if (this.averageGrayRight != null) {
                this.drawGraph(g, "x", this.colorAverageRight, this.averageGrayRight);
                noCurveDrawn = false;
            }
        }
        if (this.showStandardDeviation) {
            deviationDataAvailable = true;
            if (this.standardDevLeft != null && this.averageGrayLeft != null) {
                this.drawStdDev(g, "o", 0, this.colorDeviationLeft, this.averageGrayLeft, this.standardDevLeft);
                noCurveDrawn = false;
            }
            if (this.standardDevRight != null) {
                this.drawStdDev(g, "x", 1, this.colorDeviationRight, this.averageGrayRight, this.standardDevRight);
                noCurveDrawn = false;
            }
        }
        if (noCurveDrawn) {
            g.setFont(this.normalFont);
            g.setColor(Color.orange);
            if (!this.showAverageGray && !this.showStandardDeviation) {
                g.drawString("no items selected", this.w / 3, this.h / 2 - this.a - 10);
            } else {
                g.drawString("no data available", this.w / 3, this.h / 2 - this.a - 10);
            }
        }
    }

    public void setXMarks(int m) {
        if (m > 2) {
            this.xMarks = m;
            this.repaint();
        }
    }

    public int getXMarks() {
        return this.xMarks;
    }

    public void setYMarks(int m) {
        if (m > 2) {
            this.yMarks = m;
            this.repaint();
        }
    }

    public void setYScale(int min, int max) {
        this.minY = min;
        this.maxY = max;
        this.repaint();
    }

    public void setDevScaleFactor(double s) {
        this.devScaleFactor = s;
        this.repaint();
    }

    private void drawIndex(Graphics g) {
        g.setFont(this.verySmallFont);
        g.setColor(this.colorAverageRight);
        int textPosX = g.getClipBounds().width - this.getFontMetrics(this.verySmallFont).stringWidth(" - right");
        int x = textPosX - 3;
        int y = g.getClipBounds().height - this.space - 8;
        g.drawLine(x - 1, y - 1, x + 1, y + 1);
        g.drawLine(x - 1, y + 1, x + 1, y - 1);
        g.drawString(" - left", textPosX, y + 2);
        g.setColor(this.colorAverageLeft);
        g.drawLine(x - 1, (y -= 10) - 1, x + 1, y - 1);
        g.drawLine(x - 1, y + 1, x + 1, y + 1);
        g.drawLine(x - 1, y - 1, x - 1, y + 1);
        g.drawLine(x + 1, y - 1, x + 1, y + 1);
        g.drawString(" - right", textPosX, y + 2);
    }

    private void drawCoordinates(Graphics g) {
        if (this.mouseOver) {
            int px = this.mouseX - this.space;
            int py = g.getClipBounds().height - this.space - this.mouseY;
            double valX = (double)(this.maxX - this.minX) / (double)(g.getClipBounds().width - this.space - 1) * (double)px;
            double valY = (double)(this.maxY - this.minY) / (double)(g.getClipBounds().height - this.space - 1) * (double)py;
            valX = (double)this.minX + valX;
            valY = (double)this.minY + valY;
            String s = "" + (int)valX + " sec / " + (int)valY + " gray";
            g.setFont(this.smallFont);
            g.setColor(Color.lightGray);
            g.drawString("Position", this.space + 8, 30);
            g.drawString(s, this.space + 8, 40);
        } else {
            g.setColor(Color.black);
            g.setFont(this.smallFont);
            g.drawString("Position", this.space + 8, 30);
            g.drawString("8 sec / 8 gray", this.space + 8, 40);
            g.drawString("88 sec / 88 gray", this.space + 8, 40);
            g.drawString("888 sec / 888 gray", this.space + 8, 40);
        }
    }

    private void drawGraph(Graphics g, String sign, Color c, double[] data) {
        int i = 0;
        int lx = 0;
        int ly = 0;
        this.rec = g.getClipBounds();
        this.a = this.space;
        this.w = this.rec.width;
        this.h = this.rec.height;
        int arrayLength = data.length;
        double baseX = (double)(this.w - this.a - 1) / (double)(this.maxX - this.minX);
        double baseY = (double)(this.h - this.a - 1) / (double)(this.maxY - this.minY);
        double timePerImage = (double)(this.maxX - this.minX) / (double)(arrayLength - 1);
        g.setColor(c);
        i = 0;
        while (i < arrayLength) {
            int y = this.h - this.a - 1 - (int)Math.round((data[i] - (double)this.minY) * baseY);
            int x = this.a + (int)Math.round((double)(i - this.minX) * baseX * timePerImage);
            if (i == 0) {
                lx = x;
                ly = y;
            }
            if (this.showMarks) {
                if (sign.charAt(0) == 'x') {
                    g.drawLine(x - 1, y - 1, x + 1, y + 1);
                    g.drawLine(x - 1, y + 1, x + 1, y - 1);
                    g.drawLine(lx - 1, ly - 1, lx + 1, ly + 1);
                    g.drawLine(lx - 1, ly + 1, lx + 1, ly - 1);
                } else {
                    g.drawLine(x - 1, y - 1, x + 1, y - 1);
                    g.drawLine(x - 1, y + 1, x + 1, y + 1);
                    g.drawLine(x - 1, y - 1, x - 1, y + 1);
                    g.drawLine(x + 1, y - 1, x + 1, y + 1);
                    g.drawLine(lx - 1, ly - 1, lx + 1, ly - 1);
                    g.drawLine(lx - 1, ly + 1, lx + 1, ly + 1);
                    g.drawLine(lx - 1, ly - 1, lx - 1, ly + 1);
                    g.drawLine(lx + 1, ly - 1, lx + 1, ly + 1);
                }
            }
            if (this.showNullValues) {
                g.drawLine(x, y, lx, ly);
            } else if (y < this.h - this.a && ly < this.h - this.a) {
                g.drawLine(x, y, lx, ly);
            }
            lx = x;
            ly = y;
            ++i;
        }
    }

    private void drawStdDev(Graphics g, String sign, int half, Color c, double[] data, double[] dev) {
        int i = 0;
        int lx = 0;
        int ly = 0;
        this.rec = g.getClipBounds();
        this.a = this.space;
        this.w = this.rec.width;
        this.h = this.rec.height;
        int arrayLength = data.length;
        double baseX = (double)(this.w - this.a - 1) / (double)(this.maxX - this.minX);
        double baseY = (double)(this.h - this.a - 1) / (double)(this.maxY - this.minY);
        double timePerImage = (double)(this.maxX - this.minX) / (double)(arrayLength - 1);
        g.setColor(c);
        i = 0;
        while (i < arrayLength) {
            int y = this.h - this.a - 1 - (int)Math.round((data[i] - (double)this.minY) * baseY);
            int x = this.a + (int)Math.round((double)(i - this.minX) * baseX * timePerImage);
            int devMin = this.h - this.a - 1 - (int)Math.round((data[i] - dev[i] * this.devScaleFactor - (double)this.minY) * baseY);
            int devMax = this.h - this.a - 1 - (int)Math.round((data[i] + dev[i] * this.devScaleFactor - (double)this.minY) * baseY);
            if (i == 0) {
                lx = x;
                ly = y;
            }
            if (this.showMarks) {
                if (sign.charAt(0) == 'x') {
                    g.drawLine(x - 1, y - 1, x + 1, y + 1);
                    g.drawLine(x - 1, y + 1, x + 1, y - 1);
                    g.drawLine(lx - 1, ly - 1, lx + 1, ly + 1);
                    g.drawLine(lx - 1, ly + 1, lx + 1, ly - 1);
                } else {
                    g.drawLine(x - 1, y - 1, x + 1, y - 1);
                    g.drawLine(x - 1, y + 1, x + 1, y + 1);
                    g.drawLine(x - 1, y - 1, x - 1, y + 1);
                    g.drawLine(x + 1, y - 1, x + 1, y + 1);
                    g.drawLine(lx - 1, ly - 1, lx + 1, ly - 1);
                    g.drawLine(lx - 1, ly + 1, lx + 1, ly + 1);
                    g.drawLine(lx - 1, ly - 1, lx - 1, ly + 1);
                    g.drawLine(lx + 1, ly - 1, lx + 1, ly + 1);
                }
            }
            if (i > 0) {
                if (this.showNullValues) {
                    if (half == 0) {
                        g.drawLine(x + 1, devMin, x + 1, devMax);
                    } else {
                        g.drawLine(x - 1, devMin, x - 1, devMax);
                    }
                } else if (y < this.h - this.a && ly < this.h - this.a) {
                    if (half == 0) {
                        g.drawLine(x + 1, devMin, x + 1, devMax);
                    } else {
                        g.drawLine(x - 1, devMin, x - 1, devMax);
                    }
                }
            }
            lx = x;
            ly = y;
            ++i;
        }
    }

    public void setXScale(int min, int max) {
        this.minX = min;
        this.maxX = max;
        this.repaint();
    }

    public int getYMarks() {
        return this.yMarks;
    }

    public void setText(String text) {
        if (text != null) {
            this.infoLine = text;
            this.repaint();
        }
    }

    public void setAverageCurveColor(Color c) {
        if (c != null) {
            this.colorAverageLeft = c;
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            if (r > 60) {
                r -= 60;
            }
            if (g > 60) {
                g -= 60;
            }
            if (b > 60) {
                b -= 60;
            }
            this.colorAverageRight = new Color(r, g, b);
            this.repaint();
        }
    }

    public void setDeviationCurveColor(Color c) {
        if (c != null) {
            this.colorDeviationLeft = c;
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            if (r > 60) {
                r -= 60;
            }
            if (g > 60) {
                g -= 60;
            }
            if (b > 60) {
                b -= 60;
            }
            this.colorDeviationRight = new Color(r, g, b);
            this.repaint();
        }
    }

    public void setAverageGray(int half, double[] data) {
        if (half == 0) {
            this.averageGrayLeft = data;
        }
        if (half == 1) {
            this.averageGrayRight = data;
        }
        this.repaint();
    }

    public void setStandardDeviation(int half, double[] data) {
        if (half == 0) {
            this.standardDevLeft = data;
        }
        if (half == 1) {
            this.standardDevRight = data;
        }
        this.repaint();
    }

    public void showAverageGrayValues(boolean show) {
        this.showAverageGray = show;
        this.repaint();
    }

    public void showStandardDeviationValues(boolean show) {
        this.showStandardDeviation = show;
        this.repaint();
    }

    public void showMarks(boolean show) {
        this.showMarks = show;
        this.repaint();
    }

    public void showNullValues(boolean show) {
        this.showNullValues = show;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseOver = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseOver = false;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }
}

