/*
 * Decompiled with CFR 0.152.
 */
package jm.sit;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.MultiLineLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jm.extension.ExJButton;
import jm.sit.ImageLabel;
import jm.sit.SITAnalysis;
import jm.util.GridBagConstraints2;

public class SITAdjuster
extends JFrame
implements ActionListener,
ChangeListener {
    private SITAnalysis analysisDialog = null;
    private Image rightImage = null;
    private Image leftImage = null;
    private Image rightRefImage = null;
    private Image leftRefImage = null;
    private MediaTracker mediaTracker = new MediaTracker(this);
    private int widthLeft = 0;
    private int heightLeft = 0;
    public boolean finished = false;
    private double thCortexLeft;
    private double thMedullaLeft;
    private double thPelvisLeft;
    private double thCortexRight;
    private double thMedullaRight;
    private double thPelvisRight;
    JPanel jPanelMain = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    ImageLabel jImageLabelRight = null;
    ImageLabel jImageLabelLeft = null;
    ImageLabel jImageLabelRefRight = null;
    ImageLabel jImageLabelRefLeft = null;
    MultiLineLabel jLabelLeftImage = new MultiLineLabel("right kidney\n(2 x zoom)");
    MultiLineLabel jLabelRightImage = new MultiLineLabel("left kidney\n(2 x zoom)");
    JSlider jSliderPelvisRight = new JSlider();
    JSlider jSliderMedullaRight = new JSlider();
    JSlider jSliderCortexRight = new JSlider();
    JPanel jPanelRight = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jPanelLeft = new JPanel();
    JSlider jSliderPelvisLeft = new JSlider();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabelPelvisRight = new JLabel();
    JLabel jLabelMedullaRight = new JLabel();
    JLabel jLabelCortexRight = new JLabel();
    JSlider jSliderMedullaLeft = new JSlider();
    JSlider jSliderCortexLeft = new JSlider();
    JLabel jLabelPelvisLeft = new JLabel();
    JLabel jLabelMedullaLeft = new JLabel();
    JLabel jLabelCortexLeft = new JLabel();
    JLabel jLabelBlackSpacerRight = new JLabel();
    JLabel jLabelBlackSpacerLeft = new JLabel();
    ExJButton jButtonApply = new ExJButton();
    ExJButton jButtonCancel = new ExJButton();
    JLabel jLabelDummy = new JLabel();

    public SITAdjuster(SITAnalysis dlg, Image imgR, Image imgL) {
        try {
            this.analysisDialog = dlg;
            this.rightImage = imgR;
            this.leftImage = imgL;
            this.rightRefImage = this.getScaledImage(this.analysisDialog.rightRefImage, 2.0);
            this.leftRefImage = this.getScaledImage(this.analysisDialog.leftRefImage, 2.0);
            this.jbInit();
            this.guiInit();
            this.thCortexLeft = this.analysisDialog.classTresholdCortex[0];
            this.thMedullaLeft = this.analysisDialog.classTresholdMedulla[0];
            this.thPelvisLeft = this.analysisDialog.classTresholdPelvis[0];
            this.thCortexRight = this.analysisDialog.classTresholdCortex[1];
            this.thMedullaRight = this.analysisDialog.classTresholdMedulla[1];
            this.thPelvisRight = this.analysisDialog.classTresholdPelvis[1];
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jImageLabelRight = new ImageLabel(this.rightImage);
        this.jImageLabelLeft = new ImageLabel(this.leftImage);
        this.jImageLabelRefRight = new ImageLabel(this.rightRefImage);
        this.jImageLabelRefLeft = new ImageLabel(this.leftRefImage);
        this.jPanelMain.setLayout(this.gridBagLayout1);
        this.jSliderCortexLeft.setMinimum(50);
        this.jSliderCortexLeft.setMaximum(150);
        this.jSliderCortexLeft.setMajorTickSpacing(10);
        this.jSliderCortexLeft.setMinorTickSpacing(1);
        this.jSliderCortexLeft.setSnapToTicks(true);
        this.jSliderCortexRight.setMinimum(50);
        this.jSliderCortexRight.setMaximum(150);
        this.jSliderCortexRight.setMajorTickSpacing(10);
        this.jSliderCortexRight.setMinorTickSpacing(1);
        this.jSliderCortexRight.setSnapToTicks(true);
        this.jSliderPelvisLeft.setMinimum(50);
        this.jSliderPelvisLeft.setMaximum(150);
        this.jSliderPelvisLeft.setMajorTickSpacing(10);
        this.jSliderPelvisLeft.setMinorTickSpacing(1);
        this.jSliderPelvisLeft.setSnapToTicks(true);
        this.jSliderPelvisRight.setMinimum(50);
        this.jPanelMain.setForeground(Color.lightGray);
        this.jPanelMain.setBackground(Color.black);
        this.jSliderPelvisRight.setMaximum(150);
        this.jSliderPelvisRight.setMajorTickSpacing(10);
        this.jSliderPelvisRight.setMinorTickSpacing(1);
        this.jSliderPelvisRight.setSnapToTicks(true);
        this.jSliderMedullaLeft.setMinimum(50);
        this.jSliderMedullaLeft.setMaximum(150);
        this.jSliderMedullaLeft.setMajorTickSpacing(10);
        this.jSliderMedullaLeft.setMinorTickSpacing(1);
        this.jSliderMedullaLeft.setSnapToTicks(true);
        this.jSliderMedullaRight.setMinimum(50);
        this.jSliderMedullaRight.setMaximum(150);
        this.jSliderMedullaRight.setMajorTickSpacing(10);
        this.jSliderMedullaRight.setMinorTickSpacing(1);
        this.jSliderMedullaRight.setSnapToTicks(true);
        this.jLabelPelvisRight.setText("-  threshold renal pelvis: 1.00 +");
        this.jLabelMedullaRight.setText("-  threshold renal medulla: 1.00 +");
        this.jLabelCortexRight.setText("-  threshold renal cortex: 1.00 +");
        this.jLabelPelvisLeft.setText("-  threshold renal pelvis: 1.00 +");
        this.jLabelMedullaLeft.setText("-  threshold renal medulla: 1.00 +");
        this.jLabelCortexLeft.setText("-  threshold renal cortex: 1.00 +");
        Font labelFont = new Font("Dialog", 1, 11);
        this.jLabelLeftImage.setBackground(Color.black);
        this.jLabelLeftImage.setFont(new Font("Dialog", 1, 11));
        this.jLabelRightImage.setForeground(Color.lightGray);
        this.jLabelRightImage.setBackground(Color.black);
        this.jLabelRightImage.setFont(new Font("Dialog", 1, 11));
        this.jLabelLeftImage.setForeground(Color.lightGray);
        this.jSliderPelvisLeft.setForeground(Color.lightGray);
        this.jSliderPelvisLeft.setBackground(Color.black);
        this.jSliderMedullaLeft.setForeground(Color.lightGray);
        this.jSliderMedullaLeft.setBackground(Color.black);
        this.jSliderCortexLeft.setForeground(Color.lightGray);
        this.jSliderCortexLeft.setBackground(Color.black);
        this.jSliderPelvisRight.setForeground(Color.lightGray);
        this.jSliderPelvisRight.setBackground(Color.black);
        this.jSliderMedullaRight.setForeground(Color.lightGray);
        this.jSliderMedullaRight.setBackground(Color.black);
        this.jSliderCortexRight.setForeground(Color.lightGray);
        this.jSliderCortexRight.setBackground(Color.black);
        this.jPanelRight.setForeground(Color.lightGray);
        this.jPanelRight.setBackground(Color.black);
        this.jPanelLeft.setForeground(Color.lightGray);
        this.jPanelLeft.setBackground(Color.black);
        this.jLabelCortexRight.setForeground(Color.lightGray);
        this.jLabelCortexRight.setBackground(Color.black);
        this.jLabelMedullaRight.setForeground(Color.lightGray);
        this.jLabelMedullaRight.setBackground(Color.black);
        this.jLabelPelvisRight.setForeground(Color.lightGray);
        this.jLabelPelvisRight.setBackground(Color.black);
        this.jLabelCortexLeft.setForeground(Color.lightGray);
        this.jLabelCortexLeft.setBackground(Color.black);
        this.jLabelMedullaLeft.setForeground(Color.lightGray);
        this.jLabelMedullaLeft.setBackground(Color.black);
        this.jLabelPelvisLeft.setForeground(Color.lightGray);
        this.jLabelPelvisLeft.setBackground(Color.black);
        this.jLabelPelvisRight.setFont(labelFont);
        this.jLabelMedullaRight.setFont(labelFont);
        this.jLabelCortexRight.setFont(labelFont);
        this.jLabelPelvisLeft.setFont(labelFont);
        this.jLabelMedullaLeft.setFont(labelFont);
        this.jLabelCortexLeft.setFont(labelFont);
        this.jLabelBlackSpacerRight.setText("      ");
        this.jLabelBlackSpacerLeft.setText("      ");
        this.jButtonApply.setMargin(new Insets(0, 14, 0, 14));
        this.jButtonApply.setForeground(Color.lightGray);
        this.jButtonApply.setText("apply values");
        this.jButtonApply.setBackground(Color.darkGray);
        this.jButtonApply.setFont(new Font("Dialog", 1, 11));
        this.jButtonApply.setOpaque(true);
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.setBackground(Color.darkGray);
        this.jButtonCancel.setFont(new Font("Dialog", 1, 11));
        this.jButtonCancel.setOpaque(true);
        this.jLabelDummy.setText("                   ");
        this.jButtonCancel.setMargin(new Insets(0, 14, 0, 14));
        this.jButtonCancel.setForeground(Color.lightGray);
        this.jPanelLeft.setLayout(this.gridBagLayout3);
        this.jPanelRight.setLayout(this.gridBagLayout2);
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelMain.add((Component)this.jPanelLeft, new GridBagConstraints2(0, 0, 3, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jSliderPelvisLeft, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jImageLabelLeft, new GridBagConstraints2(1, 0, 1, 6, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jSliderMedullaLeft, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jSliderCortexLeft, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jLabelPelvisLeft, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jLabelMedullaLeft, new GridBagConstraints2(3, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jLabelCortexLeft, new GridBagConstraints2(3, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jLabelLeftImage, new GridBagConstraints2(0, 6, 2, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jLabelBlackSpacerLeft, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelLeft.add((Component)this.jImageLabelRefLeft, new GridBagConstraints2(0, 0, 1, 6, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jButtonCancel, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 8, 0), 0, 0));
        this.jPanelMain.add((Component)this.jButtonApply, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 8, 0), 0, 0));
        this.jPanelMain.add((Component)this.jPanelRight, new GridBagConstraints2(0, 1, 3, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jSliderPelvisRight, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jImageLabelRight, new GridBagConstraints2(1, 0, 1, 6, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jSliderMedullaRight, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jSliderCortexRight, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jLabelPelvisRight, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jLabelMedullaRight, new GridBagConstraints2(3, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jLabelCortexRight, new GridBagConstraints2(3, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jLabelRightImage, new GridBagConstraints2(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jLabelBlackSpacerRight, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelRight.add((Component)this.jImageLabelRefRight, new GridBagConstraints2(0, 0, 1, 6, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelDummy, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void guiInit() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
        this.jSliderCortexLeft.setValue((int)(this.analysisDialog.classTresholdCortex[0] * 100.0));
        this.jSliderCortexRight.setValue((int)(this.analysisDialog.classTresholdCortex[1] * 100.0));
        this.jSliderPelvisLeft.setValue((int)(this.analysisDialog.classTresholdPelvis[0] * 100.0));
        this.jSliderPelvisRight.setValue((int)(this.analysisDialog.classTresholdPelvis[1] * 100.0));
        this.jSliderMedullaLeft.setValue((int)(this.analysisDialog.classTresholdMedulla[0] * 100.0));
        this.jSliderMedullaRight.setValue((int)(this.analysisDialog.classTresholdMedulla[1] * 100.0));
        this.jSliderCortexLeft.setRequestFocusEnabled(false);
        this.jSliderCortexRight.setRequestFocusEnabled(false);
        this.jSliderPelvisLeft.setRequestFocusEnabled(false);
        this.jSliderPelvisRight.setRequestFocusEnabled(false);
        this.jSliderMedullaLeft.setRequestFocusEnabled(false);
        this.jSliderMedullaRight.setRequestFocusEnabled(false);
        this.jButtonApply.addActionListener(this);
        this.jButtonCancel.addActionListener(this);
        this.jSliderCortexLeft.addChangeListener(this);
        this.jSliderCortexRight.addChangeListener(this);
        this.jSliderMedullaLeft.addChangeListener(this);
        this.jSliderMedullaRight.addChangeListener(this);
        this.jSliderPelvisLeft.addChangeListener(this);
        this.jSliderPelvisRight.addChangeListener(this);
        this.jImageLabelLeft.setBorder(2);
        this.jImageLabelLeft.setBorderColor(Color.black);
        this.jImageLabelRight.setBorder(2);
        this.jImageLabelRight.setBorderColor(Color.black);
        this.jImageLabelRefLeft.setBorder(2);
        this.jImageLabelRefLeft.setBorderColor(Color.black);
        this.jImageLabelRefRight.setBorder(2);
        this.jImageLabelRefRight.setBorderColor(Color.black);
        if (!this.analysisDialog.autoClassification[0]) {
            this.jImageLabelLeft.setEnabled(false);
            this.jImageLabelRefLeft.setEnabled(false);
            this.jSliderCortexLeft.setEnabled(false);
            this.jSliderMedullaLeft.setEnabled(false);
            this.jSliderPelvisLeft.setEnabled(false);
        }
        if (!this.analysisDialog.autoClassification[1]) {
            this.jImageLabelRight.setEnabled(false);
            this.jImageLabelRefRight.setEnabled(false);
            this.jSliderCortexRight.setEnabled(false);
            this.jSliderMedullaRight.setEnabled(false);
            this.jSliderPelvisRight.setEnabled(false);
        }
        this.setTitle(" Adjust SIT-Results");
        this.setBackground(Color.black);
        this.setForeground(Color.lightGray);
        this.pack();
        this.setResizable(false);
        Rectangle rec = this.getBounds();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screensize.width - rec.width) / 2, (screensize.height - rec.height) / 2);
        this.setVisible(true);
        ChangeEvent evt = new ChangeEvent(this.jSliderMedullaRight);
        this.stateChanged(evt);
        evt = new ChangeEvent(this.jSliderCortexRight);
        this.stateChanged(evt);
        evt = new ChangeEvent(this.jSliderPelvisRight);
        this.stateChanged(evt);
        evt = new ChangeEvent(this.jSliderMedullaLeft);
        this.stateChanged(evt);
        evt = new ChangeEvent(this.jSliderCortexLeft);
        this.stateChanged(evt);
        evt = new ChangeEvent(this.jSliderPelvisLeft);
        this.stateChanged(evt);
    }

    public void updateImage(int half, Image img) {
        if (half == 0 && this.jImageLabelLeft != null) {
            this.leftImage = img;
            this.jImageLabelLeft.setImage(img);
            this.jImageLabelLeft.repaint();
        }
        if (half == 1 && this.jImageLabelRight != null) {
            this.rightImage = img;
            this.jImageLabelRight.setImage(img);
            this.jImageLabelRight.repaint();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            if (src == this.jButtonApply) {
                if (this.analysisDialog.autoClassification[0]) {
                    this.analysisDialog.classTresholdCortex[0] = this.thCortexLeft;
                    this.analysisDialog.classTresholdMedulla[0] = this.thMedullaLeft;
                    this.analysisDialog.classTresholdPelvis[0] = this.thPelvisLeft;
                    this.analysisDialog.classifyPixels(0, this.analysisDialog.classTresholdPelvis[0], this.analysisDialog.classTresholdMedulla[0], this.analysisDialog.classTresholdCortex[0]);
                    this.analysisDialog.calcPixelCurve(0, 2);
                    this.analysisDialog.calcPixelCurve(0, 3);
                    this.analysisDialog.initResultWindow(0);
                    this.analysisDialog.sitResults.setSmooth(false);
                    this.analysisDialog.sitResults.updateImageLabel(1, this.analysisDialog.ipLeftKidney);
                }
                if (this.analysisDialog.autoClassification[1]) {
                    this.analysisDialog.classTresholdCortex[1] = this.thCortexRight;
                    this.analysisDialog.classTresholdMedulla[1] = this.thMedullaRight;
                    this.analysisDialog.classTresholdPelvis[1] = this.thPelvisRight;
                    this.analysisDialog.classifyPixels(1, this.analysisDialog.classTresholdPelvis[1], this.analysisDialog.classTresholdMedulla[1], this.analysisDialog.classTresholdCortex[1]);
                    this.analysisDialog.calcPixelCurve(1, 2);
                    this.analysisDialog.calcPixelCurve(1, 3);
                    this.analysisDialog.initResultWindow(1);
                    this.analysisDialog.sitResults.setSmooth(false);
                    this.analysisDialog.sitResults.updateImageLabel(0, this.analysisDialog.ipRightKidney);
                }
                this.analysisDialog.setMinMaxAxisValues(2);
                this.analysisDialog.setMinMaxAxisValues(3);
                this.finished = true;
                this.setVisible(false);
                this.dispose();
            }
            if (src == this.jButtonCancel) {
                this.finished = true;
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    public void stateChanged(ChangeEvent evt) {
        String text;
        double val;
        Object src = evt.getSource();
        if (src == this.jSliderCortexLeft) {
            this.thCortexLeft = val = (double)this.jSliderCortexLeft.getValue() / 100.0;
            text = "-  threshold renal cortex: ";
            text = text + this.d2s(val, 2);
            this.jLabelCortexLeft.setText(text + " +");
            this.analysisDialog.classifyPixels(0, this.thPelvisLeft, this.thMedullaLeft, this.thCortexLeft);
            this.updateImage(0, this.getScaledImage(this.analysisDialog.ipLeftKidney, 2.0));
        }
        if (src == this.jSliderCortexRight) {
            this.thCortexRight = val = (double)this.jSliderCortexRight.getValue() / 100.0;
            text = "-  threshold renal cortex: ";
            text = text + this.d2s(val, 2);
            this.jLabelCortexRight.setText(text + " +");
            this.analysisDialog.classifyPixels(1, this.thPelvisRight, this.thMedullaRight, this.thCortexRight);
            this.updateImage(1, this.getScaledImage(this.analysisDialog.ipRightKidney, 2.0));
        }
        if (src == this.jSliderMedullaLeft) {
            this.thMedullaLeft = val = (double)this.jSliderMedullaLeft.getValue() / 100.0;
            text = "-  threshold renal medulla: ";
            text = text + this.d2s(val, 2);
            this.jLabelMedullaLeft.setText(text + " +");
            this.analysisDialog.classifyPixels(0, this.thPelvisLeft, this.thMedullaLeft, this.thCortexLeft);
            this.updateImage(0, this.getScaledImage(this.analysisDialog.ipLeftKidney, 2.0));
        }
        if (src == this.jSliderMedullaRight) {
            this.thMedullaRight = val = (double)this.jSliderMedullaRight.getValue() / 100.0;
            text = "-  threshold renal medulla: ";
            text = text + this.d2s(val, 2);
            this.jLabelMedullaRight.setText(text + " +");
            this.analysisDialog.classifyPixels(1, this.thPelvisRight, this.thMedullaRight, this.thCortexRight);
            this.updateImage(1, this.getScaledImage(this.analysisDialog.ipRightKidney, 2.0));
        }
        if (src == this.jSliderPelvisLeft) {
            this.thPelvisLeft = val = (double)this.jSliderPelvisLeft.getValue() / 100.0;
            text = "-  threshold renal pelvis: ";
            text = text + this.d2s(val, 2);
            this.jLabelPelvisLeft.setText(text + " +");
            this.analysisDialog.classifyPixels(0, this.thPelvisLeft, this.thMedullaLeft, this.thCortexLeft);
            this.updateImage(0, this.getScaledImage(this.analysisDialog.ipLeftKidney, 2.0));
        }
        if (src == this.jSliderPelvisRight) {
            this.thPelvisRight = val = (double)this.jSliderPelvisRight.getValue() / 100.0;
            text = "-  threshold renal pelvis: ";
            text = text + this.d2s(val, 2);
            this.jLabelPelvisRight.setText(text + " +");
            this.analysisDialog.classifyPixels(1, this.thPelvisRight, this.thMedullaRight, this.thCortexRight);
            this.updateImage(1, this.getScaledImage(this.analysisDialog.ipRightKidney, 2.0));
        }
    }

    private String d2s(double d, int l) {
        String result = IJ.d2s((double)d, (int)l);
        result = result.replace(',', '.');
        while (result.length() > 1 && result.charAt(0) == '0' && result.charAt(1) != '.') {
            result = result.substring(1);
        }
        return result;
    }

    private Image getScaledImage(ImagePlus imp, double scale) {
        if (imp == null) {
            return null;
        }
        Image scaledImage = null;
        Image originalImage = imp.getImage();
        try {
            int x = (int)((double)imp.getWidth() * scale);
            int y = (int)((double)imp.getHeight() * scale);
            scaledImage = originalImage.getScaledInstance(x, y, 4);
            this.mediaTracker.addImage(scaledImage, 0);
            this.mediaTracker.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            scaledImage.flush();
            scaledImage = null;
            return originalImage;
        }
        originalImage.flush();
        originalImage = null;
        return scaledImage;
    }

    public void setAdjustmentRange(double min, double max) {
        int smin = (int)(min * 100.0);
        int smax = (int)(max * 100.0);
        this.jSliderCortexLeft.setMinimum(smin);
        this.jSliderCortexLeft.setMaximum(smax);
        this.jSliderMedullaLeft.setMinimum(smin);
        this.jSliderMedullaLeft.setMaximum(smax);
        this.jSliderPelvisLeft.setMinimum(smin);
        this.jSliderPelvisLeft.setMaximum(smax);
        this.jSliderCortexRight.setMinimum(smin);
        this.jSliderCortexRight.setMaximum(smax);
        this.jSliderMedullaRight.setMinimum(smin);
        this.jSliderMedullaRight.setMaximum(smax);
        this.jSliderPelvisRight.setMinimum(smin);
        this.jSliderPelvisRight.setMaximum(smax);
        this.repaint();
    }
}

