/*
 * Decompiled with CFR 0.152.
 */
package jm.sit;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import jm.extension.ExImageCanvas;
import jm.kidney.AnalysisDialog;
import jm.sit.SITResults;

public class SITAnalysis
extends Thread {
    private double grayAdd = 30.0;
    public double devScaleFactor = 0.001;
    private double adjustmentMin = 0.5;
    private double adjustmentMax = 1.5;
    private int maxImage = 0;
    private int maxTime = 0;
    public AnalysisDialog analysisDialog = null;
    public SITResults sitResults = null;
    public ImagePlus rightRefImage = null;
    public ImagePlus leftRefImage = null;
    private Color myYellow = new Color(243, 239, 118);
    private Color myRed = new Color(227, 75, 75);
    private ImagePlus imagePlus = null;
    private ImageStack imageStack = null;
    private ExImageCanvas imageCanvas = null;
    private ImageProcessor imageProcessor = null;
    private int width = 0;
    private int height = 0;
    private Roi rRoi = null;
    private Roi lRoi = null;
    private Rectangle rRect = null;
    private Rectangle lRect = null;
    private double[][] stdDeviation = null;
    private double[][] averageGray = null;
    private double[][] stdDeviationMedulla = null;
    private double[][] averageGrayMedulla = null;
    private double[][] stdDeviationCortex = null;
    private double[][] averageGrayCortex = null;
    private double[][] secondDerivation = null;
    public int[] pixelCountKidney = null;
    public int[] pixelCountMedulla = null;
    public int[] pixelCountCortex = null;
    public int[] surfaceKidney = null;
    public int[] surfaceMedulla = null;
    public int[] surfaceCortex = null;
    private double[] pixStdDeviation = null;
    private double[] pixAverageGray = null;
    private double[] pixGrayAscent = null;
    private short[] pixClassification = null;
    private short[] pixDistancePercent = null;
    private short[] pix = null;
    private int[][] centerGravX = null;
    private int[][] centerGravY = null;
    private int[] maxGray = null;
    private int[] imageNrTreshhold = null;
    private double[] maxDeviation = null;
    private double[] maxAverageGray = null;
    private double[] maxGrayAscent = null;
    public double[] acquisitionTimes = null;
    public ImagePlus ipLeftKidney = null;
    public ImagePlus ipRightKidney = null;
    private ColorProcessor cpClassifyHelper = null;
    public boolean[] autoClassification = null;
    public boolean[] noRois = null;
    private boolean[][] enabledForSIT = null;
    public boolean stopRunning = false;
    public boolean finished = false;
    public boolean error = false;
    private boolean verbose = true;
    private int startImage = 1;
    public double[] classTresholdPelvis = null;
    public double[] classTresholdMedulla = null;
    public double[] classTresholdCortex = null;
    private Roi[] leftRoi = null;
    private Roi[] rightRoi = null;
    private Roi[][] leftRoiCortex = null;
    private Roi[][] rightRoiCortex = null;
    private Roi[][] leftRoiMedulla = null;
    private Roi[][] rightRoiMedulla = null;

    /*
     * Unable to fully structure code
     */
    public SITAnalysis(AnalysisDialog dlg) {
        super();
        try {
            block58: {
                block57: {
                    block55: {
                        block54: {
                            this.analysisDialog = dlg;
                            this.imagePlus = this.analysisDialog.imagePlus;
                            this.imageStack = this.imagePlus.getStack();
                            this.maxImage = this.imagePlus.getStackSize();
                            this.imageCanvas = this.analysisDialog.imageCanvas;
                            this.startImage = this.analysisDialog.startImage;
                            this.height = this.imagePlus.getHeight();
                            this.width = this.imagePlus.getWidth();
                            this.leftRoi = this.imageCanvas.getRoi(0);
                            this.rightRoi = this.imageCanvas.getRoi(1);
                            this.leftRoiCortex = this.imageCanvas.getRoi(0, 3);
                            this.rightRoiCortex = this.imageCanvas.getRoi(1, 3);
                            this.leftRoiMedulla = this.imageCanvas.getRoi(0, 2);
                            this.rightRoiMedulla = this.imageCanvas.getRoi(1, 2);
                            this.enabledForSIT = this.imageCanvas.getEnabledForSIT();
                            this.autoClassification = new boolean[2];
                            this.noRois = new boolean[2];
                            half = 0;
                            while (half <= 1) {
                                this.autoClassification[half] = true;
                                this.noRois[half] = false;
                                roi = this.leftRoi;
                                cortexRoi = this.leftRoiCortex;
                                medullaRoi = this.leftRoiMedulla;
                                if (half == 1) {
                                    roi = this.rightRoi;
                                    cortexRoi = this.rightRoiCortex;
                                    medullaRoi = this.rightRoiMedulla;
                                }
                                lastX = -1;
                                lastY = -1;
                                x = -1;
                                y = -1;
                                counter = 0;
                                i = this.startImage - 1;
                                while (i < this.maxImage) {
                                    if (roi != null && roi[i] != null && this.enabledForSIT[half][i]) {
                                        ++counter;
                                        x = roi[i].getBoundingRect().x;
                                        y = roi[i].getBoundingRect().y;
                                        if (lastX < 0) {
                                            lastX = x;
                                        }
                                        if (lastY < 0) {
                                            lastY = y;
                                        }
                                        if (lastX != x || lastY != y || cortexRoi != null && cortexRoi[i][0] != null || medullaRoi != null && medullaRoi[i][0] != null) {
                                            this.autoClassification[half] = false;
                                            i = this.maxImage;
                                        }
                                    }
                                    lastX = x;
                                    lastY = y;
                                    ++i;
                                }
                                if (this.autoClassification[half] && counter == 0) {
                                    this.autoClassification[half] = false;
                                    i = this.startImage - 1;
                                    while (i < this.maxImage) {
                                        if (cortexRoi != null && cortexRoi[i][0] != null || medullaRoi != null && medullaRoi[i][0] != null) {
                                            ++counter;
                                        }
                                        ++i;
                                    }
                                    if (counter == 0) {
                                        this.noRois[half] = true;
                                    }
                                }
                                ++half;
                            }
                            if (this.verbose) {
                                IJ.write((String)"Checking both ROIs...");
                            }
                            if (!this.autoClassification[0]) break block54;
                            i = 0;
                            while (this.lRoi == null) {
                                this.lRoi = this.leftRoi[i++];
                            }
                            this.lRect = this.lRoi.getBoundingRect();
                            if (this.verbose) {
                                IJ.write((String)("Left ROI x:" + this.lRect.x + " y: " + this.lRect.y + " w: " + this.lRect.width + " h: " + this.lRect.height));
                            }
                            break block55;
                        }
                        this.lRect = new Rectangle(0x7FFFFFFF, 0x7FFFFFFF, -2147483648, -2147483648);
                        i = this.startImage - 1;
                        while (i < this.maxImage) {
                            block56: {
                                if (!this.enabledForSIT[0][i]) break block56;
                                if (this.leftRoi != null && this.leftRoi[i] != null) {
                                    rect = this.leftRoi[i].getBoundingRect();
                                    if (rect.x < this.lRect.x) {
                                        this.lRect.x = rect.x;
                                    }
                                    if (rect.y < this.lRect.y) {
                                        this.lRect.y = rect.y;
                                    }
                                    if (rect.width > this.lRect.width) {
                                        this.lRect.width = rect.width;
                                    }
                                    if (rect.height > this.lRect.height) {
                                        this.lRect.height = rect.height;
                                    }
                                }
                                j = 0;
                                if (true) ** GOTO lbl174
                                do {
                                    rect = this.leftRoiCortex[i][j].getBoundingRect();
                                    if (rect.x < this.lRect.x) {
                                        this.lRect.x = rect.x;
                                    }
                                    if (rect.y < this.lRect.y) {
                                        this.lRect.y = rect.y;
                                    }
                                    if (rect.width > this.lRect.width) {
                                        this.lRect.width = rect.width;
                                    }
                                    if (rect.height > this.lRect.height) {
                                        this.lRect.height = rect.height;
                                    }
                                    ++j;
lbl174:
                                    // 2 sources

                                } while (j < 100 && this.leftRoiCortex != null && this.leftRoiCortex[i][j] != null);
                                j = 0;
                                if (true) ** GOTO lbl189
                                do {
                                    rect = this.leftRoiMedulla[i][j].getBoundingRect();
                                    if (rect.x < this.lRect.x) {
                                        this.lRect.x = rect.x;
                                    }
                                    if (rect.y < this.lRect.y) {
                                        this.lRect.y = rect.y;
                                    }
                                    if (rect.width > this.lRect.width) {
                                        this.lRect.width = rect.width;
                                    }
                                    if (rect.height > this.lRect.height) {
                                        this.lRect.height = rect.height;
                                    }
                                    ++j;
lbl189:
                                    // 2 sources

                                } while (j < 100 && this.leftRoiMedulla != null && this.leftRoiMedulla[i][j] != null);
                            }
                            ++i;
                        }
                        if (this.lRect.width < 0) {
                            this.lRect = null;
                        }
                    }
                    if (!this.autoClassification[1]) break block57;
                    i = 0;
                    while (this.rRoi == null) {
                        this.rRoi = this.rightRoi[i++];
                    }
                    this.rRect = this.rRoi.getBoundingRect();
                    IJ.write((String)("Right ROI x:" + this.rRect.x + " y: " + this.rRect.y + " w: " + this.rRect.width + " h: " + this.rRect.height));
                    break block58;
                }
                this.rRect = new Rectangle(0x7FFFFFFF, 0x7FFFFFFF, -2147483648, -2147483648);
                i = this.startImage - 1;
                while (i < this.maxImage) {
                    block59: {
                        if (!this.enabledForSIT[1][i]) break block59;
                        if (this.rightRoi != null && this.rightRoi[i] != null) {
                            rect = this.rightRoi[i].getBoundingRect();
                            if (rect.x < this.rRect.x) {
                                this.rRect.x = rect.x;
                            }
                            if (rect.y < this.rRect.y) {
                                this.rRect.y = rect.y;
                            }
                            if (rect.width > this.rRect.width) {
                                this.rRect.width = rect.width;
                            }
                            if (rect.height > this.rRect.height) {
                                this.rRect.height = rect.height;
                            }
                        }
                        j = 0;
                        if (true) ** GOTO lbl233
                        do {
                            rect = this.rightRoiCortex[i][j].getBoundingRect();
                            if (rect.x < this.rRect.x) {
                                this.rRect.x = rect.x;
                            }
                            if (rect.y < this.rRect.y) {
                                this.rRect.y = rect.y;
                            }
                            if (rect.width > this.rRect.width) {
                                this.rRect.width = rect.width;
                            }
                            if (rect.height > this.rRect.height) {
                                this.rRect.height = rect.height;
                            }
                            ++j;
lbl233:
                            // 2 sources

                        } while (j < 100 && this.rightRoiCortex != null && this.rightRoiCortex[i][j] != null);
                        j = 0;
                        if (true) ** GOTO lbl248
                        do {
                            rect = this.rightRoiMedulla[i][j].getBoundingRect();
                            if (rect.x < this.rRect.x) {
                                this.rRect.x = rect.x;
                            }
                            if (rect.y < this.rRect.y) {
                                this.rRect.y = rect.y;
                            }
                            if (rect.width > this.rRect.width) {
                                this.rRect.width = rect.width;
                            }
                            if (rect.height > this.rRect.height) {
                                this.rRect.height = rect.height;
                            }
                            ++j;
lbl248:
                            // 2 sources

                        } while (j < 100 && this.rightRoiMedulla != null && this.rightRoiMedulla[i][j] != null);
                    }
                    ++i;
                }
                if (this.rRect.width < 0) {
                    this.rRect = null;
                }
            }
            imageTimes = this.analysisDialog.acquisitionTime;
            if (imageTimes != null) {
                arrayLen = imageTimes.length;
                this.maxTime = imageTimes[arrayLen - 1] / 1000;
                if (this.maxTime == 0) {
                    this.maxTime = arrayLen * 2;
                }
                this.acquisitionTimes = new double[arrayLen];
                i = 0;
                while (i < arrayLen) {
                    this.acquisitionTimes[i] = (double)imageTimes[i] / 1000.0;
                    ++i;
                }
            }
        }
        catch (Exception e) {
            IJ.write((String)"Can't initialise Result Window");
            this.error = true;
            e.printStackTrace();
        }
    }

    public void setStartImage(int n) {
        if (n < this.maxImage && n >= 1) {
            this.startImage = n;
        }
    }

    private void initImages(boolean showImages) {
        int x;
        short[] pixLeft = (short[])this.imageStack.getPixels(this.imageNrTreshhold[0]);
        short[] pixRight = (short[])this.imageStack.getPixels(this.imageNrTreshhold[1]);
        this.pix = new short[this.width * this.height];
        int y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width / 2) {
                this.pix[y * this.width + x] = pixLeft[y * this.width + x];
                ++x;
            }
            int x2 = this.width / 2;
            while (x2 < this.width) {
                this.pix[y * this.width + x2] = pixRight[y * this.width + x2];
                ++x2;
            }
            ++y;
        }
        this.cpClassifyHelper = new ColorProcessor(this.width, this.height);
        x = 0;
        while (x < this.width) {
            int y2 = 0;
            while (y2 < this.height) {
                double gray = this.pix[y2 * this.width + x];
                int r = (int)(gray += this.grayAdd);
                int g = (int)gray;
                int b = (int)gray;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                int val = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                this.cpClassifyHelper.putPixel(x, y2, val);
                ++y2;
            }
            ++x;
        }
        Rectangle Rect = null;
        int half = 0;
        while (half <= 1) {
            int y3;
            int x3;
            if (half == 0) {
                Rect = this.lRect;
            }
            if (half == 1) {
                Rect = this.rRect;
            }
            ColorProcessor cp = null;
            if (Rect != null) {
                cp = new ColorProcessor(Rect.width, Rect.height);
                x3 = 0;
                while (x3 < Rect.width) {
                    y3 = 0;
                    while (y3 < Rect.height) {
                        double gray = this.pix[(y3 + Rect.y) * this.width + (x3 + Rect.x)];
                        int r = (int)(gray += this.grayAdd);
                        int g = (int)gray;
                        int b = (int)gray;
                        if (r > 255) {
                            r = 255;
                        }
                        if (g > 255) {
                            g = 255;
                        }
                        if (b > 255) {
                            b = 255;
                        }
                        int val = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                        cp.putPixel(x3, y3, val);
                        ++y3;
                    }
                    ++x3;
                }
            } else {
                cp = new ColorProcessor(20, 20);
                x3 = 0;
                while (x3 < 20) {
                    y3 = 0;
                    while (y3 < 20) {
                        int val = 0;
                        cp.putPixel(x3, y3, val);
                        ++y3;
                    }
                    ++x3;
                }
            }
            if (half == 0) {
                this.ipLeftKidney = new ImagePlus("right Kidney", (ImageProcessor)cp);
                if (showImages) {
                    this.ipLeftKidney.show();
                }
            } else {
                this.ipRightKidney = new ImagePlus("left Kidney", (ImageProcessor)cp);
                if (showImages) {
                    this.ipRightKidney.show();
                }
            }
            ++half;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int i = 0;
        int x = 0;
        int y = 0;
        this.stopRunning = false;
        if (this.noRois[0] && this.noRois[1]) {
            this.finished = false;
            this.stopRunning = true;
            return;
        }
        try {
            int j;
            int half;
            int counter;
            block125: {
                short[] rPix;
                ShortProcessor spTemp;
                ColorModel cm;
                short[] pix;
                block124: {
                    short[] lPix;
                    block123: {
                        block121: {
                            Roi roi;
                            Rectangle rect;
                            int[] mask = null;
                            pix = null;
                            IJ.showProgress((double)0.001);
                            int maxProgress = 0;
                            counter = 0;
                            this.stdDeviation = new double[2][this.maxImage];
                            this.averageGray = new double[2][this.maxImage];
                            this.stdDeviationMedulla = new double[2][this.maxImage];
                            this.averageGrayMedulla = new double[2][this.maxImage];
                            this.stdDeviationCortex = new double[2][this.maxImage];
                            this.averageGrayCortex = new double[2][this.maxImage];
                            this.secondDerivation = new double[2][this.maxImage];
                            this.centerGravX = new int[2][this.maxImage];
                            this.centerGravY = new int[2][this.maxImage];
                            this.maxGray = new int[2];
                            this.imageNrTreshhold = new int[2];
                            this.maxDeviation = new double[2];
                            this.maxAverageGray = new double[2];
                            this.maxGrayAscent = new double[2];
                            this.pixelCountKidney = new int[2];
                            this.pixelCountMedulla = new int[2];
                            this.pixelCountCortex = new int[2];
                            this.surfaceKidney = new int[2];
                            this.surfaceMedulla = new int[2];
                            this.surfaceCortex = new int[2];
                            this.classTresholdPelvis = new double[2];
                            this.classTresholdMedulla = new double[2];
                            this.classTresholdCortex = new double[2];
                            this.pixStdDeviation = new double[this.width * this.height];
                            this.pixAverageGray = new double[this.width * this.height];
                            this.pixGrayAscent = new double[this.width * this.height];
                            this.pixClassification = new short[this.width * this.height];
                            this.pixDistancePercent = new short[this.width * this.height];
                            if (this.lRect != null) {
                                ++maxProgress;
                            }
                            if (this.rRect != null) {
                                ++maxProgress;
                            }
                            maxProgress = maxProgress * 2 * this.maxImage;
                            half = 0;
                            block4: while (true) {
                                if (half > 1) {
                                    this.imageNrTreshhold[0] = 1;
                                    this.imageNrTreshhold[1] = 1;
                                    if (this.autoClassification[0]) {
                                        this.imageNrTreshhold[0] = this.getMaxArrayPos(this.derivation(this.floatingAverage(this.floatingAverage(this.averageGray[0], 3), 3))) + 3;
                                        if (this.verbose) {
                                            IJ.write((String)("Turn Over-Point for Right Kidney is Image: " + this.imageNrTreshhold[0]));
                                        }
                                    }
                                    if (this.autoClassification[1]) {
                                        this.imageNrTreshhold[1] = this.getMaxArrayPos(this.derivation(this.floatingAverage(this.floatingAverage(this.averageGray[1], 3), 3))) + 3;
                                        if (this.verbose) {
                                            IJ.write((String)("Turn Over-Point for Left Kidney is Image: " + this.imageNrTreshhold[1]));
                                        }
                                    }
                                    if (this.imageNrTreshhold[0] > this.maxImage) {
                                        this.imageNrTreshhold[0] = this.maxImage;
                                    }
                                    if (this.imageNrTreshhold[1] > this.maxImage) {
                                        this.imageNrTreshhold[1] = this.maxImage;
                                    }
                                    this.initImages(false);
                                    if (this.autoClassification[0] || this.autoClassification[1]) {
                                        break;
                                    }
                                    break block121;
                                }
                                this.pixelCountKidney[half] = 0;
                                this.classTresholdPelvis[half] = 1.0;
                                this.classTresholdMedulla[half] = 1.0;
                                this.classTresholdCortex[half] = 1.0;
                                rect = this.lRect;
                                roi = this.lRoi;
                                if (half == 1) {
                                    rect = this.rRect;
                                    roi = this.rRoi;
                                }
                                i = this.startImage;
                                while (true) {
                                    if (i > this.maxImage) {
                                        ++half;
                                        continue block4;
                                    }
                                    double[] roiProperties = new double[6];
                                    int j2 = 0;
                                    while (true) {
                                        if (j2 >= 6) {
                                            if (half == 0 && this.enabledForSIT[0][i - 1] && this.leftRoi != null) {
                                                roiProperties = this.getRoiProperties(i, this.leftRoi[i - 1]);
                                            }
                                            if (half == 1 && this.enabledForSIT[1][i - 1] && this.rightRoi != null) {
                                                roiProperties = this.getRoiProperties(i, this.rightRoi[i - 1]);
                                            }
                                            try {
                                                SITAnalysis.sleep(5L);
                                            }
                                            catch (InterruptedException ie) {
                                                IJ.write((String)"Interrupted in SIT-calcualtion");
                                            }
                                            break;
                                        }
                                        roiProperties[j2] = 0.0;
                                        ++j2;
                                    }
                                    this.averageGray[half][i - 1] = roiProperties[0];
                                    this.stdDeviation[half][i - 1] = roiProperties[1];
                                    this.centerGravX[half][i - 1] = (int)roiProperties[2];
                                    this.centerGravY[half][i - 1] = (int)roiProperties[3];
                                    this.maxGray[half] = (int)roiProperties[4];
                                    this.pixelCountKidney[half] = (int)roiProperties[5];
                                    if (this.verbose) {
                                        IJ.write((String)("Slice: " + i + " Half:" + half + " - Average Gray: " + this.averageGray[half][i - 1] + " StandardDeviation: " + this.stdDeviation[half][i - 1]));
                                    }
                                    ++i;
                                }
                                break;
                            }
                            x = 0;
                            block7: while (true) {
                                if (x >= this.width) {
                                    half = 0;
                                    break;
                                }
                                y = 0;
                                while (true) {
                                    if (y >= this.height) {
                                        ++x;
                                        continue block7;
                                    }
                                    this.pixDistancePercent[y * this.width + x] = 100;
                                    ++y;
                                }
                                break;
                            }
                            while (half <= 1) {
                                this.maxAverageGray[half] = 0.0;
                                this.maxDeviation[half] = 0.0;
                                this.maxGrayAscent[half] = 0.0;
                                rect = this.lRect;
                                roi = this.lRoi;
                                if (half == 1) {
                                    rect = this.rRect;
                                    roi = this.rRoi;
                                }
                                if (rect != null && this.autoClassification[half] && (mask = roi.getMask()) != null) {
                                    double sum;
                                    x = 0;
                                    block10: while (true) {
                                        if (x >= rect.width) break;
                                        y = 0;
                                        while (true) {
                                            if (y >= rect.height) {
                                                ++x;
                                                continue block10;
                                            }
                                            if (mask[y * rect.width + x] != -1) {
                                                counter = 0;
                                                sum = 0.0;
                                                i = this.startImage;
                                                while (true) {
                                                    if (i > this.maxImage) {
                                                        this.pixAverageGray[(y + rect.y) * this.width + (x + rect.x)] = sum /= (double)counter;
                                                        if (!(this.maxAverageGray[half] < sum)) break;
                                                        this.maxAverageGray[half] = sum;
                                                        break;
                                                    }
                                                    if (this.enabledForSIT[half][i - 1]) {
                                                        pix = (short[])this.imageStack.getPixels(i);
                                                        sum += (double)pix[(y + rect.y) * this.width + (x + rect.x)];
                                                        ++counter;
                                                    }
                                                    ++i;
                                                }
                                            }
                                            ++y;
                                        }
                                        break;
                                    }
                                    x = 0;
                                    block13: while (true) {
                                        if (x >= rect.width) {
                                            if (this.verbose) {
                                                IJ.write((String)"Calculating Help-Parameters...");
                                            }
                                            break;
                                        }
                                        y = 0;
                                        while (true) {
                                            if (y >= rect.height) {
                                                ++x;
                                                continue block13;
                                            }
                                            if (mask[y * rect.width + x] != -1) {
                                                counter = 0;
                                                sum = 0.0;
                                                i = this.startImage;
                                                while (true) {
                                                    if (i > this.maxImage) {
                                                        double dev;
                                                        this.pixStdDeviation[(y + rect.y) * this.width + (x + rect.x)] = dev = Math.sqrt(1.0 / (double)counter * sum);
                                                        if (!(this.maxDeviation[half] < dev)) break;
                                                        this.maxDeviation[half] = dev;
                                                        break;
                                                    }
                                                    if (this.enabledForSIT[half][i - 1]) {
                                                        pix = (short[])this.imageStack.getPixels(i);
                                                        double d = (double)pix[(y + rect.y) * this.width + (x + rect.x)] - this.pixAverageGray[(y + rect.y) * this.width + (x + rect.x)];
                                                        sum += d * d;
                                                        ++counter;
                                                    }
                                                    ++i;
                                                }
                                            }
                                            ++y;
                                        }
                                        break;
                                    }
                                    x = 0;
                                    block16: while (true) {
                                        if (x >= rect.width) {
                                            x = 0;
                                            break;
                                        }
                                        y = 0;
                                        while (true) {
                                            if (y >= rect.height) {
                                                ++x;
                                                continue block16;
                                            }
                                            if (mask[y * rect.width + x] != -1) {
                                                int vy;
                                                int dy;
                                                int vx;
                                                int dx;
                                                double dist;
                                                int yb;
                                                int xb;
                                                int ya;
                                                int xa;
                                                block122: {
                                                    xa = -1;
                                                    ya = -1;
                                                    int pos = this.startImage - 1;
                                                    while (true) {
                                                        if (xa >= 0 && ya >= 0) {
                                                            xb = x;
                                                            yb = y;
                                                            dist = this.calcDistance(xa, ya, xb, yb);
                                                            if (xb <= xa) break;
                                                            dx = 1;
                                                            vx = yb - ya;
                                                            break block122;
                                                        }
                                                        xa = this.centerGravX[half][pos] - rect.x;
                                                        ya = this.centerGravY[half][pos] - rect.y;
                                                        ++pos;
                                                    }
                                                    dx = -1;
                                                    vx = ya - yb;
                                                }
                                                if (yb > ya) {
                                                    dy = 1;
                                                    vy = xa - xb;
                                                } else {
                                                    dy = -1;
                                                    vy = xb - xa;
                                                }
                                                int fa = 0;
                                                int px = xa;
                                                int py = ya;
                                                while (px != xb || py != yb) {
                                                    if (py * rect.width + px < mask.length && mask[py * rect.width + px] != -1) {
                                                        short oldVal;
                                                        double d = this.calcDistance(xa, ya, px, py);
                                                        short percent = 0;
                                                        if (dist > 0.0) {
                                                            percent = (short)(d / dist * 100.0);
                                                        }
                                                        if (percent < (oldVal = this.pixDistancePercent[(py + rect.y) * this.width + (px + rect.x)])) {
                                                            this.pixDistancePercent[(py + rect.y) * this.width + (px + rect.x)] = percent;
                                                        }
                                                    }
                                                    int fx = fa + vx;
                                                    int fy = fa + vy;
                                                    int fxy = fx + fy - fa;
                                                    if (Math.abs(fx) <= Math.abs(fy) && Math.abs(fx) <= Math.abs(fxy)) {
                                                        px += dx;
                                                        fa = fx;
                                                        continue;
                                                    }
                                                    if (Math.abs(fy) < Math.abs(fx) && Math.abs(fy) < Math.abs(fxy)) {
                                                        fa = fy;
                                                        py += dy;
                                                        continue;
                                                    }
                                                    fa = fxy;
                                                    px += dx;
                                                    py += dy;
                                                }
                                            }
                                            ++y;
                                        }
                                        break;
                                    }
                                    block20: while (x < rect.width) {
                                        y = 0;
                                        while (true) {
                                            if (y >= rect.height) {
                                                ++x;
                                                continue block20;
                                            }
                                            if (mask[y * rect.width + x] != -1) {
                                                counter = 0;
                                                sum = 0.0;
                                                i = this.startImage + 1;
                                                while (true) {
                                                    if (i > this.imageNrTreshhold[half]) {
                                                        sum /= (double)counter;
                                                        this.pixGrayAscent[(y + rect.y) * this.width + (x + rect.x)] = sum *= 10.0;
                                                        if (!(this.maxGrayAscent[half] < sum)) break;
                                                        this.maxGrayAscent[half] = sum;
                                                        break;
                                                    }
                                                    if (this.enabledForSIT[half][i - 1]) {
                                                        pix = (short[])this.imageStack.getPixels(i - 1);
                                                        short val1 = pix[(y + rect.y) * this.width + (x + rect.x)];
                                                        pix = (short[])this.imageStack.getPixels(i);
                                                        short val2 = pix[(y + rect.y) * this.width + (x + rect.x)];
                                                        if (val2 < val1) {
                                                            val2 = val1;
                                                        }
                                                        sum += (double)(val2 - val1);
                                                        ++counter;
                                                    }
                                                    ++i;
                                                }
                                            }
                                            ++y;
                                        }
                                    }
                                }
                                ++half;
                            }
                        }
                        boolean showImages = false;
                        cm = this.imagePlus.getProcessor().getColorModel();
                        pix = new short[this.width * this.height];
                        i = 0;
                        while (true) {
                            if (i >= this.width * this.height) {
                                ShortProcessor sp1 = new ShortProcessor(this.width, this.height, pix, cm, false);
                                ImagePlus ip1 = new ImagePlus("Test1", (ImageProcessor)sp1);
                                if (showImages) {
                                    ip1.show();
                                }
                                break;
                            }
                            pix[i] = (short)this.pixAverageGray[i];
                            ++i;
                        }
                        i = 0;
                        while (true) {
                            if (i >= this.width * this.height) {
                                ShortProcessor sp2 = new ShortProcessor(this.width, this.height, pix, cm, false);
                                ImagePlus ip2 = new ImagePlus("Test2", (ImageProcessor)sp2);
                                if (showImages) {
                                    ip2.show();
                                }
                                ShortProcessor sp3 = new ShortProcessor(this.width, this.height, this.pixDistancePercent, cm, false);
                                ImagePlus ip3 = new ImagePlus("Test3", (ImageProcessor)sp3);
                                if (showImages) {
                                    ip3.show();
                                }
                                break;
                            }
                            pix[i] = (short)this.pixStdDeviation[i];
                            ++i;
                        }
                        i = 0;
                        while (true) {
                            if (i >= this.width * this.height) {
                                ShortProcessor sp4 = new ShortProcessor(this.width, this.height, pix, cm, false);
                                ImagePlus ip4 = new ImagePlus("Test4", (ImageProcessor)sp4);
                                if (showImages) {
                                    ip4.show();
                                }
                                if (this.lRect != null) {
                                    break;
                                }
                                break block123;
                            }
                            pix[i] = (short)this.pixGrayAscent[i];
                            ++i;
                        }
                        pix = (short[])this.imageStack.getPixels(this.imageNrTreshhold[0]);
                        lPix = new short[this.lRect.width * this.lRect.height];
                        i = 0;
                        block26: while (true) {
                            if (i >= this.lRect.width) {
                                spTemp = new ShortProcessor(this.lRect.width, this.lRect.height, lPix, cm, false);
                                this.leftRefImage = new ImagePlus("Temp", (ImageProcessor)spTemp);
                                break block124;
                            }
                            j = 0;
                            while (true) {
                                if (j >= this.lRect.height) {
                                    ++i;
                                    continue block26;
                                }
                                lPix[j * this.lRect.width + i] = pix[(this.lRect.y + j) * this.width + this.lRect.x + i];
                                ++j;
                            }
                            break;
                        }
                    }
                    lPix = new short[400];
                    i = 0;
                    while (true) {
                        if (i >= 400) {
                            spTemp = new ShortProcessor(20, 20, lPix, cm, false);
                            this.leftRefImage = new ImagePlus("Temp", (ImageProcessor)spTemp);
                            break;
                        }
                        lPix[i] = 0;
                        ++i;
                    }
                }
                if (this.rRect != null) {
                    pix = (short[])this.imageStack.getPixels(this.imageNrTreshhold[1]);
                    rPix = new short[this.rRect.width * this.rRect.height];
                    i = 0;
                    block29: while (true) {
                        if (i >= this.rRect.width) {
                            spTemp = new ShortProcessor(this.rRect.width, this.rRect.height, rPix, cm, false);
                            this.rightRefImage = new ImagePlus("Temp", (ImageProcessor)spTemp);
                            break block125;
                        }
                        j = 0;
                        while (true) {
                            if (j >= this.rRect.height) {
                                ++i;
                                continue block29;
                            }
                            rPix[j * this.rRect.width + i] = pix[(this.rRect.y + j) * this.width + this.rRect.x + i];
                            ++j;
                        }
                        break;
                    }
                }
                rPix = new short[400];
                i = 0;
                while (true) {
                    if (i >= 400) {
                        spTemp = new ShortProcessor(20, 20, rPix, cm, false);
                        this.leftRefImage = new ImagePlus("Temp", (ImageProcessor)spTemp);
                        break;
                    }
                    rPix[i] = 0;
                    ++i;
                }
            }
            if (this.verbose) {
                IJ.write((String)("Wendepunkt links: " + this.imageNrTreshhold[0] + "\nWendepunkt rechts: " + this.imageNrTreshhold[1]));
            }
            half = 0;
            while (true) {
                if (half > 1) {
                    this.setMinMaxAxisValues(5);
                    this.setMinMaxAxisValues(2);
                    this.setMinMaxAxisValues(3);
                    IJ.showProgress((double)1.0);
                    IJ.showStatus((String)"");
                    this.finished = true;
                    this.sitResults.updateImageLabel(0, this.ipRightKidney);
                    this.sitResults.updateImageLabel(1, this.ipLeftKidney);
                    this.imagePlus.unlock();
                    this.finished = true;
                    this.stopRunning = true;
                    break;
                }
                int otherHalf = Math.abs(half - 1);
                if (this.verbose) {
                    IJ.write((String)("Classifying Pixels for Half: " + half));
                }
                if (this.autoClassification[half]) {
                    this.classifyPixels(half, this.classTresholdPelvis[half], this.classTresholdMedulla[half], this.classTresholdCortex[half]);
                    this.calcPixelCurve(half, 2);
                    this.calcPixelCurve(half, 3);
                    if (this.analysisDialog.interpolateNullValues) {
                        this.averageGray[half] = this.interpolateNullValues(this.averageGray[half]);
                        this.stdDeviation[half] = this.interpolateNullValues(this.stdDeviation[half]);
                    }
                    if (this.startImage > 1) {
                        this.averageGray[half] = this.fillMissingValues(this.averageGray[half]);
                        this.stdDeviation[half] = this.fillMissingValues(this.stdDeviation[half]);
                    }
                    this.initResultWindow(half);
                } else {
                    Roi[][] roiMedulla = this.leftRoiMedulla;
                    Roi[][] roiCortex = this.leftRoiCortex;
                    if (half == 1) {
                        roiMedulla = this.rightRoiMedulla;
                        roiCortex = this.rightRoiCortex;
                    }
                    this.pixelCountCortex[half] = 0;
                    this.pixelCountMedulla[half] = 0;
                    int pixelCountCor = 0;
                    int pixelCountMed = 0;
                    int counterCountCor = 0;
                    int counterCountMed = 0;
                    i = this.startImage - 1;
                    while (true) {
                        if (i >= this.maxImage) {
                            if (counterCountCor > 0) {
                                this.pixelCountCortex[half] = pixelCountCor / counterCountCor;
                            }
                            if (counterCountMed > 0) {
                                this.pixelCountMedulla[half] = pixelCountMed / counterCountMed;
                            }
                            if (this.analysisDialog.interpolateNullValues) {
                                this.averageGray[half] = this.interpolateNullValues(this.averageGray[half]);
                                this.averageGrayCortex[half] = this.interpolateNullValues(this.averageGrayCortex[half]);
                                this.averageGrayMedulla[half] = this.interpolateNullValues(this.averageGrayMedulla[half]);
                                this.stdDeviation[half] = this.interpolateNullValues(this.stdDeviation[half]);
                                this.stdDeviationCortex[half] = this.interpolateNullValues(this.stdDeviationCortex[half]);
                                this.stdDeviationMedulla[half] = this.interpolateNullValues(this.stdDeviationMedulla[half]);
                            }
                            if (this.startImage > 1) {
                                this.averageGray[half] = this.fillMissingValues(this.averageGray[half]);
                                this.averageGrayCortex[half] = this.fillMissingValues(this.averageGrayCortex[half]);
                                this.averageGrayMedulla[half] = this.fillMissingValues(this.averageGrayMedulla[half]);
                                this.stdDeviation[half] = this.fillMissingValues(this.stdDeviation[half]);
                                this.stdDeviationCortex[half] = this.fillMissingValues(this.stdDeviationCortex[half]);
                                this.stdDeviationMedulla[half] = this.fillMissingValues(this.stdDeviationMedulla[half]);
                            }
                            this.initResultWindow(half);
                            break;
                        }
                        if (this.enabledForSIT[half][i]) {
                            int p;
                            double[] roiProperties;
                            this.averageGrayCortex[half][i] = 0.0;
                            this.averageGrayMedulla[half][i] = 0.0;
                            counter = 0;
                            j = 0;
                            block34: while (true) {
                                if (j >= 100 || roiCortex == null || roiCortex[i][j] == null) {
                                    if (counter > 1) {
                                        this.averageGrayCortex[half][i] = this.averageGrayCortex[half][i] / (double)counter;
                                        this.stdDeviationCortex[half][i] = this.stdDeviationCortex[half][i] / (double)counter;
                                    }
                                    break;
                                }
                                roiProperties = new double[6];
                                p = 0;
                                while (true) {
                                    if (p >= 6) {
                                        roiProperties = this.getRoiProperties(i + 1, roiCortex[i][j]);
                                        double[] dArray = this.averageGrayCortex[half];
                                        int n = i;
                                        dArray[n] = dArray[n] + roiProperties[0];
                                        double[] dArray2 = this.stdDeviationCortex[half];
                                        int n2 = i;
                                        dArray2[n2] = dArray2[n2] + roiProperties[1];
                                        pixelCountCor = (int)((double)pixelCountCor + roiProperties[5]);
                                        ++j;
                                        ++counter;
                                        ++counterCountCor;
                                        continue block34;
                                    }
                                    roiProperties[p] = 0.0;
                                    ++p;
                                }
                                break;
                            }
                            counter = 0;
                            j = 0;
                            block36: while (true) {
                                if (j >= 100 || roiMedulla == null || roiMedulla[i][j] == null) {
                                    if (counter <= 1) break;
                                    this.averageGrayMedulla[half][i] = this.averageGrayMedulla[half][i] / (double)counter;
                                    this.stdDeviationMedulla[half][i] = this.stdDeviationMedulla[half][i] / (double)counter;
                                    break;
                                }
                                roiProperties = new double[6];
                                p = 0;
                                while (true) {
                                    if (p >= 6) {
                                        roiProperties = this.getRoiProperties(i + 1, roiMedulla[i][j]);
                                        double[] dArray = this.averageGrayMedulla[half];
                                        int n = i;
                                        dArray[n] = dArray[n] + roiProperties[0];
                                        double[] dArray3 = this.stdDeviationMedulla[half];
                                        int n3 = i;
                                        dArray3[n3] = dArray3[n3] + roiProperties[1];
                                        pixelCountMed = (int)((double)pixelCountMed + roiProperties[5]);
                                        ++j;
                                        ++counter;
                                        ++counterCountMed;
                                        continue block36;
                                    }
                                    roiProperties[p] = 0.0;
                                    ++p;
                                }
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (this.verbose) {
                    IJ.write((String)"Done.");
                }
                ++half;
            }
        }
        catch (Exception e) {
            IJ.write((String)"Error while calculation SIT-Graph !");
            this.error = true;
            e.printStackTrace();
            this.stopRunning = true;
        }
        if (this.analysisDialog != null) {
            this.analysisDialog.sitFinished();
        }
    }

    public void setMinMaxAxisValues(int tissue) {
        int min = 0;
        int max = 100;
        if (tissue == 5) {
            min = Integer.MAX_VALUE;
            min = Math.min(this.getMinArrayVal(this.substArrays(this.averageGray[0], this.scaleArray(this.stdDeviation[0], this.devScaleFactor))), min);
            min = Math.min(this.getMinArrayVal(this.substArrays(this.averageGray[1], this.scaleArray(this.stdDeviation[1], this.devScaleFactor))), min);
            max = Integer.MIN_VALUE;
            max = Math.max(this.getMaxArrayVal(this.addArrays(this.averageGray[0], this.scaleArray(this.stdDeviation[0], this.devScaleFactor))), max);
            max = Math.max(this.getMaxArrayVal(this.addArrays(this.averageGray[1], this.scaleArray(this.stdDeviation[1], this.devScaleFactor))), max);
        }
        if (tissue == 2) {
            min = Integer.MAX_VALUE;
            min = Math.min(this.getMinArrayVal(this.substArrays(this.averageGrayMedulla[0], this.scaleArray(this.stdDeviationMedulla[0], this.devScaleFactor))), min);
            min = Math.min(this.getMinArrayVal(this.substArrays(this.averageGrayMedulla[1], this.scaleArray(this.stdDeviationMedulla[1], this.devScaleFactor))), min);
            max = Integer.MIN_VALUE;
            max = Math.max(this.getMaxArrayVal(this.addArrays(this.averageGrayMedulla[0], this.scaleArray(this.stdDeviationMedulla[0], this.devScaleFactor))), max);
            max = Math.max(this.getMaxArrayVal(this.addArrays(this.averageGrayMedulla[1], this.scaleArray(this.stdDeviationMedulla[1], this.devScaleFactor))), max);
        }
        if (tissue == 3) {
            min = Integer.MAX_VALUE;
            min = Math.min(this.getMinArrayVal(this.substArrays(this.averageGrayCortex[0], this.scaleArray(this.stdDeviationCortex[0], this.devScaleFactor))), min);
            min = Math.min(this.getMinArrayVal(this.substArrays(this.averageGrayCortex[1], this.scaleArray(this.stdDeviationCortex[1], this.devScaleFactor))), min);
            max = Integer.MIN_VALUE;
            max = Math.max(this.getMaxArrayVal(this.addArrays(this.averageGrayCortex[0], this.scaleArray(this.stdDeviationCortex[0], this.devScaleFactor))), max);
            max = Math.max(this.getMaxArrayVal(this.addArrays(this.averageGrayCortex[1], this.scaleArray(this.stdDeviationCortex[1], this.devScaleFactor))), max);
        }
        this.sitResults.setYScale(tissue, min, max);
        this.sitResults.setDevScaleFactor(this.devScaleFactor, tissue);
    }

    private double[] getRoiProperties(int slice, Roi roi) {
        short s;
        Rectangle rect = null;
        if (roi != null) {
            rect = roi.getBoundingRect();
        }
        double averageGray = 0.0;
        double stdDeviation = 0.0;
        double centerGravX = 0.0;
        double centerGravY = 0.0;
        boolean hasMask = false;
        boolean bl = false;
        int pixelCount = 0;
        short[] pix = (short[])this.imageStack.getPixels(slice);
        if (rect != null) {
            int y;
            int[] mask = roi.getMask();
            if (mask != null) {
                hasMask = true;
            }
            averageGray = 0.0;
            stdDeviation = 0.0;
            int counter = 0;
            int xSum = 0;
            int ySum = 0;
            int n = Integer.MIN_VALUE;
            pixelCount = 0;
            int x = 0;
            while (x < rect.width) {
                y = 0;
                while (y < rect.height) {
                    if (!hasMask || hasMask && mask[y * rect.width + x] != -1) {
                        ++counter;
                        short grayVal = pix[(y + rect.y) * this.width + (x + rect.x)];
                        if (grayVal > s) {
                            s = grayVal;
                        }
                        averageGray += (double)grayVal;
                        xSum += (x + rect.x) * grayVal;
                        ySum += (y + rect.y) * grayVal;
                    }
                    ++y;
                }
                ++x;
            }
            centerGravX = xSum / (int)averageGray;
            centerGravY = ySum / (int)averageGray;
            averageGray /= (double)counter;
            pixelCount = counter;
            double sum = 0.0;
            x = 0;
            while (x < rect.width) {
                y = 0;
                while (y < rect.height) {
                    if (!hasMask || hasMask && mask[y * rect.width + x] != -1) {
                        double d = (double)pix[(y + rect.y) * this.width + (x + rect.x)] - averageGray;
                        sum += d * d;
                    }
                    ++y;
                }
                ++x;
            }
            stdDeviation = Math.sqrt(1.0 / (double)counter * sum);
        }
        double[] result = new double[]{averageGray, stdDeviation, centerGravX, centerGravY, s, pixelCount};
        return result;
    }

    public void initResultWindow(int half) {
        if (this.sitResults == null) {
            this.sitResults = new SITResults(this, this.ipRightKidney, this.ipLeftKidney);
        }
        this.sitResults.setAdjustmentRange(this.adjustmentMin, this.adjustmentMax);
        this.sitResults.setAverageGray(half, 5, this.averageGray[half]);
        this.sitResults.setStandardDeviation(half, 5, this.stdDeviation[half]);
        this.sitResults.setAverageGray(half, 3, this.averageGrayCortex[half]);
        this.sitResults.setStandardDeviation(half, 3, this.stdDeviationCortex[half]);
        this.sitResults.setAverageGray(half, 2, this.averageGrayMedulla[half]);
        this.sitResults.setStandardDeviation(half, 2, this.stdDeviationMedulla[half]);
        this.sitResults.setXScale(5, 0, this.maxTime);
        this.sitResults.setXScale(2, 0, this.maxTime);
        this.sitResults.setXScale(3, 0, this.maxTime);
        int marks = this.averageGray[half].length;
        while (marks > 30) {
            marks /= 2;
        }
        this.sitResults.setXMarks(5, marks);
        this.sitResults.setXMarks(2, marks);
        this.sitResults.setXMarks(3, marks);
    }

    public void classifyPixels(int half, double thresholdPelvis, double thresholdMedulla, double thresholdCortex) {
        int[] mask = null;
        Rectangle rect = null;
        Roi roi = null;
        ColorProcessor ip = null;
        if (half == 0) {
            rect = this.lRect;
            roi = this.lRoi;
            if (this.ipLeftKidney != null) {
                ip = this.ipLeftKidney.getProcessor();
            }
        }
        if (half == 1) {
            rect = this.rRect;
            roi = this.rRoi;
            if (this.ipRightKidney != null) {
                ip = this.ipRightKidney.getProcessor();
            }
        }
        ip = ip;
        int rectWidth = rect.width;
        int rectHeight = rect.height;
        int rectX = rect.x;
        int rectY = rect.y;
        double inverseThresholdCortex = Math.abs(thresholdCortex - 2.0);
        double weakThresholdCortex = (thresholdCortex - 1.0) / 2.0 + 1.0;
        int lumination = (int)this.grayAdd;
        int lumMinus = -15724528;
        int yellowAdd = (lumination & 0xFF) << 16 | (lumination & 0xFF) << 8;
        int redAdd = (lumination & 0xFF) << 16;
        int greenAdd = (lumination & 0xFF) << 8;
        int blueAdd = lumination & 0xFF;
        if (rect != null) {
            mask = roi.getMask();
            if (mask != null) {
                this.pixelCountCortex[half] = 0;
                this.pixelCountMedulla[half] = 0;
                int x = 0;
                while (x < rectWidth) {
                    int y = 0;
                    while (y < rectHeight) {
                        if (mask[y * rectWidth + x] != -1) {
                            int val;
                            boolean classified = false;
                            double dev = this.pixStdDeviation[(y + rectY) * this.width + (x + rectX)];
                            double dist = this.pixDistancePercent[(y + rectY) * this.width + (x + rectX)];
                            double asc = this.pixGrayAscent[(y + rectY) * this.width + (x + rectX)];
                            if (dev < this.maxDeviation[half] * 0.4 * thresholdPelvis && dist < 65.0 * thresholdPelvis) {
                                this.pixClassification[(y + rectY) * this.width + (x + rectX)] = 4;
                                val = this.cpClassifyHelper.getPixel(x + rectX, y + rectY);
                                ip.putPixel(x, y, val -= lumMinus);
                                classified = true;
                            }
                            if (dev < this.maxDeviation[half] * 0.75 * thresholdMedulla && dist < 95.0 * thresholdMedulla && asc < this.maxGrayAscent[half] * 0.6 * thresholdMedulla && !classified) {
                                this.pixClassification[(y + rectY) * this.width + (x + rectX)] = 2;
                                this.pixelCountMedulla[half] = this.pixelCountMedulla[half] + 1;
                                val = this.cpClassifyHelper.getPixel(x + rectX, y + rectY);
                                val -= lumMinus;
                                ip.putPixel(x, y, val += redAdd);
                                classified = true;
                            }
                            if (!classified) {
                                this.pixClassification[(y + rectY) * this.width + (x + rectX)] = 3;
                                this.pixelCountCortex[half] = this.pixelCountCortex[half] + 1;
                                val = this.cpClassifyHelper.getPixel(x + rectX, y + rectY);
                                val -= lumMinus;
                                ip.putPixel(x, y, val += yellowAdd);
                                classified = true;
                            }
                            if (dist > 90.0 * weakThresholdCortex && asc < this.maxGrayAscent[half] * 0.55 * inverseThresholdCortex && dev < this.maxDeviation[half] * 0.5 * inverseThresholdCortex) {
                                this.pixClassification[(y + rectY) * this.width + (x + rectX)] = 4;
                                val = this.cpClassifyHelper.getPixel(x + rectX, y + rectY);
                                ip.putPixel(x, y, val -= lumMinus);
                                classified = true;
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (half == 0) {
                this.ipLeftKidney.updateImage();
            }
            if (half == 1) {
                this.ipRightKidney.updateImage();
            }
        }
    }

    public void calcPixelCurve(int half, int tissue) {
        Rectangle rect = null;
        if (half == 0) {
            rect = this.lRect;
        }
        if (half == 1) {
            rect = this.rRect;
        }
        if (rect != null && this.pixClassification != null) {
            int i = this.startImage;
            while (i <= this.maxImage) {
                if (tissue == 2) {
                    this.averageGrayMedulla[half][i - 1] = 0.0;
                    this.stdDeviationMedulla[half][i - 1] = 0.0;
                }
                if (tissue == 3) {
                    this.averageGrayCortex[half][i - 1] = 0.0;
                    this.stdDeviationCortex[half][i - 1] = 0.0;
                }
                if (this.enabledForSIT[half][i - 1]) {
                    this.pix = (short[])this.imageStack.getPixels(i);
                    int counter = 0;
                    double sum = 0.0;
                    double d = 0.0;
                    double avGray = 0.0;
                    int x = 0;
                    while (x < rect.width) {
                        int y = 0;
                        while (y < rect.height) {
                            short pixClass = this.pixClassification[(y + rect.y) * this.width + (x + rect.x)];
                            if (pixClass == tissue) {
                                ++counter;
                                short grayVal = this.pix[(y + rect.y) * this.width + (x + rect.x)];
                                if (tissue == 2) {
                                    this.averageGrayMedulla[half][i - 1] = this.averageGrayMedulla[half][i - 1] + (double)grayVal;
                                }
                                if (tissue == 3) {
                                    this.averageGrayCortex[half][i - 1] = this.averageGrayCortex[half][i - 1] + (double)grayVal;
                                }
                            }
                            ++y;
                        }
                        ++x;
                    }
                    if (tissue == 2) {
                        this.averageGrayMedulla[half][i - 1] = this.averageGrayMedulla[half][i - 1] / (double)counter;
                        avGray = this.averageGrayMedulla[half][i - 1];
                    }
                    if (tissue == 3) {
                        this.averageGrayCortex[half][i - 1] = this.averageGrayCortex[half][i - 1] / (double)counter;
                        avGray = this.averageGrayCortex[half][i - 1];
                    }
                    int x2 = 0;
                    while (x2 < rect.width) {
                        int y = 0;
                        while (y < rect.height) {
                            short pixClass = this.pixClassification[(y + rect.y) * this.width + (x2 + rect.x)];
                            if (pixClass == tissue) {
                                d = (double)this.pix[(y + rect.y) * this.width + (x2 + rect.x)] - avGray;
                                sum += d * d;
                            }
                            ++y;
                        }
                        ++x2;
                    }
                    if (tissue == 2) {
                        this.stdDeviationMedulla[half][i - 1] = Math.sqrt(1.0 / (double)counter * sum);
                    }
                    if (tissue == 3) {
                        this.stdDeviationCortex[half][i - 1] = Math.sqrt(1.0 / (double)counter * sum);
                    }
                }
                ++i;
            }
        }
        if (this.analysisDialog.interpolateNullValues) {
            if (tissue == 2) {
                this.averageGrayMedulla[half] = this.interpolateNullValues(this.averageGrayMedulla[half]);
                this.stdDeviationMedulla[half] = this.interpolateNullValues(this.stdDeviationMedulla[half]);
            }
            if (tissue == 3) {
                this.averageGrayCortex[half] = this.interpolateNullValues(this.averageGrayCortex[half]);
                this.stdDeviationCortex[half] = this.interpolateNullValues(this.stdDeviationCortex[half]);
            }
        }
        if (this.startImage > 1) {
            if (tissue == 2) {
                this.averageGrayMedulla[half] = this.fillMissingValues(this.averageGrayMedulla[half]);
                this.stdDeviationMedulla[half] = this.fillMissingValues(this.stdDeviationMedulla[half]);
            }
            if (tissue == 3) {
                this.averageGrayCortex[half] = this.fillMissingValues(this.averageGrayCortex[half]);
                this.stdDeviationCortex[half] = this.fillMissingValues(this.stdDeviationCortex[half]);
            }
        }
    }

    private int getMinArrayVal(double[] data) {
        double dmin = Double.MAX_VALUE;
        int i = 0;
        while (i < data.length) {
            if (data[i] < dmin) {
                dmin = data[i];
            }
            ++i;
        }
        return (int)Math.floor(dmin);
    }

    private int getMaxArrayVal(double[] data) {
        double dmax = Double.MIN_VALUE;
        int i = 0;
        while (i < data.length) {
            if (data[i] > dmax) {
                dmax = data[i];
            }
            ++i;
        }
        return (int)Math.ceil(dmax);
    }

    private int getMaxArrayPos(double[] data) {
        double dmax = Double.MIN_VALUE;
        int pos = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > dmax) {
                dmax = data[i];
                pos = i;
            }
            ++i;
        }
        return pos;
    }

    private double[] floatingAverage(double[] data, int range) {
        double[] result = new double[data.length];
        int i = 0;
        while (i < data.length) {
            double floatingMid = 0.0;
            int j = 0;
            while (j < range) {
                int pos = i - range / 2 + j;
                if (pos < 0) {
                    pos += range;
                }
                if (pos >= data.length) {
                    pos -= range;
                }
                floatingMid += data[pos];
                ++j;
            }
            result[i] = floatingMid /= (double)range;
            ++i;
        }
        return result;
    }

    private double[] addArrays(double[] data1, double[] data2) {
        double[] result = new double[data1.length];
        int i = 0;
        while (i < data1.length) {
            result[i] = data1[i] + data2[i];
            ++i;
        }
        return result;
    }

    private double[] substArrays(double[] data1, double[] data2) {
        double[] result = new double[data1.length];
        int i = 0;
        while (i < data1.length) {
            result[i] = data1[i] - data2[i];
            if (result[i] < 0.0) {
                result[i] = 0.0;
            }
            ++i;
        }
        return result;
    }

    private double[] scaleArray(double[] data, double scaler) {
        double[] result = new double[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = data[i] * scaler;
            if (result[i] < 0.0) {
                result[i] = 0.0;
            }
            ++i;
        }
        return result;
    }

    private double[] fillMissingValues(double[] data) {
        int pos;
        double[] result = new double[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = data[i];
            ++i;
        }
        i = 0;
        while (i < data.length && data[i] < 0.001) {
            ++i;
        }
        if (i == data.length) {
            return result;
        }
        if (i > 0) {
            double firstVal = data[i];
            pos = i - 1;
            while (pos >= 0) {
                result[pos] = firstVal;
                --pos;
            }
        }
        i = 0;
        while (i < data.length && result[i] > 0.001) {
            ++i;
        }
        if (i == data.length) {
            return result;
        }
        double lastVal = data[i - 1];
        pos = i;
        while (pos < data.length) {
            result[pos] = lastVal;
            ++pos;
        }
        return result;
    }

    private double[] derivation(double[] data) {
        double[] result = new double[data.length];
        int i = 1;
        while (i < data.length - 1) {
            double gradePoint;
            double gradePrev = data[i] - data[i - 1];
            double gradeNext = data[i + 1] - data[i];
            result[i] = gradePoint = (gradePrev + gradeNext) / 2.0;
            ++i;
        }
        return result;
    }

    private double[] interpolateNullValues(double[] data) {
        double[] result = new double[data.length];
        int i = this.startImage - 1;
        while (i < data.length) {
            result[i] = data[i];
            if (data[i] < 0.001) {
                int j = i + 1;
                while (j < data.length && data[j] < 0.001) {
                    ++j;
                }
                if (j < data.length) {
                    double ascent = (data[j] - data[i - 1]) / (double)(j - (i - 1));
                    double dcounter = 1.0;
                    int pos = i;
                    while (pos < j) {
                        result[pos] = data[pos - 1] + ascent * dcounter;
                        dcounter += 1.0;
                        ++pos;
                    }
                }
                i = j - 1;
            }
            ++i;
        }
        return result;
    }

    private double calcDistance(int pointX1, int pointY1, int pointX2, int pointY2) {
        return Math.sqrt((double)((pointX1 - pointX2) * (pointX1 - pointX2)) + (double)((pointY1 - pointY2) * (pointY1 - pointY2)));
    }

    public void setAdjustmentRange(double min, double max) {
        this.adjustmentMin = min;
        this.adjustmentMax = max;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }
}

