/*
 * Decompiled with CFR 0.152.
 */
package jm.sit;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.gui.MultiLineLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import jm.extension.ExJButton;
import jm.sit.ImageLabel;
import jm.sit.JLabelResults;
import jm.sit.SITAdjuster;
import jm.sit.SITAnalysis;
import jm.util.GridBagConstraints2;

public class SITResults
extends JFrame
implements ActionListener,
MouseListener {
    private SITAnalysis sitAnalysis = null;
    private SITAdjuster sitAdjuster = null;
    private Image rightImage = null;
    private Image leftImage = null;
    private MediaTracker mediaTracker = new MediaTracker(this);
    public boolean okPressed = false;
    private String dialogTitle = " SIT - Results";
    private Rectangle rec = null;
    private Dimension CurveSize = new Dimension(400, 190);
    private double[] averageGrayLeft = null;
    private double[] averageGrayRight = null;
    private double[] standardDevLeft = null;
    private double[] standardDevRight = null;
    private double[] medullaAverageLeft = null;
    private double[] medullaAverageRight = null;
    private double[] medullaDevLeft = null;
    private double[] medullaDevRight = null;
    private double[] cortexAverageLeft = null;
    private double[] cortexAverageRight = null;
    private double[] cortexDevLeft = null;
    private double[] cortexDevRight = null;
    private Color myYellow = new Color(243, 239, 118);
    private Color myRed = new Color(227, 75, 75);
    private ImageWindow winLeft = null;
    private ImageWindow winRight = null;
    private double adjustmentMin = 0.5;
    private double adjustmentMax = 1.5;
    JPanel jPanelMain = new JPanel();
    GridBagLayout gridBagLayoutMainPanel = new GridBagLayout();
    JLabelResults jLabelResultsKidney = new JLabelResults();
    JLabelResults jLabelResultsMedulla = new JLabelResults();
    JLabelResults jLabelResultsCortex = new JLabelResults();
    JLabel jLabelXMinKidney = new JLabel();
    JLabel jLabelXMaxKidney = new JLabel();
    JLabel jLabelYMaxKidney = new JLabel();
    JLabel jLabelYMinKidney = new JLabel();
    JLabel jLabelXMinMedulla = new JLabel();
    JLabel jLabelXMaxMedulla = new JLabel();
    JLabel jLabelYMaxMedulla = new JLabel();
    JLabel jLabelYMinMedulla = new JLabel();
    JLabel jLabelXMinCortex = new JLabel();
    JLabel jLabelXMaxCortex = new JLabel();
    JLabel jLabelYMinCortex = new JLabel();
    JLabel jLabelYMaxCortex = new JLabel();
    JLabel jLabelXTextKidney = new JLabel();
    JLabel jLabelXTextMedulla = new JLabel();
    JLabel jLabelXTextCortex = new JLabel();
    JLabel jLabelHeadlineKidney = new JLabel();
    JLabel jLabelHeadlineMedulla = new JLabel();
    JLabel jLabelHeadlineCortex = new JLabel();
    JLabel jLabelDummyKidneyYAxis = new JLabel();
    JLabel jLabelDummyMedullaYAxis = new JLabel();
    JLabel jLabelDummyXAxis = new JLabel();
    JLabel jLabelDummyCortexYAxis1 = new JLabel();
    JPanel jPanelButtons = new JPanel();
    GridBagLayout gridBagLayoutButtonPanel = new GridBagLayout();
    JRadioButton jCheckBoxDeviationMain = new JRadioButton();
    JRadioButton jCheckBoxDeviationMedulla = new JRadioButton();
    JRadioButton jCheckBoxSmoothMain = new JRadioButton();
    JRadioButton jCheckBoxShowMarksMain = new JRadioButton();
    ExJButton jButtonOk = new ExJButton();
    ExJButton jButtonTextExport = new ExJButton();
    ExJButton jButtonAdjustParameters = new ExJButton();
    JPanel jPanelImages = new JPanel();
    GridBagLayout gridBagLayoutImagePanel = new GridBagLayout();
    ImageLabel jImageLabelRight = null;
    ImageLabel jImageLabelLeft = null;
    MultiLineLabel jLabelYTextLeft = new MultiLineLabel("left\nkidney\n\n(2 x zoom)");
    MultiLineLabel jLabelYTextRight = new MultiLineLabel("right\nkidney\n\n(2 x zoom)");
    JLabel jLabelDummyButton = new JLabel();
    JLabel jLabelMainButtons = new JLabel();
    JRadioButton jCheckBoxSmoothMedulla = new JRadioButton();
    JRadioButton jCheckBoxShowMarksMedulla = new JRadioButton();
    JRadioButton jCheckBoxDeviationCortex = new JRadioButton();
    JRadioButton jCheckBoxSmoothCortex = new JRadioButton();
    JRadioButton jCheckBoxShowMarksCortex = new JRadioButton();
    JLabel jLabelMedullaButtons = new JLabel();
    JLabel jLabelCortexButtons = new JLabel();

    public SITResults(SITAnalysis SITdlg, ImagePlus imgL, ImagePlus imgR) {
        try {
            this.sitAnalysis = SITdlg;
            this.rightImage = this.getScaledImage(imgR, 2.0);
            this.leftImage = this.getScaledImage(imgL, 2.0);
            this.jbInit();
            this.guiInit();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jImageLabelRight = new ImageLabel(this.rightImage);
        this.jImageLabelLeft = new ImageLabel(this.leftImage);
        this.setBackground(Color.black);
        this.setForeground(Color.lightGray);
        this.jPanelMain.setLayout(this.gridBagLayoutMainPanel);
        this.jPanelMain.setForeground(Color.lightGray);
        this.jPanelMain.setBackground(Color.black);
        this.jLabelResultsKidney.setText("gray value");
        this.jLabelResultsKidney.setForeground(Color.white);
        this.jLabelResultsKidney.setPreferredSize(this.CurveSize);
        this.jLabelResultsKidney.setMinimumSize(this.CurveSize);
        this.jLabelResultsKidney.setMaximumSize(this.CurveSize);
        this.jLabelResultsKidney.setBackground(Color.black);
        this.jLabelResultsKidney.setOpaque(true);
        this.jLabelXMinKidney.setText("   0");
        this.jLabelXMaxKidney.setText(" 180");
        this.jLabelYMaxKidney.setText("  42");
        this.jLabelYMinKidney.setText("   0");
        this.jLabelYMaxMedulla.setText("  42");
        this.jLabelResultsMedulla.setText("gray value");
        this.jLabelResultsMedulla.setPreferredSize(this.CurveSize);
        this.jLabelResultsMedulla.setMinimumSize(this.CurveSize);
        this.jLabelResultsMedulla.setMaximumSize(this.CurveSize);
        this.jLabelResultsMedulla.setForeground(Color.white);
        this.jLabelResultsMedulla.setBackground(Color.black);
        this.jLabelResultsMedulla.setOpaque(true);
        this.jLabelResultsCortex.setPreferredSize(this.CurveSize);
        this.jLabelResultsCortex.setMinimumSize(this.CurveSize);
        this.jLabelResultsCortex.setMaximumSize(this.CurveSize);
        this.jLabelResultsCortex.setForeground(Color.white);
        this.jLabelResultsCortex.setBackground(Color.black);
        this.jLabelResultsCortex.setOpaque(true);
        this.jLabelResultsCortex.setText("gray value");
        this.jLabelYMinMedulla.setText("   0");
        this.jLabelXMinMedulla.setText("   0");
        this.jLabelXMaxMedulla.setText(" 180");
        this.jButtonOk.setMargin(new Insets(0, 4, 0, 4));
        this.jButtonOk.setForeground(Color.lightGray);
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setBackground(Color.darkGray);
        this.jButtonOk.setFont(new Font("Dialog", 1, 11));
        this.jButtonOk.setOpaque(true);
        this.jButtonTextExport.setMargin(new Insets(0, 4, 0, 4));
        this.jButtonTextExport.setForeground(Color.lightGray);
        this.jButtonTextExport.setText("Export Values");
        this.jButtonTextExport.setBackground(Color.darkGray);
        this.jButtonTextExport.setFont(new Font("Dialog", 1, 11));
        this.jButtonTextExport.setOpaque(true);
        this.jButtonAdjustParameters.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonAdjustParameters.setForeground(Color.lightGray);
        this.jButtonAdjustParameters.setText("Adjust Parameters");
        this.jButtonAdjustParameters.setBackground(Color.darkGray);
        this.jButtonAdjustParameters.setFont(new Font("Dialog", 1, 11));
        this.jButtonAdjustParameters.setOpaque(true);
        this.jLabelYTextLeft.setForeground(Color.lightGray);
        this.jLabelYTextLeft.setBackground(Color.black);
        this.jLabelYTextLeft.setFont(new Font("Dialog", 1, 11));
        this.jLabelYTextRight.setForeground(Color.lightGray);
        this.jLabelYTextRight.setBackground(Color.black);
        this.jLabelYTextRight.setFont(new Font("Dialog", 1, 11));
        this.jLabelDummyButton.setText("      ");
        this.jLabelDummyButton.setBackground(Color.black);
        this.jLabelMainButtons.setText("whole kidney");
        this.jLabelMainButtons.setForeground(Color.lightGray);
        this.jLabelMainButtons.setBackground(Color.black);
        this.jLabelMainButtons.setFont(new Font("Dialog", 1, 11));
        this.jLabelXTextKidney.setText("time (sec.)");
        this.jLabelXTextMedulla.setText("time (sec.)");
        this.jLabelXMaxKidney.setFont(new Font("Monospaced", 0, 10));
        this.jLabelHeadlineMedulla.setText("results medulla");
        this.jLabelHeadlineMedulla.setForeground(Color.lightGray);
        this.jLabelHeadlineMedulla.setFont(new Font("Dialog", 1, 11));
        this.jLabelHeadlineCortex.setText("results cortex");
        this.jLabelHeadlineCortex.setForeground(Color.lightGray);
        this.jLabelHeadlineCortex.setFont(new Font("Dialog", 1, 11));
        this.jLabelXMaxKidney.setForeground(Color.white);
        this.jLabelXMinKidney.setFont(new Font("Monospaced", 0, 10));
        this.jLabelXMinKidney.setForeground(Color.white);
        this.jLabelXMaxMedulla.setFont(new Font("Monospaced", 0, 10));
        this.jLabelXMaxMedulla.setForeground(Color.white);
        this.jLabelXMinMedulla.setFont(new Font("Monospaced", 0, 10));
        this.jLabelXMinMedulla.setForeground(Color.white);
        this.jLabelYMaxKidney.setFont(new Font("Monospaced", 0, 10));
        this.jLabelYMaxKidney.setForeground(Color.white);
        this.jLabelYMinKidney.setFont(new Font("Monospaced", 0, 10));
        this.jLabelYMinKidney.setForeground(Color.white);
        this.jLabelYMaxMedulla.setFont(new Font("Monospaced", 0, 10));
        this.jLabelYMaxMedulla.setForeground(Color.white);
        this.jLabelYMinMedulla.setFont(new Font("Monospaced", 0, 10));
        this.jLabelYMinMedulla.setForeground(Color.white);
        this.jLabelXTextKidney.setFont(new Font("Dialog", 0, 10));
        this.jLabelXTextKidney.setForeground(Color.white);
        this.jLabelXTextMedulla.setFont(new Font("Dialog", 0, 10));
        this.jLabelXTextMedulla.setForeground(Color.white);
        this.jCheckBoxDeviationMedulla.setRequestFocusEnabled(false);
        this.jCheckBoxDeviationMedulla.setForeground(Color.lightGray);
        this.jCheckBoxDeviationMedulla.setText("standard deviation");
        this.jCheckBoxSmoothMedulla.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxSmoothMedulla.setOpaque(false);
        this.jCheckBoxSmoothMedulla.setFocusPainted(false);
        this.jCheckBoxSmoothMedulla.setRequestFocusEnabled(false);
        this.jCheckBoxSmoothMedulla.setForeground(Color.lightGray);
        this.jCheckBoxSmoothMedulla.setText("smooth graph");
        this.jCheckBoxSmoothMedulla.setBackground(Color.darkGray);
        this.jCheckBoxShowMarksMedulla.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxShowMarksMedulla.setOpaque(false);
        this.jCheckBoxShowMarksMedulla.setFocusPainted(false);
        this.jCheckBoxShowMarksMedulla.setRequestFocusEnabled(false);
        this.jCheckBoxShowMarksMedulla.setForeground(Color.lightGray);
        this.jCheckBoxShowMarksMedulla.setText("show marks");
        this.jCheckBoxShowMarksMedulla.setBackground(Color.darkGray);
        this.jCheckBoxDeviationCortex.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxDeviationCortex.setOpaque(false);
        this.jCheckBoxDeviationCortex.setFocusPainted(false);
        this.jCheckBoxDeviationCortex.setRequestFocusEnabled(false);
        this.jCheckBoxDeviationCortex.setContentAreaFilled(false);
        this.jCheckBoxDeviationCortex.setForeground(Color.lightGray);
        this.jCheckBoxDeviationCortex.setText("standard deviation");
        this.jCheckBoxDeviationCortex.setBackground(Color.darkGray);
        this.jCheckBoxSmoothCortex.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxSmoothCortex.setOpaque(false);
        this.jCheckBoxSmoothCortex.setFocusPainted(false);
        this.jCheckBoxSmoothCortex.setRequestFocusEnabled(false);
        this.jCheckBoxSmoothCortex.setForeground(Color.lightGray);
        this.jCheckBoxSmoothCortex.setText("smooth graph");
        this.jCheckBoxSmoothCortex.setBackground(Color.darkGray);
        this.jCheckBoxShowMarksCortex.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxShowMarksCortex.setOpaque(false);
        this.jCheckBoxShowMarksCortex.setFocusPainted(false);
        this.jCheckBoxShowMarksCortex.setRequestFocusEnabled(false);
        this.jCheckBoxShowMarksCortex.setForeground(Color.lightGray);
        this.jCheckBoxShowMarksCortex.setText("show marks");
        this.jCheckBoxShowMarksCortex.setBackground(Color.darkGray);
        this.jCheckBoxDeviationMedulla.setBackground(Color.darkGray);
        this.jCheckBoxDeviationMain.setRequestFocusEnabled(false);
        this.jCheckBoxDeviationMain.setForeground(Color.lightGray);
        this.jCheckBoxDeviationMain.setText("standard deviation");
        this.jCheckBoxDeviationMain.setBackground(Color.darkGray);
        this.jCheckBoxDeviationMain.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxDeviationMain.setOpaque(false);
        this.jCheckBoxDeviationMain.setFocusPainted(false);
        this.jCheckBoxSmoothMain.setRequestFocusEnabled(false);
        this.jCheckBoxSmoothMain.setForeground(Color.lightGray);
        this.jCheckBoxSmoothMain.setText("smooth graph");
        this.jCheckBoxSmoothMain.setBackground(Color.darkGray);
        this.jCheckBoxShowMarksMain.setForeground(Color.lightGray);
        this.jCheckBoxShowMarksMain.setText("show marks");
        this.jCheckBoxShowMarksMain.setBackground(Color.darkGray);
        this.jCheckBoxDeviationMedulla.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxDeviationMedulla.setOpaque(false);
        this.jCheckBoxDeviationMedulla.setFocusPainted(false);
        this.jCheckBoxShowMarksMain.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxShowMarksMain.setOpaque(false);
        this.jCheckBoxSmoothMain.setFont(new Font("Dialog", 1, 11));
        this.jCheckBoxSmoothMain.setOpaque(false);
        this.jCheckBoxSmoothMain.setFocusPainted(false);
        this.jImageLabelRight.setBackground(Color.black);
        this.jImageLabelLeft.setBackground(Color.black);
        this.jPanelImages.setBackground(Color.black);
        this.jPanelImages.setMinimumSize(new Dimension(40, 10));
        this.jPanelImages.setLayout(this.gridBagLayoutImagePanel);
        this.jPanelImages.setBorder(new LineBorder(Color.black, 7));
        this.jPanelButtons.setLayout(this.gridBagLayoutButtonPanel);
        this.jPanelButtons.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        this.jLabelResultsCortex.setText("gray value");
        this.jLabelXTextCortex.setText("time (sec.)");
        this.jLabelXTextCortex.setFont(new Font("Dialog", 0, 10));
        this.jLabelYMaxCortex.setText("  42");
        this.jLabelYMaxCortex.setFont(new Font("Monospaced", 0, 10));
        this.jLabelDummyKidneyYAxis.setText(" ");
        this.jLabelDummyMedullaYAxis.setText(" ");
        this.jLabelDummyXAxis.setText("       ");
        this.jLabelDummyCortexYAxis1.setText(" ");
        this.jPanelButtons.setForeground(Color.lightGray);
        this.jPanelButtons.setBackground(Color.black);
        this.jLabelYMinCortex.setText("   0");
        this.jLabelYMinCortex.setFont(new Font("Monospaced", 0, 10));
        this.jLabelXMinCortex.setText("   0");
        this.jLabelXMinCortex.setFont(new Font("Monospaced", 0, 10));
        this.jLabelXMaxCortex.setText(" 180");
        this.jLabelXMaxCortex.setFont(new Font("Monospaced", 0, 10));
        this.jLabelHeadlineKidney.setText("results whole kidney");
        this.jLabelHeadlineKidney.setFont(new Font("Dialog", 1, 11));
        this.jLabelHeadlineKidney.setForeground(Color.lightGray);
        this.jLabelXMaxCortex.setForeground(Color.white);
        this.jLabelXMaxCortex.setBackground(Color.black);
        this.jLabelXMinCortex.setForeground(Color.white);
        this.jLabelXMinCortex.setBackground(Color.black);
        this.jLabelYMinCortex.setForeground(Color.white);
        this.jLabelYMinCortex.setBackground(Color.black);
        this.jLabelYMaxCortex.setForeground(Color.white);
        this.jLabelYMaxCortex.setBackground(Color.black);
        this.jLabelXTextCortex.setForeground(Color.white);
        this.jLabelXTextCortex.setBackground(Color.black);
        this.jLabelMedullaButtons.setText("medulla");
        this.jLabelMedullaButtons.setForeground(Color.lightGray);
        this.jLabelMedullaButtons.setBackground(Color.black);
        this.jLabelMedullaButtons.setFont(new Font("Dialog", 1, 11));
        this.jLabelCortexButtons.setText("cortex");
        this.jLabelCortexButtons.setForeground(Color.lightGray);
        this.jLabelCortexButtons.setBackground(Color.black);
        this.jLabelCortexButtons.setFont(new Font("Dialog", 1, 11));
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelMain.add((Component)this.jLabelResultsKidney, new GridBagConstraints2(2, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelHeadlineKidney, new GridBagConstraints2(2, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXMinKidney, new GridBagConstraints2(2, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXMaxKidney, new GridBagConstraints2(4, 4, 2, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelYMaxKidney, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelYMinKidney, new GridBagConstraints2(1, 3, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelYMaxMedulla, new GridBagConstraints2(1, 13, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelResultsMedulla, new GridBagConstraints2(2, 13, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelYMinCortex, new GridBagConstraints2(1, 9, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelYMinMedulla, new GridBagConstraints2(1, 15, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXMinCortex, new GridBagConstraints2(2, 10, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXMinMedulla, new GridBagConstraints2(2, 16, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXMaxCortex, new GridBagConstraints2(4, 10, 2, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXMaxMedulla, new GridBagConstraints2(4, 16, 2, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXTextKidney, new GridBagConstraints2(2, 5, 4, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXTextCortex, new GridBagConstraints2(2, 11, 4, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelXTextMedulla, new GridBagConstraints2(2, 17, 4, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jPanelImages, new GridBagConstraints2(0, 0, 1, 18, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelImages.add((Component)this.jImageLabelRight, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelImages.add((Component)this.jLabelYTextRight, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelImages.add((Component)this.jImageLabelLeft, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelImages.add((Component)this.jLabelYTextLeft, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jPanelButtons, new GridBagConstraints2(7, 2, 1, 15, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxDeviationMain, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxDeviationMedulla, new GridBagConstraints2(0, 9, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxSmoothMain, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxShowMarksMain, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 140, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonAdjustParameters, new GridBagConstraints2(0, 12, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonTextExport, new GridBagConstraints2(0, 13, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonOk, new GridBagConstraints2(0, 14, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jLabelMainButtons, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxSmoothMedulla, new GridBagConstraints2(0, 10, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxShowMarksMedulla, new GridBagConstraints2(0, 11, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 50, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxDeviationCortex, new GridBagConstraints2(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxSmoothCortex, new GridBagConstraints2(0, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jCheckBoxShowMarksCortex, new GridBagConstraints2(0, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 140, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jLabelMedullaButtons, new GridBagConstraints2(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelButtons.add((Component)this.jLabelCortexButtons, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelMain.add((Component)this.jLabelResultsCortex, new GridBagConstraints2(2, 7, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 15), 0, 0));
        this.jPanelMain.add((Component)this.jLabelYMaxCortex, new GridBagConstraints2(1, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelDummyKidneyYAxis, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelDummyCortexYAxis1, new GridBagConstraints2(1, 14, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelDummyMedullaYAxis, new GridBagConstraints2(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelDummyXAxis, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelHeadlineMedulla, new GridBagConstraints2(2, 12, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelHeadlineCortex, new GridBagConstraints2(2, 6, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelDummyButton, new GridBagConstraints2(6, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void guiInit() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
        this.jButtonOk.addActionListener(this);
        this.jButtonTextExport.addActionListener(this);
        this.jButtonAdjustParameters.addActionListener(this);
        this.jCheckBoxDeviationMain.addActionListener(this);
        this.jCheckBoxSmoothMain.addActionListener(this);
        this.jCheckBoxShowMarksMain.addActionListener(this);
        this.jCheckBoxDeviationMedulla.addActionListener(this);
        this.jCheckBoxSmoothMedulla.addActionListener(this);
        this.jCheckBoxShowMarksMedulla.addActionListener(this);
        this.jCheckBoxDeviationCortex.addActionListener(this);
        this.jCheckBoxSmoothCortex.addActionListener(this);
        this.jCheckBoxShowMarksCortex.addActionListener(this);
        this.jImageLabelRight.addMouseListener(this);
        this.jImageLabelLeft.addMouseListener(this);
        this.jLabelResultsKidney.setAverageCurveColor(Color.lightGray);
        this.jLabelResultsKidney.setDeviationCurveColor(Color.white);
        this.jLabelResultsMedulla.setAverageCurveColor(this.myRed);
        this.jLabelResultsMedulla.setDeviationCurveColor(Color.red);
        this.jLabelResultsCortex.setAverageCurveColor(this.myYellow);
        this.jLabelResultsCortex.setDeviationCurveColor(Color.yellow);
        this.jLabelHeadlineMedulla.setForeground(this.myRed);
        this.jLabelHeadlineCortex.setForeground(this.myYellow);
        this.jCheckBoxDeviationMain.setSelected(false);
        this.jCheckBoxSmoothMain.setSelected(false);
        this.jCheckBoxShowMarksMain.setSelected(true);
        this.jCheckBoxDeviationMedulla.setSelected(false);
        this.jCheckBoxSmoothMedulla.setSelected(false);
        this.jCheckBoxShowMarksMedulla.setSelected(true);
        this.jCheckBoxDeviationCortex.setSelected(false);
        this.jCheckBoxSmoothCortex.setSelected(false);
        this.jCheckBoxShowMarksCortex.setSelected(true);
        this.jLabelResultsKidney.showAverageGrayValues(true);
        this.jLabelResultsMedulla.showAverageGrayValues(true);
        this.jLabelResultsCortex.showAverageGrayValues(true);
        this.jLabelResultsKidney.showStandardDeviationValues(false);
        this.jLabelResultsMedulla.showStandardDeviationValues(false);
        this.jLabelResultsCortex.showStandardDeviationValues(false);
        this.jLabelResultsKidney.showMarks(true);
        this.jLabelResultsMedulla.showMarks(true);
        this.jLabelResultsCortex.showMarks(true);
        this.updateMainFrame(false);
        Rectangle rec = this.getBounds();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screensize.width - rec.width) / 2, (screensize.height - rec.height) / 2);
        this.setVisible(true);
    }

    public void updateMainFrame(boolean resizeable) {
        Point p = this.getLocation();
        this.setTitle(this.dialogTitle);
        this.pack();
        Rectangle rec = this.getBounds();
        rec.width += 10;
        rec.height += 10;
        this.setBounds(rec);
        this.setResizable(resizeable);
        this.setLocation(p);
        IJ.wait((int)150);
    }

    public void setXScale(int tissue, int min, int max) {
        JLabel textMin = null;
        JLabel textMax = null;
        JLabelResults res = null;
        if (tissue == 5) {
            textMin = this.jLabelXMinKidney;
            textMax = this.jLabelXMaxKidney;
            res = this.jLabelResultsKidney;
        }
        if (tissue == 2) {
            textMin = this.jLabelXMinMedulla;
            textMax = this.jLabelXMaxMedulla;
            res = this.jLabelResultsMedulla;
        }
        if (tissue == 3) {
            textMin = this.jLabelXMinCortex;
            textMax = this.jLabelXMaxCortex;
            res = this.jLabelResultsCortex;
        }
        if (min > max) {
            int t = min;
            min = max;
            max = t;
        }
        textMin.setText(Integer.toString(min));
        textMax.setText(this.int2String(max));
        res.setXScale(min, max);
        this.repaint();
    }

    public void setYScale(int tissue, double[] data) {
        JLabel textMin = null;
        JLabel textMax = null;
        JLabelResults res = null;
        double dmin = Double.MAX_VALUE;
        double dmax = Double.MIN_VALUE;
        if (tissue == 5) {
            textMin = this.jLabelYMinKidney;
            textMax = this.jLabelYMaxKidney;
            res = this.jLabelResultsKidney;
        }
        if (tissue == 2) {
            textMin = this.jLabelYMinMedulla;
            textMax = this.jLabelYMaxMedulla;
            res = this.jLabelResultsMedulla;
        }
        if (tissue == 3) {
            textMin = this.jLabelYMinCortex;
            textMax = this.jLabelYMaxCortex;
            res = this.jLabelResultsCortex;
        }
        int i = 0;
        try {
            while (data[i] != Double.NEGATIVE_INFINITY) {
                if (data[i] < dmin) {
                    dmin = data[i];
                }
                if (data[i] > dmax) {
                    dmax = data[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int min = (int)Math.floor(dmin) - 1;
        int max = (int)Math.ceil(dmax) + 1;
        textMin.setText(this.int2String(min));
        textMax.setText(this.int2String(max));
        res.setYScale(min, max);
        this.repaint();
    }

    public void setYScale(int tissue, int min, int max) {
        JLabel textMin = null;
        JLabel textMax = null;
        JLabelResults res = null;
        if (tissue == 5) {
            textMin = this.jLabelYMinKidney;
            textMax = this.jLabelYMaxKidney;
            res = this.jLabelResultsKidney;
        }
        if (tissue == 2) {
            textMin = this.jLabelYMinMedulla;
            textMax = this.jLabelYMaxMedulla;
            res = this.jLabelResultsMedulla;
        }
        if (tissue == 3) {
            textMin = this.jLabelYMinCortex;
            textMax = this.jLabelYMaxCortex;
            res = this.jLabelResultsCortex;
        }
        if (min > max) {
            int t = min;
            min = max;
            max = t;
        }
        textMin.setText(this.int2String(min));
        textMax.setText(this.int2String(max));
        res.setYScale(min, max);
        this.repaint();
    }

    public void setXScale(int tissue, double[] data) {
        JLabel textMin = null;
        JLabel textMax = null;
        JLabelResults res = null;
        if (tissue == 5) {
            textMin = this.jLabelXMinKidney;
            textMax = this.jLabelXMaxKidney;
            res = this.jLabelResultsKidney;
        }
        if (tissue == 2) {
            textMin = this.jLabelXMinMedulla;
            textMax = this.jLabelXMaxMedulla;
            res = this.jLabelResultsMedulla;
        }
        if (tissue == 3) {
            textMin = this.jLabelXMinCortex;
            textMax = this.jLabelXMaxCortex;
            res = this.jLabelResultsCortex;
        }
        int i = 0;
        try {
            while (data[i] != Double.NEGATIVE_INFINITY) {
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int max = --i * 2;
        textMin.setText("0");
        textMax.setText(this.int2String(max));
        res.setXScale(0, max);
        this.repaint();
    }

    public void setYText(int tissue, String text) {
        JLabelResults textY = null;
        if (tissue == 5) {
            textY = this.jLabelResultsKidney;
        }
        if (tissue == 2) {
            textY = this.jLabelResultsMedulla;
        }
        if (tissue == 3) {
            textY = this.jLabelResultsCortex;
        }
        if (text != null) {
            textY.setText(text);
        }
    }

    public void setXText(int tissue, String text) {
        JLabel textX = null;
        if (tissue == 5) {
            textX = this.jLabelXTextKidney;
        }
        if (tissue == 2) {
            textX = this.jLabelXTextMedulla;
        }
        if (tissue == 3) {
            textX = this.jLabelXTextCortex;
        }
        if (text != null) {
            textX.setText(text);
        }
    }

    public void setXMarks(int tissue, int marks) {
        if (tissue == 5) {
            this.jLabelResultsKidney.setXMarks(marks);
        }
        if (tissue == 2) {
            this.jLabelResultsMedulla.setXMarks(marks);
        }
        if (tissue == 3) {
            this.jLabelResultsCortex.setXMarks(marks);
        }
    }

    public void setYMarks(int tissue, int marks) {
        if (tissue == 5) {
            this.jLabelResultsKidney.setYMarks(marks);
        }
        if (tissue == 2) {
            this.jLabelResultsMedulla.setYMarks(marks);
        }
        if (tissue == 3) {
            this.jLabelResultsCortex.setYMarks(marks);
        }
    }

    public void setSmooth(boolean smooth) {
        this.jCheckBoxSmoothMain.setSelected(smooth);
        this.jCheckBoxSmoothMedulla.setSelected(smooth);
        this.jCheckBoxSmoothCortex.setSelected(smooth);
        this.smoothCurves(smooth, 5);
        this.smoothCurves(smooth, 2);
        this.smoothCurves(smooth, 3);
    }

    public void setDevScaleFactor(double s, int tissue) {
        if (tissue == 5) {
            this.jLabelResultsKidney.setDevScaleFactor(s);
        }
        if (tissue == 2) {
            this.jLabelResultsMedulla.setDevScaleFactor(s);
        }
        if (tissue == 3) {
            this.jLabelResultsCortex.setDevScaleFactor(s);
        }
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        Object src = evt.getSource();
        if (evt.getModifiers() == 16 && evt.getClickCount() == 2) {
            ImagePlus newImage;
            if (src == this.jImageLabelLeft && this.winLeft == null) {
                newImage = new ImagePlus("left kidney (classifications)", this.leftImage);
                this.winLeft = new ImageWindow(newImage);
                this.winLeft.show();
            }
            if (src == this.jImageLabelRight && this.winRight == null) {
                newImage = new ImagePlus("right kidney (classifications)", this.rightImage);
                this.winRight = new ImageWindow(newImage);
                this.winRight.show();
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.jLabelResultsKidney.repaint();
        this.jLabelResultsMedulla.repaint();
        this.jLabelResultsCortex.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            if (src == this.jButtonTextExport) {
                this.exportValues();
            }
            if (src == this.jButtonOk) {
                this.okPressed = true;
                this.setVisible(false);
                this.dispose();
            }
            if (src == this.jButtonAdjustParameters) {
                this.adjustParameters();
            }
        }
        if (src instanceof JRadioButton) {
            boolean status = false;
            if (src == this.jCheckBoxDeviationMain) {
                status = this.jCheckBoxDeviationMain.isSelected();
                this.sitAnalysis.devScaleFactor = status ? 1.0 : 0.001;
                this.sitAnalysis.setMinMaxAxisValues(5);
                this.jLabelResultsKidney.showStandardDeviationValues(status);
            }
            if (src == this.jCheckBoxSmoothMain) {
                status = this.jCheckBoxSmoothMain.isSelected();
                this.smoothCurves(status, 5);
            }
            if (src == this.jCheckBoxShowMarksMain) {
                status = this.jCheckBoxShowMarksMain.isSelected();
                this.jLabelResultsKidney.showMarks(status);
            }
            if (src == this.jCheckBoxDeviationMedulla) {
                status = this.jCheckBoxDeviationMedulla.isSelected();
                this.sitAnalysis.devScaleFactor = status ? 1.0 : 0.001;
                this.sitAnalysis.setMinMaxAxisValues(2);
                this.jLabelResultsMedulla.showStandardDeviationValues(status);
            }
            if (src == this.jCheckBoxSmoothMedulla) {
                status = this.jCheckBoxSmoothMedulla.isSelected();
                this.smoothCurves(status, 2);
            }
            if (src == this.jCheckBoxShowMarksMedulla) {
                status = this.jCheckBoxShowMarksMedulla.isSelected();
                this.jLabelResultsMedulla.showMarks(status);
            }
            if (src == this.jCheckBoxDeviationCortex) {
                status = this.jCheckBoxDeviationCortex.isSelected();
                this.sitAnalysis.devScaleFactor = status ? 1.0 : 0.001;
                this.sitAnalysis.setMinMaxAxisValues(3);
                this.jLabelResultsCortex.showStandardDeviationValues(status);
            }
            if (src == this.jCheckBoxSmoothCortex) {
                status = this.jCheckBoxSmoothCortex.isSelected();
                this.smoothCurves(status, 3);
            }
            if (src == this.jCheckBoxShowMarksCortex) {
                status = this.jCheckBoxShowMarksCortex.isSelected();
                this.jLabelResultsCortex.showMarks(status);
            }
        }
    }

    public void setAverageGray(int half, int tissue, double[] data) {
        if (data != null) {
            if (half == 0) {
                if (tissue == 5) {
                    this.averageGrayLeft = data;
                    this.jLabelResultsKidney.setAverageGray(half, data);
                }
                if (tissue == 2) {
                    this.medullaAverageLeft = data;
                    this.jLabelResultsMedulla.setAverageGray(half, data);
                }
                if (tissue == 3) {
                    this.cortexAverageLeft = data;
                    this.jLabelResultsCortex.setAverageGray(half, data);
                }
            }
            if (half == 1) {
                if (tissue == 5) {
                    this.averageGrayRight = data;
                    this.jLabelResultsKidney.setAverageGray(half, data);
                }
                if (tissue == 2) {
                    this.medullaAverageRight = data;
                    this.jLabelResultsMedulla.setAverageGray(half, data);
                }
                if (tissue == 3) {
                    this.cortexAverageRight = data;
                    this.jLabelResultsCortex.setAverageGray(half, data);
                }
            }
        }
    }

    public void setStandardDeviation(int half, int tissue, double[] data) {
        if (data != null) {
            if (half == 0) {
                if (tissue == 5) {
                    this.standardDevLeft = data;
                    this.jLabelResultsKidney.setStandardDeviation(half, data);
                }
                if (tissue == 2) {
                    this.medullaDevLeft = data;
                    this.jLabelResultsMedulla.setStandardDeviation(half, data);
                }
                if (tissue == 3) {
                    this.cortexDevLeft = data;
                    this.jLabelResultsCortex.setStandardDeviation(half, data);
                }
            } else {
                if (tissue == 5) {
                    this.standardDevRight = data;
                    this.jLabelResultsKidney.setStandardDeviation(half, data);
                }
                if (tissue == 2) {
                    this.medullaDevRight = data;
                    this.jLabelResultsMedulla.setStandardDeviation(half, data);
                }
                if (tissue == 3) {
                    this.cortexDevRight = data;
                    this.jLabelResultsCortex.setStandardDeviation(half, data);
                }
            }
        }
    }

    private String int2String(int value) {
        String result = Integer.toString(Math.abs(value));
        while (result.length() < 4) {
            result = " " + result;
        }
        return result;
    }

    public void smoothCurves(boolean smooth, int tissue) {
        if (smooth) {
            int smoothRange = 3;
            if (tissue == 5) {
                this.jLabelResultsKidney.setAverageGray(0, this.floatingAverage(this.averageGrayLeft, smoothRange));
                this.jLabelResultsKidney.setAverageGray(1, this.floatingAverage(this.averageGrayRight, smoothRange));
            }
            if (tissue == 2) {
                this.jLabelResultsMedulla.setAverageGray(0, this.floatingAverage(this.medullaAverageLeft, smoothRange));
                this.jLabelResultsMedulla.setAverageGray(1, this.floatingAverage(this.medullaAverageRight, smoothRange));
            }
            if (tissue == 3) {
                this.jLabelResultsCortex.setAverageGray(0, this.floatingAverage(this.cortexAverageLeft, smoothRange));
                this.jLabelResultsCortex.setAverageGray(1, this.floatingAverage(this.cortexAverageRight, smoothRange));
            }
        } else {
            this.jLabelResultsKidney.setAverageGray(0, this.averageGrayLeft);
            this.jLabelResultsKidney.setAverageGray(1, this.averageGrayRight);
            this.jLabelResultsMedulla.setAverageGray(0, this.medullaAverageLeft);
            this.jLabelResultsMedulla.setAverageGray(1, this.medullaAverageRight);
            this.jLabelResultsCortex.setAverageGray(0, this.cortexAverageLeft);
            this.jLabelResultsCortex.setAverageGray(1, this.cortexAverageRight);
        }
    }

    public void exportValues() {
        int length = 0;
        if (this.averageGrayLeft != null) {
            try {
                while (this.averageGrayLeft[length] != Double.MIN_VALUE) {
                    ++length;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (length == 0 && this.averageGrayRight != null) {
            try {
                while (this.averageGrayRight[length] != Double.MIN_VALUE) {
                    ++length;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (length == 0) {
            IJ.error((String)"No data available to save !");
            return;
        }
        String path = this.getLastDir();
        File f = new File(path);
        JFileChooser saveDlg = new JFileChooser();
        File saveFile = new File(path, "*.txt");
        saveDlg.setDialogTitle(" Export Analysis Values");
        String[] tl = f.list();
        if (tl != null) {
            saveDlg.setCurrentDirectory(f);
        } else {
            saveDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        saveDlg.setFileSelectionMode(0);
        int result = saveDlg.showSaveDialog(this);
        if (result == 0) {
            saveFile = saveDlg.getSelectedFile();
            path = saveFile.getParent() + File.separator;
            this.saveActualDir(path);
            String fileName = saveFile.getName();
            String fileType = fileName.substring(fileName.length() - 4);
            if (fileType.compareTo(".txt") != 0) {
                fileName = saveFile.getAbsolutePath() + ".txt";
                saveFile = new File(fileName);
            }
            IJ.write((String)("Filename: " + saveFile.getPath() + "!" + saveFile.getName()));
            FileWriter w = null;
            try {
                w = new FileWriter(saveFile.getPath(), true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                double pixelDiv = 1.0;
                double pixelSurf = this.sitAnalysis.analysisDialog.pixelSpacingX * this.sitAnalysis.analysisDialog.pixelSpacingY;
                w.write("Renographie\t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
                w.write(" \t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("Patient:\t \t \t" + this.sitAnalysis.analysisDialog.patientName + "\t \t \tFOV (mm):\t \t \t" + this.sitAnalysis.analysisDialog.fovX + "\t" + this.sitAnalysis.analysisDialog.fovY + "\t \t \t\r\n");
                w.write("ID:\t \t \t" + this.sitAnalysis.analysisDialog.patientID + "\t \t \tMatrix:\t \t \t" + this.sitAnalysis.analysisDialog.matrixX + "\t" + this.sitAnalysis.analysisDialog.matrixY + "\t \t \t\r\n");
                w.write("Untersuchungsdatum:\t \t \t" + this.sitAnalysis.analysisDialog.studyDate + "\t \t \tPixelflaeche (mm\u00b2):\t \t \t" + this.d2s(pixelSurf, 6) + "\t \t \t \t\r\n");
                w.write("Geburtsdatum:\t \t \t" + this.sitAnalysis.analysisDialog.patientBirth + "\t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("NAST (%, Seite):\t \t \t*\t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("Geschlecht:\t \t \t" + this.sitAnalysis.analysisDialog.patientSex + "\t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("Gewicht (kg):\t \t \t" + this.sitAnalysis.analysisDialog.patientWeight + "\t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("NaCl-Infusion (ml):\t \t \t*\t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("Magnevist (ml):\t \t \t*\t \t \t \t \t \t \t \t \t \t\r\n");
                w.write(" \t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
                w.write("Originaldaten\t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
                w.write(" \tGesamtniere\t \tGesamtniere\t \tNierenrinde\t \tNierenrinde\t \tNierenmark\t \tNierenmark\t \t\r\n");
                w.write(" \t   rechts\t \t   links\t \t   rechts\t \t   links\t \t   rechts\t \t   links\t \t\r\n");
                w.write(" \tROI\tPixel\tROI\tPixel\tROI\tPixel\tROI\tPixel\tROI\tPixel\tROI\tPixel\t\r\n");
                w.write(" \t" + (int)((double)this.sitAnalysis.pixelCountKidney[0] * pixelSurf) + "\t" + (int)((double)this.sitAnalysis.pixelCountKidney[0] / pixelDiv) + "\t" + (int)((double)this.sitAnalysis.pixelCountKidney[1] * pixelSurf) + "\t" + (int)((double)this.sitAnalysis.pixelCountKidney[1] / pixelDiv) + "\t" + (int)((double)this.sitAnalysis.pixelCountCortex[0] * pixelSurf) + "\t" + (int)((double)this.sitAnalysis.pixelCountCortex[0] / pixelDiv) + "\t" + (int)((double)this.sitAnalysis.pixelCountCortex[1] * pixelSurf) + "\t" + (int)((double)this.sitAnalysis.pixelCountCortex[1] / pixelDiv) + "\t" + (int)((double)this.sitAnalysis.pixelCountMedulla[0] * pixelSurf) + "\t" + (int)((double)this.sitAnalysis.pixelCountMedulla[0] / pixelDiv) + "\t" + (int)((double)this.sitAnalysis.pixelCountMedulla[1] * pixelSurf) + "\t" + (int)((double)this.sitAnalysis.pixelCountMedulla[1] / pixelDiv) + "\t\r\n");
                w.write("Zeit\tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \t\r\n");
                w.write("(s)\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\t\r\n");
                int i = 0;
                while (i < length) {
                    if (this.sitAnalysis != null) {
                        w.write("" + this.d2s(this.sitAnalysis.acquisitionTimes[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.averageGrayLeft != null) {
                        w.write("" + this.d2s(this.averageGrayLeft[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.standardDevLeft != null) {
                        w.write("" + this.d2s(this.standardDevLeft[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.averageGrayRight != null) {
                        w.write("" + this.d2s(this.averageGrayRight[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.standardDevRight != null) {
                        w.write("" + this.d2s(this.standardDevRight[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.cortexAverageLeft != null) {
                        w.write("" + this.d2s(this.cortexAverageLeft[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.cortexDevLeft != null) {
                        w.write("" + this.d2s(this.cortexDevLeft[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.cortexAverageRight != null) {
                        w.write("" + this.d2s(this.cortexAverageRight[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.cortexDevRight != null) {
                        w.write("" + this.d2s(this.cortexDevRight[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.medullaAverageLeft != null) {
                        w.write("" + this.d2s(this.medullaAverageLeft[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.medullaDevLeft != null) {
                        w.write("" + this.d2s(this.medullaDevLeft[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.medullaAverageRight != null) {
                        w.write("" + this.d2s(this.medullaAverageRight[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    if (this.medullaDevRight != null) {
                        w.write("" + this.d2s(this.medullaDevRight[i], 1) + "\t");
                    } else {
                        w.write("-1,0\t");
                    }
                    w.write("\r\n");
                    ++i;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                ((Writer)w).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void adjustParameters() {
        if (this.sitAdjuster == null || this.sitAdjuster.finished) {
            this.sitAdjuster = new SITAdjuster(this.sitAnalysis, this.leftImage, this.rightImage);
            this.sitAdjuster.setAdjustmentRange(this.adjustmentMin, this.adjustmentMax);
        }
    }

    private String d2s(double d, int l) {
        String result = IJ.d2s((double)d, (int)l);
        result = result.replace('.', ',');
        while (result.length() > 1 && result.charAt(0) == '0' && result.charAt(1) != ',') {
            result = result.substring(1);
        }
        return result;
    }

    private double[] floatingAverage(double[] data, int range) {
        double[] result = null;
        if (data == null) {
            return result;
        }
        result = new double[data.length];
        int i = 0;
        while (i < data.length) {
            double floatingMid = 0.0;
            int j = 0;
            while (j < range) {
                int pos = i - range / 2 + j;
                if (pos < 0) {
                    pos += range;
                }
                if (pos >= data.length) {
                    pos -= range;
                }
                floatingMid += data[pos];
                ++j;
            }
            result[i] = floatingMid /= (double)range;
            ++i;
        }
        return result;
    }

    public void updateImageLabel(int half, ImagePlus img) {
        Image scaledImage = this.getScaledImage(img, 2.0);
        if (half == 0 && this.jImageLabelLeft != null) {
            this.leftImage = scaledImage;
            this.jImageLabelLeft.setImage(scaledImage);
            this.jImageLabelLeft.repaint();
        }
        if (half == 1 && this.jImageLabelRight != null) {
            this.rightImage = scaledImage;
            this.jImageLabelRight.setImage(scaledImage);
            this.jImageLabelRight.repaint();
        }
        int wmax = Math.max(this.jImageLabelLeft.getWidth(), this.jImageLabelRight.getWidth());
        int h = this.jPanelButtons.getHeight();
        Dimension dim = new Dimension(wmax, h);
        this.jPanelImages.setMinimumSize(dim);
        this.jPanelImages.setMaximumSize(dim);
        this.jPanelImages.setPreferredSize(dim);
        this.jPanelImages.repaint();
    }

    private Image getScaledImage(ImagePlus imp, double scale) {
        if (imp == null) {
            return null;
        }
        Image scaledImage = null;
        Image originalImage = imp.getImage();
        try {
            int x = (int)((double)imp.getWidth() * scale);
            int y = (int)((double)imp.getHeight() * scale);
            scaledImage = originalImage.getScaledInstance(x, y, 4);
            this.mediaTracker.addImage(scaledImage, 0);
            this.mediaTracker.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            scaledImage.flush();
            scaledImage = null;
            return originalImage;
        }
        originalImage.flush();
        originalImage = null;
        return scaledImage;
    }

    private void saveActualDir(String path) {
        File saveFile = new File("SITResults.properties");
        FileWriter w = null;
        try {
            w = new FileWriter(saveFile.getPath(), false);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        try {
            w.write("Last Save Dir = " + path);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        try {
            ((Writer)w).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    private String getLastDir() {
        String result = "";
        File loadFile = new File("SITResults.properties");
        FileReader r = null;
        try {
            r = new FileReader(loadFile.getPath());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return result;
        }
        try {
            char[] input = new char[4096];
            ((Reader)r).read(input, 0, 4096);
            String data = new String(input);
            int index = data.indexOf("=");
            if (index >= 0) {
                result = data.substring(index + 2);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return result;
        }
        try {
            ((Reader)r).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return result;
        }
        return result;
    }

    public void setAdjustmentRange(double min, double max) {
        this.adjustmentMin = min;
        this.adjustmentMax = max;
    }
}

