/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 1999 Christian Schalla
 * Andreas Truemper
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.dicom.dcm;

import java.util.*;


/**
 * Die Klasse implementiert ein Dictionary der in PS 3.6 definierten DICOM
 * Daten Elemente. Das Woerterbuch wird durch eine Hashtabelle realisiert.
 * <ul>
 * <li> Jedem Daten Element wird ein eindeutiger (Integer) Code, der Type,
 * zugeordnet. Dieser dient gleichzeitig als Index fuer die Hashtabelle. </li>
 * <li> Die VR (Value Representation) der Norm entspricht hier dem VR-Name. </li>
 * <li> Jeder VR ist ein eindeutiger (Integer) Code (VRCODE_xx), zugeordnet. </li>
 * </ul>
 * <DL><DT><B>Modifications: </B><DD>
 * tha 2000.02.11: VRString eingefuehrt <br>
 * tha 2000.02.22: Typ und Typecode umbenannt in VRCode <br>
 * tha 2000.01.30: vrNameList eingefgt. Diese dient dazu, aus einem
 * VR-Code einen 2 Zeichen langen String zu erzeugen, der
 * bei der explicit VR Transfer Syntax benoetigt wird.
 * <b>Achtung</b>: Die DICOM Norm ist an dieser Stelle nicht
 * eindeutig. Im Data Dictionary (PS 3.6) werden fuer eine
 * Reihe von Daten Elementen VR's der Laenge 5 angegeben
 * (z.B. (7FE0, 0010) OW/OB) und/oder auch Alternativen
 * (z.B. (0028, 3006) US or SS.
 * In diesen Faellen wird die erste Definition in die Liste
 * aufgenommen. Sollte der "wahre" Datentyp davon abweichen,
 * muss er in DcmValue mit setVR geaendert werden. <br>
 * tde 2000.05.02: DcmDataDictionaryElemente entsprechend PS 3.6 Data Dictionary
 * (Version 1999, Final Draft) neu definiert. DcmDataDictionaryElemente, die
 * in frueheren Normen (ACR-Nema, SPI) und von Geraeteherstellern definiert
 * wurden, sind als Kommentar eingeschlossen. Sie koennen bei Bedarf durch
 * Auskommentieren in die Klasse aufgenommen werden. <br>
 * tha 2000.05.09: Die Umsetzung des in DICOM teilweise nicht eindeutig
 * definierten VR-Codes in einen eindeutigen Code wird jetzt ueber das Array
 * vrList und die Methoden vrCodeDefToCode, vrStringToCode, vrCodeToString
 * vorgenommen. getDictVRCode liefert immer einen eindeutigen VR-Code<br>
 * ans 2000.10.28: get implementiert fr DcmTransformer <br>
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @author   Christian Schalla
 * @author   Andreas Truemper
 * @version  2000.05.09
 */
public class DcmDDE {

	/* Die Hashtabelle, die die Eintraege des Woerterbuchs enthaelt */
	private static Hashtable									typeIndexTable = new Hashtable();

	/*
	 * Der letzte Index der Hashtabelle. Wir benoetigt, um evtl. weitere
	 * Indizes hinzuzufuegen.
	 */
	static int																lastSearch = 0;

	/* Definition der Type Codes */

	/*
	 * VRCODE_UNDEFINED: Fuer das Element liegt bisher keine
	 * Definition des Type Codes vor. Sie muesste deshalb aus dem
	 * Dictionary geholt werden.
	 */
	public static final int										VRCODE_UNDEFINED = 0;

	/* In der DICOM Norm definierte VRs (Value Representations) */
 	public static final int										VRCODE_AE = 1;
	public static final int										VRCODE_AS = 2;
	public static final int										VRCODE_AT = 3;
	public static final int										VRCODE_CS = 4;
	public static final int										VRCODE_DA = 5;
	public static final int										VRCODE_DS = 6;
	public static final int										VRCODE_DT = 7;
	public static final int										VRCODE_FD = 8;
	public static final int										VRCODE_FL = 9;
	public static final int										VRCODE_IS = 10;
	public static final int										VRCODE_LO = 11;
	public static final int										VRCODE_LT = 12;
	public static final int										VRCODE_OB = 13;
	public static final int										VRCODE_OW = 14;
	public static final int										VRCODE_PN = 15;
	public static final int										VRCODE_SH = 16;
	public static final int										VRCODE_SL = 17;
	public static final int										VRCODE_SQ = 18;
	public static final int										VRCODE_SS = 19;
	public static final int										VRCODE_ST = 20;
	public static final int										VRCODE_TM = 21;
	public static final int										VRCODE_UI = 22;
	public static final int										VRCODE_UL = 23;
	public static final int										VRCODE_UN = 24;
	public static final int										VRCODE_US = 25;
	public static final int										VRCODE_UT = 26;

  // Die nachfolgenden VR-Codes werden nur in den DcmVRDictionaryElementen
  // verwendet. Nach "aussen" wird immer ein eindeutiger VR-Code
  // geliefert.

	private static final int									VRCODE_OW_or_OB       = 27;
	private static final int									VRCODE_US_or_SS       = 28;
	private static final int									VRCODE_US_or_SS_or_OW = 29;
	private static final int									VRCODE_US_US_or_SS_US = 30;


	/*
	 * Hier wird ein Array mit den Value Representations angelegt.
	 */
	private static DcmVRDictionaryElement[] vrList = {

		new DcmVRDictionaryElement (VRCODE_UNDEFINED     , VRCODE_UNDEFINED, "??"),
 		new DcmVRDictionaryElement (VRCODE_AE            , VRCODE_AE       , "AE"),
		new DcmVRDictionaryElement (VRCODE_AS            , VRCODE_AS       , "AS"),
		new DcmVRDictionaryElement (VRCODE_AT            , VRCODE_AT       , "AT"),
		new DcmVRDictionaryElement (VRCODE_CS            , VRCODE_CS       , "CS"),
		new DcmVRDictionaryElement (VRCODE_DA            , VRCODE_DA       , "DA"),
		new DcmVRDictionaryElement (VRCODE_DS            , VRCODE_DS       , "DS"),
		new DcmVRDictionaryElement (VRCODE_DT            , VRCODE_DT       , "DT"),
		new DcmVRDictionaryElement (VRCODE_FD            , VRCODE_FD       , "FD"),
		new DcmVRDictionaryElement (VRCODE_FL            , VRCODE_FL       , "FL"),
		new DcmVRDictionaryElement (VRCODE_IS            , VRCODE_IS       , "IS"),
		new DcmVRDictionaryElement (VRCODE_LO            , VRCODE_LO       , "LO"),
		new DcmVRDictionaryElement (VRCODE_LT            , VRCODE_LT       , "LT"),
		new DcmVRDictionaryElement (VRCODE_OB            , VRCODE_OB       , "OB"),
		new DcmVRDictionaryElement (VRCODE_OW            , VRCODE_OW       , "OW"),
		new DcmVRDictionaryElement (VRCODE_PN            , VRCODE_PN       , "PN"),
		new DcmVRDictionaryElement (VRCODE_SH            , VRCODE_SH       , "SH"),
		new DcmVRDictionaryElement (VRCODE_SL            , VRCODE_SL       , "SL"),
		new DcmVRDictionaryElement (VRCODE_SQ            , VRCODE_SQ       , "SQ"),
		new DcmVRDictionaryElement (VRCODE_SS            , VRCODE_SS       , "SS"),
		new DcmVRDictionaryElement (VRCODE_ST            , VRCODE_ST       , "ST"),
		new DcmVRDictionaryElement (VRCODE_TM            , VRCODE_TM       , "TM"),
		new DcmVRDictionaryElement (VRCODE_UI            , VRCODE_UI       , "UI"),
		new DcmVRDictionaryElement (VRCODE_UL            , VRCODE_UL       , "UL"),
		new DcmVRDictionaryElement (VRCODE_UN            , VRCODE_UN       , "UN"),
		new DcmVRDictionaryElement (VRCODE_US            , VRCODE_US       , "US"),
		new DcmVRDictionaryElement (VRCODE_UT            , VRCODE_UT       , "UT"),
		new DcmVRDictionaryElement (VRCODE_OW_or_OB      , VRCODE_OW       , "OW"),
		new DcmVRDictionaryElement (VRCODE_US_or_SS      , VRCODE_US       , "US"),
		new DcmVRDictionaryElement (VRCODE_US_or_SS_or_OW, VRCODE_US       , "US"),
		new DcmVRDictionaryElement (VRCODE_US_US_or_SS_US, VRCODE_US       , "US")
  };


	/* Definition des DataElement Typs */


	public static final int										DD_UNDEFINED = 0;
	public static final int										DD_GroupLength = 1 ;
	public static final int										DD_SpecificCharacterSet = 2 ;
	public static final int										DD_ImageType = 3 ;
	public static final int										DD_InstanceCreationDate = 4 ;
	public static final int										DD_InstanceCreationTime = 5 ;
	public static final int										DD_InstanceCreatorUID = 6 ;
	public static final int										DD_SOPClassUID = 7 ;
	public static final int										DD_SOPInstanceUID = 8 ;
	public static final int										DD_StudyDate = 9 ;
	public static final int										DD_SeriesDate = 10 ;
	public static final int										DD_AcquisitionDate = 11 ;
	public static final int										DD_ImageDate = 12 ;
	public static final int										DD_OverlayDate = 13 ;
	public static final int										DD_CurveDate = 14 ;
	public static final int										DD_StudyTime = 15 ;
	public static final int										DD_SeriesTime = 16 ;
	public static final int										DD_AcquisitionTime = 17 ;
	public static final int										DD_ImageTime = 18 ;
	public static final int										DD_OverlayTime = 19 ;
	public static final int										DD_CurveTime = 20 ;
	public static final int										DD_NuclearMedicineSeriesType = 21 ;
	public static final int										DD_AccessionNumber = 22 ;
	public static final int										DD_QueryRetrieveLevel = 23 ;
	public static final int										DD_Retrieve = 24 ;
	public static final int										DD_FailedSOPInstanceUIDList = 25 ;
	public static final int										DD_Modality = 26 ;
	public static final int										DD_ModalitiesInStudy = 27 ;
	public static final int										DD_ConversionType = 28 ;
	public static final int										DD_PresentationIntentType = 29 ;
	public static final int										DD_Manufacturer = 30 ;
	public static final int										DD_InstitutionName = 31 ;
	public static final int										DD_InstitutionAddress = 32 ;
	public static final int										DD_InstitutionCodeSequence = 33 ;
	public static final int										DD_ReferringPhysiciansName = 34 ;
	public static final int										DD_ReferringPhysiciansAddress = 35 ;
	public static final int										DD_ReferringPhysiciansTelephoneNumbers = 36 ;
	public static final int										DD_CodeValue = 37 ;
	public static final int										DD_CodingSchemeDesignator = 38 ;
	public static final int										DD_CodingSchemeVersion = 39 ;
	public static final int										DD_CodeMeaning = 40 ;
	public static final int										DD_MappingResource = 41 ;
	public static final int										DD_ContextGroupVersion = 42 ;
	public static final int										DD_ContextGroupLocalVersion = 43 ;
	public static final int										DD_CodeSetExtensionFlag = 44 ;
	public static final int										DD_PrivateCodingSchemeCreatorUID = 45 ;
	public static final int										DD_CodeSetExtensionCreatorUID = 46 ;
	public static final int										DD_ContextIdentifier = 47 ;
	public static final int										DD_StationName = 48 ;
	public static final int										DD_StudyDescription = 49 ;
	public static final int										DD_ProcedureCodeSequence = 50 ;
	public static final int										DD_SeriesDescription = 51 ;
	public static final int										DD_InstitutionalDepartmentName = 52 ;
	public static final int										DD_PhysicianOfRecord = 53 ;
	public static final int										DD_PerformingPhysiciansName = 54 ;
	public static final int										DD_NameOfPhysicianReadingStudy = 55 ;
	public static final int										DD_OperatorsName = 56 ;
	public static final int										DD_AdmittingDiagnosesDescription = 57 ;
	public static final int										DD_AdmittingDiagnosisCodeSequence = 58 ;
	public static final int										DD_ManufacturersModelName = 59 ;
	public static final int										DD_ReferencedResultsSequence = 60 ;
	public static final int										DD_ReferencedStudySequence = 61 ;
	public static final int										DD_ReferencedStudyComponentSequence = 62 ;
	public static final int										DD_ReferencedSeriesSequence = 63 ;
	public static final int										DD_ReferencedPatientSequence = 64 ;
	public static final int										DD_ReferencedVisitSequence = 65 ;
	public static final int										DD_ReferencedOverlaySequence = 66 ;
	public static final int										DD_ReferencedImageSequence = 67 ;
	public static final int										DD_ReferencedCurveSequence = 68 ;
	public static final int										DD_ReferencedSOPClassUID = 69 ;
	public static final int										DD_ReferencedSOPInstanceUID = 70 ;
	public static final int										DD_SOPClassesSupported = 71 ;
	public static final int										DD_ReferencedFrameNumber = 72 ;
	public static final int										DD_TransactionUID = 73 ;
	public static final int										DD_FailureReason = 74 ;
	public static final int										DD_FailedSOPSequence = 75 ;
	public static final int										DD_ReferencedSOPSequence = 76 ;
	public static final int										DD_LossyImageCompression = 77 ;
	public static final int										DD_DerivationDescription = 78 ;
	public static final int										DD_SourceImageSequence = 79 ;
	public static final int										DD_StageName = 80 ;
	public static final int										DD_StageNumber = 81 ;
	public static final int										DD_NumberOfStages = 82 ;
	public static final int										DD_ViewNumber = 83 ;
	public static final int										DD_NumberOfEventTimers = 84 ;
	public static final int										DD_NumberOfViewsInStage = 85 ;
	public static final int										DD_EventElapsedTime = 86 ;
	public static final int										DD_EventTimerName = 87 ;
	public static final int										DD_StartTrim = 88 ;
	public static final int										DD_StopTrim = 89 ;
	public static final int										DD_RecommendedDisplayFrameRate = 90 ;
	public static final int										DD_TransducerPosition = 91 ;
	public static final int										DD_TransducerOrientation = 92 ;
	public static final int										DD_AnatomicStructure = 93 ;
	public static final int										DD_AnatomicRegionSequence = 94 ;
	public static final int										DD_AnatomicRegionModifierSequence = 95 ;
	public static final int										DD_PrimaryAnatomicStructureSequence = 96 ;
	public static final int										DD_AnatomicStructureSpaceOrRegionSequence = 97 ;
	public static final int										DD_PrimaryAnatomicStructureModifierSequence = 98 ;
	public static final int										DD_TransducerPositionSequence = 99 ;
	public static final int										DD_TransducerPositionModifierSequence = 100 ;
	public static final int										DD_TransducerOrientationSequence = 101 ;
	public static final int										DD_TransducerOrientationModifierSequence = 102 ;
	public static final int										DD_GroupLength_0010 = 103 ;
	public static final int										DD_PatientsName = 104 ;
	public static final int										DD_PatientID = 105 ;
	public static final int										DD_IssuerOfPatientID = 106 ;
	public static final int										DD_PatientsBirthDate = 107 ;
	public static final int										DD_PatientsBirthTime = 108 ;
	public static final int										DD_PatientsSex = 109 ;
	public static final int										DD_PatientsInsurancePlanCodeSequence = 110 ;
	public static final int										DD_OtherPatientIDs = 111 ;
	public static final int										DD_OtherPatientNames = 112 ;
	public static final int										DD_PatientsBirthName = 113 ;
	public static final int										DD_PatientsAge = 114 ;
	public static final int										DD_PatientsSize = 115 ;
	public static final int										DD_PatientsWeight = 116 ;
	public static final int										DD_PatientsAddress = 117 ;
	public static final int										DD_PatientsMothersBirthName = 118 ;
	public static final int										DD_MilitaryRank = 119 ;
	public static final int										DD_BranchOfService = 120 ;
	public static final int										DD_MedicalRecordLocator = 121 ;
	public static final int										DD_MedicalAlerts = 122 ;
	public static final int										DD_ContrastAllergies = 123 ;
	public static final int										DD_CountryOfResidence = 124 ;
	public static final int										DD_RegionOfResidence = 125 ;
	public static final int										DD_PatientsTelephoneNumbers = 126 ;
	public static final int										DD_EthnicGroup = 127 ;
	public static final int										DD_Occupation = 128 ;
	public static final int										DD_SmokingStatus = 129 ;
	public static final int										DD_AdditionalPatientHistory = 130 ;
	public static final int										DD_PregnancyStatus = 131 ;
	public static final int										DD_LastMenstrualDate = 132 ;
	public static final int										DD_PatientsReligiousPreference = 133 ;
	public static final int										DD_PatientComments = 134 ;
	public static final int										DD_GroupLength_0018 = 135 ;
	public static final int										DD_ContrastBolusAgent = 136 ;
	public static final int										DD_ContrastBolusAgentSequence = 137 ;
	public static final int										DD_ContrastBolusAdministrationRouteSequence = 138 ;
	public static final int										DD_BodyPartExamined = 139 ;
	public static final int										DD_ScanningSequence = 140 ;
	public static final int										DD_SequenceVariant = 141 ;
	public static final int										DD_ScanOptions = 142 ;
	public static final int										DD_MRAcquisitionType = 143 ;
	public static final int										DD_SequenceName = 144 ;
	public static final int										DD_AngioFlag = 145 ;
	public static final int										DD_InterventionDrugInformationSequence = 146 ;
	public static final int										DD_InterventionDrugStopTime = 147 ;
	public static final int										DD_InterventionDrugDose = 148 ;
	public static final int										DD_InterventionDrugCodeSequence = 149 ;
	public static final int										DD_AdditionalDrugSequence = 150 ;
	public static final int										DD_Radionuclide = 151 ;
	public static final int										DD_Radiopharmaceutical = 152 ;
	public static final int										DD_EnergyWindowCenterline = 153 ;
	public static final int										DD_EnergyWindowTotalWidth = 154 ;
	public static final int										DD_InterventionDrugName = 155 ;
	public static final int										DD_InterventionDrugStartTime = 156 ;
	public static final int										DD_InterventionalTherapySequence = 157 ;
	public static final int										DD_TherapyType = 158 ;
	public static final int										DD_InterventionalStatus = 159 ;
	public static final int										DD_TherapyDescription = 160 ;
	public static final int										DD_CineRate = 161 ;
	public static final int										DD_SliceThickness = 162 ;
	public static final int										DD_KVP = 163 ;
	public static final int										DD_CountsAccumulated = 164 ;
	public static final int										DD_AcquisitionTerminationCondition = 165 ;
	public static final int										DD_EffectiveSeriesDuration = 166 ;
	public static final int										DD_AcquisitionStartCondition = 167 ;
	public static final int										DD_AcquisitionStartConditionData = 168 ;
	public static final int										DD_AcquisitionTerminationConditionData = 169 ;
	public static final int										DD_RepetitionTime = 170 ;
	public static final int										DD_EchoTime = 171 ;
	public static final int										DD_InversionTime = 172 ;
	public static final int										DD_NumberOfAverages = 173 ;
	public static final int										DD_ImagingFrequency = 174 ;
	public static final int										DD_ImagedNucleus = 175 ;
	public static final int										DD_EchoNumber = 176 ;
	public static final int										DD_MagneticFieldStrength = 177 ;
	public static final int										DD_SpacingBetweenSlices = 178 ;
	public static final int										DD_NumberOfPhaseEncodingSteps = 179 ;
	public static final int										DD_DataCollectionDiameter = 180 ;
	public static final int										DD_EchoTrainLength = 181 ;
	public static final int										DD_PercentSampling = 182 ;
	public static final int										DD_PercentPhaseFieldOfView = 183 ;
	public static final int										DD_PixelBandwidth = 184 ;
	public static final int										DD_DeviceSerialNumber = 185 ;
	public static final int										DD_PlateID = 186 ;
	public static final int										DD_SecondaryCaptureDeviceID = 187 ;
	public static final int										DD_HardcopyCreationDeviceID = 188 ;
	public static final int										DD_DateOfSecondaryCapture = 189 ;
	public static final int										DD_TimeOfSecondaryCapture = 190 ;
	public static final int										DD_SecondaryCaptureDeviceManufacturer = 191 ;
	public static final int										DD_HardcopyDeviceManufacturer = 192 ;
	public static final int										DD_SecondaryCaptureDeviceManufacturersModelName = 193 ;
	public static final int										DD_SecondaryCaptureDeviceSoftwareVersion = 194 ;
	public static final int										DD_HardcopyDeviceSoftwareVersion = 195 ;
	public static final int										DD_HardcopyDeviceManfuacturersModelName = 196 ;
	public static final int										DD_SoftwareVersion = 197 ;
	public static final int										DD_VideoImageFormatAcquired = 198 ;
	public static final int										DD_DigitalImageFormatAcquired = 199 ;
	public static final int										DD_ProtocolName = 200 ;
	public static final int										DD_ContrastBolusRoute = 201 ;
	public static final int										DD_ContrastBolusVolume = 202 ;
	public static final int										DD_ContrastBolusStartTime = 203 ;
	public static final int										DD_ContrastBolusStopTime = 204 ;
	public static final int										DD_ContrastBolusTotalDose = 205 ;
	public static final int										DD_SyringeCounts = 206 ;
	public static final int										DD_ContrastFlowRate = 207 ;
	public static final int										DD_ContrastFlowDuration = 208 ;
	public static final int										DD_ContrastBolusIngredient = 209 ;
	public static final int										DD_ContrastBolusIngredientConcentration = 210 ;
	public static final int										DD_SpatialResolution = 211 ;
	public static final int										DD_TriggerTime = 212 ;
	public static final int										DD_TriggerSourceOrType = 213 ;
	public static final int										DD_NominalInterval = 214 ;
	public static final int										DD_FrameTime = 215 ;
	public static final int										DD_FramingType = 216 ;
	public static final int										DD_FrameTimeVector = 217 ;
	public static final int										DD_FrameDelay = 218 ;
	public static final int										DD_RadionuclideRoute = 219 ;
	public static final int										DD_RadiopharmaceuticalRoute = 220 ;
	public static final int										DD_RadionuclideVolume = 221 ;
	public static final int										DD_RadiopharmaceuticalVolume = 222 ;
	public static final int										DD_RadionuclideStartTime = 223 ;
	public static final int										DD_RadiopharmaceuticalStartTime = 224 ;
	public static final int										DD_RadionuclideStopTime = 225 ;
	public static final int										DD_RadiopharmaceuticalStopTime = 226 ;
	public static final int										DD_RadionuclideTotalDose = 227 ;
	public static final int										DD_RadionuclideHalfLife = 228 ;
	public static final int										DD_RadionuclidePositronFraction = 229 ;
	public static final int										DD_RadiopharmaceuticalSpecificActivity = 230 ;
	public static final int										DD_BeatRejectionFlag = 231 ;
	public static final int										DD_LowRRValue = 232 ;
	public static final int										DD_HighRRValue = 233 ;
	public static final int										DD_IntervalsAcquired = 234 ;
	public static final int										DD_IntervalsRejected = 235 ;
	public static final int										DD_PVCRejection = 236 ;
	public static final int										DD_SkipBeats = 237 ;
	public static final int										DD_HeartRate = 238 ;
	public static final int										DD_CardiacNumberOfImages = 239 ;
	public static final int										DD_TriggerWindow = 240 ;
	public static final int										DD_ReconstructionDiameter = 241 ;
	public static final int										DD_DistanceSourceToDetector = 242 ;
	public static final int										DD_DistanceSourceToPatient = 243 ;
	public static final int										DD_EstimatedRadiographicMagnificationFactor = 244 ;
	public static final int										DD_GantryDetectorTilt = 245 ;
	public static final int										DD_GantryDetectorSlew = 246 ;
	public static final int										DD_TableHeight = 247 ;
	public static final int										DD_TableTraverse = 248 ;
	public static final int										DD_TableMotion = 249 ;
	public static final int										DD_TableVerticalIncrement = 250 ;
	public static final int										DD_TableLateralIncrement = 251 ;
	public static final int										DD_TableLongitudinalIncrement = 252 ;
	public static final int										DD_TableAngle = 253 ;
	public static final int										DD_TableType = 254 ;
	public static final int										DD_RotationDirection = 255 ;
	public static final int										DD_AngularPosition = 256 ;
	public static final int										DD_RadialPosition = 257 ;
	public static final int										DD_ScanArc = 258 ;
	public static final int										DD_AngularStep = 259 ;
	public static final int										DD_CenterOfRotationOffset = 260 ;
	public static final int										DD_RotationOffset = 261 ;
	public static final int										DD_FieldOfViewShape = 262 ;
	public static final int										DD_FieldOfViewDimension = 263 ;
	public static final int										DD_ExposureTime = 264 ;
	public static final int										DD_XrayTubeCurrent = 265 ;
	public static final int										DD_Exposure = 266 ;
	public static final int										DD_ExposureInUAs = 267 ;
	public static final int										DD_AveragePulseWidth = 268 ;
	public static final int										DD_RadiationSetting = 269 ;
	public static final int										DD_RectificationType = 270 ;
	public static final int										DD_RadiationMode = 271 ;
	public static final int										DD_ImageAreaDoseProduct = 272 ;
	public static final int										DD_FilterType = 273 ;
	public static final int										DD_TypeOfFilters = 274 ;
	public static final int										DD_IntensifierSize = 275 ;
	public static final int										DD_ImagerPixelSpacing = 276 ;
	public static final int										DD_Grid = 277 ;
	public static final int										DD_GeneratorPower = 278 ;
	public static final int										DD_CollimatorgridName = 279 ;
	public static final int										DD_CollimatorType = 280 ;
	public static final int										DD_FocalDistance = 281 ;
	public static final int										DD_XFocusCenter = 282 ;
	public static final int										DD_YFocusCenter = 283 ;
	public static final int										DD_FocalSpot = 284 ;
	public static final int										DD_AnodeTargetMaterial = 285 ;
	public static final int										DD_BodyPartThickness = 286 ;
	public static final int										DD_CompressionForce = 287 ;
	public static final int										DD_DateOfLastCalibration = 288 ;
	public static final int										DD_TimeOfLastCalibration = 289 ;
	public static final int										DD_ConvolutionKernel = 290 ;
	public static final int										DD_ActualFrameDuration = 291 ;
	public static final int										DD_CountRate = 292 ;
	public static final int										DD_PreferredPlaybackSequencing = 293 ;
	public static final int										DD_ReceivingCoil = 294 ;
	public static final int										DD_TransmittingCoil = 295 ;
	public static final int										DD_PlateType = 296 ;
	public static final int										DD_PhosphorType = 297 ;
	public static final int										DD_ScanVelocity = 298 ;
	public static final int										DD_WholeBodyTechnique = 299 ;
	public static final int										DD_ScanLength = 300 ;
	public static final int										DD_AcquisitionMatrix = 301 ;
	public static final int										DD_PhaseEncodingDirection = 302 ;
	public static final int										DD_FlipAngle = 303 ;
	public static final int										DD_VariableFlipAngleFlag = 304 ;
	public static final int										DD_SAR = 305 ;
	public static final int										DD_dBdt = 306 ;
	public static final int										DD_AcquisitionDeviceProcessingDescription = 307 ;
	public static final int										DD_AcquisitionDeviceProcessingCode = 308 ;
	public static final int										DD_CassetteOrientation = 309 ;
	public static final int										DD_CassetteSize = 310 ;
	public static final int										DD_ExposuresOnPlate = 311 ;
	public static final int										DD_RelativeXrayExposure = 312 ;
	public static final int										DD_ColumnAngulation = 313 ;
	public static final int										DD_TomoLayerHeight = 314 ;
	public static final int										DD_TomoAngle = 315 ;
	public static final int										DD_TomoTime = 316 ;
	public static final int										DD_TomoType = 317 ;
	public static final int										DD_TomoClass = 318 ;
	public static final int										DD_NumberOfTomosynthesisSourceImages = 319 ;
	public static final int										DD_PositionerMotion = 320 ;
	public static final int										DD_PositionerType = 321 ;
	public static final int										DD_PositionerPrimaryAngle = 322 ;
	public static final int										DD_PositionerSecondaryAngle = 323 ;
	public static final int										DD_PositionerPrimaryAngleIncrement = 324 ;
	public static final int										DD_PositionerSecondaryAngleIncrement = 325 ;
	public static final int										DD_DetectorPrimaryAngle = 326 ;
	public static final int										DD_DetectorSecondaryAngle = 327 ;
	public static final int										DD_ShutterShape = 328 ;
	public static final int										DD_ShutterLeftVerticalEdge = 329 ;
	public static final int										DD_ShutterRightVerticalEdge = 330 ;
	public static final int										DD_ShutterUpperHorizontalEdge = 331 ;
	public static final int										DD_ShutterLowerHorizontalEdge = 332 ;
	public static final int										DD_CenterOfCircularShutter = 333 ;
	public static final int										DD_RadiusOfCircularShutter = 334 ;
	public static final int										DD_VerticesOfThePolygonalShutter = 335 ;
	public static final int										DD_CollimatorShape = 336 ;
	public static final int										DD_CollimatorLeftVerticalEdge = 337 ;
	public static final int										DD_CollimatorRightVerticalEdge = 338 ;
	public static final int										DD_CollimatorUpperHorizontalEdge = 339 ;
	public static final int										DD_CollimatorLowerHorizontalEdge = 340 ;
	public static final int										DD_CenterOfCircularCollimator = 341 ;
	public static final int										DD_RadiusOfCircularCollimator = 342 ;
	public static final int										DD_VerticesOfThePolygonalCollimator = 343 ;
	public static final int										DD_OutputPower = 344 ;
	public static final int										DD_TransducerData = 345 ;
	public static final int										DD_FocusDepth = 346 ;
	public static final int										DD_ProcessingFunction = 347 ;
	public static final int										DD_PostprocessingFunction = 348 ;
	public static final int										DD_MechanicalIndex = 349 ;
	public static final int										DD_ThermalIndex = 350 ;
	public static final int										DD_CranialThermalIndex = 351 ;
	public static final int										DD_SoftTissueThermalIndex = 352 ;
	public static final int										DD_SoftTissuefocusThermalIndex = 353 ;
	public static final int										DD_SoftTissuesurfaceThermalIndex = 354 ;
	public static final int										DD_DepthOfScanField = 355 ;
	public static final int										DD_PatientPosition = 356 ;
	public static final int										DD_ViewPosition = 357 ;
	public static final int										DD_ProjectionEponymousNameCodeSequence = 358 ;
	public static final int										DD_ImageTransformationMatrix = 359 ;
	public static final int										DD_ImageTranslationVector = 360 ;
	public static final int										DD_Sensitivity = 361 ;
	public static final int										DD_SequenceOfUltrasoundRegions = 362 ;
	public static final int										DD_RegionSpatialFormat = 363 ;
	public static final int										DD_RegionDataType = 364 ;
	public static final int										DD_RegionFlags = 365 ;
	public static final int										DD_RegionLocationMinX0 = 366 ;
	public static final int										DD_RegionLocationMinY0 = 367 ;
	public static final int										DD_RegionLocationMaxX1 = 368 ;
	public static final int										DD_RegionLocationMaxY1 = 369 ;
	public static final int										DD_ReferencePixelX0 = 370 ;
	public static final int										DD_ReferencePixelY0 = 371 ;
	public static final int										DD_PhysicalUnitsXDirection = 372 ;
	public static final int										DD_PhysicalUnitsYDirection = 373 ;
	public static final int										DD_ReferencePixelPhysicalValueX = 374 ;
	public static final int										DD_ReferencePixelPhysicalValueY = 375 ;
	public static final int										DD_PhysicalDeltaX = 376 ;
	public static final int										DD_PhysicalDeltaY = 377 ;
	public static final int										DD_TransducerFrequency = 378 ;
	public static final int										DD_TransducerType = 379 ;
	public static final int										DD_PulseRepetitionFrequency = 380 ;
	public static final int										DD_DopplerCorrectionAngle = 381 ;
	public static final int										DD_SteeringAngle = 382 ;
	public static final int										DD_DopplerSampleVolumeXPosition = 383 ;
	public static final int										DD_DopplerSampleVolumeYPosition = 384 ;
	public static final int										DD_TMLinePositionX0 = 385 ;
	public static final int										DD_TMLinePositionY0 = 386 ;
	public static final int										DD_TMLinePositionX1 = 387 ;
	public static final int										DD_TMLinePositionY1 = 388 ;
	public static final int										DD_PixelComponentOrganization = 389 ;
	public static final int										DD_PixelComponentMask = 390 ;
	public static final int										DD_PixelComponentRangeStart = 391 ;
	public static final int										DD_PixelComponentRangeStop = 392 ;
	public static final int										DD_PixelComponentPhysicalUnits = 393 ;
	public static final int										DD_PixelComponentDataType = 394 ;
	public static final int										DD_NumberOfTableBreakPoints = 395 ;
	public static final int										DD_TableOfXBreakPoints = 396 ;
	public static final int										DD_TableOfYBreakPoints = 397 ;
	public static final int										DD_NumberOfTableEntries = 398 ;
	public static final int										DD_TableOfPixelValues = 399 ;
	public static final int										DD_TableOfParameterValues = 400 ;
	public static final int										DD_DetectorConditionsNominalFlag = 401 ;
	public static final int										DD_DetectorTemperature = 402 ;
	public static final int										DD_DetectorType = 403 ;
	public static final int										DD_DetectorConfiguration = 404 ;
	public static final int										DD_DetectorDescription = 405 ;
	public static final int										DD_DetectorMode = 406 ;
	public static final int										DD_DetectorID = 407 ;
	public static final int										DD_DateOfLastDetectorCalibration = 408 ;
	public static final int										DD_TimeOfLastDetectorCalibration = 409 ;
	public static final int										DD_ExposuresOnDetectorSinceLastCalibration = 410 ;
	public static final int										DD_ExposuresOnDetectorSinceManufactured = 411 ;
	public static final int										DD_DetectorTimeSinceLastExposure = 412 ;
	public static final int										DD_DetectorActiveTime = 413 ;
	public static final int										DD_DetectorActivationOffsetFromExposure = 414 ;
	public static final int										DD_DetectorBinning = 415 ;
	public static final int										DD_DetectorElementPhysicalSize = 416 ;
	public static final int										DD_DetectorElementSpacing = 417 ;
	public static final int										DD_DetectorActiveShape = 418 ;
	public static final int										DD_DetectorActiveDimension = 419 ;
	public static final int										DD_DetectorActiveOrigin = 420 ;
	public static final int										DD_FieldOfViewOrigin = 421 ;
	public static final int										DD_FieldOfViewRotation = 422 ;
	public static final int										DD_FieldOfViewHorizontalFlip = 423 ;
	public static final int										DD_GridAbsorbingMaterial = 424 ;
	public static final int										DD_GridSpacingMaterial = 425 ;
	public static final int										DD_GridThickness = 426 ;
	public static final int										DD_GridPitch = 427 ;
	public static final int										DD_GridAspectRatio = 428 ;
	public static final int										DD_GridPeriod = 429 ;
	public static final int										DD_GridFocalDistance = 430 ;
	public static final int										DD_FilterMaterial = 431 ;
	public static final int										DD_FilterThicknessMinimum = 432 ;
	public static final int										DD_FilterThicknessMaximum = 433 ;
	public static final int										DD_ExposureControlMode = 434 ;
	public static final int										DD_ExposureControlModeDescription = 435 ;
	public static final int										DD_ExposureStatus = 436 ;
	public static final int										DD_PhototimerSetting = 437 ;
	public static final int										DD_GroupLength_0020 = 438 ;
	public static final int										DD_StudyInstanceUID = 439 ;
	public static final int										DD_SeriesInstanceUID = 440 ;
	public static final int										DD_StudyID = 441 ;
	public static final int										DD_SeriesNumber = 442 ;
	public static final int										DD_AcquisitionNumber = 443 ;
	public static final int										DD_InstanceNumber = 444 ;
	public static final int										DD_IsotopeNumber = 445 ;
	public static final int										DD_PhaseNumber = 446 ;
	public static final int										DD_IntervalNumber = 447 ;
	public static final int										DD_TimeSlotNumber = 448 ;
	public static final int										DD_AngleNumber = 449 ;
	public static final int										DD_ItemNumber = 450 ;
	public static final int										DD_PatientOrientation = 451 ;
	public static final int										DD_OverlayNumber = 452 ;
	public static final int										DD_CurveNumber = 453 ;
	public static final int										DD_LookupTableNumber = 454 ;
	public static final int										DD_ImagePositionPatient = 455 ;
	public static final int										DD_ImageOrientationPatient = 456 ;
	public static final int										DD_FrameOfReferenceUID = 457 ;
	public static final int										DD_Laterality = 458 ;
	public static final int										DD_ImageLaterality = 459 ;
	public static final int										DD_TemporalPositionIdentifier = 460 ;
	public static final int										DD_NumberOfTemporalPositions = 461 ;
	public static final int										DD_TemporalResolution = 462 ;
	public static final int										DD_SeriesInStudy = 463 ;
	public static final int										DD_ImagesInAcquisition = 464 ;
	public static final int										DD_AcquisitionsInStudy = 465 ;
	public static final int										DD_PositionReferenceIndicator = 466 ;
	public static final int										DD_SliceLocation = 467 ;
	public static final int										DD_OtherStudyNumbers = 468 ;
	public static final int										DD_NumberOfPatientRelatedStudies = 469 ;
	public static final int										DD_NumberOfPatientRelatedSeries = 470 ;
	public static final int										DD_NumberOfPatientRelatedInstances = 471 ;
	public static final int										DD_NumberOfStudyRelatedSeries = 472 ;
	public static final int										DD_NumberOfStudyRelatedInstances = 473 ;
	public static final int										DD_NumberOfSeriesRelatedInstances = 474 ;
	public static final int										DD_ImageComments = 475 ;
	public static final int										DD_GroupLength_0028 = 476 ;
	public static final int										DD_SamplesPerPixel = 477 ;
	public static final int										DD_PhotometricInterpretation = 478 ;
	public static final int										DD_PlanarConfiguration = 479 ;
	public static final int										DD_NumberOfFrames = 480 ;
	public static final int										DD_FrameIncrementPointer = 481 ;
	public static final int										DD_Rows = 482 ;
	public static final int										DD_Columns = 483 ;
	public static final int										DD_Planes = 484 ;
	public static final int										DD_UltrasoundColorDataPresent = 485 ;
	public static final int										DD_PixelSpacing = 486 ;
	public static final int										DD_ZoomFactor = 487 ;
	public static final int										DD_ZoomCenter = 488 ;
	public static final int										DD_PixelAspectRatio = 489 ;
	public static final int										DD_CorrectedImage = 490 ;
	public static final int										DD_BitsAllocated = 491 ;
	public static final int										DD_BitsStored = 492 ;
	public static final int										DD_HighBit = 493 ;
	public static final int										DD_PixelRepresentation = 494 ;
	public static final int										DD_SmallestImagePixelValue = 495 ;
	public static final int										DD_LargestImagePixelValue = 496 ;
	public static final int										DD_SmallestPixelValueInSeries = 497 ;
	public static final int										DD_LargestPixelValueInSeries = 498 ;
	public static final int										DD_SmallestImagePixelValueInPlane = 499 ;
	public static final int										DD_LargestImagePixelValueInPlane = 500 ;
	public static final int										DD_PixelPaddingValue = 501 ;
	public static final int										DD_QualityControlImage = 502 ;
	public static final int										DD_BurnedInAnnotation = 503 ;
	public static final int										DD_PixelIntensityRelationship = 504 ;
	public static final int										DD_PixelIntensityRelationshipSign = 505 ;
	public static final int										DD_WindowCenter = 506 ;
	public static final int										DD_WindowWidth = 507 ;
	public static final int										DD_RescaleIntercept = 508 ;
	public static final int										DD_RescaleSlope = 509 ;
	public static final int										DD_RescaleType = 510 ;
	public static final int										DD_WindowCenterWidthExplanation = 511 ;
	public static final int										DD_RecommendedViewingMode = 512 ;
	public static final int										DD_RedPaletteColorLookupTableDescriptor = 513 ;
	public static final int										DD_GreenPaletteColorLookupTableDescriptor = 514 ;
	public static final int										DD_BluePaletteColorLookupTableDescriptor = 515 ;
	public static final int										DD_PaletteColorLookupTableUID = 516 ;
	public static final int										DD_RedPaletteColorLookupTableData = 517 ;
	public static final int										DD_GreenPaletteColorLookupTableData = 518 ;
	public static final int										DD_BluePaletteColorLookupTableData = 519 ;
	public static final int										DD_SegmentedRedPaletteColorLookupTableData = 520 ;
	public static final int										DD_SegmentedGreenPaletteColorLookupTableData = 521 ;
	public static final int										DD_SegmentedBluePaletteColorLookupTableData = 522 ;
	public static final int										DD_ImplantPresent = 523 ;
	public static final int										DD_LossyImageCompression_0028 = 524 ;
	public static final int										DD_LossyImageCompressionRatio = 525 ;
	public static final int										DD_ModalityLUTSequence = 526 ;
	public static final int										DD_LUTDescriptor = 527 ;
	public static final int										DD_LUTExplanation = 528 ;
	public static final int										DD_ModalityLUTType = 529 ;
	public static final int										DD_LUTData = 530 ;
	public static final int										DD_VOILUTSequence = 531 ;
	public static final int										DD_BiPlaneAcquisitionSequence = 532 ;
	public static final int										DD_RepresentativeFrameNumber = 533 ;
	public static final int										DD_FrameNumbersOfInterestFOI = 534 ;
	public static final int										DD_FrameOfInterestDescription = 535 ;
	public static final int										DD_MaskPointer = 536 ;
	public static final int										DD_RWavePointer = 537 ;
	public static final int										DD_MaskSubtractionSequence = 538 ;
	public static final int										DD_MaskOperation = 539 ;
	public static final int										DD_ApplicableFrameRange = 540 ;
	public static final int										DD_MaskFrameNumbers = 541 ;
	public static final int										DD_ContrastFrameAveraging = 542 ;
	public static final int										DD_MaskSubpixelShift = 543 ;
	public static final int										DD_TIDOffset = 544 ;
	public static final int										DD_MaskOperationExplanation = 545 ;
	public static final int										DD_GroupLength_0032 = 546 ;
	public static final int										DD_StudyStatusID = 547 ;
	public static final int										DD_StudyPriorityID = 548 ;
	public static final int										DD_StudyIDIssuer = 549 ;
	public static final int										DD_StudyVerifiedDate = 550 ;
	public static final int										DD_StudyVerifiedTime = 551 ;
	public static final int										DD_StudyReadDate = 552 ;
	public static final int										DD_StudyReadTime = 553 ;
	public static final int										DD_ScheduledStudyStartDate = 554 ;
	public static final int										DD_ScheduledStudyStartTime = 555 ;
	public static final int										DD_ScheduledStudyStopDate = 556 ;
	public static final int										DD_ScheduledStudyStopTime = 557 ;
	public static final int										DD_ScheduledStudyLocation = 558 ;
	public static final int										DD_ScheduledStudyLocation_AETitle = 559 ;
	public static final int										DD_ReasonForStudy = 560 ;
	public static final int										DD_RequestingPhysician = 561 ;
	public static final int										DD_RequestingService = 562 ;
	public static final int										DD_StudyArrivalDate = 563 ;
	public static final int										DD_StudyArrivalTime = 564 ;
	public static final int										DD_StudyCompletionDate = 565 ;
	public static final int										DD_StudyCompletionTime = 566 ;
	public static final int										DD_StudyComponentStatusID = 567 ;
	public static final int										DD_RequestedProcedureDescription = 568 ;
	public static final int										DD_RequestedProcedureCodeSequence = 569 ;
	public static final int										DD_RequestedContrastAgent = 570 ;
	public static final int										DD_StudyComments = 571 ;
	public static final int										DD_GroupLength_0038 = 572 ;
	public static final int										DD_ReferencedPatientAliasSequence = 573 ;
	public static final int										DD_VisitStatusID = 574 ;
	public static final int										DD_AdmissionID = 575 ;
	public static final int										DD_IssuerOfAdmissionID = 576 ;
	public static final int										DD_RouteOfAdmissions = 577 ;
	public static final int										DD_ScheduledAdmissionDate = 578 ;
	public static final int										DD_ScheduledAdmissionTime = 579 ;
	public static final int										DD_ScheduledDischargeDate = 580 ;
	public static final int										DD_ScheduledDischargeTime = 581 ;
	public static final int										DD_ScheduledPatientInstitutionResidence = 582 ;
	public static final int										DD_AdmittingDate = 583 ;
	public static final int										DD_AdmittingTime = 584 ;
	public static final int										DD_DischargeDate = 585 ;
	public static final int										DD_DischargeTime = 586 ;
	public static final int										DD_DischargeDiagnosisDescription = 587 ;
	public static final int										DD_DischargeDiagnosisCodeSequence = 588 ;
	public static final int										DD_SpecialNeeds = 589 ;
	public static final int										DD_CurrentPatientLocation = 590 ;
	public static final int										DD_PatientsInstitutionResidence = 591 ;
	public static final int										DD_PatientState = 592 ;
	public static final int										DD_VisitComments = 593 ;
	public static final int										DD_GroupLength_0040 = 594 ;
	public static final int										DD_ScheduledStation = 595 ;
	public static final int										DD_ScheduledProcedureStepStartDate = 596 ;
	public static final int										DD_ScheduledProcedureStepStartTime = 597 ;
	public static final int										DD_ScheduledProcedureStepEndDate = 598 ;
	public static final int										DD_ScheduledProcedureStepEndTime = 599 ;
	public static final int										DD_ScheduledPerformingPhysiciansName = 600 ;
	public static final int										DD_ScheduledProcedureStepDescription = 601 ;
	public static final int										DD_ScheduledActionItemCodeSequence = 602 ;
	public static final int										DD_ScheduledProcedureStepID = 603 ;
	public static final int										DD_ScheduledStationName = 604 ;
	public static final int										DD_ScheduledProcedureStepLocation = 605 ;
	public static final int										DD_PreMedication = 606 ;
	public static final int										DD_ScheduledProcedureStepStatus = 607 ;
	public static final int										DD_ScheduledProcedureStepSequence = 608 ;
	public static final int										DD_ReferencedStandaloneSOPInstanceSequence = 609 ;
	public static final int										DD_PerformedStation = 610 ;
	public static final int										DD_PerformedStationName = 611 ;
	public static final int										DD_PerformedLocation = 612 ;
	public static final int										DD_PerformedProcedureStepStartDate = 613 ;
	public static final int										DD_PerformedProcedureStepStartTime = 614 ;
	public static final int										DD_PerformedProcedureStepEndDate = 615 ;
	public static final int										DD_PerformedProcedureStepEndTime = 616 ;
	public static final int										DD_PerformedProcedureStepStatus = 617 ;
	public static final int										DD_PerformedProcedureStepID = 618 ;
	public static final int										DD_PerformedProcedureStepDescription = 619 ;
	public static final int										DD_PerformedProcedureTypeDescription = 620 ;
	public static final int										DD_PerformedActionItemSequence = 621 ;
	public static final int										DD_ScheduledStepAttributesSequence = 622 ;
	public static final int										DD_RequestAttributesSequence = 623 ;
	public static final int										DD_CommentsOnThePerformedProcedureSteps = 624 ;
	public static final int										DD_QuantitySequence = 625 ;
	public static final int										DD_Quantity_0040 = 626 ;
	public static final int										DD_MeasuringUnitsSequence = 627 ;
	public static final int										DD_BillingItemSequence = 628 ;
	public static final int										DD_TotalTimeOfFluoroscopy = 629 ;
	public static final int										DD_TotalNumberOfExposures = 630 ;
	public static final int										DD_EntranceDose = 631 ;
	public static final int										DD_ExposedArea = 632 ;
	public static final int										DD_DistanceSourceToEntrance = 633 ;
	public static final int										DD_DistanceSourceToSupport = 634 ;
	public static final int										DD_CommentsOnRadiationDose = 635 ;
	public static final int										DD_XRayOutput = 636 ;
	public static final int										DD_HalfValueLayer = 637 ;
	public static final int										DD_OrganDose = 638 ;
	public static final int										DD_OrganExposed = 639 ;
	public static final int										DD_BillingProcedureStepSequence = 640 ;
	public static final int										DD_FilmConsumptionSequence = 641 ;
	public static final int										DD_BillingSuppliesAndDevicesSequence = 642 ;
	public static final int										DD_ReferencedProcedureStepSequence = 643 ;
	public static final int										DD_PerformedSeriesSequence = 644 ;
	public static final int										DD_CommentsOnTheScheduledProcedureStep = 645 ;
	public static final int										DD_AcquisitionContextSequence = 646 ;
	public static final int										DD_AcquisitionContextDescription = 647 ;
	public static final int										DD_SlideIdentifier = 648 ;
	public static final int										DD_ImageCenterPointCoordinatesSequence = 649 ;
	public static final int										DD_XOffsetInSlideCoordinateSystem = 650 ;
	public static final int										DD_YOffsetInSlideCoordinateSystem = 651 ;
	public static final int										DD_ZOffsetInSlideCoordinateSystem = 652 ;
	public static final int										DD_PixelSpacingSequence = 653 ;
	public static final int										DD_CoordinateSystemAxisCodeSequence = 654 ;
	public static final int										DD_MeasurementUnitsCodeSequence = 655 ;
	public static final int										DD_ConceptnameCodeSequence = 656 ;
	public static final int										DD_Date_0040 = 657 ;
	public static final int										DD_Time_0040 = 658 ;
	public static final int										DD_PersonName = 659 ;
	public static final int										DD_ReferencedFrameNumbers = 660 ;
	public static final int										DD_TextValue = 661 ;
	public static final int										DD_ConceptCodeSequence = 662 ;
	public static final int										DD_NumericValue = 663 ;
	public static final int										DD_RequestedProcedureID = 664 ;
	public static final int										DD_ReasonForTheRequestedProcedure = 665 ;
	public static final int										DD_RequestedProcedurePriority = 666 ;
	public static final int										DD_PatientTransportArrangements = 667 ;
	public static final int										DD_RequestedProcedureLocation = 668 ;
	public static final int										DD_ConfidentialityCode = 669 ;
	public static final int										DD_ReportingPriority = 670 ;
	public static final int										DD_NamesOfIntendedRecipientsOfResults = 671 ;
	public static final int										DD_RequestedProcedureComments = 672 ;
	public static final int										DD_ReasonForTheImagingServiceRequest = 673 ;
	public static final int										DD_IssueDateOfImagingServiceRequest = 674 ;
	public static final int										DD_IssueTimeOfImagingServiceRequest = 675 ;
	public static final int										DD_OrderEnteredBy = 676 ;
	public static final int										DD_OrderEnterersLocation = 677 ;
	public static final int										DD_OrderCallbackPhoneNumber = 678 ;
	public static final int										DD_PlacerOrderNumberImagingServiceRequest = 679 ;
	public static final int										DD_FillerOrderNumberImagingServiceRequest = 680 ;
	public static final int										DD_ImagingServiceRequestComments = 681 ;
	public static final int										DD_ConfidentialityConstraintOnPatientDataDescription = 682 ;
	public static final int										DD_GroupLength_0050 = 683 ;
	public static final int										DD_CalibrationImage = 684 ;
	public static final int										DD_DeviceSequence = 685 ;
	public static final int										DD_DeviceLength = 686 ;
	public static final int										DD_DeviceDiameter = 687 ;
	public static final int										DD_DeviceDiameterUnits = 688 ;
	public static final int										DD_DeviceVolume = 689 ;
	public static final int										DD_IntermarkerDistance = 690 ;
	public static final int										DD_DeviceDescription = 691 ;
	public static final int										DD_GroupLength_0054 = 692 ;
	public static final int										DD_EnergyWindowVector = 693 ;
	public static final int										DD_NumberOfEnergyWindows = 694 ;
	public static final int										DD_EnergyWindowInformationSequence = 695 ;
	public static final int										DD_EnergyWindowRangeSequence = 696 ;
	public static final int										DD_EnergyWindowLowerLimit = 697 ;
	public static final int										DD_EnergyWindowUpperLimit = 698 ;
	public static final int										DD_RadiopharmaceuticalInformationSequence = 699 ;
	public static final int										DD_ResidualSyringeCounts = 700 ;
	public static final int										DD_EnergyWindowName = 701 ;
	public static final int										DD_DetectorVector = 702 ;
	public static final int										DD_NumberOfDetectors = 703 ;
	public static final int										DD_DetectorInformationSequence = 704 ;
	public static final int										DD_PhaseVector = 705 ;
	public static final int										DD_NumberOfPhases = 706 ;
	public static final int										DD_PhaseInformationSequence = 707 ;
	public static final int										DD_NumberOfFramesInPhase = 708 ;
	public static final int										DD_PhaseDelay = 709 ;
	public static final int										DD_PauseBetweenFrames = 710 ;
	public static final int										DD_RotationVector = 711 ;
	public static final int										DD_NumberOfRotations = 712 ;
	public static final int										DD_RotationInformationSequence = 713 ;
	public static final int										DD_NumberOfFramesInRotation = 714 ;
	public static final int										DD_RRIntervalVector = 715 ;
	public static final int										DD_NumberOfRRIntervals = 716 ;
	public static final int										DD_GatedInformationSequence = 717 ;
	public static final int										DD_DataInformationSequence = 718 ;
	public static final int										DD_TimeSlotVector = 719 ;
	public static final int										DD_NumberOfTimeSlots = 720 ;
	public static final int										DD_TimeSlotInformationSequence = 721 ;
	public static final int										DD_TimeSlotTime = 722 ;
	public static final int										DD_SliceVector = 723 ;
	public static final int										DD_NumberOfSlices = 724 ;
	public static final int										DD_AngularViewVector = 725 ;
	public static final int										DD_TimeSliceVector = 726 ;
	public static final int										DD_NumberOfTimeSlices = 727 ;
	public static final int										DD_StartAngle = 728 ;
	public static final int										DD_TypeOfDetectorMotion = 729 ;
	public static final int										DD_TriggerVector = 730 ;
	public static final int										DD_NumberOfTriggersInPhase = 731 ;
	public static final int										DD_ViewCodeSequence = 732 ;
	public static final int										DD_ViewModifierCodeSequence = 733 ;
	public static final int										DD_RadionuclideCodeSequence = 734 ;
	public static final int										DD_AdministrationRouteCodeSequence = 735 ;
	public static final int										DD_RadiopharmaceuticalCodeSequence = 736 ;
	public static final int										DD_CalibrationDataSequence = 737 ;
	public static final int										DD_EnergyWindowNumber = 738 ;
	public static final int										DD_ImageID = 739 ;
	public static final int										DD_PatientOrientationCodeSequence = 740 ;
	public static final int										DD_PatientOrientationModifierCodeSequence = 741 ;
	public static final int										DD_PatientGantryRelationshipCodeSequence = 742 ;
	public static final int										DD_SeriesType = 743 ;
	public static final int										DD_Units = 744 ;
	public static final int										DD_CountsSource = 745 ;
	public static final int										DD_ReprojectionMethod = 746 ;
	public static final int										DD_RandomsCorrectionMethod = 747 ;
	public static final int										DD_AttenuationCorrectionMethod = 748 ;
	public static final int										DD_DecayCorrection = 749 ;
	public static final int										DD_ReconstructionMethod = 750 ;
	public static final int										DD_DetectorLinesOfResponseUsed = 751 ;
	public static final int										DD_ScatterCorrectionMethod = 752 ;
	public static final int										DD_AxialAcceptance = 753 ;
	public static final int										DD_AxialMash = 754 ;
	public static final int										DD_TransverseMash = 755 ;
	public static final int										DD_DetectorElementSize = 756 ;
	public static final int										DD_CoincidenceWindowWidth = 757 ;
	public static final int										DD_SecondaryCountsType = 758 ;
	public static final int										DD_FrameReferenceTime = 759 ;
	public static final int										DD_PrimaryPromptsCountsAccumulated = 760 ;
	public static final int										DD_SecondaryCountsAccumulated = 761 ;
	public static final int										DD_SliceSensitivityFactor = 762 ;
	public static final int										DD_DecayFactor = 763 ;
	public static final int										DD_DoseCalibrationFactor = 764 ;
	public static final int										DD_ScatterFractionFactor = 765 ;
	public static final int										DD_DeadTimeFactor = 766 ;
	public static final int										DD_ImageIndex = 767 ;
	public static final int										DD_CountsIncluded = 768 ;
	public static final int										DD_DeadTimeCorrectionFlag = 769 ;
	public static final int										DD_HistogramSequence = 770 ;
	public static final int										DD_HistogramNumberOfBins = 771 ;
	public static final int										DD_HistogramFirstBinValue = 772 ;
	public static final int										DD_HistogramLastBinValue = 773 ;
	public static final int										DD_HistogramBinWidth = 774 ;
	public static final int										DD_HistogramExplanation = 775 ;
	public static final int										DD_HistogramData = 776 ;
	public static final int										DD_GroupLength_0088 = 777 ;
	public static final int										DD_StorageMediaFilesetID = 778 ;
	public static final int										DD_StorageMediaFilesetUID = 779 ;
	public static final int										DD_IconImageSequence = 780 ;
	public static final int										DD_TopicTitle = 781 ;
	public static final int										DD_TopicSubject = 782 ;
	public static final int										DD_TopicAuthor = 783 ;
	public static final int										DD_TopicKeyWords = 784 ;
	public static final int										DD_GroupLength_2000 = 785 ;
	public static final int										DD_NumberOfCopies = 786 ;
	public static final int										DD_PrinterConfigurationSequence = 787 ;
	public static final int										DD_PrintPriority = 788 ;
	public static final int										DD_MediumType = 789 ;
	public static final int										DD_FilmDestination = 790 ;
	public static final int										DD_FilmSessionLabel = 791 ;
	public static final int										DD_MemoryAllocation = 792 ;
	public static final int										DD_MaximumMemoryAllocation = 793 ;
	public static final int										DD_ColorImagePrintingFlag = 794 ;
	public static final int										DD_CollationFlag = 795 ;
	public static final int										DD_AnnotationFlag = 796 ;
	public static final int										DD_ImageOverlayFlag = 797 ;
	public static final int										DD_PresentationLUTFlag = 798 ;
	public static final int										DD_ImageBoxPresentationLUTFlag = 799 ;
	public static final int										DD_MemoryBitDepth = 800 ;
	public static final int										DD_PrintingBitDepth = 801 ;
	public static final int										DD_MediaInstalledSequence = 802 ;
	public static final int										DD_OtherMediaAvailableSequence = 803 ;
	public static final int										DD_SupportedImageDisplayFormatsSequence = 804 ;
	public static final int										DD_ReferencedFilmBoxSequence = 805 ;
	public static final int										DD_ReferencedStoredPrintSequence = 806 ;
	public static final int										DD_GroupLength_2010 = 807 ;
	public static final int										DD_ImageDisplayFormat = 808 ;
	public static final int										DD_AnnotationDisplayFormatID = 809 ;
	public static final int										DD_FilmOrientation = 810 ;
	public static final int										DD_FilmSizeID = 811 ;
	public static final int										DD_PrinterResolutionID = 812 ;
	public static final int										DD_DefaultPrinterResolutionID = 813 ;
	public static final int										DD_MagnificationType = 814 ;
	public static final int										DD_SmoothingType = 815 ;
	public static final int										DD_DefaultMagnificationType = 816 ;
	public static final int										DD_OtherMagnificationTypesAvailable = 817 ;
	public static final int										DD_DefaultSmoothingType = 818 ;
	public static final int										DD_OtherSmoothingTypesAvailable = 819 ;
	public static final int										DD_BorderDensity = 820 ;
	public static final int										DD_EmptyImageDensity = 821 ;
	public static final int										DD_MinDensity = 822 ;
	public static final int										DD_MaxDensity = 823 ;
	public static final int										DD_Trim = 824 ;
	public static final int										DD_ConfigurationInformation = 825 ;
	public static final int										DD_ConfigurationInformationDescription = 826 ;
	public static final int										DD_MaximumCollatedFilms = 827 ;
	public static final int										DD_Illumination = 828 ;
	public static final int										DD_ReflectedAmbientLight = 829 ;
	public static final int										DD_PrinterPixelSpacing = 830 ;
	public static final int										DD_ReferencedFilmSessionSequence = 831 ;
	public static final int										DD_ReferencedImageBoxSequence = 832 ;
	public static final int										DD_ReferencedBasicAnnotationBoxSequence = 833 ;
	public static final int										DD_GroupLength_2020 = 834 ;
	public static final int										DD_ImagePosition_2020 = 835 ;
	public static final int										DD_Polarity = 836 ;
	public static final int										DD_RequestedImageSize = 837 ;
	public static final int										DD_RequestedDecimateCropBehavior = 838 ;
	public static final int										DD_RequestedResolutionID = 839 ;
	public static final int										DD_RequestedImageSizeFlag = 840 ;
	public static final int										DD_DecimateCropResult = 841 ;
	public static final int										DD_BasicGrayscaleImageSequence = 842 ;
	public static final int										DD_BasicColorImageSequence = 843 ;
	public static final int										DD_ReferencedImageOverlayBoxSequence = 844 ;
	public static final int										DD_ReferencedVOILUTBoxSequence = 845 ;
	public static final int										DD_GroupLength_2030 = 846 ;
	public static final int										DD_AnnotationPosition = 847 ;
	public static final int										DD_TextString = 848 ;
	public static final int										DD_GroupLength_2040 = 849 ;
	public static final int										DD_ReferencedOverlayPlaneSequence = 850 ;
	public static final int										DD_ReferencedOverlayPlaneGroups = 851 ;
	public static final int										DD_OverlayPixelDataSequence = 852 ;
	public static final int										DD_OverlayMagnificationType = 853 ;
	public static final int										DD_OverlaySmoothingType = 854 ;
	public static final int										DD_OverlayOrImageMagnification = 855 ;
	public static final int										DD_MagnifyToNumberOfColumns = 856 ;
	public static final int										DD_OverlayForegroundDensity = 857 ;
	public static final int										DD_OverlayBackgroundDensity = 858 ;
	public static final int										DD_OverlayMode = 859 ;
	public static final int										DD_ThresholdDensity = 860 ;
	public static final int										DD_ReferencedImageBoxSequence_2040 = 861 ;
	public static final int										DD_PresentationLUTSequence = 862 ;
	public static final int										DD_PresentationLUTShape = 863 ;
	public static final int										DD_ReferencedPresentationLUTSequence = 864 ;
	public static final int										DD_GroupLength_2100 = 865 ;
	public static final int										DD_PrintJobID = 866 ;
	public static final int										DD_ExecutionStatus = 867 ;
	public static final int										DD_ExecutionStatusInfo = 868 ;
	public static final int										DD_CreationDate = 869 ;
	public static final int										DD_CreationTime = 870 ;
	public static final int										DD_Originator = 871 ;
	public static final int										DD_Destination = 872 ;
	public static final int										DD_OwnerID = 873 ;
	public static final int										DD_NumberOfFilms = 874 ;
	public static final int										DD_ReferencedPrintJobSequence = 875 ;
	public static final int										DD_GroupLength_2110 = 876 ;
	public static final int										DD_PrinterStatus = 877 ;
	public static final int										DD_PrinterStatusInfo = 878 ;
	public static final int										DD_PrinterName = 879 ;
	public static final int										DD_PrintQueueID = 880 ;
	public static final int										DD_QueueStatus = 881 ;
	public static final int										DD_PrintJobDescriptionSequence = 882 ;
	public static final int										DD_ReferencedPrintJobSequence_2120 = 883 ;
	public static final int										DD_PrintManagementCapabilitiesSequence = 884 ;
	public static final int										DD_PrinterCharacteristicsSequence = 885 ;
	public static final int										DD_FilmBoxContentSequence = 886 ;
	public static final int										DD_ImageBoxContentSequence = 887 ;
	public static final int										DD_AnnotationContentSequence = 888 ;
	public static final int										DD_ImageOverlayBoxContentSequence = 889 ;
	public static final int										DD_PresentationLUTContentSequence = 890 ;
	public static final int										DD_ProposedStudySequence = 891 ;
	public static final int										DD_OriginalImageSequence = 892 ;
	public static final int										DD_RTImageLabel = 893 ;
	public static final int										DD_RTImageName = 894 ;
	public static final int										DD_RTImageDescription = 895 ;
	public static final int										DD_ReportedValuesOrigin = 896 ;
	public static final int										DD_RTImagePlane = 897 ;
	public static final int										DD_XRayImageReceptorAngle = 898 ;
	public static final int										DD_RTImageOrientation = 899 ;
	public static final int										DD_ImagePlanePixelSpacing = 900 ;
	public static final int										DD_RTImagePosition = 901 ;
	public static final int										DD_RadiationMachineName = 902 ;
	public static final int										DD_RadiationMachineSAD = 903 ;
	public static final int										DD_RadiationMachineSSD = 904 ;
	public static final int										DD_RTImageSID = 905 ;
	public static final int										DD_SourceToReferenceObjectDistance = 906 ;
	public static final int										DD_FractionNumber = 907 ;
	public static final int										DD_ExposureSequence = 908 ;
	public static final int										DD_MetersetExposure = 909 ;
	public static final int										DD_DVHType = 910 ;
	public static final int										DD_DoseUnits = 911 ;
	public static final int										DD_DoseType = 912 ;
	public static final int										DD_DoseComment = 913 ;
	public static final int										DD_NormalizationPoint = 914 ;
	public static final int										DD_DoseSummationType = 915 ;
	public static final int										DD_GridFrameOffsetVector = 916 ;
	public static final int										DD_DoseGridScaling = 917 ;
	public static final int										DD_RTDoseROISequence = 918 ;
	public static final int										DD_DoseValue = 919 ;
	public static final int										DD_DVHNormalizationPoint = 920 ;
	public static final int										DD_DVHNormalizationDoseValue = 921 ;
	public static final int										DD_DVHSequence = 922 ;
	public static final int										DD_DVHDoseScaling = 923 ;
	public static final int										DD_DVHVolumeUnits = 924 ;
	public static final int										DD_DVHNumberOfBins = 925 ;
	public static final int										DD_DVHData = 926 ;
	public static final int										DD_DVHReferencedROISequence = 927 ;
	public static final int										DD_DVHROIContributionType = 928 ;
	public static final int										DD_DVHMinimumDose = 929 ;
	public static final int										DD_DVHMaximumDose = 930 ;
	public static final int										DD_DVHMeanDose = 931 ;
	public static final int										DD_StructureSetLabel = 932 ;
	public static final int										DD_StructureSetName = 933 ;
	public static final int										DD_StructureSetDescription = 934 ;
	public static final int										DD_StructureSetDate = 935 ;
	public static final int										DD_StructureSetTime = 936 ;
	public static final int										DD_ReferencedFrameOfReferenceSequence = 937 ;
	public static final int										DD_RTReferencedStudySequence = 938 ;
	public static final int										DD_RTReferencedSeriesSequence = 939 ;
	public static final int										DD_ContourImageSequence = 940 ;
	public static final int										DD_StructureSetROISequence = 941 ;
	public static final int										DD_ROINumber = 942 ;
	public static final int										DD_ReferencedFrameOfReferenceUID = 943 ;
	public static final int										DD_ROIName = 944 ;
	public static final int										DD_ROIDescription = 945 ;
	public static final int										DD_ROIDisplayColor = 946 ;
	public static final int										DD_ROIVolume = 947 ;
	public static final int										DD_RTRelatedROISequence = 948 ;
	public static final int										DD_RTROIRelationship = 949 ;
	public static final int										DD_ROIGenerationAlgorithm = 950 ;
	public static final int										DD_ROIGenerationDescription = 951 ;
	public static final int										DD_ROIContourSequence = 952 ;
	public static final int										DD_ContourSequence = 953 ;
	public static final int										DD_ContourGeometricType = 954 ;
	public static final int										DD_ContourSlabThickness = 955 ;
	public static final int										DD_ContourOffsetVector = 956 ;
	public static final int										DD_NumberOfContourPoints = 957 ;
	public static final int										DD_ContourData = 958 ;
	public static final int										DD_RTROIObservationsSequence = 959 ;
	public static final int										DD_ObservationNumber = 960 ;
	public static final int										DD_ReferencedROINumber = 961 ;
	public static final int										DD_ROIObservationLabel = 962 ;
	public static final int										DD_RTROIIdentificationCodeSequence = 963 ;
	public static final int										DD_ROIObservationDescription = 964 ;
	public static final int										DD_RelatedRTROIObservationsSequence = 965 ;
	public static final int										DD_RTROIInterpretedType = 966 ;
	public static final int										DD_ROIInterpreter = 967 ;
	public static final int										DD_ROIPhysicalPropertiesSequence = 968 ;
	public static final int										DD_ROIPhysicalProperty = 969 ;
	public static final int										DD_ROIPhysicalPropertyValue = 970 ;
	public static final int										DD_FrameOfReferenceRelationshipSequence = 971 ;
	public static final int										DD_RelatedFrameOfReferenceUID = 972 ;
	public static final int										DD_FrameOfReferenceTransformationType = 973 ;
	public static final int										DD_FrameOfReferenceTransformationMatrix = 974 ;
	public static final int										DD_FrameOfReferenceTransformationComment = 975 ;
	public static final int										DD_MeasuredDoseReferenceSequence = 976 ;
	public static final int										DD_MeasuredDoseDescription = 977 ;
	public static final int										DD_MeasuredDoseType = 978 ;
	public static final int										DD_MeasuredDoseValue = 979 ;
	public static final int										DD_TreatmentSessionBeamSequence = 980 ;
	public static final int										DD_CurrentFractionNumber = 981 ;
	public static final int										DD_TreatmentControlPointDate = 982 ;
	public static final int										DD_TreatmentControlPointTime = 983 ;
	public static final int										DD_TreatmentTerminationStatus = 984 ;
	public static final int										DD_TreatmentTerminationCode = 985 ;
	public static final int										DD_TreatmentVerificationStatus = 986 ;
	public static final int										DD_ReferencedTreatmentRecordSequence = 987 ;
	public static final int										DD_SpecifiedPrimaryMeterset = 988 ;
	public static final int										DD_SpecifiedSecondaryMeterset = 989 ;
	public static final int										DD_DeliveredPrimaryMeterset = 990 ;
	public static final int										DD_DeliveredSecondaryMeterset = 991 ;
	public static final int										DD_SpecifiedTreatmentTime = 992 ;
	public static final int										DD_DeliveredTreatmentTime = 993 ;
	public static final int										DD_ControlPointDeliverySequence = 994 ;
	public static final int										DD_SpecifiedMeterset = 995 ;
	public static final int										DD_DeliveredMeterset = 996 ;
	public static final int										DD_DoseRateDelivered = 997 ;
	public static final int										DD_CumulativeDoseToDoseReference = 998 ;
	public static final int										DD_FirstTreatmentDate = 999 ;
	public static final int										DD_MostRecentTreatmentDate = 1000 ;
	public static final int										DD_NumberOfFractionsDelivered = 1001 ;
	public static final int										DD_OverrideSequence = 1002 ;
	public static final int										DD_OverrideParameterPointer = 1003 ;
	public static final int										DD_MeasuredDoseReferenceNumber = 1004 ;
	public static final int										DD_OverrideReason = 1005 ;
	public static final int										DD_CalculatedDoseReferenceSequence = 1006 ;
	public static final int										DD_CalculatedDoseReferenceNumber = 1007 ;
	public static final int										DD_CalculatedDoseReferenceDescription = 1008 ;
	public static final int										DD_CalculatedDoseReferenceDoseValue = 1009 ;
	public static final int										DD_StartMeterset = 1010 ;
	public static final int										DD_EndMeterset = 1011 ;
	public static final int										DD_ReferencedMeasuredDoseReferenceSequence = 1012 ;
	public static final int										DD_ReferencedMeasuredDoseReferenceNumber = 1013 ;
	public static final int										DD_ReferencedCalculatedDoseReferenceSequence = 1014 ;
	public static final int										DD_ReferencedCalculatedDoseReferenceNumber = 1015 ;
	public static final int										DD_BeamLimitingDeviceLeafPairsSequence = 1016 ;
	public static final int										DD_RecordedWedgeSequence = 1017 ;
	public static final int										DD_RecordedCompensatorSequence = 1018 ;
	public static final int										DD_RecordedBlockSequence = 1019 ;
	public static final int										DD_TreatmentSummaryMeasuredDoseReferenceSequence = 1020 ;
	public static final int										DD_RecordedSourceSequence = 1021 ;
	public static final int										DD_SourceSerialNumber = 1022 ;
	public static final int										DD_TreatmentSessionApplicationSetupSequence = 1023 ;
	public static final int										DD_ApplicationSetupCheck = 1024 ;
	public static final int										DD_RecordedBrachyAccessoryDeviceSequence = 1025 ;
	public static final int										DD_ReferencedBrachyAccessoryDeviceNumber = 1026 ;
	public static final int										DD_RecordedChannelSequence = 1027 ;
	public static final int										DD_SpecifiedChannelTotalTime = 1028 ;
	public static final int										DD_DeliveredChannelTotalTime = 1029 ;
	public static final int										DD_SpecifiedNumberOfPulses = 1030 ;
	public static final int										DD_DeliveredNumberOfPulses = 1031 ;
	public static final int										DD_SpecifiedPulseRepetitionInterval = 1032 ;
	public static final int										DD_DeliveredPulseRepetitionInterval = 1033 ;
	public static final int										DD_RecordedSourceApplicatorSequence = 1034 ;
	public static final int										DD_ReferencedSourceApplicatorNumber = 1035 ;
	public static final int										DD_RecordedChannelShieldSequence = 1036 ;
	public static final int										DD_ReferencedChannelShieldNumber = 1037 ;
	public static final int										DD_BrachyControlPointDeliveredSequence = 1038 ;
	public static final int										DD_SafePositionExitDate = 1039 ;
	public static final int										DD_SafePositionExitTime = 1040 ;
	public static final int										DD_SafePositionReturnDate = 1041 ;
	public static final int										DD_SafePositionReturnTime = 1042 ;
	public static final int										DD_CurrentTreatmentStatus = 1043 ;
	public static final int										DD_TreatmentStatusComment = 1044 ;
	public static final int										DD_FractionGroupSummarySequence = 1045 ;
	public static final int										DD_ReferencedFractionNumber = 1046 ;
	public static final int										DD_FractionGroupType = 1047 ;
	public static final int										DD_BeamStopperPosition = 1048 ;
	public static final int										DD_FractionStatusSummarySequence = 1049 ;
	public static final int										DD_TreatmentDate = 1050 ;
	public static final int										DD_TreatmentTime = 1051 ;
	public static final int										DD_RTPlanLabel = 1052 ;
	public static final int										DD_RTPlanName = 1053 ;
	public static final int										DD_RTPlanDescription = 1054 ;
	public static final int										DD_RTPlanDate = 1055 ;
	public static final int										DD_RTPlanTime = 1056 ;
	public static final int										DD_TreatmentProtocols = 1057 ;
	public static final int										DD_TreatmentIntent = 1058 ;
	public static final int										DD_TreatmentSites = 1059 ;
	public static final int										DD_RTPlanGeometry = 1060 ;
	public static final int										DD_PrescriptionDescription = 1061 ;
	public static final int										DD_DoseReferenceSequence = 1062 ;
	public static final int										DD_DoseReferenceNumber = 1063 ;
	public static final int										DD_DoseReferenceStructureType = 1064 ;
	public static final int										DD_NominalBeamEnergyUnit = 1065 ;
	public static final int										DD_DoseReferenceDescription = 1066 ;
	public static final int										DD_DoseReferencePointCoordinates = 1067 ;
	public static final int										DD_NominalPriorDose = 1068 ;
	public static final int										DD_DoseReferenceType = 1069 ;
	public static final int										DD_ConstraintWeight = 1070 ;
	public static final int										DD_DeliveryWarningDose = 1071 ;
	public static final int										DD_DeliveryMaximumDose = 1072 ;
	public static final int										DD_TargetMinimumDose = 1073 ;
	public static final int										DD_TargetPrescriptionDose = 1074 ;
	public static final int										DD_TargetMaximumDose = 1075 ;
	public static final int										DD_TargetUnderdoseVolumeFraction = 1076 ;
	public static final int										DD_OrganAtRiskFullvolumeDose = 1077 ;
	public static final int										DD_OrganAtRiskLimitDose = 1078 ;
	public static final int										DD_OrganAtRiskMaximumDose = 1079 ;
	public static final int										DD_OrganAtRiskOverdoseVolumeFraction = 1080 ;
	public static final int										DD_ToleranceTableSequence = 1081 ;
	public static final int										DD_ToleranceTableNumber = 1082 ;
	public static final int										DD_ToleranceTableLabel = 1083 ;
	public static final int										DD_GantryAngleTolerance = 1084 ;
	public static final int										DD_BeamLimitingDeviceAngleTolerance = 1085 ;
	public static final int										DD_BeamLimitingDeviceToleranceSequence = 1086 ;
	public static final int										DD_BeamLimitingDevicePositionTolerance = 1087 ;
	public static final int										DD_PatientSupportAngleTolerance = 1088 ;
	public static final int										DD_TableTopEccentricAngleTolerance = 1089 ;
	public static final int										DD_TableTopVerticalPositionTolerance = 1090 ;
	public static final int										DD_TableTopLongitudinalPositionTolerance = 1091 ;
	public static final int										DD_TableTopLateralPositionTolerance = 1092 ;
	public static final int										DD_RTPlanRelationship = 1093 ;
	public static final int										DD_FractionGroupSequence = 1094 ;
	public static final int										DD_FractionGroupNumber = 1095 ;
	public static final int										DD_NumberOfFractionsPlanned = 1096 ;
	public static final int										DD_NumberOfFractionsPerDay = 1097 ;
	public static final int										DD_RepeatFractionCycleLength = 1098 ;
	public static final int										DD_FractionPattern = 1099 ;
	public static final int										DD_NumberOfBeams = 1100 ;
	public static final int										DD_BeamDoseSpecificationPoint = 1101 ;
	public static final int										DD_BeamDose_300A = 1102 ;
	public static final int										DD_BeamMeterset = 1103 ;
	public static final int										DD_NumberOfBrachyApplicationSetups = 1104 ;
	public static final int										DD_BrachyApplicationSetupDoseSpecificationPoint = 1105 ;
	public static final int										DD_BrachyApplicationSetupDose_300A = 1106 ;
	public static final int										DD_BeamSequence = 1107 ;
	public static final int										DD_TreatmentMachineName = 1108 ;
	public static final int										DD_PrimaryDosimeterUnit = 1109 ;
	public static final int										DD_SourceAxisDistance = 1110 ;
	public static final int										DD_BeamLimitingDeviceSequence = 1111 ;
	public static final int										DD_RTBeamLimitingDeviceType = 1112 ;
	public static final int										DD_SourceToBeamLimitingDeviceDistance = 1113 ;
	public static final int										DD_NumberOfLeafJawPairs = 1114 ;
	public static final int										DD_LeafPositionBoundaries = 1115 ;
	public static final int										DD_BeamNumber = 1116 ;
	public static final int										DD_BeamName = 1117 ;
	public static final int										DD_BeamDescription = 1118 ;
	public static final int										DD_BeamType = 1119 ;
	public static final int										DD_RadiationType = 1120 ;
	public static final int										DD_ReferenceImageNumber = 1121 ;
	public static final int										DD_PlannedVerificationImageSequence = 1122 ;
	public static final int										DD_ImagingDeviceSpecificAcquisitionParameters = 1123 ;
	public static final int										DD_TreatmentDeliveryType = 1124 ;
	public static final int										DD_NumberOfWedges = 1125 ;
	public static final int										DD_WedgeSequence = 1126 ;
	public static final int										DD_WedgeNumber = 1127 ;
	public static final int										DD_WedgeType = 1128 ;
	public static final int										DD_WedgeID = 1129 ;
	public static final int										DD_WedgeAngle = 1130 ;
	public static final int										DD_WedgeFactor = 1131 ;
	public static final int										DD_WedgeOrientation = 1132 ;
	public static final int										DD_SourceToWedgeTrayDistance = 1133 ;
	public static final int										DD_NumberOfCompensators = 1134 ;
	public static final int										DD_MaterialID = 1135 ;
	public static final int										DD_TotalCompensatorTrayFactor = 1136 ;
	public static final int										DD_CompensatorSequence = 1137 ;
	public static final int										DD_CompensatorNumber = 1138 ;
	public static final int										DD_CompensatorID = 1139 ;
	public static final int										DD_SourceToCompensatorTrayDistance = 1140 ;
	public static final int										DD_CompensatorRows = 1141 ;
	public static final int										DD_CompensatorColumns = 1142 ;
	public static final int										DD_CompensatorPixelSpacing = 1143 ;
	public static final int										DD_CompensatorPosition = 1144 ;
	public static final int										DD_CompensatorTransmissionData = 1145 ;
	public static final int										DD_CompensatorThicknessData = 1146 ;
	public static final int										DD_NumberOfBoli = 1147 ;
	public static final int										DD_CompensatorType = 1148 ;
	public static final int										DD_NumberOfBlocks = 1149 ;
	public static final int										DD_TotalBlockTrayFactor = 1150 ;
	public static final int										DD_BlockSequence = 1151 ;
	public static final int										DD_BlockTrayID = 1152 ;
	public static final int										DD_SourceToBlockTrayDistance = 1153 ;
	public static final int										DD_BlockType = 1154 ;
	public static final int										DD_BlockDivergence = 1155 ;
	public static final int										DD_BlockNumber = 1156 ;
	public static final int										DD_BlockName = 1157 ;
	public static final int										DD_BlockThickness = 1158 ;
	public static final int										DD_BlockTransmission = 1159 ;
	public static final int										DD_BlockNumberOfPoints = 1160 ;
	public static final int										DD_BlockData = 1161 ;
	public static final int										DD_ApplicatorSequence = 1162 ;
	public static final int										DD_ApplicatorID = 1163 ;
	public static final int										DD_ApplicatorType = 1164 ;
	public static final int										DD_ApplicatorDescription = 1165 ;
	public static final int										DD_CumulativeDoseReferenceCoefficient = 1166 ;
	public static final int										DD_FinalCumulativeMetersetWeight = 1167 ;
	public static final int										DD_NumberOfControlPoints = 1168 ;
	public static final int										DD_ControlPointSequence = 1169 ;
	public static final int										DD_ControlPointIndex = 1170 ;
	public static final int										DD_NominalBeamEnergy_300A = 1171 ;
	public static final int										DD_DoseRateSet = 1172 ;
	public static final int										DD_WedgePositionSequence = 1173 ;
	public static final int										DD_WedgePosition_300A = 1174 ;
	public static final int										DD_BeamLimitingDevicePositionSequence = 1175 ;
	public static final int										DD_LeafJawPositions = 1176 ;
	public static final int										DD_GantryAngle_300A = 1177 ;
	public static final int										DD_GantryRotationDirection = 1178 ;
	public static final int										DD_BeamLimitingDeviceAngle_300A = 1179 ;
	public static final int										DD_BeamLimitingDeviceRotationDirection = 1180 ;
	public static final int										DD_PatientSupportAngle_300A = 1181 ;
	public static final int										DD_PatientSupportRotationDirection = 1182 ;
	public static final int										DD_TableTopEccentricAxisDistance = 1183 ;
	public static final int										DD_TableTopEccentricAngle_300A = 1184 ;
	public static final int										DD_TableTopEccentricRotationDirection = 1185 ;
	public static final int										DD_TableTopVerticalPosition_300A = 1186 ;
	public static final int										DD_TableTopLongitudinalPosition_300A = 1187 ;
	public static final int										DD_TableTopLateralPosition_300A = 1188 ;
	public static final int										DD_IsocenterPosition = 1189 ;
	public static final int										DD_SurfaceEntryPoint = 1190 ;
	public static final int										DD_SourceToSurfaceDistance = 1191 ;
	public static final int										DD_CumulativeMetersetWeight = 1192 ;
	public static final int										DD_PatientSetupSequence = 1193 ;
	public static final int										DD_PatientSetupNumber = 1194 ;
	public static final int										DD_PatientAdditionalPosition = 1195 ;
	public static final int										DD_FixationDeviceSequence = 1196 ;
	public static final int										DD_FixationDeviceType = 1197 ;
	public static final int										DD_FixationDeviceLabel = 1198 ;
	public static final int										DD_FixationDeviceDescription = 1199 ;
	public static final int										DD_FixationDevicePosition = 1200 ;
	public static final int										DD_ShieldingDeviceSequence = 1201 ;
	public static final int										DD_ShieldingDeviceType = 1202 ;
	public static final int										DD_ShieldingDeviceLabel = 1203 ;
	public static final int										DD_ShieldingDeviceDescription = 1204 ;
	public static final int										DD_ShieldingDevicePosition = 1205 ;
	public static final int										DD_SetupTechnique = 1206 ;
	public static final int										DD_SetupTechniqueDescription = 1207 ;
	public static final int										DD_SetupDeviceSequence = 1208 ;
	public static final int										DD_SetupDeviceType = 1209 ;
	public static final int										DD_SetupDeviceLabel = 1210 ;
	public static final int										DD_SetupDeviceDescription = 1211 ;
	public static final int										DD_SetupDeviceParameter = 1212 ;
	public static final int										DD_SetupReferenceDescription = 1213 ;
	public static final int										DD_TableTopVerticalSetupDisplacement = 1214 ;
	public static final int										DD_TableTopLongitudinalSetupDisplacement = 1215 ;
	public static final int										DD_TableTopLateralSetupDisplacement = 1216 ;
	public static final int										DD_BrachyTreatmentTechnique = 1217 ;
	public static final int										DD_BrachyTreatmentType = 1218 ;
	public static final int										DD_TreatmentMachineSequence = 1219 ;
	public static final int										DD_SourceSequence = 1220 ;
	public static final int										DD_SourceNumber = 1221 ;
	public static final int										DD_SourceType = 1222 ;
	public static final int										DD_SourceManufacturer = 1223 ;
	public static final int										DD_ActiveSourceDiameter = 1224 ;
	public static final int										DD_ActiveSourceLength = 1225 ;
	public static final int										DD_SourceEncapsulationNominalThickness = 1226 ;
	public static final int										DD_SourceEncapsulationNominalTransmission = 1227 ;
	public static final int										DD_SourceIsotopeName = 1228 ;
	public static final int										DD_SourceIsotopeHalfLife = 1229 ;
	public static final int										DD_ReferenceAirKermaRate = 1230 ;
	public static final int										DD_AirKermaRateReferenceDate = 1231 ;
	public static final int										DD_AirKermaRateReferenceTime = 1232 ;
	public static final int										DD_ApplicationSetupSequence = 1233 ;
	public static final int										DD_ApplicationSetupType = 1234 ;
	public static final int										DD_ApplicationSetupNumber = 1235 ;
	public static final int										DD_ApplicationSetupName = 1236 ;
	public static final int										DD_ApplicationSetupManufacturer = 1237 ;
	public static final int										DD_TemplateNumber = 1238 ;
	public static final int										DD_TemplateType = 1239 ;
	public static final int										DD_TemplateName = 1240 ;
	public static final int										DD_TotalReferenceAirKerma = 1241 ;
	public static final int										DD_BrachyAccessoryDeviceSequence = 1242 ;
	public static final int										DD_BrachyAccessoryDeviceNumber = 1243 ;
	public static final int										DD_BrachyAccessoryDeviceID = 1244 ;
	public static final int										DD_BrachyAccessoryDeviceType = 1245 ;
	public static final int										DD_BrachyAccessoryDeviceName = 1246 ;
	public static final int										DD_BrachyAccessoryDeviceNominalThickness = 1247 ;
	public static final int										DD_BrachyAccessoryDeviceNominalTransmission = 1248 ;
	public static final int										DD_ChannelSequence = 1249 ;
	public static final int										DD_ChannelNumber = 1250 ;
	public static final int										DD_ChannelLength = 1251 ;
	public static final int										DD_ChannelTotalTime = 1252 ;
	public static final int										DD_SourceMovementType = 1253 ;
	public static final int										DD_NumberOfPulses = 1254 ;
	public static final int										DD_PulseRepetitionInterval = 1255 ;
	public static final int										DD_SourceApplicatorNumber = 1256 ;
	public static final int										DD_SourceApplicatorID = 1257 ;
	public static final int										DD_SourceApplicatorType = 1258 ;
	public static final int										DD_SourceApplicatorName = 1259 ;
	public static final int										DD_SourceApplicatorLength = 1260 ;
	public static final int										DD_SourceApplicatorManufacturer = 1261 ;
	public static final int										DD_SourceApplicatorWallNominalThickness = 1262 ;
	public static final int										DD_SourceApplicatorWallNominalTransmission = 1263 ;
	public static final int										DD_SourceApplicatorStepSize = 1264 ;
	public static final int										DD_TransferTubeNumber = 1265 ;
	public static final int										DD_TransferTubeLength = 1266 ;
	public static final int										DD_ChannelShieldSequence = 1267 ;
	public static final int										DD_ChannelShieldNumber = 1268 ;
	public static final int										DD_ChannelShieldID = 1269 ;
	public static final int										DD_ChannelShieldName = 1270 ;
	public static final int										DD_ChannelShieldNominalThickness = 1271 ;
	public static final int										DD_ChannelShieldNominalTransmission = 1272 ;
	public static final int										DD_FinalCumulativeTimeWeight = 1273 ;
	public static final int										DD_BrachyControlPointSequence = 1274 ;
	public static final int										DD_ControlPointRelativePosition = 1275 ;
	public static final int										DD_ControlPoint3DPosition = 1276 ;
	public static final int										DD_CumulativeTimeWeight = 1277 ;
	public static final int										DD_ReferencedRTPlanSequence = 1278 ;
	public static final int										DD_ReferencedBeamSequence = 1279 ;
	public static final int										DD_ReferencedBeamNumber = 1280 ;
	public static final int										DD_ReferencedReferenceImageNumber = 1281 ;
	public static final int										DD_StartCumulativeMetersetWeight = 1282 ;
	public static final int										DD_EndCumulativeMetersetWeight = 1283 ;
	public static final int										DD_ReferencedBrachyApplicationSetupSequence = 1284 ;
	public static final int										DD_ReferencedBrachyApplicationSetupNumber = 1285 ;
	public static final int										DD_ReferencedSourceNumber = 1286 ;
	public static final int										DD_ReferencedFractionGroupSequence = 1287 ;
	public static final int										DD_ReferencedFractionGroupNumber = 1288 ;
	public static final int										DD_ReferencedVerificationImageSequence = 1289 ;
	public static final int										DD_ReferencedReferenceImageSequence = 1290 ;
	public static final int										DD_ReferencedDoseReferenceSequence = 1291 ;
	public static final int										DD_ReferencedDoseReferenceNumber = 1292 ;
	public static final int										DD_BrachyReferencedDoseReferenceSequence = 1293 ;
	public static final int										DD_ReferencedStructureSetSequence = 1294 ;
	public static final int										DD_ReferencedPatientSetupNumber = 1295 ;
	public static final int										DD_ReferencedDoseSequence = 1296 ;
	public static final int										DD_ReferencedToleranceTableNumber = 1297 ;
	public static final int										DD_ReferencedBolusSequence = 1298 ;
	public static final int										DD_ReferencedWedgeNumber = 1299 ;
	public static final int										DD_ReferencedCompensatorNumber = 1300 ;
	public static final int										DD_ReferencedBlockNumber = 1301 ;
	public static final int										DD_ReferencedControlPointIndex = 1302 ;
	public static final int										DD_ApprovalStatus = 1303 ;
	public static final int										DD_ReviewDate = 1304 ;
	public static final int										DD_ReviewTime = 1305 ;
	public static final int										DD_ReviewerName = 1306 ;
	public static final int										DD_GroupLength_4008 = 1307 ;
	public static final int										DD_ResultsID = 1308 ;
	public static final int										DD_ResultsIDIssuer = 1309 ;
	public static final int										DD_ReferencedInterpretationSequence = 1310 ;
	public static final int										DD_InterpretationRecordedDate = 1311 ;
	public static final int										DD_InterpretationRecordedTime = 1312 ;
	public static final int										DD_InterpretationRecorder = 1313 ;
	public static final int										DD_ReferenceToRecordedSound = 1314 ;
	public static final int										DD_InterpretationTranscriptionDate = 1315 ;
	public static final int										DD_InterpretationTranscriptionTime = 1316 ;
	public static final int										DD_InterpretationTranscriber = 1317 ;
	public static final int										DD_InterpretationText = 1318 ;
	public static final int										DD_InterpretationAuthor = 1319 ;
	public static final int										DD_InterpretationApproverSequence = 1320 ;
	public static final int										DD_InterpretationApprovalDate = 1321 ;
	public static final int										DD_InterpretationApprovalTime = 1322 ;
	public static final int										DD_PhysicianApprovingInterpretation = 1323 ;
	public static final int										DD_InterpretationDiagnosisDescription = 1324 ;
	public static final int										DD_InterpretationDiagnosisCodeSequence = 1325 ;
	public static final int										DD_ResultsDistributionListSequence = 1326 ;
	public static final int										DD_DistributionName = 1327 ;
	public static final int										DD_DistributionAddress = 1328 ;
	public static final int										DD_InterpretationID = 1329 ;
	public static final int										DD_InterpretationIDIssuer = 1330 ;
	public static final int										DD_InterpretationTypeID = 1331 ;
	public static final int										DD_InterpretationStatusID = 1332 ;
	public static final int										DD_Impressions = 1333 ;
	public static final int										DD_ResultsComments = 1334 ;
	public static final int										DD_GroupLength_5000 = 1335 ;
	public static final int										DD_CurveDimensions = 1336 ;
	public static final int										DD_NumberOfPoints = 1337 ;
	public static final int										DD_TypeOfData = 1338 ;
	public static final int										DD_CurveDescription = 1339 ;
	public static final int										DD_AxisUnits = 1340 ;
	public static final int										DD_AxisLabels = 1341 ;
	public static final int										DD_DataValueRepresentation = 1342 ;
	public static final int										DD_MinimumCoordinateValue = 1343 ;
	public static final int										DD_MaximumCoordinateValue = 1344 ;
	public static final int										DD_CurveRange = 1345 ;
	public static final int										DD_CurveDataDescriptor = 1346 ;
	public static final int										DD_CoordinateStartValue = 1347 ;
	public static final int										DD_CoordinateStepValue = 1348 ;
	public static final int										DD_AudioType = 1349 ;
	public static final int										DD_AudioSampleFormat = 1350 ;
	public static final int										DD_NumberOfChannels = 1351 ;
	public static final int										DD_NumberOfSamples = 1352 ;
	public static final int										DD_SampleRate = 1353 ;
	public static final int										DD_TotalTime_5000 = 1354 ;
	public static final int										DD_AudioSampleData = 1355 ;
	public static final int										DD_AudioComments = 1356 ;
	public static final int										DD_CurveLabel = 1357 ;
	public static final int										DD_ReferencedOverlaySequence_5000 = 1358 ;
	public static final int										DD_ReferencedOverlayGroup = 1359 ;
	public static final int										DD_CurveData_5000 = 1360 ;
	public static final int										DD_GroupLength_6000 = 1361 ;
	public static final int										DD_OverlayRows = 1362 ;
	public static final int										DD_OverlayColumns = 1363 ;
	public static final int										DD_OverlayPlanes = 1364 ;
	public static final int										DD_NumberOfFramesInOverlay = 1365 ;
	public static final int										DD_OverlayDescription = 1366 ;
	public static final int										DD_OverlayType = 1367 ;
	public static final int										DD_OverlaySubtype = 1368 ;
	public static final int										DD_OverlayOrigin = 1369 ;
	public static final int										DD_ImageFrameOrigin = 1370 ;
	public static final int										DD_OverlayPlaneOrigin = 1371 ;
	public static final int										DD_OverlayBitsAllocated = 1372 ;
	public static final int										DD_OverlayBitPosition = 1373 ;
	public static final int										DD_OverlayDescriptorGray = 1374 ;
	public static final int										DD_OverlayDescriptorRed = 1375 ;
	public static final int										DD_OverlayDescriptorGreen = 1376 ;
	public static final int										DD_OverlayDescriptorBlue = 1377 ;
	public static final int										DD_OverlaysGray = 1378 ;
	public static final int										DD_OverlaysRed = 1379 ;
	public static final int										DD_OverlaysGreen = 1380 ;
	public static final int										DD_OverlaysBlue = 1381 ;
	public static final int										DD_ROIArea = 1382 ;
	public static final int										DD_ROIMean = 1383 ;
	public static final int										DD_ROIStandardDeviation = 1384 ;
	public static final int										DD_OverlayLabel = 1385 ;
	public static final int										DD_OverlayData = 1386 ;
	public static final int										DD_GroupLength_7FE0 = 1387 ;
	public static final int										DD_PixelData = 1388 ;
	public static final int										DD_DataSetTrailingPadding = 1389 ;
	public static final int										DD_GroupLength_0002 = 1390 ;
	public static final int										DD_FileMetaInformationVersion = 1391 ;
	public static final int										DD_MediaStorageSOPClassUID = 1392 ;
	public static final int										DD_MediaStorageSOPInstanceUID = 1393 ;
	public static final int										DD_TransferSyntaxUID = 1394 ;
	public static final int										DD_ImplementationClassUID = 1395 ;
	public static final int										DD_ImplementationVersionName = 1396 ;
	public static final int										DD_SourceApplicationEntityTitle = 1397 ;
	public static final int										DD_PrivateInformationCreatorUID = 1398 ;
	public static final int										DD_PrivateInformation_0002 = 1399 ;
	public static final int										DD_GroupLength_0004 = 1400 ;
	public static final int										DD_FileSetID = 1401 ;
	public static final int										DD_FileSetDescriptorFileID = 1402 ;
	public static final int										DD_SpecificCharacterSetOfFileSetDescriptorFile = 1403 ;
	public static final int										DD_OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity = 1404 ;
	public static final int										DD_OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity = 1405 ;
	public static final int										DD_FileSetConsistencyFlag = 1406 ;
	public static final int										DD_DirectoryRecordSequence = 1407 ;
	public static final int										DD_OffsetOfTheNextDirectoryRecord = 1408 ;
	public static final int										DD_RecordInUseFlag = 1409 ;
	public static final int										DD_OffsetOfReferencedLowerLevelDirectoryEntity = 1410 ;
	public static final int										DD_DirectoryRecordType = 1411 ;
	public static final int										DD_PrivateRecordUID = 1412 ;
	public static final int										DD_ReferencedFileID = 1413 ;
	public static final int										DD_MRDRDirectoryRecordOffset = 1414 ;
	public static final int										DD_ReferencedSOPClassUIDInFile = 1415 ;
	public static final int										DD_ReferencedSOPInstanceUIDInFile = 1416 ;
	public static final int										DD_ReferencedTransferSyntaxUIDInFile = 1417 ;
	public static final int										DD_NumberOfReferences = 1418 ;
	public static final int										DD_Item = 1419 ;
	public static final int										DD_ItemDelimitationItem = 1420 ;
	public static final int										DD_SequenceDelimitationItem = 1421 ;

	// public static final int										DD_ACRNEMA_CommandLengthToEnd = 2000 ;
	// public static final int										DD_ACRNEMA_Initiator = 2002 ;
	// public static final int										DD_ACRNEMA_Receiver = 2003 ;
	// public static final int										DD_ACRNEMA_FindLocation = 2004 ;
	// public static final int										DD_ACRNEMA_NumberOfMatches = 2005 ;
	// public static final int										DD_ACRNEMA_ResponseSequenceNumber = 2006 ;
	// public static final int										DD_ACRNEMA_DialogReceiver = 2007 ;
	// public static final int										DD_ACRNEMA_TerminalType = 2008 ;
	// public static final int										DD_ACRNEMA_DisplayFormat = 2009 ;
	// public static final int										DD_ACRNEMA_PagePositionID = 2010 ;
	// public static final int										DD_ACRNEMA_TextFormatID = 2011 ;
	// public static final int										DD_ACRNEMA_NormalReverse = 2012 ;
	// public static final int										DD_ACRNEMA_AddGrayScale = 2013 ;
	// public static final int										DD_ACRNEMA_Borders = 2014 ;
	// public static final int										DD_ACRNEMA_Copies = 2015 ;
	// public static final int										DD_ACRNEMA_OldMagnificationType = 2016 ;
	// public static final int										DD_ACRNEMA_Erase = 2017 ;
	// public static final int										DD_ACRNEMA_Print = 2018 ;
	// public static final int										DD_ACRNEMA_Overlays = 2019 ;
	// public static final int										DD_ACRNEMA_LengthToEnd = 2030 ;
	// public static final int										DD_ACRNEMA_RecognitionCode = 2031 ;
	// public static final int										DD_ACRNEMA_OldDataSetType = 2032 ;
	// public static final int										DD_ACRNEMA_OldDataSetSubtype = 2033 ;
	// public static final int										DD_ACRNEMA_NetworkID = 2034 ;
	// public static final int										DD_ACRNEMA_IdentifyingComments = 2035 ;
	// public static final int										DD_ACRNEMA_InsurancePlanIdentification = 2064 ;
	// public static final int										DD_ACRNEMA_UpperLowerPixelValues = 2098 ;
	// public static final int										DD_ACRNEMA_AcquisitionComments = 2099 ;
	// public static final int										DD_ACRNEMA_DynamicRange = 2100 ;
	// public static final int										DD_ACRNEMA_TotalGain = 2101 ;
	// public static final int										DD_ACRNEMA_ImagePosition = 2147 ;
	// public static final int										DD_ACRNEMA_ImageOrientation = 2148 ;
	// public static final int										DD_ACRNEMA_Location = 2149 ;
	// public static final int										DD_ACRNEMA_ImageGeometryType = 2150 ;
	// public static final int										DD_ACRNEMA_MaskingImage = 2151 ;
	// public static final int										DD_ACRNEMA_AcquisitionsInSeries = 2152 ;
	// public static final int										DD_ACRNEMA_ImagesInSeries = 2153 ;
	// public static final int										DD_ACRNEMA_ImagesInStudy = 2154 ;
	// public static final int										DD_ACRNEMA_Reference = 2155 ;
	// public static final int										DD_ACRNEMA_SourceImageID = 2156 ;
	// public static final int										DD_ACRNEMA_ModifyingDeviceID = 2157 ;
	// public static final int										DD_ACRNEMA_ModifiedImageID = 2158 ;
	// public static final int										DD_ACRNEMA_ModifiedImageDate = 2159 ;
	// public static final int										DD_ACRNEMA_ModifyingDeviceManufacturer = 2160 ;
	// public static final int										DD_ACRNEMA_ModifiedImageTime = 2161 ;
	// public static final int										DD_ACRNEMA_ModifiedImageDescription = 2162 ;
	// public static final int										DD_ACRNEMA_OriginalImageIdentification = 2163 ;
	// public static final int										DD_ACRNEMA_OriginalImageIdentificationNomenclature = 2164 ;
	// public static final int										DD_ACRNEMA_ImageDimensions = 2218 ;
	// public static final int										DD_ACRNEMA_ImageFormat = 2219 ;
	// public static final int										DD_ACRNEMA_ManipulatedImage = 2220 ;
	// public static final int										DD_ACRNEMA_CompressionRecognitionCode = 2221 ;
	// public static final int										DD_ACRNEMA_CompressionCode = 2222 ;
	// public static final int										DD_ACRNEMA_CompressionOriginator = 2223 ;
	// public static final int										DD_ACRNEMA_CompressionLabel = 2224 ;
	// public static final int										DD_ACRNEMA_CompressionDescription = 2225 ;
	// public static final int										DD_ACRNEMA_CompressionSequence = 2226 ;
	// public static final int										DD_ACRNEMA_CompressionStepPointers = 2227 ;
	// public static final int										DD_ACRNEMA_RepeatInterval = 2228 ;
	// public static final int										DD_ACRNEMA_BitsGrouped = 2229 ;
	// public static final int										DD_ACRNEMA_PerimeterTable = 2230 ;
	// public static final int										DD_ACRNEMA_PerimeterValue = 2231 ;
	// public static final int										DD_ACRNEMA_PredictorRows = 2232 ;
	// public static final int										DD_ACRNEMA_PredictorColumns = 2233 ;
	// public static final int										DD_ACRNEMA_PredictorConstants = 2234 ;
	// public static final int										DD_ACRNEMA_BlockedPixels = 2235 ;
	// public static final int										DD_ACRNEMA_BlockRows = 2236 ;
	// public static final int										DD_ACRNEMA_BlockColumns = 2237 ;
	// public static final int										DD_ACRNEMA_RowOverlap = 2238 ;
	// public static final int										DD_ACRNEMA_ColumnOverlap = 2239 ;
	// public static final int										DD_ACRNEMA_SmallestValidPixelValue = 2240 ;
	// public static final int										DD_ACRNEMA_LargestValidPixelValue = 2241 ;
	// public static final int										DD_ACRNEMA_ImageLocation = 2242 ;
	// public static final int										DD_ACRNEMA_TransformLabel = 2243 ;
	// public static final int										DD_ACRNEMA_TransformVersionNumber = 2244 ;
	// public static final int										DD_ACRNEMA_NumberOfTransformSteps = 2245 ;
	// public static final int										DD_ACRNEMA_SequenceOfCompressedData = 2246 ;
	// public static final int										DD_ACRNEMA_DetailsOfCoefficients = 2247 ;
	// public static final int										DD_ACRNEMA_DCTLabel = 2248 ;
	// public static final int										DD_ACRNEMA_DataBlockDescription = 2249 ;
	// public static final int										DD_ACRNEMA_DataBlock = 2250 ;
	// public static final int										DD_ACRNEMA_NormalizationFactorFormat = 2251 ;
	// public static final int										DD_ACRNEMA_ZonalMapNumberFormat = 2252 ;
	// public static final int										DD_ACRNEMA_ZonalMapLocation = 2253 ;
	// public static final int										DD_ACRNEMA_ZonalMapFormat = 2254 ;
	// public static final int										DD_ACRNEMA_AdaptiveMapFormat = 2255 ;
	// public static final int										DD_ACRNEMA_CodeNumberFormat = 2256 ;
	// public static final int										DD_ACRNEMA_CodeLabel = 2257 ;
	// public static final int										DD_ACRNEMA_NumberOfTables = 2258 ;
	// public static final int										DD_ACRNEMA_CodeTableLocation = 2259 ;
	// public static final int										DD_ACRNEMA_BitsForCodeWord = 2260 ;
	// public static final int										DD_ACRNEMA_ImageDataLocation = 2261 ;
	// public static final int										DD_ACRNEMA_GrayScale = 2262 ;
	// public static final int										DD_ACRNEMA_GrayLookupTableDescriptor = 2263 ;
	// public static final int										DD_ACRNEMA_GrayLookupTableData = 2264 ;
	// public static final int										DD_ACRNEMA_ImagePresentationComments = 2265 ;
	// public static final int										DD_ACRNEMA_CodeTableGroupLength = 2372 ;
	// public static final int										DD_ACRNEMA_RunLengthTriplet = 2373 ;
	// public static final int										DD_ACRNEMA_HuffmanTableSize = 2374 ;
	// public static final int										DD_ACRNEMA_HuffmanTableTriplet = 2375 ;
	// public static final int										DD_ACRNEMA_ShiftTableSize = 2376 ;
	// public static final int										DD_ACRNEMA_ShiftTableTriplet = 2377 ;
	// public static final int										DD_ACRNEMA_ZonalMapGroupLength = 2378 ;
	// public static final int										DD_ACRNEMA_TextGroupLength = 2380 ;
	// public static final int										DD_ACRNEMA_TextArbitrary = 2381 ;
	// public static final int										DD_ACRNEMA_TextComments = 2382 ;
	// public static final int										DD_ACRNEMA_OverlayCompressionCode = 2391 ;
	// public static final int										DD_ACRNEMA_OverlayCompressionOriginator = 2392 ;
	// public static final int										DD_ACRNEMA_OverlayCompressionLabel = 2393 ;
	// public static final int										DD_ACRNEMA_OverlayCompressionDescription = 2394 ;
	// public static final int										DD_ACRNEMA_OverlayCompressionStepPointers = 2395 ;
	// public static final int										DD_ACRNEMA_OverlayRepeatInterval = 2396 ;
	// public static final int										DD_ACRNEMA_OverlayBitsGrouped = 2397 ;
	// public static final int										DD_ACRNEMA_OverlayFormat = 2398 ;
	// public static final int										DD_ACRNEMA_OverlayLocation = 2399 ;
	// public static final int										DD_ACRNEMA_OverlayCodeLabel = 2400 ;
	// public static final int										DD_ACRNEMA_OverlayNumberOfTables = 2401 ;
	// public static final int										DD_ACRNEMA_OverlayCodeTableLocation = 2402 ;
	// public static final int										DD_ACRNEMA_OverlayBitsForCodeWord = 2403 ;
	// public static final int										DD_ACRNEMA_OverlayComments = 2404 ;
	// public static final int										DD_ACRNEMA_CoefficientsSDVN = 2408 ;
	// public static final int										DD_ACRNEMA_CoefficientsSDHN = 2409 ;
	// public static final int										DD_ACRNEMA_CoefficientsSDDN = 2410 ;
	// public static final int										DD_ACRNEMA_VariablePixelDataGroupLength = 2412 ;
	// public static final int										DD_ACRNEMA_VariablePixelData = 2413 ;
	// public static final int										DD_ACRNEMA_VariableNextDataGroup = 2414 ;
	// public static final int										DD_ACRNEMA_VariableCoefficientsSDVN = 2415 ;
	// public static final int										DD_ACRNEMA_VariableCoefficientsSDHN = 2416 ;
	// public static final int										DD_ACRNEMA_VariableCoefficientsSDDN = 2417 ;
	// public static final int										DD_AEGIS_DICOM_2_00_0x0003_0x0000 = 2020 ;
	// public static final int										DD_AEGIS_DICOM_2_00_0x0005_0x0000 = 2029 ;
	// public static final int										DD_AEGIS_DICOM_2_00_0x1369_0x0000 = 2379 ;
	// public static final int										DD_ELSCINT1_DataDictionaryVersion = 2356 ;
	// public static final int										DD_ELSCINT1_0x00E1_0x0014 = 2357 ;
	// public static final int										DD_ELSCINT1_0x00E1_0x0022 = 2358 ;
	// public static final int										DD_ELSCINT1_0x00E1_0x0023 = 2359 ;
	// public static final int										DD_ELSCINT1_0x00E1_0x0024 = 2360 ;
	// public static final int										DD_ELSCINT1_0x00E1_0x0025 = 2361 ;
	// public static final int										DD_ELSCINT1_OffsetFromCTMRImages = 2362 ;
	// public static final int										DD_ELSCINT1_ImplementationVersion = 2366 ;
	// public static final int										DD_ELSCINT1_RelativeTablePosition = 2367 ;
	// public static final int										DD_ELSCINT1_RelativeTableHeight = 2368 ;
	// public static final int										DD_ELSCINT1_SurviewDirection = 2369 ;
	// public static final int										DD_ELSCINT1_SurviewLength = 2370 ;
	// public static final int										DD_ELSCINT1_ImageViewType = 2371 ;
	// public static final int										DD_GEMS_IDEN_01_0x0009_0x0017 = 2036 ;
	// public static final int										DD_GEMS_IDEN_01_0x0009_0x001a = 2038 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x0024 = 2040 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x0025 = 2041 ;
	// public static final int										DD_GEMS_IDEN_01_0x0009_0x002f = 2045 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x003e = 2048 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x003f = 2049 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x0043 = 2050 ;
	// public static final int										DD_GEMS_IDEN_01_0x0009_0x00e2 = 2056 ;
	// public static final int										DD_GEMS_IDEN_01_0x0009_0x00e3 = 2057 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x00f8 = 2062 ;
	// public static final int										DD_GEMS_ACQU_01_0x0009_0x00fb = 2063 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x002d = 2104 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x0039 = 2105 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x003b = 2106 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x003f = 2107 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x005d = 2110 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x007f = 2115 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x008f = 2116 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x0099 = 2118 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x009b = 2119 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x009d = 2120 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00b6 = 2121 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00b7 = 2122 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00b8 = 2123 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00b9 = 2124 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00ba = 2125 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00bb = 2126 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00bc = 2127 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00bd = 2128 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00df = 2135 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00e4 = 2136 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00e5 = 2137 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00e6 = 2138 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00e8 = 2139 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00e9 = 2140 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00eb = 2141 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00ec = 2142 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00f4 = 2144 ;
	// public static final int										DD_GEMS_ACQU_01_0x0019_0x00f9 = 2145 ;
	// public static final int										DD_GEMS_RELA_01_0x0021_0x004e = 2179 ;
	// public static final int										DD_GEMS_RELA_01_0x0021_0x0081 = 2195 ;
	// public static final int										DD_GEMS_RELA_01_0x0021_0x0083 = 2196 ;
	// public static final int										DD_GEMS_RELA_01_0x0021_0x0084 = 2197 ;
	// public static final int										DD_GEMS_GNHD_01_0x0033_0x0001 = 2318 ;
	// public static final int										DD_GEMS_YMHD_01_0x0033_0x0005 = 2319 ;
	// public static final int										DD_GEMS_YMHD_01_0x0033_0x0006 = 2320 ;
	// public static final int										DD_GEMS_DRS_1_ReferringDepartment = 2322 ;
	// public static final int										DD_GEMS_DRS_1_ScreenNumber = 2323 ;
	// public static final int										DD_GEMS_DRS_1_LeftOrientation = 2324 ;
	// public static final int										DD_GEMS_DRS_1_RightOrientation = 2325 ;
	// public static final int										DD_GEMS_DRS_1_Inversion = 2326 ;
	// public static final int										DD_GEMS_DRS_1_DSA = 2327 ;
	// public static final int										DD_PAPYRUS_DataSetIdentifier = 2037 ;
	// public static final int										DD_PAPYRUS_3_0_PixelOffset = 2328 ;
	// public static final int										DD_PAPYRUS_3_0_ImageIdentifierSequence = 2329 ;
	// public static final int										DD_PAPYRUS_3_0_ExternalFileReferenceSequence = 2330 ;
	// public static final int										DD_PAPYRUS_3_0_NumberOfImages = 2331 ;
	// public static final int										DD_PAPYRUS_3_0_ReferencedSOPClassUID2 = 2332 ;
	// public static final int										DD_PAPYRUS_3_0_ReferencedSOPInstanceUID2 = 2333 ;
	// public static final int										DD_PAPYRUS_ModifiedDate = 2334 ;
	// public static final int										DD_PAPYRUS_ModifiedTime = 2335 ;
	// public static final int										DD_PAPYRUS_OwnerName = 2336 ;
	// public static final int										DD_PAPYRUS_3_0_ReferencedImageSOPClassUID = 2337 ;
	// public static final int										DD_PAPYRUS_3_0_ReferencedImageSOPInstanceUID = 2338 ;
	// public static final int										DD_PAPYRUS_NumberOfImages2 = 2339 ;
	// public static final int										DD_PAPYRUS_NumberOfOther = 2340 ;
	// public static final int										DD_PAPYRUS_ExternalFolderElementDSID = 2341 ;
	// public static final int										DD_PAPYRUS_ExternalFolderElementDataSetType = 2342 ;
	// public static final int										DD_PAPYRUS_ExternalFolderElementFileLocation = 2343 ;
	// public static final int										DD_PAPYRUS_ExternalFolderElementLength = 2344 ;
	// public static final int										DD_PAPYRUS_InternalFolderElementDSID = 2345 ;
	// public static final int										DD_PAPYRUS_InternalFolderElementDataSetType = 2346 ;
	// public static final int										DD_PAPYRUS_InternalOffsetToDataSet = 2347 ;
	// public static final int										DD_PAPYRUS_InternalOffsetToImage = 2348 ;
	// public static final int										DD_PHILIPS_MR_PART_NumberOfScans = 2102 ;
	// public static final int										DD_PHILIPS_MR_SPECTRO_1_0x0019_0x0029 = 2103 ;
	// public static final int										DD_PHILIPS_MR_PART_InversionDelay = 2111 ;
	// public static final int										DD_PHILIPS_MR_PART_GateWidth = 2112 ;
	// public static final int										DD_PHILIPS_MR_SPECTRO_1_0x0019_0x0073 = 2113 ;
	// public static final int										DD_PHILIPS_MR_SPECTRO_1_0x0019_0x0077 = 2114 ;
	// public static final int										DD_PHILIPS_MR_PART_FoldoverDirectionCoronal = 2130 ;
	// public static final int										DD_PHILIPS_MR_PART_NumberOfEchoes = 2131 ;
	// public static final int										DD_PHILIPS_MR_PART_ScanResolution = 2132 ;
	// public static final int										DD_PHILIPS_MR_LAST_WSProtocolString3 = 2143 ;
	// public static final int										DD_PHILIPS_MR_PART_ResonanceFrequency = 2146 ;
	// public static final int										DD_PHILIPS_MR_PART_ChemicalShiftNumber = 2177 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0000 = 2211 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0011 = 2212 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0012 = 2213 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0013 = 2214 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0014 = 2215 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0015 = 2216 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x0027_0x0016 = 2217 ;
	// public static final int										DD_PHILIPS_MR_LAST_ViewZoom = 2290 ;
	// public static final int										DD_PHILIPS_MR_LAST_ViewTransform = 2291 ;
	// public static final int										DD_PHILIPS_MR_PART_ScanResolution2 = 2301 ;
	// public static final int										DD_PHILIPS_MR_PART_FieldOfView = 2302 ;
	// public static final int										DD_PHILIPS_MR_PART_SliceThickness2 = 2308 ;
	// public static final int										DD_PHILIPS_MR_LAST_0x6001_0x0000 = 2390 ;
	// public static final int										DD_SIEMENS_ISI_ISICommandField = 2021 ;
	// public static final int										DD_SIEMENS_ISI_AttachIDApplicationCode = 2022 ;
	// public static final int										DD_SIEMENS_ISI_AttachIDMessageCount = 2023 ;
	// public static final int										DD_SIEMENS_ISI_AttachIDDate = 2024 ;
	// public static final int										DD_SIEMENS_ISI_AttachIDTime = 2025 ;
	// public static final int										DD_SIEMENS_ISI_MessageType = 2026 ;
	// public static final int										DD_SIEMENS_ISI_MaxWaitingDate = 2027 ;
	// public static final int										DD_SIEMENS_ISI_MaxWaitingTime = 2028 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_LastMoveDate = 2042 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_LastMoveTime = 2043 ;
	// public static final int										DD_SIEMENS_CT_VA0__IDE_0x0009_0x0032 = 2046 ;
	// public static final int										DD_SIEMENS_MED_PDMDataObjectTypeExtension = 2061 ;
	// public static final int										DD_SIEMENS_ISI_PatientUID = 2066 ;
	// public static final int										DD_SIEMENS_ISI_PatientID2 = 2067 ;
	// public static final int										DD_SIEMENS_ISI_CaseID = 2068 ;
	// public static final int										DD_SIEMENS_RA_GEN_0x0011_0x0025 = 2069 ;
	// public static final int										DD_SIEMENS_RA_GEN_0x0011_0x0035 = 2071 ;
	// public static final int										DD_SIEMENS_RIS_MedicalAlerts2 = 2072 ;
	// public static final int										DD_SIEMENS_RIS_ContrastAllergies2 = 2073 ;
	// public static final int										DD_SIEMENS_ISI_PatientRegistrationDate2 = 2074 ;
	// public static final int										DD_SIEMENS_ISI_PatientRegistrationTime = 2075 ;
	// public static final int										DD_SIEMENS_ISI_PatientLastName = 2076 ;
	// public static final int										DD_SIEMENS_ISI_PatientFirstName = 2077 ;
	// public static final int										DD_SIEMENS_ISI_PatientHospitalStatus = 2078 ;
	// public static final int										DD_SIEMENS_ISI_CurrentLocationTime = 2079 ;
	// public static final int										DD_SIEMENS_ISI_PatientInsuranceStatus = 2080 ;
	// public static final int										DD_SIEMENS_ISI_PatientBillingType = 2081 ;
	// public static final int										DD_SIEMENS_ISI_PatientBillingAddress = 2082 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ModifyingPhysician = 2083 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ModificationDate = 2084 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ModificationTime = 2085 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientName2 = 2086 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientId = 2087 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientBirthdate = 2088 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientWeight2 = 2089 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientsMaidenName = 2090 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ReferringPhysician = 2091 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_AdmittingDiagnosis = 2092 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientSex2 = 2093 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ProcedureDescription = 2094 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientRestDirection = 2095 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PatientPosition = 2096 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ViewDirection = 2097 ;
	// public static final int										DD_SIEMENS_DLR_01_Barcode = 2108 ;
	// public static final int										DD_SIEMENS_MR_VA0__COAD_ReceiverReferenceGain = 2109 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_CoilClassMask = 2117 ;
	// public static final int										DD_SIEMENS_MR_VA0__COAD_EPICapacity = 2129 ;
	// public static final int										DD_SIEMENS_MR_VA0__COAD_FlowSensitivity = 2133 ;
	// public static final int										DD_SIEMENS_MR_VA0__COAD_PhaseCodingDirection = 2134 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_VOIPosition = 2165 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_VOISize = 2166 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_CSIMatrixSizeOriginal = 2167 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_CSIMatrixSizeExtended = 2168 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_SpatialGridShift = 2169 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_SignalLimitsMinimum = 2170 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_EPITimeRateOfChangeLegalLimit1 = 2171 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_EPIOperationModeFlag = 2172 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_EPIFieldCalculationSafetyFactor = 2173 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_EPILegalLimit1OfChangeValue = 2174 ;
	// public static final int										DD_SIEMENS_RA_GEN_0x0021_0x0025 = 2175 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ImagePixelOffset = 2176 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_SlabThickness = 2178 ;
	// public static final int										DD_SIEMENS_MR_VA0__RAW_SaturationDistance = 2180 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_RepetitionTimeEffective = 2181 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_GatePhase = 2182 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_GateThreshold = 2183 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_GatedRatio = 2184 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ImageDistance = 2185 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ImagePositioningHistoryMask = 2186 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ImageRow = 2187 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ImageColumn = 2188 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_SecondRepetitionTime = 2189 ;
	// public static final int										DD_SIEMENS_CT_VA0__GEN_LightBrightness = 2190 ;
	// public static final int										DD_SIEMENS_CT_VA0__GEN_LightContrast = 2191 ;
	// public static final int										DD_SIEMENS_CT_VA0__GEN_OverlayThreshold = 2192 ;
	// public static final int										DD_SIEMENS_CT_VA0__GEN_SurfaceThreshold = 2193 ;
	// public static final int										DD_SIEMENS_CT_VA0__GEN_GreyScaleThreshold = 2194 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_SaturationPhaseEncodingVectorTransverseComponent = 2199 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_SaturationReadoutVectorTransverseComponent = 2200 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfMagnitude = 2201 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfXComponent = 2202 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfYComponent = 2203 ;
	// public static final int										DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfZComponent = 2204 ;
	// public static final int										DD_SIEMENS_CT_VA0__GEN_0x0021_0x00a7 = 2208 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_0x0029_0x0013 = 2270 ;
	// public static final int										DD_SIEMENS_MED_HG_ListOfShadowOwnerCodes = 2271 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_0x0029_0x0021 = 2272 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_PixelQualityValue = 2273 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ExposureCode = 2281 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_SortCode = 2282 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_0x0029_0x0053 = 2283 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_ShutterType = 2294 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_RowsOfRectangularShutter = 2295 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_ColumnsOfRectangularShutter = 2296 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_OriginOfRectangularShutter = 2297 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_RadiusOfCircularShutter2 = 2298 ;
	// public static final int										DD_SIEMENS_MED_DISPLAY_OriginOfCircularShutter = 2299 ;
	// public static final int										DD_SIEMENS_RIS_RequestUID = 2309 ;
	// public static final int										DD_SIEMENS_ISI_ExaminationReason = 2310 ;
	// public static final int										DD_SIEMENS_ISI_RequestedDate = 2311 ;
	// public static final int										DD_SIEMENS_ISI_WorklistRequestStartTime = 2312 ;
	// public static final int										DD_SIEMENS_ISI_WorklistRequestEndTime = 2313 ;
	// public static final int										DD_SIEMENS_RIS_RequestingPhysician = 2314 ;
	// public static final int										DD_SIEMENS_ISI_RequestedTime = 2315 ;
	// public static final int										DD_SIEMENS_RIS_RequestedPhysician = 2316 ;
	// public static final int										DD_SIEMENS_ISI_RequestedLocation = 2317 ;
	// public static final int										DD_SIEMENS_RIS_PatientStudyUID = 2321 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_ImageText = 2349 ;
	// public static final int										DD_SIEMENS_ISI_CurrentWard = 2350 ;
	// public static final int										DD_SIEMENS_ISI_RISKey = 2363 ;
	// public static final int										DD_SIEMENS_ISI_RISWorklistIMGEF = 2364 ;
	// public static final int										DD_SIEMENS_ISI_RISReportIMGEF = 2365 ;
	// public static final int										DD_SIEMENS_ISI_ReportID = 2383 ;
	// public static final int										DD_SIEMENS_ISI_ReportStatus = 2384 ;
	// public static final int										DD_SIEMENS_ISI_ReportCreationDate = 2385 ;
	// public static final int										DD_SIEMENS_ISI_ReportApprovingPhysician = 2386 ;
	// public static final int										DD_SIEMENS_ISI_ReportText = 2387 ;
	// public static final int										DD_SIEMENS_ISI_ReportAuthor = 2388 ;
	// public static final int										DD_SIEMENS_ISI_ReportingRadiologist = 2389 ;
	// public static final int										DD_SIEMENS_MED_Dummy = 2405 ;
	// public static final int										DD_SIEMENS_MED_Header = 2406 ;
	// public static final int										DD_SIEMENS_MED_Dummy2 = 2407 ;
	// public static final int										DD_SIEMENS_CM_VA0__CMS_BinaryData = 2418 ;
	// public static final int										DD_SIEMENS_NUMARIS_II_ImageGraphicsFormatCode2 = 2419 ;
	// public static final int										DD_SIEMENS_NUMARIS_II_ImageGraphics2 = 2420 ;
	// public static final int										DD_SIEMENS_NUMARIS_II_ImageGraphicsDummy = 2421 ;
	// public static final int										DD_SIENET_ActualUser = 2044 ;
	// public static final int										DD_SIENET_ExaminationFolderID = 2351 ;
	// public static final int										DD_SIENET_FolderReportedStatus = 2352 ;
	// public static final int										DD_SIENET_FolderReportingRadiologist = 2353 ;
	// public static final int										DD_SIENET_SIENETISAPLA = 2354 ;
	// public static final int										DD_SIENET_DataObjectAttributes = 2355 ;
	// public static final int										DD_SPI_P_Release_1_0x0009_0x0021 = 2039 ;
	// public static final int										DD_SPI_P_Release_1_SystemUniqueIdentifier = 2047 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0009_0x0060 = 2051 ;
	// public static final int										DD_SPI_P_Release_1_SeriesUniqueIdentifier = 2052 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0009_0x0070 = 2053 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0009_0x0080 = 2054 ;
	// public static final int										DD_SPI_P_Release_1_0x0009_0x0091 = 2055 ;
	// public static final int										DD_SPI_P_Release_1_0x0009_0x00f2 = 2058 ;
	// public static final int										DD_SPI_P_Release_1_0x0009_0x00f3 = 2059 ;
	// public static final int										DD_SPI_P_Release_1_0x0009_0x00f4 = 2060 ;
	// public static final int										DD_SPI_P_Release_1_0x0011_0x0032 = 2070 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0021_0x0090 = 2198 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0021_0x00a1 = 2205 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0021_0x00a3 = 2206 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0021_0x00a4 = 2207 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0021_0x00b0 = 2209 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0021_0x00c0 = 2210 ;
	// public static final int										DD_SPI_P_Release_1_3_ConvolutionKernelSize2 = 2266 ;
	// public static final int										DD_SPI_P_Release_1_3_ConvolutionKernel2 = 2267 ;
	// public static final int										DD_SPI_P_Release_1_1_ZoomEnableStatus = 2268 ;
	// public static final int										DD_SPI_P_Release_1_1_ZoomSelectStatus = 2269 ;
	// public static final int										DD_SPI_P_Release_1_ProcessedPixelDataQuality = 2274 ;
	// public static final int										DD_SPI_P_Release_1_0x0029_0x0038 = 2275 ;
	// public static final int										DD_SPI_P_Release_1_1_MagnifyingGlassRectangle = 2276 ;
	// public static final int										DD_SPI_P_Release_1_1_MagnifyingGlassFactor = 2277 ;
	// public static final int										DD_SPI_P_Release_1_1_MagnifyingGlassFunction = 2278 ;
	// public static final int										DD_SPI_P_Release_1_1_MagnifyingGlassEnableStatus = 2279 ;
	// public static final int										DD_SPI_P_Release_1_1_MagnifyingGlassSelectStatus = 2280 ;
	// public static final int										DD_SPI_P_Release_1_0x0029_0x0067 = 2284 ;
	// public static final int										DD_SPI_P_Release_1_WindowSelectStatus = 2285 ;
	// public static final int										DD_SPI_P_Release_1_ECGDisplayPrintingID = 2286 ;
	// public static final int										DD_SPI_P_Release_1_ECGDisplayPrinting = 2287 ;
	// public static final int										DD_SPI_P_Release_1_ECGDisplayPrintingEnableStatus = 2288 ;
	// public static final int										DD_SPI_P_Release_1_ECGDisplayPrintingSelectStatus = 2289 ;
	// public static final int										DD_SPI_P_Release_1_PhysiologicalDisplayEnableStatus = 2292 ;
	// public static final int										DD_SPI_P_Release_1_PhysiologicalDisplaySelectStatus = 2293 ;
	// public static final int										DD_SPI_P_Release_1_FunctionalShutterID = 2300 ;
	// public static final int										DD_SPI_P_Release_1_FieldOfShutterRectangle = 2303 ;
	// public static final int										DD_SPI_P_Release_1_ShutterEnableStatus = 2304 ;
	// public static final int										DD_SPI_P_Release_1_ShutterSelectStatus = 2305 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0029_0x00d0 = 2306 ;
	// public static final int										DD_SPI_P_GV_CT_Release_1_0x0029_0x00d1 = 2307 ;
	// public static final int										DD_SPI_P_Release_1_PixelData2 = 2411 ;
	// public static final int										DD_TOSHIBA_MEC_1_0_0x0011_0x0002 = 2065 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0004 = 2422 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0005 = 2423 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0007 = 2424 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0008 = 2425 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0009 = 2426 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000a = 2427 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000b = 2428 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000c = 2429 ;
	// public static final int										DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000d = 2430 ;
	// public static final int										DD_TOSHIBA_MEC_1_0_0x7ff1_0x0010 = 2431 ;


	/*
	 * Hier wird ein Array mit den DICOM-Parametern angelegt. Fuer jeden Parameter
	 * wird ein neuer Woerterbucheintrag erzeugt. Diese Eintraege werden allerdings
	 * noch nicht in die Hashtabelle eingefuegt.
	 */
	private static DcmDataDictionaryElement[] idList = {
		new DcmDataDictionaryElement (0x0002, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0002),
		new DcmDataDictionaryElement (0x0002, 0x0001, VRCODE_OB, "File Meta Information Version", DD_FileMetaInformationVersion),
		new DcmDataDictionaryElement (0x0002, 0x0002, VRCODE_UI, "Media Storage SOP Class UID", DD_MediaStorageSOPClassUID),
		new DcmDataDictionaryElement (0x0002, 0x0003, VRCODE_UI, "Media Storage SOP Instance UID", DD_MediaStorageSOPInstanceUID),
		new DcmDataDictionaryElement (0x0002, 0x0010, VRCODE_UI, "Transfer Syntax UID", DD_TransferSyntaxUID),
		new DcmDataDictionaryElement (0x0002, 0x0012, VRCODE_UI, "Implementation Class UID", DD_ImplementationClassUID),
		new DcmDataDictionaryElement (0x0002, 0x0013, VRCODE_SH, "Implementation Version Name", DD_ImplementationVersionName),
		new DcmDataDictionaryElement (0x0002, 0x0016, VRCODE_AE, "Source Application Entity Title", DD_SourceApplicationEntityTitle),
		new DcmDataDictionaryElement (0x0002, 0x0100, VRCODE_UI, "Private Information Creator UID", DD_PrivateInformationCreatorUID),
		new DcmDataDictionaryElement (0x0002, 0x0102, VRCODE_OB, "Private Information", DD_PrivateInformation_0002),
		new DcmDataDictionaryElement (0x0004, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0004),
		new DcmDataDictionaryElement (0x0004, 0x1130, VRCODE_CS, "File-set ID", DD_FileSetID),
		new DcmDataDictionaryElement (0x0004, 0x1141, VRCODE_CS, "File-set Descriptor File ID", DD_FileSetDescriptorFileID),
		new DcmDataDictionaryElement (0x0004, 0x1142, VRCODE_CS, "Specific Character Set of File-set Descriptor File", DD_SpecificCharacterSetOfFileSetDescriptorFile),
		new DcmDataDictionaryElement (0x0004, 0x1200, VRCODE_UL, "Offset of the First Directory Record of the Root Directory Entity", DD_OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity),
		new DcmDataDictionaryElement (0x0004, 0x1202, VRCODE_UL, "Offset of the Last Directory Record of the Root Directory Entity", DD_OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity),
		new DcmDataDictionaryElement (0x0004, 0x1212, VRCODE_US, "File-set Consistency Flag", DD_FileSetConsistencyFlag),
		new DcmDataDictionaryElement (0x0004, 0x1220, VRCODE_SQ, "Directory Record Sequence", DD_DirectoryRecordSequence),
		new DcmDataDictionaryElement (0x0004, 0x1400, VRCODE_UL, "Offset of the Next Directory Record", DD_OffsetOfTheNextDirectoryRecord),
		new DcmDataDictionaryElement (0x0004, 0x1410, VRCODE_US, "Record In-use Flag", DD_RecordInUseFlag),
		new DcmDataDictionaryElement (0x0004, 0x1420, VRCODE_UL, "Offset of Referenced Lower-Level Directory Entity", DD_OffsetOfReferencedLowerLevelDirectoryEntity),
		new DcmDataDictionaryElement (0x0004, 0x1430, VRCODE_CS, "Directory Record Type", DD_DirectoryRecordType),
		new DcmDataDictionaryElement (0x0004, 0x1432, VRCODE_UI, "Private Record UID", DD_PrivateRecordUID),
		new DcmDataDictionaryElement (0x0004, 0x1500, VRCODE_CS, "Referenced File ID", DD_ReferencedFileID),
		new DcmDataDictionaryElement (0x0004, 0x1504, VRCODE_UL, "MRDR Directory Record Offset", DD_MRDRDirectoryRecordOffset),
		new DcmDataDictionaryElement (0x0004, 0x1510, VRCODE_UI, "Referenced SOP Class UID in File", DD_ReferencedSOPClassUIDInFile),
		new DcmDataDictionaryElement (0x0004, 0x1511, VRCODE_UI, "Referenced SOP Instance UID in File", DD_ReferencedSOPInstanceUIDInFile),
		new DcmDataDictionaryElement (0x0004, 0x1512, VRCODE_UI, "Referenced Transfer Syntax UID in File", DD_ReferencedTransferSyntaxUIDInFile),
		new DcmDataDictionaryElement (0x0004, 0x1600, VRCODE_UL, "Number of References", DD_NumberOfReferences),
		new DcmDataDictionaryElement (0x0008, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength),
		new DcmDataDictionaryElement (0x0008, 0x0005, VRCODE_CS, "Specific Character Set", DD_SpecificCharacterSet),
		new DcmDataDictionaryElement (0x0008, 0x0008, VRCODE_CS, "Image Type", DD_ImageType),
		new DcmDataDictionaryElement (0x0008, 0x0012, VRCODE_DA, "Instance Creation Date", DD_InstanceCreationDate),
		new DcmDataDictionaryElement (0x0008, 0x0013, VRCODE_TM, "Instance Creation Time", DD_InstanceCreationTime),
		new DcmDataDictionaryElement (0x0008, 0x0014, VRCODE_UI, "Instance Creator UID", DD_InstanceCreatorUID),
		new DcmDataDictionaryElement (0x0008, 0x0016, VRCODE_UI, "SOP Class UID", DD_SOPClassUID),
		new DcmDataDictionaryElement (0x0008, 0x0018, VRCODE_UI, "SOP Instance UID", DD_SOPInstanceUID),
		new DcmDataDictionaryElement (0x0008, 0x0020, VRCODE_DA, "Study Date", DD_StudyDate),
		new DcmDataDictionaryElement (0x0008, 0x0021, VRCODE_DA, "Series Date", DD_SeriesDate),
		new DcmDataDictionaryElement (0x0008, 0x0022, VRCODE_DA, "Acquisition Date", DD_AcquisitionDate),
		new DcmDataDictionaryElement (0x0008, 0x0023, VRCODE_DA, "Image Date", DD_ImageDate),
		new DcmDataDictionaryElement (0x0008, 0x0024, VRCODE_DA, "Overlay Date", DD_OverlayDate),
		new DcmDataDictionaryElement (0x0008, 0x0025, VRCODE_DA, "Curve Date", DD_CurveDate),
		new DcmDataDictionaryElement (0x0008, 0x0030, VRCODE_TM, "Study Time", DD_StudyTime),
		new DcmDataDictionaryElement (0x0008, 0x0031, VRCODE_TM, "Series Time", DD_SeriesTime),
		new DcmDataDictionaryElement (0x0008, 0x0032, VRCODE_TM, "Acquisition Time", DD_AcquisitionTime),
		new DcmDataDictionaryElement (0x0008, 0x0033, VRCODE_TM, "Image Time", DD_ImageTime),
		new DcmDataDictionaryElement (0x0008, 0x0034, VRCODE_TM, "Overlay Time", DD_OverlayTime),
		new DcmDataDictionaryElement (0x0008, 0x0035, VRCODE_TM, "Curve Time", DD_CurveTime),
		new DcmDataDictionaryElement (0x0008, 0x0042, VRCODE_CS, "Nuclear Medicine Series Type", DD_NuclearMedicineSeriesType),
		new DcmDataDictionaryElement (0x0008, 0x0050, VRCODE_SH, "Accession Number", DD_AccessionNumber),
		new DcmDataDictionaryElement (0x0008, 0x0052, VRCODE_CS, "Query/Retrieve Level", DD_QueryRetrieveLevel),
		new DcmDataDictionaryElement (0x0008, 0x0054, VRCODE_AE, "Retrieve", DD_Retrieve),
		new DcmDataDictionaryElement (0x0008, 0x0058, VRCODE_UI, "Failed SOP Instance UID List", DD_FailedSOPInstanceUIDList),
		new DcmDataDictionaryElement (0x0008, 0x0060, VRCODE_CS, "Modality", DD_Modality),
		new DcmDataDictionaryElement (0x0008, 0x0061, VRCODE_CS, "Modalities in Study", DD_ModalitiesInStudy),
		new DcmDataDictionaryElement (0x0008, 0x0064, VRCODE_CS, "Conversion Type", DD_ConversionType),
		new DcmDataDictionaryElement (0x0008, 0x0068, VRCODE_CS, "Presentation Intent Type", DD_PresentationIntentType),
		new DcmDataDictionaryElement (0x0008, 0x0070, VRCODE_LO, "Manufacturer", DD_Manufacturer),
		new DcmDataDictionaryElement (0x0008, 0x0080, VRCODE_LO, "Institution Name", DD_InstitutionName),
		new DcmDataDictionaryElement (0x0008, 0x0081, VRCODE_ST, "Institution Address", DD_InstitutionAddress),
		new DcmDataDictionaryElement (0x0008, 0x0082, VRCODE_SQ, "Institution Code Sequence", DD_InstitutionCodeSequence),
		new DcmDataDictionaryElement (0x0008, 0x0090, VRCODE_PN, "Referring Physician's Name", DD_ReferringPhysiciansName),
		new DcmDataDictionaryElement (0x0008, 0x0092, VRCODE_ST, "Referring Physician's Address", DD_ReferringPhysiciansAddress),
		new DcmDataDictionaryElement (0x0008, 0x0094, VRCODE_SH, "Referring Physician's Telephone Numbers", DD_ReferringPhysiciansTelephoneNumbers),
		new DcmDataDictionaryElement (0x0008, 0x0100, VRCODE_SH, "Code Value", DD_CodeValue),
		new DcmDataDictionaryElement (0x0008, 0x0102, VRCODE_SH, "Coding Scheme Designator", DD_CodingSchemeDesignator),
		new DcmDataDictionaryElement (0x0008, 0x0103, VRCODE_SH, "Coding Scheme Version", DD_CodingSchemeVersion),
		new DcmDataDictionaryElement (0x0008, 0x0104, VRCODE_LO, "Code Meaning", DD_CodeMeaning),
		new DcmDataDictionaryElement (0x0008, 0x0105, VRCODE_CS, "Mapping Resource", DD_MappingResource),
		new DcmDataDictionaryElement (0x0008, 0x0106, VRCODE_DT, "Context Group Version", DD_ContextGroupVersion),
		new DcmDataDictionaryElement (0x0008, 0x0107, VRCODE_DT, "Context Group Local Version", DD_ContextGroupLocalVersion),
		new DcmDataDictionaryElement (0x0008, 0x010B, VRCODE_CS, "Code Set Extension Flag", DD_CodeSetExtensionFlag),
		new DcmDataDictionaryElement (0x0008, 0x010C, VRCODE_UI, "Private Coding Scheme Creator UID", DD_PrivateCodingSchemeCreatorUID),
		new DcmDataDictionaryElement (0x0008, 0x010D, VRCODE_UI, "Code Set Extension Creator UID", DD_CodeSetExtensionCreatorUID),
		new DcmDataDictionaryElement (0x0008, 0x010F, VRCODE_CS, "Context Identifier", DD_ContextIdentifier),
		new DcmDataDictionaryElement (0x0008, 0x1010, VRCODE_SH, "Station Name", DD_StationName),
		new DcmDataDictionaryElement (0x0008, 0x1030, VRCODE_LO, "Study Description", DD_StudyDescription),
		new DcmDataDictionaryElement (0x0008, 0x1032, VRCODE_SQ, "Procedure Code Sequence", DD_ProcedureCodeSequence),
		new DcmDataDictionaryElement (0x0008, 0x103E, VRCODE_LO, "Series Description", DD_SeriesDescription),
		new DcmDataDictionaryElement (0x0008, 0x1040, VRCODE_LO, "Institutional Department Name", DD_InstitutionalDepartmentName),
		new DcmDataDictionaryElement (0x0008, 0x1048, VRCODE_PN, "Physician(s) of Record", DD_PhysicianOfRecord),
		new DcmDataDictionaryElement (0x0008, 0x1050, VRCODE_PN, "Performing Physician's Name", DD_PerformingPhysiciansName),
		new DcmDataDictionaryElement (0x0008, 0x1060, VRCODE_PN, "Name of Physician(s) Reading Study", DD_NameOfPhysicianReadingStudy),
		new DcmDataDictionaryElement (0x0008, 0x1070, VRCODE_PN, "Operators' Name", DD_OperatorsName),
		new DcmDataDictionaryElement (0x0008, 0x1080, VRCODE_LO, "Admitting Diagnoses Description", DD_AdmittingDiagnosesDescription),
		new DcmDataDictionaryElement (0x0008, 0x1084, VRCODE_SQ, "Admitting Diagnosis Code Sequence", DD_AdmittingDiagnosisCodeSequence),
		new DcmDataDictionaryElement (0x0008, 0x1090, VRCODE_LO, "Manufacturer's Model Name", DD_ManufacturersModelName),
		new DcmDataDictionaryElement (0x0008, 0x1100, VRCODE_SQ, "Referenced Results Sequence", DD_ReferencedResultsSequence),
		new DcmDataDictionaryElement (0x0008, 0x1110, VRCODE_SQ, "Referenced Study Sequence", DD_ReferencedStudySequence),
		new DcmDataDictionaryElement (0x0008, 0x1111, VRCODE_SQ, "Referenced Study Component Sequence", DD_ReferencedStudyComponentSequence),
		new DcmDataDictionaryElement (0x0008, 0x1115, VRCODE_SQ, "Referenced Series Sequence", DD_ReferencedSeriesSequence),
		new DcmDataDictionaryElement (0x0008, 0x1120, VRCODE_SQ, "Referenced Patient Sequence", DD_ReferencedPatientSequence),
		new DcmDataDictionaryElement (0x0008, 0x1125, VRCODE_SQ, "Referenced Visit Sequence", DD_ReferencedVisitSequence),
		new DcmDataDictionaryElement (0x0008, 0x1130, VRCODE_SQ, "Referenced Overlay Sequence", DD_ReferencedOverlaySequence),
		new DcmDataDictionaryElement (0x0008, 0x1140, VRCODE_SQ, "Referenced Image Sequence", DD_ReferencedImageSequence),
		new DcmDataDictionaryElement (0x0008, 0x1145, VRCODE_SQ, "Referenced Curve Sequence", DD_ReferencedCurveSequence),
		new DcmDataDictionaryElement (0x0008, 0x1150, VRCODE_UI, "Referenced SOP Class UID", DD_ReferencedSOPClassUID),
		new DcmDataDictionaryElement (0x0008, 0x1155, VRCODE_UI, "Referenced SOP Instance UID", DD_ReferencedSOPInstanceUID),
		new DcmDataDictionaryElement (0x0008, 0x115A, VRCODE_UI, "SOP Classes Supported", DD_SOPClassesSupported),
		new DcmDataDictionaryElement (0x0008, 0x1160, VRCODE_IS, "Referenced Frame Number", DD_ReferencedFrameNumber),
		new DcmDataDictionaryElement (0x0008, 0x1195, VRCODE_UI, "Transaction UID", DD_TransactionUID),
		new DcmDataDictionaryElement (0x0008, 0x1197, VRCODE_US, "Failure Reason", DD_FailureReason),
		new DcmDataDictionaryElement (0x0008, 0x1198, VRCODE_SQ, "Failed SOP Sequence", DD_FailedSOPSequence),
		new DcmDataDictionaryElement (0x0008, 0x1199, VRCODE_SQ, "Referenced SOP Sequence", DD_ReferencedSOPSequence),
		new DcmDataDictionaryElement (0x0008, 0x2110, VRCODE_CS, "Lossy Image Compression", DD_LossyImageCompression),
		new DcmDataDictionaryElement (0x0008, 0x2111, VRCODE_ST, "Derivation Description", DD_DerivationDescription),
		new DcmDataDictionaryElement (0x0008, 0x2112, VRCODE_SQ, "Source Image Sequence", DD_SourceImageSequence),
		new DcmDataDictionaryElement (0x0008, 0x2120, VRCODE_SH, "Stage Name", DD_StageName),
		new DcmDataDictionaryElement (0x0008, 0x2122, VRCODE_IS, "Stage Number", DD_StageNumber),
		new DcmDataDictionaryElement (0x0008, 0x2124, VRCODE_IS, "Number of Stages", DD_NumberOfStages),
		new DcmDataDictionaryElement (0x0008, 0x2128, VRCODE_IS, "View Number", DD_ViewNumber),
		new DcmDataDictionaryElement (0x0008, 0x2129, VRCODE_IS, "Number of Event Timers", DD_NumberOfEventTimers),
		new DcmDataDictionaryElement (0x0008, 0x212A, VRCODE_IS, "Number of Views in Stage", DD_NumberOfViewsInStage),
		new DcmDataDictionaryElement (0x0008, 0x2130, VRCODE_DS, "Event Elapsed Time(s)", DD_EventElapsedTime),
		new DcmDataDictionaryElement (0x0008, 0x2132, VRCODE_LO, "Event Timer Name(s)", DD_EventTimerName),
		new DcmDataDictionaryElement (0x0008, 0x2142, VRCODE_IS, "Start Trim", DD_StartTrim),
		new DcmDataDictionaryElement (0x0008, 0x2143, VRCODE_IS, "Stop Trim", DD_StopTrim),
		new DcmDataDictionaryElement (0x0008, 0x2144, VRCODE_IS, "Recommended Display Frame Rate", DD_RecommendedDisplayFrameRate),
		new DcmDataDictionaryElement (0x0008, 0x2200, VRCODE_CS, "Transducer Position", DD_TransducerPosition),
		new DcmDataDictionaryElement (0x0008, 0x2204, VRCODE_CS, "Transducer Orientation", DD_TransducerOrientation),
		new DcmDataDictionaryElement (0x0008, 0x2208, VRCODE_CS, "Anatomic Structure", DD_AnatomicStructure),
		new DcmDataDictionaryElement (0x0008, 0x2218, VRCODE_SQ, "Anatomic Region Sequence", DD_AnatomicRegionSequence),
		new DcmDataDictionaryElement (0x0008, 0x2220, VRCODE_SQ, "Anatomic Region Modifier Sequence", DD_AnatomicRegionModifierSequence),
		new DcmDataDictionaryElement (0x0008, 0x2228, VRCODE_SQ, "Primary Anatomic Structure Sequence", DD_PrimaryAnatomicStructureSequence),
		new DcmDataDictionaryElement (0x0008, 0x2229, VRCODE_SQ, "Anatomic Structure Space or Region Sequence", DD_AnatomicStructureSpaceOrRegionSequence),
		new DcmDataDictionaryElement (0x0008, 0x2230, VRCODE_SQ, "Primary Anatomic Structure Modifier Sequence", DD_PrimaryAnatomicStructureModifierSequence),
		new DcmDataDictionaryElement (0x0008, 0x2240, VRCODE_SQ, "Transducer Position Sequence", DD_TransducerPositionSequence),
		new DcmDataDictionaryElement (0x0008, 0x2242, VRCODE_SQ, "Transducer Position Modifier Sequence", DD_TransducerPositionModifierSequence),
		new DcmDataDictionaryElement (0x0008, 0x2244, VRCODE_SQ, "Transducer Orientation Sequence", DD_TransducerOrientationSequence),
		new DcmDataDictionaryElement (0x0008, 0x2246, VRCODE_SQ, "Transducer Orientation Modifier Sequence", DD_TransducerOrientationModifierSequence),
		new DcmDataDictionaryElement (0x0010, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0010),
		new DcmDataDictionaryElement (0x0010, 0x0010, VRCODE_PN, "Patient's Name", DD_PatientsName),
		new DcmDataDictionaryElement (0x0010, 0x0020, VRCODE_LO, "Patient ID", DD_PatientID),
		new DcmDataDictionaryElement (0x0010, 0x0021, VRCODE_LO, "Issuer of Patient ID", DD_IssuerOfPatientID),
		new DcmDataDictionaryElement (0x0010, 0x0030, VRCODE_DA, "Patient's Birth Date", DD_PatientsBirthDate),
		new DcmDataDictionaryElement (0x0010, 0x0032, VRCODE_TM, "Patient's Birth Time", DD_PatientsBirthTime),
		new DcmDataDictionaryElement (0x0010, 0x0040, VRCODE_CS, "Patient's Sex", DD_PatientsSex),
		new DcmDataDictionaryElement (0x0010, 0x0050, VRCODE_SQ, "Patient's Insurance Plan Code Sequence", DD_PatientsInsurancePlanCodeSequence),
		new DcmDataDictionaryElement (0x0010, 0x1000, VRCODE_LO, "Other Patient IDs", DD_OtherPatientIDs),
		new DcmDataDictionaryElement (0x0010, 0x1001, VRCODE_PN, "Other Patient Names", DD_OtherPatientNames),
		new DcmDataDictionaryElement (0x0010, 0x1005, VRCODE_PN, "Patient's Birth Name", DD_PatientsBirthName),
		new DcmDataDictionaryElement (0x0010, 0x1010, VRCODE_AS, "Patient's Age", DD_PatientsAge),
		new DcmDataDictionaryElement (0x0010, 0x1020, VRCODE_DS, "Patient's Size", DD_PatientsSize),
		new DcmDataDictionaryElement (0x0010, 0x1030, VRCODE_DS, "Patient's Weight", DD_PatientsWeight),
		new DcmDataDictionaryElement (0x0010, 0x1040, VRCODE_LO, "Patient's Address", DD_PatientsAddress),
		new DcmDataDictionaryElement (0x0010, 0x1060, VRCODE_PN, "Patient's Mother's Birth Name", DD_PatientsMothersBirthName),
		new DcmDataDictionaryElement (0x0010, 0x1080, VRCODE_LO, "Military Rank", DD_MilitaryRank),
		new DcmDataDictionaryElement (0x0010, 0x1081, VRCODE_LO, "Branch of Service", DD_BranchOfService),
		new DcmDataDictionaryElement (0x0010, 0x1090, VRCODE_LO, "Medical Record Locator", DD_MedicalRecordLocator),
		new DcmDataDictionaryElement (0x0010, 0x2000, VRCODE_LO, "Medical Alerts", DD_MedicalAlerts),
		new DcmDataDictionaryElement (0x0010, 0x2110, VRCODE_LO, "Contrast Allergies", DD_ContrastAllergies),
		new DcmDataDictionaryElement (0x0010, 0x2150, VRCODE_LO, "Country of Residence", DD_CountryOfResidence),
		new DcmDataDictionaryElement (0x0010, 0x2152, VRCODE_LO, "Region of Residence", DD_RegionOfResidence),
		new DcmDataDictionaryElement (0x0010, 0x2154, VRCODE_SH, "Patient's Telephone Numbers", DD_PatientsTelephoneNumbers),
		new DcmDataDictionaryElement (0x0010, 0x2160, VRCODE_SH, "Ethnic Group", DD_EthnicGroup),
		new DcmDataDictionaryElement (0x0010, 0x2180, VRCODE_SH, "Occupation", DD_Occupation),
		new DcmDataDictionaryElement (0x0010, 0x21A0, VRCODE_CS, "Smoking Status", DD_SmokingStatus),
		new DcmDataDictionaryElement (0x0010, 0x21B0, VRCODE_LT, "Additional Patient History", DD_AdditionalPatientHistory),
		new DcmDataDictionaryElement (0x0010, 0x21C0, VRCODE_US, "Pregnancy Status", DD_PregnancyStatus),
		new DcmDataDictionaryElement (0x0010, 0x21D0, VRCODE_DA, "Last Menstrual Date", DD_LastMenstrualDate),
		new DcmDataDictionaryElement (0x0010, 0x21F0, VRCODE_LO, "Patient's Religious Preference", DD_PatientsReligiousPreference),
		new DcmDataDictionaryElement (0x0010, 0x4000, VRCODE_LT, "Patient Comments", DD_PatientComments),
		new DcmDataDictionaryElement (0x0018, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0018),
		new DcmDataDictionaryElement (0x0018, 0x0010, VRCODE_LO, "Contrast/Bolus Agent", DD_ContrastBolusAgent),
		new DcmDataDictionaryElement (0x0018, 0x0012, VRCODE_SQ, "Contrast/Bolus Agent Sequence", DD_ContrastBolusAgentSequence),
		new DcmDataDictionaryElement (0x0018, 0x0014, VRCODE_SQ, "Contrast/Bolus Administration Route Sequence", DD_ContrastBolusAdministrationRouteSequence),
		new DcmDataDictionaryElement (0x0018, 0x0015, VRCODE_CS, "Body Part Examined", DD_BodyPartExamined),
		new DcmDataDictionaryElement (0x0018, 0x0020, VRCODE_CS, "Scanning Sequence", DD_ScanningSequence),
		new DcmDataDictionaryElement (0x0018, 0x0021, VRCODE_CS, "Sequence Variant", DD_SequenceVariant),
		new DcmDataDictionaryElement (0x0018, 0x0022, VRCODE_CS, "Scan Options", DD_ScanOptions),
		new DcmDataDictionaryElement (0x0018, 0x0023, VRCODE_CS, "MR Acquisition Type", DD_MRAcquisitionType),
		new DcmDataDictionaryElement (0x0018, 0x0024, VRCODE_SH, "Sequence Name", DD_SequenceName),
		new DcmDataDictionaryElement (0x0018, 0x0025, VRCODE_CS, "Angio Flag", DD_AngioFlag),
		new DcmDataDictionaryElement (0x0018, 0x0026, VRCODE_SQ, "Intervention Drug Information Sequence", DD_InterventionDrugInformationSequence),
		new DcmDataDictionaryElement (0x0018, 0x0027, VRCODE_TM, "Intervention Drug Stop Time", DD_InterventionDrugStopTime),
		new DcmDataDictionaryElement (0x0018, 0x0028, VRCODE_DS, "Intervention Drug Dose", DD_InterventionDrugDose),
		new DcmDataDictionaryElement (0x0018, 0x0029, VRCODE_SQ, "Intervention Drug Code Sequence", DD_InterventionDrugCodeSequence),
		new DcmDataDictionaryElement (0x0018, 0x002A, VRCODE_SQ, "Additional Drug Sequence", DD_AdditionalDrugSequence),
		new DcmDataDictionaryElement (0x0018, 0x0030, VRCODE_LO, "Radionuclide", DD_Radionuclide),
		new DcmDataDictionaryElement (0x0018, 0x0031, VRCODE_LO, "Radiopharmaceutical", DD_Radiopharmaceutical),
		new DcmDataDictionaryElement (0x0018, 0x0032, VRCODE_DS, "Energy Window Centerline", DD_EnergyWindowCenterline),
		new DcmDataDictionaryElement (0x0018, 0x0033, VRCODE_DS, "Energy Window Total Width", DD_EnergyWindowTotalWidth),
		new DcmDataDictionaryElement (0x0018, 0x0034, VRCODE_LO, "Intervention Drug Name", DD_InterventionDrugName),
		new DcmDataDictionaryElement (0x0018, 0x0035, VRCODE_TM, "Intervention Drug Start Time", DD_InterventionDrugStartTime),
		new DcmDataDictionaryElement (0x0018, 0x0036, VRCODE_SQ, "Interventional Therapy Sequence", DD_InterventionalTherapySequence),
		new DcmDataDictionaryElement (0x0018, 0x0037, VRCODE_CS, "Therapy Type", DD_TherapyType),
		new DcmDataDictionaryElement (0x0018, 0x0038, VRCODE_CS, "Interventional Status", DD_InterventionalStatus),
		new DcmDataDictionaryElement (0x0018, 0x0039, VRCODE_CS, "Therapy Description", DD_TherapyDescription),
		new DcmDataDictionaryElement (0x0018, 0x0040, VRCODE_IS, "Cine Rate", DD_CineRate),
		new DcmDataDictionaryElement (0x0018, 0x0050, VRCODE_DS, "Slice Thickness", DD_SliceThickness),
		new DcmDataDictionaryElement (0x0018, 0x0060, VRCODE_DS, "KVP", DD_KVP),
		new DcmDataDictionaryElement (0x0018, 0x0070, VRCODE_IS, "Counts Accumulated", DD_CountsAccumulated),
		new DcmDataDictionaryElement (0x0018, 0x0071, VRCODE_CS, "Acquisition Termination Condition", DD_AcquisitionTerminationCondition),
		new DcmDataDictionaryElement (0x0018, 0x0072, VRCODE_DS, "Effective Series Duration", DD_EffectiveSeriesDuration),
		new DcmDataDictionaryElement (0x0018, 0x0073, VRCODE_CS, "Acquisition Start Condition", DD_AcquisitionStartCondition),
		new DcmDataDictionaryElement (0x0018, 0x0074, VRCODE_IS, "Acquisition Start Condition Data", DD_AcquisitionStartConditionData),
		new DcmDataDictionaryElement (0x0018, 0x0075, VRCODE_IS, "Acquisition Termination Condition Data", DD_AcquisitionTerminationConditionData),
		new DcmDataDictionaryElement (0x0018, 0x0080, VRCODE_DS, "Repetition Time", DD_RepetitionTime),
		new DcmDataDictionaryElement (0x0018, 0x0081, VRCODE_DS, "Echo Time", DD_EchoTime),
		new DcmDataDictionaryElement (0x0018, 0x0082, VRCODE_DS, "Inversion Time", DD_InversionTime),
		new DcmDataDictionaryElement (0x0018, 0x0083, VRCODE_DS, "Number of Averages", DD_NumberOfAverages),
		new DcmDataDictionaryElement (0x0018, 0x0084, VRCODE_DS, "Imaging Frequency", DD_ImagingFrequency),
		new DcmDataDictionaryElement (0x0018, 0x0085, VRCODE_SH, "Imaged Nucleus", DD_ImagedNucleus),
		new DcmDataDictionaryElement (0x0018, 0x0086, VRCODE_IS, "Echo Number(s)", DD_EchoNumber),
		new DcmDataDictionaryElement (0x0018, 0x0087, VRCODE_DS, "Magnetic Field Strength", DD_MagneticFieldStrength),
		new DcmDataDictionaryElement (0x0018, 0x0088, VRCODE_DS, "Spacing Between Slices", DD_SpacingBetweenSlices),
		new DcmDataDictionaryElement (0x0018, 0x0089, VRCODE_IS, "Number of Phase Encoding Steps", DD_NumberOfPhaseEncodingSteps),
		new DcmDataDictionaryElement (0x0018, 0x0090, VRCODE_DS, "Data Collection Diameter", DD_DataCollectionDiameter),
		new DcmDataDictionaryElement (0x0018, 0x0091, VRCODE_IS, "Echo Train Length", DD_EchoTrainLength),
		new DcmDataDictionaryElement (0x0018, 0x0093, VRCODE_DS, "Percent Sampling", DD_PercentSampling),
		new DcmDataDictionaryElement (0x0018, 0x0094, VRCODE_DS, "Percent Phase Field of View", DD_PercentPhaseFieldOfView),
		new DcmDataDictionaryElement (0x0018, 0x0095, VRCODE_DS, "Pixel Bandwidth", DD_PixelBandwidth),
		new DcmDataDictionaryElement (0x0018, 0x1000, VRCODE_LO, "Device Serial Number", DD_DeviceSerialNumber),
		new DcmDataDictionaryElement (0x0018, 0x1004, VRCODE_LO, "Plate ID", DD_PlateID),
		new DcmDataDictionaryElement (0x0018, 0x1010, VRCODE_LO, "Secondary Capture Device ID", DD_SecondaryCaptureDeviceID),
		new DcmDataDictionaryElement (0x0018, 0x1011, VRCODE_LO, "Hardcopy Creation Device ID", DD_HardcopyCreationDeviceID),
		new DcmDataDictionaryElement (0x0018, 0x1012, VRCODE_DA, "Date of Secondary Capture", DD_DateOfSecondaryCapture),
		new DcmDataDictionaryElement (0x0018, 0x1014, VRCODE_TM, "Time of Secondary Capture", DD_TimeOfSecondaryCapture),
		new DcmDataDictionaryElement (0x0018, 0x1016, VRCODE_LO, "Secondary Capture Device Manufacturer", DD_SecondaryCaptureDeviceManufacturer),
		new DcmDataDictionaryElement (0x0018, 0x1017, VRCODE_LO, "Hardcopy Device Manufacturer", DD_HardcopyDeviceManufacturer),
		new DcmDataDictionaryElement (0x0018, 0x1018, VRCODE_LO, "Secondary Capture Device Manufacturer's Model Name", DD_SecondaryCaptureDeviceManufacturersModelName),
		new DcmDataDictionaryElement (0x0018, 0x1019, VRCODE_LO, "Secondary Capture Device Software Version(s)", DD_SecondaryCaptureDeviceSoftwareVersion),
		new DcmDataDictionaryElement (0x0018, 0x101A, VRCODE_LO, "Hardcopy Device Software Version", DD_HardcopyDeviceSoftwareVersion),
		new DcmDataDictionaryElement (0x0018, 0x101B, VRCODE_LO, "Hardcopy Device Manfuacturer's Model Name", DD_HardcopyDeviceManfuacturersModelName),
		new DcmDataDictionaryElement (0x0018, 0x1020, VRCODE_LO, "Software Version(s)", DD_SoftwareVersion),
		new DcmDataDictionaryElement (0x0018, 0x1022, VRCODE_SH, "Video Image Format Acquired", DD_VideoImageFormatAcquired),
		new DcmDataDictionaryElement (0x0018, 0x1023, VRCODE_LO, "Digital Image Format Acquired", DD_DigitalImageFormatAcquired),
		new DcmDataDictionaryElement (0x0018, 0x1030, VRCODE_LO, "Protocol Name", DD_ProtocolName),
		new DcmDataDictionaryElement (0x0018, 0x1040, VRCODE_LO, "Contrast/Bolus Route", DD_ContrastBolusRoute),
		new DcmDataDictionaryElement (0x0018, 0x1041, VRCODE_DS, "Contrast/Bolus Volume", DD_ContrastBolusVolume),
		new DcmDataDictionaryElement (0x0018, 0x1042, VRCODE_TM, "Contrast/Bolus Start Time", DD_ContrastBolusStartTime),
		new DcmDataDictionaryElement (0x0018, 0x1043, VRCODE_TM, "Contrast/Bolus Stop Time", DD_ContrastBolusStopTime),
		new DcmDataDictionaryElement (0x0018, 0x1044, VRCODE_DS, "Contrast/Bolus Total Dose", DD_ContrastBolusTotalDose),
		new DcmDataDictionaryElement (0x0018, 0x1045, VRCODE_IS, "Syringe Counts", DD_SyringeCounts),
		new DcmDataDictionaryElement (0x0018, 0x1046, VRCODE_DS, "Contrast Flow Rate(s)", DD_ContrastFlowRate),
		new DcmDataDictionaryElement (0x0018, 0x1047, VRCODE_DS, "Contrast Flow Duration(s)", DD_ContrastFlowDuration),
		new DcmDataDictionaryElement (0x0018, 0x1048, VRCODE_CS, "Contrast/Bolus Ingredient", DD_ContrastBolusIngredient),
		new DcmDataDictionaryElement (0x0018, 0x1049, VRCODE_DS, "Contrast/Bolus Ingredient Concentration", DD_ContrastBolusIngredientConcentration),
		new DcmDataDictionaryElement (0x0018, 0x1050, VRCODE_DS, "Spatial Resolution", DD_SpatialResolution),
		new DcmDataDictionaryElement (0x0018, 0x1060, VRCODE_DS, "Trigger Time", DD_TriggerTime),
		new DcmDataDictionaryElement (0x0018, 0x1061, VRCODE_LO, "Trigger Source or Type", DD_TriggerSourceOrType),
		new DcmDataDictionaryElement (0x0018, 0x1062, VRCODE_IS, "Nominal Interval", DD_NominalInterval),
		new DcmDataDictionaryElement (0x0018, 0x1063, VRCODE_DS, "Frame Time", DD_FrameTime),
		new DcmDataDictionaryElement (0x0018, 0x1064, VRCODE_LO, "Framing Type", DD_FramingType),
		new DcmDataDictionaryElement (0x0018, 0x1065, VRCODE_DS, "Frame Time Vector", DD_FrameTimeVector),
		new DcmDataDictionaryElement (0x0018, 0x1066, VRCODE_DS, "Frame Delay", DD_FrameDelay),
		new DcmDataDictionaryElement (0x0018, 0x1070, VRCODE_LO, "Radionuclide Route", DD_RadionuclideRoute),
		new DcmDataDictionaryElement (0x0018, 0x1070, VRCODE_LO, "Radiopharmaceutical Route", DD_RadiopharmaceuticalRoute),
		new DcmDataDictionaryElement (0x0018, 0x1071, VRCODE_DS, "Radionuclide Volume", DD_RadionuclideVolume),
		new DcmDataDictionaryElement (0x0018, 0x1071, VRCODE_DS, "Radiopharmaceutical Volume", DD_RadiopharmaceuticalVolume),
		new DcmDataDictionaryElement (0x0018, 0x1072, VRCODE_TM, "Radionuclide Start Time", DD_RadionuclideStartTime),
		new DcmDataDictionaryElement (0x0018, 0x1072, VRCODE_TM, "Radiopharmaceutical Start Time", DD_RadiopharmaceuticalStartTime),
		new DcmDataDictionaryElement (0x0018, 0x1073, VRCODE_TM, "Radionuclide Stop Time", DD_RadionuclideStopTime),
		new DcmDataDictionaryElement (0x0018, 0x1073, VRCODE_TM, "Radiopharmaceutical Stop Time", DD_RadiopharmaceuticalStopTime),
		new DcmDataDictionaryElement (0x0018, 0x1074, VRCODE_DS, "Radionuclide Total Dose", DD_RadionuclideTotalDose),
		new DcmDataDictionaryElement (0x0018, 0x1075, VRCODE_DS, "Radionuclide Half Life", DD_RadionuclideHalfLife),
		new DcmDataDictionaryElement (0x0018, 0x1076, VRCODE_DS, "Radionuclide Positron Fraction", DD_RadionuclidePositronFraction),
		new DcmDataDictionaryElement (0x0018, 0x1077, VRCODE_DS, "Radiopharmaceutical Specific Activity", DD_RadiopharmaceuticalSpecificActivity),
		new DcmDataDictionaryElement (0x0018, 0x1080, VRCODE_CS, "Beat Rejection Flag", DD_BeatRejectionFlag),
		new DcmDataDictionaryElement (0x0018, 0x1081, VRCODE_IS, "Low R-R Value", DD_LowRRValue),
		new DcmDataDictionaryElement (0x0018, 0x1082, VRCODE_IS, "High R-R Value", DD_HighRRValue),
		new DcmDataDictionaryElement (0x0018, 0x1083, VRCODE_IS, "Intervals Acquired", DD_IntervalsAcquired),
		new DcmDataDictionaryElement (0x0018, 0x1084, VRCODE_IS, "Intervals Rejected", DD_IntervalsRejected),
		new DcmDataDictionaryElement (0x0018, 0x1085, VRCODE_LO, "PVC Rejection", DD_PVCRejection),
		new DcmDataDictionaryElement (0x0018, 0x1086, VRCODE_IS, "Skip Beats", DD_SkipBeats),
		new DcmDataDictionaryElement (0x0018, 0x1088, VRCODE_IS, "Heart Rate", DD_HeartRate),
		new DcmDataDictionaryElement (0x0018, 0x1090, VRCODE_IS, "Cardiac Number of Images", DD_CardiacNumberOfImages),
		new DcmDataDictionaryElement (0x0018, 0x1094, VRCODE_IS, "Trigger Window", DD_TriggerWindow),
		new DcmDataDictionaryElement (0x0018, 0x1100, VRCODE_DS, "Reconstruction Diameter", DD_ReconstructionDiameter),
		new DcmDataDictionaryElement (0x0018, 0x1110, VRCODE_DS, "Distance Source to Detector", DD_DistanceSourceToDetector),
		new DcmDataDictionaryElement (0x0018, 0x1111, VRCODE_DS, "Distance Source to Patient", DD_DistanceSourceToPatient),
		new DcmDataDictionaryElement (0x0018, 0x1114, VRCODE_DS, "Estimated Radiographic Magnification Factor", DD_EstimatedRadiographicMagnificationFactor),
		new DcmDataDictionaryElement (0x0018, 0x1120, VRCODE_DS, "Gantry/Detector Tilt", DD_GantryDetectorTilt),
		new DcmDataDictionaryElement (0x0018, 0x1121, VRCODE_DS, "Gantry/Detector Slew", DD_GantryDetectorSlew),
		new DcmDataDictionaryElement (0x0018, 0x1130, VRCODE_DS, "Table Height", DD_TableHeight),
		new DcmDataDictionaryElement (0x0018, 0x1131, VRCODE_DS, "Table Traverse", DD_TableTraverse),
		new DcmDataDictionaryElement (0x0018, 0x1134, VRCODE_CS, "Table Motion", DD_TableMotion),
		new DcmDataDictionaryElement (0x0018, 0x1135, VRCODE_DS, "Table Vertical Increment", DD_TableVerticalIncrement),
		new DcmDataDictionaryElement (0x0018, 0x1136, VRCODE_DS, "Table Lateral Increment", DD_TableLateralIncrement),
		new DcmDataDictionaryElement (0x0018, 0x1137, VRCODE_DS, "Table Longitudinal Increment", DD_TableLongitudinalIncrement),
		new DcmDataDictionaryElement (0x0018, 0x1138, VRCODE_DS, "Table Angle", DD_TableAngle),
		new DcmDataDictionaryElement (0x0018, 0x113A, VRCODE_CS, "Table Type", DD_TableType),
		new DcmDataDictionaryElement (0x0018, 0x1140, VRCODE_CS, "Rotation Direction", DD_RotationDirection),
		new DcmDataDictionaryElement (0x0018, 0x1141, VRCODE_DS, "Angular Position", DD_AngularPosition),
		new DcmDataDictionaryElement (0x0018, 0x1142, VRCODE_DS, "Radial Position", DD_RadialPosition),
		new DcmDataDictionaryElement (0x0018, 0x1143, VRCODE_DS, "Scan Arc", DD_ScanArc),
		new DcmDataDictionaryElement (0x0018, 0x1144, VRCODE_DS, "Angular Step", DD_AngularStep),
		new DcmDataDictionaryElement (0x0018, 0x1145, VRCODE_DS, "Center of Rotation Offset", DD_CenterOfRotationOffset),
		new DcmDataDictionaryElement (0x0018, 0x1146, VRCODE_DS, "Rotation Offset", DD_RotationOffset),
		new DcmDataDictionaryElement (0x0018, 0x1147, VRCODE_CS, "Field of View Shape", DD_FieldOfViewShape),
		new DcmDataDictionaryElement (0x0018, 0x1149, VRCODE_IS, "Field of View Dimension(s)", DD_FieldOfViewDimension),
		new DcmDataDictionaryElement (0x0018, 0x1150, VRCODE_IS, "Exposure Time", DD_ExposureTime),
		new DcmDataDictionaryElement (0x0018, 0x1151, VRCODE_IS, "X-ray Tube Current", DD_XrayTubeCurrent),
		new DcmDataDictionaryElement (0x0018, 0x1152, VRCODE_IS, "Exposure", DD_Exposure),
		new DcmDataDictionaryElement (0x0018, 0x1153, VRCODE_IS, "Exposure in uAs", DD_ExposureInUAs),
		new DcmDataDictionaryElement (0x0018, 0x1154, VRCODE_DS, "Average Pulse Width", DD_AveragePulseWidth),
		new DcmDataDictionaryElement (0x0018, 0x1155, VRCODE_CS, "Radiation Setting", DD_RadiationSetting),
		new DcmDataDictionaryElement (0x0018, 0x1156, VRCODE_CS, "Rectification Type", DD_RectificationType),
		new DcmDataDictionaryElement (0x0018, 0x115A, VRCODE_CS, "Radiation Mode", DD_RadiationMode),
		new DcmDataDictionaryElement (0x0018, 0x115E, VRCODE_DS, "Image Area Dose Product", DD_ImageAreaDoseProduct),
		new DcmDataDictionaryElement (0x0018, 0x1160, VRCODE_SH, "Filter Type", DD_FilterType),
		new DcmDataDictionaryElement (0x0018, 0x1161, VRCODE_LO, "Type of Filters", DD_TypeOfFilters),
		new DcmDataDictionaryElement (0x0018, 0x1162, VRCODE_DS, "Intensifier Size", DD_IntensifierSize),
		new DcmDataDictionaryElement (0x0018, 0x1164, VRCODE_DS, "Imager Pixel Spacing", DD_ImagerPixelSpacing),
		new DcmDataDictionaryElement (0x0018, 0x1166, VRCODE_CS, "Grid", DD_Grid),
		new DcmDataDictionaryElement (0x0018, 0x1170, VRCODE_IS, "Generator Power", DD_GeneratorPower),
		new DcmDataDictionaryElement (0x0018, 0x1180, VRCODE_SH, "Collimator/grid Name", DD_CollimatorgridName),
		new DcmDataDictionaryElement (0x0018, 0x1181, VRCODE_CS, "Collimator Type", DD_CollimatorType),
		new DcmDataDictionaryElement (0x0018, 0x1182, VRCODE_IS, "Focal Distance", DD_FocalDistance),
		new DcmDataDictionaryElement (0x0018, 0x1183, VRCODE_DS, "X Focus Center", DD_XFocusCenter),
		new DcmDataDictionaryElement (0x0018, 0x1184, VRCODE_DS, "Y Focus Center", DD_YFocusCenter),
		new DcmDataDictionaryElement (0x0018, 0x1190, VRCODE_DS, "Focal Spot(s)", DD_FocalSpot),
		new DcmDataDictionaryElement (0x0018, 0x1191, VRCODE_CS, "Anode Target Material", DD_AnodeTargetMaterial),
		new DcmDataDictionaryElement (0x0018, 0x11A0, VRCODE_DS, "Body Part Thickness", DD_BodyPartThickness),
		new DcmDataDictionaryElement (0x0018, 0x11A2, VRCODE_DS, "Compression Force", DD_CompressionForce),
		new DcmDataDictionaryElement (0x0018, 0x1200, VRCODE_DA, "Date of Last Calibration", DD_DateOfLastCalibration),
		new DcmDataDictionaryElement (0x0018, 0x1201, VRCODE_TM, "Time of Last Calibration", DD_TimeOfLastCalibration),
		new DcmDataDictionaryElement (0x0018, 0x1210, VRCODE_SH, "Convolution Kernel", DD_ConvolutionKernel),
		new DcmDataDictionaryElement (0x0018, 0x1242, VRCODE_IS, "Actual Frame Duration", DD_ActualFrameDuration),
		new DcmDataDictionaryElement (0x0018, 0x1243, VRCODE_IS, "Count Rate", DD_CountRate),
		new DcmDataDictionaryElement (0x0018, 0x1244, VRCODE_US, "Preferred Playback Sequencing", DD_PreferredPlaybackSequencing),
		new DcmDataDictionaryElement (0x0018, 0x1250, VRCODE_SH, "Receiving Coil", DD_ReceivingCoil),
		new DcmDataDictionaryElement (0x0018, 0x1251, VRCODE_SH, "Transmitting Coil", DD_TransmittingCoil),
		new DcmDataDictionaryElement (0x0018, 0x1260, VRCODE_SH, "Plate Type", DD_PlateType),
		new DcmDataDictionaryElement (0x0018, 0x1261, VRCODE_LO, "Phosphor Type", DD_PhosphorType),
		new DcmDataDictionaryElement (0x0018, 0x1300, VRCODE_DS, "Scan Velocity", DD_ScanVelocity),
		new DcmDataDictionaryElement (0x0018, 0x1301, VRCODE_CS, "Whole Body Technique", DD_WholeBodyTechnique),
		new DcmDataDictionaryElement (0x0018, 0x1302, VRCODE_IS, "Scan Length", DD_ScanLength),
		new DcmDataDictionaryElement (0x0018, 0x1310, VRCODE_US, "Acquisition Matrix", DD_AcquisitionMatrix),
		new DcmDataDictionaryElement (0x0018, 0x1312, VRCODE_CS, "Phase Encoding Direction", DD_PhaseEncodingDirection),
		new DcmDataDictionaryElement (0x0018, 0x1314, VRCODE_DS, "Flip Angle", DD_FlipAngle),
		new DcmDataDictionaryElement (0x0018, 0x1315, VRCODE_CS, "Variable Flip Angle Flag", DD_VariableFlipAngleFlag),
		new DcmDataDictionaryElement (0x0018, 0x1316, VRCODE_DS, "SAR", DD_SAR),
		new DcmDataDictionaryElement (0x0018, 0x1318, VRCODE_DS, "dB/dt", DD_dBdt),
		new DcmDataDictionaryElement (0x0018, 0x1400, VRCODE_LO, "Acquisition Device Processing Description", DD_AcquisitionDeviceProcessingDescription),
		new DcmDataDictionaryElement (0x0018, 0x1401, VRCODE_LO, "Acquisition Device Processing Code", DD_AcquisitionDeviceProcessingCode),
		new DcmDataDictionaryElement (0x0018, 0x1402, VRCODE_CS, "Cassette Orientation", DD_CassetteOrientation),
		new DcmDataDictionaryElement (0x0018, 0x1403, VRCODE_CS, "Cassette Size", DD_CassetteSize),
		new DcmDataDictionaryElement (0x0018, 0x1404, VRCODE_US, "Exposures on Plate", DD_ExposuresOnPlate),
		new DcmDataDictionaryElement (0x0018, 0x1405, VRCODE_IS, "Relative X-ray Exposure", DD_RelativeXrayExposure),
		new DcmDataDictionaryElement (0x0018, 0x1450, VRCODE_CS, "Column Angulation", DD_ColumnAngulation),
		new DcmDataDictionaryElement (0x0018, 0x1460, VRCODE_DS, "Tomo Layer Height", DD_TomoLayerHeight),
		new DcmDataDictionaryElement (0x0018, 0x1470, VRCODE_DS, "Tomo Angle", DD_TomoAngle),
		new DcmDataDictionaryElement (0x0018, 0x1480, VRCODE_DS, "Tomo Time", DD_TomoTime),
		new DcmDataDictionaryElement (0x0018, 0x1490, VRCODE_CS, "Tomo Type", DD_TomoType),
		new DcmDataDictionaryElement (0x0018, 0x1491, VRCODE_CS, "Tomo Class", DD_TomoClass),
		new DcmDataDictionaryElement (0x0018, 0x1495, VRCODE_IS, "Number of Tomosynthesis Source Images", DD_NumberOfTomosynthesisSourceImages),
		new DcmDataDictionaryElement (0x0018, 0x1500, VRCODE_CS, "Positioner Motion", DD_PositionerMotion),
		new DcmDataDictionaryElement (0x0018, 0x1508, VRCODE_CS, "Positioner Type", DD_PositionerType),
		new DcmDataDictionaryElement (0x0018, 0x1510, VRCODE_DS, "Positioner Primary Angle", DD_PositionerPrimaryAngle),
		new DcmDataDictionaryElement (0x0018, 0x1511, VRCODE_DS, "Positioner Secondary Angle", DD_PositionerSecondaryAngle),
		new DcmDataDictionaryElement (0x0018, 0x1520, VRCODE_DS, "Positioner Primary Angle Increment", DD_PositionerPrimaryAngleIncrement),
		new DcmDataDictionaryElement (0x0018, 0x1521, VRCODE_DS, "Positioner Secondary Angle Increment", DD_PositionerSecondaryAngleIncrement),
		new DcmDataDictionaryElement (0x0018, 0x1530, VRCODE_DS, "Detector Primary Angle", DD_DetectorPrimaryAngle),
		new DcmDataDictionaryElement (0x0018, 0x1531, VRCODE_DS, "Detector Secondary Angle", DD_DetectorSecondaryAngle),
		new DcmDataDictionaryElement (0x0018, 0x1600, VRCODE_CS, "Shutter Shape", DD_ShutterShape),
		new DcmDataDictionaryElement (0x0018, 0x1602, VRCODE_IS, "Shutter Left Vertical Edge", DD_ShutterLeftVerticalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1604, VRCODE_IS, "Shutter Right Vertical Edge", DD_ShutterRightVerticalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1606, VRCODE_IS, "Shutter Upper Horizontal Edge", DD_ShutterUpperHorizontalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1608, VRCODE_IS, "Shutter Lower Horizontal Edge", DD_ShutterLowerHorizontalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1610, VRCODE_IS, "Center of Circular Shutter", DD_CenterOfCircularShutter),
		new DcmDataDictionaryElement (0x0018, 0x1612, VRCODE_IS, "Radius of Circular Shutter", DD_RadiusOfCircularShutter),
		new DcmDataDictionaryElement (0x0018, 0x1620, VRCODE_IS, "Vertices of the Polygonal Shutter", DD_VerticesOfThePolygonalShutter),
		new DcmDataDictionaryElement (0x0018, 0x1700, VRCODE_CS, "Collimator Shape", DD_CollimatorShape),
		new DcmDataDictionaryElement (0x0018, 0x1702, VRCODE_IS, "Collimator Left Vertical Edge", DD_CollimatorLeftVerticalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1704, VRCODE_IS, "Collimator Right Vertical Edge", DD_CollimatorRightVerticalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1706, VRCODE_IS, "Collimator Upper Horizontal Edge", DD_CollimatorUpperHorizontalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1708, VRCODE_IS, "Collimator Lower Horizontal Edge", DD_CollimatorLowerHorizontalEdge),
		new DcmDataDictionaryElement (0x0018, 0x1710, VRCODE_IS, "Center of Circular Collimator", DD_CenterOfCircularCollimator),
		new DcmDataDictionaryElement (0x0018, 0x1712, VRCODE_IS, "Radius of Circular Collimator", DD_RadiusOfCircularCollimator),
		new DcmDataDictionaryElement (0x0018, 0x1720, VRCODE_IS, "Vertices of the Polygonal Collimator", DD_VerticesOfThePolygonalCollimator),
		new DcmDataDictionaryElement (0x0018, 0x5000, VRCODE_SH, "Output Power", DD_OutputPower),
		new DcmDataDictionaryElement (0x0018, 0x5010, VRCODE_LO, "Transducer Data", DD_TransducerData),
		new DcmDataDictionaryElement (0x0018, 0x5012, VRCODE_DS, "Focus Depth", DD_FocusDepth),
		new DcmDataDictionaryElement (0x0018, 0x5020, VRCODE_LO, "Processing Function", DD_ProcessingFunction),
		new DcmDataDictionaryElement (0x0018, 0x5021, VRCODE_LO, "Postprocessing Function", DD_PostprocessingFunction),
		new DcmDataDictionaryElement (0x0018, 0x5022, VRCODE_DS, "Mechanical Index", DD_MechanicalIndex),
		new DcmDataDictionaryElement (0x0018, 0x5024, VRCODE_DS, "Thermal Index", DD_ThermalIndex),
		new DcmDataDictionaryElement (0x0018, 0x5026, VRCODE_DS, "Cranial Thermal Index", DD_CranialThermalIndex),
		new DcmDataDictionaryElement (0x0018, 0x5027, VRCODE_DS, "Soft Tissue Thermal Index", DD_SoftTissueThermalIndex),
		new DcmDataDictionaryElement (0x0018, 0x5028, VRCODE_DS, "Soft Tissue-focus Thermal Index", DD_SoftTissuefocusThermalIndex),
		new DcmDataDictionaryElement (0x0018, 0x5029, VRCODE_DS, "Soft Tissue-surface Thermal Index", DD_SoftTissuesurfaceThermalIndex),
		new DcmDataDictionaryElement (0x0018, 0x5050, VRCODE_IS, "Depth of Scan Field", DD_DepthOfScanField),
		new DcmDataDictionaryElement (0x0018, 0x5100, VRCODE_CS, "Patient Position", DD_PatientPosition),
		new DcmDataDictionaryElement (0x0018, 0x5101, VRCODE_CS, "View Position", DD_ViewPosition),
		new DcmDataDictionaryElement (0x0018, 0x5104, VRCODE_SQ, "Projection Eponymous Name Code Sequence", DD_ProjectionEponymousNameCodeSequence),
		new DcmDataDictionaryElement (0x0018, 0x5210, VRCODE_DS, "Image Transformation Matrix", DD_ImageTransformationMatrix),
		new DcmDataDictionaryElement (0x0018, 0x5212, VRCODE_DS, "Image Translation Vector", DD_ImageTranslationVector),
		new DcmDataDictionaryElement (0x0018, 0x6000, VRCODE_DS, "Sensitivity", DD_Sensitivity),
		new DcmDataDictionaryElement (0x0018, 0x6011, VRCODE_SQ, "Sequence of Ultrasound Regions", DD_SequenceOfUltrasoundRegions),
		new DcmDataDictionaryElement (0x0018, 0x6012, VRCODE_US, "Region Spatial Format", DD_RegionSpatialFormat),
		new DcmDataDictionaryElement (0x0018, 0x6014, VRCODE_US, "Region Data Type", DD_RegionDataType),
		new DcmDataDictionaryElement (0x0018, 0x6016, VRCODE_UL, "Region Flags", DD_RegionFlags),
		new DcmDataDictionaryElement (0x0018, 0x6018, VRCODE_UL, "Region Location Min X 0", DD_RegionLocationMinX0),
		new DcmDataDictionaryElement (0x0018, 0x601A, VRCODE_UL, "Region Location Min Y 0", DD_RegionLocationMinY0),
		new DcmDataDictionaryElement (0x0018, 0x601C, VRCODE_UL, "Region Location Max X 1", DD_RegionLocationMaxX1),
		new DcmDataDictionaryElement (0x0018, 0x601E, VRCODE_UL, "Region Location Max Y 1", DD_RegionLocationMaxY1),
		new DcmDataDictionaryElement (0x0018, 0x6020, VRCODE_SL, "Reference Pixel X 0", DD_ReferencePixelX0),
		new DcmDataDictionaryElement (0x0018, 0x6022, VRCODE_SL, "Reference Pixel Y 0", DD_ReferencePixelY0),
		new DcmDataDictionaryElement (0x0018, 0x6024, VRCODE_US, "Physical Units X Direction", DD_PhysicalUnitsXDirection),
		new DcmDataDictionaryElement (0x0018, 0x6026, VRCODE_US, "Physical Units Y Direction", DD_PhysicalUnitsYDirection),
		new DcmDataDictionaryElement (0x0018, 0x6028, VRCODE_FD, "Reference Pixel Physical Value X", DD_ReferencePixelPhysicalValueX),
		new DcmDataDictionaryElement (0x0018, 0x602A, VRCODE_FD, "Reference Pixel Physical Value Y", DD_ReferencePixelPhysicalValueY),
		new DcmDataDictionaryElement (0x0018, 0x602C, VRCODE_FD, "Physical Delta X", DD_PhysicalDeltaX),
		new DcmDataDictionaryElement (0x0018, 0x602E, VRCODE_FD, "Physical Delta Y", DD_PhysicalDeltaY),
		new DcmDataDictionaryElement (0x0018, 0x6030, VRCODE_UL, "Transducer Frequency", DD_TransducerFrequency),
		new DcmDataDictionaryElement (0x0018, 0x6031, VRCODE_CS, "Transducer Type", DD_TransducerType),
		new DcmDataDictionaryElement (0x0018, 0x6032, VRCODE_UL, "Pulse Repetition Frequency", DD_PulseRepetitionFrequency),
		new DcmDataDictionaryElement (0x0018, 0x6034, VRCODE_FD, "Doppler Correction Angle", DD_DopplerCorrectionAngle),
		new DcmDataDictionaryElement (0x0018, 0x6036, VRCODE_FD, "Steering Angle", DD_SteeringAngle),
		new DcmDataDictionaryElement (0x0018, 0x6038, VRCODE_UL, "Doppler Sample Volume X Position", DD_DopplerSampleVolumeXPosition),
		new DcmDataDictionaryElement (0x0018, 0x603A, VRCODE_UL, "Doppler Sample Volume Y Position", DD_DopplerSampleVolumeYPosition),
		new DcmDataDictionaryElement (0x0018, 0x603C, VRCODE_UL, "TM-Line Position X 0", DD_TMLinePositionX0),
		new DcmDataDictionaryElement (0x0018, 0x603E, VRCODE_UL, "TM-Line Position Y 0", DD_TMLinePositionY0),
		new DcmDataDictionaryElement (0x0018, 0x6040, VRCODE_UL, "TM-Line Position X 1", DD_TMLinePositionX1),
		new DcmDataDictionaryElement (0x0018, 0x6042, VRCODE_UL, "TM-Line Position Y 1", DD_TMLinePositionY1),
		new DcmDataDictionaryElement (0x0018, 0x6044, VRCODE_US, "Pixel Component Organization", DD_PixelComponentOrganization),
		new DcmDataDictionaryElement (0x0018, 0x6046, VRCODE_UL, "Pixel Component Mask", DD_PixelComponentMask),
		new DcmDataDictionaryElement (0x0018, 0x6048, VRCODE_UL, "Pixel Component Range Start", DD_PixelComponentRangeStart),
		new DcmDataDictionaryElement (0x0018, 0x604A, VRCODE_UL, "Pixel Component Range Stop", DD_PixelComponentRangeStop),
		new DcmDataDictionaryElement (0x0018, 0x604C, VRCODE_US, "Pixel Component Physical Units", DD_PixelComponentPhysicalUnits),
		new DcmDataDictionaryElement (0x0018, 0x604E, VRCODE_US, "Pixel Component Data Type", DD_PixelComponentDataType),
		new DcmDataDictionaryElement (0x0018, 0x6050, VRCODE_UL, "Number of Table Break Points", DD_NumberOfTableBreakPoints),
		new DcmDataDictionaryElement (0x0018, 0x6052, VRCODE_UL, "Table of X Break Points", DD_TableOfXBreakPoints),
		new DcmDataDictionaryElement (0x0018, 0x6054, VRCODE_FD, "Table of Y Break Points", DD_TableOfYBreakPoints),
		new DcmDataDictionaryElement (0x0018, 0x6056, VRCODE_UL, "Number of Table Entries", DD_NumberOfTableEntries),
		new DcmDataDictionaryElement (0x0018, 0x6058, VRCODE_UL, "Table of Pixel Values", DD_TableOfPixelValues),
		new DcmDataDictionaryElement (0x0018, 0x605A, VRCODE_FL, "Table of Parameter Values", DD_TableOfParameterValues),
		new DcmDataDictionaryElement (0x0018, 0x7000, VRCODE_CS, "Detector Conditions Nominal Flag", DD_DetectorConditionsNominalFlag),
		new DcmDataDictionaryElement (0x0018, 0x7001, VRCODE_DS, "Detector Temperature", DD_DetectorTemperature),
		new DcmDataDictionaryElement (0x0018, 0x7004, VRCODE_CS, "Detector Type", DD_DetectorType),
		new DcmDataDictionaryElement (0x0018, 0x7005, VRCODE_CS, "Detector Configuration", DD_DetectorConfiguration),
		new DcmDataDictionaryElement (0x0018, 0x7006, VRCODE_LT, "Detector Description", DD_DetectorDescription),
		new DcmDataDictionaryElement (0x0018, 0x7008, VRCODE_LT, "Detector Mode", DD_DetectorMode),
		new DcmDataDictionaryElement (0x0018, 0x700A, VRCODE_SH, "Detector ID", DD_DetectorID),
		new DcmDataDictionaryElement (0x0018, 0x700C, VRCODE_DA, "Date of Last Detector Calibration", DD_DateOfLastDetectorCalibration),
		new DcmDataDictionaryElement (0x0018, 0x700E, VRCODE_TM, "Time of Last Detector Calibration", DD_TimeOfLastDetectorCalibration),
		new DcmDataDictionaryElement (0x0018, 0x7010, VRCODE_IS, "Exposures on Detector Since Last Calibration", DD_ExposuresOnDetectorSinceLastCalibration),
		new DcmDataDictionaryElement (0x0018, 0x7011, VRCODE_IS, "Exposures on Detector Since Manufactured", DD_ExposuresOnDetectorSinceManufactured),
		new DcmDataDictionaryElement (0x0018, 0x7012, VRCODE_DS, "Detector Time Since Last Exposure", DD_DetectorTimeSinceLastExposure),
		new DcmDataDictionaryElement (0x0018, 0x7014, VRCODE_DS, "Detector Active Time", DD_DetectorActiveTime),
		new DcmDataDictionaryElement (0x0018, 0x7016, VRCODE_DS, "Detector Activation Offset From Exposure", DD_DetectorActivationOffsetFromExposure),
		new DcmDataDictionaryElement (0x0018, 0x701A, VRCODE_DS, "Detector Binning", DD_DetectorBinning),
		new DcmDataDictionaryElement (0x0018, 0x7020, VRCODE_DS, "Detector Element Physical Size", DD_DetectorElementPhysicalSize),
		new DcmDataDictionaryElement (0x0018, 0x7022, VRCODE_DS, "Detector Element Spacing", DD_DetectorElementSpacing),
		new DcmDataDictionaryElement (0x0018, 0x7024, VRCODE_CS, "Detector Active Shape", DD_DetectorActiveShape),
		new DcmDataDictionaryElement (0x0018, 0x7026, VRCODE_DS, "Detector Active Dimension(s)", DD_DetectorActiveDimension),
		new DcmDataDictionaryElement (0x0018, 0x7028, VRCODE_DS, "Detector Active Origin", DD_DetectorActiveOrigin),
		new DcmDataDictionaryElement (0x0018, 0x7030, VRCODE_DS, "Field of View Origin", DD_FieldOfViewOrigin),
		new DcmDataDictionaryElement (0x0018, 0x7032, VRCODE_DS, "Field of View Rotation", DD_FieldOfViewRotation),
		new DcmDataDictionaryElement (0x0018, 0x7034, VRCODE_CS, "Field of View Horizontal Flip", DD_FieldOfViewHorizontalFlip),
		new DcmDataDictionaryElement (0x0018, 0x7040, VRCODE_LT, "Grid Absorbing Material", DD_GridAbsorbingMaterial),
		new DcmDataDictionaryElement (0x0018, 0x7041, VRCODE_LT, "Grid Spacing Material", DD_GridSpacingMaterial),
		new DcmDataDictionaryElement (0x0018, 0x7042, VRCODE_DS, "Grid Thickness", DD_GridThickness),
		new DcmDataDictionaryElement (0x0018, 0x7044, VRCODE_DS, "Grid Pitch", DD_GridPitch),
		new DcmDataDictionaryElement (0x0018, 0x7046, VRCODE_IS, "Grid Aspect Ratio", DD_GridAspectRatio),
		new DcmDataDictionaryElement (0x0018, 0x7048, VRCODE_DS, "Grid Period", DD_GridPeriod),
		new DcmDataDictionaryElement (0x0018, 0x704C, VRCODE_DS, "Grid Focal Distance", DD_GridFocalDistance),
		new DcmDataDictionaryElement (0x0018, 0x7050, VRCODE_LT, "Filter Material", DD_FilterMaterial),
		new DcmDataDictionaryElement (0x0018, 0x7052, VRCODE_DS, "Filter Thickness Minimum", DD_FilterThicknessMinimum),
		new DcmDataDictionaryElement (0x0018, 0x7054, VRCODE_DS, "Filter Thickness Maximum", DD_FilterThicknessMaximum),
		new DcmDataDictionaryElement (0x0018, 0x7060, VRCODE_CS, "Exposure Control Mode", DD_ExposureControlMode),
		new DcmDataDictionaryElement (0x0018, 0x7062, VRCODE_LT, "Exposure Control Mode Description", DD_ExposureControlModeDescription),
		new DcmDataDictionaryElement (0x0018, 0x7064, VRCODE_CS, "Exposure Status", DD_ExposureStatus),
		new DcmDataDictionaryElement (0x0018, 0x7065, VRCODE_DS, "Phototimer Setting", DD_PhototimerSetting),
		new DcmDataDictionaryElement (0x0020, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0020),
		new DcmDataDictionaryElement (0x0020, 0x000D, VRCODE_UI, "Study Instance UID", DD_StudyInstanceUID),
		new DcmDataDictionaryElement (0x0020, 0x000E, VRCODE_UI, "Series Instance UID", DD_SeriesInstanceUID),
		new DcmDataDictionaryElement (0x0020, 0x0010, VRCODE_SH, "Study ID", DD_StudyID),
		new DcmDataDictionaryElement (0x0020, 0x0011, VRCODE_IS, "Series Number", DD_SeriesNumber),
		new DcmDataDictionaryElement (0x0020, 0x0012, VRCODE_IS, "Acquisition Number", DD_AcquisitionNumber),
		new DcmDataDictionaryElement (0x0020, 0x0013, VRCODE_IS, "Instance Number", DD_InstanceNumber),
		new DcmDataDictionaryElement (0x0020, 0x0014, VRCODE_IS, "Isotope Number", DD_IsotopeNumber),
		new DcmDataDictionaryElement (0x0020, 0x0015, VRCODE_IS, "Phase Number", DD_PhaseNumber),
		new DcmDataDictionaryElement (0x0020, 0x0016, VRCODE_IS, "Interval Number", DD_IntervalNumber),
		new DcmDataDictionaryElement (0x0020, 0x0017, VRCODE_IS, "Time Slot Number", DD_TimeSlotNumber),
		new DcmDataDictionaryElement (0x0020, 0x0018, VRCODE_IS, "Angle Number", DD_AngleNumber),
		new DcmDataDictionaryElement (0x0020, 0x0019, VRCODE_IS, "Item Number", DD_ItemNumber),
		new DcmDataDictionaryElement (0x0020, 0x0020, VRCODE_CS, "Patient Orientation", DD_PatientOrientation),
		new DcmDataDictionaryElement (0x0020, 0x0022, VRCODE_IS, "Overlay Number", DD_OverlayNumber),
		new DcmDataDictionaryElement (0x0020, 0x0024, VRCODE_IS, "Curve Number", DD_CurveNumber),
		new DcmDataDictionaryElement (0x0020, 0x0026, VRCODE_IS, "Lookup Table Number", DD_LookupTableNumber),
		new DcmDataDictionaryElement (0x0020, 0x0032, VRCODE_DS, "Image Position (Patient)", DD_ImagePositionPatient),
		new DcmDataDictionaryElement (0x0020, 0x0037, VRCODE_DS, "Image Orientation (Patient)", DD_ImageOrientationPatient),
		new DcmDataDictionaryElement (0x0020, 0x0052, VRCODE_UI, "Frame of Reference UID", DD_FrameOfReferenceUID),
		new DcmDataDictionaryElement (0x0020, 0x0060, VRCODE_CS, "Laterality", DD_Laterality),
		new DcmDataDictionaryElement (0x0020, 0x0062, VRCODE_CS, "Image Laterality", DD_ImageLaterality),
		new DcmDataDictionaryElement (0x0020, 0x0100, VRCODE_IS, "Temporal Position Identifier", DD_TemporalPositionIdentifier),
		new DcmDataDictionaryElement (0x0020, 0x0105, VRCODE_IS, "Number of Temporal Positions", DD_NumberOfTemporalPositions),
		new DcmDataDictionaryElement (0x0020, 0x0110, VRCODE_DS, "Temporal Resolution", DD_TemporalResolution),
		new DcmDataDictionaryElement (0x0020, 0x1000, VRCODE_IS, "Series in Study", DD_SeriesInStudy),
		new DcmDataDictionaryElement (0x0020, 0x1002, VRCODE_IS, "Images in Acquisition", DD_ImagesInAcquisition),
		new DcmDataDictionaryElement (0x0020, 0x1004, VRCODE_IS, "Acquisitions in Study", DD_AcquisitionsInStudy),
		new DcmDataDictionaryElement (0x0020, 0x1040, VRCODE_LO, "Position Reference Indicator", DD_PositionReferenceIndicator),
		new DcmDataDictionaryElement (0x0020, 0x1041, VRCODE_DS, "Slice Location", DD_SliceLocation),
		new DcmDataDictionaryElement (0x0020, 0x1070, VRCODE_IS, "Other Study Numbers", DD_OtherStudyNumbers),
		new DcmDataDictionaryElement (0x0020, 0x1200, VRCODE_IS, "Number of Patient Related Studies", DD_NumberOfPatientRelatedStudies),
		new DcmDataDictionaryElement (0x0020, 0x1202, VRCODE_IS, "Number of Patient Related Series", DD_NumberOfPatientRelatedSeries),
		new DcmDataDictionaryElement (0x0020, 0x1204, VRCODE_IS, "Number of Patient Related Instances", DD_NumberOfPatientRelatedInstances),
		new DcmDataDictionaryElement (0x0020, 0x1206, VRCODE_IS, "Number of Study Related Series", DD_NumberOfStudyRelatedSeries),
		new DcmDataDictionaryElement (0x0020, 0x1208, VRCODE_IS, "Number of Study Related Instances", DD_NumberOfStudyRelatedInstances),
		new DcmDataDictionaryElement (0x0020, 0x1209, VRCODE_IS, "Number of Series Related Instances", DD_NumberOfSeriesRelatedInstances),
		new DcmDataDictionaryElement (0x0020, 0x4000, VRCODE_LT, "Image Comments", DD_ImageComments),
		new DcmDataDictionaryElement (0x0028, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0028),
		new DcmDataDictionaryElement (0x0028, 0x0002, VRCODE_US, "Samples per Pixel", DD_SamplesPerPixel),
		new DcmDataDictionaryElement (0x0028, 0x0004, VRCODE_CS, "Photometric Interpretation", DD_PhotometricInterpretation),
		new DcmDataDictionaryElement (0x0028, 0x0006, VRCODE_US, "Planar Configuration", DD_PlanarConfiguration),
		new DcmDataDictionaryElement (0x0028, 0x0008, VRCODE_IS, "Number of Frames", DD_NumberOfFrames),
		new DcmDataDictionaryElement (0x0028, 0x0009, VRCODE_AT, "Frame Increment Pointer", DD_FrameIncrementPointer),
		new DcmDataDictionaryElement (0x0028, 0x0010, VRCODE_US, "Rows", DD_Rows),
		new DcmDataDictionaryElement (0x0028, 0x0011, VRCODE_US, "Columns", DD_Columns),
		new DcmDataDictionaryElement (0x0028, 0x0012, VRCODE_US, "Planes", DD_Planes),
		new DcmDataDictionaryElement (0x0028, 0x0014, VRCODE_US, "Ultrasound Color Data Present", DD_UltrasoundColorDataPresent),
		new DcmDataDictionaryElement (0x0028, 0x0030, VRCODE_DS, "Pixel Spacing", DD_PixelSpacing),
		new DcmDataDictionaryElement (0x0028, 0x0031, VRCODE_DS, "Zoom Factor", DD_ZoomFactor),
		new DcmDataDictionaryElement (0x0028, 0x0032, VRCODE_DS, "Zoom Center", DD_ZoomCenter),
		new DcmDataDictionaryElement (0x0028, 0x0034, VRCODE_IS, "Pixel Aspect Ratio", DD_PixelAspectRatio),
		new DcmDataDictionaryElement (0x0028, 0x0051, VRCODE_CS, "Corrected Image", DD_CorrectedImage),
		new DcmDataDictionaryElement (0x0028, 0x0100, VRCODE_US, "Bits Allocated", DD_BitsAllocated),
		new DcmDataDictionaryElement (0x0028, 0x0101, VRCODE_US, "Bits Stored", DD_BitsStored),
		new DcmDataDictionaryElement (0x0028, 0x0102, VRCODE_US, "High Bit", DD_HighBit),
		new DcmDataDictionaryElement (0x0028, 0x0103, VRCODE_US, "Pixel Representation", DD_PixelRepresentation),
		new DcmDataDictionaryElement (0x0028, 0x0106, VRCODE_US_or_SS, "Smallest Image Pixel Value", DD_SmallestImagePixelValue),
		new DcmDataDictionaryElement (0x0028, 0x0107, VRCODE_US_or_SS, "Largest Image Pixel Value", DD_LargestImagePixelValue),
		new DcmDataDictionaryElement (0x0028, 0x0108, VRCODE_US_or_SS, "Smallest Pixel Value in Series", DD_SmallestPixelValueInSeries),
		new DcmDataDictionaryElement (0x0028, 0x0109, VRCODE_US_or_SS, "Largest Pixel Value in Series", DD_LargestPixelValueInSeries),
		new DcmDataDictionaryElement (0x0028, 0x0110, VRCODE_US_or_SS, "Smallest Image Pixel Value in Plane", DD_SmallestImagePixelValueInPlane),
		new DcmDataDictionaryElement (0x0028, 0x0111, VRCODE_US_or_SS, "Largest Image Pixel Value in Plane", DD_LargestImagePixelValueInPlane),
		new DcmDataDictionaryElement (0x0028, 0x0120, VRCODE_US_or_SS, "Pixel Padding Value", DD_PixelPaddingValue),
		new DcmDataDictionaryElement (0x0028, 0x0300, VRCODE_CS, "Quality Control Image", DD_QualityControlImage),
		new DcmDataDictionaryElement (0x0028, 0x0301, VRCODE_CS, "Burned In Annotation", DD_BurnedInAnnotation),
		new DcmDataDictionaryElement (0x0028, 0x1040, VRCODE_CS, "Pixel Intensity Relationship", DD_PixelIntensityRelationship),
		new DcmDataDictionaryElement (0x0028, 0x1041, VRCODE_SS, "Pixel Intensity Relationship Sign", DD_PixelIntensityRelationshipSign),
		new DcmDataDictionaryElement (0x0028, 0x1050, VRCODE_DS, "Window Center", DD_WindowCenter),
		new DcmDataDictionaryElement (0x0028, 0x1051, VRCODE_DS, "Window Width", DD_WindowWidth),
		new DcmDataDictionaryElement (0x0028, 0x1052, VRCODE_DS, "Rescale Intercept", DD_RescaleIntercept),
		new DcmDataDictionaryElement (0x0028, 0x1053, VRCODE_DS, "Rescale Slope", DD_RescaleSlope),
		new DcmDataDictionaryElement (0x0028, 0x1054, VRCODE_LO, "Rescale Type", DD_RescaleType),
		new DcmDataDictionaryElement (0x0028, 0x1055, VRCODE_LO, "Window Center & Width Explanation", DD_WindowCenterWidthExplanation),
		new DcmDataDictionaryElement (0x0028, 0x1090, VRCODE_CS, "Recommended Viewing Mode", DD_RecommendedViewingMode),
		new DcmDataDictionaryElement (0x0028, 0x1101, VRCODE_US_US_or_SS_US, "Red Palette Color Lookup Table Descriptor", DD_RedPaletteColorLookupTableDescriptor),
		new DcmDataDictionaryElement (0x0028, 0x1102, VRCODE_US_US_or_SS_US, "Green Palette Color Lookup Table Descriptor", DD_GreenPaletteColorLookupTableDescriptor),
		new DcmDataDictionaryElement (0x0028, 0x1103, VRCODE_US_US_or_SS_US, "Blue Palette Color Lookup Table Descriptor", DD_BluePaletteColorLookupTableDescriptor),
		new DcmDataDictionaryElement (0x0028, 0x1199, VRCODE_UI, "Palette Color Lookup Table UID", DD_PaletteColorLookupTableUID),
		new DcmDataDictionaryElement (0x0028, 0x1201, VRCODE_US_or_SS_or_OW, "Red Palette Color Lookup Table Data", DD_RedPaletteColorLookupTableData),
		new DcmDataDictionaryElement (0x0028, 0x1202, VRCODE_US_or_SS_or_OW, "Green Palette Color Lookup Table Data", DD_GreenPaletteColorLookupTableData),
		new DcmDataDictionaryElement (0x0028, 0x1203, VRCODE_US_or_SS_or_OW, "Blue Palette Color Lookup Table Data", DD_BluePaletteColorLookupTableData),
		new DcmDataDictionaryElement (0x0028, 0x1221, VRCODE_OW, "Segmented Red Palette Color Lookup Table Data", DD_SegmentedRedPaletteColorLookupTableData),
		new DcmDataDictionaryElement (0x0028, 0x1222, VRCODE_OW, "Segmented Green Palette Color Lookup Table Data", DD_SegmentedGreenPaletteColorLookupTableData),
		new DcmDataDictionaryElement (0x0028, 0x1223, VRCODE_OW, "Segmented Blue Palette Color Lookup Table Data", DD_SegmentedBluePaletteColorLookupTableData),
		new DcmDataDictionaryElement (0x0028, 0x1300, VRCODE_CS, "Implant Present", DD_ImplantPresent),
		new DcmDataDictionaryElement (0x0028, 0x2110, VRCODE_CS, "Lossy Image Compression", DD_LossyImageCompression_0028),
		new DcmDataDictionaryElement (0x0028, 0x2112, VRCODE_DS, "Lossy Image Compression Ratio", DD_LossyImageCompressionRatio),
		new DcmDataDictionaryElement (0x0028, 0x3000, VRCODE_SQ, "Modality LUT Sequence", DD_ModalityLUTSequence),
		new DcmDataDictionaryElement (0x0028, 0x3002, VRCODE_US_US_or_SS_US, "LUT Descriptor", DD_LUTDescriptor),
		new DcmDataDictionaryElement (0x0028, 0x3003, VRCODE_LO, "LUT Explanation", DD_LUTExplanation),
		new DcmDataDictionaryElement (0x0028, 0x3004, VRCODE_LO, "Modality LUT Type", DD_ModalityLUTType),
		new DcmDataDictionaryElement (0x0028, 0x3006, VRCODE_US_or_SS, "LUT Data", DD_LUTData),
		new DcmDataDictionaryElement (0x0028, 0x3010, VRCODE_SQ, "VOI LUT Sequence", DD_VOILUTSequence),
		new DcmDataDictionaryElement (0x0028, 0x5000, VRCODE_SQ, "Bi-Plane Acquisition Sequence", DD_BiPlaneAcquisitionSequence),
		new DcmDataDictionaryElement (0x0028, 0x6010, VRCODE_US, "Representative Frame Number", DD_RepresentativeFrameNumber),
		new DcmDataDictionaryElement (0x0028, 0x6020, VRCODE_US, "Frame Numbers of Interest (FOI)", DD_FrameNumbersOfInterestFOI),
		new DcmDataDictionaryElement (0x0028, 0x6022, VRCODE_LO, "Frame(s) of Interest Description", DD_FrameOfInterestDescription),
		new DcmDataDictionaryElement (0x0028, 0x6030, VRCODE_US, "Mask Pointer(s)", DD_MaskPointer),
		new DcmDataDictionaryElement (0x0028, 0x6040, VRCODE_US, "R Wave Pointer", DD_RWavePointer),
		new DcmDataDictionaryElement (0x0028, 0x6100, VRCODE_SQ, "Mask Subtraction Sequence", DD_MaskSubtractionSequence),
		new DcmDataDictionaryElement (0x0028, 0x6101, VRCODE_CS, "Mask Operation", DD_MaskOperation),
		new DcmDataDictionaryElement (0x0028, 0x6102, VRCODE_US, "Applicable Frame Range", DD_ApplicableFrameRange),
		new DcmDataDictionaryElement (0x0028, 0x6110, VRCODE_US, "Mask Frame Numbers", DD_MaskFrameNumbers),
		new DcmDataDictionaryElement (0x0028, 0x6112, VRCODE_US, "Contrast Frame Averaging", DD_ContrastFrameAveraging),
		new DcmDataDictionaryElement (0x0028, 0x6114, VRCODE_FL, "Mask Sub-pixel Shift", DD_MaskSubpixelShift),
		new DcmDataDictionaryElement (0x0028, 0x6120, VRCODE_SS, "TID Offset", DD_TIDOffset),
		new DcmDataDictionaryElement (0x0028, 0x6190, VRCODE_ST, "Mask Operation Explanation", DD_MaskOperationExplanation),
		new DcmDataDictionaryElement (0x0032, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0032),
		new DcmDataDictionaryElement (0x0032, 0x000A, VRCODE_CS, "Study Status ID", DD_StudyStatusID),
		new DcmDataDictionaryElement (0x0032, 0x000C, VRCODE_CS, "Study Priority ID", DD_StudyPriorityID),
		new DcmDataDictionaryElement (0x0032, 0x0012, VRCODE_LO, "Study ID Issuer", DD_StudyIDIssuer),
		new DcmDataDictionaryElement (0x0032, 0x0032, VRCODE_DA, "Study Verified Date", DD_StudyVerifiedDate),
		new DcmDataDictionaryElement (0x0032, 0x0033, VRCODE_TM, "Study Verified Time", DD_StudyVerifiedTime),
		new DcmDataDictionaryElement (0x0032, 0x0034, VRCODE_DA, "Study Read Date", DD_StudyReadDate),
		new DcmDataDictionaryElement (0x0032, 0x0035, VRCODE_TM, "Study Read Time", DD_StudyReadTime),
		new DcmDataDictionaryElement (0x0032, 0x1000, VRCODE_DA, "Scheduled Study Start Date", DD_ScheduledStudyStartDate),
		new DcmDataDictionaryElement (0x0032, 0x1001, VRCODE_TM, "Scheduled Study Start Time", DD_ScheduledStudyStartTime),
		new DcmDataDictionaryElement (0x0032, 0x1010, VRCODE_DA, "Scheduled Study Stop Date", DD_ScheduledStudyStopDate),
		new DcmDataDictionaryElement (0x0032, 0x1011, VRCODE_TM, "Scheduled Study Stop Time", DD_ScheduledStudyStopTime),
		new DcmDataDictionaryElement (0x0032, 0x1020, VRCODE_LO, "Scheduled Study Location", DD_ScheduledStudyLocation),
		new DcmDataDictionaryElement (0x0032, 0x1021, VRCODE_AE, "Scheduled Study Location_AE Title(s)", DD_ScheduledStudyLocation_AETitle),
		new DcmDataDictionaryElement (0x0032, 0x1030, VRCODE_LO, "Reason for Study", DD_ReasonForStudy),
		new DcmDataDictionaryElement (0x0032, 0x1032, VRCODE_PN, "Requesting Physician", DD_RequestingPhysician),
		new DcmDataDictionaryElement (0x0032, 0x1033, VRCODE_LO, "Requesting Service", DD_RequestingService),
		new DcmDataDictionaryElement (0x0032, 0x1040, VRCODE_DA, "Study Arrival Date", DD_StudyArrivalDate),
		new DcmDataDictionaryElement (0x0032, 0x1041, VRCODE_TM, "Study Arrival Time", DD_StudyArrivalTime),
		new DcmDataDictionaryElement (0x0032, 0x1050, VRCODE_DA, "Study Completion Date", DD_StudyCompletionDate),
		new DcmDataDictionaryElement (0x0032, 0x1051, VRCODE_TM, "Study Completion Time", DD_StudyCompletionTime),
		new DcmDataDictionaryElement (0x0032, 0x1055, VRCODE_CS, "Study Component Status ID", DD_StudyComponentStatusID),
		new DcmDataDictionaryElement (0x0032, 0x1060, VRCODE_LO, "Requested Procedure Description", DD_RequestedProcedureDescription),
		new DcmDataDictionaryElement (0x0032, 0x1064, VRCODE_SQ, "Requested Procedure Code Sequence", DD_RequestedProcedureCodeSequence),
		new DcmDataDictionaryElement (0x0032, 0x1070, VRCODE_LO, "Requested Contrast Agent", DD_RequestedContrastAgent),
		new DcmDataDictionaryElement (0x0032, 0x4000, VRCODE_LT, "Study Comments", DD_StudyComments),
		new DcmDataDictionaryElement (0x0038, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0038),
		new DcmDataDictionaryElement (0x0038, 0x0004, VRCODE_SQ, "Referenced Patient Alias Sequence", DD_ReferencedPatientAliasSequence),
		new DcmDataDictionaryElement (0x0038, 0x0008, VRCODE_CS, "Visit Status ID", DD_VisitStatusID),
		new DcmDataDictionaryElement (0x0038, 0x0010, VRCODE_LO, "Admission ID", DD_AdmissionID),
		new DcmDataDictionaryElement (0x0038, 0x0011, VRCODE_LO, "Issuer of Admission ID", DD_IssuerOfAdmissionID),
		new DcmDataDictionaryElement (0x0038, 0x0016, VRCODE_LO, "Route of Admissions", DD_RouteOfAdmissions),
		new DcmDataDictionaryElement (0x0038, 0x001A, VRCODE_DA, "Scheduled Admission Date", DD_ScheduledAdmissionDate),
		new DcmDataDictionaryElement (0x0038, 0x001B, VRCODE_TM, "Scheduled Admission Time", DD_ScheduledAdmissionTime),
		new DcmDataDictionaryElement (0x0038, 0x001C, VRCODE_DA, "Scheduled Discharge Date", DD_ScheduledDischargeDate),
		new DcmDataDictionaryElement (0x0038, 0x001D, VRCODE_TM, "Scheduled Discharge Time", DD_ScheduledDischargeTime),
		new DcmDataDictionaryElement (0x0038, 0x001E, VRCODE_LO, "Scheduled Patient Institution Residence", DD_ScheduledPatientInstitutionResidence),
		new DcmDataDictionaryElement (0x0038, 0x0020, VRCODE_DA, "Admitting Date", DD_AdmittingDate),
		new DcmDataDictionaryElement (0x0038, 0x0021, VRCODE_TM, "Admitting Time", DD_AdmittingTime),
		new DcmDataDictionaryElement (0x0038, 0x0030, VRCODE_DA, "Discharge Date", DD_DischargeDate),
		new DcmDataDictionaryElement (0x0038, 0x0032, VRCODE_TM, "Discharge Time", DD_DischargeTime),
		new DcmDataDictionaryElement (0x0038, 0x0040, VRCODE_LO, "Discharge Diagnosis Description", DD_DischargeDiagnosisDescription),
		new DcmDataDictionaryElement (0x0038, 0x0044, VRCODE_SQ, "Discharge Diagnosis Code Sequence", DD_DischargeDiagnosisCodeSequence),
		new DcmDataDictionaryElement (0x0038, 0x0050, VRCODE_LO, "Special Needs", DD_SpecialNeeds),
		new DcmDataDictionaryElement (0x0038, 0x0300, VRCODE_LO, "Current Patient Location", DD_CurrentPatientLocation),
		new DcmDataDictionaryElement (0x0038, 0x0400, VRCODE_LO, "Patient's Institution Residence", DD_PatientsInstitutionResidence),
		new DcmDataDictionaryElement (0x0038, 0x0500, VRCODE_LO, "Patient State", DD_PatientState),
		new DcmDataDictionaryElement (0x0038, 0x4000, VRCODE_LT, "Visit Comments", DD_VisitComments),
		new DcmDataDictionaryElement (0x0040, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0040),
		new DcmDataDictionaryElement (0x0040, 0x0001, VRCODE_AE, "Scheduled Station", DD_ScheduledStation),
		new DcmDataDictionaryElement (0x0040, 0x0002, VRCODE_DA, "Scheduled Procedure Step Start Date", DD_ScheduledProcedureStepStartDate),
		new DcmDataDictionaryElement (0x0040, 0x0003, VRCODE_TM, "Scheduled Procedure Step Start Time", DD_ScheduledProcedureStepStartTime),
		new DcmDataDictionaryElement (0x0040, 0x0004, VRCODE_DA, "Scheduled Procedure Step End Date", DD_ScheduledProcedureStepEndDate),
		new DcmDataDictionaryElement (0x0040, 0x0005, VRCODE_TM, "Scheduled Procedure Step End Time", DD_ScheduledProcedureStepEndTime),
		new DcmDataDictionaryElement (0x0040, 0x0006, VRCODE_PN, "Scheduled Performing Physician's Name", DD_ScheduledPerformingPhysiciansName),
		new DcmDataDictionaryElement (0x0040, 0x0007, VRCODE_LO, "Scheduled Procedure Step Description", DD_ScheduledProcedureStepDescription),
		new DcmDataDictionaryElement (0x0040, 0x0008, VRCODE_SQ, "Scheduled Action Item Code Sequence", DD_ScheduledActionItemCodeSequence),
		new DcmDataDictionaryElement (0x0040, 0x0009, VRCODE_SH, "Scheduled Procedure Step ID", DD_ScheduledProcedureStepID),
		new DcmDataDictionaryElement (0x0040, 0x0010, VRCODE_SH, "Scheduled Station Name", DD_ScheduledStationName),
		new DcmDataDictionaryElement (0x0040, 0x0011, VRCODE_SH, "Scheduled Procedure Step Location", DD_ScheduledProcedureStepLocation),
		new DcmDataDictionaryElement (0x0040, 0x0012, VRCODE_LO, "Pre-Medication", DD_PreMedication),
		new DcmDataDictionaryElement (0x0040, 0x0020, VRCODE_CS, "Scheduled Procedure Step Status", DD_ScheduledProcedureStepStatus),
		new DcmDataDictionaryElement (0x0040, 0x0100, VRCODE_SQ, "Scheduled Procedure Step Sequence", DD_ScheduledProcedureStepSequence),
		new DcmDataDictionaryElement (0x0040, 0x0220, VRCODE_SQ, "Referenced Standalone SOP Instance Sequence", DD_ReferencedStandaloneSOPInstanceSequence),
		new DcmDataDictionaryElement (0x0040, 0x0241, VRCODE_AE, "Performed Station", DD_PerformedStation),
		new DcmDataDictionaryElement (0x0040, 0x0242, VRCODE_SH, "Performed Station Name", DD_PerformedStationName),
		new DcmDataDictionaryElement (0x0040, 0x0243, VRCODE_SH, "Performed Location", DD_PerformedLocation),
		new DcmDataDictionaryElement (0x0040, 0x0244, VRCODE_DA, "Performed Procedure Step Start Date", DD_PerformedProcedureStepStartDate),
		new DcmDataDictionaryElement (0x0040, 0x0245, VRCODE_TM, "Performed Procedure Step Start Time", DD_PerformedProcedureStepStartTime),
		new DcmDataDictionaryElement (0x0040, 0x0250, VRCODE_DA, "Performed Procedure Step End Date", DD_PerformedProcedureStepEndDate),
		new DcmDataDictionaryElement (0x0040, 0x0251, VRCODE_TM, "Performed Procedure Step End Time", DD_PerformedProcedureStepEndTime),
		new DcmDataDictionaryElement (0x0040, 0x0252, VRCODE_CS, "Performed Procedure Step Status", DD_PerformedProcedureStepStatus),
		new DcmDataDictionaryElement (0x0040, 0x0253, VRCODE_SH, "Performed Procedure Step ID", DD_PerformedProcedureStepID),
		new DcmDataDictionaryElement (0x0040, 0x0254, VRCODE_LO, "Performed Procedure Step Description", DD_PerformedProcedureStepDescription),
		new DcmDataDictionaryElement (0x0040, 0x0255, VRCODE_LO, "Performed Procedure Type Description", DD_PerformedProcedureTypeDescription),
		new DcmDataDictionaryElement (0x0040, 0x0260, VRCODE_SQ, "Performed Action Item Sequence", DD_PerformedActionItemSequence),
		new DcmDataDictionaryElement (0x0040, 0x0270, VRCODE_SQ, "Scheduled Step Attributes Sequence", DD_ScheduledStepAttributesSequence),
		new DcmDataDictionaryElement (0x0040, 0x0275, VRCODE_SQ, "Request Attributes Sequence", DD_RequestAttributesSequence),
		new DcmDataDictionaryElement (0x0040, 0x0280, VRCODE_ST, "Comments on the Performed Procedure Steps", DD_CommentsOnThePerformedProcedureSteps),
		new DcmDataDictionaryElement (0x0040, 0x0293, VRCODE_SQ, "Quantity Sequence", DD_QuantitySequence),
		new DcmDataDictionaryElement (0x0040, 0x0294, VRCODE_DS, "Quantity", DD_Quantity_0040),
		new DcmDataDictionaryElement (0x0040, 0x0295, VRCODE_SQ, "Measuring Units Sequence", DD_MeasuringUnitsSequence),
		new DcmDataDictionaryElement (0x0040, 0x0296, VRCODE_SQ, "Billing Item Sequence", DD_BillingItemSequence),
		new DcmDataDictionaryElement (0x0040, 0x0300, VRCODE_US, "Total Time of Fluoroscopy", DD_TotalTimeOfFluoroscopy),
		new DcmDataDictionaryElement (0x0040, 0x0301, VRCODE_US, "Total Number of Exposures", DD_TotalNumberOfExposures),
		new DcmDataDictionaryElement (0x0040, 0x0302, VRCODE_US, "Entrance Dose", DD_EntranceDose),
		new DcmDataDictionaryElement (0x0040, 0x0303, VRCODE_US, "Exposed Area", DD_ExposedArea),
		new DcmDataDictionaryElement (0x0040, 0x0306, VRCODE_DS, "Distance Source to Entrance", DD_DistanceSourceToEntrance),
		new DcmDataDictionaryElement (0x0040, 0x0307, VRCODE_DS, "Distance Source to Support", DD_DistanceSourceToSupport),
		new DcmDataDictionaryElement (0x0040, 0x0310, VRCODE_ST, "Comments on Radiation Dose", DD_CommentsOnRadiationDose),
		new DcmDataDictionaryElement (0x0040, 0x0312, VRCODE_DS, "X-Ray Output", DD_XRayOutput),
		new DcmDataDictionaryElement (0x0040, 0x0314, VRCODE_DS, "Half Value Layer", DD_HalfValueLayer),
		new DcmDataDictionaryElement (0x0040, 0x0316, VRCODE_DS, "Organ Dose", DD_OrganDose),
		new DcmDataDictionaryElement (0x0040, 0x0318, VRCODE_CS, "Organ Exposed", DD_OrganExposed),
		new DcmDataDictionaryElement (0x0040, 0x0320, VRCODE_SQ, "Billing Procedure Step Sequence", DD_BillingProcedureStepSequence),
		new DcmDataDictionaryElement (0x0040, 0x0321, VRCODE_SQ, "Film Consumption Sequence", DD_FilmConsumptionSequence),
		new DcmDataDictionaryElement (0x0040, 0x0324, VRCODE_SQ, "Billing Supplies and Devices Sequence", DD_BillingSuppliesAndDevicesSequence),
		new DcmDataDictionaryElement (0x0040, 0x0330, VRCODE_SQ, "Referenced Procedure Step Sequence", DD_ReferencedProcedureStepSequence),
		new DcmDataDictionaryElement (0x0040, 0x0340, VRCODE_SQ, "Performed Series Sequence", DD_PerformedSeriesSequence),
		new DcmDataDictionaryElement (0x0040, 0x0400, VRCODE_LT, "Comments on the Scheduled Procedure Step", DD_CommentsOnTheScheduledProcedureStep),
		new DcmDataDictionaryElement (0x0040, 0x0555, VRCODE_SQ, "Acquisition Context Sequence", DD_AcquisitionContextSequence),
		new DcmDataDictionaryElement (0x0040, 0x0556, VRCODE_ST, "Acquisition Context Description", DD_AcquisitionContextDescription),
		new DcmDataDictionaryElement (0x0040, 0x06FA, VRCODE_LO, "Slide Identifier", DD_SlideIdentifier),
		new DcmDataDictionaryElement (0x0040, 0x071A, VRCODE_SQ, "Image Center Point Coordinates Sequence", DD_ImageCenterPointCoordinatesSequence),
		new DcmDataDictionaryElement (0x0040, 0x072A, VRCODE_DS, "X offset in Slide Coordinate System", DD_XOffsetInSlideCoordinateSystem),
		new DcmDataDictionaryElement (0x0040, 0x073A, VRCODE_DS, "Y offset in Slide Coordinate System", DD_YOffsetInSlideCoordinateSystem),
		new DcmDataDictionaryElement (0x0040, 0x074A, VRCODE_DS, "Z offset in Slide Coordinate System", DD_ZOffsetInSlideCoordinateSystem),
		new DcmDataDictionaryElement (0x0040, 0x08D8, VRCODE_SQ, "Pixel Spacing Sequence", DD_PixelSpacingSequence),
		new DcmDataDictionaryElement (0x0040, 0x08DA, VRCODE_SQ, "Coordinate System Axis Code Sequence", DD_CoordinateSystemAxisCodeSequence),
		new DcmDataDictionaryElement (0x0040, 0x08EA, VRCODE_SQ, "Measurement Units Code Sequence", DD_MeasurementUnitsCodeSequence),
		new DcmDataDictionaryElement (0x0040, 0xA043, VRCODE_SQ, "Concept-name Code Sequence", DD_ConceptnameCodeSequence),
		new DcmDataDictionaryElement (0x0040, 0xA121, VRCODE_DA, "Date", DD_Date_0040),
		new DcmDataDictionaryElement (0x0040, 0xA122, VRCODE_TM, "Time", DD_Time_0040),
		new DcmDataDictionaryElement (0x0040, 0xA123, VRCODE_PN, "Person Name", DD_PersonName),
		new DcmDataDictionaryElement (0x0040, 0xA136, VRCODE_US, "Referenced Frame Numbers", DD_ReferencedFrameNumbers),
		new DcmDataDictionaryElement (0x0040, 0xA160, VRCODE_UT, "Text Value", DD_TextValue),
		new DcmDataDictionaryElement (0x0040, 0xA168, VRCODE_SQ, "Concept Code Sequence", DD_ConceptCodeSequence),
		new DcmDataDictionaryElement (0x0040, 0xA30A, VRCODE_DS, "Numeric Value", DD_NumericValue),
		new DcmDataDictionaryElement (0x0040, 0x1001, VRCODE_SH, "Requested Procedure ID", DD_RequestedProcedureID),
		new DcmDataDictionaryElement (0x0040, 0x1002, VRCODE_LO, "Reason for the Requested Procedure", DD_ReasonForTheRequestedProcedure),
		new DcmDataDictionaryElement (0x0040, 0x1003, VRCODE_SH, "Requested Procedure Priority", DD_RequestedProcedurePriority),
		new DcmDataDictionaryElement (0x0040, 0x1004, VRCODE_LO, "Patient Transport Arrangements", DD_PatientTransportArrangements),
		new DcmDataDictionaryElement (0x0040, 0x1005, VRCODE_LO, "Requested Procedure Location", DD_RequestedProcedureLocation),
		new DcmDataDictionaryElement (0x0040, 0x1008, VRCODE_LO, "Confidentiality Code", DD_ConfidentialityCode),
		new DcmDataDictionaryElement (0x0040, 0x1009, VRCODE_SH, "Reporting Priority", DD_ReportingPriority),
		new DcmDataDictionaryElement (0x0040, 0x1010, VRCODE_PN, "Names of Intended Recipients of Results", DD_NamesOfIntendedRecipientsOfResults),
		new DcmDataDictionaryElement (0x0040, 0x1400, VRCODE_LT, "Requested Procedure Comments", DD_RequestedProcedureComments),
		new DcmDataDictionaryElement (0x0040, 0x2001, VRCODE_LO, "Reason for the Imaging Service Request", DD_ReasonForTheImagingServiceRequest),
		new DcmDataDictionaryElement (0x0040, 0x2004, VRCODE_DA, "Issue Date of Imaging Service Request", DD_IssueDateOfImagingServiceRequest),
		new DcmDataDictionaryElement (0x0040, 0x2005, VRCODE_TM, "Issue Time of Imaging Service Request", DD_IssueTimeOfImagingServiceRequest),
		new DcmDataDictionaryElement (0x0040, 0x2008, VRCODE_PN, "Order Entered By", DD_OrderEnteredBy),
		new DcmDataDictionaryElement (0x0040, 0x2009, VRCODE_SH, "Order Enterer's Location", DD_OrderEnterersLocation),
		new DcmDataDictionaryElement (0x0040, 0x2010, VRCODE_SH, "Order Callback Phone Number", DD_OrderCallbackPhoneNumber),
		new DcmDataDictionaryElement (0x0040, 0x2016, VRCODE_LO, "Placer Order Number / Imaging Service Request", DD_PlacerOrderNumberImagingServiceRequest),
		new DcmDataDictionaryElement (0x0040, 0x2017, VRCODE_LO, "Filler Order Number / Imaging Service Request", DD_FillerOrderNumberImagingServiceRequest),
		new DcmDataDictionaryElement (0x0040, 0x2400, VRCODE_LT, "Imaging Service Request Comments", DD_ImagingServiceRequestComments),
		new DcmDataDictionaryElement (0x0040, 0x3001, VRCODE_LO, "Confidentiality Constraint on Patient Data Description", DD_ConfidentialityConstraintOnPatientDataDescription),
		new DcmDataDictionaryElement (0x0050, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0050),
		new DcmDataDictionaryElement (0x0050, 0x0004, VRCODE_CS, "Calibration Image", DD_CalibrationImage),
		new DcmDataDictionaryElement (0x0050, 0x0010, VRCODE_SQ, "Device Sequence", DD_DeviceSequence),
		new DcmDataDictionaryElement (0x0050, 0x0014, VRCODE_DS, "Device Length", DD_DeviceLength),
		new DcmDataDictionaryElement (0x0050, 0x0016, VRCODE_DS, "Device Diameter", DD_DeviceDiameter),
		new DcmDataDictionaryElement (0x0050, 0x0017, VRCODE_CS, "Device Diameter Units", DD_DeviceDiameterUnits),
		new DcmDataDictionaryElement (0x0050, 0x0018, VRCODE_DS, "Device Volume", DD_DeviceVolume),
		new DcmDataDictionaryElement (0x0050, 0x0019, VRCODE_DS, "Inter-marker Distance", DD_IntermarkerDistance),
		new DcmDataDictionaryElement (0x0050, 0x0020, VRCODE_LO, "Device Description", DD_DeviceDescription),
		new DcmDataDictionaryElement (0x0054, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0054),
		new DcmDataDictionaryElement (0x0054, 0x0010, VRCODE_US, "Energy Window Vector", DD_EnergyWindowVector),
		new DcmDataDictionaryElement (0x0054, 0x0011, VRCODE_US, "Number of Energy Windows", DD_NumberOfEnergyWindows),
		new DcmDataDictionaryElement (0x0054, 0x0012, VRCODE_SQ, "Energy Window Information Sequence", DD_EnergyWindowInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0013, VRCODE_SQ, "Energy Window Range Sequence", DD_EnergyWindowRangeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0014, VRCODE_DS, "Energy Window Lower Limit", DD_EnergyWindowLowerLimit),
		new DcmDataDictionaryElement (0x0054, 0x0015, VRCODE_DS, "Energy Window Upper Limit", DD_EnergyWindowUpperLimit),
		new DcmDataDictionaryElement (0x0054, 0x0016, VRCODE_SQ, "Radiopharmaceutical Information Sequence", DD_RadiopharmaceuticalInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0017, VRCODE_IS, "Residual Syringe Counts", DD_ResidualSyringeCounts),
		new DcmDataDictionaryElement (0x0054, 0x0018, VRCODE_SH, "Energy Window Name", DD_EnergyWindowName),
		new DcmDataDictionaryElement (0x0054, 0x0020, VRCODE_US, "Detector Vector", DD_DetectorVector),
		new DcmDataDictionaryElement (0x0054, 0x0021, VRCODE_US, "Number of Detectors", DD_NumberOfDetectors),
		new DcmDataDictionaryElement (0x0054, 0x0022, VRCODE_SQ, "Detector Information Sequence", DD_DetectorInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0030, VRCODE_US, "Phase Vector", DD_PhaseVector),
		new DcmDataDictionaryElement (0x0054, 0x0031, VRCODE_US, "Number of Phases", DD_NumberOfPhases),
		new DcmDataDictionaryElement (0x0054, 0x0032, VRCODE_SQ, "Phase Information Sequence", DD_PhaseInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0033, VRCODE_US, "Number of Frames in Phase", DD_NumberOfFramesInPhase),
		new DcmDataDictionaryElement (0x0054, 0x0036, VRCODE_IS, "Phase Delay", DD_PhaseDelay),
		new DcmDataDictionaryElement (0x0054, 0x0038, VRCODE_IS, "Pause Between Frames", DD_PauseBetweenFrames),
		new DcmDataDictionaryElement (0x0054, 0x0050, VRCODE_US, "Rotation Vector", DD_RotationVector),
		new DcmDataDictionaryElement (0x0054, 0x0051, VRCODE_US, "Number of Rotations", DD_NumberOfRotations),
		new DcmDataDictionaryElement (0x0054, 0x0052, VRCODE_SQ, "Rotation Information Sequence", DD_RotationInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0053, VRCODE_US, "Number of Frames in Rotation", DD_NumberOfFramesInRotation),
		new DcmDataDictionaryElement (0x0054, 0x0060, VRCODE_US, "R-R Interval Vector", DD_RRIntervalVector),
		new DcmDataDictionaryElement (0x0054, 0x0061, VRCODE_US, "Number of R-R Intervals", DD_NumberOfRRIntervals),
		new DcmDataDictionaryElement (0x0054, 0x0062, VRCODE_SQ, "Gated Information Sequence", DD_GatedInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0063, VRCODE_SQ, "Data Information Sequence", DD_DataInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0070, VRCODE_US, "Time Slot Vector", DD_TimeSlotVector),
		new DcmDataDictionaryElement (0x0054, 0x0071, VRCODE_US, "Number of Time Slots", DD_NumberOfTimeSlots),
		new DcmDataDictionaryElement (0x0054, 0x0072, VRCODE_SQ, "Time Slot Information Sequence", DD_TimeSlotInformationSequence),
		new DcmDataDictionaryElement (0x0054, 0x0073, VRCODE_DS, "Time Slot Time", DD_TimeSlotTime),
		new DcmDataDictionaryElement (0x0054, 0x0080, VRCODE_US, "Slice Vector", DD_SliceVector),
		new DcmDataDictionaryElement (0x0054, 0x0081, VRCODE_US, "Number of Slices", DD_NumberOfSlices),
		new DcmDataDictionaryElement (0x0054, 0x0090, VRCODE_US, "Angular View Vector", DD_AngularViewVector),
		new DcmDataDictionaryElement (0x0054, 0x0100, VRCODE_US, "Time Slice Vector", DD_TimeSliceVector),
		new DcmDataDictionaryElement (0x0054, 0x0101, VRCODE_US, "Number of Time Slices", DD_NumberOfTimeSlices),
		new DcmDataDictionaryElement (0x0054, 0x0200, VRCODE_DS, "Start Angle", DD_StartAngle),
		new DcmDataDictionaryElement (0x0054, 0x0202, VRCODE_CS, "Type of Detector Motion", DD_TypeOfDetectorMotion),
		new DcmDataDictionaryElement (0x0054, 0x0210, VRCODE_IS, "Trigger Vector", DD_TriggerVector),
		new DcmDataDictionaryElement (0x0054, 0x0211, VRCODE_US, "Number of Triggers in Phase", DD_NumberOfTriggersInPhase),
		new DcmDataDictionaryElement (0x0054, 0x0220, VRCODE_SQ, "View Code Sequence", DD_ViewCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0222, VRCODE_SQ, "View Modifier Code Sequence", DD_ViewModifierCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0300, VRCODE_SQ, "Radionuclide Code Sequence", DD_RadionuclideCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0302, VRCODE_SQ, "Administration Route Code Sequence", DD_AdministrationRouteCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0304, VRCODE_SQ, "Radiopharmaceutical Code Sequence", DD_RadiopharmaceuticalCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0306, VRCODE_SQ, "Calibration Data Sequence", DD_CalibrationDataSequence),
		new DcmDataDictionaryElement (0x0054, 0x0308, VRCODE_US, "Energy Window Number", DD_EnergyWindowNumber),
		new DcmDataDictionaryElement (0x0054, 0x0400, VRCODE_SH, "Image ID", DD_ImageID),
		new DcmDataDictionaryElement (0x0054, 0x0410, VRCODE_SQ, "Patient Orientation Code Sequence", DD_PatientOrientationCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0412, VRCODE_SQ, "Patient Orientation Modifier Code Sequence", DD_PatientOrientationModifierCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x0414, VRCODE_SQ, "Patient Gantry Relationship Code Sequence", DD_PatientGantryRelationshipCodeSequence),
		new DcmDataDictionaryElement (0x0054, 0x1000, VRCODE_CS, "Series Type", DD_SeriesType),
		new DcmDataDictionaryElement (0x0054, 0x1001, VRCODE_CS, "Units", DD_Units),
		new DcmDataDictionaryElement (0x0054, 0x1002, VRCODE_CS, "Counts Source", DD_CountsSource),
		new DcmDataDictionaryElement (0x0054, 0x1004, VRCODE_CS, "Reprojection Method", DD_ReprojectionMethod),
		new DcmDataDictionaryElement (0x0054, 0x1100, VRCODE_CS, "Randoms Correction Method", DD_RandomsCorrectionMethod),
		new DcmDataDictionaryElement (0x0054, 0x1101, VRCODE_LO, "Attenuation Correction Method", DD_AttenuationCorrectionMethod),
		new DcmDataDictionaryElement (0x0054, 0x1102, VRCODE_CS, "Decay Correction", DD_DecayCorrection),
		new DcmDataDictionaryElement (0x0054, 0x1103, VRCODE_LO, "Reconstruction Method", DD_ReconstructionMethod),
		new DcmDataDictionaryElement (0x0054, 0x1104, VRCODE_LO, "Detector Lines of Response Used", DD_DetectorLinesOfResponseUsed),
		new DcmDataDictionaryElement (0x0054, 0x1105, VRCODE_LO, "Scatter Correction Method", DD_ScatterCorrectionMethod),
		new DcmDataDictionaryElement (0x0054, 0x1200, VRCODE_DS, "Axial Acceptance", DD_AxialAcceptance),
		new DcmDataDictionaryElement (0x0054, 0x1201, VRCODE_IS, "Axial Mash", DD_AxialMash),
		new DcmDataDictionaryElement (0x0054, 0x1202, VRCODE_IS, "Transverse Mash", DD_TransverseMash),
		new DcmDataDictionaryElement (0x0054, 0x1203, VRCODE_DS, "Detector Element Size", DD_DetectorElementSize),
		new DcmDataDictionaryElement (0x0054, 0x1210, VRCODE_DS, "Coincidence Window Width", DD_CoincidenceWindowWidth),
		new DcmDataDictionaryElement (0x0054, 0x1220, VRCODE_CS, "Secondary Counts Type", DD_SecondaryCountsType),
		new DcmDataDictionaryElement (0x0054, 0x1300, VRCODE_DS, "Frame Reference Time", DD_FrameReferenceTime),
		new DcmDataDictionaryElement (0x0054, 0x1310, VRCODE_IS, "Primary (Prompts) Counts Accumulated", DD_PrimaryPromptsCountsAccumulated),
		new DcmDataDictionaryElement (0x0054, 0x1311, VRCODE_IS, "Secondary Counts Accumulated", DD_SecondaryCountsAccumulated),
		new DcmDataDictionaryElement (0x0054, 0x1320, VRCODE_DS, "Slice Sensitivity Factor", DD_SliceSensitivityFactor),
		new DcmDataDictionaryElement (0x0054, 0x1321, VRCODE_DS, "Decay Factor", DD_DecayFactor),
		new DcmDataDictionaryElement (0x0054, 0x1322, VRCODE_DS, "Dose Calibration Factor", DD_DoseCalibrationFactor),
		new DcmDataDictionaryElement (0x0054, 0x1323, VRCODE_DS, "Scatter Fraction Factor", DD_ScatterFractionFactor),
		new DcmDataDictionaryElement (0x0054, 0x1324, VRCODE_DS, "Dead Time Factor", DD_DeadTimeFactor),
		new DcmDataDictionaryElement (0x0054, 0x1330, VRCODE_US, "Image Index", DD_ImageIndex),
		new DcmDataDictionaryElement (0x0054, 0x1400, VRCODE_CS, "Counts Included", DD_CountsIncluded),
		new DcmDataDictionaryElement (0x0054, 0x1401, VRCODE_CS, "Dead Time Correction Flag", DD_DeadTimeCorrectionFlag),
		new DcmDataDictionaryElement (0x0060, 0x3000, VRCODE_SQ, "Histogram Sequence", DD_HistogramSequence),
		new DcmDataDictionaryElement (0x0060, 0x3002, VRCODE_US, "Histogram Number of Bins", DD_HistogramNumberOfBins),
		new DcmDataDictionaryElement (0x0060, 0x3004, VRCODE_US_or_SS, "Histogram First Bin Value", DD_HistogramFirstBinValue),
		new DcmDataDictionaryElement (0x0060, 0x3006, VRCODE_US_or_SS, "Histogram Last Bin Value", DD_HistogramLastBinValue),
		new DcmDataDictionaryElement (0x0060, 0x3008, VRCODE_US, "Histogram Bin Width", DD_HistogramBinWidth),
		new DcmDataDictionaryElement (0x0060, 0x3010, VRCODE_LO, "Histogram Explanation", DD_HistogramExplanation),
		new DcmDataDictionaryElement (0x0060, 0x3020, VRCODE_UL, "Histogram Data", DD_HistogramData),
		new DcmDataDictionaryElement (0x0088, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_0088),
		new DcmDataDictionaryElement (0x0088, 0x0130, VRCODE_SH, "Storage Media File-set ID", DD_StorageMediaFilesetID),
		new DcmDataDictionaryElement (0x0088, 0x0140, VRCODE_UI, "Storage Media File-set UID", DD_StorageMediaFilesetUID),
		new DcmDataDictionaryElement (0x0088, 0x0200, VRCODE_SQ, "Icon Image Sequence", DD_IconImageSequence),
		new DcmDataDictionaryElement (0x0088, 0x0904, VRCODE_LO, "Topic Title", DD_TopicTitle),
		new DcmDataDictionaryElement (0x0088, 0x0906, VRCODE_ST, "Topic Subject", DD_TopicSubject),
		new DcmDataDictionaryElement (0x0088, 0x0910, VRCODE_LO, "Topic Author", DD_TopicAuthor),
		new DcmDataDictionaryElement (0x0088, 0x0912, VRCODE_LO, "Topic Key Words", DD_TopicKeyWords),
		new DcmDataDictionaryElement (0x2000, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2000),
		new DcmDataDictionaryElement (0x2000, 0x0010, VRCODE_IS, "Number of Copies", DD_NumberOfCopies),
		new DcmDataDictionaryElement (0x2000, 0x001E, VRCODE_SQ, "Printer Configuration Sequence", DD_PrinterConfigurationSequence),
		new DcmDataDictionaryElement (0x2000, 0x0020, VRCODE_CS, "Print Priority", DD_PrintPriority),
		new DcmDataDictionaryElement (0x2000, 0x0030, VRCODE_CS, "Medium Type", DD_MediumType),
		new DcmDataDictionaryElement (0x2000, 0x0040, VRCODE_CS, "Film Destination", DD_FilmDestination),
		new DcmDataDictionaryElement (0x2000, 0x0050, VRCODE_LO, "Film Session Label", DD_FilmSessionLabel),
		new DcmDataDictionaryElement (0x2000, 0x0060, VRCODE_IS, "Memory Allocation", DD_MemoryAllocation),
		new DcmDataDictionaryElement (0x2000, 0x0061, VRCODE_IS, "Maximum Memory Allocation", DD_MaximumMemoryAllocation),
		new DcmDataDictionaryElement (0x2000, 0x0062, VRCODE_CS, "Color Image Printing Flag", DD_ColorImagePrintingFlag),
		new DcmDataDictionaryElement (0x2000, 0x0063, VRCODE_CS, "Collation Flag", DD_CollationFlag),
		new DcmDataDictionaryElement (0x2000, 0x0065, VRCODE_CS, "Annotation Flag", DD_AnnotationFlag),
		new DcmDataDictionaryElement (0x2000, 0x0067, VRCODE_CS, "Image Overlay Flag", DD_ImageOverlayFlag),
		new DcmDataDictionaryElement (0x2000, 0x0069, VRCODE_CS, "Presentation LUT Flag", DD_PresentationLUTFlag),
		new DcmDataDictionaryElement (0x2000, 0x006A, VRCODE_CS, "Image Box Presentation LUT Flag", DD_ImageBoxPresentationLUTFlag),
		new DcmDataDictionaryElement (0x2000, 0x00A0, VRCODE_US, "Memory Bit Depth", DD_MemoryBitDepth),
		new DcmDataDictionaryElement (0x2000, 0x00A1, VRCODE_US, "Printing Bit Depth", DD_PrintingBitDepth),
		new DcmDataDictionaryElement (0x2000, 0x00A2, VRCODE_SQ, "Media Installed Sequence", DD_MediaInstalledSequence),
		new DcmDataDictionaryElement (0x2000, 0x00A4, VRCODE_SQ, "Other Media Available Sequence", DD_OtherMediaAvailableSequence),
		new DcmDataDictionaryElement (0x2000, 0x00A8, VRCODE_SQ, "Supported Image Display Formats Sequence", DD_SupportedImageDisplayFormatsSequence),
		new DcmDataDictionaryElement (0x2000, 0x0500, VRCODE_SQ, "Referenced Film Box Sequence", DD_ReferencedFilmBoxSequence),
		new DcmDataDictionaryElement (0x2000, 0x0510, VRCODE_SQ, "Referenced Stored Print Sequence", DD_ReferencedStoredPrintSequence),
		new DcmDataDictionaryElement (0x2010, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2010),
		new DcmDataDictionaryElement (0x2010, 0x0010, VRCODE_ST, "Image Display Format", DD_ImageDisplayFormat),
		new DcmDataDictionaryElement (0x2010, 0x0030, VRCODE_CS, "Annotation Display Format ID", DD_AnnotationDisplayFormatID),
		new DcmDataDictionaryElement (0x2010, 0x0040, VRCODE_CS, "Film Orientation", DD_FilmOrientation),
		new DcmDataDictionaryElement (0x2010, 0x0050, VRCODE_CS, "Film Size ID", DD_FilmSizeID),
		new DcmDataDictionaryElement (0x2010, 0x0052, VRCODE_CS, "Printer Resolution ID", DD_PrinterResolutionID),
		new DcmDataDictionaryElement (0x2010, 0x0054, VRCODE_CS, "Default Printer Resolution ID", DD_DefaultPrinterResolutionID),
		new DcmDataDictionaryElement (0x2010, 0x0060, VRCODE_CS, "Magnification Type", DD_MagnificationType),
		new DcmDataDictionaryElement (0x2010, 0x0080, VRCODE_CS, "Smoothing Type", DD_SmoothingType),
		new DcmDataDictionaryElement (0x2010, 0x00A6, VRCODE_CS, "Default Magnification Type", DD_DefaultMagnificationType),
		new DcmDataDictionaryElement (0x2010, 0x00A7, VRCODE_CS, "Other Magnification Types Available", DD_OtherMagnificationTypesAvailable),
		new DcmDataDictionaryElement (0x2010, 0x00A8, VRCODE_CS, "Default Smoothing Type", DD_DefaultSmoothingType),
		new DcmDataDictionaryElement (0x2010, 0x00A9, VRCODE_CS, "Other Smoothing Types Available", DD_OtherSmoothingTypesAvailable),
		new DcmDataDictionaryElement (0x2010, 0x0100, VRCODE_CS, "Border Density", DD_BorderDensity),
		new DcmDataDictionaryElement (0x2010, 0x0110, VRCODE_CS, "Empty Image Density", DD_EmptyImageDensity),
		new DcmDataDictionaryElement (0x2010, 0x0120, VRCODE_US, "Min Density", DD_MinDensity),
		new DcmDataDictionaryElement (0x2010, 0x0130, VRCODE_US, "Max Density", DD_MaxDensity),
		new DcmDataDictionaryElement (0x2010, 0x0140, VRCODE_CS, "Trim", DD_Trim),
		new DcmDataDictionaryElement (0x2010, 0x0150, VRCODE_ST, "Configuration Information", DD_ConfigurationInformation),
		new DcmDataDictionaryElement (0x2010, 0x0152, VRCODE_LT, "Configuration Information Description", DD_ConfigurationInformationDescription),
		new DcmDataDictionaryElement (0x2010, 0x0154, VRCODE_IS, "Maximum Collated Films", DD_MaximumCollatedFilms),
		new DcmDataDictionaryElement (0x2010, 0x015E, VRCODE_US, "Illumination", DD_Illumination),
		new DcmDataDictionaryElement (0x2010, 0x0160, VRCODE_US, "Reflected Ambient Light", DD_ReflectedAmbientLight),
		new DcmDataDictionaryElement (0x2010, 0x0376, VRCODE_DS, "Printer Pixel Spacing", DD_PrinterPixelSpacing),
		new DcmDataDictionaryElement (0x2010, 0x0500, VRCODE_SQ, "Referenced Film Session Sequence", DD_ReferencedFilmSessionSequence),
		new DcmDataDictionaryElement (0x2010, 0x0510, VRCODE_SQ, "Referenced Image Box Sequence", DD_ReferencedImageBoxSequence),
		new DcmDataDictionaryElement (0x2010, 0x0520, VRCODE_SQ, "Referenced Basic Annotation Box Sequence", DD_ReferencedBasicAnnotationBoxSequence),
		new DcmDataDictionaryElement (0x2020, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2020),
		new DcmDataDictionaryElement (0x2020, 0x0010, VRCODE_US, "Image Position", DD_ImagePosition_2020),
		new DcmDataDictionaryElement (0x2020, 0x0020, VRCODE_CS, "Polarity", DD_Polarity),
		new DcmDataDictionaryElement (0x2020, 0x0030, VRCODE_DS, "Requested Image Size", DD_RequestedImageSize),
		new DcmDataDictionaryElement (0x2020, 0x0040, VRCODE_CS, "Requested Decimate/Crop Behavior", DD_RequestedDecimateCropBehavior),
		new DcmDataDictionaryElement (0x2020, 0x0050, VRCODE_CS, "Requested Resolution ID", DD_RequestedResolutionID),
		new DcmDataDictionaryElement (0x2020, 0x00A0, VRCODE_CS, "Requested Image Size Flag", DD_RequestedImageSizeFlag),
		new DcmDataDictionaryElement (0x2020, 0x00A2, VRCODE_CS, "Decimate/Crop Result", DD_DecimateCropResult),
		new DcmDataDictionaryElement (0x2020, 0x0110, VRCODE_SQ, "Basic Grayscale Image Sequence", DD_BasicGrayscaleImageSequence),
		new DcmDataDictionaryElement (0x2020, 0x0111, VRCODE_SQ, "Basic Color Image Sequence", DD_BasicColorImageSequence),
		new DcmDataDictionaryElement (0x2020, 0x0130, VRCODE_SQ, "Referenced Image Overlay Box Sequence", DD_ReferencedImageOverlayBoxSequence),
		new DcmDataDictionaryElement (0x2020, 0x0140, VRCODE_SQ, "Referenced VOI LUT Box Sequence", DD_ReferencedVOILUTBoxSequence),
		new DcmDataDictionaryElement (0x2030, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2030),
		new DcmDataDictionaryElement (0x2030, 0x0010, VRCODE_US, "Annotation Position", DD_AnnotationPosition),
		new DcmDataDictionaryElement (0x2030, 0x0020, VRCODE_LO, "Text String", DD_TextString),
		new DcmDataDictionaryElement (0x2040, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2040),
		new DcmDataDictionaryElement (0x2040, 0x0010, VRCODE_SQ, "Referenced Overlay Plane Sequence", DD_ReferencedOverlayPlaneSequence),
		new DcmDataDictionaryElement (0x2040, 0x0011, VRCODE_US, "Referenced Overlay Plane Groups", DD_ReferencedOverlayPlaneGroups),
		new DcmDataDictionaryElement (0x2040, 0x0020, VRCODE_SQ, "Overlay Pixel Data Sequence", DD_OverlayPixelDataSequence),
		new DcmDataDictionaryElement (0x2040, 0x0060, VRCODE_CS, "Overlay Magnification Type", DD_OverlayMagnificationType),
		new DcmDataDictionaryElement (0x2040, 0x0070, VRCODE_CS, "Overlay Smoothing Type", DD_OverlaySmoothingType),
		new DcmDataDictionaryElement (0x2040, 0x0072, VRCODE_CS, "Overlay or Image Magnification", DD_OverlayOrImageMagnification),
		new DcmDataDictionaryElement (0x2040, 0x0074, VRCODE_US, "Magnify to Number of Columns", DD_MagnifyToNumberOfColumns),
		new DcmDataDictionaryElement (0x2040, 0x0080, VRCODE_CS, "Overlay Foreground Density", DD_OverlayForegroundDensity),
		new DcmDataDictionaryElement (0x2040, 0x0082, VRCODE_CS, "Overlay Background Density", DD_OverlayBackgroundDensity),
		new DcmDataDictionaryElement (0x2040, 0x0090, VRCODE_CS, "Overlay Mode", DD_OverlayMode),
		new DcmDataDictionaryElement (0x2040, 0x0100, VRCODE_CS, "Threshold Density", DD_ThresholdDensity),
		new DcmDataDictionaryElement (0x2040, 0x0500, VRCODE_SQ, "Referenced Image Box Sequence", DD_ReferencedImageBoxSequence_2040),
		new DcmDataDictionaryElement (0x2050, 0x0010, VRCODE_SQ, "Presentation LUT Sequence", DD_PresentationLUTSequence),
		new DcmDataDictionaryElement (0x2050, 0x0020, VRCODE_CS, "Presentation LUT Shape", DD_PresentationLUTShape),
		new DcmDataDictionaryElement (0x2050, 0x0500, VRCODE_SQ, "Referenced Presentation LUT Sequence", DD_ReferencedPresentationLUTSequence),
		new DcmDataDictionaryElement (0x2100, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2100),
		new DcmDataDictionaryElement (0x2100, 0x0010, VRCODE_SH, "Print Job ID", DD_PrintJobID),
		new DcmDataDictionaryElement (0x2100, 0x0020, VRCODE_CS, "Execution Status", DD_ExecutionStatus),
		new DcmDataDictionaryElement (0x2100, 0x0030, VRCODE_CS, "Execution Status Info", DD_ExecutionStatusInfo),
		new DcmDataDictionaryElement (0x2100, 0x0040, VRCODE_DA, "Creation Date", DD_CreationDate),
		new DcmDataDictionaryElement (0x2100, 0x0050, VRCODE_TM, "Creation Time", DD_CreationTime),
		new DcmDataDictionaryElement (0x2100, 0x0070, VRCODE_AE, "Originator", DD_Originator),
		new DcmDataDictionaryElement (0x2100, 0x0140, VRCODE_AE, "Destination", DD_Destination),
		new DcmDataDictionaryElement (0x2100, 0x0160, VRCODE_SH, "Owner ID", DD_OwnerID),
		new DcmDataDictionaryElement (0x2100, 0x0170, VRCODE_IS, "Number of Films", DD_NumberOfFilms),
		new DcmDataDictionaryElement (0x2100, 0x0500, VRCODE_SQ, "Referenced Print Job Sequence", DD_ReferencedPrintJobSequence),
		new DcmDataDictionaryElement (0x2110, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_2110),
		new DcmDataDictionaryElement (0x2110, 0x0010, VRCODE_CS, "Printer Status", DD_PrinterStatus),
		new DcmDataDictionaryElement (0x2110, 0x0020, VRCODE_CS, "Printer Status Info", DD_PrinterStatusInfo),
		new DcmDataDictionaryElement (0x2110, 0x0030, VRCODE_LO, "Printer Name", DD_PrinterName),
		new DcmDataDictionaryElement (0x2110, 0x0099, VRCODE_SH, "Print Queue ID", DD_PrintQueueID),
		new DcmDataDictionaryElement (0x2120, 0x0010, VRCODE_CS, "Queue Status", DD_QueueStatus),
		new DcmDataDictionaryElement (0x2120, 0x0050, VRCODE_SQ, "Print Job Description Sequence", DD_PrintJobDescriptionSequence),
		new DcmDataDictionaryElement (0x2120, 0x0070, VRCODE_SQ, "Referenced Print Job Sequence", DD_ReferencedPrintJobSequence_2120),
		new DcmDataDictionaryElement (0x2130, 0x0010, VRCODE_SQ, "Print Management Capabilities Sequence", DD_PrintManagementCapabilitiesSequence),
		new DcmDataDictionaryElement (0x2130, 0x0015, VRCODE_SQ, "Printer Characteristics Sequence", DD_PrinterCharacteristicsSequence),
		new DcmDataDictionaryElement (0x2130, 0x0030, VRCODE_SQ, "Film Box Content Sequence", DD_FilmBoxContentSequence),
		new DcmDataDictionaryElement (0x2130, 0x0040, VRCODE_SQ, "Image Box Content Sequence", DD_ImageBoxContentSequence),
		new DcmDataDictionaryElement (0x2130, 0x0050, VRCODE_SQ, "Annotation Content Sequence", DD_AnnotationContentSequence),
		new DcmDataDictionaryElement (0x2130, 0x0060, VRCODE_SQ, "Image Overlay Box Content Sequence", DD_ImageOverlayBoxContentSequence),
		new DcmDataDictionaryElement (0x2130, 0x0080, VRCODE_SQ, "Presentation LUT Content Sequence", DD_PresentationLUTContentSequence),
		new DcmDataDictionaryElement (0x2130, 0x00A0, VRCODE_SQ, "Proposed Study Sequence", DD_ProposedStudySequence),
		new DcmDataDictionaryElement (0x2130, 0x00C0, VRCODE_SQ, "Original Image Sequence", DD_OriginalImageSequence),
		new DcmDataDictionaryElement (0x3002, 0x0002, VRCODE_SH, "RT Image Label", DD_RTImageLabel),
		new DcmDataDictionaryElement (0x3002, 0x0003, VRCODE_LO, "RT Image Name", DD_RTImageName),
		new DcmDataDictionaryElement (0x3002, 0x0004, VRCODE_ST, "RT Image Description", DD_RTImageDescription),
		new DcmDataDictionaryElement (0x3002, 0x000A, VRCODE_CS, "Reported Values Origin", DD_ReportedValuesOrigin),
		new DcmDataDictionaryElement (0x3002, 0x000C, VRCODE_CS, "RT Image Plane", DD_RTImagePlane),
		new DcmDataDictionaryElement (0x3002, 0x000E, VRCODE_DS, "X-Ray Image Receptor Angle", DD_XRayImageReceptorAngle),
		new DcmDataDictionaryElement (0x3002, 0x0010, VRCODE_DS, "RT Image Orientation", DD_RTImageOrientation),
		new DcmDataDictionaryElement (0x3002, 0x0011, VRCODE_DS, "Image Plane Pixel Spacing", DD_ImagePlanePixelSpacing),
		new DcmDataDictionaryElement (0x3002, 0x0012, VRCODE_DS, "RT Image Position", DD_RTImagePosition),
		new DcmDataDictionaryElement (0x3002, 0x0020, VRCODE_SH, "Radiation Machine Name", DD_RadiationMachineName),
		new DcmDataDictionaryElement (0x3002, 0x0022, VRCODE_DS, "Radiation Machine SAD", DD_RadiationMachineSAD),
		new DcmDataDictionaryElement (0x3002, 0x0024, VRCODE_DS, "Radiation Machine SSD", DD_RadiationMachineSSD),
		new DcmDataDictionaryElement (0x3002, 0x0026, VRCODE_DS, "RT Image SID", DD_RTImageSID),
		new DcmDataDictionaryElement (0x3002, 0x0028, VRCODE_DS, "Source to Reference Object Distance", DD_SourceToReferenceObjectDistance),
		new DcmDataDictionaryElement (0x3002, 0x0029, VRCODE_IS, "Fraction Number", DD_FractionNumber),
		new DcmDataDictionaryElement (0x3002, 0x0030, VRCODE_SQ, "Exposure Sequence", DD_ExposureSequence),
		new DcmDataDictionaryElement (0x3002, 0x0032, VRCODE_DS, "Meterset Exposure", DD_MetersetExposure),
		new DcmDataDictionaryElement (0x3004, 0x0001, VRCODE_CS, "DVH Type", DD_DVHType),
		new DcmDataDictionaryElement (0x3004, 0x0002, VRCODE_CS, "Dose Units", DD_DoseUnits),
		new DcmDataDictionaryElement (0x3004, 0x0004, VRCODE_CS, "Dose Type", DD_DoseType),
		new DcmDataDictionaryElement (0x3004, 0x0006, VRCODE_LO, "Dose Comment", DD_DoseComment),
		new DcmDataDictionaryElement (0x3004, 0x0008, VRCODE_DS, "Normalization Point", DD_NormalizationPoint),
		new DcmDataDictionaryElement (0x3004, 0x000A, VRCODE_CS, "Dose Summation Type", DD_DoseSummationType),
		new DcmDataDictionaryElement (0x3004, 0x000C, VRCODE_DS, "Grid Frame Offset Vector", DD_GridFrameOffsetVector),
		new DcmDataDictionaryElement (0x3004, 0x000E, VRCODE_DS, "Dose Grid Scaling", DD_DoseGridScaling),
		new DcmDataDictionaryElement (0x3004, 0x0010, VRCODE_SQ, "RT Dose ROI Sequence", DD_RTDoseROISequence),
		new DcmDataDictionaryElement (0x3004, 0x0012, VRCODE_DS, "Dose Value", DD_DoseValue),
		new DcmDataDictionaryElement (0x3004, 0x0040, VRCODE_DS, "DVH Normalization Point", DD_DVHNormalizationPoint),
		new DcmDataDictionaryElement (0x3004, 0x0042, VRCODE_DS, "DVH Normalization Dose Value", DD_DVHNormalizationDoseValue),
		new DcmDataDictionaryElement (0x3004, 0x0050, VRCODE_SQ, "DVH Sequence", DD_DVHSequence),
		new DcmDataDictionaryElement (0x3004, 0x0052, VRCODE_DS, "DVH Dose Scaling", DD_DVHDoseScaling),
		new DcmDataDictionaryElement (0x3004, 0x0054, VRCODE_CS, "DVH Volume Units", DD_DVHVolumeUnits),
		new DcmDataDictionaryElement (0x3004, 0x0056, VRCODE_IS, "DVH Number of Bins", DD_DVHNumberOfBins),
		new DcmDataDictionaryElement (0x3004, 0x0058, VRCODE_DS, "DVH Data", DD_DVHData),
		new DcmDataDictionaryElement (0x3004, 0x0060, VRCODE_SQ, "DVH Referenced ROI Sequence", DD_DVHReferencedROISequence),
		new DcmDataDictionaryElement (0x3004, 0x0062, VRCODE_CS, "DVH ROI Contribution Type", DD_DVHROIContributionType),
		new DcmDataDictionaryElement (0x3004, 0x0070, VRCODE_DS, "DVH Minimum Dose", DD_DVHMinimumDose),
		new DcmDataDictionaryElement (0x3004, 0x0072, VRCODE_DS, "DVH Maximum Dose", DD_DVHMaximumDose),
		new DcmDataDictionaryElement (0x3004, 0x0074, VRCODE_DS, "DVH Mean Dose", DD_DVHMeanDose),
		new DcmDataDictionaryElement (0x3006, 0x0002, VRCODE_SH, "Structure Set Label", DD_StructureSetLabel),
		new DcmDataDictionaryElement (0x3006, 0x0004, VRCODE_LO, "Structure Set Name", DD_StructureSetName),
		new DcmDataDictionaryElement (0x3006, 0x0006, VRCODE_ST, "Structure Set Description", DD_StructureSetDescription),
		new DcmDataDictionaryElement (0x3006, 0x0008, VRCODE_DA, "Structure Set Date", DD_StructureSetDate),
		new DcmDataDictionaryElement (0x3006, 0x0009, VRCODE_TM, "Structure Set Time", DD_StructureSetTime),
		new DcmDataDictionaryElement (0x3006, 0x0010, VRCODE_SQ, "Referenced Frame of Reference Sequence", DD_ReferencedFrameOfReferenceSequence),
		new DcmDataDictionaryElement (0x3006, 0x0012, VRCODE_SQ, "RT Referenced Study Sequence", DD_RTReferencedStudySequence),
		new DcmDataDictionaryElement (0x3006, 0x0014, VRCODE_SQ, "RT Referenced Series Sequence", DD_RTReferencedSeriesSequence),
		new DcmDataDictionaryElement (0x3006, 0x0016, VRCODE_SQ, "Contour Image Sequence", DD_ContourImageSequence),
		new DcmDataDictionaryElement (0x3006, 0x0020, VRCODE_SQ, "Structure Set ROI Sequence", DD_StructureSetROISequence),
		new DcmDataDictionaryElement (0x3006, 0x0022, VRCODE_IS, "ROI Number", DD_ROINumber),
		new DcmDataDictionaryElement (0x3006, 0x0024, VRCODE_UI, "Referenced Frame of Reference UID", DD_ReferencedFrameOfReferenceUID),
		new DcmDataDictionaryElement (0x3006, 0x0026, VRCODE_LO, "ROI Name", DD_ROIName),
		new DcmDataDictionaryElement (0x3006, 0x0028, VRCODE_ST, "ROI Description", DD_ROIDescription),
		new DcmDataDictionaryElement (0x3006, 0x002A, VRCODE_IS, "ROI Display Color", DD_ROIDisplayColor),
		new DcmDataDictionaryElement (0x3006, 0x002C, VRCODE_DS, "ROI Volume", DD_ROIVolume),
		new DcmDataDictionaryElement (0x3006, 0x0030, VRCODE_SQ, "RT Related ROI Sequence", DD_RTRelatedROISequence),
		new DcmDataDictionaryElement (0x3006, 0x0033, VRCODE_CS, "RT ROI Relationship", DD_RTROIRelationship),
		new DcmDataDictionaryElement (0x3006, 0x0036, VRCODE_CS, "ROI Generation Algorithm", DD_ROIGenerationAlgorithm),
		new DcmDataDictionaryElement (0x3006, 0x0038, VRCODE_LO, "ROI Generation Description", DD_ROIGenerationDescription),
		new DcmDataDictionaryElement (0x3006, 0x0039, VRCODE_SQ, "ROI Contour Sequence", DD_ROIContourSequence),
		new DcmDataDictionaryElement (0x3006, 0x0040, VRCODE_SQ, "Contour Sequence", DD_ContourSequence),
		new DcmDataDictionaryElement (0x3006, 0x0042, VRCODE_CS, "Contour Geometric Type", DD_ContourGeometricType),
		new DcmDataDictionaryElement (0x3006, 0x0044, VRCODE_DS, "Contour Slab Thickness", DD_ContourSlabThickness),
		new DcmDataDictionaryElement (0x3006, 0x0045, VRCODE_DS, "Contour Offset Vector", DD_ContourOffsetVector),
		new DcmDataDictionaryElement (0x3006, 0x0046, VRCODE_IS, "Number of Contour Points", DD_NumberOfContourPoints),
		new DcmDataDictionaryElement (0x3006, 0x0050, VRCODE_DS, "Contour Data", DD_ContourData),
		new DcmDataDictionaryElement (0x3006, 0x0080, VRCODE_SQ, "RT ROI Observations Sequence", DD_RTROIObservationsSequence),
		new DcmDataDictionaryElement (0x3006, 0x0082, VRCODE_IS, "Observation Number", DD_ObservationNumber),
		new DcmDataDictionaryElement (0x3006, 0x0084, VRCODE_IS, "Referenced ROI Number", DD_ReferencedROINumber),
		new DcmDataDictionaryElement (0x3006, 0x0085, VRCODE_SH, "ROI Observation Label", DD_ROIObservationLabel),
		new DcmDataDictionaryElement (0x3006, 0x0086, VRCODE_SQ, "RT ROI Identification Code Sequence", DD_RTROIIdentificationCodeSequence),
		new DcmDataDictionaryElement (0x3006, 0x0088, VRCODE_ST, "ROI Observation Description", DD_ROIObservationDescription),
		new DcmDataDictionaryElement (0x3006, 0x00A0, VRCODE_SQ, "Related RT ROI Observations Sequence", DD_RelatedRTROIObservationsSequence),
		new DcmDataDictionaryElement (0x3006, 0x00A4, VRCODE_CS, "RT ROI Interpreted Type", DD_RTROIInterpretedType),
		new DcmDataDictionaryElement (0x3006, 0x00A6, VRCODE_PN, "ROI Interpreter", DD_ROIInterpreter),
		new DcmDataDictionaryElement (0x3006, 0x00B0, VRCODE_SQ, "ROI Physical Properties Sequence", DD_ROIPhysicalPropertiesSequence),
		new DcmDataDictionaryElement (0x3006, 0x00B2, VRCODE_CS, "ROI Physical Property", DD_ROIPhysicalProperty),
		new DcmDataDictionaryElement (0x3006, 0x00B4, VRCODE_DS, "ROI Physical Property Value", DD_ROIPhysicalPropertyValue),
		new DcmDataDictionaryElement (0x3006, 0x00C0, VRCODE_SQ, "Frame of Reference Relationship Sequence", DD_FrameOfReferenceRelationshipSequence),
		new DcmDataDictionaryElement (0x3006, 0x00C2, VRCODE_UI, "Related Frame of Reference UID", DD_RelatedFrameOfReferenceUID),
		new DcmDataDictionaryElement (0x3006, 0x00C4, VRCODE_CS, "Frame of Reference Transformation Type", DD_FrameOfReferenceTransformationType),
		new DcmDataDictionaryElement (0x3006, 0x00C6, VRCODE_DS, "Frame of Reference Transformation Matrix", DD_FrameOfReferenceTransformationMatrix),
		new DcmDataDictionaryElement (0x3006, 0x00C8, VRCODE_LO, "Frame of Reference Transformation Comment", DD_FrameOfReferenceTransformationComment),
		new DcmDataDictionaryElement (0x3008, 0x0010, VRCODE_SQ, "Measured Dose Reference Sequence", DD_MeasuredDoseReferenceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0012, VRCODE_ST, "Measured Dose Description", DD_MeasuredDoseDescription),
		new DcmDataDictionaryElement (0x3008, 0x0014, VRCODE_CS, "Measured Dose Type", DD_MeasuredDoseType),
		new DcmDataDictionaryElement (0x3008, 0x0016, VRCODE_DS, "Measured Dose Value", DD_MeasuredDoseValue),
		new DcmDataDictionaryElement (0x3008, 0x0020, VRCODE_SQ, "Treatment Session Beam Sequence", DD_TreatmentSessionBeamSequence),
		new DcmDataDictionaryElement (0x3008, 0x0022, VRCODE_IS, "Current Fraction Number", DD_CurrentFractionNumber),
		new DcmDataDictionaryElement (0x3008, 0x0024, VRCODE_DA, "Treatment Control Point Date", DD_TreatmentControlPointDate),
		new DcmDataDictionaryElement (0x3008, 0x0025, VRCODE_TM, "Treatment Control Point Time", DD_TreatmentControlPointTime),
		new DcmDataDictionaryElement (0x3008, 0x002A, VRCODE_CS, "Treatment Termination Status", DD_TreatmentTerminationStatus),
		new DcmDataDictionaryElement (0x3008, 0x002B, VRCODE_SH, "Treatment Termination Code", DD_TreatmentTerminationCode),
		new DcmDataDictionaryElement (0x3008, 0x002C, VRCODE_CS, "Treatment Verification Status", DD_TreatmentVerificationStatus),
		new DcmDataDictionaryElement (0x3008, 0x0030, VRCODE_SQ, "Referenced Treatment Record Sequence", DD_ReferencedTreatmentRecordSequence),
		new DcmDataDictionaryElement (0x3008, 0x0032, VRCODE_DS, "Specified Primary Meterset", DD_SpecifiedPrimaryMeterset),
		new DcmDataDictionaryElement (0x3008, 0x0033, VRCODE_DS, "Specified Secondary Meterset", DD_SpecifiedSecondaryMeterset),
		new DcmDataDictionaryElement (0x3008, 0x0036, VRCODE_DS, "Delivered Primary Meterset", DD_DeliveredPrimaryMeterset),
		new DcmDataDictionaryElement (0x3008, 0x0037, VRCODE_DS, "Delivered Secondary Meterset", DD_DeliveredSecondaryMeterset),
		new DcmDataDictionaryElement (0x3008, 0x003A, VRCODE_DS, "Specified Treatment Time", DD_SpecifiedTreatmentTime),
		new DcmDataDictionaryElement (0x3008, 0x003B, VRCODE_DS, "Delivered Treatment Time", DD_DeliveredTreatmentTime),
		new DcmDataDictionaryElement (0x3008, 0x0040, VRCODE_SQ, "Control Point Delivery Sequence", DD_ControlPointDeliverySequence),
		new DcmDataDictionaryElement (0x3008, 0x0042, VRCODE_DS, "Specified Meterset", DD_SpecifiedMeterset),
		new DcmDataDictionaryElement (0x3008, 0x0044, VRCODE_DS, "Delivered Meterset", DD_DeliveredMeterset),
		new DcmDataDictionaryElement (0x3008, 0x0048, VRCODE_DS, "Dose Rate Delivered", DD_DoseRateDelivered),
		new DcmDataDictionaryElement (0x3008, 0x0052, VRCODE_DS, "Cumulative Dose to Dose Reference", DD_CumulativeDoseToDoseReference),
		new DcmDataDictionaryElement (0x3008, 0x0054, VRCODE_DA, "First Treatment Date", DD_FirstTreatmentDate),
		new DcmDataDictionaryElement (0x3008, 0x0056, VRCODE_DA, "Most Recent Treatment Date", DD_MostRecentTreatmentDate),
		new DcmDataDictionaryElement (0x3008, 0x005A, VRCODE_IS, "Number of Fractions Delivered", DD_NumberOfFractionsDelivered),
		new DcmDataDictionaryElement (0x3008, 0x0060, VRCODE_SQ, "Override Sequence", DD_OverrideSequence),
		new DcmDataDictionaryElement (0x3008, 0x0062, VRCODE_AT, "Override Parameter Pointer", DD_OverrideParameterPointer),
		new DcmDataDictionaryElement (0x3008, 0x0064, VRCODE_IS, "Measured Dose Reference Number", DD_MeasuredDoseReferenceNumber),
		new DcmDataDictionaryElement (0x3008, 0x0066, VRCODE_ST, "Override Reason", DD_OverrideReason),
		new DcmDataDictionaryElement (0x3008, 0x0070, VRCODE_SQ, "Calculated Dose Reference Sequence", DD_CalculatedDoseReferenceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0072, VRCODE_IS, "Calculated Dose Reference Number", DD_CalculatedDoseReferenceNumber),
		new DcmDataDictionaryElement (0x3008, 0x0074, VRCODE_ST, "Calculated Dose Reference Description", DD_CalculatedDoseReferenceDescription),
		new DcmDataDictionaryElement (0x3008, 0x0076, VRCODE_DS, "Calculated Dose Reference Dose Value", DD_CalculatedDoseReferenceDoseValue),
		new DcmDataDictionaryElement (0x3008, 0x0078, VRCODE_DS, "Start Meterset", DD_StartMeterset),
		new DcmDataDictionaryElement (0x3008, 0x007A, VRCODE_DS, "End Meterset", DD_EndMeterset),
		new DcmDataDictionaryElement (0x3008, 0x0080, VRCODE_SQ, "Referenced Measured Dose Reference Sequence", DD_ReferencedMeasuredDoseReferenceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0082, VRCODE_IS, "Referenced Measured Dose Reference Number", DD_ReferencedMeasuredDoseReferenceNumber),
		new DcmDataDictionaryElement (0x3008, 0x0090, VRCODE_SQ, "Referenced Calculated Dose Reference Sequence", DD_ReferencedCalculatedDoseReferenceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0092, VRCODE_IS, "Referenced Calculated Dose Reference Number", DD_ReferencedCalculatedDoseReferenceNumber),
		new DcmDataDictionaryElement (0x3008, 0x00A0, VRCODE_SQ, "Beam Limiting Device Leaf Pairs Sequence", DD_BeamLimitingDeviceLeafPairsSequence),
		new DcmDataDictionaryElement (0x3008, 0x00B0, VRCODE_SQ, "Recorded Wedge Sequence", DD_RecordedWedgeSequence),
		new DcmDataDictionaryElement (0x3008, 0x00C0, VRCODE_SQ, "Recorded Compensator Sequence", DD_RecordedCompensatorSequence),
		new DcmDataDictionaryElement (0x3008, 0x00D0, VRCODE_SQ, "Recorded Block Sequence", DD_RecordedBlockSequence),
		new DcmDataDictionaryElement (0x3008, 0x00E0, VRCODE_SQ, "Treatment Summary Measured Dose Reference Sequence", DD_TreatmentSummaryMeasuredDoseReferenceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0100, VRCODE_SQ, "Recorded Source Sequence", DD_RecordedSourceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0105, VRCODE_LO, "Source Serial Number", DD_SourceSerialNumber),
		new DcmDataDictionaryElement (0x3008, 0x0110, VRCODE_SQ, "Treatment Session Application Setup Sequence", DD_TreatmentSessionApplicationSetupSequence),
		new DcmDataDictionaryElement (0x3008, 0x0116, VRCODE_CS, "Application Setup Check", DD_ApplicationSetupCheck),
		new DcmDataDictionaryElement (0x3008, 0x0120, VRCODE_SQ, "Recorded Brachy Accessory Device Sequence", DD_RecordedBrachyAccessoryDeviceSequence),
		new DcmDataDictionaryElement (0x3008, 0x0122, VRCODE_IS, "Referenced Brachy Accessory Device Number", DD_ReferencedBrachyAccessoryDeviceNumber),
		new DcmDataDictionaryElement (0x3008, 0x0130, VRCODE_SQ, "Recorded Channel Sequence", DD_RecordedChannelSequence),
		new DcmDataDictionaryElement (0x3008, 0x0132, VRCODE_DS, "Specified Channel Total Time", DD_SpecifiedChannelTotalTime),
		new DcmDataDictionaryElement (0x3008, 0x0134, VRCODE_DS, "Delivered Channel Total Time", DD_DeliveredChannelTotalTime),
		new DcmDataDictionaryElement (0x3008, 0x0136, VRCODE_IS, "Specified Number of Pulses", DD_SpecifiedNumberOfPulses),
		new DcmDataDictionaryElement (0x3008, 0x0138, VRCODE_IS, "Delivered Number of Pulses", DD_DeliveredNumberOfPulses),
		new DcmDataDictionaryElement (0x3008, 0x013A, VRCODE_DS, "Specified Pulse Repetition Interval", DD_SpecifiedPulseRepetitionInterval),
		new DcmDataDictionaryElement (0x3008, 0x013C, VRCODE_DS, "Delivered Pulse Repetition Interval", DD_DeliveredPulseRepetitionInterval),
		new DcmDataDictionaryElement (0x3008, 0x0140, VRCODE_SQ, "Recorded Source Applicator Sequence", DD_RecordedSourceApplicatorSequence),
		new DcmDataDictionaryElement (0x3008, 0x0142, VRCODE_IS, "Referenced Source Applicator Number", DD_ReferencedSourceApplicatorNumber),
		new DcmDataDictionaryElement (0x3008, 0x0150, VRCODE_SQ, "Recorded Channel Shield Sequence", DD_RecordedChannelShieldSequence),
		new DcmDataDictionaryElement (0x3008, 0x0152, VRCODE_IS, "Referenced Channel Shield Number", DD_ReferencedChannelShieldNumber),
		new DcmDataDictionaryElement (0x3008, 0x0160, VRCODE_SQ, "Brachy Control Point Delivered Sequence", DD_BrachyControlPointDeliveredSequence),
		new DcmDataDictionaryElement (0x3008, 0x0162, VRCODE_DA, "Safe Position Exit Date", DD_SafePositionExitDate),
		new DcmDataDictionaryElement (0x3008, 0x0164, VRCODE_TM, "Safe Position Exit Time", DD_SafePositionExitTime),
		new DcmDataDictionaryElement (0x3008, 0x0166, VRCODE_DA, "Safe Position Return Date", DD_SafePositionReturnDate),
		new DcmDataDictionaryElement (0x3008, 0x0168, VRCODE_TM, "Safe Position Return Time", DD_SafePositionReturnTime),
		new DcmDataDictionaryElement (0x3008, 0x0200, VRCODE_CS, "Current Treatment Status", DD_CurrentTreatmentStatus),
		new DcmDataDictionaryElement (0x3008, 0x0202, VRCODE_ST, "Treatment Status Comment", DD_TreatmentStatusComment),
		new DcmDataDictionaryElement (0x3008, 0x0220, VRCODE_SQ, "Fraction Group Summary Sequence", DD_FractionGroupSummarySequence),
		new DcmDataDictionaryElement (0x3008, 0x0223, VRCODE_IS, "Referenced Fraction Number", DD_ReferencedFractionNumber),
		new DcmDataDictionaryElement (0x3008, 0x0224, VRCODE_CS, "Fraction Group Type", DD_FractionGroupType),
		new DcmDataDictionaryElement (0x3008, 0x0230, VRCODE_CS, "Beam Stopper Position", DD_BeamStopperPosition),
		new DcmDataDictionaryElement (0x3008, 0x0240, VRCODE_SQ, "Fraction Status Summary Sequence", DD_FractionStatusSummarySequence),
		new DcmDataDictionaryElement (0x3008, 0x0250, VRCODE_DA, "Treatment Date", DD_TreatmentDate),
		new DcmDataDictionaryElement (0x3008, 0x0251, VRCODE_TM, "Treatment Time", DD_TreatmentTime),
		new DcmDataDictionaryElement (0x300A, 0x0002, VRCODE_SH, "RT Plan Label", DD_RTPlanLabel),
		new DcmDataDictionaryElement (0x300A, 0x0003, VRCODE_LO, "RT Plan Name", DD_RTPlanName),
		new DcmDataDictionaryElement (0x300A, 0x0004, VRCODE_ST, "RT Plan Description", DD_RTPlanDescription),
		new DcmDataDictionaryElement (0x300A, 0x0006, VRCODE_DA, "RT Plan Date", DD_RTPlanDate),
		new DcmDataDictionaryElement (0x300A, 0x0007, VRCODE_TM, "RT Plan Time", DD_RTPlanTime),
		new DcmDataDictionaryElement (0x300A, 0x0009, VRCODE_LO, "Treatment Protocols", DD_TreatmentProtocols),
		new DcmDataDictionaryElement (0x300A, 0x000A, VRCODE_CS, "Treatment Intent", DD_TreatmentIntent),
		new DcmDataDictionaryElement (0x300A, 0x000B, VRCODE_LO, "Treatment Sites", DD_TreatmentSites),
		new DcmDataDictionaryElement (0x300A, 0x000C, VRCODE_CS, "RT Plan Geometry", DD_RTPlanGeometry),
		new DcmDataDictionaryElement (0x300A, 0x000E, VRCODE_ST, "Prescription Description", DD_PrescriptionDescription),
		new DcmDataDictionaryElement (0x300A, 0x0010, VRCODE_SQ, "Dose Reference Sequence", DD_DoseReferenceSequence),
		new DcmDataDictionaryElement (0x300A, 0x0012, VRCODE_IS, "Dose Reference Number", DD_DoseReferenceNumber),
		new DcmDataDictionaryElement (0x300A, 0x0014, VRCODE_CS, "Dose Reference Structure Type", DD_DoseReferenceStructureType),
		new DcmDataDictionaryElement (0x300A, 0x0015, VRCODE_CS, "Nominal Beam Energy Unit", DD_NominalBeamEnergyUnit),
		new DcmDataDictionaryElement (0x300A, 0x0016, VRCODE_LO, "Dose Reference Description", DD_DoseReferenceDescription),
		new DcmDataDictionaryElement (0x300A, 0x0018, VRCODE_DS, "Dose Reference Point Coordinates", DD_DoseReferencePointCoordinates),
		new DcmDataDictionaryElement (0x300A, 0x001A, VRCODE_DS, "Nominal Prior Dose", DD_NominalPriorDose),
		new DcmDataDictionaryElement (0x300A, 0x0020, VRCODE_CS, "Dose Reference Type", DD_DoseReferenceType),
		new DcmDataDictionaryElement (0x300A, 0x0021, VRCODE_DS, "Constraint Weight", DD_ConstraintWeight),
		new DcmDataDictionaryElement (0x300A, 0x0022, VRCODE_DS, "Delivery Warning Dose", DD_DeliveryWarningDose),
		new DcmDataDictionaryElement (0x300A, 0x0023, VRCODE_DS, "Delivery Maximum Dose", DD_DeliveryMaximumDose),
		new DcmDataDictionaryElement (0x300A, 0x0025, VRCODE_DS, "Target Minimum Dose", DD_TargetMinimumDose),
		new DcmDataDictionaryElement (0x300A, 0x0026, VRCODE_DS, "Target Prescription Dose", DD_TargetPrescriptionDose),
		new DcmDataDictionaryElement (0x300A, 0x0027, VRCODE_DS, "Target Maximum Dose", DD_TargetMaximumDose),
		new DcmDataDictionaryElement (0x300A, 0x0028, VRCODE_DS, "Target Underdose Volume Fraction", DD_TargetUnderdoseVolumeFraction),
		new DcmDataDictionaryElement (0x300A, 0x002A, VRCODE_DS, "Organ at Risk Full-volume Dose", DD_OrganAtRiskFullvolumeDose),
		new DcmDataDictionaryElement (0x300A, 0x002B, VRCODE_DS, "Organ at Risk Limit Dose", DD_OrganAtRiskLimitDose),
		new DcmDataDictionaryElement (0x300A, 0x002C, VRCODE_DS, "Organ at Risk Maximum Dose", DD_OrganAtRiskMaximumDose),
		new DcmDataDictionaryElement (0x300A, 0x002D, VRCODE_DS, "Organ at Risk Overdose Volume Fraction", DD_OrganAtRiskOverdoseVolumeFraction),
		new DcmDataDictionaryElement (0x300A, 0x0040, VRCODE_SQ, "Tolerance Table Sequence", DD_ToleranceTableSequence),
		new DcmDataDictionaryElement (0x300A, 0x0042, VRCODE_IS, "Tolerance Table Number", DD_ToleranceTableNumber),
		new DcmDataDictionaryElement (0x300A, 0x0043, VRCODE_SH, "Tolerance Table Label", DD_ToleranceTableLabel),
		new DcmDataDictionaryElement (0x300A, 0x0044, VRCODE_DS, "Gantry Angle Tolerance", DD_GantryAngleTolerance),
		new DcmDataDictionaryElement (0x300A, 0x0046, VRCODE_DS, "Beam Limiting Device Angle Tolerance", DD_BeamLimitingDeviceAngleTolerance),
		new DcmDataDictionaryElement (0x300A, 0x0048, VRCODE_SQ, "Beam Limiting Device Tolerance Sequence", DD_BeamLimitingDeviceToleranceSequence),
		new DcmDataDictionaryElement (0x300A, 0x004A, VRCODE_DS, "Beam Limiting Device Position Tolerance", DD_BeamLimitingDevicePositionTolerance),
		new DcmDataDictionaryElement (0x300A, 0x004C, VRCODE_DS, "Patient Support Angle Tolerance", DD_PatientSupportAngleTolerance),
		new DcmDataDictionaryElement (0x300A, 0x004E, VRCODE_DS, "Table Top Eccentric Angle Tolerance", DD_TableTopEccentricAngleTolerance),
		new DcmDataDictionaryElement (0x300A, 0x0051, VRCODE_DS, "Table Top Vertical Position Tolerance", DD_TableTopVerticalPositionTolerance),
		new DcmDataDictionaryElement (0x300A, 0x0052, VRCODE_DS, "Table Top Longitudinal Position Tolerance", DD_TableTopLongitudinalPositionTolerance),
		new DcmDataDictionaryElement (0x300A, 0x0053, VRCODE_DS, "Table Top Lateral Position Tolerance", DD_TableTopLateralPositionTolerance),
		new DcmDataDictionaryElement (0x300A, 0x0055, VRCODE_CS, "RT Plan Relationship", DD_RTPlanRelationship),
		new DcmDataDictionaryElement (0x300A, 0x0070, VRCODE_SQ, "Fraction Group Sequence", DD_FractionGroupSequence),
		new DcmDataDictionaryElement (0x300A, 0x0071, VRCODE_IS, "Fraction Group Number", DD_FractionGroupNumber),
		new DcmDataDictionaryElement (0x300A, 0x0078, VRCODE_IS, "Number of Fractions Planned", DD_NumberOfFractionsPlanned),
		new DcmDataDictionaryElement (0x300A, 0x0079, VRCODE_IS, "Number of Fractions Per Day", DD_NumberOfFractionsPerDay),
		new DcmDataDictionaryElement (0x300A, 0x007A, VRCODE_IS, "Repeat Fraction Cycle Length", DD_RepeatFractionCycleLength),
		new DcmDataDictionaryElement (0x300A, 0x007B, VRCODE_LT, "Fraction Pattern", DD_FractionPattern),
		new DcmDataDictionaryElement (0x300A, 0x0080, VRCODE_IS, "Number of Beams", DD_NumberOfBeams),
		new DcmDataDictionaryElement (0x300A, 0x0082, VRCODE_DS, "Beam Dose Specification Point", DD_BeamDoseSpecificationPoint),
		new DcmDataDictionaryElement (0x300A, 0x0084, VRCODE_DS, "Beam Dose", DD_BeamDose_300A),
		new DcmDataDictionaryElement (0x300A, 0x0086, VRCODE_DS, "Beam Meterset", DD_BeamMeterset),
		new DcmDataDictionaryElement (0x300A, 0x00A0, VRCODE_IS, "Number of Brachy Application Setups", DD_NumberOfBrachyApplicationSetups),
		new DcmDataDictionaryElement (0x300A, 0x00A2, VRCODE_DS, "Brachy Application Setup Dose Specification Point", DD_BrachyApplicationSetupDoseSpecificationPoint),
		new DcmDataDictionaryElement (0x300A, 0x00A4, VRCODE_DS, "Brachy Application Setup Dose", DD_BrachyApplicationSetupDose_300A),
		new DcmDataDictionaryElement (0x300A, 0x00B0, VRCODE_SQ, "Beam Sequence", DD_BeamSequence),
		new DcmDataDictionaryElement (0x300A, 0x00B2, VRCODE_SH, "Treatment Machine Name", DD_TreatmentMachineName),
		new DcmDataDictionaryElement (0x300A, 0x00B3, VRCODE_CS, "Primary Dosimeter Unit", DD_PrimaryDosimeterUnit),
		new DcmDataDictionaryElement (0x300A, 0x00B4, VRCODE_DS, "Source-Axis Distance", DD_SourceAxisDistance),
		new DcmDataDictionaryElement (0x300A, 0x00B6, VRCODE_SQ, "Beam Limiting Device Sequence", DD_BeamLimitingDeviceSequence),
		new DcmDataDictionaryElement (0x300A, 0x00B8, VRCODE_CS, "RT Beam Limiting Device Type", DD_RTBeamLimitingDeviceType),
		new DcmDataDictionaryElement (0x300A, 0x00BA, VRCODE_DS, "Source to Beam Limiting Device Distance", DD_SourceToBeamLimitingDeviceDistance),
		new DcmDataDictionaryElement (0x300A, 0x00BC, VRCODE_IS, "Number of Leaf/Jaw Pairs", DD_NumberOfLeafJawPairs),
		new DcmDataDictionaryElement (0x300A, 0x00BE, VRCODE_DS, "Leaf Position Boundaries", DD_LeafPositionBoundaries),
		new DcmDataDictionaryElement (0x300A, 0x00C0, VRCODE_IS, "Beam Number", DD_BeamNumber),
		new DcmDataDictionaryElement (0x300A, 0x00C2, VRCODE_LO, "Beam Name", DD_BeamName),
		new DcmDataDictionaryElement (0x300A, 0x00C3, VRCODE_ST, "Beam Description", DD_BeamDescription),
		new DcmDataDictionaryElement (0x300A, 0x00C4, VRCODE_CS, "Beam Type", DD_BeamType),
		new DcmDataDictionaryElement (0x300A, 0x00C6, VRCODE_CS, "Radiation Type", DD_RadiationType),
		new DcmDataDictionaryElement (0x300A, 0x00C8, VRCODE_IS, "Reference Image Number", DD_ReferenceImageNumber),
		new DcmDataDictionaryElement (0x300A, 0x00CA, VRCODE_SQ, "Planned Verification Image Sequence", DD_PlannedVerificationImageSequence),
		new DcmDataDictionaryElement (0x300A, 0x00CC, VRCODE_LO, "Imaging Device-Specific Acquisition Parameters", DD_ImagingDeviceSpecificAcquisitionParameters),
		new DcmDataDictionaryElement (0x300A, 0x00CE, VRCODE_CS, "Treatment Delivery Type", DD_TreatmentDeliveryType),
		new DcmDataDictionaryElement (0x300A, 0x00D0, VRCODE_IS, "Number of Wedges", DD_NumberOfWedges),
		new DcmDataDictionaryElement (0x300A, 0x00D1, VRCODE_SQ, "Wedge Sequence", DD_WedgeSequence),
		new DcmDataDictionaryElement (0x300A, 0x00D2, VRCODE_IS, "Wedge Number", DD_WedgeNumber),
		new DcmDataDictionaryElement (0x300A, 0x00D3, VRCODE_CS, "Wedge Type", DD_WedgeType),
		new DcmDataDictionaryElement (0x300A, 0x00D4, VRCODE_SH, "Wedge ID", DD_WedgeID),
		new DcmDataDictionaryElement (0x300A, 0x00D5, VRCODE_IS, "Wedge Angle", DD_WedgeAngle),
		new DcmDataDictionaryElement (0x300A, 0x00D6, VRCODE_DS, "Wedge Factor", DD_WedgeFactor),
		new DcmDataDictionaryElement (0x300A, 0x00D8, VRCODE_DS, "Wedge Orientation", DD_WedgeOrientation),
		new DcmDataDictionaryElement (0x300A, 0x00DA, VRCODE_DS, "Source to Wedge Tray Distance", DD_SourceToWedgeTrayDistance),
		new DcmDataDictionaryElement (0x300A, 0x00E0, VRCODE_IS, "Number of Compensators", DD_NumberOfCompensators),
		new DcmDataDictionaryElement (0x300A, 0x00E1, VRCODE_SH, "Material ID", DD_MaterialID),
		new DcmDataDictionaryElement (0x300A, 0x00E2, VRCODE_DS, "Total Compensator Tray Factor", DD_TotalCompensatorTrayFactor),
		new DcmDataDictionaryElement (0x300A, 0x00E3, VRCODE_SQ, "Compensator Sequence", DD_CompensatorSequence),
		new DcmDataDictionaryElement (0x300A, 0x00E4, VRCODE_IS, "Compensator Number", DD_CompensatorNumber),
		new DcmDataDictionaryElement (0x300A, 0x00E5, VRCODE_SH, "Compensator ID", DD_CompensatorID),
		new DcmDataDictionaryElement (0x300A, 0x00E6, VRCODE_DS, "Source to Compensator Tray Distance", DD_SourceToCompensatorTrayDistance),
		new DcmDataDictionaryElement (0x300A, 0x00E7, VRCODE_IS, "Compensator Rows", DD_CompensatorRows),
		new DcmDataDictionaryElement (0x300A, 0x00E8, VRCODE_IS, "Compensator Columns", DD_CompensatorColumns),
		new DcmDataDictionaryElement (0x300A, 0x00E9, VRCODE_DS, "Compensator Pixel Spacing", DD_CompensatorPixelSpacing),
		new DcmDataDictionaryElement (0x300A, 0x00EA, VRCODE_DS, "Compensator Position", DD_CompensatorPosition),
		new DcmDataDictionaryElement (0x300A, 0x00EB, VRCODE_DS, "Compensator Transmission Data", DD_CompensatorTransmissionData),
		new DcmDataDictionaryElement (0x300A, 0x00EC, VRCODE_DS, "Compensator Thickness Data", DD_CompensatorThicknessData),
		new DcmDataDictionaryElement (0x300A, 0x00ED, VRCODE_IS, "Number of Boli", DD_NumberOfBoli),
		new DcmDataDictionaryElement (0x300A, 0x00EE, VRCODE_CS, "Compensator Type", DD_CompensatorType),
		new DcmDataDictionaryElement (0x300A, 0x00F0, VRCODE_IS, "Number of Blocks", DD_NumberOfBlocks),
		new DcmDataDictionaryElement (0x300A, 0x00F2, VRCODE_DS, "Total Block Tray Factor", DD_TotalBlockTrayFactor),
		new DcmDataDictionaryElement (0x300A, 0x00F4, VRCODE_SQ, "Block Sequence", DD_BlockSequence),
		new DcmDataDictionaryElement (0x300A, 0x00F5, VRCODE_SH, "Block Tray ID", DD_BlockTrayID),
		new DcmDataDictionaryElement (0x300A, 0x00F6, VRCODE_DS, "Source to Block Tray Distance", DD_SourceToBlockTrayDistance),
		new DcmDataDictionaryElement (0x300A, 0x00F8, VRCODE_CS, "Block Type", DD_BlockType),
		new DcmDataDictionaryElement (0x300A, 0x00FA, VRCODE_CS, "Block Divergence", DD_BlockDivergence),
		new DcmDataDictionaryElement (0x300A, 0x00FC, VRCODE_IS, "Block Number", DD_BlockNumber),
		new DcmDataDictionaryElement (0x300A, 0x00FE, VRCODE_LO, "Block Name", DD_BlockName),
		new DcmDataDictionaryElement (0x300A, 0x0100, VRCODE_DS, "Block Thickness", DD_BlockThickness),
		new DcmDataDictionaryElement (0x300A, 0x0102, VRCODE_DS, "Block Transmission", DD_BlockTransmission),
		new DcmDataDictionaryElement (0x300A, 0x0104, VRCODE_IS, "Block Number of Points", DD_BlockNumberOfPoints),
		new DcmDataDictionaryElement (0x300A, 0x0106, VRCODE_DS, "Block Data", DD_BlockData),
		new DcmDataDictionaryElement (0x300A, 0x0107, VRCODE_SQ, "Applicator Sequence", DD_ApplicatorSequence),
		new DcmDataDictionaryElement (0x300A, 0x0108, VRCODE_SH, "Applicator ID", DD_ApplicatorID),
		new DcmDataDictionaryElement (0x300A, 0x0109, VRCODE_CS, "Applicator Type", DD_ApplicatorType),
		new DcmDataDictionaryElement (0x300A, 0x010A, VRCODE_LO, "Applicator Description", DD_ApplicatorDescription),
		new DcmDataDictionaryElement (0x300A, 0x010C, VRCODE_DS, "Cumulative Dose Reference Coefficient", DD_CumulativeDoseReferenceCoefficient),
		new DcmDataDictionaryElement (0x300A, 0x010E, VRCODE_DS, "Final Cumulative Meterset Weight", DD_FinalCumulativeMetersetWeight),
		new DcmDataDictionaryElement (0x300A, 0x0110, VRCODE_IS, "Number of Control Points", DD_NumberOfControlPoints),
		new DcmDataDictionaryElement (0x300A, 0x0111, VRCODE_SQ, "Control Point Sequence", DD_ControlPointSequence),
		new DcmDataDictionaryElement (0x300A, 0x0112, VRCODE_IS, "Control Point Index", DD_ControlPointIndex),
		new DcmDataDictionaryElement (0x300A, 0x0114, VRCODE_DS, "Nominal Beam Energy", DD_NominalBeamEnergy_300A),
		new DcmDataDictionaryElement (0x300A, 0x0115, VRCODE_DS, "Dose Rate Set", DD_DoseRateSet),
		new DcmDataDictionaryElement (0x300A, 0x0116, VRCODE_SQ, "Wedge Position Sequence", DD_WedgePositionSequence),
		new DcmDataDictionaryElement (0x300A, 0x0118, VRCODE_CS, "Wedge Position", DD_WedgePosition_300A),
		new DcmDataDictionaryElement (0x300A, 0x011A, VRCODE_SQ, "Beam Limiting Device Position Sequence", DD_BeamLimitingDevicePositionSequence),
		new DcmDataDictionaryElement (0x300A, 0x011C, VRCODE_DS, "Leaf/Jaw Positions", DD_LeafJawPositions),
		new DcmDataDictionaryElement (0x300A, 0x011E, VRCODE_DS, "Gantry Angle", DD_GantryAngle_300A),
		new DcmDataDictionaryElement (0x300A, 0x011F, VRCODE_CS, "Gantry Rotation Direction", DD_GantryRotationDirection),
		new DcmDataDictionaryElement (0x300A, 0x0120, VRCODE_DS, "Beam Limiting Device Angle", DD_BeamLimitingDeviceAngle_300A),
		new DcmDataDictionaryElement (0x300A, 0x0121, VRCODE_CS, "Beam Limiting Device Rotation Direction", DD_BeamLimitingDeviceRotationDirection),
		new DcmDataDictionaryElement (0x300A, 0x0122, VRCODE_DS, "Patient Support Angle", DD_PatientSupportAngle_300A),
		new DcmDataDictionaryElement (0x300A, 0x0123, VRCODE_CS, "Patient Support Rotation Direction", DD_PatientSupportRotationDirection),
		new DcmDataDictionaryElement (0x300A, 0x0124, VRCODE_DS, "Table Top Eccentric Axis Distance", DD_TableTopEccentricAxisDistance),
		new DcmDataDictionaryElement (0x300A, 0x0125, VRCODE_DS, "Table Top Eccentric Angle", DD_TableTopEccentricAngle_300A),
		new DcmDataDictionaryElement (0x300A, 0x0126, VRCODE_CS, "Table Top Eccentric Rotation Direction", DD_TableTopEccentricRotationDirection),
		new DcmDataDictionaryElement (0x300A, 0x0128, VRCODE_DS, "Table Top Vertical Position", DD_TableTopVerticalPosition_300A),
		new DcmDataDictionaryElement (0x300A, 0x0129, VRCODE_DS, "Table Top Longitudinal Position", DD_TableTopLongitudinalPosition_300A),
		new DcmDataDictionaryElement (0x300A, 0x012A, VRCODE_DS, "Table Top Lateral Position", DD_TableTopLateralPosition_300A),
		new DcmDataDictionaryElement (0x300A, 0x012C, VRCODE_DS, "Isocenter Position", DD_IsocenterPosition),
		new DcmDataDictionaryElement (0x300A, 0x012E, VRCODE_DS, "Surface Entry Point", DD_SurfaceEntryPoint),
		new DcmDataDictionaryElement (0x300A, 0x0130, VRCODE_DS, "Source to Surface Distance", DD_SourceToSurfaceDistance),
		new DcmDataDictionaryElement (0x300A, 0x0134, VRCODE_DS, "Cumulative Meterset Weight", DD_CumulativeMetersetWeight),
		new DcmDataDictionaryElement (0x300A, 0x0180, VRCODE_SQ, "Patient Setup Sequence", DD_PatientSetupSequence),
		new DcmDataDictionaryElement (0x300A, 0x0182, VRCODE_IS, "Patient Setup Number", DD_PatientSetupNumber),
		new DcmDataDictionaryElement (0x300A, 0x0184, VRCODE_LO, "Patient Additional Position", DD_PatientAdditionalPosition),
		new DcmDataDictionaryElement (0x300A, 0x0190, VRCODE_SQ, "Fixation Device Sequence", DD_FixationDeviceSequence),
		new DcmDataDictionaryElement (0x300A, 0x0192, VRCODE_CS, "Fixation Device Type", DD_FixationDeviceType),
		new DcmDataDictionaryElement (0x300A, 0x0194, VRCODE_SH, "Fixation Device Label", DD_FixationDeviceLabel),
		new DcmDataDictionaryElement (0x300A, 0x0196, VRCODE_ST, "Fixation Device Description", DD_FixationDeviceDescription),
		new DcmDataDictionaryElement (0x300A, 0x0198, VRCODE_SH, "Fixation Device Position", DD_FixationDevicePosition),
		new DcmDataDictionaryElement (0x300A, 0x01A0, VRCODE_SQ, "Shielding Device Sequence", DD_ShieldingDeviceSequence),
		new DcmDataDictionaryElement (0x300A, 0x01A2, VRCODE_CS, "Shielding Device Type", DD_ShieldingDeviceType),
		new DcmDataDictionaryElement (0x300A, 0x01A4, VRCODE_SH, "Shielding Device Label", DD_ShieldingDeviceLabel),
		new DcmDataDictionaryElement (0x300A, 0x01A6, VRCODE_ST, "Shielding Device Description", DD_ShieldingDeviceDescription),
		new DcmDataDictionaryElement (0x300A, 0x01A8, VRCODE_SH, "Shielding Device Position", DD_ShieldingDevicePosition),
		new DcmDataDictionaryElement (0x300A, 0x01B0, VRCODE_CS, "Setup Technique", DD_SetupTechnique),
		new DcmDataDictionaryElement (0x300A, 0x01B2, VRCODE_ST, "Setup Technique Description", DD_SetupTechniqueDescription),
		new DcmDataDictionaryElement (0x300A, 0x01B4, VRCODE_SQ, "Setup Device Sequence", DD_SetupDeviceSequence),
		new DcmDataDictionaryElement (0x300A, 0x01B6, VRCODE_CS, "Setup Device Type", DD_SetupDeviceType),
		new DcmDataDictionaryElement (0x300A, 0x01B8, VRCODE_SH, "Setup Device Label", DD_SetupDeviceLabel),
		new DcmDataDictionaryElement (0x300A, 0x01BA, VRCODE_ST, "Setup Device Description", DD_SetupDeviceDescription),
		new DcmDataDictionaryElement (0x300A, 0x01BC, VRCODE_DS, "Setup Device Parameter", DD_SetupDeviceParameter),
		new DcmDataDictionaryElement (0x300A, 0x01D0, VRCODE_ST, "Setup Reference Description", DD_SetupReferenceDescription),
		new DcmDataDictionaryElement (0x300A, 0x01D2, VRCODE_DS, "Table Top Vertical Setup Displacement", DD_TableTopVerticalSetupDisplacement),
		new DcmDataDictionaryElement (0x300A, 0x01D4, VRCODE_DS, "Table Top Longitudinal Setup Displacement", DD_TableTopLongitudinalSetupDisplacement),
		new DcmDataDictionaryElement (0x300A, 0x01D6, VRCODE_DS, "Table Top Lateral Setup Displacement", DD_TableTopLateralSetupDisplacement),
		new DcmDataDictionaryElement (0x300A, 0x0200, VRCODE_CS, "Brachy Treatment Technique", DD_BrachyTreatmentTechnique),
		new DcmDataDictionaryElement (0x300A, 0x0202, VRCODE_CS, "Brachy Treatment Type", DD_BrachyTreatmentType),
		new DcmDataDictionaryElement (0x300A, 0x0206, VRCODE_SQ, "Treatment Machine Sequence", DD_TreatmentMachineSequence),
		new DcmDataDictionaryElement (0x300A, 0x0210, VRCODE_SQ, "Source Sequence", DD_SourceSequence),
		new DcmDataDictionaryElement (0x300A, 0x0212, VRCODE_IS, "Source Number", DD_SourceNumber),
		new DcmDataDictionaryElement (0x300A, 0x0214, VRCODE_CS, "Source Type", DD_SourceType),
		new DcmDataDictionaryElement (0x300A, 0x0216, VRCODE_LO, "Source Manufacturer", DD_SourceManufacturer),
		new DcmDataDictionaryElement (0x300A, 0x0218, VRCODE_DS, "Active Source Diameter", DD_ActiveSourceDiameter),
		new DcmDataDictionaryElement (0x300A, 0x021A, VRCODE_DS, "Active Source Length", DD_ActiveSourceLength),
		new DcmDataDictionaryElement (0x300A, 0x0222, VRCODE_DS, "Source Encapsulation Nominal Thickness", DD_SourceEncapsulationNominalThickness),
		new DcmDataDictionaryElement (0x300A, 0x0224, VRCODE_DS, "Source Encapsulation Nominal Transmission", DD_SourceEncapsulationNominalTransmission),
		new DcmDataDictionaryElement (0x300A, 0x0226, VRCODE_LO, "Source Isotope Name", DD_SourceIsotopeName),
		new DcmDataDictionaryElement (0x300A, 0x0228, VRCODE_DS, "Source Isotope Half Life", DD_SourceIsotopeHalfLife),
		new DcmDataDictionaryElement (0x300A, 0x022A, VRCODE_DS, "Reference Air Kerma Rate", DD_ReferenceAirKermaRate),
		new DcmDataDictionaryElement (0x300A, 0x022C, VRCODE_DA, "Air Kerma Rate Reference Date", DD_AirKermaRateReferenceDate),
		new DcmDataDictionaryElement (0x300A, 0x022E, VRCODE_TM, "Air Kerma Rate Reference Time", DD_AirKermaRateReferenceTime),
		new DcmDataDictionaryElement (0x300A, 0x0230, VRCODE_SQ, "Application Setup Sequence", DD_ApplicationSetupSequence),
		new DcmDataDictionaryElement (0x300A, 0x0232, VRCODE_CS, "Application Setup Type", DD_ApplicationSetupType),
		new DcmDataDictionaryElement (0x300A, 0x0234, VRCODE_IS, "Application Setup Number", DD_ApplicationSetupNumber),
		new DcmDataDictionaryElement (0x300A, 0x0236, VRCODE_LO, "Application Setup Name", DD_ApplicationSetupName),
		new DcmDataDictionaryElement (0x300A, 0x0238, VRCODE_LO, "Application Setup Manufacturer", DD_ApplicationSetupManufacturer),
		new DcmDataDictionaryElement (0x300A, 0x0240, VRCODE_IS, "Template Number", DD_TemplateNumber),
		new DcmDataDictionaryElement (0x300A, 0x0242, VRCODE_SH, "Template Type", DD_TemplateType),
		new DcmDataDictionaryElement (0x300A, 0x0244, VRCODE_LO, "Template Name", DD_TemplateName),
		new DcmDataDictionaryElement (0x300A, 0x0250, VRCODE_DS, "Total Reference Air Kerma", DD_TotalReferenceAirKerma),
		new DcmDataDictionaryElement (0x300A, 0x0260, VRCODE_SQ, "Brachy Accessory Device Sequence", DD_BrachyAccessoryDeviceSequence),
		new DcmDataDictionaryElement (0x300A, 0x0262, VRCODE_IS, "Brachy Accessory Device Number", DD_BrachyAccessoryDeviceNumber),
		new DcmDataDictionaryElement (0x300A, 0x0263, VRCODE_SH, "Brachy Accessory Device ID", DD_BrachyAccessoryDeviceID),
		new DcmDataDictionaryElement (0x300A, 0x0264, VRCODE_CS, "Brachy Accessory Device Type", DD_BrachyAccessoryDeviceType),
		new DcmDataDictionaryElement (0x300A, 0x0266, VRCODE_LO, "Brachy Accessory Device Name", DD_BrachyAccessoryDeviceName),
		new DcmDataDictionaryElement (0x300A, 0x026A, VRCODE_DS, "Brachy Accessory Device Nominal Thickness", DD_BrachyAccessoryDeviceNominalThickness),
		new DcmDataDictionaryElement (0x300A, 0x026C, VRCODE_DS, "Brachy Accessory Device Nominal Transmission", DD_BrachyAccessoryDeviceNominalTransmission),
		new DcmDataDictionaryElement (0x300A, 0x0280, VRCODE_SQ, "Channel Sequence", DD_ChannelSequence),
		new DcmDataDictionaryElement (0x300A, 0x0282, VRCODE_IS, "Channel Number", DD_ChannelNumber),
		new DcmDataDictionaryElement (0x300A, 0x0284, VRCODE_DS, "Channel Length", DD_ChannelLength),
		new DcmDataDictionaryElement (0x300A, 0x0286, VRCODE_DS, "Channel Total Time", DD_ChannelTotalTime),
		new DcmDataDictionaryElement (0x300A, 0x0288, VRCODE_CS, "Source Movement Type", DD_SourceMovementType),
		new DcmDataDictionaryElement (0x300A, 0x028A, VRCODE_IS, "Number of Pulses", DD_NumberOfPulses),
		new DcmDataDictionaryElement (0x300A, 0x028C, VRCODE_DS, "Pulse Repetition Interval", DD_PulseRepetitionInterval),
		new DcmDataDictionaryElement (0x300A, 0x0290, VRCODE_IS, "Source Applicator Number", DD_SourceApplicatorNumber),
		new DcmDataDictionaryElement (0x300A, 0x0291, VRCODE_SH, "Source Applicator ID", DD_SourceApplicatorID),
		new DcmDataDictionaryElement (0x300A, 0x0292, VRCODE_CS, "Source Applicator Type", DD_SourceApplicatorType),
		new DcmDataDictionaryElement (0x300A, 0x0294, VRCODE_LO, "Source Applicator Name", DD_SourceApplicatorName),
		new DcmDataDictionaryElement (0x300A, 0x0296, VRCODE_DS, "Source Applicator Length", DD_SourceApplicatorLength),
		new DcmDataDictionaryElement (0x300A, 0x0298, VRCODE_LO, "Source Applicator Manufacturer", DD_SourceApplicatorManufacturer),
		new DcmDataDictionaryElement (0x300A, 0x029C, VRCODE_DS, "Source Applicator Wall Nominal Thickness", DD_SourceApplicatorWallNominalThickness),
		new DcmDataDictionaryElement (0x300A, 0x029E, VRCODE_DS, "Source Applicator Wall Nominal Transmission", DD_SourceApplicatorWallNominalTransmission),
		new DcmDataDictionaryElement (0x300A, 0x02A0, VRCODE_DS, "Source Applicator Step Size", DD_SourceApplicatorStepSize),
		new DcmDataDictionaryElement (0x300A, 0x02A2, VRCODE_IS, "Transfer Tube Number", DD_TransferTubeNumber),
		new DcmDataDictionaryElement (0x300A, 0x02A4, VRCODE_DS, "Transfer Tube Length", DD_TransferTubeLength),
		new DcmDataDictionaryElement (0x300A, 0x02B0, VRCODE_SQ, "Channel Shield Sequence", DD_ChannelShieldSequence),
		new DcmDataDictionaryElement (0x300A, 0x02B2, VRCODE_IS, "Channel Shield Number", DD_ChannelShieldNumber),
		new DcmDataDictionaryElement (0x300A, 0x02B3, VRCODE_SH, "Channel Shield ID", DD_ChannelShieldID),
		new DcmDataDictionaryElement (0x300A, 0x02B4, VRCODE_LO, "Channel Shield Name", DD_ChannelShieldName),
		new DcmDataDictionaryElement (0x300A, 0x02B8, VRCODE_DS, "Channel Shield Nominal Thickness", DD_ChannelShieldNominalThickness),
		new DcmDataDictionaryElement (0x300A, 0x02BA, VRCODE_DS, "Channel Shield Nominal Transmission", DD_ChannelShieldNominalTransmission),
		new DcmDataDictionaryElement (0x300A, 0x02C8, VRCODE_DS, "Final Cumulative Time Weight", DD_FinalCumulativeTimeWeight),
		new DcmDataDictionaryElement (0x300A, 0x02D0, VRCODE_SQ, "Brachy Control Point Sequence", DD_BrachyControlPointSequence),
		new DcmDataDictionaryElement (0x300A, 0x02D2, VRCODE_DS, "Control Point Relative Position", DD_ControlPointRelativePosition),
		new DcmDataDictionaryElement (0x300A, 0x02D4, VRCODE_DS, "Control Point 3D Position", DD_ControlPoint3DPosition),
		new DcmDataDictionaryElement (0x300A, 0x02D6, VRCODE_DS, "Cumulative Time Weight", DD_CumulativeTimeWeight),
		new DcmDataDictionaryElement (0x300C, 0x0002, VRCODE_SQ, "Referenced RT Plan Sequence", DD_ReferencedRTPlanSequence),
		new DcmDataDictionaryElement (0x300C, 0x0004, VRCODE_SQ, "Referenced Beam Sequence", DD_ReferencedBeamSequence),
		new DcmDataDictionaryElement (0x300C, 0x0006, VRCODE_IS, "Referenced Beam Number", DD_ReferencedBeamNumber),
		new DcmDataDictionaryElement (0x300C, 0x0007, VRCODE_IS, "Referenced Reference Image Number", DD_ReferencedReferenceImageNumber),
		new DcmDataDictionaryElement (0x300C, 0x0008, VRCODE_DS, "Start Cumulative Meterset Weight", DD_StartCumulativeMetersetWeight),
		new DcmDataDictionaryElement (0x300C, 0x0009, VRCODE_DS, "End Cumulative Meterset Weight", DD_EndCumulativeMetersetWeight),
		new DcmDataDictionaryElement (0x300C, 0x000A, VRCODE_SQ, "Referenced Brachy Application Setup Sequence", DD_ReferencedBrachyApplicationSetupSequence),
		new DcmDataDictionaryElement (0x300C, 0x000C, VRCODE_IS, "Referenced Brachy Application Setup Number", DD_ReferencedBrachyApplicationSetupNumber),
		new DcmDataDictionaryElement (0x300C, 0x000E, VRCODE_IS, "Referenced Source Number", DD_ReferencedSourceNumber),
		new DcmDataDictionaryElement (0x300C, 0x0020, VRCODE_SQ, "Referenced Fraction Group Sequence", DD_ReferencedFractionGroupSequence),
		new DcmDataDictionaryElement (0x300C, 0x0022, VRCODE_IS, "Referenced Fraction Group Number", DD_ReferencedFractionGroupNumber),
		new DcmDataDictionaryElement (0x300C, 0x0040, VRCODE_SQ, "Referenced Verification Image Sequence", DD_ReferencedVerificationImageSequence),
		new DcmDataDictionaryElement (0x300C, 0x0042, VRCODE_SQ, "Referenced Reference Image Sequence", DD_ReferencedReferenceImageSequence),
		new DcmDataDictionaryElement (0x300C, 0x0050, VRCODE_SQ, "Referenced Dose Reference Sequence", DD_ReferencedDoseReferenceSequence),
		new DcmDataDictionaryElement (0x300C, 0x0051, VRCODE_IS, "Referenced Dose Reference Number", DD_ReferencedDoseReferenceNumber),
		new DcmDataDictionaryElement (0x300C, 0x0055, VRCODE_SQ, "Brachy Referenced Dose Reference Sequence", DD_BrachyReferencedDoseReferenceSequence),
		new DcmDataDictionaryElement (0x300C, 0x0060, VRCODE_SQ, "Referenced Structure Set Sequence", DD_ReferencedStructureSetSequence),
		new DcmDataDictionaryElement (0x300C, 0x006A, VRCODE_IS, "Referenced Patient Setup Number", DD_ReferencedPatientSetupNumber),
		new DcmDataDictionaryElement (0x300C, 0x0080, VRCODE_SQ, "Referenced Dose Sequence", DD_ReferencedDoseSequence),
		new DcmDataDictionaryElement (0x300C, 0x00A0, VRCODE_IS, "Referenced Tolerance Table Number", DD_ReferencedToleranceTableNumber),
		new DcmDataDictionaryElement (0x300C, 0x00B0, VRCODE_SQ, "Referenced Bolus Sequence", DD_ReferencedBolusSequence),
		new DcmDataDictionaryElement (0x300C, 0x00C0, VRCODE_IS, "Referenced Wedge Number", DD_ReferencedWedgeNumber),
		new DcmDataDictionaryElement (0x300C, 0x00D0, VRCODE_IS, "Referenced Compensator Number", DD_ReferencedCompensatorNumber),
		new DcmDataDictionaryElement (0x300C, 0x00E0, VRCODE_IS, "Referenced Block Number", DD_ReferencedBlockNumber),
		new DcmDataDictionaryElement (0x300C, 0x00F0, VRCODE_IS, "Referenced Control Point Index", DD_ReferencedControlPointIndex),
		new DcmDataDictionaryElement (0x300E, 0x0002, VRCODE_CS, "Approval Status", DD_ApprovalStatus),
		new DcmDataDictionaryElement (0x300E, 0x0004, VRCODE_DA, "Review Date", DD_ReviewDate),
		new DcmDataDictionaryElement (0x300E, 0x0005, VRCODE_TM, "Review Time", DD_ReviewTime),
		new DcmDataDictionaryElement (0x300E, 0x0008, VRCODE_PN, "Reviewer Name", DD_ReviewerName),
		new DcmDataDictionaryElement (0x4008, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_4008),
		new DcmDataDictionaryElement (0x4008, 0x0040, VRCODE_SH, "Results ID", DD_ResultsID),
		new DcmDataDictionaryElement (0x4008, 0x0042, VRCODE_LO, "Results ID Issuer", DD_ResultsIDIssuer),
		new DcmDataDictionaryElement (0x4008, 0x0050, VRCODE_SQ, "Referenced Interpretation Sequence", DD_ReferencedInterpretationSequence),
		new DcmDataDictionaryElement (0x4008, 0x0100, VRCODE_DA, "Interpretation Recorded Date", DD_InterpretationRecordedDate),
		new DcmDataDictionaryElement (0x4008, 0x0101, VRCODE_TM, "Interpretation Recorded Time", DD_InterpretationRecordedTime),
		new DcmDataDictionaryElement (0x4008, 0x0102, VRCODE_PN, "Interpretation Recorder", DD_InterpretationRecorder),
		new DcmDataDictionaryElement (0x4008, 0x0103, VRCODE_LO, "Reference to Recorded Sound", DD_ReferenceToRecordedSound),
		new DcmDataDictionaryElement (0x4008, 0x0108, VRCODE_DA, "Interpretation Transcription Date", DD_InterpretationTranscriptionDate),
		new DcmDataDictionaryElement (0x4008, 0x0109, VRCODE_TM, "Interpretation Transcription Time", DD_InterpretationTranscriptionTime),
		new DcmDataDictionaryElement (0x4008, 0x010A, VRCODE_PN, "Interpretation Transcriber", DD_InterpretationTranscriber),
		new DcmDataDictionaryElement (0x4008, 0x010B, VRCODE_ST, "Interpretation Text", DD_InterpretationText),
		new DcmDataDictionaryElement (0x4008, 0x010C, VRCODE_PN, "Interpretation Author", DD_InterpretationAuthor),
		new DcmDataDictionaryElement (0x4008, 0x0111, VRCODE_SQ, "Interpretation Approver Sequence", DD_InterpretationApproverSequence),
		new DcmDataDictionaryElement (0x4008, 0x0112, VRCODE_DA, "Interpretation Approval Date", DD_InterpretationApprovalDate),
		new DcmDataDictionaryElement (0x4008, 0x0113, VRCODE_TM, "Interpretation Approval Time", DD_InterpretationApprovalTime),
		new DcmDataDictionaryElement (0x4008, 0x0114, VRCODE_PN, "Physician Approving Interpretation", DD_PhysicianApprovingInterpretation),
		new DcmDataDictionaryElement (0x4008, 0x0115, VRCODE_LT, "Interpretation Diagnosis Description", DD_InterpretationDiagnosisDescription),
		new DcmDataDictionaryElement (0x4008, 0x0117, VRCODE_SQ, "Interpretation Diagnosis Code Sequence", DD_InterpretationDiagnosisCodeSequence),
		new DcmDataDictionaryElement (0x4008, 0x0118, VRCODE_SQ, "Results Distribution List Sequence", DD_ResultsDistributionListSequence),
		new DcmDataDictionaryElement (0x4008, 0x0119, VRCODE_PN, "Distribution Name", DD_DistributionName),
		new DcmDataDictionaryElement (0x4008, 0x011A, VRCODE_LO, "Distribution Address", DD_DistributionAddress),
		new DcmDataDictionaryElement (0x4008, 0x0200, VRCODE_SH, "Interpretation ID", DD_InterpretationID),
		new DcmDataDictionaryElement (0x4008, 0x0202, VRCODE_LO, "Interpretation ID Issuer", DD_InterpretationIDIssuer),
		new DcmDataDictionaryElement (0x4008, 0x0210, VRCODE_CS, "Interpretation Type ID", DD_InterpretationTypeID),
		new DcmDataDictionaryElement (0x4008, 0x0212, VRCODE_CS, "Interpretation Status ID", DD_InterpretationStatusID),
		new DcmDataDictionaryElement (0x4008, 0x0300, VRCODE_ST, "Impressions", DD_Impressions),
		new DcmDataDictionaryElement (0x4008, 0x4000, VRCODE_ST, "Results Comments", DD_ResultsComments),
		new DcmDataDictionaryElement (0x5000, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_5000),
		new DcmDataDictionaryElement (0x5000, 0x0005, VRCODE_US, "Curve Dimensions", DD_CurveDimensions),
		new DcmDataDictionaryElement (0x5000, 0x0010, VRCODE_US, "Number of Points", DD_NumberOfPoints),
		new DcmDataDictionaryElement (0x5000, 0x0020, VRCODE_CS, "Type of Data", DD_TypeOfData),
		new DcmDataDictionaryElement (0x5000, 0x0022, VRCODE_LO, "Curve Description", DD_CurveDescription),
		new DcmDataDictionaryElement (0x5000, 0x0030, VRCODE_SH, "Axis Units", DD_AxisUnits),
		new DcmDataDictionaryElement (0x5000, 0x0040, VRCODE_SH, "Axis Labels", DD_AxisLabels),
		new DcmDataDictionaryElement (0x5000, 0x0103, VRCODE_US, "Data Value Representation", DD_DataValueRepresentation),
		new DcmDataDictionaryElement (0x5000, 0x0104, VRCODE_US, "Minimum Coordinate Value", DD_MinimumCoordinateValue),
		new DcmDataDictionaryElement (0x5000, 0x0105, VRCODE_US, "Maximum Coordinate Value", DD_MaximumCoordinateValue),
		new DcmDataDictionaryElement (0x5000, 0x0106, VRCODE_SH, "Curve Range", DD_CurveRange),
		new DcmDataDictionaryElement (0x5000, 0x0110, VRCODE_US, "Curve Data Descriptor", DD_CurveDataDescriptor),
		new DcmDataDictionaryElement (0x5000, 0x0112, VRCODE_US, "Coordinate Start Value", DD_CoordinateStartValue),
		new DcmDataDictionaryElement (0x5000, 0x0114, VRCODE_US, "Coordinate Step Value", DD_CoordinateStepValue),
		new DcmDataDictionaryElement (0x5000, 0x2000, VRCODE_US, "Audio Type", DD_AudioType),
		new DcmDataDictionaryElement (0x5000, 0x2002, VRCODE_US, "Audio Sample Format", DD_AudioSampleFormat),
		new DcmDataDictionaryElement (0x5000, 0x2004, VRCODE_US, "Number of Channels", DD_NumberOfChannels),
		new DcmDataDictionaryElement (0x5000, 0x2006, VRCODE_UL, "Number of Samples", DD_NumberOfSamples),
		new DcmDataDictionaryElement (0x5000, 0x2008, VRCODE_UL, "Sample Rate", DD_SampleRate),
		new DcmDataDictionaryElement (0x5000, 0x200A, VRCODE_UL, "Total Time", DD_TotalTime_5000),
		new DcmDataDictionaryElement (0x5000, 0x200C, VRCODE_OW_or_OB, "Audio Sample Data", DD_AudioSampleData),
		new DcmDataDictionaryElement (0x5000, 0x200E, VRCODE_LT, "Audio Comments", DD_AudioComments),
		new DcmDataDictionaryElement (0x5000, 0x2500, VRCODE_LO, "Curve Label", DD_CurveLabel),
		new DcmDataDictionaryElement (0x5000, 0x2600, VRCODE_SQ, "Referenced Overlay Sequence", DD_ReferencedOverlaySequence_5000),
		new DcmDataDictionaryElement (0x5000, 0x2610, VRCODE_US, "Referenced Overlay Group", DD_ReferencedOverlayGroup),
		new DcmDataDictionaryElement (0x5000, 0x3000, VRCODE_OW_or_OB, "Curve Data", DD_CurveData_5000),
		new DcmDataDictionaryElement (0x6000, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_6000),
		new DcmDataDictionaryElement (0x6000, 0x0010, VRCODE_US, "Overlay Rows", DD_OverlayRows),
		new DcmDataDictionaryElement (0x6000, 0x0011, VRCODE_US, "Overlay Columns", DD_OverlayColumns),
		new DcmDataDictionaryElement (0x6000, 0x0012, VRCODE_US, "Overlay Planes", DD_OverlayPlanes),
		new DcmDataDictionaryElement (0x6000, 0x0015, VRCODE_IS, "Number of Frames in Overlay", DD_NumberOfFramesInOverlay),
		new DcmDataDictionaryElement (0x6000, 0x0022, VRCODE_LO, "Overlay Description", DD_OverlayDescription),
		new DcmDataDictionaryElement (0x6000, 0x0040, VRCODE_CS, "Overlay Type", DD_OverlayType),
		new DcmDataDictionaryElement (0x6000, 0x0045, VRCODE_LO, "Overlay Subtype", DD_OverlaySubtype),
		new DcmDataDictionaryElement (0x6000, 0x0050, VRCODE_SS, "Overlay Origin", DD_OverlayOrigin),
		new DcmDataDictionaryElement (0x6000, 0x0051, VRCODE_US, "Image Frame Origin", DD_ImageFrameOrigin),
		new DcmDataDictionaryElement (0x6000, 0x0052, VRCODE_US, "Overlay Plane Origin", DD_OverlayPlaneOrigin),
		new DcmDataDictionaryElement (0x6000, 0x0100, VRCODE_US, "Overlay Bits Allocated", DD_OverlayBitsAllocated),
		new DcmDataDictionaryElement (0x6000, 0x0102, VRCODE_US, "Overlay Bit Position", DD_OverlayBitPosition),
		new DcmDataDictionaryElement (0x6000, 0x1100, VRCODE_US, "Overlay Descriptor - Gray", DD_OverlayDescriptorGray),
		new DcmDataDictionaryElement (0x6000, 0x1101, VRCODE_US, "Overlay Descriptor - Red", DD_OverlayDescriptorRed),
		new DcmDataDictionaryElement (0x6000, 0x1102, VRCODE_US, "Overlay Descriptor - Green", DD_OverlayDescriptorGreen),
		new DcmDataDictionaryElement (0x6000, 0x1103, VRCODE_US, "Overlay Descriptor - Blue", DD_OverlayDescriptorBlue),
		new DcmDataDictionaryElement (0x6000, 0x1200, VRCODE_US, "Overlays- Gray", DD_OverlaysGray),
		new DcmDataDictionaryElement (0x6000, 0x1201, VRCODE_US, "Overlays - Red", DD_OverlaysRed),
		new DcmDataDictionaryElement (0x6000, 0x1202, VRCODE_US, "Overlays - Green", DD_OverlaysGreen),
		new DcmDataDictionaryElement (0x6000, 0x1203, VRCODE_US, "Overlays- Blue", DD_OverlaysBlue),
		new DcmDataDictionaryElement (0x6000, 0x1301, VRCODE_IS, "ROI Area", DD_ROIArea),
		new DcmDataDictionaryElement (0x6000, 0x1302, VRCODE_DS, "ROI Mean", DD_ROIMean),
		new DcmDataDictionaryElement (0x6000, 0x1303, VRCODE_DS, "ROI Standard Deviation", DD_ROIStandardDeviation),
		new DcmDataDictionaryElement (0x6000, 0x1500, VRCODE_LO, "Overlay Label", DD_OverlayLabel),
		new DcmDataDictionaryElement (0x6000, 0x3000, VRCODE_OW, "Overlay Data", DD_OverlayData),
		new DcmDataDictionaryElement (0x7FE0, 0x0000, VRCODE_UL, "Group Length", DD_GroupLength_7FE0),
		new DcmDataDictionaryElement (0x7FE0, 0x0010, VRCODE_OW_or_OB, "Pixel Data", DD_PixelData),
		new DcmDataDictionaryElement (0xFFFC, 0xFFFC, VRCODE_OB, "Data Set Trailing Padding", DD_DataSetTrailingPadding),
		new DcmDataDictionaryElement (0xFFFE, 0xE000, VRCODE_UN, "Item", DD_Item),
		new DcmDataDictionaryElement (0xFFFE, 0xE00D, VRCODE_UN, "Item Delimitation Item", DD_ItemDelimitationItem),
		new DcmDataDictionaryElement (0xFFFE, 0xE0DD, VRCODE_UN, "Sequence Delimitation Item", DD_SequenceDelimitationItem),


		// new DcmDataDictionaryElement (0x0000, 0x0001, VRCODE_UL, "Command Length to End", DD_ACRNEMA_CommandLengthToEnd),
		// new DcmDataDictionaryElement (0x0000, 0x0010, VRCODE_LO, "Command Recognition Code", DD_ACRNEMA_CommandRecognitionCode),
		// new DcmDataDictionaryElement (0x0000, 0x0200, VRCODE_AE, "Initiator", DD_ACRNEMA_Initiator),
		// new DcmDataDictionaryElement (0x0000, 0x0300, VRCODE_AE, "Receiver", DD_ACRNEMA_Receiver),
		// new DcmDataDictionaryElement (0x0000, 0x0400, VRCODE_AE, "Find Location", DD_ACRNEMA_FindLocation),
		// new DcmDataDictionaryElement (0x0000, 0x0850, VRCODE_US, "Number of Matches", DD_ACRNEMA_NumberOfMatches),
		// new DcmDataDictionaryElement (0x0000, 0x0860, VRCODE_US, "Response Sequence Number", DD_ACRNEMA_ResponseSequenceNumber),
		// new DcmDataDictionaryElement (0x0000, 0x4000, VRCODE_LO, "Dialog Receiver", DD_ACRNEMA_DialogReceiver),
		// new DcmDataDictionaryElement (0x0000, 0x4010, VRCODE_LO, "Terminal Type", DD_ACRNEMA_TerminalType),
		// new DcmDataDictionaryElement (0x0000, 0x5110, VRCODE_LO, "Display Format", DD_ACRNEMA_DisplayFormat),
		// new DcmDataDictionaryElement (0x0000, 0x5120, VRCODE_LO, "Page Position ID", DD_ACRNEMA_PagePositionID),
		// new DcmDataDictionaryElement (0x0000, 0x5130, VRCODE_LO, "Text Format ID", DD_ACRNEMA_TextFormatID),
		// new DcmDataDictionaryElement (0x0000, 0x5140, VRCODE_LO, "Normal Reverse", DD_ACRNEMA_NormalReverse),
		// new DcmDataDictionaryElement (0x0000, 0x5150, VRCODE_LO, "Add Gray Scale", DD_ACRNEMA_AddGrayScale),
		// new DcmDataDictionaryElement (0x0000, 0x5160, VRCODE_LO, "Borders", DD_ACRNEMA_Borders),
		// new DcmDataDictionaryElement (0x0000, 0x5170, VRCODE_IS, "Copies", DD_ACRNEMA_Copies),
		// new DcmDataDictionaryElement (0x0000, 0x5180, VRCODE_LO, "OldMagnificationType", DD_ACRNEMA_OldMagnificationType),
		// new DcmDataDictionaryElement (0x0000, 0x5190, VRCODE_LO, "Erase", DD_ACRNEMA_Erase),
		// new DcmDataDictionaryElement (0x0000, 0x51A0, VRCODE_LO, "Print", DD_ACRNEMA_Print),
		// new DcmDataDictionaryElement (0x0000, 0x51B0, VRCODE_US, "Overlays", DD_ACRNEMA_Overlays),
		// new DcmDataDictionaryElement (0x0008, 0x0001, VRCODE_UL, "Length to End", DD_ACRNEMA_LengthToEnd),
		// new DcmDataDictionaryElement (0x0008, 0x0010, VRCODE_LO, "Recognition Code", DD_ACRNEMA_RecognitionCode),
		// new DcmDataDictionaryElement (0x0008, 0x0040, VRCODE_US, "Old Data Set Type", DD_ACRNEMA_OldDataSetType),
		// new DcmDataDictionaryElement (0x0008, 0x0041, VRCODE_LT, "Old Data Set Subtype", DD_ACRNEMA_OldDataSetSubtype),
		// new DcmDataDictionaryElement (0x0008, 0x1000, VRCODE_LT, "Network ID", DD_ACRNEMA_NetworkID),
		// new DcmDataDictionaryElement (0x0008, 0x4000, VRCODE_LT, "Identifying Comments", DD_ACRNEMA_IdentifyingComments),
		// new DcmDataDictionaryElement (0x0010, 0x1050, VRCODE_LT, "Insurance Plan Identification", DD_ACRNEMA_InsurancePlanIdentification),
		// new DcmDataDictionaryElement (0x0018, 0x1240, VRCODE_IS, "Upper/Lower Pixel Values", DD_ACRNEMA_UpperLowerPixelValues),
		// new DcmDataDictionaryElement (0x0018, 0x4000, VRCODE_LT, "Acquisition Comments", DD_ACRNEMA_AcquisitionComments),
		// new DcmDataDictionaryElement (0x0018, 0x5030, VRCODE_DS, "Dynamic Range", DD_ACRNEMA_DynamicRange),
		// new DcmDataDictionaryElement (0x0018, 0x5040, VRCODE_DS, "Total Gain", DD_ACRNEMA_TotalGain),
		// new DcmDataDictionaryElement (0x0020, 0x0030, VRCODE_DS, "Image Position", DD_ACRNEMA_ImagePosition),
		// new DcmDataDictionaryElement (0x0020, 0x0035, VRCODE_DS, "Image Orientation", DD_ACRNEMA_ImageOrientation),
		// new DcmDataDictionaryElement (0x0020, 0x0050, VRCODE_DS, "Location", DD_ACRNEMA_Location),
		// new DcmDataDictionaryElement (0x0020, 0x0070, VRCODE_LT, "Image Geometry Type", DD_ACRNEMA_ImageGeometryType),
		// new DcmDataDictionaryElement (0x0020, 0x0080, VRCODE_LO, "Masking Image", DD_ACRNEMA_MaskingImage),
		// new DcmDataDictionaryElement (0x0020, 0x1001, VRCODE_IS, "Acquisitions in Series", DD_ACRNEMA_AcquisitionsInSeries),
		// new DcmDataDictionaryElement (0x0020, 0x1003, VRCODE_IS, "Images in Series", DD_ACRNEMA_ImagesInSeries),
		// new DcmDataDictionaryElement (0x0020, 0x1005, VRCODE_IS, "Images in Study", DD_ACRNEMA_ImagesInStudy),
		// new DcmDataDictionaryElement (0x0020, 0x1020, VRCODE_LO, "Reference", DD_ACRNEMA_Reference),
		// new DcmDataDictionaryElement (0x0020, 0x3100, VRCODE_LO, "Source Image IDs", DD_ACRNEMA_SourceImageID),
		// new DcmDataDictionaryElement (0x0020, 0x3401, VRCODE_LO, "Modifying Device ID", DD_ACRNEMA_ModifyingDeviceID),
		// new DcmDataDictionaryElement (0x0020, 0x3402, VRCODE_LO, "Modified Image ID", DD_ACRNEMA_ModifiedImageID),
		// new DcmDataDictionaryElement (0x0020, 0x3403, VRCODE_DA, "Modified Image Date", DD_ACRNEMA_ModifiedImageDate),
		// new DcmDataDictionaryElement (0x0020, 0x3404, VRCODE_LO, "Modifying Device Manufacturer", DD_ACRNEMA_ModifyingDeviceManufacturer),
		// new DcmDataDictionaryElement (0x0020, 0x3405, VRCODE_TM, "Modified Image Time", DD_ACRNEMA_ModifiedImageTime),
		// new DcmDataDictionaryElement (0x0020, 0x3406, VRCODE_LT, "Modified Image Description", DD_ACRNEMA_ModifiedImageDescription),
		// new DcmDataDictionaryElement (0x0020, 0x5000, VRCODE_AT, "Original Image Identification", DD_ACRNEMA_OriginalImageIdentification),
		// new DcmDataDictionaryElement (0x0020, 0x5002, VRCODE_LO, "Original Image Identification Nomenclature", DD_ACRNEMA_OriginalImageIdentificationNomenclature),
		// new DcmDataDictionaryElement (0x0028, 0x0005, VRCODE_US, "Image Dimensions", DD_ACRNEMA_ImageDimensions),
		// new DcmDataDictionaryElement (0x0028, 0x0040, VRCODE_LO, "Image Format", DD_ACRNEMA_ImageFormat),
		// new DcmDataDictionaryElement (0x0028, 0x0050, VRCODE_LT, "Manipulated Image", DD_ACRNEMA_ManipulatedImage),
		// new DcmDataDictionaryElement (0x0028, 0x005F, VRCODE_LO, "Compression Recognition Code", DD_ACRNEMA_CompressionRecognitionCode),
		// new DcmDataDictionaryElement (0x0028, 0x0060, VRCODE_LO, "Compression Code", DD_ACRNEMA_CompressionCode),
		// new DcmDataDictionaryElement (0x0028, 0x0061, VRCODE_SH, "Compression Originator", DD_ACRNEMA_CompressionOriginator),
		// new DcmDataDictionaryElement (0x0028, 0x0062, VRCODE_SH, "Compression Label", DD_ACRNEMA_CompressionLabel),
		// new DcmDataDictionaryElement (0x0028, 0x0063, VRCODE_SH, "Compression Description", DD_ACRNEMA_CompressionDescription),
		// new DcmDataDictionaryElement (0x0028, 0x0065, VRCODE_LO, "Compression Sequence", DD_ACRNEMA_CompressionSequence),
		// new DcmDataDictionaryElement (0x0028, 0x0066, VRCODE_AT, "Compression Step Pointers", DD_ACRNEMA_CompressionStepPointers),
		// new DcmDataDictionaryElement (0x0028, 0x0068, VRCODE_US, "Repeat Interval", DD_ACRNEMA_RepeatInterval),
		// new DcmDataDictionaryElement (0x0028, 0x0069, VRCODE_US, "Bits Grouped", DD_ACRNEMA_BitsGrouped),
		// new DcmDataDictionaryElement (0x0028, 0x0070, VRCODE_US, "Perimeter Table", DD_ACRNEMA_PerimeterTable),
		// new DcmDataDictionaryElement (0x0028, 0x0071, VRCODE_US_or_SS, "Perimeter Value", DD_ACRNEMA_PerimeterValue),
		// new DcmDataDictionaryElement (0x0028, 0x0080, VRCODE_US, "Predictor Rows", DD_ACRNEMA_PredictorRows),
		// new DcmDataDictionaryElement (0x0028, 0x0081, VRCODE_US, "Predictor Columns", DD_ACRNEMA_PredictorColumns),
		// new DcmDataDictionaryElement (0x0028, 0x0082, VRCODE_US, "Predictor Constants", DD_ACRNEMA_PredictorConstants),
		// new DcmDataDictionaryElement (0x0028, 0x0090, VRCODE_LO, "Blocked Pixels", DD_ACRNEMA_BlockedPixels),
		// new DcmDataDictionaryElement (0x0028, 0x0091, VRCODE_US, "Block Rows", DD_ACRNEMA_BlockRows),
		// new DcmDataDictionaryElement (0x0028, 0x0092, VRCODE_US, "Block Columns", DD_ACRNEMA_BlockColumns),
		// new DcmDataDictionaryElement (0x0028, 0x0093, VRCODE_US, "Row Overlap", DD_ACRNEMA_RowOverlap),
		// new DcmDataDictionaryElement (0x0028, 0x0094, VRCODE_US, "Column Overlap", DD_ACRNEMA_ColumnOverlap),
		// new DcmDataDictionaryElement (0x0028, 0x0104, VRCODE_US_or_SS, "Smallest Valid Pixel Value", DD_ACRNEMA_SmallestValidPixelValue),
		// new DcmDataDictionaryElement (0x0028, 0x0105, VRCODE_US_or_SS, "Largest Valid Pixel Value", DD_ACRNEMA_LargestValidPixelValue),
		// new DcmDataDictionaryElement (0x0028, 0x0200, VRCODE_US, "Image Location", DD_ACRNEMA_ImageLocation),
		// new DcmDataDictionaryElement (0x0028, 0x0400, VRCODE_LO, "Transform Label", DD_ACRNEMA_TransformLabel),
		// new DcmDataDictionaryElement (0x0028, 0x0401, VRCODE_LO, "Transform Version Number", DD_ACRNEMA_TransformVersionNumber),
		// new DcmDataDictionaryElement (0x0028, 0x0402, VRCODE_US, "Number of Transform Steps", DD_ACRNEMA_NumberOfTransformSteps),
		// new DcmDataDictionaryElement (0x0028, 0x0403, VRCODE_LO, "Sequence of Compressed Data", DD_ACRNEMA_SequenceOfCompressedData),
		// new DcmDataDictionaryElement (0x0028, 0x0404, VRCODE_AT, "Details of Coefficients", DD_ACRNEMA_DetailsOfCoefficients),
		// new DcmDataDictionaryElement (0x0028, 0x0700, VRCODE_LO, "DCT Label", DD_ACRNEMA_DCTLabel),
		// new DcmDataDictionaryElement (0x0028, 0x0701, VRCODE_LO, "Data Block Description", DD_ACRNEMA_DataBlockDescription),
		// new DcmDataDictionaryElement (0x0028, 0x0702, VRCODE_AT, "Data Block", DD_ACRNEMA_DataBlock),
		// new DcmDataDictionaryElement (0x0028, 0x0710, VRCODE_US, "Normalization Factor Format", DD_ACRNEMA_NormalizationFactorFormat),
		// new DcmDataDictionaryElement (0x0028, 0x0720, VRCODE_US, "Zonal Map Number Format", DD_ACRNEMA_ZonalMapNumberFormat),
		// new DcmDataDictionaryElement (0x0028, 0x0721, VRCODE_AT, "Zonal Map Location", DD_ACRNEMA_ZonalMapLocation),
		// new DcmDataDictionaryElement (0x0028, 0x0722, VRCODE_US, "Zonal Map Format", DD_ACRNEMA_ZonalMapFormat),
		// new DcmDataDictionaryElement (0x0028, 0x0730, VRCODE_US, "Adaptive Map Format", DD_ACRNEMA_AdaptiveMapFormat),
		// new DcmDataDictionaryElement (0x0028, 0x0740, VRCODE_US, "Code Number Format", DD_ACRNEMA_CodeNumberFormat),
		// new DcmDataDictionaryElement (0x0028, 0x0800, VRCODE_LO, "Code Label", DD_ACRNEMA_CodeLabel),
		// new DcmDataDictionaryElement (0x0028, 0x0802, VRCODE_US, "Number of Tables", DD_ACRNEMA_NumberOfTables),
		// new DcmDataDictionaryElement (0x0028, 0x0803, VRCODE_AT, "Code Table Location", DD_ACRNEMA_CodeTableLocation),
		// new DcmDataDictionaryElement (0x0028, 0x0804, VRCODE_US, "Bits For Code Word", DD_ACRNEMA_BitsForCodeWord),
		// new DcmDataDictionaryElement (0x0028, 0x0808, VRCODE_AT, "Image Data Location", DD_ACRNEMA_ImageDataLocation),
		// new DcmDataDictionaryElement (0x0028, 0x1080, VRCODE_LO, "Gray Scale", DD_ACRNEMA_GrayScale),
		// new DcmDataDictionaryElement (0x0028, 0x1100, VRCODE_US_US_or_SS_US, "Gray Lookup Table Descriptor", DD_ACRNEMA_GrayLookupTableDescriptor),
		// new DcmDataDictionaryElement (0x0028, 0x1200, VRCODE_US_or_SS, "Gray Lookup Table Data", DD_ACRNEMA_GrayLookupTableData),
		// new DcmDataDictionaryElement (0x0028, 0x4000, VRCODE_LT, "Image Presentation Comments", DD_ACRNEMA_ImagePresentationComments),
		// new DcmDataDictionaryElement (0x1000, 0x0000, VRCODE_UL, "Code Table Group Length", DD_ACRNEMA_CodeTableGroupLength),
		// new DcmDataDictionaryElement (0x1000, 0x0001, VRCODE_US, "Run Length Triplet", DD_ACRNEMA_RunLengthTriplet),
		// new DcmDataDictionaryElement (0x1000, 0x0002, VRCODE_US, "Huffman Table Size", DD_ACRNEMA_HuffmanTableSize),
		// new DcmDataDictionaryElement (0x1000, 0x0003, VRCODE_US, "Huffman Table Triplet", DD_ACRNEMA_HuffmanTableTriplet),
		// new DcmDataDictionaryElement (0x1000, 0x0004, VRCODE_US, "Shift Table Size", DD_ACRNEMA_ShiftTableSize),
		// new DcmDataDictionaryElement (0x1000, 0x0005, VRCODE_US, "Shift Table Triplet", DD_ACRNEMA_ShiftTableTriplet),
		// new DcmDataDictionaryElement (0x1010, 0x0000, VRCODE_UL, "Zonal Map Group Length", DD_ACRNEMA_ZonalMapGroupLength),
		// new DcmDataDictionaryElement (0x4000, 0x0000, VRCODE_UL, "Text Group Length", DD_ACRNEMA_TextGroupLength),
		// new DcmDataDictionaryElement (0x4000, 0x0010, VRCODE_LT, "Text Arbitrary", DD_ACRNEMA_TextArbitrary),
		// new DcmDataDictionaryElement (0x4000, 0x4000, VRCODE_LT, "Text Comments", DD_ACRNEMA_TextComments),
		// new DcmDataDictionaryElement (0x6000, 0x0060, VRCODE_LO, "Overlay Compression Code", DD_ACRNEMA_OverlayCompressionCode),
		// new DcmDataDictionaryElement (0x6000, 0x0061, VRCODE_SH, "Overlay Compression Originator", DD_ACRNEMA_OverlayCompressionOriginator),
		// new DcmDataDictionaryElement (0x6000, 0x0062, VRCODE_SH, "Overlay Compression Label", DD_ACRNEMA_OverlayCompressionLabel),
		// new DcmDataDictionaryElement (0x6000, 0x0063, VRCODE_SH, "Overlay Compression Description", DD_ACRNEMA_OverlayCompressionDescription),
		// new DcmDataDictionaryElement (0x6000, 0x0066, VRCODE_AT, "Overlay Compression Step Pointers", DD_ACRNEMA_OverlayCompressionStepPointers),
		// new DcmDataDictionaryElement (0x6000, 0x0068, VRCODE_US, "Overlay Repeat Interval", DD_ACRNEMA_OverlayRepeatInterval),
		// new DcmDataDictionaryElement (0x6000, 0x0069, VRCODE_US, "Overlay Bits Grouped", DD_ACRNEMA_OverlayBitsGrouped),
		// new DcmDataDictionaryElement (0x6000, 0x0110, VRCODE_LO, "Overlay Format", DD_ACRNEMA_OverlayFormat),
		// new DcmDataDictionaryElement (0x6000, 0x0200, VRCODE_US, "Overlay Location", DD_ACRNEMA_OverlayLocation),
		// new DcmDataDictionaryElement (0x6000, 0x0800, VRCODE_LO, "Overlay Code Label", DD_ACRNEMA_OverlayCodeLabel),
		// new DcmDataDictionaryElement (0x6000, 0x0802, VRCODE_US, "Overlay Number of Tables", DD_ACRNEMA_OverlayNumberOfTables),
		// new DcmDataDictionaryElement (0x6000, 0x0803, VRCODE_AT, "Overlay Code Table Location", DD_ACRNEMA_OverlayCodeTableLocation),
		// new DcmDataDictionaryElement (0x6000, 0x0804, VRCODE_US, "Overlay Bits For Code Word", DD_ACRNEMA_OverlayBitsForCodeWord),
		// new DcmDataDictionaryElement (0x6000, 0x4000, VRCODE_LT, "Overlay Comments", DD_ACRNEMA_OverlayComments),
		// new DcmDataDictionaryElement (0x7FE0, 0x0020, VRCODE_OW, "Coefficients SDVN", DD_ACRNEMA_CoefficientsSDVN),
		// new DcmDataDictionaryElement (0x7FE0, 0x0030, VRCODE_OW, "Coefficients SDHN", DD_ACRNEMA_CoefficientsSDHN),
		// new DcmDataDictionaryElement (0x7FE0, 0x0040, VRCODE_OW, "Coefficients SDDN", DD_ACRNEMA_CoefficientsSDDN),
		// new DcmDataDictionaryElement (0x7F00, 0x0000, VRCODE_UL, "Variable Pixel Data Group Length", DD_ACRNEMA_VariablePixelDataGroupLength),
		// new DcmDataDictionaryElement (0x7F00, 0x0010, VRCODE_OW_or_OB, "Variable Pixel Data", DD_ACRNEMA_VariablePixelData),
		// new DcmDataDictionaryElement (0x7F00, 0x0011, VRCODE_US, "Variable Next Data Group", DD_ACRNEMA_VariableNextDataGroup),
		// new DcmDataDictionaryElement (0x7F00, 0x0020, VRCODE_OW, "Variable Coefficients SDVN", DD_ACRNEMA_VariableCoefficientsSDVN),
		// new DcmDataDictionaryElement (0x7F00, 0x0030, VRCODE_OW, "Variable Coefficients SDHN", DD_ACRNEMA_VariableCoefficientsSDHN),
		// new DcmDataDictionaryElement (0x7F00, 0x0040, VRCODE_OW, "Variable Coefficients SDDN", DD_ACRNEMA_VariableCoefficientsSDDN),
		// new DcmDataDictionaryElement (0x0003, 0x0000, VRCODE_US, "AEGIS_DICOM_2_00 Attribute (0x0003, 0x0000)", DD_AEGIS_DICOM_2_00_0x0003_0x0000),
		// new DcmDataDictionaryElement (0x0005, 0x0000, VRCODE_US, "AEGIS_DICOM_2_00 Attribute (0x0005, 0x0000)", DD_AEGIS_DICOM_2_00_0x0005_0x0000),
		// new DcmDataDictionaryElement (0x1369, 0x0000, VRCODE_US, "AEGIS_DICOM_2_00 Attribute (0x1369, 0x0000)", DD_AEGIS_DICOM_2_00_0x1369_0x0000),
		// new DcmDataDictionaryElement (0x00E1, 0x0001, VRCODE_US, "Data Dictionary Version", DD_ELSCINT1_DataDictionaryVersion),
		// new DcmDataDictionaryElement (0x00E1, 0x0014, VRCODE_LT, "ELSCINT1 Attribute (0x00E1, 0x0014)", DD_ELSCINT1_0x00E1_0x0014),
		// new DcmDataDictionaryElement (0x00E1, 0x0022, VRCODE_DS, "ELSCINT1 Attribute (0x00E1, 0x0022)", DD_ELSCINT1_0x00E1_0x0022),
		// new DcmDataDictionaryElement (0x00E1, 0x0023, VRCODE_DS, "ELSCINT1 Attribute (0x00E1, 0x0023)", DD_ELSCINT1_0x00E1_0x0023),
		// new DcmDataDictionaryElement (0x00E1, 0x0024, VRCODE_LT, "ELSCINT1 Attribute (0x00E1, 0x0024)", DD_ELSCINT1_0x00E1_0x0024),
		// new DcmDataDictionaryElement (0x00E1, 0x0025, VRCODE_LT, "ELSCINT1 Attribute (0x00E1, 0x0025)", DD_ELSCINT1_0x00E1_0x0025),
		// new DcmDataDictionaryElement (0x00E1, 0x0040, VRCODE_SH, "Offset From CT MR Images", DD_ELSCINT1_OffsetFromCTMRImages),
		// new DcmDataDictionaryElement (0x0601, 0x0000, VRCODE_SH, "Implementation Version", DD_ELSCINT1_ImplementationVersion),
		// new DcmDataDictionaryElement (0x0601, 0x0020, VRCODE_DS, "Relative Table Position", DD_ELSCINT1_RelativeTablePosition),
		// new DcmDataDictionaryElement (0x0601, 0x0021, VRCODE_DS, "Relative Table Height", DD_ELSCINT1_RelativeTableHeight),
		// new DcmDataDictionaryElement (0x0601, 0x0030, VRCODE_SH, "Surview Direction", DD_ELSCINT1_SurviewDirection),
		// new DcmDataDictionaryElement (0x0601, 0x0031, VRCODE_DS, "Surview Length", DD_ELSCINT1_SurviewLength),
		// new DcmDataDictionaryElement (0x0601, 0x0050, VRCODE_SH, "Image View Type", DD_ELSCINT1_ImageViewType),
		// new DcmDataDictionaryElement (0x0009, 0x0017, VRCODE_LT, "GEMS_IDEN_01 Attribute (0x0009, 0x0017)", DD_GEMS_IDEN_01_0x0009_0x0017),
		// new DcmDataDictionaryElement (0x0009, 0x001a, VRCODE_US, "GEMS_IDEN_01 Attribute (0x0009, 0x001a)", DD_GEMS_IDEN_01_0x0009_0x001a),
		// new DcmDataDictionaryElement (0x0009, 0x0024, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0009, 0x0024)", DD_GEMS_ACQU_01_0x0009_0x0024),
		// new DcmDataDictionaryElement (0x0009, 0x0025, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0009, 0x0025)", DD_GEMS_ACQU_01_0x0009_0x0025),
		// new DcmDataDictionaryElement (0x0009, 0x002f, VRCODE_LT, "GEMS_IDEN_01 Attribute (0x0009, 0x002f)", DD_GEMS_IDEN_01_0x0009_0x002f),
		// new DcmDataDictionaryElement (0x0009, 0x003e, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0009, 0x003e)", DD_GEMS_ACQU_01_0x0009_0x003e),
		// new DcmDataDictionaryElement (0x0009, 0x003f, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0009, 0x003f)", DD_GEMS_ACQU_01_0x0009_0x003f),
		// new DcmDataDictionaryElement (0x0009, 0x0043, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0009, 0x0043)", DD_GEMS_ACQU_01_0x0009_0x0043),
		// new DcmDataDictionaryElement (0x0009, 0x00e2, VRCODE_LT, "GEMS_IDEN_01 Attribute (0x0009, 0x00e2)", DD_GEMS_IDEN_01_0x0009_0x00e2),
		// new DcmDataDictionaryElement (0x0009, 0x00e3, VRCODE_LT, "GEMS_IDEN_01 Attribute (0x0009, 0x00e3)", DD_GEMS_IDEN_01_0x0009_0x00e3),
		// new DcmDataDictionaryElement (0x0009, 0x00f8, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0009, 0x00f8)", DD_GEMS_ACQU_01_0x0009_0x00f8),
		// new DcmDataDictionaryElement (0x0009, 0x00fb, VRCODE_IS, "GEMS_ACQU_01 Attribute (0x0009, 0x00fb)", DD_GEMS_ACQU_01_0x0009_0x00fb),
		// new DcmDataDictionaryElement (0x0019, 0x002d, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x002d)", DD_GEMS_ACQU_01_0x0019_0x002d),
		// new DcmDataDictionaryElement (0x0019, 0x0039, VRCODE_UN, "GEMS_ACQU_01 Attribute (0x0019, 0x0039)", DD_GEMS_ACQU_01_0x0019_0x0039),
		// new DcmDataDictionaryElement (0x0019, 0x003b, VRCODE_LT, "GEMS_ACQU_01 Attribute (0x0019, 0x003b)", DD_GEMS_ACQU_01_0x0019_0x003b),
		// new DcmDataDictionaryElement (0x0019, 0x003f, VRCODE_UN, "GEMS_ACQU_01 Attribute (0x0019, 0x003f)", DD_GEMS_ACQU_01_0x0019_0x003f),
		// new DcmDataDictionaryElement (0x0019, 0x005d, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x005d)", DD_GEMS_ACQU_01_0x0019_0x005d),
		// new DcmDataDictionaryElement (0x0019, 0x007f, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x007f)", DD_GEMS_ACQU_01_0x0019_0x007f),
		// new DcmDataDictionaryElement (0x0019, 0x008f, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x008f)", DD_GEMS_ACQU_01_0x0019_0x008f),
		// new DcmDataDictionaryElement (0x0019, 0x0099, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x0099)", DD_GEMS_ACQU_01_0x0019_0x0099),
		// new DcmDataDictionaryElement (0x0019, 0x009b, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x009b)", DD_GEMS_ACQU_01_0x0019_0x009b),
		// new DcmDataDictionaryElement (0x0019, 0x009d, VRCODE_LT, "GEMS_ACQU_01 Attribute (0x0019, 0x009d)", DD_GEMS_ACQU_01_0x0019_0x009d),
		// new DcmDataDictionaryElement (0x0019, 0x00b6, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00b6)", DD_GEMS_ACQU_01_0x0019_0x00b6),
		// new DcmDataDictionaryElement (0x0019, 0x00b7, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00b7)", DD_GEMS_ACQU_01_0x0019_0x00b7),
		// new DcmDataDictionaryElement (0x0019, 0x00b8, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00b8)", DD_GEMS_ACQU_01_0x0019_0x00b8),
		// new DcmDataDictionaryElement (0x0019, 0x00b9, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00b9)", DD_GEMS_ACQU_01_0x0019_0x00b9),
		// new DcmDataDictionaryElement (0x0019, 0x00ba, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00ba)", DD_GEMS_ACQU_01_0x0019_0x00ba),
		// new DcmDataDictionaryElement (0x0019, 0x00bb, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00bb)", DD_GEMS_ACQU_01_0x0019_0x00bb),
		// new DcmDataDictionaryElement (0x0019, 0x00bc, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00bc)", DD_GEMS_ACQU_01_0x0019_0x00bc),
		// new DcmDataDictionaryElement (0x0019, 0x00bd, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00bd)", DD_GEMS_ACQU_01_0x0019_0x00bd),
		// new DcmDataDictionaryElement (0x0019, 0x00df, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00df)", DD_GEMS_ACQU_01_0x0019_0x00df),
		// new DcmDataDictionaryElement (0x0019, 0x00e4, VRCODE_LT, "GEMS_ACQU_01 Attribute (0x0019, 0x00e4)", DD_GEMS_ACQU_01_0x0019_0x00e4),
		// new DcmDataDictionaryElement (0x0019, 0x00e5, VRCODE_IS, "GEMS_ACQU_01 Attribute (0x0019, 0x00e5)", DD_GEMS_ACQU_01_0x0019_0x00e5),
		// new DcmDataDictionaryElement (0x0019, 0x00e6, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x00e6)", DD_GEMS_ACQU_01_0x0019_0x00e6),
		// new DcmDataDictionaryElement (0x0019, 0x00e8, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00e8)", DD_GEMS_ACQU_01_0x0019_0x00e8),
		// new DcmDataDictionaryElement (0x0019, 0x00e9, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00e9)", DD_GEMS_ACQU_01_0x0019_0x00e9),
		// new DcmDataDictionaryElement (0x0019, 0x00eb, VRCODE_DS, "GEMS_ACQU_01 Attribute (0x0019, 0x00eb)", DD_GEMS_ACQU_01_0x0019_0x00eb),
		// new DcmDataDictionaryElement (0x0019, 0x00ec, VRCODE_US, "GEMS_ACQU_01 Attribute (0x0019, 0x00ec)", DD_GEMS_ACQU_01_0x0019_0x00ec),
		// new DcmDataDictionaryElement (0x0019, 0x00f4, VRCODE_LT, "GEMS_ACQU_01 Attribute (0x0019, 0x00f4)", DD_GEMS_ACQU_01_0x0019_0x00f4),
		// new DcmDataDictionaryElement (0x0019, 0x00f9, VRCODE_IS, "GEMS_ACQU_01 Attribute (0x0019, 0x00f9)", DD_GEMS_ACQU_01_0x0019_0x00f9),
		// new DcmDataDictionaryElement (0x0021, 0x004e, VRCODE_US, "GEMS_RELA_01 Attribute (0x0021, 0x004e)", DD_GEMS_RELA_01_0x0021_0x004e),
		// new DcmDataDictionaryElement (0x0021, 0x0081, VRCODE_DS, "GEMS_RELA_01 Attribute (0x0021, 0x0081)", DD_GEMS_RELA_01_0x0021_0x0081),
		// new DcmDataDictionaryElement (0x0021, 0x0083, VRCODE_IS, "GEMS_RELA_01 Attribute (0x0021, 0x0083)", DD_GEMS_RELA_01_0x0021_0x0083),
		// new DcmDataDictionaryElement (0x0021, 0x0084, VRCODE_IS, "GEMS_RELA_01 Attribute (0x0021, 0x0084)", DD_GEMS_RELA_01_0x0021_0x0084),
		// new DcmDataDictionaryElement (0x0033, 0x0001, VRCODE_UN, "GEMS_GNHD_01 Attribute (0x0033, 0x0001)", DD_GEMS_GNHD_01_0x0033_0x0001),
		// new DcmDataDictionaryElement (0x0033, 0x0005, VRCODE_UN, "GEMS_YMHD_01 Attribute (0x0033, 0x0005)", DD_GEMS_YMHD_01_0x0033_0x0005),
		// new DcmDataDictionaryElement (0x0033, 0x0006, VRCODE_UN, "GEMS_YMHD_01 Attribute (0x0033, 0x0006)", DD_GEMS_YMHD_01_0x0033_0x0006),
		// new DcmDataDictionaryElement (0x0037, 0x0010, VRCODE_LO, "ReferringDepartment", DD_GEMS_DRS_1_ReferringDepartment),
		// new DcmDataDictionaryElement (0x0037, 0x0020, VRCODE_US, "ScreenNumber", DD_GEMS_DRS_1_ScreenNumber),
		// new DcmDataDictionaryElement (0x0037, 0x0040, VRCODE_CS, "LeftOrientation", DD_GEMS_DRS_1_LeftOrientation),
		// new DcmDataDictionaryElement (0x0037, 0x0042, VRCODE_CS, "RightOrientation", DD_GEMS_DRS_1_RightOrientation),
		// new DcmDataDictionaryElement (0x0037, 0x0050, VRCODE_CS, "Inversion", DD_GEMS_DRS_1_Inversion),
		// new DcmDataDictionaryElement (0x0037, 0x0060, VRCODE_CS, "DSA", DD_GEMS_DRS_1_DSA),
		// new DcmDataDictionaryElement (0x0009, 0x0018, VRCODE_LT, "Data Set Identifier", DD_PAPYRUS_DataSetIdentifier),
		// new DcmDataDictionaryElement (0x0041, 0x0012, VRCODE_UL, "Pixel Offset", DD_PAPYRUS_3_0_PixelOffset),
		// new DcmDataDictionaryElement (0x0041, 0x0013, VRCODE_SQ, "Image Identifier Sequence", DD_PAPYRUS_3_0_ImageIdentifierSequence),
		// new DcmDataDictionaryElement (0x0041, 0x0014, VRCODE_SQ, "External File Reference Sequence", DD_PAPYRUS_3_0_ExternalFileReferenceSequence),
		// new DcmDataDictionaryElement (0x0041, 0x0015, VRCODE_US, "Number of Images", DD_PAPYRUS_3_0_NumberOfImages),
		// new DcmDataDictionaryElement (0x0041, 0x0021, VRCODE_UI, "Referenced SOP Class UID", DD_PAPYRUS_3_0_ReferencedSOPClassUID2),
		// new DcmDataDictionaryElement (0x0041, 0x0022, VRCODE_UI, "Referenced SOP Instance UID", DD_PAPYRUS_3_0_ReferencedSOPInstanceUID2),
		// new DcmDataDictionaryElement (0x0041, 0x0034, VRCODE_DA, "Modified Date", DD_PAPYRUS_ModifiedDate),
		// new DcmDataDictionaryElement (0x0041, 0x0036, VRCODE_TM, "Modified Time", DD_PAPYRUS_ModifiedTime),
		// new DcmDataDictionaryElement (0x0041, 0x0040, VRCODE_LT, "Owner Name", DD_PAPYRUS_OwnerName),
		// new DcmDataDictionaryElement (0x0041, 0x0041, VRCODE_UI, "Referenced Image SOP Class UID", DD_PAPYRUS_3_0_ReferencedImageSOPClassUID),
		// new DcmDataDictionaryElement (0x0041, 0x0042, VRCODE_UI, "Referenced Image SOP Instance UID", DD_PAPYRUS_3_0_ReferencedImageSOPInstanceUID),
		// new DcmDataDictionaryElement (0x0041, 0x0060, VRCODE_UL, "Number of Images", DD_PAPYRUS_NumberOfImages2),
		// new DcmDataDictionaryElement (0x0041, 0x0062, VRCODE_UL, "Number of Other", DD_PAPYRUS_NumberOfOther),
		// new DcmDataDictionaryElement (0x0041, 0x00A0, VRCODE_LT, "External Folder Element DSID", DD_PAPYRUS_ExternalFolderElementDSID),
		// new DcmDataDictionaryElement (0x0041, 0x00A1, VRCODE_US, "External Folder Element Data Set Type", DD_PAPYRUS_ExternalFolderElementDataSetType),
		// new DcmDataDictionaryElement (0x0041, 0x00A2, VRCODE_LT, "External Folder Element File Location", DD_PAPYRUS_ExternalFolderElementFileLocation),
		// new DcmDataDictionaryElement (0x0041, 0x00A3, VRCODE_UL, "External Folder Element Length", DD_PAPYRUS_ExternalFolderElementLength),
		// new DcmDataDictionaryElement (0x0041, 0x00B0, VRCODE_LT, "Internal Folder Element DSID", DD_PAPYRUS_InternalFolderElementDSID),
		// new DcmDataDictionaryElement (0x0041, 0x00B1, VRCODE_US, "Internal Folder Element Data Set Type", DD_PAPYRUS_InternalFolderElementDataSetType),
		// new DcmDataDictionaryElement (0x0041, 0x00B2, VRCODE_UL, "Internal Offset To Data Set", DD_PAPYRUS_InternalOffsetToDataSet),
		// new DcmDataDictionaryElement (0x0041, 0x00B3, VRCODE_UL, "Internal Offset To Image", DD_PAPYRUS_InternalOffsetToImage),
		// new DcmDataDictionaryElement (0x0019, 0x001b, VRCODE_IS, "Number of Scans", DD_PHILIPS_MR_PART_NumberOfScans),
		// new DcmDataDictionaryElement (0x0019, 0x0029, VRCODE_IS, "PHILIPS_MR_SPECTRO_1 Attribute (0x0019, 0x0029)", DD_PHILIPS_MR_SPECTRO_1_0x0019_0x0029),
		// new DcmDataDictionaryElement (0x0019, 0x006b, VRCODE_IS, "Inversion Delay", DD_PHILIPS_MR_PART_InversionDelay),
		// new DcmDataDictionaryElement (0x0019, 0x006d, VRCODE_IS, "Gate Width", DD_PHILIPS_MR_PART_GateWidth),
		// new DcmDataDictionaryElement (0x0019, 0x0073, VRCODE_US, "PHILIPS_MR_SPECTRO_1 Attribute (0x0019, 0x0073)", DD_PHILIPS_MR_SPECTRO_1_0x0019_0x0073),
		// new DcmDataDictionaryElement (0x0019, 0x0077, VRCODE_US, "PHILIPS_MR_SPECTRO_1 Attribute (0x0019, 0x0077)", DD_PHILIPS_MR_SPECTRO_1_0x0019_0x0077),
		// new DcmDataDictionaryElement (0x0019, 0x00cb, VRCODE_IS, "Foldover Direction Coronal", DD_PHILIPS_MR_PART_FoldoverDirectionCoronal),
		// new DcmDataDictionaryElement (0x0019, 0x00cf, VRCODE_IS, "Number of Echoes", DD_PHILIPS_MR_PART_NumberOfEchoes),
		// new DcmDataDictionaryElement (0x0019, 0x00d0, VRCODE_IS, "Scan Resolution", DD_PHILIPS_MR_PART_ScanResolution),
		// new DcmDataDictionaryElement (0x0019, 0x00f2, VRCODE_LT, "WS Protocol String 3", DD_PHILIPS_MR_LAST_WSProtocolString3),
		// new DcmDataDictionaryElement (0x0019, 0x00fc, VRCODE_IS, "Resonance Frequency", DD_PHILIPS_MR_PART_ResonanceFrequency),
		// new DcmDataDictionaryElement (0x0021, 0x0035, VRCODE_IS, "Chemical Shift Number", DD_PHILIPS_MR_PART_ChemicalShiftNumber),
		// new DcmDataDictionaryElement (0x0027, 0x0000, VRCODE_US, "PHILIPS_MR_LAST Attribute (0x0027, 0x0000)", DD_PHILIPS_MR_LAST_0x0027_0x0000),
		// new DcmDataDictionaryElement (0x0027, 0x0011, VRCODE_UN, "PHILIPS_MR_LAST Attribute (0x0027, 0x0011)", DD_PHILIPS_MR_LAST_0x0027_0x0011),
		// new DcmDataDictionaryElement (0x0027, 0x0012, VRCODE_IS, "PHILIPS_MR_LAST Attribute (0x0027, 0x0012)", DD_PHILIPS_MR_LAST_0x0027_0x0012),
		// new DcmDataDictionaryElement (0x0027, 0x0013, VRCODE_IS, "PHILIPS_MR_LAST Attribute (0x0027, 0x0013)", DD_PHILIPS_MR_LAST_0x0027_0x0013),
		// new DcmDataDictionaryElement (0x0027, 0x0014, VRCODE_IS, "PHILIPS_MR_LAST Attribute (0x0027, 0x0014)", DD_PHILIPS_MR_LAST_0x0027_0x0014),
		// new DcmDataDictionaryElement (0x0027, 0x0015, VRCODE_IS, "PHILIPS_MR_LAST Attribute (0x0027, 0x0015)", DD_PHILIPS_MR_LAST_0x0027_0x0015),
		// new DcmDataDictionaryElement (0x0027, 0x0016, VRCODE_LT, "PHILIPS_MR_LAST Attribute (0x0027, 0x0016)", DD_PHILIPS_MR_LAST_0x0027_0x0016),
		// new DcmDataDictionaryElement (0x0029, 0x0082, VRCODE_IS, "View Zoom", DD_PHILIPS_MR_LAST_ViewZoom),
		// new DcmDataDictionaryElement (0x0029, 0x0083, VRCODE_IS, "View Transform", DD_PHILIPS_MR_LAST_ViewTransform),
		// new DcmDataDictionaryElement (0x0029, 0x00c3, VRCODE_IS, "Scan Resolution", DD_PHILIPS_MR_PART_ScanResolution2),
		// new DcmDataDictionaryElement (0x0029, 0x00c4, VRCODE_IS, "Field of View", DD_PHILIPS_MR_PART_FieldOfView),
		// new DcmDataDictionaryElement (0x0029, 0x00d5, VRCODE_LT, "Slice Thickness", DD_PHILIPS_MR_PART_SliceThickness2),
		// new DcmDataDictionaryElement (0x6001, 0x0000, VRCODE_UN, "PHILIPS_MR_LAST Attribute (0x6001, 0x0000)", DD_PHILIPS_MR_LAST_0x6001_0x0000),
		// new DcmDataDictionaryElement (0x0003, 0x0008, VRCODE_US, "ISI Command Field", DD_SIEMENS_ISI_ISICommandField),
		// new DcmDataDictionaryElement (0x0003, 0x0011, VRCODE_US, "Attach ID Application Code", DD_SIEMENS_ISI_AttachIDApplicationCode),
		// new DcmDataDictionaryElement (0x0003, 0x0012, VRCODE_UL, "Attach ID Message Count", DD_SIEMENS_ISI_AttachIDMessageCount),
		// new DcmDataDictionaryElement (0x0003, 0x0013, VRCODE_DA, "Attach ID Date", DD_SIEMENS_ISI_AttachIDDate),
		// new DcmDataDictionaryElement (0x0003, 0x0014, VRCODE_TM, "Attach ID Time", DD_SIEMENS_ISI_AttachIDTime),
		// new DcmDataDictionaryElement (0x0003, 0x0020, VRCODE_US, "Message Type", DD_SIEMENS_ISI_MessageType),
		// new DcmDataDictionaryElement (0x0003, 0x0030, VRCODE_DA, "Max Waiting Date", DD_SIEMENS_ISI_MaxWaitingDate),
		// new DcmDataDictionaryElement (0x0003, 0x0031, VRCODE_TM, "Max Waiting Time", DD_SIEMENS_ISI_MaxWaitingTime),
		// new DcmDataDictionaryElement (0x0009, 0x0026, VRCODE_DA, "Last Move Date", DD_SIEMENS_CM_VA0__CMS_LastMoveDate),
		// new DcmDataDictionaryElement (0x0009, 0x0027, VRCODE_TM, "Last Move Time", DD_SIEMENS_CM_VA0__CMS_LastMoveTime),
		// new DcmDataDictionaryElement (0x0009, 0x0032, VRCODE_LT, "SIEMENS_CT_VA0__IDE Attribute (0x0009, 0x0032)", DD_SIEMENS_CT_VA0__IDE_0x0009_0x0032),
		// new DcmDataDictionaryElement (0x0009, 0x00f6, VRCODE_LT, "PDM Data Object Type Extension", DD_SIEMENS_MED_PDMDataObjectTypeExtension),
		// new DcmDataDictionaryElement (0x0011, 0x0003, VRCODE_LT, "Patient UID", DD_SIEMENS_ISI_PatientUID),
		// new DcmDataDictionaryElement (0x0011, 0x0004, VRCODE_LT, "Patient ID", DD_SIEMENS_ISI_PatientID2),
		// new DcmDataDictionaryElement (0x0011, 0x000a, VRCODE_LT, "Case ID", DD_SIEMENS_ISI_CaseID),
		// new DcmDataDictionaryElement (0x0011, 0x0025, VRCODE_US, "SIEMENS_RA_GEN Attribute (0x0011, 0x0025)", DD_SIEMENS_RA_GEN_0x0011_0x0025),
		// new DcmDataDictionaryElement (0x0011, 0x0035, VRCODE_LT, "SIEMENS_RA_GEN Attribute (0x0011, 0x0035)", DD_SIEMENS_RA_GEN_0x0011_0x0035),
		// new DcmDataDictionaryElement (0x0011, 0x0041, VRCODE_LT, "Medical Alerts", DD_SIEMENS_RIS_MedicalAlerts2),
		// new DcmDataDictionaryElement (0x0011, 0x0042, VRCODE_LT, "Contrast Allergies", DD_SIEMENS_RIS_ContrastAllergies2),
		// new DcmDataDictionaryElement (0x0011, 0x00a1, VRCODE_DA, "Patient Registration Date", DD_SIEMENS_ISI_PatientRegistrationDate2),
		// new DcmDataDictionaryElement (0x0011, 0x00a2, VRCODE_TM, "Patient Registration Time", DD_SIEMENS_ISI_PatientRegistrationTime),
		// new DcmDataDictionaryElement (0x0011, 0x00b0, VRCODE_LT, "Patient Last Name", DD_SIEMENS_ISI_PatientLastName),
		// new DcmDataDictionaryElement (0x0011, 0x00b2, VRCODE_LT, "Patient First Name", DD_SIEMENS_ISI_PatientFirstName),
		// new DcmDataDictionaryElement (0x0011, 0x00b4, VRCODE_LT, "Patient Hospital Status", DD_SIEMENS_ISI_PatientHospitalStatus),
		// new DcmDataDictionaryElement (0x0011, 0x00bc, VRCODE_TM, "Current Location Time", DD_SIEMENS_ISI_CurrentLocationTime),
		// new DcmDataDictionaryElement (0x0011, 0x00c0, VRCODE_LT, "Patient Insurance Status", DD_SIEMENS_ISI_PatientInsuranceStatus),
		// new DcmDataDictionaryElement (0x0011, 0x00d0, VRCODE_LT, "Patient Billing Type", DD_SIEMENS_ISI_PatientBillingType),
		// new DcmDataDictionaryElement (0x0011, 0x00d2, VRCODE_LT, "Patient Billing Address", DD_SIEMENS_ISI_PatientBillingAddress),
		// new DcmDataDictionaryElement (0x0013, 0x0000, VRCODE_LT, "Modifying Physician", DD_SIEMENS_CM_VA0__CMS_ModifyingPhysician),
		// new DcmDataDictionaryElement (0x0013, 0x0010, VRCODE_DA, "Modification Date", DD_SIEMENS_CM_VA0__CMS_ModificationDate),
		// new DcmDataDictionaryElement (0x0013, 0x0012, VRCODE_TM, "Modification Time", DD_SIEMENS_CM_VA0__CMS_ModificationTime),
		// new DcmDataDictionaryElement (0x0013, 0x0020, VRCODE_LT, "Patient Name", DD_SIEMENS_CM_VA0__CMS_PatientName2),
		// new DcmDataDictionaryElement (0x0013, 0x0022, VRCODE_LT, "Patient Id", DD_SIEMENS_CM_VA0__CMS_PatientId),
		// new DcmDataDictionaryElement (0x0013, 0x0030, VRCODE_DA, "Patient Birthdate", DD_SIEMENS_CM_VA0__CMS_PatientBirthdate),
		// new DcmDataDictionaryElement (0x0013, 0x0031, VRCODE_DS, "Patient Weight", DD_SIEMENS_CM_VA0__CMS_PatientWeight2),
		// new DcmDataDictionaryElement (0x0013, 0x0032, VRCODE_LT, "Patients Maiden Name", DD_SIEMENS_CM_VA0__CMS_PatientsMaidenName),
		// new DcmDataDictionaryElement (0x0013, 0x0033, VRCODE_LT, "Referring Physician", DD_SIEMENS_CM_VA0__CMS_ReferringPhysician),
		// new DcmDataDictionaryElement (0x0013, 0x0034, VRCODE_LT, "Admitting Diagnosis", DD_SIEMENS_CM_VA0__CMS_AdmittingDiagnosis),
		// new DcmDataDictionaryElement (0x0013, 0x0035, VRCODE_LT, "Patient Sex", DD_SIEMENS_CM_VA0__CMS_PatientSex2),
		// new DcmDataDictionaryElement (0x0013, 0x0040, VRCODE_LT, "Procedure Description", DD_SIEMENS_CM_VA0__CMS_ProcedureDescription),
		// new DcmDataDictionaryElement (0x0013, 0x0042, VRCODE_LT, "Patient Rest Direction", DD_SIEMENS_CM_VA0__CMS_PatientRestDirection),
		// new DcmDataDictionaryElement (0x0013, 0x0044, VRCODE_LT, "Patient Position", DD_SIEMENS_CM_VA0__CMS_PatientPosition),
		// new DcmDataDictionaryElement (0x0013, 0x0046, VRCODE_LT, "View Direction", DD_SIEMENS_CM_VA0__CMS_ViewDirection),
		// new DcmDataDictionaryElement (0x0019, 0x0053, VRCODE_LT, "Barcode", DD_SIEMENS_DLR_01_Barcode),
		// new DcmDataDictionaryElement (0x0019, 0x0055, VRCODE_DS, "Receiver Reference Gain", DD_SIEMENS_MR_VA0__COAD_ReceiverReferenceGain),
		// new DcmDataDictionaryElement (0x0019, 0x0097, VRCODE_UL, "Coil Class Mask", DD_SIEMENS_MR_VA0__GEN_CoilClassMask),
		// new DcmDataDictionaryElement (0x0019, 0x00c1, VRCODE_DS, "EPI Capacity", DD_SIEMENS_MR_VA0__COAD_EPICapacity),
		// new DcmDataDictionaryElement (0x0019, 0x00d1, VRCODE_DS, "Flow Sensitivity", DD_SIEMENS_MR_VA0__COAD_FlowSensitivity),
		// new DcmDataDictionaryElement (0x0019, 0x00da, VRCODE_LT, "PhaseCodingDirection", DD_SIEMENS_MR_VA0__COAD_PhaseCodingDirection),
		// new DcmDataDictionaryElement (0x0021, 0x0004, VRCODE_DS, "VOI Position", DD_SIEMENS_MR_VA0__RAW_VOIPosition),
		// new DcmDataDictionaryElement (0x0021, 0x0005, VRCODE_DS, "VOI Size", DD_SIEMENS_MR_VA0__RAW_VOISize),
		// new DcmDataDictionaryElement (0x0021, 0x0006, VRCODE_IS, "CSI Matrix Size Original", DD_SIEMENS_MR_VA0__RAW_CSIMatrixSizeOriginal),
		// new DcmDataDictionaryElement (0x0021, 0x0007, VRCODE_IS, "CSI Matrix Size Extended", DD_SIEMENS_MR_VA0__RAW_CSIMatrixSizeExtended),
		// new DcmDataDictionaryElement (0x0021, 0x0008, VRCODE_DS, "Spatial Grid Shift", DD_SIEMENS_MR_VA0__RAW_SpatialGridShift),
		// new DcmDataDictionaryElement (0x0021, 0x0009, VRCODE_DS, "Signal Limits Minimum", DD_SIEMENS_MR_VA0__RAW_SignalLimitsMinimum),
		// new DcmDataDictionaryElement (0x0021, 0x0016, VRCODE_DS, "EPI Time Rate of Change Legal Limit 1", DD_SIEMENS_MR_VA0__RAW_EPITimeRateOfChangeLegalLimit1),
		// new DcmDataDictionaryElement (0x0021, 0x0017, VRCODE_DS, "EPI Operation Mode Flag", DD_SIEMENS_MR_VA0__RAW_EPIOperationModeFlag),
		// new DcmDataDictionaryElement (0x0021, 0x0018, VRCODE_DS, "EPI Field Calculation Safety Factor", DD_SIEMENS_MR_VA0__RAW_EPIFieldCalculationSafetyFactor),
		// new DcmDataDictionaryElement (0x0021, 0x0019, VRCODE_DS, "EPI Legal Limit 1 of Change Value", DD_SIEMENS_MR_VA0__RAW_EPILegalLimit1OfChangeValue),
		// new DcmDataDictionaryElement (0x0021, 0x0025, VRCODE_US, "SIEMENS_RA_GEN Attribute (0x0021, 0x0025)", DD_SIEMENS_RA_GEN_0x0021_0x0025),
		// new DcmDataDictionaryElement (0x0021, 0x0026, VRCODE_IS, "Image Pixel Offset", DD_SIEMENS_CM_VA0__CMS_ImagePixelOffset),
		// new DcmDataDictionaryElement (0x0021, 0x0039, VRCODE_DS, "Slab Thickness", DD_SIEMENS_MR_VA0__GEN_SlabThickness),
		// new DcmDataDictionaryElement (0x0021, 0x0055, VRCODE_DS, "Saturation Distance", DD_SIEMENS_MR_VA0__RAW_SaturationDistance),
		// new DcmDataDictionaryElement (0x0021, 0x0056, VRCODE_DS, "Repetition Time Effective", DD_SIEMENS_MR_VA0__GEN_RepetitionTimeEffective),
		// new DcmDataDictionaryElement (0x0021, 0x0057, VRCODE_LT, "Gate Phase", DD_SIEMENS_MR_VA0__GEN_GatePhase),
		// new DcmDataDictionaryElement (0x0021, 0x0058, VRCODE_DS, "Gate Threshold", DD_SIEMENS_MR_VA0__GEN_GateThreshold),
		// new DcmDataDictionaryElement (0x0021, 0x0059, VRCODE_DS, "Gated Ratio", DD_SIEMENS_MR_VA0__GEN_GatedRatio),
		// new DcmDataDictionaryElement (0x0021, 0x0063, VRCODE_DS, "Image Distance", DD_SIEMENS_CM_VA0__CMS_ImageDistance),
		// new DcmDataDictionaryElement (0x0021, 0x0065, VRCODE_US, "Image Positioning History Mask", DD_SIEMENS_CM_VA0__CMS_ImagePositioningHistoryMask),
		// new DcmDataDictionaryElement (0x0021, 0x006a, VRCODE_DS, "Image Row", DD_SIEMENS_CM_VA0__CMS_ImageRow),
		// new DcmDataDictionaryElement (0x0021, 0x006b, VRCODE_DS, "Image Column", DD_SIEMENS_CM_VA0__CMS_ImageColumn),
		// new DcmDataDictionaryElement (0x0021, 0x0073, VRCODE_DS, "Second Repetition Time", DD_SIEMENS_MR_VA0__GEN_SecondRepetitionTime),
		// new DcmDataDictionaryElement (0x0021, 0x0075, VRCODE_DS, "Light Brightness", DD_SIEMENS_CT_VA0__GEN_LightBrightness),
		// new DcmDataDictionaryElement (0x0021, 0x0076, VRCODE_DS, "Light Contrast", DD_SIEMENS_CT_VA0__GEN_LightContrast),
		// new DcmDataDictionaryElement (0x0021, 0x007a, VRCODE_IS, "Overlay Threshold", DD_SIEMENS_CT_VA0__GEN_OverlayThreshold),
		// new DcmDataDictionaryElement (0x0021, 0x007b, VRCODE_IS, "Surface Threshold", DD_SIEMENS_CT_VA0__GEN_SurfaceThreshold),
		// new DcmDataDictionaryElement (0x0021, 0x007c, VRCODE_IS, "Grey Scale Threshold", DD_SIEMENS_CT_VA0__GEN_GreyScaleThreshold),
		// new DcmDataDictionaryElement (0x0021, 0x0091, VRCODE_DS, "Saturation PhaseEncoding Vector Transverse Component", DD_SIEMENS_MR_VA0__GEN_SaturationPhaseEncodingVectorTransverseComponent),
		// new DcmDataDictionaryElement (0x0021, 0x0092, VRCODE_DS, "Saturation Readout Vector Transverse Component", DD_SIEMENS_MR_VA0__GEN_SaturationReadoutVectorTransverseComponent),
		// new DcmDataDictionaryElement (0x0021, 0x0093, VRCODE_DS, "EPI Change Value of Magnitude", DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfMagnitude),
		// new DcmDataDictionaryElement (0x0021, 0x0094, VRCODE_DS, "EPI Change Value of X Component", DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfXComponent),
		// new DcmDataDictionaryElement (0x0021, 0x0095, VRCODE_DS, "EPI Change Value of Y Component", DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfYComponent),
		// new DcmDataDictionaryElement (0x0021, 0x0096, VRCODE_DS, "EPI Change Value of Z Component", DD_SIEMENS_MR_VA0__GEN_EPIChangeValueOfZComponent),
		// new DcmDataDictionaryElement (0x0021, 0x00a7, VRCODE_LT, "SIEMENS_CT_VA0__GEN Attribute (0x0021, 0x00a7)", DD_SIEMENS_CT_VA0__GEN_0x0021_0x00a7),
		// new DcmDataDictionaryElement (0x0029, 0x0013, VRCODE_LT, "SIEMENS_CM_VA0__CMS Attribute (0x0029, 0x0013)", DD_SIEMENS_CM_VA0__CMS_0x0029_0x0013),
		// new DcmDataDictionaryElement (0x0029, 0x0015, VRCODE_LT, "List of Shadow Owner Codes", DD_SIEMENS_MED_HG_ListOfShadowOwnerCodes),
		// new DcmDataDictionaryElement (0x0029, 0x0021, VRCODE_US, "SIEMENS_MED_DISPLAY Attribute (0x0029, 0x0021)", DD_SIEMENS_MED_DISPLAY_0x0029_0x0021),
		// new DcmDataDictionaryElement (0x0029, 0x0022, VRCODE_IS, "Pixel Quality Value", DD_SIEMENS_CM_VA0__CMS_PixelQualityValue),
		// new DcmDataDictionaryElement (0x0029, 0x0051, VRCODE_LT, "Exposure Code", DD_SIEMENS_CM_VA0__CMS_ExposureCode),
		// new DcmDataDictionaryElement (0x0029, 0x0052, VRCODE_LT, "Sort Code", DD_SIEMENS_CM_VA0__CMS_SortCode),
		// new DcmDataDictionaryElement (0x0029, 0x0053, VRCODE_LT, "SIEMENS_CM_VA0__CMS Attribute (0x0029, 0x0053)", DD_SIEMENS_CM_VA0__CMS_0x0029_0x0053),
		// new DcmDataDictionaryElement (0x0029, 0x0099, VRCODE_LT, "Shutter Type", DD_SIEMENS_MED_DISPLAY_ShutterType),
		// new DcmDataDictionaryElement (0x0029, 0x00a0, VRCODE_US, "Rows of Rectangular Shutter", DD_SIEMENS_MED_DISPLAY_RowsOfRectangularShutter),
		// new DcmDataDictionaryElement (0x0029, 0x00a1, VRCODE_US, "Columns of Rectangular Shutter", DD_SIEMENS_MED_DISPLAY_ColumnsOfRectangularShutter),
		// new DcmDataDictionaryElement (0x0029, 0x00a2, VRCODE_US, "Origin of Rectangular Shutter", DD_SIEMENS_MED_DISPLAY_OriginOfRectangularShutter),
		// new DcmDataDictionaryElement (0x0029, 0x00b0, VRCODE_US, "Radius of Circular Shutter", DD_SIEMENS_MED_DISPLAY_RadiusOfCircularShutter2),
		// new DcmDataDictionaryElement (0x0029, 0x00b2, VRCODE_US, "Origin of Circular Shutter", DD_SIEMENS_MED_DISPLAY_OriginOfCircularShutter),
		// new DcmDataDictionaryElement (0x0031, 0x0010, VRCODE_LT, "Request UID", DD_SIEMENS_RIS_RequestUID),
		// new DcmDataDictionaryElement (0x0031, 0x0012, VRCODE_LT, "Examination Reason", DD_SIEMENS_ISI_ExaminationReason),
		// new DcmDataDictionaryElement (0x0031, 0x0030, VRCODE_DA, "Requested Date", DD_SIEMENS_ISI_RequestedDate),
		// new DcmDataDictionaryElement (0x0031, 0x0032, VRCODE_TM, "Worklist Request Start Time", DD_SIEMENS_ISI_WorklistRequestStartTime),
		// new DcmDataDictionaryElement (0x0031, 0x0033, VRCODE_TM, "Worklist Request End Time", DD_SIEMENS_ISI_WorklistRequestEndTime),
		// new DcmDataDictionaryElement (0x0031, 0x0045, VRCODE_LT, "Requesting Physician", DD_SIEMENS_RIS_RequestingPhysician),
		// new DcmDataDictionaryElement (0x0031, 0x004A, VRCODE_TM, "Requested Time", DD_SIEMENS_ISI_RequestedTime),
		// new DcmDataDictionaryElement (0x0031, 0x0050, VRCODE_LT, "Requested Physician", DD_SIEMENS_RIS_RequestedPhysician),
		// new DcmDataDictionaryElement (0x0031, 0x0080, VRCODE_LT, "Requested Location", DD_SIEMENS_ISI_RequestedLocation),
		// new DcmDataDictionaryElement (0x0033, 0x0010, VRCODE_LT, "Patient Study UID", DD_SIEMENS_RIS_PatientStudyUID),
		// new DcmDataDictionaryElement (0x0051, 0x0010, VRCODE_LT, "Image Text", DD_SIEMENS_CM_VA0__CMS_ImageText),
		// new DcmDataDictionaryElement (0x0055, 0x0046, VRCODE_LT, "Current Ward", DD_SIEMENS_ISI_CurrentWard),
		// new DcmDataDictionaryElement (0x0193, 0x0002, VRCODE_DS, "RIS Key", DD_SIEMENS_ISI_RISKey),
		// new DcmDataDictionaryElement (0x0307, 0x0001, VRCODE_UN, "RIS Worklist IMGEF", DD_SIEMENS_ISI_RISWorklistIMGEF),
		// new DcmDataDictionaryElement (0x0309, 0x0001, VRCODE_UN, "RIS Report IMGEF", DD_SIEMENS_ISI_RISReportIMGEF),
		// new DcmDataDictionaryElement (0x4009, 0x0001, VRCODE_LT, "Report ID", DD_SIEMENS_ISI_ReportID),
		// new DcmDataDictionaryElement (0x4009, 0x0020, VRCODE_LT, "Report Status", DD_SIEMENS_ISI_ReportStatus),
		// new DcmDataDictionaryElement (0x4009, 0x0030, VRCODE_DA, "Report Creation Date", DD_SIEMENS_ISI_ReportCreationDate),
		// new DcmDataDictionaryElement (0x4009, 0x0070, VRCODE_LT, "Report Approving Physician", DD_SIEMENS_ISI_ReportApprovingPhysician),
		// new DcmDataDictionaryElement (0x4009, 0x00e0, VRCODE_LT, "Report Text", DD_SIEMENS_ISI_ReportText),
		// new DcmDataDictionaryElement (0x4009, 0x00e1, VRCODE_LT, "Report Author", DD_SIEMENS_ISI_ReportAuthor),
		// new DcmDataDictionaryElement (0x4009, 0x00e3, VRCODE_LT, "Reporting Radiologist", DD_SIEMENS_ISI_ReportingRadiologist),
		// new DcmDataDictionaryElement (0x7001, 0x0010, VRCODE_LT, "Dummy", DD_SIEMENS_MED_Dummy),
		// new DcmDataDictionaryElement (0x7003, 0x0010, VRCODE_LT, "Header", DD_SIEMENS_MED_Header),
		// new DcmDataDictionaryElement (0x7005, 0x0010, VRCODE_LT, "Dummy", DD_SIEMENS_MED_Dummy2),
		// new DcmDataDictionaryElement (0x7fe1, 0x0000, VRCODE_OB, "Binary Data", DD_SIEMENS_CM_VA0__CMS_BinaryData),
		// new DcmDataDictionaryElement (0x7fe3, 0x0000, VRCODE_LT, "Image Graphics Format Code", DD_SIEMENS_NUMARIS_II_ImageGraphicsFormatCode2),
		// new DcmDataDictionaryElement (0x7fe3, 0x0010, VRCODE_OB, "Image Graphics", DD_SIEMENS_NUMARIS_II_ImageGraphics2),
		// new DcmDataDictionaryElement (0x7fe3, 0x0020, VRCODE_OB, "Image Graphics Dummy", DD_SIEMENS_NUMARIS_II_ImageGraphicsDummy),
		// new DcmDataDictionaryElement (0x0009, 0x0029, VRCODE_LT, "Actual User", DD_SIENET_ActualUser),
		// new DcmDataDictionaryElement (0x0095, 0x0001, VRCODE_LT, "Examination Folder ID", DD_SIENET_ExaminationFolderID),
		// new DcmDataDictionaryElement (0x0095, 0x0004, VRCODE_UL, "Folder Reported Status", DD_SIENET_FolderReportedStatus),
		// new DcmDataDictionaryElement (0x0095, 0x0005, VRCODE_LT, "Folder Reporting Radiologist", DD_SIENET_FolderReportingRadiologist),
		// new DcmDataDictionaryElement (0x0095, 0x0007, VRCODE_LT, "SIENET ISA PLA", DD_SIENET_SIENETISAPLA),
		// new DcmDataDictionaryElement (0x0099, 0x0002, VRCODE_UL, "Data Object Attributes", DD_SIENET_DataObjectAttributes),
		// new DcmDataDictionaryElement (0x0009, 0x0021, VRCODE_LT, "SPI_P_Release_1 Attribute (0x0009, 0x0021)", DD_SPI_P_Release_1_0x0009_0x0021),
		// new DcmDataDictionaryElement (0x0009, 0x0038, VRCODE_LT, "System Unique Identifier", DD_SPI_P_Release_1_SystemUniqueIdentifier),
		// new DcmDataDictionaryElement (0x0009, 0x0060, VRCODE_LT, "SPI_P_GV_CT_Release_1 Attribute (0x0009, 0x0060)", DD_SPI_P_GV_CT_Release_1_0x0009_0x0060),
		// new DcmDataDictionaryElement (0x0009, 0x0061, VRCODE_LT, "Series Unique Identifier", DD_SPI_P_Release_1_SeriesUniqueIdentifier),
		// new DcmDataDictionaryElement (0x0009, 0x0070, VRCODE_LT, "SPI_P_GV_CT_Release_1 Attribute (0x0009, 0x0070)", DD_SPI_P_GV_CT_Release_1_0x0009_0x0070),
		// new DcmDataDictionaryElement (0x0009, 0x0080, VRCODE_LT, "SPI_P_GV_CT_Release_1 Attribute (0x0009, 0x0080)", DD_SPI_P_GV_CT_Release_1_0x0009_0x0080),
		// new DcmDataDictionaryElement (0x0009, 0x0091, VRCODE_LT, "SPI_P_Release_1 Attribute (0x0009, 0x0091)", DD_SPI_P_Release_1_0x0009_0x0091),
		// new DcmDataDictionaryElement (0x0009, 0x00f2, VRCODE_UN, "SPI_P_Release_1 Attribute (0x0009, 0x00f2)", DD_SPI_P_Release_1_0x0009_0x00f2),
		// new DcmDataDictionaryElement (0x0009, 0x00f3, VRCODE_UN, "SPI_P_Release_1 Attribute (0x0009, 0x00f3)", DD_SPI_P_Release_1_0x0009_0x00f3),
		// new DcmDataDictionaryElement (0x0009, 0x00f4, VRCODE_LT, "SPI_P_Release_1 Attribute (0x0009, 0x00f4)", DD_SPI_P_Release_1_0x0009_0x00f4),
		// new DcmDataDictionaryElement (0x0011, 0x0032, VRCODE_UN, "SPI_P_Release_1 Attribute (0x0011, 0x0032)", DD_SPI_P_Release_1_0x0011_0x0032),
		// new DcmDataDictionaryElement (0x0021, 0x0090, VRCODE_DS, "SPI_P_GV_CT_Release_1 Attribute (0x0021, 0x0090)", DD_SPI_P_GV_CT_Release_1_0x0021_0x0090),
		// new DcmDataDictionaryElement (0x0021, 0x00a1, VRCODE_DS, "SPI_P_GV_CT_Release_1 Attribute (0x0021, 0x00a1)", DD_SPI_P_GV_CT_Release_1_0x0021_0x00a1),
		// new DcmDataDictionaryElement (0x0021, 0x00a3, VRCODE_LT, "SPI_P_GV_CT_Release_1 Attribute (0x0021, 0x00a3)", DD_SPI_P_GV_CT_Release_1_0x0021_0x00a3),
		// new DcmDataDictionaryElement (0x0021, 0x00a4, VRCODE_LT, "SPI_P_GV_CT_Release_1 Attribute (0x0021, 0x00a4)", DD_SPI_P_GV_CT_Release_1_0x0021_0x00a4),
		// new DcmDataDictionaryElement (0x0021, 0x00b0, VRCODE_IS, "SPI_P_GV_CT_Release_1 Attribute (0x0021, 0x00b0)", DD_SPI_P_GV_CT_Release_1_0x0021_0x00b0),
		// new DcmDataDictionaryElement (0x0021, 0x00c0, VRCODE_IS, "SPI_P_GV_CT_Release_1 Attribute (0x0021, 0x00c0)", DD_SPI_P_GV_CT_Release_1_0x0021_0x00c0),
		// new DcmDataDictionaryElement (0x0029, 0x0005, VRCODE_US, "Convolution Kernel Size", DD_SPI_P_Release_1_3_ConvolutionKernelSize2),
		// new DcmDataDictionaryElement (0x0029, 0x0006, VRCODE_US, "Convolution Kernel", DD_SPI_P_Release_1_3_ConvolutionKernel2),
		// new DcmDataDictionaryElement (0x0029, 0x000e, VRCODE_CS, "Zoom Enable Status", DD_SPI_P_Release_1_1_ZoomEnableStatus),
		// new DcmDataDictionaryElement (0x0029, 0x000f, VRCODE_CS, "Zoom Select Status", DD_SPI_P_Release_1_1_ZoomSelectStatus),
		// new DcmDataDictionaryElement (0x0029, 0x0025, VRCODE_LT, "Processed Pixel Data Quality", DD_SPI_P_Release_1_ProcessedPixelDataQuality),
		// new DcmDataDictionaryElement (0x0029, 0x0038, VRCODE_US, "SPI_P_Release_1 Attribute (0x0029, 0x0038)", DD_SPI_P_Release_1_0x0029_0x0038),
		// new DcmDataDictionaryElement (0x0029, 0x0041, VRCODE_DS, "Magnifying Glass Rectangle", DD_SPI_P_Release_1_1_MagnifyingGlassRectangle),
		// new DcmDataDictionaryElement (0x0029, 0x0043, VRCODE_DS, "Magnifying Glass Factor", DD_SPI_P_Release_1_1_MagnifyingGlassFactor),
		// new DcmDataDictionaryElement (0x0029, 0x0044, VRCODE_US, "Magnifying Glass Function", DD_SPI_P_Release_1_1_MagnifyingGlassFunction),
		// new DcmDataDictionaryElement (0x0029, 0x004e, VRCODE_CS, "Magnifying Glass Enable Status", DD_SPI_P_Release_1_1_MagnifyingGlassEnableStatus),
		// new DcmDataDictionaryElement (0x0029, 0x004f, VRCODE_CS, "Magnifying Glass Select Status", DD_SPI_P_Release_1_1_MagnifyingGlassSelectStatus),
		// new DcmDataDictionaryElement (0x0029, 0x0067, VRCODE_LT, "SPI_P_Release_1 Attribute (0x0029, 0x0067)", DD_SPI_P_Release_1_0x0029_0x0067),
		// new DcmDataDictionaryElement (0x0029, 0x0077, VRCODE_CS, "Window Select Status", DD_SPI_P_Release_1_WindowSelectStatus),
		// new DcmDataDictionaryElement (0x0029, 0x0078, VRCODE_LT, "ECG Display Printing ID", DD_SPI_P_Release_1_ECGDisplayPrintingID),
		// new DcmDataDictionaryElement (0x0029, 0x0079, VRCODE_CS, "ECG Display Printing", DD_SPI_P_Release_1_ECGDisplayPrinting),
		// new DcmDataDictionaryElement (0x0029, 0x007e, VRCODE_CS, "ECG Display Printing Enable Status", DD_SPI_P_Release_1_ECGDisplayPrintingEnableStatus),
		// new DcmDataDictionaryElement (0x0029, 0x007f, VRCODE_CS, "ECG Display Printing Select Status", DD_SPI_P_Release_1_ECGDisplayPrintingSelectStatus),
		// new DcmDataDictionaryElement (0x0029, 0x008e, VRCODE_CS, "Physiological Display Enable Status", DD_SPI_P_Release_1_PhysiologicalDisplayEnableStatus),
		// new DcmDataDictionaryElement (0x0029, 0x008f, VRCODE_CS, "Physiological Display Select Status", DD_SPI_P_Release_1_PhysiologicalDisplaySelectStatus),
		// new DcmDataDictionaryElement (0x0029, 0x00c0, VRCODE_LT, "Functional Shutter ID", DD_SPI_P_Release_1_FunctionalShutterID),
		// new DcmDataDictionaryElement (0x0029, 0x00c5, VRCODE_LT, "Field Of Shutter Rectangle", DD_SPI_P_Release_1_FieldOfShutterRectangle),
		// new DcmDataDictionaryElement (0x0029, 0x00ce, VRCODE_CS, "Shutter Enable Status", DD_SPI_P_Release_1_ShutterEnableStatus),
		// new DcmDataDictionaryElement (0x0029, 0x00cf, VRCODE_CS, "Shutter Select Status", DD_SPI_P_Release_1_ShutterSelectStatus),
		// new DcmDataDictionaryElement (0x0029, 0x00d0, VRCODE_IS, "SPI_P_GV_CT_Release_1 Attribute (0x0029, 0x00d0)", DD_SPI_P_GV_CT_Release_1_0x0029_0x00d0),
		// new DcmDataDictionaryElement (0x0029, 0x00d1, VRCODE_IS, "SPI_P_GV_CT_Release_1 Attribute (0x0029, 0x00d1)", DD_SPI_P_GV_CT_Release_1_0x0029_0x00d1),
		// new DcmDataDictionaryElement (0x7FE1, 0x0010, VRCODE_OW_or_OB, "Pixel Data", DD_SPI_P_Release_1_PixelData2),
		// new DcmDataDictionaryElement (0x0011, 0x0002, VRCODE_US, "TOSHIBA_MEC_1_0 Attribute (0x0011, 0x0002)", DD_TOSHIBA_MEC_1_0_0x0011_0x0002),
		// new DcmDataDictionaryElement (0x7ff1, 0x0004, VRCODE_IS, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x0004)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0004),
		// new DcmDataDictionaryElement (0x7ff1, 0x0005, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x0005)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0005),
		// new DcmDataDictionaryElement (0x7ff1, 0x0007, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x0007)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0007),
		// new DcmDataDictionaryElement (0x7ff1, 0x0008, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x0008)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0008),
		// new DcmDataDictionaryElement (0x7ff1, 0x0009, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x0009)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x0009),
		// new DcmDataDictionaryElement (0x7ff1, 0x000a, VRCODE_LT, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x000a)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000a),
		// new DcmDataDictionaryElement (0x7ff1, 0x000b, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x000b)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000b),
		// new DcmDataDictionaryElement (0x7ff1, 0x000c, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x000c)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000c),
		// new DcmDataDictionaryElement (0x7ff1, 0x000d, VRCODE_US, "TOSHIBA_MEC_CT_1_0 Attribute (0x7ff1, 0x000d)", DD_TOSHIBA_MEC_CT_1_0_0x7ff1_0x000d),
		// new DcmDataDictionaryElement (0x7ff1, 0x0010, VRCODE_US, "TOSHIBA_MEC_1_0 Attribute (0x7ff1, 0x0010)", DD_TOSHIBA_MEC_1_0_0x7ff1_0x0010),
	};


	/**
	 * Die Methode sucht in der Hashtabelle nach dem uebergebenen Zugriffscode des
	 * DICOM-Parameters. Ist dieser bereits in der Hashtabelle vorhanden, so wird
	 * dessen Index zurueckgeliefert. Ansonsten wird der Parameter in die
	 * Hashtabelle aufgenommen und der neue Index zurueckgeliefert.
	 * @param type Der Zugriffscode des DICOM-Parameters
	 * @return
	 */
	private static int getHashtableIndex(int type) {
		Integer iType = new Integer(type);
		Integer index;
		int			i = -1;

		if (type == DD_UNDEFINED) {
			return (-1);
		} 

		// Wenn der Eintrag in der Hashtabelle gefunden wird, wird der Index dieses
		// Eintrags zurueckgeliefert.
		index = (Integer) typeIndexTable.get(iType);
		if (index != null) {
			i = index.intValue();
		} 

		// Ist der Eintrag nicht in der Hashtabelle vorhanden, so wird er dort
		// aufgenommen. Dazu wird zunaechst das entsprechende Element aus der Liste
		// bestimmt
		for (int j = 0; j < idList.length; j++) {
			if (idList[j].type == type) {
				addTypeToHashtable(idList[j].group, idList[j].element, type);
				return j;
			} 
		} 
		return i;
	}
 

	/**
	 * Nimmt einen neuen Type in die Hashtabel auf
	 * @param g     Gruppennummer (hat aktuelle keine Bedeutung)
	 * @param e     Elementnummer (hat aktuelle keine Bedeutung)
	 * @param type  Der Type der aufgenommen werden soll
	 */
	private static void addTypeToHashtable(int g, int e, int type) {
		typeIndexTable.put(new Integer(type), new Integer(lastSearch));
	}


	/**
	 * Die Methode liefert aus dem Dictionary die Gruppennummer fuer den Type
	 * des uebergebenen DICOM Elementes.
	 * @param type Der Type dessen Gruppennummer bestimmt werden soll
	 * @return 		 Die Gruppennummer
	 */
	public static int getDictGroup(int type) {
		int i;

		if ((i = getHashtableIndex(type)) >= 0) {
			return idList[i].group;
		} else {
			return (-1);
		}
	}
 

	/**
	 * Die Methode liefert aus dem Dictionary die Elementnummer fuer den Type
	 * des uebergebenen DICOM Elementes.
	 * @param type Der Type dessen Elementnummer bestimmt werden soll
	 * @return 		 Die Elementnummer
	 */
	public static int getDictElement(int type) {
		int i;

		if ((i = getHashtableIndex(type)) >= 0) {
			return idList[i].element;
		} else {
			return (-1);
		} 
	}


	/**
	 * Die Methode sucht im Dictionary den Type fuer ein Datenelement mit einer
	 * Gruppen- und Elementnummer.
	 * @param g Die Gruppennummer
	 * @param e Die Elementnummer
	 * @return  Der gefundene Type. Wird er nicht gefunden, wird der DD_UNDEFINED
	 * zurueckgeliefert
	 */
	public static int getDictType(int g, int e) {
		if (e == 0x0000) {
			return DD_GroupLength;
		} else {

			for (int i = 0; i < idList.length; i++) {
				if (g == idList[i].group) {
					if (e == idList[i].element) {
						lastSearch = i;
						int type = idList[i].type;

						return type;
					} 
				} 
			}
 
			return DD_UNDEFINED;
		}
	}


	/**
	 * Die Methode liefert die im Dictionary gefundenen Namen des
	 * Daten Elementes zurueck.
	 * @param type  Der Type des gesuchten Daten Elementes
	 * @return      Die Beschreibung
	 */
	public static String getDictName(int type) {
		int i;

		if ((i = getHashtableIndex(type)) >= 0) {
			return idList[i].name;
		} else {
			return (new String("Unknown"));
		}
	}


	/**
	 * Die Methode liefert einen eindeutigen VR-Code eines Daten Elementes
	 * zurueck.
	 * @param g 	Die Gruppennummer des Daten Elementes
	 * @param e 	Die Elementnummer des Daten Elementes
	 * @return 	  Der VR-Code des DICOM-Parameters
	 */
	public static int getDictVRCode(int g, int e) {
		return getDictVRCode(DcmDDE.getDictType(g, e));
	} 


	/**
	 * Die Methode liefert einen eindeutigen VR-Code eines Daten Elementes
	 * zurueck.
	 * Achtung: In PS 3.6 werden im Dictionary fuer einige Daten Elemente
	 * mehrere Moeglichkeiten fuer den Type Code genannt. Diese finden sich
	 * auch in DcmDataDictionaryElement wieder. Fuer die Kodierung der
	 * Dateien muss aber ein eindeutiger Code angegeben werden. Deshalb wird
	 * eine Umsetzung des definierten VR-Codes vorgenommen.
	 * @param type  Der Typ des Daten Elementes
	 * @return 		  Der VR-Code des DICOM-Parameters
	 */
	public static int getDictVRCode(int type) {
		int i;
		int vr;

		if ((i = getHashtableIndex(type)) >= 0) {
			vr = vrCodeDefToCode(idList[i].vrCodeDef);
		} else {
			vr = VRCODE_UNDEFINED;
		} 
		return vr;
	}
 

	/**
	 * Die Methode liefert fr eine DICOM VR-Code Definition einen eindeutigen
   * VR-Code zurueck.
	 * @param vrcd	Die DICOM Definition des VR-Codes
	 * @return		  Der eindeutige VR-Code
	 * @author		  Thomas Hacklaender
	 */
	public static int vrCodeDefToCode(int vrcd) {
		for (int i = 0; i < vrList.length; i++) {
			if (vrcd == vrList[i].vrCodeDef) {
				return vrList[i].vrCode;
			}
		}
		return VRCODE_UNDEFINED;
	}


	/**
	 * Die Methode liefert fr eine 2 Character lange DICOM Value-Representation
   * den internen VR-Code zurueck.
	 * @param vrs	 Die DICOM Value-Representation
	 * @return     Der VR-Code
	 * @author     Thomas Hacklaender
	 */
	public static int vrStringToCode(String vrs) {
		for (int i = 0; i < vrList.length; i++) {
			if (vrs.compareTo(vrList[i].vrString) == 0) {
				return vrList[i].vrCode;
			}
		}
		return VRCODE_UNDEFINED;
	}
 

	/**
	 * Die Methode liefert fr den internen VR-Code die 2 Character lange
   * DICOM Value-Representation zurueck.
	 * @param vr	Der VR-Code
	 * @return		Die Value-Representation
	 * @author		Thomas Hacklaender
	 */
	public static String vrCodeToString(int vr) {
		for (int i = 0; i < vrList.length; i++) {
			if (vr == vrList[i].vrCode) {
				return vrList[i].vrString;
			}
		}
		return "??";
	}

	/**
	* Wie die obigen getXXXX-Methoden, allerdings wird das
	* DcmDataDictionaryElement zurckgeliefert. Diese Methode
	* steht nur als Hilfe fr das Packet dcm zur Verfgung
	*/
	protected static DcmDataDictionaryElement get(int type) {
		int i;

		if ((i = getHashtableIndex(type)) >= 0) {
			return idList[i];
		} else {
			return null;
		}
	}

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

