/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * Christian Schalla
 * Andreas Truemper
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.dicom.dcm;


/**
 * Die Klasse repraesentiert einen Eintrag im Woerterbuch der Daten-Elemente
 * in der Klasse DcmDDE (entsprechend PS 3.6 Data Dictionary).
 * <DL><DT><B>Modifications: </B><DD>
 * ans  2000.10.28: Cloneable/Serializable hinzugefgt, CopyConstructor, equals(), toString()
 * </DD></DL>
 * @author   Christian Schalla
 * @author   Andreas Truemper
 * @version  2000.05.04
 */
public class DcmDataDictionaryElement implements Cloneable, java.io.Serializable {


	/**
	 * Gruppennummer
	 */
	int			group;


	/**
	 * Elementnummer
	 */
	int			element;


	/**
	 * Attributtype
	 */
	int			type;


	/**
	 * Value representation
	 */
	int			vrCodeDef;


	/**
	 * Attributname
	 */
	String	name;


	/**
	 * Konstruktor zum Erzeugen eines neuen Woerterbucheintrags.
	 * @param g  Gruppennummer
	 * @param e  Elementnummer
	 * @param v  Value Representation Code
	 * @param n  Name
	 * @param t  Typ
	 */
	protected DcmDataDictionaryElement(int g, int e, int v, String n, int t) {
		group = g;
		element = e;
		vrCodeDef = v;
		name = n;
		type = t;
	}


	/**
	 * Copy-Konstruktor zum Erzeugen eines neuen Woerterbucheintrags.
	 * @param el Zu kopierendes Dictionary Element
	 */
	public DcmDataDictionaryElement(DcmDataDictionaryElement el) {
		group = el.group;
		element = el.element;
		vrCodeDef = el.vrCodeDef;
		name = new String(el.name);
		type = el.type;
	}


	/**
	 * Clone-Methode, liefert eine Kopie
	 * @return Kopie des Dictionary Elements.
	 */
	public Object clone() {
		return new DcmDataDictionaryElement(this);
	} 


	/**
	 * Vergleicht zwei Wrterbuchelemente
	 * @return Liefert TRUE, wenn Gruppen- und Elementnummer bereinstimmen.
	 */
	public boolean equals(Object o) {
		if ((o instanceof DcmDataDictionaryElement) == false) {
			throw new IllegalArgumentException();
		} 
		DcmDataDictionaryElement	e = (DcmDataDictionaryElement) o;

		return ((e.group == group) && (e.element == element));
	} 


	/**
	 * Vergleicht dieses DictionaryElement mit der geg. Gruppen/Elementnummer
	 * @return TRUE bei Uebereinstimmung
	 */
	public boolean equalsGroupElem(int egroup, int eelement) {
		return ((egroup == group) && (eelement == element));
	} 


	/**
	 * @return Liefert eine Stringreprsentation (zum Dumpen)
	 */
	public String toString() {
		return "(" + group + "," + element + ")  " + type + "/" + vrCodeDef + "  " + name;
	} 


}



/*--- formatting done in "My Own Convention" style on 11-11-2000 ---*/

