/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * Christian Schalla
 * Andreas Truemper
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.dicom.dcm;

import java.util.*;


/**
 * Die Klasse repraesentiert eine Hashtabelle von DICOM-Datenelementen, die alle in
 * der gleichen Gruppe sind. Die einzige Erweiterung gegenueber einer herkoemmlichen
 * Hashtabelle ist die, dass es eine Instanzvariable gibt, die die Laenge der
 * Hashtabelle (und damit der Gruppe) speichert.
 * 
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * </DD></DL>
 * @author   Christian Schalla
 * @author   Andreas Truemper
 * @version  2000.05.04
 */
public class DcmElements extends Hashtable {

	/* Die Laenge der Gruppe in Byte unter Bercksichtigung der Transfersyntax */
	private int length = 0;


	/**
	 * Liefert Die Laenge der Gruppe in Byte.
	 * @return Die Laenge der Gruppe in Byte
	 */
	protected int getLength() {
		return length;
	} 


	/**
	 * Addiert zur Laenge der Gruppe die Laenge eines DcmValues. Dabei wird der
	 * VR des Elementes und die Transfersyntax beruecksichtigt.
	 * @param dv	Das DcmValue Objekt, dessen Laenge addiert werden soll.
	 * @param st  Die Structure der Transfersyntax fuer das DcmValue.
	 * @author    Thomas Hacklaender
	 */
	protected void addLength(DcmValue dv, int st) {
		length += calcLength(dv, st);
	} 


	/**
	 * Subtrahiert zur Laenge der Gruppe die Laenge eines DcmValues. Dabei wird der
	 * VR des Elementes und die Transfersyntax beruecksichtigt.
	 * @param dv	Das DcmValue Objekt, dessen Laenge subtrahiert werden soll.
	 * @param st  Die Structure der Transfersyntax fuer das DcmValue.
	 * @author    Thomas Hacklaender
	 */
	protected void subLength(DcmValue dv, int st) {
		length -= calcLength(dv, st);
	} 


	/**
	 * Berechnet die korrekte Laenge eines DcmValues fuer die externe Speicherung.
	 * Dabei wird der VR des Elementes und die Transfersyntax beruecksichtigt.
	 * @param dv	Das DcmValue Objekt, dessen Laenge subtrahiert werden soll.
	 * @param st  Die Structure der Transfersyntax fuer das DcmValue.
	 * @return    Die korrekte Laenge in Byte
	 * @author    Thomas Hacklaender
	 */
	protected int calcLength(DcmValue dv, int st) {
		int l;
		int vr;

		if (dv == null) {
			return 0;

		} 
		l = dv.getData().length;
		vr = dv.getVR();

		// Alle Daten Elemente werden extern auf eine gerade Laenge aufgefuellt.
		// Deshalb muss auch hier die Elementlaenge ggf. um eins erhoeht werden.
		if ((l % 2) == 1) {
			l++;
		} 

		// Fuer alle Transfersyntaces muessen mindestens 8 Byte Headerinformationen
		// fuer jedes Daten Element beruecksichtigt (PS 3.5-7.1).
		l += 8;

		// Fuer spezielle Type Codes ist der Header bei expliziter Structure um 4
		// Byte laenger (PS 3.5-7.1.2).
		if (st == DcmDataObject.EXPLICITE_VR) {
			if ((vr == DcmDDE.VRCODE_OB) | (vr == DcmDDE.VRCODE_OW) | (vr == DcmDDE.VRCODE_SQ)) {
				l += 4;
			} 
		} 

		return l;
	} 

}




/*--- formatting done in "My Own Convention" style on 11-11-2000 ---*/

