/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.dicom.dcm;


/**
 * Definition von Konstanten fuer das gesamte Package rad.dicom.*.
 * Insbesonder werden hier UID's definiert: <br>
 * Eine UID (Unique Identifier, PS 3.5-9) setzt sich folgendermassen
 * zusammen:  UID = <org root>.<suffix> <br>
 * <org root> = "1.2.840.10008" ist fuer DICOM reserviert. Man kann
 * einen eigenen String registrieren lassen (wo?). <br>
 * Fuer dieses Package wird durchgaengig die <org root> = DcmUID.ORG_ROOT_UID
 * verwendet. <br>
 * Die verschiedenen Klassen der UIDs werden durch die erste Zahl des
 * <suffix> unterschieden. Die weitere Differenzierung der UIDs
 * erfolgt durch Anhaengen weiterer Zahlen an den primaeren Suffix.
 * @author   Thomas Hacklaender
 * @version  2002.05.12
 */
public interface DcmUID {


	/**
	 * Die aktuelle Versionsnummer des package
	 */
	public static final String	DCM_VERSION = "2.5";


	/**
	 * Der gemeinsame Anfangsteil aller UID dieser Software.
	 */
	public static final String	ORG_ROOT_UID = "1.2.3.4711";


	/**
	 * Suffix fuer Studies
	 */
	public static final String	STUDY_UID_SUFFIX = ".1";


	/**
	 * Suffix fuer Serien
	 */
	public static final String	SERIES_UID_SUFFIX = ".2";


	/**
	 * Suffix fuer die SOP UID (PS 3.7-D3.3.2)
	 */
	public static final String	SOP_UID_SUFFIX = ".3";


	/**
	 * Suffix fuer die Implementation UID (PS 3.7-D3.3.2)
	 */
	public static final String	IMPLEMENTATION_UID_SUFFIX = ".4";


	/**
	 * Suffix fuer Property-Fields in ImageJ
	 */
	public static final String	PROPERTY_UID_SUFFIX = ".5";


	/**
	 * Little Endian Implicite Transfersyntax UIDs nach PS 3.5-A
	 */
	public static final String	LI_IM_TRANSFER_UID = "1.2.840.10008.1.2";


	/**
	 * Little Endian Explicite Transfersyntax UIDs nach PS 3.5-A
	 */
	public static final String	LI_EX_TRANSFER_UID = "1.2.840.10008.1.2.1";


	/**
	 * Big Endian Explicite Transfersyntax UIDs nach PS 3.5-A
	 */
	public static final String	BI_EX_TRANSFER_UID = "1.2.840.10008.1.2.2";


	/**
	 * CT Media Storage Standard SOP Classes nach PS 3.4-I.4
	 */
	public static final String	CT_STORAGE_UID = "1.2.840.10008.5.1.4.1.1.2";


	/**
	 * MR Media Storage Standard SOP Classes nach PS 3.4-I.4
	 */
	public static final String	MR_STORAGE_UID = "1.2.840.10008.5.1.4.1.1.4";


	/**
	 * SC Media Storage Standard SOP Classes nach PS 3.4-I.4
	 */
	public static final String	SC_STORAGE_UID = "1.2.840.10008.5.1.4.1.1.7";


	/**
	 * Der Name des Property-Fields, in dem in ImageJ die DICOM Header
	 * Informationen in String Darstellung gespeichert werden.
	 */
	public static final String	DCM_STRING_HEADER_PROPERTY = ORG_ROOT_UID + PROPERTY_UID_SUFFIX + ".1";


	/**
	 * Der Name des Property-Fields, in dem in ImageJ die DICOM Header
	 * Informationen als DcmDataObject gespeichert werden.
	 */
	public static final String	DCM_BIN_HEADER_PROPERTY = ORG_ROOT_UID + PROPERTY_UID_SUFFIX + ".2";

}




/*--- formatting done in "My Own Convention" style on 11-11-2000 ---*/

