/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * Christian Schalla
 * Andreas Truemper
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.dicom.dcm;


/**
 * Die Klasse repraesentiert einen Eintrag im Woerterbuch der VR-Elemente
 * in der Klasse DcmDDE.
 * @author   Thomas Hacklaender
 * @version  2000.05.08
 */
public class DcmVRDictionaryElement {

	int			vrCodeDef;
	int			vrCode;
  String	vrString;


	/**
	 * Konstruktor zum Erzeugen eines neuen Woerterbucheintrags.
	 * @param d  Definition des VR-Code in der DICOM Norm
	 * @param c  VR-Code, der als Ergebnis einer Anfrage ans Woerterbuch geliefert wird
	 * @param s  VR-String, der als Ergebnis einer Anfrage ans Woerterbuch geliefert wird
	 */
	protected DcmVRDictionaryElement(int d, int c, String s) {
		vrCodeDef = d;
		vrCode = c;
		vrString = s;
	}

}

