/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * This Class is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions in MRT-Images
 * of the Kidneys.
 *
 * Copyright (C) 1999 / 2000 Jens Martin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// 2000.8.2 tha: package jm;

import jm.kidney.*;
import ij.*;
import ij.gui.*;
import ij.plugin.*;


/**
 * Implementiert die Plugin-Schnittstelle von ImageJ.
 * Ruft das Plugin zur Renalen Funktionsanalyse auf.
 * @see jm.kidney.AnalysisDailog
 * @version  2.0, 14/02/2000
 * @author   Jens Martin
 */
public class Renal_Function_Analysis extends ImagePlus implements PlugIn {
  private ImageWindow win = null;
  private ImagePlus		imp = null;
  private int					imageType = 0;
  private ImageStack	newStack = null;
  
  
  /**
   * Der Konstruktor. Wird fuer diese Klasse nur benoetigt, damit das Debugging
   * funktioniert. Ansonsten ohne weitere Funktion.
   */
  public Renal_Function_Analysis() {
    
    // nix machen
  }
  
  
  /**
   * Wird Aufgerufen, wenn das Plugin gestartet wird.
   * Der Parameter 'arg' wird vin ImageJ uebergeben.
   * @param arg Uebergebener String, kann leer sein. Wird nicht weiter beruecksichtigt.
   */
  public void run(String arg) {
    imp = WindowManager.getCurrentImage();
    if (imp != null) {
      if (!imp.lock()) {
        return;		// exit if image is in use
      }
      win = imp.getWindow();
    }
    
    if (win == null) {
      IJ.error("There are no images open !");
      return;
      
      // es ist wohl kein Fenster vorhanden !
    }
    
    // If there is a Window, test the Type of Image
    // Supported: GRAY 8,16,32   Not Supported: the Rest
    imageType = imp.getType();
    if (imageType == imp.COLOR_RGB || imageType == imp.COLOR_256) {
      IJ.error("Kidney Analysis is limited to \n8bit Gray, 16bit Gray, or 32bit Gray Dicom-Images !");
      return;
    }
    
    if (imp.getStackSize() <= 1) {
      IJ.error("DICOM-Image is single, no series.\n\nPlease load a series consisting of 2 or more Images !");
      return;
    }
    AnalysisDialog	dlg = new AnalysisDialog(win);
  }
  
}


/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

