/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.cepstrum is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.cepstrum;

import java.io.*;


/**
 * Ermoeglicht das Schreiben von Strings in eine Protokolldatei.
 * Eine sehr einfache Mutual Exclusion wird dadurch erreich,
 * indem das LogFile ienfach nach jedem Schreibzugriff wieder
 * geschlossen wird und sich das Klassenobjekt selbst loescht.
 * @see jm.cepstrum.CepstrumAnalysis
 * @see jm.cepstrum.Cepstrum
 * @version  1.0, 14/02/2000
 * @author   Jens Martin
 */
public class ResultLog {
	Writer	w = null;


	/**
	 * Der Konstruktor.
	 * @param fileName Name der Protokolldatei
	 */
	public ResultLog(String fileName) {
		try {
			w = new FileWriter(fileName, true);
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} 
	}


	/**
	 * Schreibt einen String an das Ende des Logfiles.
	 * @param str Zur schreibender String
	 */
	public void append(String str) {
		if (str.length() > 0) {
			try {
				if (!(str.endsWith("\n") || str.endsWith("|"))) {
					str = str + "|";
				} 
				w.write(str);
			} catch (IOException ioe) {
				ioe.printStackTrace();
			} 
		} 

		try {
			w.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} 
	} 

}


/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

