/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

import jm.kidney.*;

import java.awt.*;
import java.util.Properties;
import java.awt.event.*;

import ij.gui.*;

import javax.swing.*;


/**
 * Zeigt einen kleinen Dialog zur Abfrage, ob ROIs fuer ein Bild oder alle
 * Bilder der Sequenz festgelegt werden sollen. Wird von der Klasse ExImageCanvas
 * benoetigt.
 * @see jm.extension.ExImageCanvas
 * @version  2.1, 14/02/2000
 * @author   Jens Martin
 */
public class AddRoiDialog extends Dialog implements ActionListener {
	public static final int CANCEL = 0;
	public static final int ALL = 1;
	public static final int CURRENT = 2;
	public int							result = -1;
	private ExJButton				allSlices = new ExJButton();
	private ExJButton				currentSlice = new ExJButton();
	private ExJButton				cancel = new ExJButton();

	private JRadioButton		showAgain = new JRadioButton("don't show this dialog again            ", false);

	public boolean					dontAskAgain = false;


	/**
	 * Der Konstruktor. Er bekommt eine Referenz auf das Vater-Fenster,
	 * den anzuzeigen Titel und die Stirng-Meldung.
	 * @param f Frame des Vaterfensters
	 * @param titel Titel des dargestellten Dialoges
	 * @param Medlung Textmeldung des dargestellten Dialoges
	 */
	public AddRoiDialog(Frame f, String titel, String meldung) {
		super(f, titel, true);
		this.setLayout(new BorderLayout());
		Font	font = new Font("Dialog", 1, 11);

		allSlices.setText("all");
		allSlices.setBackground(Color.black);
		allSlices.setForeground(Color.lightGray);
		allSlices.setFont(font);
		currentSlice.setText("current");
		currentSlice.setBackground(Color.black);
		currentSlice.setForeground(Color.lightGray);
		currentSlice.setFont(font);
		cancel.setText("cancel");
		cancel.setBackground(Color.black);
		cancel.setForeground(Color.lightGray);
		cancel.setFont(font);

		allSlices.addActionListener(this);
		currentSlice.addActionListener(this);
		cancel.addActionListener(this);

		showAgain.setBackground(Color.black);
		showAgain.setForeground(Color.lightGray);
		showAgain.setFont(font);
		showAgain.setFocusPainted(false);
		showAgain.setBorderPainted(false);
		showAgain.setOpaque(true);

		Panel p = new Panel();

		p.setBackground(Color.black);
		p.setLayout(new BorderLayout());
		p.add(BorderLayout.EAST, allSlices);
		p.add(BorderLayout.CENTER, currentSlice);
		p.add(BorderLayout.WEST, cancel);
		add(BorderLayout.SOUTH, p);
		MultiLineLabel	textLabel = new MultiLineLabel(meldung);

		Label						dummy1 = new Label(" ");
		Label						dummy2 = new Label(" ");

		dummy1.setBackground(Color.black);
		dummy1.setForeground(Color.lightGray);
		dummy2.setBackground(Color.black);
		dummy2.setForeground(Color.lightGray);
		textLabel.setBackground(Color.black);
		textLabel.setForeground(Color.lightGray);
		textLabel.setFont(font);

		add(BorderLayout.NORTH, textLabel);

		add(BorderLayout.CENTER, showAgain);
		add(BorderLayout.EAST, dummy1);
		add(BorderLayout.WEST, dummy2);

		this.setBackground(Color.black);
		this.pack();
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			System.err.println("Can't set GUI to look and feel: " + e);
		} 
	}


	/**
	 * Faengt Mausklicks auf die Schaltflaechen des Dialog ab.
	 * @param evt ActionEvent, durch Mausklick verursacht
	 */
	public void actionPerformed(ActionEvent evt) {
		Object	src = evt.getSource();

		if (src instanceof JButton) {
			this.setVisible(false);
			dontAskAgain = showAgain.isSelected();
			if (src == cancel) {
				result = CANCEL;
			} 
			if (src == allSlices) {
				result = ALL;
			} 
			if (src == currentSlice) {
				result = CURRENT;
			} 
		} 
	} 

}



/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

