/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 *
 * Copyright (C) 1999 / 2000 Jens Martin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

import java.awt.event.*;
import ij.*;

/**
 * Diese Klasse ermoeglicht die Darstellung von Tooltips auf dem ImageCanvas von ImageJ.
 * Sie wird von der abgeleiteten Klasse ExImageCanvas benutzt.
 * @see     jm.extension.ExImageCanvas
 * @see     jm.extension.AwtToolTipHelper
 * @see     jm.extension.TimerThread
 * @version 2.0, 14/02/2000
 * @author  Jens Martin
 */
public class AwtToolTip extends MouseMotionAdapter {
	private TimerThread timerThread = new TimerThread();


	/**
	 * Setzt die Verzoegerung in Millisekunden, nach der ein ToolTip
	 * eingeblendet werden soll, wenn die Maus nicht bewegt wird.
	 * @param ms Zeit in Millisekunden
	 */
	public void setInitialDelay(int ms) {

		// if (!timerThread.started) timerThread.start();
		timerThread.setInitialDelay(ms);
	}


	/**
	 * Setzt die Verzoegerung in Millisekunden, nach der ein ToolTip
	 * ausgeblendet werden soll.
	 * @param ms Zeit in Millisekunden
	 */
	public void setDismissDelay(int ms) {

		// if (!timerThread.started) timerThread.start();
		timerThread.setDismissDelay(ms);
	}


	/**
	 * Faengt Bewegungen der Maus ab, um die Timer zu steuern.
	 * @param e MouseEvent, durch Mausbewegungen erzeugt
	 */
	public void mouseMoved(java.awt.event.MouseEvent e) {

		// if (!timerThread.started) timerThread.start();
		timerThread.setLastMoveTime(System.currentTimeMillis());
	}


	/**
	 * Setzt die Refernz auf den ExImageCanvas, auf dem die ToolTips
	 * angzeigt werden sollen.
	 * @param ic Refernz auf den ImageCanvas
	 */
	public void setSourceClass(ExImageCanvas ic) {

		// if (!timerThread.started) timerThread.start();
		if (ic != null) {
                    timerThread.setSourceClass(ic);
                }
                else {
                    //IJ.write("setting timerThread to 0!");
                    timerThread.stopped = true;
                    if (timerThread != null) timerThread = null;
                    //timerThread = null;
                }
	}


	/**
	 * Fragt ab, ob z.Zt ein ToolTip angezeigt werden soll.
	 * @return boolean true, wenn alle Timer-Bedingungen erfuellt sind.
	 */
	public boolean showToolTip() {

		// if (!timerThread.started) timerThread.start();
		return timerThread.showToolTip;
	}

        /**
	 * Fragt ab, ob z.Zt ein ToolTip angezeigt werden soll.
	 * @return boolean true, wenn alle Timer-Bedingungen erfuellt sind.
	 */
	protected void finalize() throws Exception {
                // IJ.write("TERMINATING THREAD IN FINALIZE YEAH !!!");
        if (timerThread != null) timerThread = null;
		//try {
                // super.finalize();
                //} catch (Exception e) {}
	}

}





/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

