/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

import jm.kidney.*;
import jm.util.*;

import java.awt.*;
import java.util.Properties;
import java.awt.image.*;
import java.awt.event.*;

import ij.*;
import ij.gui.*;

import javax.swing.*;
import javax.swing.event.*;


/**
 * Hilfsklasse zur Darstellung von Tooltips auf dem ImageCanvas von ImageJ.
 * Wird von AwtToolTip benoetigt.
 * 
 * @see     jm.extension.AwtToolTip
 * @see     jm.extension.ExImageCanvas
 * @version 1.0, 14/02/2000
 * @author  Jens Martin
 */
public class AwtToolTipHelper extends MouseAdapter {
	private boolean mouseOver = false;


	/**
	 * Fragt ab, ob sich der Mauszeiger ueber dem
	 * dem ToolTip zugeordnete GUI-Objekt befindes.
	 * @return boolean true, wenn der Mauszeiger ueber dem Objekt ist.
	 */
	public boolean isMouseOver() {
		return mouseOver;
	} 


	/**
	 * Faengt Bewebungen des Mauszeigers ab und stellt fest, ob der Mauszeiger in die
	 * Flaeche des dem ToolTip zugeordnete GUI-Objekt eingetreten ist.
	 * @param e MouseEvent, durch Mausbewegungen erzeugt.
	 */
	public void mouseEntered(java.awt.event.MouseEvent e) {
		mouseOver = true;

		// IJ.write("drin");
	} 


	/**
	 * Faengt Bewebungen des Mauszeigers ab und stellt fest, ob der Mauszeiger aus der
	 * Flaeche des dem ToolTip zugeordnete GUI-Objekt ausgetreten ist.
	 * @param e MouseEvent, durch Mausbewegungen erzeugt.
	 */
	public void mouseExited(java.awt.event.MouseEvent e) {
		mouseOver = false;

		// IJ.write("draussen");
	} 

}




/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

