/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 *
 * Copyright (C) 1999 / 2000 Jens Martin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

import java.awt.*;
import java.awt.image.*;
import java.util.Properties;
import java.awt.event.*;

import ij.*;
import ij.io.*;
import ij.gui.*;

import javax.swing.*;


/**
 * Diese Klasse erweitert das ImageWindow von ImageJ.
 * Die Ableitung dieses Klasse ist nur noetig, un eine explizite Typumwandlung
 * eines ImageCanvas in ein ExImageCanvas ermoeglichen zu koennen.
 * @see     jm.extension.ExImageCanvas
 * @see     jm.kidney.AnalysisDialog
 * @version 2.1, 13/05/2003, tha: Kleine Aenderungen in drawInfo.
 * @author  Jens Martin
 */
public class ExImageWindow extends ImageWindow {
	private static final int	TEXT_GAP = 0;
	private Font							textFont = new Font("Dialog", 1, 11);

	// private ExImageCanvas eic = null;


	/**
	 * Der Konstruktor.
	 * @param    imp    ImagePlus-Objekt von ImageJ
	 */
	public ExImageWindow(ImagePlus imp) {
		super(imp, new ExImageCanvas(imp));

		// super(imp,new ExImageCanvas(imp));

		this.setBackground(Color.black);
		this.setForeground(Color.white);
		this.pack();

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			System.err.println("Can't set GUI to look and feel: " + e);
		}
	}


	/**
	 * Ueberschreibt die paint-Methode der Oberklasse. Es wurden einige Aufrufe
	 * aus der urspruenglichen Methode auskommentiert, die nicht mehr benoetigt werden.
	 * @param g Graphics-Object
	 */
	public void paint(Graphics g) {
		drawInfo(g);

		// Point loc = ic.getLocation();
		// Dimension csize = ic.getSize();
		// canvasButton.setBounds(loc.x,loc.y,csize.width,10);
		// canvasButton.paint(g);
		// Point loc = ic.getLocation();
		// Dimension csize = ic.getSize();
		// canvasButton.setBounds(loc.x,loc.y,csize.width,csize.height);
		// canvasButton.repaint();
		// g.drawRect(loc.x-1, loc.y-1, csize.width+1, csize.height+1);

	}


        /**
	 * Ueberschreibt die close-Methode der Oberklasse.
	 */
	public boolean close() {
                //IJ.write("ExImageWindow:Closing ExImageWindow!");
		return super.close();
	}

	/**
	 * Hilfmethode zum zeichnen des Informations-String mit Bildeinganschaften,
	 * Bildgroesse und Bilsausmassen am oberen Rand innerhalb des Fenstersrahmens.
	 * @param g Graphics-Object
	 */
	public void drawInfo(Graphics g) {
		String	s = "";
		Insets	insets = super.getInsets();
		int			nSlices = imp.getStackSize();

		if (nSlices > 1) {
			ImageStack	stack = imp.getStack();

			s += imp.getCurrentSlice() + "/" + nSlices;
			boolean isLabel = false;

			if (nSlices <= 4) {
        // tha 2002.5.13: In der aktuellen Version von ImageJ (1.26) wird  
        // ImageStack.getSliceLabel() nicht mehr unterstuetzt.
				// String	label = stack.getSliceLabel();
				String	label = stack.getSliceLabel(1);

				if (label != null) {
					s += " (" + label + ")";
				}
			}
			if ((this instanceof ExStackWindow) && running) {
				g.drawString(s, 5, insets.top + TEXT_GAP);
				return;
			}
			s += "; ";
		}

		int type = imp.getType();

		if (imp.sCalibrated) {
			s += imp.getWidth() + "x" + imp.getHeight() + " pixels; ";

			// s += IJ.d2s(imp.getWidth()*imp.pixelWidth,2) + "x" + IJ.d2s(imp.getHeight()*imp.pixelHeight,2) + " " + imp.units
			// + " (" + imp.getWidth() + "x" + imp.getHeight() + "); ";
		} else {
			s += imp.getWidth() + "x" + imp.getHeight() + " pixels; ";
		}
		int size = (imp.getWidth() * imp.getHeight() * imp.getStackSize()) / 1024;

		switch (type) {
		case ImagePlus.GRAY8:		// 2000.7.31 tha: Constant Expression notwendig, war imp.GRAY8
			s += "8-bit grayscale";
			break;
		case ImagePlus.GRAY16:	// 2000.7.31 tha: Constant Expression notwendig
			s += "16-bit grayscale";
			size *= 2;
			break;
		case ImagePlus.GRAY32:	// 2000.7.31 tha: Constant Expression notwendig
			s += "32-bit grayscale";
			size *= 4;
			break;
		case ImagePlus.COLOR_256:		// 2000.7.31 tha: Constant Expression notwendig
			s += "8-bit color";
			break;
		case ImagePlus.COLOR_RGB:		// 2000.7.31 tha: Constant Expression notwendig
			s += "RGB";
			size *= 4;
			break;
		}
		s += "; " + size + "K";
		g.drawString(s, 5, insets.top + TEXT_GAP);
	}

}


/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

