/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

// import ij.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;


/**
 * Diese Klasse erweitert die Klasse JButton von Swing.
 * Sobald der Mauszeiger ueber den Button gefahren wird, wird der Button-Text
 * etwas heller und erscheint zusaetzlich unterstrichen. Dies soll beim Benutzer
 * ein aehnliches Gefuehl wie bei der Bedienung eines Browsers aufkommen lassen.
 * @version 1.1, 14/02/2000
 * @author  Jens Martin
 */
public class ExJButton extends JButton implements MouseListener {
	private boolean mouseOver = false;
	private boolean mouseButtonDown = false;
	private Color		inactiveForeground;


	/**
	 * Der Konstruktor.
	 */
	public ExJButton() {
		this.setBorderPainted(false);
		this.setFocusPainted(false);
		this.addMouseListener(this);
		repaint();
	}


	/**
	 * Ueberschreibt die Methode der Oberklasse und brechnet aus der uebergebenen Farbe
	 * die Farbe fuer den inaktiven Vordergrund.
	 * @param c Color, Farbe des Vordergrundes
	 */
	public void setForeground(Color c) {
		super.setForeground(c);
		int r = c.getRed();
		int g = c.getGreen();
		int b = c.getBlue();

		r = r - 25;
		if (r < 0) {
			r = 0;
		} 
		g = g - 25;
		if (g < 0) {
			g = 0;
		} 
		b = b - 25;
		if (b < 0) {
			b = 0;
		} 
		inactiveForeground = new Color(r, g, b);
	} 


	/**
	 * Faengt Mausbewegungen ab und stellt fest, ob der Mauszeiger aus
	 * der Flaeche des Buttons herausbewegt wurde.
	 * @param e MouseEvent, durch Bewegungen der Maus ausgeloest.
	 */
	public void mouseExited(MouseEvent e) {

		// super.mouseExited(e);
		// IJ.write("raus");
		mouseButtonDown = false;
		mouseOver = false;
		repaint();
	} 


	/**
	 * Faengt Mausbewegungen ab und stellt fest, ob der Mauszeiger in
	 * die Flaeche des Buttons hereinbewegt wurde.
	 * @param e MouseEvent, durch Bewegungen der Maus ausgeloest.
	 */
	public void mouseEntered(MouseEvent e) {

		// super.mouseEntered(e);
		// IJ.write("rein");
		mouseButtonDown = false;
		mouseOver = true;
		repaint();
	} 


	/**
	 * Faengt Mausklicks ab.
	 * @param e MouseEvent, durch Klicks des Mausbuttons ausgeloest
	 */
	public void mouseReleased(MouseEvent e) {

		// super.mouseReleased(e);
		// IJ.write("rauf");
		mouseButtonDown = false;
		repaint();
	} 


	/**
	 * Faengt Mausklicks ab.
	 * @param e MouseEvent, durch Klicks des Mausbuttons ausgeloest
	 */
	public void mousePressed(MouseEvent e) {

		// super.mousePressed(e);
		// IJ.write("runter");
		mouseButtonDown = true;
		repaint();
	} 


	/**
	 * Faengt Mausklicks ab.
	 * @param e MouseEvent, durch Klicks des Mausbuttons ausgeloest
	 */
	public void mouseClicked(MouseEvent e) {

		// super.mouseClicked(e);
	} 


	/**
	 * Ueberschreibung der Paint-Methode der Oberklasse. Dadurch kann die Erweiterte
	 * Farbdarstellung bie Mausbewegungen sowie das Unterstreichen von Text realisiert
	 * werden.
	 * @param g Graphics-Objekt
	 */
	public void paint(Graphics g) {
		super.paint(g);

		// IJ.write("EXB paint!!");
		boolean enabled = this.isEnabled();
		int			width = this.getBounds().width;
		int			height = this.getBounds().height;
		String	s = this.getText();
		int			textPosX = ((width - getFontMetrics(this.getFont()).stringWidth(s)) / 2) - 1;
		int			textPosY = (getFont().getSize() + ((height - getFont().getSize()) / 2)) - 1;

		if (mouseButtonDown && enabled) {
			textPosX++;
			textPosY++;
		} 

		g.setColor(getBackground());
		g.fillRect(0, 0, width, height);
		g.setFont(getFont());
		if (mouseOver && enabled) {
			g.setColor(getForeground());
			g.drawRect(0, 0, width - 1, height - 1);
			g.drawString(s, textPosX, textPosY);
			if (!mouseButtonDown) {
				g.drawLine(textPosX - 1, textPosY + 2, textPosX - 1 + getFontMetrics(getFont()).stringWidth(s), textPosY + 2);
			} 
		} else {
			g.setColor(inactiveForeground);
			g.drawRect(0, 0, width - 1, height - 1);
			g.drawString(s, textPosX, textPosY);
		} 
	} 

}




/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

