/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 *
 * Copyright (C) 1999 / 2000 Jens Martin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import ij.*;

import javax.swing.*;
import javax.swing.event.*;


/**
 * Diese Klasse erweitert das StackWindow von ImageJ.
 * Die Ableitung dieses Klasse ist nur noetig, un eine explizite Typumwandlung
 * eines ImageCanvas in ein ExImageCanvas ermoeglichen zu koennen.
 * @see     jm.extension.ExImageCanvas
 * @see     jm.kidney.AnalysisDialog
 * @version 2.0, 14/02/2000
 * @author  Jens Martin
 */
public class ExStackWindow extends ExImageWindow implements Runnable, AdjustmentListener, ActionListener {

	protected Scrollbar sliceSelector;
	protected Thread		thread;
	protected boolean		done;
	protected int				slice;


	/**
	 * Der Konstruktor.
	 * @param    imp    ImagePlus-Objekt von ImageJ
	 */
	public ExStackWindow(ImagePlus imp) {
		super(imp);

		// hide();
		// add slice selection slider
		ImageStack	s = imp.getStack();
		int					stackSize = s.getSize();

		sliceSelector = new Scrollbar(Scrollbar.HORIZONTAL, 1, 1, 1, stackSize + 1);
		sliceSelector.setBackground(Color.black);
		sliceSelector.setForeground(Color.white);
		add(sliceSelector);
		sliceSelector.addAdjustmentListener(this);
		int blockIncrement = stackSize / 10;

		if (blockIncrement < 1) {
			blockIncrement = 1;
		}
		sliceSelector.setUnitIncrement(1);
		sliceSelector.setBlockIncrement(blockIncrement);
		pack();
		show();
		imp.setSlice(1);

		thread = new Thread(this, "SliceSelector");

		// thread.setPriority(thread.getPriority()-1);
		// thread.setPriority(Thread.MIN_PRIORITY);
		thread.start();
	}


	/**
	 * Faengt Bewegungen des Schiebereglers zum Durchblaettern der Bilderstapels ab.
	 * @param e AdjustmentEvent, ausgeloest durch Bewegung des Schiebereglers.
	 */
	public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
		if (!running) {
			slice = sliceSelector.getValue();
			notify();
		}
	}


	/**
	 * Sperrt das Fenster fuer weitere Eingaben von maus oder Tastatur. Im gesperrten
	 * Zustand sind keine Mausklicks und kein Durchblaettern mehr moeglich.
	 */
	public void lock() {
		imp.lock();
		ic.setEnabled(false);
		sliceSelector.setEnabled(false);
	}


	/**
	 * Hebt die Sperrung des Fensters wieder auf
	 */
	public void unlock() {
		imp.unlock();
		ic.setEnabled(true);
		sliceSelector.setEnabled(true);
	}


	/**
	 * Faengt durch Mausklicks oder Tastatureingaben erzeugte Events ab.
	 * @param e ActionsEvent
	 */
	public void actionPerformed(ActionEvent e) {}


	/**
	 * Wird aufgerufen, wenn das Fenster geschlossen wird.
	 * @return boolean true, wenn der Vorgang erfolgreich war.
	 */
	public boolean close() {

		//IJ.write("ExStackWindow: closing Window...");
		super.close();
		synchronized (this) {
			done = true;
			notify();
		}
		return true;
	}


	/**
	 * Zeigt die mit dem Schieberegler eingestellte Bildnummer der Sequenz an
	 * und updated den Fenstertext in der Statuszeile ueber dem Bild.
	 * @return int Nummer der Bildes
	 */
	public void showSlice(int index) {
		ImageStack	stack = imp.getStack();

		if (index >= 1 && stack != null && index <= stack.getSize()) {
			imp.setSlice(index);
			sliceSelector.setValue(index);
		}
	}


	/**
	 * Startet den Thread zur Ueberwachung des Schiebereglers.
	 */
	public void run() {
		while (!done) {
			synchronized (this) {
				try {
					wait();
				} catch (InterruptedException e) {}
			}
			if (done) {
				return;
			}
			if (slice > 0) {
				int s = slice;

				slice = 0;
				ImageStack	stack = imp.getStack();

				imp.setSlice(s);
			}
		}
	}

}



/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

