/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 *
 * Copyright (C) 1999 / 2000 Jens Martin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.extension;

import jm.kidney.*;
import jm.util.*;

import java.awt.*;
import java.util.Properties;
import java.awt.image.*;
import java.awt.event.*;

import ij.*;
import ij.gui.*;

import javax.swing.*;
import javax.swing.event.*;


/**
 * Steuert die Einblen- und Ausblendzeiten fuer die Awt-Tooltips
 * @see     jm.extension.AwtToolTip
 * @see     jm.extension.AwtToolTipHelper
 * @see     jm.extension.ExImageCanvas
 * @version 2.2, 14/02/2000
 * @author  Jens Martin
 */
public class TimerThread extends Thread {
	public boolean				stopped = false;
	public boolean				started = false;
	private int						latencyTime = 750;
	private int						dismissTime = 4000;
	private long					actualTime = 0;
	private long					lastMoveTime = Long.MAX_VALUE;
	private ExImageCanvas exImageCanvas = null;
	public boolean				showToolTip = false;
	private boolean				repaintOnce = true;
	private boolean				repaintDismiss = true;

	private MouseEvent		mouseEvent = null;


	/**
	 * Der Konstruktor.
	 */
	public TimerThread() {
		super();
		this.start();
	}


	/**
	 * Method declaration
	 */
	public void run() {
		this.setPriority(Thread.MIN_PRIORITY);
		started = true;
		while (!stopped && exImageCanvas != null) {
			actualTime = System.currentTimeMillis();
			if ((actualTime - lastMoveTime) > latencyTime) {
				if (repaintOnce) {
					repaintOnce = false;
					showToolTip = true;
					exImageCanvas.repaint();
					showToolTip = false;
				}
			} else {
				showToolTip = false;
				repaintOnce = true;
				repaintDismiss = true;
			}
			if ((actualTime - lastMoveTime) > dismissTime) {
				if (repaintDismiss) {
					repaintDismiss = false;
					showToolTip = false;
					exImageCanvas.repaint();
				}
			}

			//IJ.write("laufe!" + lastMoveTime + " ! " +  actualTime);

			if (exImageCanvas == null) {

				// IJ.write("TimerThread: Must stop myself now");
				// this.stop();
				this.interrupt();
			}
		}
	}


	/**
	 * Setzt die Zeit bis zum Einblenden eines Tooltips.
	 * @param ms Zeit in Millisekunden
	 */
	public void setInitialDelay(int ms) {
		if (ms > 0) {
			latencyTime = ms;
		}
	}


	/**
	 * Setzt die Zeit bis zum Ausblenden eines bereits eingeblendeten Tooltips.
	 * @param ms Zeit in Millisekunden
	 */
	public void setDismissDelay(int ms) {
		if (ms > 0) {
			dismissTime = ms;
		}
	}


	/**
	 * Setzt die Zeit bis zum Ausbelnden eines ToolTips, wenn die Maus
	 * vom GUI-Objekt herunterbewegt wird.
	 * @param ms Zeit in Millisekunden
	 */
	public void setLastMoveTime(long time) {
		if (time > 0) {
			lastMoveTime = time;
		}
	}


	/**
	 * Setzt die Refernz auf das GUI-Objekt, auf dem die ToolTips dargestellt werden
	 * Sollen. Hier also der ExImageCanvas.
	 * @param ic Referenz auf den ImageCanvas.
	 */
	public void setSourceClass(ExImageCanvas ic) {
		exImageCanvas = ic;
	}

}




/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

