/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * JIGL--Java Imaging and Graphics Library
 * Copyright (C)1999 Brigham Young University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * A copy of the GNU Library General Public Licence is contained in
 * /jigl/licence.txt
 */

package jm.jigl; // Modifizierte Paketstruktur [JM]
import jm.jigl.*;
import java.io.*;


/**
 * Performs a ByteSize operation on an signal.  This class supports command line options in
 * the following format <i> Bytesize <input file> <output file> </i>.
 * @version 1.3, Modifikation der urspruenglichen jigl Paketstruktur durch Jens Martin
 * @see jigl.image.LevelOps.ByteSize
 */
public class ByteSize implements LevelOp {


	/**
	 * Initilizes ByteSize for use with integers
	 */
	public ByteSize() {}


	/**
	 * ByteSizes the range of this signal to an arbitrary min/max
	 */
	public Signal apply(Signal signal) throws SignalNotSupportedException {
		if (signal instanceof DiscreteSignal) {
			return apply((DiscreteSignal) signal);
		} else if (signal instanceof RealSignal) {
			return apply((RealSignal) signal);
		} else {
			throw new SignalNotSupportedException();
		}
	}


	/**
	 * ByteSizes the range of this signal to an arbitrary min/max
	 * @signal RealSignal
	 */
	private DiscreteSignal apply(DiscreteSignal signal) {

		float min = signal.min();
		float max = signal.max();

		float range = max - min;

		// convert to byte depth
		int		value = 0;

		for (int x = 0; x < signal.length(); x++) {
			value = (int) ((255.0 / range) * ((float) signal.get(x) - min));
			value = 0x00FF & value;
			signal.set(x, (short) value);
		}

		return signal;
	}


	/**
	 * ByteSizes the range of this signal to an arbitrary min/max
	 * @signal RealSignal
	 */
	private RealSignal apply(RealSignal signal) {

		float min = signal.min();
		float max = signal.max();

		float range = max - min;

		// convert to byte depth
		float value = 0;

		for (int x = 0; x < signal.length(); x++) {
			value = (float) ((255.0 / range) * (signal.get(x) - min));
			value = 0x00FF & (int) value;
			signal.set(x, value);
		}

		return signal;
	}


	/**
	 * Method declaration
	 *
	 *
	 * @param argv
	 *
	 * @see
	 */
	public static void main(String[] argv) {

		try {
			Signal						image = null;
			String						inputfile = argv[0];
			Signal						image2 = null;


			SignalInputStream is = new SignalInputStream(inputfile);

			image = is.read();
			is.close();

			ByteSize	bytesize = new ByteSize();

			image2 = bytesize.apply(image);

			// put command line stuff here.

			// create a new SignalOutputStream
			SignalOutputStream	os = new SignalOutputStream(argv[1]);

			os.write(image2);
			os.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}



/*--- formatting done in "My Own Convention" style on 08-08-2000 ---*/

