/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * JIGL--Java Imaging and Graphics Library
 * Copyright (C)1999 Brigham Young University
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * A copy of the GNU Library General Public Licence is contained in
 * /jigl/licence.txt
 */

package jm.jigl; // Modifizierte Paketstruktur [JM]
import java.*;
import jm.jigl.*;

// import jigl.math.*;


/**
 * Signal type conversions.
 * Handles only discrete, real, and complex.
 * @version 1.3, Modifikation der urspruenglichen jigl Paketstruktur durch Jens Martin
 * @see jigl.math.ConvertSignal
 */


public class ConvertSignal {


	/**
	 * Default Constructor (doesn't do anything)
	 */

	public ConvertSignal() {}


	/**
	 * Converts a Signal to a DescreteSignal
	 */
	public static DiscreteSignal toDiscrete(Signal signal) {
		if (signal instanceof DiscreteSignal) {
			return toDiscrete((DiscreteSignal) signal);
		} else if (signal instanceof RealSignal) {
			return toDiscrete((RealSignal) signal);
		} else {
			return toDiscrete((ComplexSignal) signal);
		}
	}


	/**
	 * Converts a Signal to a RealSignal
	 */
	public static RealSignal toRealDiscrete(Signal signal) {
		if (signal instanceof DiscreteSignal) {
			return toRealDiscrete((DiscreteSignal) signal);
		} else if (signal instanceof RealSignal) {
			return toRealDiscrete((RealSignal) signal);
		} else {
			return toRealDiscrete((ComplexSignal) signal);
		}
	}


	/**
	 * Converts a Signal to a ComplexSignal
	 */
	public static ComplexSignal toComplex(Signal signal) {
		if (signal instanceof DiscreteSignal) {
			return toComplex((DiscreteSignal) signal);
		} else if (signal instanceof RealSignal) {
			return toComplex((RealSignal) signal);
		} else {
			return toComplex((ComplexSignal) signal);
		}
	}


	/**
	 * Converts a DiscreteSignal to a DiscretetSignal
	 */
	public static DiscreteSignal toDiscrete(DiscreteSignal signal) {
		int							length = signal.length();
		DiscreteSignal	newsignal = new DiscreteSignal(length);

		for (int x = 0; x < length; x++) {
			newsignal.set(x, signal.get(x));
		}
		return newsignal;
	}


	/**
	 * Converts a RealSignal to a DiscretetSignal
	 */
	public static DiscreteSignal toDiscrete(RealSignal signal) {
		int							length = signal.length();
		DiscreteSignal	newsignal = new DiscreteSignal(length);

		for (int x = 0; x < length; x++) {
			newsignal.set(x, (short) signal.get(x));
		}
		return newsignal;
	}


	/**
	 * Converts a ComplexSignal to a DiscretetSignal
	 */
	public static DiscreteSignal toDiscrete(ComplexSignal signal) {
		int							length = signal.length();
		DiscreteSignal	newsignal = null;

		newsignal = new DiscreteSignal(length);
		for (int x = 0; x < length; x++) {
			newsignal.set(x, (int) signal.getReal(x));
		}
		return newsignal;
	}


	/**
	 * Converts a DiscreteSignal to a RealSignal
	 */
	public static RealSignal toRealDiscrete(DiscreteSignal signal) {
		int					length = signal.length();
		RealSignal	newsignal = new RealSignal(length);

		for (int x = 0; x < length; x++) {
			newsignal.set(x, (float) signal.get(x));
		}
		return newsignal;
	}


	/**
	 * Converts a RealSignal to a RealSignal
	 */
	public static RealSignal toRealDiscrete(RealSignal signal) {
		int					length = signal.length();
		RealSignal	newsignal = new RealSignal(length);

		for (int x = 0; x < length; x++) {
			newsignal.set(x, signal.get(x));
		}
		return newsignal;
	}


	/**
	 * Converts a ComplexSignal to a RealSignal
	 */
	public static RealSignal toRealDiscrete(ComplexSignal signal) {
		int					length = signal.length();
		RealSignal	newsignal = null;

		newsignal = new RealSignal(length);
		for (int x = 0; x < length; x++) {
			newsignal.set(x, signal.getReal(x));
		}
		return newsignal;
	}


	/**
	 * Converts a DiscreteSignal to a ComplexSignal
	 */
	public static ComplexSignal toComplex(DiscreteSignal signal) {
		int						length = signal.length();
		Complex				complex = new Complex();
		ComplexSignal newsignal = new ComplexSignal(length);

		for (int x = 0; x < length; x++) {
			newsignal.setReal(x, (float) signal.get(x));
			newsignal.setImag(x, 0f);
		}
		return newsignal;
	}


	/**
	 * Converts a RealSignal to a ComplexSignal
	 */
	public static ComplexSignal toComplex(RealSignal signal) {
		int						length = signal.length();
		Complex				complex = new Complex();
		ComplexSignal newsignal = new ComplexSignal(length);

		for (int x = 0; x < length; x++) {
			newsignal.setReal(x, signal.get(x));
			newsignal.setImag(x, 0f);
		}
		return newsignal;
	}


	/**
	 * Converts a ComplexSignal to a ComplexSignal
	 */
	public static ComplexSignal toComplex(ComplexSignal signal) {
		int						length = signal.length();
		ComplexSignal newsignal = null;

		newsignal = new ComplexSignal(length);
		for (int x = 0; x < length; x++) {
			newsignal.setReal(x, signal.getReal(x));
			newsignal.setImag(x, signal.getImag(x));
		}
		return newsignal;
	}

}


/*--- formatting done in "My Own Convention" style on 08-08-2000 ---*/

