/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.extension is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.kidney;

import jm.extension.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.*;


/**
 * Zeigt einen kleinen Dialog mit Informationen zum RENAL FUNCTION Alanysis
 * Plguin an. Hier wird einfach nochmals das Bild der Splashscreen eingeblendet.
 * @see jm.kidney.AnalysisDialog
 * @version  1.1, 14/02/2000
 * @author   Jens Martin
 */
class AboutDialog extends JDialog implements ActionListener {
	private ExJButton ok = new ExJButton();


	/**
	 * Der Konstruktor. Er bekommt //den Namen// die URL einer GIF-Bilddatei uebergeben,
	 * die die Splashscreen enthaelt ( "/images/Splash.gif" )
	 * //@param filename Der Name der Bilddatei.//
	 * @param splashURL Die URL der Bilddatei.
	 */

	// 2000.8.2 tha: public AboutDialog(String filename)
	public AboutDialog(URL splashURL) {

		// 2000.7.31 tha: super( (JFrame) null, "About Renal Function Analysis", true );
		super((JFrame) null, "About Renal Function Analysis", true);

		this.getContentPane().setLayout(new BorderLayout());
		Font			font = new Font("Dialog", 1, 11);

		// 2000.8.2 tha: ImageIcon image = new ImageIcon(filename);
		ImageIcon image = new ImageIcon(splashURL);

		ok.setText("Ok");
		ok.setBackground(Color.black);
		ok.setForeground(Color.lightGray);
		ok.setFont(font);
		ok.addActionListener(this);

		JLabel	picture = new JLabel(image);

		this.getContentPane().add(BorderLayout.NORTH, picture);
		this.getContentPane().add(BorderLayout.CENTER, ok);
		this.setBackground(Color.black);
		this.pack();
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			System.err.println("Can't set GUI to look and feel: " + e);
		} 
		Rectangle rec = this.getBounds();
		Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();

		this.setLocation(((screensize.width - rec.width) / 2), ((screensize.height - rec.height) / 2));

	}


	/**
	 * Faengt Mausklicks auf die OK-Schaltflaeche des Dialog ab.
	 * @param evt ActionEvent, durch Mausklick verursacht
	 */
	public void actionPerformed(ActionEvent evt) {
		Object	src = evt.getSource();

		if (src instanceof JButton) {
			this.setVisible(false);
		} 
	} 

}



/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

