/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.kidney is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.kidney;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;


/**
 * Implements a basic splash screen for the Swing Application Framework.
 * The splash screen will show for a fixed amount of time unles the user
 * clicks the mouse on the window.
 * 
 * This code is based on code published by the Java Developer's Journal
 * <http://www.sys-con.com/java/index2.html<
 * 
 * @version	1.0
 */

public class JSplashScreen extends JWindow implements KeyListener, MouseListener, ActionListener {


	/**
	 * JSplashScreen constructs a splash screen (JWindow).
	 * parent is the parent frame for the window
	 * filename is the JPEG/GIF file to show as the splash
	 * timeout is time in milliseconds to display the splash
	 */

	// 2000.8.2 tha: public JSplashScreen(JFrame parent, String filename, int timeout) {
	public JSplashScreen(JFrame parent, URL splashURL, int timeout) {
		super(parent);

		// Note, this code does no error checking
		// 2000.8.2 tha: ImageIcon image = new ImageIcon(filename);
		ImageIcon image = new ImageIcon(splashURL);

		// The splash will be centered on the screen
		int				w = image.getIconWidth() + 5;
		int				h = image.getIconHeight() + 5;
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int				x = (screen.width - w) / 2;
		int				y = (screen.height - h) / 2;

		setBounds(x, y, w, h);

		getContentPane().setLayout(new BorderLayout());
		JLabel	picture = new JLabel(image);

		getContentPane().add("Center", picture);
		picture.setBorder(new BevelBorder(BevelBorder.RAISED));

		// Listen for key strokes
		addKeyListener(this);

		// Listen for mouse events from here and parent
		addMouseListener(this);
		parent.addMouseListener(this);

		// Timeout after a while
		Timer timer = new Timer(0, this);

		timer.setRepeats(false);
		timer.setInitialDelay(timeout);
		timer.start();
	}


	/**
	 * This method is called in order to block the application until
	 * the splash screen times out or is dismissed.
	 * This is a bit of a kludge, actually, and the actual affect
	 * varies based on platform.
	 */
	public void block() {
		while (isVisible()) {}
	} 


	/**
	 * Process key events
	 */
	public void keyTyped(KeyEvent event) {}


	/**
	 * Process key events
	 */
	public void keyReleased(KeyEvent event) {}


	/**
	 * Process key events
	 */
	public void keyPressed(KeyEvent event) {
		setVisible(false);
		dispose();
	} 


	/**
	 * Process mouse events
	 */
	public void mousePressed(MouseEvent event) {}


	/**
	 * Process mouse events
	 */
	public void mouseReleased(MouseEvent event) {}


	/**
	 * Process mouse events
	 */
	public void mouseEntered(MouseEvent event) {}


	/**
	 * Process mouse events
	 */
	public void mouseExited(MouseEvent event) {}


	/**
	 * Process mouse events
	 * Dismiss the window on a mouse click, ignore rest.
	 */
	public void mouseClicked(MouseEvent event) {
		setVisible(false);
		dispose();
	} 


	/**
	 * Process Actions events
	 * Dismiss the window on a timeout
	 */
	public void actionPerformed(ActionEvent event) {
		setVisible(false);
		dispose();
	} 

}


/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

