/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.scaler is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 *
 * Copyright (C) 1999 / 2000 Jens Martin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.scaler;

import java.awt.*;
import java.awt.event.*;

// import com.sun.java.swing.*;
// import com.sun.java.swing.event.*;
import javax.swing.*;
import javax.swing.event.*;


import ij.*;
import ij.io.*;
import ij.gui.*;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.process.*;

import jm.kidney.*;
import jm.cepstrum.*;
import jm.util.*;		// Fuer GridBagConstraints2


/**
 * Diese Klasse zeigt einen Dialog an, mit dem die Bilddimensionen veraendert werden
 * koennen. Sie wird vom Bikubischen Skalierungs-Plugin aufgerufen, damit der
 * Benutzer Eingaben zur gewuenschten Skalierung machen kann.
 * @see jm.cepstrum.BicubicInterpolation
 * @version  2.1, 11/12/1999
 * @author   Jens Martin
 */
public class ScaleDialog extends JDialog implements ActionListener, FocusListener, KeyListener {
	JPanel							jPanel1 = new JPanel();
	GridBagLayout				gridBagLayout1 = new GridBagLayout();
	JButton							jButtonMinusX = new JButton();
	JButton							jButtonMinusY = new JButton();
	JTextField					jTextFieldScaleX = new JTextField();
	JTextField					jTextFieldScaleY = new JTextField();
	JButton							jButtonPlusY = new JButton();
	JButton							jButtonPlusX = new JButton();
	JButton							jButtonCancel = new JButton();
	JButton							jButtonOk = new JButton();
	JLabel							jLabelScaleX = new JLabel();
	JLabel							jLabelScaleY = new JLabel();
	JCheckBox						jCheckBoxNewWindow = new JCheckBox();
	JLabel							jLabelPixelY = new JLabel();
	JLabel							jLabelPixelX = new JLabel();
	JTextField					jTextFieldPixelX = new JTextField();
	JTextField					jTextFieldPixelY = new JTextField();
	JCheckBox						jCheckBoxProportions = new JCheckBox();
	JButton							jButtonPlusPixX = new JButton();
	JButton							jButtonMinusPixX = new JButton();
	JButton							jButtonMinusPixY = new JButton();
	JButton							jButtonPlusPixY = new JButton();
	JLabel							jLabelNewSize = new JLabel();
	JLabel							jLabelOldSize = new JLabel();

	// Private Variables
	private double			scaleX = 1.00;
	private double			scaleY = 1.00;
	private double			oldScaleX = 1.00;
	private double			oldScaleY = 1.00;

	// private double orgScaleX = 1.00;
	// private double orgScaleY = 1.00;
	public int					pixelX = 256;
	public int					pixelY = 256;
	private int					oldPixelX = 256;
	private int					oldPixelY = 256;
	private int					orgPixelX = 256;
	private int					orgPixelY = 256;
	private double			minScaleX = 0.05;
	private double			minScaleY = 0.05;
	private double			maxScaleX = 1000.0;
	private double			maxScaleY = 1000.0;
	private int					minPixX = 10;
	private int					minPixY = 10;
	private int					maxPixX = 10000000;
	private int					maxPixY = 10000000;
	private ImageWindow win = null;
	private ImagePlus		imp = null;
	private int					oldImageSize = 0;
	private int					newImageSize = 0;
	private int					imageType = 0;
	private String			oldImageString = "";
	private String			newImageString = "";
	private int					maxImageSize = 65535;		// 64 Megs !!!
	private ImageStack	newStack = null;
	public boolean			okPressed = false;
	public boolean			newwindow = true;

	// Only for debugging


	/**
	 * Der Konstruktor.
	 * @param    i    ImagePlus-Objekt von ImageJ
	 */
	public ScaleDialog(ImagePlus i) {
		super();
		imp = i;
		pixelX = imp.getWidth();
		pixelY = imp.getHeight();
		imageType = imp.getType();
		scaleX = 1.0;
		scaleY = 1.0;
		orgPixelX = pixelX;
		orgPixelY = pixelY;
		oldImageSize = this.getImageSize();
		oldImageString = "   original Image Size: " + oldImageSize + "K";
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		}
		IJ.wait(250);
		this.updateTextFields();
		while (this.isVisible()) {}
		if (this != null) {
			this.dispose();
		}
	}


	/**
	 * Initialisierung der Objekte des Fensters.
	 * Von JBuilder automatisch eingefuegt.
	 */
	private void jbInit() throws Exception {
		jPanel1.setLayout(gridBagLayout1);
		//jButtonMinusX.setText("jButton1");
		jButtonMinusX.setText("-");
		//jButtonMinusY.setText("jButton2");
		jButtonMinusY.setText("-");
		jLabelScaleX.setText("new X-scale:");
		jLabelScaleY.setText("new Y-scale:");
		//jCheckBoxNewWindow.setText("jCheckBox1");
		jCheckBoxNewWindow.setText("create new window");
		jTextFieldScaleX.setText("1000.00");
		jTextFieldScaleX.setFont(new Font("Monospaced", 0, 12));
		jTextFieldScaleY.setText("1000.00");
		jTextFieldScaleY.setFont(new Font("Monospaced", 0, 12));
		jLabelPixelY.setText("Pixel Y:");
		jLabelPixelX.setText("Pixel X:");
		jTextFieldPixelX.setText("1000000");
		jTextFieldPixelX.setFont(new Font("Monospaced", 0, 12));
		jTextFieldPixelY.setText("1000000");
		jTextFieldPixelY.setFont(new Font("Monospaced", 0, 12));
		//jCheckBoxProportions.setText("jCheckBox1");
		jCheckBoxProportions.setText("preserve proportions");
		//jButtonPlusPixX.setText("jButton1");
		jButtonPlusPixX.setText("+");
		//jButtonMinusPixX.setText("jButton2");
		jButtonMinusPixX.setText("-");
		//jButtonMinusPixY.setText("jButton3");
		jButtonMinusPixY.setText("-");
		//jButtonPlusPixY.setText("jButton4");
		jButtonPlusPixY.setText("+");
		//jLabelNewSize.setText("jLabel1");
		jLabelNewSize.setForeground(SystemColor.windowText);
		//jLabelOldSize.setText("jLabel2");
		jLabelOldSize.setForeground(SystemColor.windowText);
		//jButtonPlusY.setText("jButton4");
		jButtonPlusY.setText("+");
		//jButtonPlusX.setText("jButton5");
		jButtonPlusX.setText("+");
		//jButtonCancel.setText("jButton6");
		jButtonCancel.setText("Cancel");
		//jButtonOk.setText("jButton8");
		jButtonOk.setText("Ok");
		this.getContentPane().add(jPanel1, BorderLayout.CENTER);
		jPanel1.add(jButtonMinusX, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonMinusY, new GridBagConstraints2(0, 5, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jTextFieldScaleX, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jTextFieldScaleY, new GridBagConstraints2(3, 5, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonPlusY, new GridBagConstraints2(4, 5, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonPlusX, new GridBagConstraints2(4, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonCancel, new GridBagConstraints2(0, 8, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonOk, new GridBagConstraints2(3, 8, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jLabelScaleX, new GridBagConstraints2(1, 4, 2, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 3), 0, 0));
		jPanel1.add(jLabelScaleY, new GridBagConstraints2(2, 5, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 3), 0, 0));
		jPanel1.add(jCheckBoxNewWindow, new GridBagConstraints2(2, 7, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jLabelPixelY, new GridBagConstraints2(2, 3, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 3), 0, 0));
		jPanel1.add(jLabelPixelX, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 3), 0, 0));
		jPanel1.add(jTextFieldPixelX, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jTextFieldPixelY, new GridBagConstraints2(3, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jCheckBoxProportions, new GridBagConstraints2(2, 6, 2, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonPlusPixX, new GridBagConstraints2(4, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonMinusPixX, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonMinusPixY, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonPlusPixY, new GridBagConstraints2(4, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jLabelNewSize, new GridBagConstraints2(0, 1, 5, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 5, 0), 0, 0));
		jPanel1.add(jLabelOldSize, new GridBagConstraints2(0, 0, 5, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

		// add actionListners
		jButtonMinusPixX.addActionListener(this);
		jButtonMinusPixY.addActionListener(this);
		jButtonMinusX.addActionListener(this);
		jButtonMinusY.addActionListener(this);
		jButtonPlusPixX.addActionListener(this);
		jButtonPlusPixY.addActionListener(this);
		jButtonPlusX.addActionListener(this);
		jButtonPlusY.addActionListener(this);
		jButtonOk.addActionListener(this);
		jButtonCancel.addActionListener(this);
		jTextFieldScaleX.addActionListener(this);
		jTextFieldScaleY.addActionListener(this);
		jTextFieldPixelX.addActionListener(this);
		jTextFieldPixelY.addActionListener(this);

		// add Focus Listeners
		jTextFieldScaleX.addFocusListener(this);
		jTextFieldScaleY.addFocusListener(this);
		jTextFieldPixelX.addFocusListener(this);
		jTextFieldPixelY.addFocusListener(this);
		jButtonOk.addFocusListener(this);

		// add Key Listeners
		jButtonOk.addKeyListener(this);

		jTextFieldScaleX.setRequestFocusEnabled(true);
		jTextFieldScaleY.setRequestFocusEnabled(true);
		jTextFieldPixelX.setRequestFocusEnabled(true);
		jTextFieldPixelY.setRequestFocusEnabled(true);
		jButtonOk.setRequestFocusEnabled(true);

		// set CheckBoxes
		jCheckBoxNewWindow.setSelected(true);
		jCheckBoxProportions.setSelected(true);

		// set Textfield Parameters
		jTextFieldScaleX.setHorizontalAlignment(JTextField.RIGHT);
		jTextFieldScaleY.setHorizontalAlignment(JTextField.RIGHT);
		jTextFieldPixelX.setHorizontalAlignment(JTextField.RIGHT);
		jTextFieldPixelY.setHorizontalAlignment(JTextField.RIGHT);

		// adjust and show Dialog Window
		this.setTitle(" Scale Image");
		this.pack();
		GUI.center(this);
		Rectangle rec = this.getBounds();

		rec.width += 10;
		rec.height += 10;
		this.setBounds(rec);
		this.setResizable(false);
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());	// getCrossPlatformLookAndFeelClassName());
		} catch (Exception e) {
			System.err.println("Can't set GUI to look and feel: " + e);
		}
		this.show();

		// this.updateTextFields();
	}


	/**
	 * Stellt die Groesse in Kilobyte des ImagePlus-Bildes fest, welches dem Konstruktor
	 * uebergeben wurde.
	 * @return int die brechnete Bildgroesse. Es wird immer ein Wert > 0 zurueckgegeben.
	 */
	private int getImageSize() {
		int result = 0;

		if (imp == null) {
			return result;
		}
		int size = (pixelX * pixelY * imp.getStackSize()) / 1024;

		switch (imageType) {
		case ImagePlus.GRAY8:		// 2000.7.31 tha: Constant Expression notwendig
			break;
		case ImagePlus.GRAY16:	// 2000.7.31 tha: Constant Expression notwendig
			size *= 2;
			break;
		case ImagePlus.GRAY32:	// 2000.7.31 tha: Constant Expression notwendig
			size *= 4;
			break;
		case ImagePlus.COLOR_256:		// 2000.7.31 tha: Constant Expression notwendig
			break;
		case ImagePlus.COLOR_RGB:		// 2000.7.31 tha: Constant Expression notwendig
			size *= 4;
			break;
		}
		if (size == 0) {
			size++;
		}
		return size;
	}


	/**
	 * Aktualisiert alle Textfelder des Dialog. Die darin dargestellten Werte
	 * werden entsprechend ihrer Klassenvariablen neu gesetzt.
	 */
	private void updateTextFields() {
		try {
			String	s = "";
			int			pos = 0;

			// IJ.write("IJ.d2s");
			s = IJ.d2s(scaleX, 2);

			// IJ.write("IJ.wait " + s);
			IJ.wait(50);

			// IJ.write("s.lastindexof");
			pos = s.lastIndexOf(",");

			// IJ.write("s.substring " + pos);
			if (pos > 0) {
				s = s.substring(0, pos) + "." + s.substring(pos + 1);

				// IJ.write("Textfield.setText " + s);
			}
			jTextFieldScaleX.setText(s);
			s = IJ.d2s(scaleY, 2);
			IJ.wait(50);
			pos = s.lastIndexOf(",");
			if (pos > 0) {
				s = s.substring(0, pos) + "." + s.substring(pos + 1);
			}
			jTextFieldScaleY.setText(s);

			// IJ.write("IntegertoString");
			jTextFieldPixelX.setText(Integer.toString(pixelX));
			jTextFieldPixelY.setText(Integer.toString(pixelY));
			jLabelOldSize.setText(oldImageString);
			newImageString = "   new Image Size:    " + this.getImageSize() + "K";
			jLabelNewSize.setText(newImageString);
		} catch (Exception e) {
			e.printStackTrace();
			IJ.write("Fehler in updateTextFields aufgetreten!");
		}

		// this.invalidate();
	}


	/**
	 * Routine zur Nachrichtenbehandung von Mausklicks sowie Tastatureingaben (Return)
	 * @param evt uebergebener ActionEvent
	 */
	public void actionPerformed(ActionEvent evt) {
		Object	src = evt.getSource();

		if (src instanceof JButton) {
			if (src == jButtonMinusX) {
				if (scaleX > minScaleX) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					scaleX = scaleX - 0.05;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonPlusX) {
				if (scaleX < maxScaleX) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					scaleX = scaleX + 0.05;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonMinusY) {
				if (scaleY > minScaleY) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					scaleY = scaleY - 0.05;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonPlusY) {
				if (scaleY < maxScaleY) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					scaleY = scaleY + 0.05;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonMinusPixX) {
				if (pixelX > minPixX) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					pixelX = pixelX - 10;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonPlusPixX) {
				if (pixelX < maxPixX) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					pixelX = pixelX + 10;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonMinusPixY) {
				if (pixelY > minPixY) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					pixelY = pixelY - 10;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonPlusPixY) {
				if (pixelY < maxPixY) {
					oldScaleX = scaleX;
					oldScaleY = scaleY;
					oldPixelX = pixelX;
					oldPixelY = pixelY;
					pixelY = pixelY + 10;
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
				}
			}
			if (src == jButtonCancel) {
				this.setVisible(false);
				this.dispose();
			}
			if (src == jButtonOk) {

				// jButtonOk.removeFocusListener(this);
				okPressed = true;
				newwindow = jCheckBoxNewWindow.isSelected();

				// jButtonOk.transferFocus();
				// if (imp!= null) imp.unlock();
				this.setVisible(false);
				this.dispose();

			}

			// updateTextFields();
		}

		// Catch Return for Pixel-X-Textfield
		// ////////////////////////////////////
		if (src instanceof JTextField) {
			if (src == jTextFieldPixelX) {
				oldScaleX = scaleX;
				oldScaleY = scaleY;
				oldPixelX = pixelX;
				oldPixelY = pixelY;
				String	input = jTextFieldPixelX.getText();

				// int wert = pixelX;
				int			pos = -1;

				try {
					pos = analysePixelInput(input);
					if (pos > -1) {
						jTextFieldPixelX.setCaretPosition(pos);
						jTextFieldPixelX.setSelectionStart(pos);
						jTextFieldPixelX.setSelectionEnd(pos + 1);
					}
				} catch (Exception e) {}
				if (pos == -1) {

					// IJ.write("Calc pixelx Value");
					pixelX = (Integer.valueOf(input)).intValue();
					if (pixelX > maxPixX) {
						pixelX = maxPixX;
					}
					if (pixelX < minPixX) {
						pixelX = minPixX;

						// jTextFieldPixelX.setText(String.valueOf(pixelX));
						// IJ.write("CheckAll values");
					}
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
					jTextFieldPixelY.requestFocus();
				}
			}

			// Catch Return for Pixel-Y-Textfield
			// ////////////////////////////////////
			if (src == jTextFieldPixelY) {
				oldScaleX = scaleX;
				oldScaleY = scaleY;
				oldPixelX = pixelX;
				oldPixelY = pixelY;
				String	input = jTextFieldPixelY.getText();

				// int wert = pixelY;
				int			pos = -1;

				try {
					pos = analysePixelInput(input);
					if (pos > -1) {
						jTextFieldPixelY.setCaretPosition(pos);
						jTextFieldPixelY.setSelectionStart(pos);
						jTextFieldPixelY.setSelectionEnd(pos + 1);
					}
				} catch (Exception e) {}
				if (pos == -1) {
					pixelY = (Integer.valueOf(input)).intValue();

					// IJ.write("inter: " + wert);
					// IJ.write("pos: " + pos);
					if (pixelY > maxPixY) {
						pixelY = maxPixY;
					}
					if (pixelY < minPixY) {
						pixelY = minPixY;

						// jTextFieldPixelY.setText(String.valueOf(pixelY));
					}
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
					jButtonOk.requestFocus();
				}
			}

			// Catch Return for Scale-X-Textfield
			// ////////////////////////////////////
			if (src == jTextFieldScaleX) {
				oldScaleX = scaleX;
				oldScaleY = scaleY;
				oldPixelX = pixelX;
				oldPixelY = pixelY;
				String	input = jTextFieldScaleX.getText();
				int			pos = -1;

				try {
					pos = analyseScaleInput(input);
					if (pos > -1) {
						jTextFieldScaleX.setCaretPosition(pos);
						jTextFieldScaleX.setSelectionStart(pos);
						jTextFieldScaleX.setSelectionEnd(pos + 1);
					}
				} catch (Exception e) {}
				if (pos == -1) {
					scaleX = (Double.valueOf(input)).doubleValue();

					// IJ.write("ScaleX " + scaleX);
					if (scaleX > maxScaleX) {
						scaleX = maxScaleX;
					}
					if (scaleX < minScaleX) {
						scaleX = minScaleX;

						// input = IJ.d2s(scaleX,2);
						// pos = input.lastIndexOf(",");
						// input = input.substring(0,pos) + "." + input.substring(pos+1);
						// jTextFieldScaleX.setText(input);
					}
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
					jTextFieldScaleY.requestFocus();
				}
			}

			// Catch Return for Scale-Y-Textfield
			// ////////////////////////////////////
			if (src == jTextFieldScaleY) {
				oldScaleX = scaleX;
				oldScaleY = scaleY;
				oldPixelX = pixelX;
				oldPixelY = pixelY;
				String	input = jTextFieldScaleY.getText();
				int			pos = -1;

				try {
					pos = analyseScaleInput(input);
					if (pos > -1) {
						jTextFieldScaleY.setCaretPosition(pos);
						jTextFieldScaleY.setSelectionStart(pos);
						jTextFieldScaleY.setSelectionEnd(pos + 1);
					}
				} catch (Exception e) {}
				if (pos == -1) {
					scaleY = (Double.valueOf(input)).doubleValue();

					// IJ.write("ScaleY " + scaleY);
					if (scaleY > maxScaleY) {
						scaleY = maxScaleY;
					}
					if (scaleY < minScaleY) {
						scaleY = minScaleY;

						// input = IJ.d2s(scaleY,2);
						// pos = input.lastIndexOf(",");
						// input = input.substring(0,pos) + "." + input.substring(pos+1);
						// jTextFieldScaleY.setText(input);
					}
					this.checkAllValues(src);
					this.updateTextFields();

					// this.invalidate();
					jButtonOk.requestFocus();
				}
			}
		}

	}


	/**
	 * Routine zur Nachrichtenbehandung von Fokuswechseln der Elemente der GUI.
	 * Hier muessen insbesondere Fokuswechsel der Textfelder behandelt werden.
	 * @param evt uebergebener FocusEvent, ausgeloest durch Fokuswechsel.
	 */
	public void focusLost(FocusEvent evt) {
		Object	src = evt.getSource();

		// Aus dem Focus-Event einfach einen Actionc-Event generieren, wenn
		// ein Textfeld verlassen wurde.
		if (src instanceof JTextField) {
			ActionEvent dummy = new ActionEvent(src, evt.getID(), evt.paramString());

			// this.actionPerformed(dummy);
		}
	}


	/**
	 * Routine zur Nachrichtenbehandung von Fokuswechseln der Elemente der GUI.
	 * @param evt uebergebener FocusEvent, ausgeloest durch Fokuswechsel.
	 */
	public void focusGained(FocusEvent evt) {}


	/**
	 * Analysiert den aus einem Textfeld uebernommenen String auf die darin enthaltene
	 * ganzzahlig numerische Benutzereingebe und prueft deren Gueltigkeit.
	 * Es wird die Psotion innerhalb des Einagbe-Strings zurueckgegeben, die das erste
	 * angetroffenen ungueltige (also nicht-numerische) Zeichen enthaelt.
	 * Enthaelt der String keine ungueltigen Eingaben, wird der Wert -1 zurueckgegeben.
	 * @param String Eingabestring aus den Textfiel-Element der GUI.
	 * @return int der Rueckgabenwert als Integer
	 */
	private int analysePixelInput(String input) {
		int i, result;

		result = -1;
		for (i = 0; i <= input.length(); i++) {

			// Character c = new Character();
			if (!Character.isDigit(input.charAt(i))) {
				result = i;
				i = input.length() + 1;
			}
		}
		return result;
	}


	/**
	 * Analysiert den aus einem Textfeld uebernommenen String auf die darin enthaltene
	 * reellwertige, numerische Benutzereingebe und prueft deren Gueltigkeit.
	 * Es wird die Psotion innerhalb des Einagbe-Strings zurueckgegeben, die das erste
	 * angetroffenen ungueltige (also nicht-numerische) Zeichen enthaelt.
	 * Enthaelt der String keine ungueltigen Eingaben, wird der Wert -1 zurueckgegeben.
	 * @param String Eingabestring aus den Textfiel-Element der GUI.
	 * @return int der Rueckgabenwert als Integer
	 */
	private int analyseScaleInput(String input) {
		int i, result;

		result = -1;
		boolean hasKomma = false;

		for (i = 0; i <= input.length(); i++) {

			// Character c = new Character();
			if (!Character.isDigit(input.charAt(i))) {
				if (input.charAt(i) == '.') {
					if (hasKomma) {
						result = i;
						i = input.length() + 1;
					} else {
						hasKomma = true;
					}
				} else {
					result = i;
					i = input.length() + 1;
				}
			}
		}
		return result;
	}


	/**
	 * Ueberprueft die Werte in allen Textfeldern auf deren numerische Gueltigkeit.
	 * Wird beim Fokuswechsel eines Textfeldes zu einer Schaltflaeche aufgerufen.
	 * @param src Das ausloesende GUI-Element, in einen Object-Typ gecastet.
	 */
	private void checkAllValues(Object src) {
		if (src == jTextFieldPixelX || src == jButtonMinusPixX || src == jButtonPlusPixX) {
			if (jCheckBoxProportions.isSelected()) {
				pixelY = oldPixelY * pixelX / oldPixelX;
				scaleX = (double) pixelX / (double) orgPixelX;
				scaleY = (double) pixelY / (double) orgPixelY;
			} else {
				scaleX = (double) pixelX / (double) orgPixelX;
			}

			if ((pixelX == 0) || (pixelY == 0) || (getImageSize() > maxImageSize)) {
				pixelX = oldPixelX;
				pixelY = oldPixelY;
				scaleX = oldScaleX;
				scaleY = oldScaleY;
			}
		}
		if (src == jTextFieldPixelY || src == jButtonMinusPixY || src == jButtonPlusPixY) {
			if (jCheckBoxProportions.isSelected()) {
				pixelX = oldPixelX * pixelY / oldPixelY;
				scaleY = (double) pixelY / (double) orgPixelY;
				scaleX = (double) pixelX / (double) orgPixelX;
			} else {
				scaleY = (double) pixelY / (double) orgPixelY;
			}

			if ((pixelX == 0) || (pixelY == 0) || (getImageSize() > maxImageSize)) {
				pixelX = oldPixelX;
				pixelY = oldPixelY;
				scaleX = oldScaleX;
				scaleY = oldScaleY;
			}
		}
		if (src == jTextFieldScaleX || src == jButtonMinusX || src == jButtonPlusX) {
			if (jCheckBoxProportions.isSelected()) {
				scaleY = oldScaleY * scaleX / oldScaleX;
				pixelX = (int) ((double) orgPixelX * scaleX);
				pixelY = (int) ((double) orgPixelY * scaleY);
			} else {
				pixelX = (int) ((double) orgPixelX * scaleX);
			}

			if ((pixelX == 0) || (pixelY == 0) || (getImageSize() > maxImageSize)) {
				pixelX = oldPixelX;
				pixelY = oldPixelY;
				scaleX = oldScaleX;
				scaleY = oldScaleY;
			}
		}
		if (src == jTextFieldScaleY || src == jButtonMinusY || src == jButtonPlusY) {
			if (jCheckBoxProportions.isSelected()) {
				scaleX = oldScaleX * scaleY / oldScaleY;
				pixelY = (int) ((double) orgPixelY * scaleY);
				pixelX = (int) ((double) orgPixelX * scaleX);
			} else {
				pixelY = (int) ((double) orgPixelY * scaleY);
			}

			if ((pixelX == 0) || (pixelY == 0) || (getImageSize() > maxImageSize)) {
				pixelX = oldPixelX;
				pixelY = oldPixelY;
				scaleX = oldScaleX;
				scaleY = oldScaleY;
			}
		}
	}


	/**
	 * Faengt Eingaben von der Tastatur ab. Dies ist noetig, um abzufragen, wenn ein
	 * Textfeld mit der Eingabetaste verlassen wird.
	 * @param evt KeyEvent, durch Tastatureinagben ausgeloest.
	 */
	public void keyReleased(KeyEvent evt) {}


	/**
	 * Faengt Eingaben von der Tastatur ab. Dies ist noetig, um abzufragen, wenn ein
	 * Textfeld mit der Eingabetaste verlassen wird.
	 * @param evt KeyEvent, durch Tastatureinagben ausgeloest.
	 */
	public void keyPressed(KeyEvent evt) {
		Object	src = evt.getSource();

		if (src == jButtonOk) {

			IJ.write("Holla return");
			ActionEvent dummy = new ActionEvent(src, evt.getID(), evt.paramString());

			this.actionPerformed(dummy);
		}
	}


	/**
	 * Faengt Eingaben von der Tastatur ab. Dies ist noetig, um abzufragen, wenn ein
	 * Textfeld mit der Eingabetaste verlassen wird.
	 * @param evt KeyEvent, durch Tastatureinagben ausgeloest.
	 */
	public void keyTyped(KeyEvent evt) {}

}




/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

