/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.sit is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.sit;

import jm.kidney.*;
import jm.sit.*;
import jm.extension.*;
import jm.util.*;

import ij.*;
import ij.io.*;
import ij.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;


/**
 * Realisiert einen Dialog zur Justierung der Pixel-Klassifizierung.
 * Der benutzer kann die Schwellenwerte der Klasse SITAnalysis per
 * Scheiberegler direkt veraendern und bekommt die neuen Klassifizierungswergebnisse
 * sofort angezeigt. Die SIT-Kurven werden beim verlassen des Dialoges entsprechned
 * der neu eingestellten Schwellenwerte neu angezeigt.
 * @see jm.sit.SITResults
 * @see jm.sit.SITAnalysis
 * @see jm.sit.ImageLabel
 * @version  2.3, 14/02/2000
 * @author   Jens Martin
 */
public class SITAdjuster extends JFrame /* JDialog */ implements ActionListener, ChangeListener {
	private SITAnalysis		analysisDialog = null;
	private Image					rightImage = null;
	private Image					leftImage = null;
	private Image					rightRefImage = null;
	private Image					leftRefImage = null;

	private MediaTracker	mediaTracker = new MediaTracker(this);

	private int						widthLeft = 0;
	private int						heightLeft = 0;
	public boolean				finished = false;

	private double				thCortexLeft;
	private double				thMedullaLeft;
	private double				thPelvisLeft;
	private double				thCortexRight;
	private double				thMedullaRight;
	private double				thPelvisRight;

	// gui elements
	JPanel								jPanelMain = new JPanel();
	GridBagLayout					gridBagLayout1 = new GridBagLayout();

	// JLabel jImageLabelRight = new JLabel();JLabel jImageLabelLeft = new JLabel();
	// JLabel jImageLabelRefRight = new JLabel();JLabel jImageLabelRefLeft = new JLabel();

	ImageLabel						jImageLabelRight = null;
	ImageLabel						jImageLabelLeft = null;
	ImageLabel						jImageLabelRefRight = null;
	ImageLabel						jImageLabelRefLeft = null;

	MultiLineLabel				jLabelLeftImage = new MultiLineLabel("right kidney\n(2 x zoom)");		// new JLabel();
	MultiLineLabel				jLabelRightImage = new MultiLineLabel("left kidney\n(2 x zoom)");		// new JLabel();

	JSlider								jSliderPelvisRight = new JSlider();
	JSlider								jSliderMedullaRight = new JSlider();
	JSlider								jSliderCortexRight = new JSlider();
	JPanel								jPanelRight = new JPanel();
	GridBagLayout					gridBagLayout2 = new GridBagLayout();
	JPanel								jPanelLeft = new JPanel();
	JSlider								jSliderPelvisLeft = new JSlider();
	GridBagLayout					gridBagLayout3 = new GridBagLayout();
	JLabel								jLabelPelvisRight = new JLabel();
	JLabel								jLabelMedullaRight = new JLabel();
	JLabel								jLabelCortexRight = new JLabel();
	JSlider								jSliderMedullaLeft = new JSlider();
	JSlider								jSliderCortexLeft = new JSlider();
	JLabel								jLabelPelvisLeft = new JLabel();
	JLabel								jLabelMedullaLeft = new JLabel();
	JLabel								jLabelCortexLeft = new JLabel();
	JLabel								jLabelBlackSpacerRight = new JLabel();
	JLabel								jLabelBlackSpacerLeft = new JLabel();
	ExJButton							jButtonApply = new ExJButton();
	ExJButton							jButtonCancel = new ExJButton();
	JLabel								jLabelDummy = new JLabel();


	/**
	 * Der Konstruktor.
	 * @param dlg Referenz auf den Dialog zur Anzeige der SIT-Kurven
	 * @param imgR Bild mit den eingefaerbten Pixelklassifizierungen fuer die rechte Niere
	 * @param imgL Bild mit den eingefaerbten Pixelklassifizierungen fuer die linke Niere
	 */
	public SITAdjuster(SITAnalysis dlg, Image imgR, Image imgL) {
		try {
			analysisDialog = dlg;
			rightImage = imgR;
			leftImage = imgL;
			rightRefImage = getScaledImage(analysisDialog.rightRefImage, 2.0);
			leftRefImage = getScaledImage(analysisDialog.leftRefImage, 2.0);
			jbInit();
			guiInit();
			thCortexLeft = analysisDialog.classTresholdCortex[JMConst.LEFT];
			thMedullaLeft = analysisDialog.classTresholdMedulla[JMConst.LEFT];
			thPelvisLeft = analysisDialog.classTresholdPelvis[JMConst.LEFT];
			thCortexRight = analysisDialog.classTresholdCortex[JMConst.RIGHT];
			thMedullaRight = analysisDialog.classTresholdMedulla[JMConst.RIGHT];
			thPelvisRight = analysisDialog.classTresholdPelvis[JMConst.RIGHT];

			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}


	/**
	 * Initialisierung der Objekte des Fensters. Von JBuilder automatisch eingefuegt.
	 */
	private void jbInit() throws Exception {

		// init the two image Labels
		jImageLabelRight = new ImageLabel(rightImage);
		jImageLabelLeft = new ImageLabel(leftImage);
		jImageLabelRefRight = new ImageLabel(rightRefImage);
		jImageLabelRefLeft = new ImageLabel(leftRefImage);

		jPanelMain.setLayout(gridBagLayout1);

		// jImageLabelRight.setText("jLabel1");
		// jLabelRightImage.setText("jLabel2");
		// jLabelLeftImage.setText("jLabel3");
		// jImageLabelLeft.setText("jLabel4");
		jSliderCortexLeft.setMinimum(50);
		jSliderCortexLeft.setMaximum(150);
		jSliderCortexLeft.setMajorTickSpacing(10);
		jSliderCortexLeft.setMinorTickSpacing(1);
		jSliderCortexLeft.setSnapToTicks(true);
		jSliderCortexRight.setMinimum(50);
		jSliderCortexRight.setMaximum(150);
		jSliderCortexRight.setMajorTickSpacing(10);
		jSliderCortexRight.setMinorTickSpacing(1);
		jSliderCortexRight.setSnapToTicks(true);
		jSliderPelvisLeft.setMinimum(50);
		jSliderPelvisLeft.setMaximum(150);
		jSliderPelvisLeft.setMajorTickSpacing(10);
		jSliderPelvisLeft.setMinorTickSpacing(1);
		jSliderPelvisLeft.setSnapToTicks(true);
		jSliderPelvisRight.setMinimum(50);

		// jPanelMain.setPreferredSize(new Dimension(231, 231));
		// jPanelMain.setMinimumSize(new Dimension(231, 231));
		jPanelMain.setForeground(Color.lightGray);
		jPanelMain.setBackground(Color.black);
		jSliderPelvisRight.setMaximum(150);
		jSliderPelvisRight.setMajorTickSpacing(10);
		jSliderPelvisRight.setMinorTickSpacing(1);
		jSliderPelvisRight.setSnapToTicks(true);
		jSliderMedullaLeft.setMinimum(50);
		jSliderMedullaLeft.setMaximum(150);
		jSliderMedullaLeft.setMajorTickSpacing(10);
		jSliderMedullaLeft.setMinorTickSpacing(1);
		jSliderMedullaLeft.setSnapToTicks(true);
		jSliderMedullaRight.setMinimum(50);
		jSliderMedullaRight.setMaximum(150);
		jSliderMedullaRight.setMajorTickSpacing(10);
		jSliderMedullaRight.setMinorTickSpacing(1);
		jSliderMedullaRight.setSnapToTicks(true);

		jLabelPelvisRight.setText("-  threshold renal pelvis: 1.00 +");
		jLabelMedullaRight.setText("-  threshold renal medulla: 1.00 +");
		jLabelCortexRight.setText("-  threshold renal cortex: 1.00 +");
		jLabelPelvisLeft.setText("-  threshold renal pelvis: 1.00 +");
		jLabelMedullaLeft.setText("-  threshold renal medulla: 1.00 +");
		jLabelCortexLeft.setText("-  threshold renal cortex: 1.00 +");
		Font	labelFont = new Font("Dialog", 1, 11);

		jLabelLeftImage.setBackground(Color.black);
		jLabelLeftImage.setFont(new Font("Dialog", 1, 11));
		jLabelRightImage.setForeground(Color.lightGray);
		jLabelRightImage.setBackground(Color.black);
		jLabelRightImage.setFont(new Font("Dialog", 1, 11));
		jLabelLeftImage.setForeground(Color.lightGray);
		jSliderPelvisLeft.setForeground(Color.lightGray);
		jSliderPelvisLeft.setBackground(Color.black);
		jSliderMedullaLeft.setForeground(Color.lightGray);
		jSliderMedullaLeft.setBackground(Color.black);
		jSliderCortexLeft.setForeground(Color.lightGray);
		jSliderCortexLeft.setBackground(Color.black);
		jSliderPelvisRight.setForeground(Color.lightGray);
		jSliderPelvisRight.setBackground(Color.black);
		jSliderMedullaRight.setForeground(Color.lightGray);
		jSliderMedullaRight.setBackground(Color.black);
		jSliderCortexRight.setForeground(Color.lightGray);
		jSliderCortexRight.setBackground(Color.black);
		jPanelRight.setForeground(Color.lightGray);
		jPanelRight.setBackground(Color.black);
		jPanelLeft.setForeground(Color.lightGray);
		jPanelLeft.setBackground(Color.black);
		jLabelCortexRight.setForeground(Color.lightGray);
		jLabelCortexRight.setBackground(Color.black);
		jLabelMedullaRight.setForeground(Color.lightGray);
		jLabelMedullaRight.setBackground(Color.black);
		jLabelPelvisRight.setForeground(Color.lightGray);
		jLabelPelvisRight.setBackground(Color.black);
		jLabelCortexLeft.setForeground(Color.lightGray);
		jLabelCortexLeft.setBackground(Color.black);
		jLabelMedullaLeft.setForeground(Color.lightGray);
		jLabelMedullaLeft.setBackground(Color.black);
		jLabelPelvisLeft.setForeground(Color.lightGray);
		jLabelPelvisLeft.setBackground(Color.black);
		jLabelPelvisRight.setFont(labelFont);
		jLabelMedullaRight.setFont(labelFont);
		jLabelCortexRight.setFont(labelFont);
		jLabelPelvisLeft.setFont(labelFont);
		jLabelMedullaLeft.setFont(labelFont);
		jLabelCortexLeft.setFont(labelFont);

		jLabelBlackSpacerRight.setText("      ");
		jLabelBlackSpacerLeft.setText("      ");

		// jButtonApply.setText("jButton1");
		jButtonApply.setMargin(new Insets(0, 14, 0, 14));
		jButtonApply.setForeground(Color.lightGray);
		jButtonApply.setText("apply values");
		jButtonApply.setBackground(Color.darkGray);
		jButtonApply.setFont(new Font("Dialog", 1, 11));
		jButtonApply.setOpaque(true);

		// jImageLabelRefLeft2.setText("   ");
		// jImageLabelRefRight2.setText("   ");
		jButtonCancel.setText("cancel");
		jButtonCancel.setBackground(Color.darkGray);
		jButtonCancel.setFont(new Font("Dialog", 1, 11));
		jButtonCancel.setOpaque(true);
		jLabelDummy.setText("                   ");
		jButtonCancel.setMargin(new Insets(0, 14, 0, 14));
		jButtonCancel.setForeground(Color.lightGray);

		// jButtonCancel.setText("jButton1");
		jPanelLeft.setLayout(gridBagLayout3);
		jPanelRight.setLayout(gridBagLayout2);
		this.getContentPane().add(jPanelMain, BorderLayout.CENTER);

		jPanelMain.add(jPanelLeft, new GridBagConstraints2(0, 0, 3, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(5, 0, 0, 0), 0, 0));
		jPanelLeft.add(jSliderPelvisLeft, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(5, 0, 0, 0), 0, 0));
		jPanelLeft.add(jImageLabelLeft, new GridBagConstraints2(1, 0, 1, 6, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jSliderMedullaLeft, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jSliderCortexLeft, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jLabelPelvisLeft, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jLabelMedullaLeft, new GridBagConstraints2(3, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jLabelCortexLeft, new GridBagConstraints2(3, 5, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jLabelLeftImage, new GridBagConstraints2(0, 6, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jLabelBlackSpacerLeft, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelLeft.add(jImageLabelRefLeft, new GridBagConstraints2(0, 0, 1, 6, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jButtonCancel, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 0, 8, 0), 0, 0));
		jPanelMain.add(jButtonApply, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 0, 8, 0), 0, 0));

		jPanelMain.add(jPanelRight, new GridBagConstraints2(0, 1, 3, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(10, 0, 0, 0), 0, 0));
		jPanelRight.add(jSliderPelvisRight, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(5, 0, 0, 0), 0, 0));
		jPanelRight.add(jImageLabelRight, new GridBagConstraints2(1, 0, 1, 6, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jSliderMedullaRight, new GridBagConstraints2(3, 2, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jSliderCortexRight, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jLabelPelvisRight, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jLabelMedullaRight, new GridBagConstraints2(3, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jLabelCortexRight, new GridBagConstraints2(3, 5, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jLabelRightImage, new GridBagConstraints2(0, 6, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jLabelBlackSpacerRight, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelRight.add(jImageLabelRefRight, new GridBagConstraints2(0, 0, 1, 6, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelDummy, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
	} 


	/**
	 * Nimmt zusaetzliche Initialisierungen von Objekten der GUI vor.
	 * Wird vor dem ersten Anzeigen des Plugins aufgerufen.
	 */
	private void guiInit() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			System.err.println("Can't set GUI to look and feel: " + e);
		} 

		jSliderCortexLeft.setValue((int) (analysisDialog.classTresholdCortex[JMConst.LEFT] * 100.0));
		jSliderCortexRight.setValue((int) (analysisDialog.classTresholdCortex[JMConst.RIGHT] * 100.0));
		jSliderPelvisLeft.setValue((int) (analysisDialog.classTresholdPelvis[JMConst.LEFT] * 100.0));
		jSliderPelvisRight.setValue((int) (analysisDialog.classTresholdPelvis[JMConst.RIGHT] * 100.0));
		jSliderMedullaLeft.setValue((int) (analysisDialog.classTresholdMedulla[JMConst.LEFT] * 100.0));
		jSliderMedullaRight.setValue((int) (analysisDialog.classTresholdMedulla[JMConst.RIGHT] * 100.0));

		jSliderCortexLeft.setRequestFocusEnabled(false);
		jSliderCortexRight.setRequestFocusEnabled(false);
		jSliderPelvisLeft.setRequestFocusEnabled(false);
		jSliderPelvisRight.setRequestFocusEnabled(false);
		jSliderMedullaLeft.setRequestFocusEnabled(false);
		jSliderMedullaRight.setRequestFocusEnabled(false);


		jButtonApply.addActionListener(this);
		jButtonCancel.addActionListener(this);
		jSliderCortexLeft.addChangeListener(this);
		jSliderCortexRight.addChangeListener(this);
		jSliderMedullaLeft.addChangeListener(this);
		jSliderMedullaRight.addChangeListener(this);
		jSliderPelvisLeft.addChangeListener(this);
		jSliderPelvisRight.addChangeListener(this);

		jImageLabelLeft.setBorder(2);		// (BorderFactory.createLineBorder(Color.black,2));
		jImageLabelLeft.setBorderColor(Color.black);
		jImageLabelRight.setBorder(2);	// (BorderFactory.createLineBorder(Color.black,2));
		jImageLabelRight.setBorderColor(Color.black);
		jImageLabelRefLeft.setBorder(2);	// (BorderFactory.createLineBorder(Color.black,2));
		jImageLabelRefLeft.setBorderColor(Color.black);
		jImageLabelRefRight.setBorder(2);		// (BorderFactory.createLineBorder(Color.black,2));
		jImageLabelRefRight.setBorderColor(Color.black);

		if (!analysisDialog.autoClassification[JMConst.LEFT]) {
			jImageLabelLeft.setEnabled(false);
			jImageLabelRefLeft.setEnabled(false);
			jSliderCortexLeft.setEnabled(false);
			jSliderMedullaLeft.setEnabled(false);
			jSliderPelvisLeft.setEnabled(false);
		} 
		if (!analysisDialog.autoClassification[JMConst.RIGHT]) {
			jImageLabelRight.setEnabled(false);
			jImageLabelRefRight.setEnabled(false);
			jSliderCortexRight.setEnabled(false);
			jSliderMedullaRight.setEnabled(false);
			jSliderPelvisRight.setEnabled(false);
		} 

		this.setTitle(" Adjust SIT-Results");
		this.setBackground(Color.black);
		this.setForeground(Color.lightGray);
		this.pack();
		this.setResizable(false);

		Rectangle rec = this.getBounds();
		Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();

		this.setLocation(((screensize.width - rec.width) / 2), ((screensize.height - rec.height) / 2));

		this.setVisible(true);
		ChangeEvent evt;

		evt = new ChangeEvent((Object) jSliderMedullaRight);
		this.stateChanged(evt);
		evt = new ChangeEvent((Object) jSliderCortexRight);
		this.stateChanged(evt);
		evt = new ChangeEvent((Object) jSliderPelvisRight);
		this.stateChanged(evt);
		evt = new ChangeEvent((Object) jSliderMedullaLeft);
		this.stateChanged(evt);
		evt = new ChangeEvent((Object) jSliderCortexLeft);
		this.stateChanged(evt);
		evt = new ChangeEvent((Object) jSliderPelvisLeft);
		this.stateChanged(evt);

		// this.setModal(true);
	} 


	/**
	 * Aktualisiert das Klassifizierungsbild.
	 * @param half Die Bildhaelfte (linke=0, oder rechte=1 Niere)
	 * @Param img  das Klassifizierungsbild im Datentyp java.awt.Image
	 */
	public void updateImage(int half, Image img) {
		if (half == JMConst.LEFT) {
			if (jImageLabelLeft != null) {
				leftImage = img;
				jImageLabelLeft.setImage(img);
				jImageLabelLeft.repaint();

				// this.repaint();
			} 
		} 
		if (half == JMConst.RIGHT) {
			if (jImageLabelRight != null) {
				rightImage = img;
				jImageLabelRight.setImage(img);
				jImageLabelRight.repaint();

				// this.repaint();
			} 
		} 
	} 


	/**
	 * Routine zur Nachrichtenbehandung von Mausklicks oder Tastatureingaben.
	 * Stellt fest, auf welche Schaltflaechen des Dialogs geklickt wurde.
	 * @param evt uebergebener ActionEvent, ausgeloest durch eine Mausklick oder Tastatureingabe.
	 */
	public void actionPerformed(ActionEvent evt) {
		Object	src = evt.getSource();

		if (src instanceof JButton) {
			if (src == jButtonApply) {
				if (analysisDialog.autoClassification[JMConst.LEFT]) {

					// IJ.write("calculating new curves left");
					analysisDialog.classTresholdCortex[JMConst.LEFT] = thCortexLeft;
					analysisDialog.classTresholdMedulla[JMConst.LEFT] = thMedullaLeft;
					analysisDialog.classTresholdPelvis[JMConst.LEFT] = thPelvisLeft;
					analysisDialog.classifyPixels(JMConst.LEFT, analysisDialog.classTresholdPelvis[JMConst.LEFT], analysisDialog.classTresholdMedulla[JMConst.LEFT], analysisDialog.classTresholdCortex[JMConst.LEFT]);
					analysisDialog.calcPixelCurve(JMConst.LEFT, JMConst.MEDULLA);
					analysisDialog.calcPixelCurve(JMConst.LEFT, JMConst.CORTEX);
					analysisDialog.initResultWindow(JMConst.LEFT);
					analysisDialog.sitResults.setSmooth(false);
					analysisDialog.sitResults.updateImageLabel(JMConst.RIGHT, analysisDialog.ipLeftKidney);
				} 

				if (analysisDialog.autoClassification[JMConst.RIGHT]) {

					// IJ.write("calculating new curves right");
					analysisDialog.classTresholdCortex[JMConst.RIGHT] = thCortexRight;
					analysisDialog.classTresholdMedulla[JMConst.RIGHT] = thMedullaRight;
					analysisDialog.classTresholdPelvis[JMConst.RIGHT] = thPelvisRight;
					analysisDialog.classifyPixels(JMConst.RIGHT, analysisDialog.classTresholdPelvis[JMConst.RIGHT], analysisDialog.classTresholdMedulla[JMConst.RIGHT], analysisDialog.classTresholdCortex[JMConst.RIGHT]);
					analysisDialog.calcPixelCurve(JMConst.RIGHT, JMConst.MEDULLA);
					analysisDialog.calcPixelCurve(JMConst.RIGHT, JMConst.CORTEX);
					analysisDialog.initResultWindow(JMConst.RIGHT);
					analysisDialog.sitResults.setSmooth(false);
					analysisDialog.sitResults.updateImageLabel(JMConst.LEFT, analysisDialog.ipRightKidney);
				} 
				analysisDialog.setMinMaxAxisValues(JMConst.MEDULLA);
				analysisDialog.setMinMaxAxisValues(JMConst.CORTEX);

				this.finished = true;
				this.setVisible(false);
				this.dispose();
			} 
			if (src == jButtonCancel) {
				this.finished = true;
				this.setVisible(false);
				this.dispose();
			} 
		} 
	} 


	/**
	 * Wird aufgerufen, wenn einer der Schieberegler zur Justierung der Schwellenwerte
	 * vom Benutzer veraendert wird.
	 * @param evt ChangeEvent, ausgeloest durch Bewegung eines Schiebereglers.
	 */
	public void stateChanged(ChangeEvent evt) {
		Object	src = evt.getSource();

		// String text = null;
		// double val = 1.0;
		if (src == jSliderCortexLeft) {
			double	val = (double) jSliderCortexLeft.getValue() / 100.0;

			// IJ.write("Slide Value:" +val);
			thCortexLeft = val;
			String	text = "-  threshold renal cortex: ";

			text = text + d2s(val, 2);	// ((d2s(val,2)).substring(2)).replace(',','.');
			jLabelCortexLeft.setText(text + " +");
			analysisDialog.classifyPixels(JMConst.LEFT, thPelvisLeft, thMedullaLeft, thCortexLeft);
			this.updateImage(JMConst.LEFT, getScaledImage(analysisDialog.ipLeftKidney, 2.0));

		} 
		if (src == jSliderCortexRight) {
			double	val = (double) jSliderCortexRight.getValue() / 100.0;

			thCortexRight = val;
			String	text = "-  threshold renal cortex: ";

			text = text + d2s(val, 2);	// ((d2s(val,2)).substring(2)).replace(',','.');
			jLabelCortexRight.setText(text + " +");
			analysisDialog.classifyPixels(JMConst.RIGHT, thPelvisRight, thMedullaRight, thCortexRight);
			this.updateImage(JMConst.RIGHT, getScaledImage(analysisDialog.ipRightKidney, 2.0));
		} 
		if (src == jSliderMedullaLeft) {
			double	val = (double) jSliderMedullaLeft.getValue() / 100.0;

			thMedullaLeft = val;
			String	text = "-  threshold renal medulla: ";

			text = text + d2s(val, 2);	// ((d2s(val,2)).substring(2)).replace(',','.');
			jLabelMedullaLeft.setText(text + " +");
			analysisDialog.classifyPixels(JMConst.LEFT, thPelvisLeft, thMedullaLeft, thCortexLeft);
			this.updateImage(JMConst.LEFT, getScaledImage(analysisDialog.ipLeftKidney, 2.0));

		} 
		if (src == jSliderMedullaRight) {
			double	val = (double) jSliderMedullaRight.getValue() / 100.0;

			thMedullaRight = val;
			String	text = "-  threshold renal medulla: ";

			text = text + d2s(val, 2);	// ((d2s(val,2)).substring(2)).replace(',','.');
			jLabelMedullaRight.setText(text + " +");
			analysisDialog.classifyPixels(JMConst.RIGHT, thPelvisRight, thMedullaRight, thCortexRight);
			this.updateImage(JMConst.RIGHT, getScaledImage(analysisDialog.ipRightKidney, 2.0));
		} 
		if (src == jSliderPelvisLeft) {
			double	val = (double) jSliderPelvisLeft.getValue() / 100.0;

			thPelvisLeft = val;
			String	text = "-  threshold renal pelvis: ";

			text = text + d2s(val, 2);	// ((d2s(val,2)).substring(2)).replace(',','.');
			jLabelPelvisLeft.setText(text + " +");
			analysisDialog.classifyPixels(JMConst.LEFT, thPelvisLeft, thMedullaLeft, thCortexLeft);
			this.updateImage(JMConst.LEFT, getScaledImage(analysisDialog.ipLeftKidney, 2.0));

		} 
		if (src == jSliderPelvisRight) {
			double	val = (double) jSliderPelvisRight.getValue() / 100.0;

			thPelvisRight = val;
			String	text = "-  threshold renal pelvis: ";

			text = text + d2s(val, 2);	// ((d2s(val,2)).substring(2)).replace(',','.');
			jLabelPelvisRight.setText(text + " +");
			analysisDialog.classifyPixels(JMConst.RIGHT, thPelvisRight, thMedullaRight, thCortexRight);
			this.updateImage(JMConst.RIGHT, getScaledImage(analysisDialog.ipRightKidney, 2.0));
		} 
	} 


	/**
	 * Hilfsfunktion. Wandelt einen Double in einen String um. Erweitert die ImageJ-d2s-Methode
	 * um einige zusaetzliche Sicherheitsabfragen.
	 * @param d der Double-Wert
	 * @param l die Anzahl der Nachkommastellen
	 * @return String der generierte String
	 */
	private String d2s(double d, int l) {
		String	result = IJ.d2s(d, l);

		result = result.replace(',', '.');
		while ((result.length() > 1) && (result.charAt(0) == '0') && (result.charAt(1) != '.')) {
			result = result.substring(1);
		} 
		return result;
	} 


	/**
	 * Erzeugt eine Instanz eines java.awt.Image, das dem uebergebenen ImagePlus-Bild
	 * entspricht und um einen angegebenen Faktor skaliert wurde.
	 * Zum Skalieren werden Standard-AWT-Methoden benutzt, weil diese sehr schnell sind.
	 * @param imp   das ImagePlus-Bildobjekt
	 * @param scale die gewuenschte Skalierung
	 * @return Image Ergebnisbild als java.awt.Image-Datentyp
	 */
	private Image getScaledImage(ImagePlus imp, double scale) {
		if (imp == null) {
			return null;
		} 
		Image scaledImage = null;
		Image originalImage = imp.getImage();

		try {
			int x = (int) ((double) imp.getWidth() * scale);
			int y = (int) ((double) imp.getHeight() * scale);

			scaledImage = originalImage.getScaledInstance(x, y, originalImage.SCALE_SMOOTH);
			mediaTracker.addImage(scaledImage, 0);
			mediaTracker.waitForAll();
		} catch (Exception e) {
			e.printStackTrace();
			scaledImage.flush();
			scaledImage = null;
			return originalImage;
		} 
		originalImage.flush();
		originalImage = null;
		return scaledImage;
	} 


	/**
	 * Setzt den Wertebereich der Schieberegler. Damit kann festgelegt werden, in welchem
	 * Umfang die Schwellenwerte veraendert werden koennen. Die Schwellenwerte werden von der
	 * Berechnungsklasse SITAnalysis mit 1,0 intialisiert. Der min- und max-Wert wird durch
	 * die Einstellungen im Voreinstellungs-Dialog (jm.kidney.PresetsDialog) festgelegt.
	 * @param min   der minimal erlaubte Wert der Schieberegler
	 * @param max   der maximal erlaubte Wert der Schieberegler
	 */
	public void setAdjustmentRange(double min, double max) {
		int smin = (int) (min * 100.0);
		int smax = (int) (max * 100.0);

		jSliderCortexLeft.setMinimum(smin);
		jSliderCortexLeft.setMaximum(smax);
		jSliderMedullaLeft.setMinimum(smin);
		jSliderMedullaLeft.setMaximum(smax);
		jSliderPelvisLeft.setMinimum(smin);
		jSliderPelvisLeft.setMaximum(smax);

		jSliderCortexRight.setMinimum(smin);
		jSliderCortexRight.setMaximum(smax);
		jSliderMedullaRight.setMinimum(smin);
		jSliderMedullaRight.setMaximum(smax);
		jSliderPelvisRight.setMinimum(smin);
		jSliderPelvisRight.setMaximum(smax);

		this.repaint();
	} 

}


/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

