/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * The package jm.sit is part of the Renal Function Project
 * for analysis of dynamic contrast medium evalutions MRT-Images
 * of the Kidneys.
 * 
 * Copyright (C) 1999 / 2000 Jens Martin
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jm.sit;

import jm.kidney.*;
import jm.util.*;
import jm.sit.*;
import jm.extension.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import jm.kidney.*;
import jm.sit.*;
import jm.util.*;		// 2000.7.31 tha: Fuer GridBagConstraints2

import ij.*;
import ij.io.*;
import ij.gui.*;


/**
 * Diese Klasse realisiert einen Dialog zur Anzeige der berechneten
 * Signal-Intensitaets-Zeit-Kurven. Die Daten werden von der Berechnungsklasse
 * SITAnalysis uebergeben.
 * @see jm.sit.SITAnalysis
 * @see jm.sit.SITAdjuster
 * @version  4.1, 14/02/2000
 * @author   Jens Martin
 */
public class SITResults extends JFrame implements ActionListener, MouseListener {
	private SITAnalysis		sitAnalysis = null;
	private SITAdjuster		sitAdjuster = null;
	private Image					rightImage = null;
	private Image					leftImage = null;
	private MediaTracker	mediaTracker = new MediaTracker(this);
	public boolean				okPressed = false;
	private String				dialogTitle = " SIT - Results";
	private Rectangle			rec = null;

	private Dimension			CurveSize = new Dimension(400, 190);
	private double[]			averageGrayLeft = null;
	private double[]			averageGrayRight = null;
	private double[]			standardDevLeft = null;
	private double[]			standardDevRight = null;
	private double[]			medullaAverageLeft = null;
	private double[]			medullaAverageRight = null;
	private double[]			medullaDevLeft = null;
	private double[]			medullaDevRight = null;
	private double[]			cortexAverageLeft = null;
	private double[]			cortexAverageRight = null;
	private double[]			cortexDevLeft = null;
	private double[]			cortexDevRight = null;

	private Color					myYellow = new Color(243, 239, 118);
	private Color					myRed = new Color(227, 75, 75);

	private ImageWindow		winLeft = null;
	private ImageWindow		winRight = null;

	private double				adjustmentMin = 0.5;
	private double				adjustmentMax = 1.5;

	// private Image dummyImage = new java.awt.GrayImage();
	JPanel								jPanelMain = new JPanel();
	GridBagLayout					gridBagLayoutMainPanel = new GridBagLayout();

	JLabelResults					jLabelResultsKidney = new JLabelResults();
	JLabelResults					jLabelResultsMedulla = new JLabelResults();
	JLabelResults					jLabelResultsCortex = new JLabelResults();

	JLabel								jLabelXMinKidney = new JLabel();
	JLabel								jLabelXMaxKidney = new JLabel();
	JLabel								jLabelYMaxKidney = new JLabel();
	JLabel								jLabelYMinKidney = new JLabel();
	JLabel								jLabelXMinMedulla = new JLabel();
	JLabel								jLabelXMaxMedulla = new JLabel();
	JLabel								jLabelYMaxMedulla = new JLabel();
	JLabel								jLabelYMinMedulla = new JLabel();
	JLabel								jLabelXMinCortex = new JLabel();
	JLabel								jLabelXMaxCortex = new JLabel();
	JLabel								jLabelYMinCortex = new JLabel();
	JLabel								jLabelYMaxCortex = new JLabel();
	JLabel								jLabelXTextKidney = new JLabel();
	JLabel								jLabelXTextMedulla = new JLabel();
	JLabel								jLabelXTextCortex = new JLabel();
	JLabel								jLabelHeadlineKidney = new JLabel();
	JLabel								jLabelHeadlineMedulla = new JLabel();
	JLabel								jLabelHeadlineCortex = new JLabel();


	JLabel								jLabelDummyKidneyYAxis = new JLabel();
	JLabel								jLabelDummyMedullaYAxis = new JLabel();
	JLabel								jLabelDummyXAxis = new JLabel();
	JLabel								jLabelDummyCortexYAxis1 = new JLabel();



	JPanel								jPanelButtons = new JPanel();
	GridBagLayout					gridBagLayoutButtonPanel = new GridBagLayout();

	/*
	 * JCheckBox jCheckBoxDeviation = new JCheckBox();
	 * JCheckBox jCheckBoxAverage = new JCheckBox();
	 * JCheckBox jCheckBoxSmooth = new JCheckBox();
	 * JCheckBox jCheckBoxShowMarks = new JCheckBox();
	 */

	/*
	 * JRadioButton jCheckBoxDeviation = new JRadioButton();
	 * JRadioButton jCheckBoxAverage = new JRadioButton();
	 * JRadioButton jCheckBoxSmooth = new JRadioButton();
	 * JRadioButton jCheckBoxShowMarks = new JRadioButton();
	 */

	JRadioButton					jCheckBoxDeviationMain = new JRadioButton();
	JRadioButton					jCheckBoxDeviationMedulla = new JRadioButton();
	JRadioButton					jCheckBoxSmoothMain = new JRadioButton();
	JRadioButton					jCheckBoxShowMarksMain = new JRadioButton();

	ExJButton							jButtonOk = new ExJButton();
	ExJButton							jButtonTextExport = new ExJButton();
	ExJButton							jButtonAdjustParameters = new ExJButton();


	JPanel								jPanelImages = new JPanel();
	GridBagLayout					gridBagLayoutImagePanel = new GridBagLayout();

	ImageLabel						jImageLabelRight = null;
	ImageLabel						jImageLabelLeft = null;

	// JLabel jImageLabelRight = new JLabel();JLabel jImageLabelLeft = new JLabel();
	MultiLineLabel				jLabelYTextLeft = new MultiLineLabel("left\nkidney\n\n(2 x zoom)");		// new JLabel();
	MultiLineLabel				jLabelYTextRight = new MultiLineLabel("right\nkidney\n\n(2 x zoom)");		// new JLabel();
	JLabel								jLabelDummyButton = new JLabel();
	javax.swing.JLabel		jLabelMainButtons = new javax.swing.JLabel();
	JRadioButton					jCheckBoxSmoothMedulla = new JRadioButton();
	JRadioButton					jCheckBoxShowMarksMedulla = new JRadioButton();
	JRadioButton					jCheckBoxDeviationCortex = new JRadioButton();
	JRadioButton					jCheckBoxSmoothCortex = new JRadioButton();
	JRadioButton					jCheckBoxShowMarksCortex = new JRadioButton();
	javax.swing.JLabel		jLabelMedullaButtons = new javax.swing.JLabel();
	javax.swing.JLabel		jLabelCortexButtons = new javax.swing.JLabel();


	/**
	 * Der Konstruktor. Er bekommt eine Referenz auf die Berechnungsklasse uebergeben.
	 * @param SITdlg  die Referenz auf die Berechnungsklasse SITAnalysis
	 * @param imgL das eingefaerbte Klassifizierungsbild der linken Niere.
	 * @param imgR das eingefaerbte Klassifizierungsbild der rechten Niere.
	 */
	public SITResults(SITAnalysis SITdlg, ImagePlus imgL, ImagePlus imgR) {
		try {
			sitAnalysis = SITdlg;
			rightImage = getScaledImage(imgR, 2.0);
			leftImage = getScaledImage(imgL, 2.0);
			jbInit();
			guiInit();
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		} 

	}


	/**
	 * Initialisierung der Objekte des Fensters. Von JBuilder automatisch eingefuegt.
	 */
	private void jbInit() throws Exception {

		// init the two image Labels
		jImageLabelRight = new ImageLabel(rightImage);
		jImageLabelLeft = new ImageLabel(leftImage);
		this.setBackground(Color.black);
		this.setForeground(Color.lightGray);

		jPanelMain.setLayout(gridBagLayoutMainPanel);
		jPanelMain.setForeground(Color.lightGray);
		jPanelMain.setBackground(Color.black);
		jLabelResultsKidney.setText("gray value");
		jLabelResultsKidney.setForeground(Color.white);
		jLabelResultsKidney.setPreferredSize(CurveSize);
		jLabelResultsKidney.setMinimumSize(CurveSize);
		jLabelResultsKidney.setMaximumSize(CurveSize);
		jLabelResultsKidney.setBackground(Color.black);
		jLabelResultsKidney.setOpaque(true);
		jLabelXMinKidney.setText("   0");
		jLabelXMaxKidney.setText(" 180");
		jLabelYMaxKidney.setText("  42");
		jLabelYMinKidney.setText("   0");
		jLabelYMaxMedulla.setText("  42");
		jLabelResultsMedulla.setText("gray value");
		jLabelResultsMedulla.setPreferredSize(CurveSize);
		jLabelResultsMedulla.setMinimumSize(CurveSize);
		jLabelResultsMedulla.setMaximumSize(CurveSize);
		jLabelResultsMedulla.setForeground(Color.white);
		jLabelResultsMedulla.setBackground(Color.black);
		jLabelResultsMedulla.setOpaque(true);
		jLabelResultsCortex.setPreferredSize(CurveSize);
		jLabelResultsCortex.setMinimumSize(CurveSize);
		jLabelResultsCortex.setMaximumSize(CurveSize);
		jLabelResultsCortex.setForeground(Color.white);
		jLabelResultsCortex.setBackground(Color.black);
		jLabelResultsCortex.setOpaque(true);
		jLabelResultsCortex.setText("gray value");

		jLabelYMinMedulla.setText("   0");
		jLabelXMinMedulla.setText("   0");
		jLabelXMaxMedulla.setText(" 180");

		// jButtonOk.setText("jButton1");
		jButtonOk.setMargin(new Insets(0, 4, 0, 4));
		jButtonOk.setForeground(Color.lightGray);
		jButtonOk.setText("Ok");
		jButtonOk.setBackground(Color.darkGray);
		jButtonOk.setFont(new Font("Dialog", 1, 11));
		jButtonOk.setOpaque(true);

		// jButtonTextExport.setText("jButton1");
		jButtonTextExport.setMargin(new Insets(0, 4, 0, 4));
		jButtonTextExport.setForeground(Color.lightGray);
		jButtonTextExport.setText("Export Values");
		jButtonTextExport.setBackground(Color.darkGray);
		jButtonTextExport.setFont(new Font("Dialog", 1, 11));
		jButtonTextExport.setOpaque(true);
		jButtonAdjustParameters.setMargin(new Insets(2, 4, 2, 4));
		jButtonAdjustParameters.setForeground(Color.lightGray);
		jButtonAdjustParameters.setText("Adjust Parameters");
		jButtonAdjustParameters.setBackground(Color.darkGray);
		jButtonAdjustParameters.setFont(new Font("Dialog", 1, 11));
		jButtonAdjustParameters.setOpaque(true);

		jLabelYTextLeft.setForeground(Color.lightGray);
		jLabelYTextLeft.setBackground(Color.black);
		jLabelYTextLeft.setFont(new Font("Dialog", 1, 11));
		jLabelYTextRight.setForeground(Color.lightGray);
		jLabelYTextRight.setBackground(Color.black);
		jLabelYTextRight.setFont(new Font("Dialog", 1, 11));
		jLabelDummyButton.setText("      ");
		jLabelDummyButton.setBackground(Color.black);
		jLabelMainButtons.setText("whole kidney");
		jLabelMainButtons.setForeground(Color.lightGray);
		jLabelMainButtons.setBackground(Color.black);
		jLabelMainButtons.setFont(new Font("Dialog", 1, 11));

		// jLabelYTextLeft.setText("Standard-Dev.");
		// jLabelYTextRight.setText("Standard-Dev.");
		jLabelXTextKidney.setText("time (sec.)");
		jLabelXTextMedulla.setText("time (sec.)");
		jLabelXMaxKidney.setFont(new Font("Monospaced", 0, 10));
		jLabelHeadlineMedulla.setText("results medulla");
		jLabelHeadlineMedulla.setForeground(Color.lightGray);
		jLabelHeadlineMedulla.setFont(new Font("Dialog", 1, 11));
		jLabelHeadlineCortex.setText("results cortex");
		jLabelHeadlineCortex.setForeground(Color.lightGray);
		jLabelHeadlineCortex.setFont(new Font("Dialog", 1, 11));
		jLabelXMaxKidney.setForeground(Color.white);
		jLabelXMinKidney.setFont(new Font("Monospaced", 0, 10));
		jLabelXMinKidney.setForeground(Color.white);
		jLabelXMaxMedulla.setFont(new Font("Monospaced", 0, 10));
		jLabelXMaxMedulla.setForeground(Color.white);
		jLabelXMinMedulla.setFont(new Font("Monospaced", 0, 10));
		jLabelXMinMedulla.setForeground(Color.white);
		jLabelYMaxKidney.setFont(new Font("Monospaced", 0, 10));
		jLabelYMaxKidney.setForeground(Color.white);
		jLabelYMinKidney.setFont(new Font("Monospaced", 0, 10));
		jLabelYMinKidney.setForeground(Color.white);
		jLabelYMaxMedulla.setFont(new Font("Monospaced", 0, 10));
		jLabelYMaxMedulla.setForeground(Color.white);
		jLabelYMinMedulla.setFont(new Font("Monospaced", 0, 10));
		jLabelYMinMedulla.setForeground(Color.white);
		jLabelXTextKidney.setFont(new Font("Dialog", 0, 10));
		jLabelXTextKidney.setForeground(Color.white);
		jLabelXTextMedulla.setFont(new Font("Dialog", 0, 10));
		jLabelXTextMedulla.setForeground(Color.white);

		jCheckBoxDeviationMedulla.setRequestFocusEnabled(false);
		jCheckBoxDeviationMedulla.setForeground(Color.lightGray);
		jCheckBoxDeviationMedulla.setText("standard deviation");
		jCheckBoxSmoothMedulla.setFont(new Font("Dialog", 1, 11));
		jCheckBoxSmoothMedulla.setOpaque(false);
		jCheckBoxSmoothMedulla.setFocusPainted(false);
		jCheckBoxSmoothMedulla.setRequestFocusEnabled(false);
		jCheckBoxSmoothMedulla.setForeground(Color.lightGray);
		jCheckBoxSmoothMedulla.setText("smooth graph");
		jCheckBoxSmoothMedulla.setBackground(Color.darkGray);
		jCheckBoxShowMarksMedulla.setFont(new Font("Dialog", 1, 11));
		jCheckBoxShowMarksMedulla.setOpaque(false);
		jCheckBoxShowMarksMedulla.setFocusPainted(false);
		jCheckBoxShowMarksMedulla.setRequestFocusEnabled(false);
		jCheckBoxShowMarksMedulla.setForeground(Color.lightGray);
		jCheckBoxShowMarksMedulla.setText("show marks");
		jCheckBoxShowMarksMedulla.setBackground(Color.darkGray);
		jCheckBoxDeviationCortex.setFont(new Font("Dialog", 1, 11));
		jCheckBoxDeviationCortex.setOpaque(false);
		jCheckBoxDeviationCortex.setFocusPainted(false);
		jCheckBoxDeviationCortex.setRequestFocusEnabled(false);
		jCheckBoxDeviationCortex.setContentAreaFilled(false);
		jCheckBoxDeviationCortex.setForeground(Color.lightGray);
		jCheckBoxDeviationCortex.setText("standard deviation");
		jCheckBoxDeviationCortex.setBackground(Color.darkGray);
		jCheckBoxSmoothCortex.setFont(new Font("Dialog", 1, 11));
		jCheckBoxSmoothCortex.setOpaque(false);
		jCheckBoxSmoothCortex.setFocusPainted(false);
		jCheckBoxSmoothCortex.setRequestFocusEnabled(false);
		jCheckBoxSmoothCortex.setForeground(Color.lightGray);
		jCheckBoxSmoothCortex.setText("smooth graph");
		jCheckBoxSmoothCortex.setBackground(Color.darkGray);
		jCheckBoxShowMarksCortex.setFont(new Font("Dialog", 1, 11));
		jCheckBoxShowMarksCortex.setOpaque(false);
		jCheckBoxShowMarksCortex.setFocusPainted(false);
		jCheckBoxShowMarksCortex.setRequestFocusEnabled(false);
		jCheckBoxShowMarksCortex.setForeground(Color.lightGray);
		jCheckBoxShowMarksCortex.setText("show marks");
		jCheckBoxShowMarksCortex.setBackground(Color.darkGray);
		jCheckBoxDeviationMedulla.setBackground(Color.darkGray);
		jCheckBoxDeviationMain.setRequestFocusEnabled(false);
		jCheckBoxDeviationMain.setForeground(Color.lightGray);
		jCheckBoxDeviationMain.setText("standard deviation");
		jCheckBoxDeviationMain.setBackground(Color.darkGray);
		jCheckBoxDeviationMain.setFont(new Font("Dialog", 1, 11));
		jCheckBoxDeviationMain.setOpaque(false);
		jCheckBoxDeviationMain.setFocusPainted(false);
		jCheckBoxSmoothMain.setRequestFocusEnabled(false);
		jCheckBoxSmoothMain.setForeground(Color.lightGray);
		jCheckBoxSmoothMain.setText("smooth graph");
		jCheckBoxSmoothMain.setBackground(Color.darkGray);
		jCheckBoxShowMarksMain.setForeground(Color.lightGray);
		jCheckBoxShowMarksMain.setText("show marks");
		jCheckBoxShowMarksMain.setBackground(Color.darkGray);
		jCheckBoxDeviationMedulla.setFont(new Font("Dialog", 1, 11));
		jCheckBoxDeviationMedulla.setOpaque(false);
		jCheckBoxDeviationMedulla.setFocusPainted(false);
		jCheckBoxShowMarksMain.setFont(new Font("Dialog", 1, 11));
		jCheckBoxShowMarksMain.setOpaque(false);
		jCheckBoxSmoothMain.setFont(new Font("Dialog", 1, 11));
		jCheckBoxSmoothMain.setOpaque(false);
		jCheckBoxSmoothMain.setFocusPainted(false);


		jImageLabelRight.setBackground(Color.black);

		// jImageLabelRight.setMinimumSize(new Dimension(20, 20));
		jImageLabelLeft.setBackground(Color.black);
		jPanelImages.setBackground(Color.black);
		jPanelImages.setMinimumSize(new Dimension(40, 10));
		jPanelImages.setLayout(gridBagLayoutImagePanel);
		jPanelImages.setBorder(new LineBorder(Color.black, 7));
		jPanelButtons.setLayout(gridBagLayoutButtonPanel);
		jPanelButtons.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));

		jLabelResultsCortex.setText("gray value");

		// jLabelResultsKidney.setText("gray value");

		jLabelXTextCortex.setText("time (sec.)");
		jLabelXTextCortex.setFont(new Font("Dialog", 0, 10));
		jLabelYMaxCortex.setText("  42");
		jLabelYMaxCortex.setFont(new Font("Monospaced", 0, 10));
		jLabelDummyKidneyYAxis.setText(" ");
		jLabelDummyMedullaYAxis.setText(" ");
		jLabelDummyXAxis.setText("       ");
		jLabelDummyCortexYAxis1.setText(" ");
		jPanelButtons.setForeground(Color.lightGray);
		jPanelButtons.setBackground(Color.black);
		jLabelYMinCortex.setText("   0");
		jLabelYMinCortex.setFont(new Font("Monospaced", 0, 10));
		jLabelXMinCortex.setText("   0");
		jLabelXMinCortex.setFont(new Font("Monospaced", 0, 10));
		jLabelXMaxCortex.setText(" 180");
		jLabelXMaxCortex.setFont(new Font("Monospaced", 0, 10));
		jLabelHeadlineKidney.setText("results whole kidney");
		jLabelHeadlineKidney.setFont(new Font("Dialog", 1, 11));
		jLabelHeadlineKidney.setForeground(Color.lightGray);
		jLabelXMaxCortex.setForeground(Color.white);
		jLabelXMaxCortex.setBackground(Color.black);
		jLabelXMinCortex.setForeground(Color.white);
		jLabelXMinCortex.setBackground(Color.black);
		jLabelYMinCortex.setForeground(Color.white);
		jLabelYMinCortex.setBackground(Color.black);
		jLabelYMaxCortex.setForeground(Color.white);
		jLabelYMaxCortex.setBackground(Color.black);
		jLabelXTextCortex.setForeground(Color.white);
		jLabelXTextCortex.setBackground(Color.black);

		jLabelMedullaButtons.setText("medulla");
		jLabelMedullaButtons.setForeground(Color.lightGray);
		jLabelMedullaButtons.setBackground(Color.black);
		jLabelMedullaButtons.setFont(new Font("Dialog", 1, 11));
		jLabelCortexButtons.setText("cortex");
		jLabelCortexButtons.setForeground(Color.lightGray);
		jLabelCortexButtons.setBackground(Color.black);
		jLabelCortexButtons.setFont(new Font("Dialog", 1, 11));

		this.getContentPane().add(jPanelMain, BorderLayout.CENTER);
		jPanelMain.add(jLabelResultsKidney, new GridBagConstraints2(2, 1, 4, 3, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelHeadlineKidney, new GridBagConstraints2(2, 0, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 25, 0, 0), 0, 0));
		jPanelMain.add(jLabelXMinKidney, new GridBagConstraints2(2, 4, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXMaxKidney, new GridBagConstraints2(4, 4, 2, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelYMaxKidney, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelYMinKidney, new GridBagConstraints2(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelYMaxMedulla, new GridBagConstraints2(1, 13, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelResultsMedulla, new GridBagConstraints2(2, 13, 4, 3, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelYMinCortex, new GridBagConstraints2(1, 9, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelYMinMedulla, new GridBagConstraints2(1, 15, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXMinCortex, new GridBagConstraints2(2, 10, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXMinMedulla, new GridBagConstraints2(2, 16, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXMaxCortex, new GridBagConstraints2(4, 10, 2, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXMaxMedulla, new GridBagConstraints2(4, 16, 2, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXTextKidney, new GridBagConstraints2(2, 5, 4, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXTextCortex, new GridBagConstraints2(2, 11, 4, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelXTextMedulla, new GridBagConstraints2(2, 17, 4, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jPanelImages, new GridBagConstraints2(0, 0, 1, 18, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

		jPanelImages.add(jImageLabelRight, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelImages.add(jLabelYTextRight, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelImages.add(jImageLabelLeft, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelImages.add(jLabelYTextLeft, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

		jPanelMain.add(jPanelButtons, new GridBagConstraints2(7, 2, 1, 15, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

		jPanelButtons.add(jCheckBoxDeviationMain, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxDeviationMedulla, new GridBagConstraints2(0, 9, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxSmoothMain, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxShowMarksMain, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 140, 5), 0, 0));
		jPanelButtons.add(jButtonAdjustParameters, new GridBagConstraints2(0, 12, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
		jPanelButtons.add(jButtonTextExport, new GridBagConstraints2(0, 13, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
		jPanelButtons.add(jButtonOk, new GridBagConstraints2(0, 14, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
		jPanelButtons.add(jLabelMainButtons, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxSmoothMedulla, new GridBagConstraints2(0, 10, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxShowMarksMedulla, new GridBagConstraints2(0, 11, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 50, 5), 0, 0));
		jPanelButtons.add(jCheckBoxDeviationCortex, new GridBagConstraints2(0, 5, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxSmoothCortex, new GridBagConstraints2(0, 6, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jCheckBoxShowMarksCortex, new GridBagConstraints2(0, 7, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 5, 140, 5), 0, 0));
		jPanelButtons.add(jLabelMedullaButtons, new GridBagConstraints2(0, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
		jPanelButtons.add(jLabelCortexButtons, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));

		jPanelMain.add(jLabelResultsCortex, new GridBagConstraints2(2, 7, 4, 3, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 15), 0, 0));
		jPanelMain.add(jLabelYMaxCortex, new GridBagConstraints2(1, 7, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelDummyKidneyYAxis, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelDummyCortexYAxis1, new GridBagConstraints2(1, 14, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelDummyMedullaYAxis, new GridBagConstraints2(1, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelDummyXAxis, new GridBagConstraints2(3, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelMain.add(jLabelHeadlineMedulla, new GridBagConstraints2(2, 12, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 25, 0, 0), 0, 0));
		jPanelMain.add(jLabelHeadlineCortex, new GridBagConstraints2(2, 6, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 25, 0, 0), 0, 0));
		jPanelMain.add(jLabelDummyButton, new GridBagConstraints2(6, 10, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

	} 


	/**
	 * Nimmt zusaetzliche Initialisierungen von Objekten der GUI vor.
	 * Wird vor dem ersten Anzeigen des Plugins aufgerufen.
	 */
	private void guiInit() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			System.err.println("Can't set GUI to look and feel: " + e);
		} 

		jButtonOk.addActionListener(this);
		jButtonTextExport.addActionListener(this);
		jButtonAdjustParameters.addActionListener(this);

		jCheckBoxDeviationMain.addActionListener(this);
		jCheckBoxSmoothMain.addActionListener(this);
		jCheckBoxShowMarksMain.addActionListener(this);

		jCheckBoxDeviationMedulla.addActionListener(this);
		jCheckBoxSmoothMedulla.addActionListener(this);
		jCheckBoxShowMarksMedulla.addActionListener(this);

		jCheckBoxDeviationCortex.addActionListener(this);
		jCheckBoxSmoothCortex.addActionListener(this);
		jCheckBoxShowMarksCortex.addActionListener(this);

		jImageLabelRight.addMouseListener(this);
		jImageLabelLeft.addMouseListener(this);

		// jLabelYTextLeft.

		jLabelResultsKidney.setAverageCurveColor(Color.lightGray);
		jLabelResultsKidney.setDeviationCurveColor(Color.white);
		jLabelResultsMedulla.setAverageCurveColor(myRed);
		jLabelResultsMedulla.setDeviationCurveColor(Color.red);
		jLabelResultsCortex.setAverageCurveColor(myYellow);
		jLabelResultsCortex.setDeviationCurveColor(Color.yellow);

		jLabelHeadlineMedulla.setForeground(myRed);
		jLabelHeadlineCortex.setForeground(myYellow);

		// jImageLabelLeft.setBorder(1);
		// jImageLabelLeft.setBorderColor(Color.black);
		// jImageLabelRight.setBorder(1);
		// jImageLabelRight.setBorderColor(Color.black);

		jCheckBoxDeviationMain.setSelected(false);
		jCheckBoxSmoothMain.setSelected(false);
		jCheckBoxShowMarksMain.setSelected(true);

		jCheckBoxDeviationMedulla.setSelected(false);
		jCheckBoxSmoothMedulla.setSelected(false);
		jCheckBoxShowMarksMedulla.setSelected(true);

		jCheckBoxDeviationCortex.setSelected(false);
		jCheckBoxSmoothCortex.setSelected(false);
		jCheckBoxShowMarksCortex.setSelected(true);

		// jLabelYTextLeft.setFont(new Font("Dialog", 1, 12));

		jLabelResultsKidney.showAverageGrayValues(true);
		jLabelResultsMedulla.showAverageGrayValues(true);
		jLabelResultsCortex.showAverageGrayValues(true);

		jLabelResultsKidney.showStandardDeviationValues(false);
		jLabelResultsMedulla.showStandardDeviationValues(false);
		jLabelResultsCortex.showStandardDeviationValues(false);

		jLabelResultsKidney.showMarks(true);
		jLabelResultsMedulla.showMarks(true);
		jLabelResultsCortex.showMarks(true);

		// Das Fenster auf eine schoene Groesse bringen und zentrieren
		this.updateMainFrame(false);
		Rectangle rec = this.getBounds();
		Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();

		this.setLocation(((screensize.width - rec.width) / 2), ((screensize.height - rec.height) / 2));

		this.setVisible(true);

		// this.show();
		// this.repaint();
	} 


	/**
	 * Zusaetzliche Initialisierung des Mainframes. Setzt das Fenster in die Mitte des
	 * Bildschirms. Ausserdem wird ein Flag uebergeben, das angibt, ob das Fenster
	 * vom Benutzer in seiner Groesse veraendert werden darf oder nicht.
	 * @param resizeable true, wenn das Fenster in seiner Groesse veraendert werden darf.
	 */
	public void updateMainFrame(boolean resizeable) {
		Point p = this.getLocation();

		this.setTitle(dialogTitle);

		// jFrameMain.setBounds(0,0,1024,768);
		this.pack();
		Rectangle rec = this.getBounds();

		rec.width += 10;
		rec.height += 10;
		this.setBounds(rec);
		this.setResizable(resizeable);
		this.setLocation(p);
		IJ.wait(150);
	} 


	/**
	 * Hilfsmethode. Setzt die Min/Max-Werte der x-Achse des Koordinatensystems, in
	 * dem die SIT-Kurven angezeigt werden. Ueberladene Methode.
	 * @param tissue der Gewebetyp
	 * @param min    der minimale Wert
	 * @param max    der maximale Wert
	 */
	public void setXScale(int tissue, int min, int max) {
		JLabel				textMin = null;
		JLabel				textMax = null;
		JLabelResults res = null;

		// String s;
		if (tissue == JMConst.MAIN) {
			textMin = jLabelXMinKidney;
			textMax = jLabelXMaxKidney;
			res = jLabelResultsKidney;
		} 
		if (tissue == JMConst.MEDULLA) {
			textMin = jLabelXMinMedulla;
			textMax = jLabelXMaxMedulla;
			res = jLabelResultsMedulla;
		} 
		if (tissue == JMConst.CORTEX) {
			textMin = jLabelXMinCortex;
			textMax = jLabelXMaxCortex;
			res = jLabelResultsCortex;
		} 

		if (min > max) {
			int t = min;

			min = max;
			max = t;
		} 
		textMin.setText(Integer.toString(min));
		textMax.setText(int2String(max));
		res.setXScale(min, max);
		this.repaint();
	} 


	/**
	 * Hilfsmethode. Setzt die Min/Max-Werte der y-Achse des Koordinatensystems, in
	 * dem die SIT-Kurven angezeigt werden. Ueberladene Methode.
	 * @param tissue der Gewebetyp
	 * @param data double-Array der Kurvenwerte. Hieraus extrahier der Methode den minimalen und maximalen Wert.
	 */
	public void setYScale(int tissue, double[] data) {
		JLabel				textMin = null;
		JLabel				textMax = null;
		JLabelResults res = null;
		int						min, max;
		double				dmin = Double.MAX_VALUE;
		double				dmax = Double.MIN_VALUE;
		int						i;

		if (tissue == JMConst.MAIN) {
			textMin = jLabelYMinKidney;
			textMax = jLabelYMaxKidney;
			res = jLabelResultsKidney;
		} 
		if (tissue == JMConst.MEDULLA) {
			textMin = jLabelYMinMedulla;
			textMax = jLabelYMaxMedulla;
			res = jLabelResultsMedulla;
		} 
		if (tissue == JMConst.CORTEX) {
			textMin = jLabelYMinCortex;
			textMax = jLabelYMaxCortex;
			res = jLabelResultsCortex;
		} 

		i = 0;
		try {
			while (data[i] != Double.NEGATIVE_INFINITY) {
				if (data[i] < dmin) {
					dmin = data[i];
				} 
				if (data[i] > dmax) {
					dmax = data[i];
				} 
				i++;
			} 
		} catch (Exception e) {}
		min = (int) Math.floor(dmin) - 1;
		max = (int) Math.ceil(dmax) + 1;
		textMin.setText(int2String(min));
		textMax.setText(int2String(max));
		res.setYScale(min, max);
		this.repaint();
	} 


	/**
	 * Hilfsmethode. Setzt die Min/Max-Werte der y-Achse des Koordinatensystems, in
	 * dem die SIT-Kurven angezeigt werden. Ueberladene Methode.
	 * @param tissue der Gewebetyp
	 * @param min    der minimale Wert
	 * @param max    der maximale Wert
	 */
	public void setYScale(int tissue, int min, int max) {
		JLabel				textMin = null;
		JLabel				textMax = null;
		JLabelResults res = null;

		// String s;
		if (tissue == JMConst.MAIN) {
			textMin = jLabelYMinKidney;
			textMax = jLabelYMaxKidney;
			res = jLabelResultsKidney;
		} 
		if (tissue == JMConst.MEDULLA) {
			textMin = jLabelYMinMedulla;
			textMax = jLabelYMaxMedulla;
			res = jLabelResultsMedulla;
		} 
		if (tissue == JMConst.CORTEX) {
			textMin = jLabelYMinCortex;
			textMax = jLabelYMaxCortex;
			res = jLabelResultsCortex;
		} 

		if (min > max) {
			int t = min;

			min = max;
			max = t;
		} 
		textMin.setText(int2String(min));
		textMax.setText(int2String(max));
		res.setYScale(min, max);
		this.repaint();
	} 


	/**
	 * Hilfsmethode. Setzt die Min/Max-Werte der x-Achse des Koordinatensystems, in
	 * dem die SIT-Kurven angezeigt werden. Ueberladene Methode.
	 * @param tissue der Gewebetyp
	 * @param data double-Array der Kurvenwerte. Hieraus extrahier der Methode den minimalen und maximalen Wert.
	 */
	public void setXScale(int tissue, double[] data) {
		JLabel				textMin = null;
		JLabel				textMax = null;
		JLabelResults res = null;
		int						i;
		int						max;

		if (tissue == JMConst.MAIN) {
			textMin = jLabelXMinKidney;
			textMax = jLabelXMaxKidney;
			res = jLabelResultsKidney;
		} 
		if (tissue == JMConst.MEDULLA) {
			textMin = jLabelXMinMedulla;
			textMax = jLabelXMaxMedulla;
			res = jLabelResultsMedulla;
		} 
		if (tissue == JMConst.CORTEX) {
			textMin = jLabelXMinCortex;
			textMax = jLabelXMaxCortex;
			res = jLabelResultsCortex;
		} 

		i = 0;
		try {
			while (data[i] != Double.NEGATIVE_INFINITY) {
				i++;
			} 
		} catch (Exception e) {}
		max = --i * 2;
		textMin.setText("0");
		textMax.setText(int2String(max));
		res.setXScale(0, max);
		this.repaint();
	} 


	/**
	 * Hilfsmethode. Setzt die Beschriftung der y-Achse
	 * @param tissue der Gewebetyp
	 * @param text   ein Sting mit der Beschriftung
	 */
	public void setYText(int tissue, String text) {
		JLabelResults textY = null;

		if (tissue == JMConst.MAIN) {
			textY = jLabelResultsKidney;
		} 
		if (tissue == JMConst.MEDULLA) {
			textY = jLabelResultsMedulla;
		} 
		if (tissue == JMConst.CORTEX) {
			textY = jLabelResultsCortex;
		} 
		if (text != null) {
			textY.setText(text);
		} 
	} 


	/**
	 * Hilfsmethode. Setzt die Beschriftung der x-Achse
	 * @param tissue der Gewebetyp
	 * @param text   ein Sting mit der Beschriftung
	 */
	public void setXText(int tissue, String text) {
		JLabel	textX = null;

		if (tissue == JMConst.MAIN) {
			textX = jLabelXTextKidney;
		} 
		if (tissue == JMConst.MEDULLA) {
			textX = jLabelXTextMedulla;
		} 
		if (tissue == JMConst.CORTEX) {
			textX = jLabelXTextCortex;
		} 
		if (text != null) {
			textX.setText(text);

		} 
	} 


	/**
	 * Hilfsmethode. Setzt die Anzahl der dargestellten Unterteilungstriche der x-Achse
	 * @param tissue der Gewebetyp
	 * @param marks  Anzahl der Unterteilungsstriche
	 */
	public void setXMarks(int tissue, int marks) {
		if (tissue == JMConst.MAIN) {
			jLabelResultsKidney.setXMarks(marks);
		} 
		if (tissue == JMConst.MEDULLA) {
			jLabelResultsMedulla.setXMarks(marks);
		} 
		if (tissue == JMConst.CORTEX) {
			jLabelResultsCortex.setXMarks(marks);
		} 
	} 


	/**
	 * Hilfsmethode. Setzt die Anzahl der dargestellten Unterteilungstriche der x-Achse
	 * @param tissue der Gewebetyp
	 * @param marks  Anzahl der Unterteilungsstriche
	 */
	public void setYMarks(int tissue, int marks) {
		if (tissue == JMConst.MAIN) {
			jLabelResultsKidney.setYMarks(marks);
		} 
		if (tissue == JMConst.MEDULLA) {
			jLabelResultsMedulla.setYMarks(marks);
		} 
		if (tissue == JMConst.CORTEX) {
			jLabelResultsCortex.setYMarks(marks);
		} 
	} 


	/**
	 * Hilfsmethode. Legt fest, ob ALLE Kurven geglaettet dargestellt werden sollen.
	 * @param smooth true, wenn die Kurven geglaettet werden sollen.
	 */
	public void setSmooth(boolean smooth) {
		jCheckBoxSmoothMain.setSelected(smooth);
		jCheckBoxSmoothMedulla.setSelected(smooth);
		jCheckBoxSmoothCortex.setSelected(smooth);
		smoothCurves(smooth, JMConst.MAIN);
		smoothCurves(smooth, JMConst.MEDULLA);
		smoothCurves(smooth, JMConst.CORTEX);
	} 


	/**
	 * Hilfsmethode. Setzt die Skalierungsfaktor fuer die Darstellung der
	 * Standardabweichung. Wird z.Zt. nicht benutzt (konstant auf 1), damit
	 * die Darstellung der berechneten Ergebnisse nicht verfaelscht wird. Wenn
	 * nur die realtive Groesse der Abweichung (unabhaengig von den quantitativen Werten)
	 * gefragt ist, sa kann hier ein Faktor > 1 gewaehlt werden. Dies verbessert die
	 * /zusaetzliche Darstellung der Standardabweichung innerhalb der Koordinatensysteme.
	 * @param s der Skalierungsfaktor
	 * @param tissue der Gewebetyp
	 */
	public void setDevScaleFactor(double s, int tissue) {
		if (tissue == JMConst.MAIN) {
			jLabelResultsKidney.setDevScaleFactor(s);
		} 
		if (tissue == JMConst.MEDULLA) {
			jLabelResultsMedulla.setDevScaleFactor(s);
		} 
		if (tissue == JMConst.CORTEX) {
			jLabelResultsCortex.setDevScaleFactor(s);
		} 
	} 


	/**
	 * Faengt durch Mausbewegungen ausgeloeste Events ab.
	 * @param evt MouseEvent, durch Bewegung des Mauszeigers verursacht
	 */
	public void mouseExited(MouseEvent evt) {}


	/**
	 * Faengt durch Mausbewegungen ausgeloeste Events ab.
	 * @param evt MouseEvent, durch Bewegung des Mauszeigers verursacht
	 */
	public void mouseEntered(MouseEvent evt) {}


	/**
	 * Faengt durch Klicks der Maustasten ausgeloeste Events ab.
	 * @param evt MouseEvent, durch Mausklicks verursacht
	 */
	public void mouseReleased(MouseEvent evt) {}


	/**
	 * Faengt durch Klicks der Maustasten ausgeloeste Events ab.
	 * @param evt MouseEvent, durch Mausklicks verursacht
	 */
	public void mousePressed(MouseEvent evt) {}


	/**
	 * Faengt durch Klicks der Maustasten ausgeloeste Events ab.
	 * @param evt MouseEvent, durch Mausklicks verursacht
	 */
	public void mouseClicked(MouseEvent evt) {
		Object	src = evt.getSource();

		if ((evt.getModifiers() == evt.BUTTON1_MASK) && (evt.getClickCount() == 2)) {

			// IJ.error("aha, mouse doppelt geclickt!");
			if (src == jImageLabelLeft && winLeft == null) {
				ImagePlus newImage = new ImagePlus("left kidney (classifications)", leftImage);

				winLeft = new ImageWindow(newImage);
				winLeft.show();
			} 
			if (src == jImageLabelRight && winRight == null) {
				ImagePlus newImage = new ImagePlus("right kidney (classifications)", rightImage);

				winRight = new ImageWindow(newImage);
				winRight.show();
			} 
		} 
	} 


	/**
	 * Ueberschreibt die paint()-Methode der Oberklasse. Diese wird aber als erstes
	 * hier aufgerufen, danach werden die Koordinatensysteme zur Kurvendarstellung
	 * aktualisiert. Dies ist notwendig, um die Kurvendarstellung bei Bewegungen
	 * des gesamten Dailogfenster oder Aenderungen der Groesse des Dialogfensters immer
	 * neu zeichenen zu koennen.
	 * @param g Graphics-Canvas, der gezeichner werden soll.
	 */
	public void paint(Graphics g) {
		super.paint(g);

		// IJ.write("results repaint");
		jLabelResultsKidney.repaint();
		jLabelResultsMedulla.repaint();
		jLabelResultsCortex.repaint();
	} 


	/**
	 * Faengt durch Klicks der Maustasten oder Druecken der Eingabetaste ausgeloeste Events ab.
	 * @param evt ActionEvent, durch Mausklicks oder die Eingabetaste verursacht
	 */
	public void actionPerformed(ActionEvent evt) {
		Object	src = evt.getSource();

		if (src instanceof JButton) {
			if (src == jButtonTextExport) {
				exportValues();
			} 
			if (src == jButtonOk) {

				// jButtonOk.removeFocusListener(this);
				okPressed = true;
				this.setVisible(false);
				this.dispose();
			} 
			if (src == jButtonAdjustParameters) {
				adjustParameters();
			} 
		} 

		if (src instanceof JRadioButton) {

			// IJ.write("Checkbox geclickt");
			boolean status = false;

			if (src == jCheckBoxDeviationMain) {
				status = jCheckBoxDeviationMain.isSelected();
				if (status) {
					sitAnalysis.devScaleFactor = 1.0;
				} else {
					sitAnalysis.devScaleFactor = 0.001;
				}
				sitAnalysis.setMinMaxAxisValues(JMConst.MAIN);
				jLabelResultsKidney.showStandardDeviationValues(status);

				// jLabelResultsMedulla.showStandardDeviationValues(status);
				// jLabelResultsCortex.showStandardDeviationValues(status);
			} 
			if (src == jCheckBoxSmoothMain) {
				status = jCheckBoxSmoothMain.isSelected();
				this.smoothCurves(status, JMConst.MAIN);
			} 
			if (src == jCheckBoxShowMarksMain) {
				status = jCheckBoxShowMarksMain.isSelected();

				// jLabelResultsMedulla.showMarks(status);
				jLabelResultsKidney.showMarks(status);

				// jLabelResultsCortex.showMarks(status);
			} 
			if (src == jCheckBoxDeviationMedulla) {
				status = jCheckBoxDeviationMedulla.isSelected();
				if (status) {
					sitAnalysis.devScaleFactor = 1.0;
				} else {
					sitAnalysis.devScaleFactor = 0.001;
				}
				sitAnalysis.setMinMaxAxisValues(JMConst.MEDULLA);
				jLabelResultsMedulla.showStandardDeviationValues(status);

				// jLabelResultsMedulla.showAverageGrayValues(status);
				// jLabelResultsCortex.showAverageGrayValues(status);
			} 
			if (src == jCheckBoxSmoothMedulla) {
				status = jCheckBoxSmoothMedulla.isSelected();
				this.smoothCurves(status, JMConst.MEDULLA);
			} 
			if (src == jCheckBoxShowMarksMedulla) {
				status = jCheckBoxShowMarksMedulla.isSelected();
				jLabelResultsMedulla.showMarks(status);

				// jLabelResultsKidney.showMarks(status);
				// jLabelResultsCortex.showMarks(status);
			} 
			if (src == jCheckBoxDeviationCortex) {
				status = jCheckBoxDeviationCortex.isSelected();
				if (status) {
					sitAnalysis.devScaleFactor = 1.0;
				} else {
					sitAnalysis.devScaleFactor = 0.001;
				}
				sitAnalysis.setMinMaxAxisValues(JMConst.CORTEX);
				jLabelResultsCortex.showStandardDeviationValues(status);

				// jLabelResultsMedulla.showAverageGrayValues(status);
				// jLabelResultsCortex.showAverageGrayValues(status);
			} 
			if (src == jCheckBoxSmoothCortex) {
				status = jCheckBoxSmoothCortex.isSelected();
				this.smoothCurves(status, JMConst.CORTEX);
			} 
			if (src == jCheckBoxShowMarksCortex) {
				status = jCheckBoxShowMarksCortex.isSelected();
				jLabelResultsCortex.showMarks(status);

				// jLabelResultsKidney.showMarks(status);
				// jLabelResultsCortex.showMarks(status);
			} 
		} 
	} 


	/**
	 * Setzt fuer einen bestimmten Gewebetyp die Kurvendaten fuer die Kurve des
	 * mittleren Grauwertes. Die Werte der Kurve werden als Array uebergeben.
	 * @param half die Bildhaelfte (entsprechend linke oder rechte Niere)
	 * @param tissue der Gewebetyp
	 * @param data double-Array mit den Daten der Kurve
	 */
	public void setAverageGray(int half, int tissue, double[] data) {
		if (data != null) {
			if (half == JMConst.LEFT) {
				if (tissue == JMConst.MAIN) {
					averageGrayLeft = data;
					jLabelResultsKidney.setAverageGray(half, data);
				} 
				if (tissue == JMConst.MEDULLA) {
					medullaAverageLeft = data;
					jLabelResultsMedulla.setAverageGray(half, data);
				} 
				if (tissue == JMConst.CORTEX) {
					cortexAverageLeft = data;
					jLabelResultsCortex.setAverageGray(half, data);
				} 
			} 
			if (half == JMConst.RIGHT) {
				if (tissue == JMConst.MAIN) {
					averageGrayRight = data;
					jLabelResultsKidney.setAverageGray(half, data);
				} 
				if (tissue == JMConst.MEDULLA) {
					medullaAverageRight = data;
					jLabelResultsMedulla.setAverageGray(half, data);
				} 
				if (tissue == JMConst.CORTEX) {
					cortexAverageRight = data;
					jLabelResultsCortex.setAverageGray(half, data);
				} 
			} 
		} 
	} 


	/**
	 * Setzt fuer einen bestimmten Gewebetyp die Kurvendaten fuer die Kurve der
	 * Standardabweichung. Die Werte der Kurve werden als Array uebergeben.
	 * @param half die Bildhaelfte (entsprechend linke oder rechte Niere)
	 * @param tissue der Gewebetyp
	 * @param data double-Array mit den Daten der Kurve
	 */
	public void setStandardDeviation(int half, int tissue, double[] data) {
		if (data != null) {
			if (half == JMConst.LEFT) {
				if (tissue == JMConst.MAIN) {
					standardDevLeft = data;
					jLabelResultsKidney.setStandardDeviation(half, data);
				} 
				if (tissue == JMConst.MEDULLA) {
					medullaDevLeft = data;
					jLabelResultsMedulla.setStandardDeviation(half, data);
				} 
				if (tissue == JMConst.CORTEX) {
					cortexDevLeft = data;
					jLabelResultsCortex.setStandardDeviation(half, data);
				} 
			} else {
				if (tissue == JMConst.MAIN) {
					standardDevRight = data;
					jLabelResultsKidney.setStandardDeviation(half, data);
				} 
				if (tissue == JMConst.MEDULLA) {
					medullaDevRight = data;
					jLabelResultsMedulla.setStandardDeviation(half, data);
				} 
				if (tissue == JMConst.CORTEX) {
					cortexDevRight = data;
					jLabelResultsCortex.setStandardDeviation(half, data);
				} 
			} 
		} 
	} 


	/**
	 * Hilfsmethode. Wandelt einen Integer in einen String um. Es werden nur
	 * positive Werte beruecksichtigt. Sollte der Integer < 1000 sein, werden
	 * die restlichen Stellen mit Leerzeichen aufgefuellt.
	 * @param value der Integer
	 * @result String der Ergebnis-String.
	 */
	private String int2String(int value) {
		String	result = Integer.toString(Math.abs(value));

		while (result.length() < 4) {
			result = " " + result;
		} 
		return result;
	} 


	/**
	 * Legt fest, ob einen Kurve der angegebenen Gewebetyps fuer die Dasstellung
	 * geglaettet werden soll.
	 * @param smooth true, wenn die Kurve geglaettet werden soll
	 * @param tissue der Gewebetyp
	 */
	public void smoothCurves(boolean smooth, int tissue) {
		if (smooth) {
			int smoothRange = 3;

			if (tissue == JMConst.MAIN) {
				jLabelResultsKidney.setAverageGray(JMConst.LEFT, floatingAverage(averageGrayLeft, smoothRange));
				jLabelResultsKidney.setAverageGray(JMConst.RIGHT, floatingAverage(averageGrayRight, smoothRange));
			} 
			if (tissue == JMConst.MEDULLA) {
				jLabelResultsMedulla.setAverageGray(JMConst.LEFT, floatingAverage(medullaAverageLeft, smoothRange));
				jLabelResultsMedulla.setAverageGray(JMConst.RIGHT, floatingAverage(medullaAverageRight, smoothRange));
			} 
			if (tissue == JMConst.CORTEX) {
				jLabelResultsCortex.setAverageGray(JMConst.LEFT, floatingAverage(cortexAverageLeft, smoothRange));
				jLabelResultsCortex.setAverageGray(JMConst.RIGHT, floatingAverage(cortexAverageRight, smoothRange));
			} 
		} else {
			jLabelResultsKidney.setAverageGray(JMConst.LEFT, averageGrayLeft);
			jLabelResultsKidney.setAverageGray(JMConst.RIGHT, averageGrayRight);
			jLabelResultsMedulla.setAverageGray(JMConst.LEFT, medullaAverageLeft);
			jLabelResultsMedulla.setAverageGray(JMConst.RIGHT, medullaAverageRight);
			jLabelResultsCortex.setAverageGray(JMConst.LEFT, cortexAverageLeft);
			jLabelResultsCortex.setAverageGray(JMConst.RIGHT, cortexAverageRight);
		} 
	} 


	/**
	 * Hier werden die Werte SIT-Kurven als Textdatei exportiert. Der Benutzer kann
	 * in einem Speichern-Dialog den Dateinamen festlegen, danach werden die Daten
	 * in tabellarischer Form (mit TABs als Trennzeichen) in die Datei geschrieben.
	 */
	public void exportValues() {

		// Get the Length of the Data-Arrays
		int length = 0;

		if (averageGrayLeft != null) {
			try {
				while (averageGrayLeft[length] != Double.MIN_VALUE) {
					length++;
				} 
			} catch (Exception e) {}
		} 
		if ((length == 0) && (averageGrayRight != null)) {
			try {
				while (averageGrayRight[length] != Double.MIN_VALUE) {
					length++;
				} 
			} catch (Exception e) {}
		} 
		if (length == 0) {
			IJ.error("No data available to save !");
			return;
		} 

		String										path = getLastDir();
		File											f = new File(path);
		javax.swing.JFileChooser	saveDlg = new javax.swing.JFileChooser();

		// th.util.JFileChooser saveDlg = new th.util.JFileChooser(f);
		File											saveFile = new File(path, "*.txt");

		saveDlg.setDialogTitle(" Export Analysis Values");
		String[]	tl = f.list();

		if (tl != null) {
			saveDlg.setCurrentDirectory(f);
		} else {
			saveDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
		}

		// saveDlg.setfsetFileFilter(filter);
		saveDlg.setFileSelectionMode(saveDlg.FILES_ONLY);

		// saveDlg.setSelectedFile(saveFile);
		// saveDlg.set
		int result = saveDlg.showSaveDialog(this);

		// IJ.write("result was " + result);
		if (result == JFileChooser.APPROVE_OPTION) 

		// if (result != 0)
		{
			int i;

			saveFile = saveDlg.getSelectedFile();
			path = saveFile.getParent() + saveFile.separator;
			saveActualDir(path);
			String	fileName = saveFile.getName();
			String	fileType = fileName.substring(fileName.length() - 4);

			if (fileType.compareTo(".txt") != 0) {
				fileName = saveFile.getAbsolutePath() + ".txt";
				saveFile = new File(fileName);	// saveFile.getPath(),fileName);
			} 
			IJ.write("Filename: " + saveFile.getPath() + "!" + saveFile.getName());

			// Open the output file;
			Writer	w = null;

			try {
				w = new FileWriter(saveFile.getPath(), true);
			} catch (IOException ioe) {
				ioe.printStackTrace();
			} 

			// Write data to the File
			try {
				double	pixelDiv = 1.0;
				double	pixelSurf = sitAnalysis.analysisDialog.pixelSpacingX * sitAnalysis.analysisDialog.pixelSpacingY;

				w.write("Renographie\t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
				w.write(" \t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
				w.write("Patient:\t \t \t" + sitAnalysis.analysisDialog.patientName + "\t \t \tFOV (mm):\t \t \t" + sitAnalysis.analysisDialog.fovX + "\t" + sitAnalysis.analysisDialog.fovY + "\t \t \t\r\n");
				w.write("ID:\t \t \t" + sitAnalysis.analysisDialog.patientID + "\t \t \tMatrix:\t \t \t" + sitAnalysis.analysisDialog.matrixX + "\t" + sitAnalysis.analysisDialog.matrixY + "\t \t \t\r\n");
				w.write("Untersuchungsdatum:\t \t \t" + sitAnalysis.analysisDialog.studyDate + "\t \t \tPixelflaeche (mm):\t \t \t" + d2s(pixelSurf, 6) + "\t \t \t \t\r\n");
				w.write("Geburtsdatum:\t \t \t" + sitAnalysis.analysisDialog.patientBirth + "\t \t \t \t \t \t \t \t \t \t\r\n");
				w.write("NAST (%, Seite):\t \t \t" + "*" /* sitAnalysis.analysisDialog.patientID */ + "\t \t \t \t \t \t \t \t \t \t\r\n");
				w.write("Geschlecht:\t \t \t" + sitAnalysis.analysisDialog.patientSex + "\t \t \t \t \t \t \t \t \t \t\r\n");
				w.write("Gewicht (kg):\t \t \t" + sitAnalysis.analysisDialog.patientWeight + "\t \t \t \t \t \t \t \t \t \t\r\n");
				w.write("NaCl-Infusion (ml):\t \t \t" + "*" /* sitAnalysis.analysisDialog.patientID */ + "\t \t \t \t \t \t \t \t \t \t\r\n");
				w.write("Magnevist (ml):\t \t \t" + "*" /* sitAnalysis.analysisDialog.patientID */ + "\t \t \t \t \t \t \t \t \t \t\r\n");
				w.write(" \t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");

				w.write("Originaldaten\t \t \t \t \t \t \t \t \t \t \t \t \t\r\n");
				w.write(" \tGesamtniere\t \tGesamtniere\t \tNierenrinde\t \tNierenrinde\t \tNierenmark\t \tNierenmark\t \t\r\n");
				w.write(" \t   rechts\t \t   links\t \t   rechts\t \t   links\t \t   rechts\t \t   links\t \t\r\n");
				w.write(" \tROI\tPixel\tROI\tPixel\tROI\tPixel\tROI\tPixel\tROI\tPixel\tROI\tPixel\t\r\n");
				w.write(" \t" + (int) ((double) sitAnalysis.pixelCountKidney[JMConst.LEFT] * pixelSurf) + "\t" + (int) ((double) sitAnalysis.pixelCountKidney[JMConst.LEFT] / pixelDiv) + "\t" + (int) ((double) sitAnalysis.pixelCountKidney[JMConst.RIGHT] * pixelSurf) + "\t" + (int) ((double) sitAnalysis.pixelCountKidney[JMConst.RIGHT] / pixelDiv) + "\t" + (int) ((double) sitAnalysis.pixelCountCortex[JMConst.LEFT] * pixelSurf) + "\t" + (int) ((double) sitAnalysis.pixelCountCortex[JMConst.LEFT] / pixelDiv) + "\t" + (int) ((double) sitAnalysis.pixelCountCortex[JMConst.RIGHT] * pixelSurf) + "\t" + (int) ((double) sitAnalysis.pixelCountCortex[JMConst.RIGHT] / pixelDiv) + "\t" + (int) ((double) sitAnalysis.pixelCountMedulla[JMConst.LEFT] * pixelSurf) + "\t" + (int) ((double) sitAnalysis.pixelCountMedulla[JMConst.LEFT] / pixelDiv) + "\t" + (int) ((double) sitAnalysis.pixelCountMedulla[JMConst.RIGHT] * pixelSurf) + "\t" + (int) ((double) sitAnalysis.pixelCountMedulla[JMConst.RIGHT] / pixelDiv) + "\t\r\n");
				w.write("Zeit\tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \tSignalintensitaet\t \t\r\n");
				w.write("(s)\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\tMittel\tStabw\t\r\n");
				for (i = 0; i < length; i++) {
					if (sitAnalysis != null) {
						w.write("" + d2s(sitAnalysis.acquisitionTimes[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (averageGrayLeft != null) {
						w.write("" + d2s(averageGrayLeft[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (standardDevLeft != null) {
						w.write("" + d2s(standardDevLeft[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (averageGrayRight != null) {
						w.write("" + d2s(averageGrayRight[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (standardDevRight != null) {
						w.write("" + d2s(standardDevRight[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (cortexAverageLeft != null) {
						w.write("" + d2s(cortexAverageLeft[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (cortexDevLeft != null) {
						w.write("" + d2s(cortexDevLeft[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (cortexAverageRight != null) {
						w.write("" + d2s(cortexAverageRight[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (cortexDevRight != null) {
						w.write("" + d2s(cortexDevRight[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (medullaAverageLeft != null) {
						w.write("" + d2s(medullaAverageLeft[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (medullaDevLeft != null) {
						w.write("" + d2s(medullaDevLeft[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (medullaAverageRight != null) {
						w.write("" + d2s(medullaAverageRight[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					if (medullaDevRight != null) {
						w.write("" + d2s(medullaDevRight[i], 1) + "\t");
					} else {
						w.write("-1,0\t");
					} 
					w.write("\r\n");
				} 
			} catch (IOException ioe) {
				ioe.printStackTrace();
			} 

			// Close the Outout File
			try {
				w.close();
			} catch (IOException ioe) {
				ioe.printStackTrace();
			} 
		} 
	} 


	/**
	 * Ruft den Dialog zur manuellen Nachjustierung der Schwellenwerte auf.
	 */
	private void adjustParameters() {
		if (sitAdjuster == null || sitAdjuster.finished == true) {
			sitAdjuster = new SITAdjuster(sitAnalysis, leftImage, rightImage);
			sitAdjuster.setAdjustmentRange(adjustmentMin, adjustmentMax);
		} 

	} 


	/**
	 * Hilfsfunktion. Wandelt einen Double in einen String um. Erweitert die ImageJ-d2s-Methode
	 * um einige zusaetzliche Sicherheitsabfragen.
	 * @param d der Double-Wert
	 * @param l die Anzahl der Nachkommastellen
	 * @return String der generierte String
	 */
	private String d2s(double d, int l) {
		String	result = IJ.d2s(d, l);

		result = result.replace('.', ',');
		while ((result.length() > 1) && (result.charAt(0) == '0') && (result.charAt(1) != ',')) {
			result = result.substring(1);
		} 
		return result;
	} 


	/**
	 * Hilfsmethode. Berechnet den gleitenden Mittelwert fuer ein Double-Array,
	 * dies entspricht einer Glaettung der durch das Array dargestellten Kurve.
	 * @param data Array von double-Werten
	 * @param range legt fest, wieviele der Nachbarwerte eines betrachteten Arrayeintrags fuer die Mittelwertbildung einbezogen werden sollen.
	 * @return double das geglaettete Array
	 */
	private double[] floatingAverage(double[] data, int range) {
		double[]	result = null;

		if (data == null) {
			return result;
		} 
		result = new double[data.length];
		double	floatingMid;
		int			i, j, pos;

		for (i = 0; i < data.length; i++) {
			floatingMid = 0.0;
			for (j = 0; j < range; j++) {
				pos = i - (range / 2) + j;
				if (pos < 0) {
					pos = pos + range;
				} 
				if (pos >= data.length) {
					pos = pos - range;
				} 
				floatingMid = floatingMid + data[pos];

			} 
			floatingMid = floatingMid / (double) range;

			// IJ.write("FM1: " + floatingMid);
			result[i] = floatingMid;
		} 
		return result;
	} 


	/**
	 * Aktualisiert die Darstellung des Klassifizierungsbildes im Dailogfenster.
	 * @param half Die Bildhaelfte (linke=0, oder rechte=1 Niere)
	 * @Param img  das Klassifizierungsbild im Datentyp ImagePlus
	 */
	public void updateImageLabel(int half, ImagePlus img) {
		Image scaledImage = getScaledImage(img, 2.0);

		if (half == JMConst.LEFT) {
			if (jImageLabelLeft != null) {
				leftImage = scaledImage;
				jImageLabelLeft.setImage(scaledImage);
				jImageLabelLeft.repaint();

				// this.repaint();
			} 
		} 
		if (half == JMConst.RIGHT) {
			if (jImageLabelRight != null) {
				rightImage = scaledImage;
				jImageLabelRight.setImage(scaledImage);
				jImageLabelRight.repaint();

				// this.repaint();
			} 
		} 
		int				wmax = Math.max(jImageLabelLeft.getWidth(), jImageLabelRight.getWidth());
		int				h = jPanelButtons.getHeight();

		// Rectangle bounds = jPanelImages.getBounds();
		Dimension dim = new Dimension(wmax, h);

		jPanelImages.setMinimumSize(dim);
		jPanelImages.setMaximumSize(dim);
		jPanelImages.setPreferredSize(dim);
		jPanelImages.repaint();
	} 


	/**
	 * Erzeugt eine Instanz eines java.awt.Image, das dem uebergebenen ImagePlus-Bild
	 * entspricht und um einen angegebenen Faktor skaliert wurde.
	 * Zum Skalieren werden Standard-AWT-Methoden benutzt, weil diese sehr schnell sind.
	 * @param imp   das ImagePlus-Bildobjekt
	 * @param scale die gewuenschte Skalierung
	 * @return Image Ergebnisbild als java.awt.Image-Datentyp
	 */
	private Image getScaledImage(ImagePlus imp, double scale) {
		if (imp == null) {
			return null;
		} 
		Image scaledImage = null;
		Image originalImage = imp.getImage();

		try {
			int x = (int) ((double) imp.getWidth() * scale);
			int y = (int) ((double) imp.getHeight() * scale);

			scaledImage = originalImage.getScaledInstance(x, y, originalImage.SCALE_SMOOTH);
			mediaTracker.addImage(scaledImage, 0);
			mediaTracker.waitForAll();
		} catch (Exception e) {
			e.printStackTrace();
			scaledImage.flush();
			scaledImage = null;
			return originalImage;
		} 
		originalImage.flush();
		originalImage = null;
		return scaledImage;
	} 


	/**
	 * Speichert das als String uebergebene Verzeichnis in einer Textdatei mit dem
	 * Namen "SITResults.properties" ab. Der gespeicherte Pfad kann beim naechten
	 * Aufruf der Export()-Methode wieder gelesen werden und dem Benutzer wird
	 * dann das Verzeichnis des vorausgegangenen Speichervorgangs wieder als
	 * Zeilverzeichnis vorgeschlagen.
	 * @param path der Pfad als String
	 */
	private void saveActualDir(String path) {
		File		saveFile = new File("SITResults.properties");		// saveFile.getPath(),fileName);
		Writer	w = null;

		try {
			w = new FileWriter(saveFile.getPath(), false);
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return;
		} 

		// Write data to the File
		try {
			w.write("Last Save Dir = " + path);
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return;
		} 

		// Close the Output File
		try {
			w.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return;
		} 
	} 


	/**
	 * Liefert das Verzeichnis des vorausgegangenen Speichervorgangs als String.
	 * Dieser wird aus einer Datei mit dem Namen "SITResults.properties" gelesen.
	 * @return String das Verzeichnis
	 */
	private String getLastDir() {
		String	result = "";
		File		loadFile = new File("SITResults.properties");		// saveFile.getPath(),fileName);
		Reader	r = null;

		try {
			r = new FileReader(loadFile.getPath());
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return result;
		} 

		// Read data from the File
		try {
			char[]	input = new char[4096];

			r.read(input, 0, 4096);
			String	data = new String(input);
			int			index = data.indexOf("=");

			if (index >= 0) {
				result = data.substring(index + 2);
			} 
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return result;
		} 

		// Close the Input File
		try {
			r.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return result;
		} 
		return result;
	} 


	/**
	 * Setzt den Wertebereich, innerhalb dem die Schwellenwerte veraendert werden koennen.
	 * Die Schwellenwerte werden  mit 1,0 intialisiert. Der min- und max-Wert wird durch
	 * die Einstellungen im Voreinstellungs-Dialog (jm.kidney.PresetsDialog) festgelegt.
	 * @param min   der minimal erlaubte Wert
	 * @param max   der maximal erlaubte Wert
	 */
	public void setAdjustmentRange(double min, double max) {
		adjustmentMin = min;
		adjustmentMax = max;
	} 

}


/*--- formatting done in "My Own Convention" style on 08-04-2000 ---*/

