/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * ImageJ plug-in to dump DICOM files.
 *
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/copyleft.html
 *
 * The ImageJ project:
 * http://rsb.info.nih.gov/ij/default.html
 * Author: Wayne Rasband, wayne@codon.nih.gov
 * Research Services Branch, National Institute of Mental Health, Bethesda, Maryland, USA.
 * Download: ftp://codon.nih.gov/pub/image-j/
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;

import ij.*;
import ij.io.*;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.process.*;

import rad.dicom.dcm.*;
import rad.ijplugin.dcm.*;
import rad.ijplugin.util.*;


/**
 * Diese PlugIn liefert den Dump einer DICOM 3 Datei.<br>
 * </pre>
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2002.5.12
 */
public class DICOM_dumpFile extends ImagePlus implements PlugIn {

	/**
	 * Die Versionsnummer dieses Plugins
	 */
	static public final String	DUMP_VERSION = "5.0";


	/* Directory fuer alle Input-Operationen */
	private File								inputDir = new File(System.getProperty("user.dir"));

	/* Directory fuer alle Output-Operationen */
	public File									outputDir = new File(System.getProperty("user.dir"));


	/**
	 * Konstruktor. Nur zum Debuggen.
	 */
	public DICOM_dumpFile() {}


	/**
	 * Diese Methode wird einmal aufgerufen, wenn das PlugIn geladen wird.
	 * @param arg  Der path des DICOM files, der geffnet werden soll.
	 * Falls in "ij.properties" ein Argument fuer dieses
	 * PlugIn definiert ist, hat arg dessen Wert.
	 * Ist arg = "", wird eine open-Dialogbox angezeigt.
	 */
	public void run(String arg) {
		InputStream			pfs;
		JFileChooser		chooser;
		File						f = null;

		// Das Look and Feel der zugrund liegenden Maschine waehlen
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {}

		// Versucht einen Property File zu finden
		pfs = Util.getPropertyFileStream(arg);
		if (pfs != null) {
			getProperties(pfs);

		}
		chooser = new JFileChooser();
		chooser.setDialogTitle("Select a DICOM file...");
		chooser.setCurrentDirectory(inputDir);
		Frame fr = new Frame();

		chooser.showOpenDialog(fr);
		f = chooser.getSelectedFile();
		if (f == null) return;

		try {
		  DcmDataObject				ddo = null;
		  DcmDataObject				mddo = null;
		  FileInputStream			fis = null;
		  BufferedInputStream bis = null;
		  DcmInputStream			dis = null;

		  try {
			  fis = new FileInputStream(f);
			  bis = new BufferedInputStream(fis);
			  dis = new DcmInputStream(bis);
			  ddo = dis.readDDO();
        mddo = dis.getMetaInfo();
		  } catch (Exception e) {
			  throw e;
		  }
		  finally {
			  if (fis != null) fis.close();
			  bis = null;		// BufferedInputStream.close() erst ab Java 1.2 definiert
			  dis = null;
		  }

			showDumpPanel(mddo, ddo);
		} catch (Exception e) {}

	}


	/**
	 * Erzeugt ein Dialogfenster, in dem ein neues DumpPanel dargestellt wird.
	 * @param   mddo  Das DcmDataObject des Meta File Information Blocks.
	 * @param   ddo   Das DcmDataObject, das analysiert werden soll.
	 */
	private void showDumpPanel(DcmDataObject mddo, DcmDataObject ddo) {
		DumpPanel dp;
		JDialog		d;

		dp = new DumpPanel(outputDir);
		try {
			dp.processDcmDataObject(mddo, ddo);
		} catch (Exception err) {}
		d = new JDialog();
		d.setTitle("Dump DICOM file");
		d.setSize((dp.getPreferredSize()).width, (dp.getPreferredSize()).height);
		d.setModal(true);
		d.setLocationRelativeTo(d);		// center on screen (d is invisble!)
		d.getContentPane().add(dp, BorderLayout.CENTER);
		d.validate();
		d.setVisible(true);
		while (d.isVisible()) {}
		;
		if (d != null) {
			d.dispose();
		}
	}


	/**
	 * Felder der Klasseninstanz werden mit den Werten des Property Files
	 * ueberschrieben:
	 * input.dir				inputDir
	 * output.dir				outputDir
	 */
	private void getProperties(InputStream in) {
		Properties	prop = new Properties();
		String			s;
		File				f;

		try {
			prop.load(in);

			s = prop.getProperty("input.dir");
			if (s != null) {
				f = new File(s);
				if (f != null) {
					inputDir = f;
				}
			}

			s = prop.getProperty("output.dir");
			if (s != null) {
				f = new File(s);
				if (f != null) {
					outputDir = f;
				}
			}

			in.close();

		} catch (Exception e) {}
	}

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

