/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * ImageJ plug-in to dump DICOM header information in ImageJ Images.
 * 
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 * 
 * The ImageJ project:
 * http://rsb.info.nih.gov/ij/default.html
 * Author: Wayne Rasband, wayne@codon.nih.gov
 * Research Services Branch, National Institute of Mental Health, Bethesda, Maryland, USA.
 * Download: ftp://codon.nih.gov/pub/image-j/
 */

import java.util.*;

import ij.*;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.process.*;

import rad.dicom.dcm.*;


/**
 * Diese Plugin ueberprueft, ob sich in dem aktuellen Bild (Stack)
 * DICOM Header Informationen befinden. Sind welche vorhanden,
 * werden sie im ImageJ Textfenster ausgegeben.
 * Es werden sowohl String, als auch DcmDataObject Informationen
 * erkannt und ausgegeben.
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2002.5.12
 */
public class DICOM_dumpHeader implements PlugInFilter {

	/**
	 * Die Versionsnummer dieses Plugins
	 */
	public final String			DUMP_HEADER_VERSION = "5.0";


	/* Die aktuelle Bildnummer, falls ein Stack bearbeitet wird */
	private static int			imageNumber;

	/*
	 * Ein Array, das die Header-Informationen fuer jedes Bild in der
	 * String-Darstellung enthaelt
	 */
	private String[]				sl = null;

	/*
	 * Ein Array, das die Header-Informationen fuer jedes Bild in der
	 * Binaeren-Darstellung enthaelt
	 */
	private DcmDataObject[] ddol = null;


	/**
	 * Nur zum Debuggen
	 */
	public DICOM_dumpHeader() {}


	/**
	 * Diese Methode wird einmal aufgerufen, wenn der Filter geladen wird.
	 * @param arg  Falls in "ij.properties" ein Argument fuer dieses
	 * Filter definiert ist, hat arg dessen Wert.
	 * @param imp  Das aktuell aktive Bild oder Stack (ImagePlus Objekt)
	 * @return     Flags, die die Moeglichkeiten des Filters beschreiben.
	 */
	public int setup(String arg, ImagePlus imp) {

		imageNumber = -1;

		Properties	prop = imp.getProperties();

		if (prop != null) {
			if (prop.containsKey(DcmUID.DCM_STRING_HEADER_PROPERTY)) {
				sl = (String[]) prop.get(DcmUID.DCM_STRING_HEADER_PROPERTY);
			} 

			if (prop.containsKey(DcmUID.DCM_BIN_HEADER_PROPERTY)) {
				ddol = (DcmDataObject[]) prop.get(DcmUID.DCM_BIN_HEADER_PROPERTY);
			} 
		} 

		return DOES_ALL +		// add supported image types
		DOES_STACKS + NO_CHANGES;
	} 


	/**
	 * Die Filterroutine. Wenn der Filter die Verarbeitung von Stacks
	 * unterstuetzt, wird diese Methode fuer jedes Bild des Stacks
	 * aufgerufen. Image/J locked das Bild  bevor der Filter aufgerufen
	 * wird und unlocked es danach wieder.
	 * @param ip  Das ImageProcessor Object des aktuell aktiven Bildes
	 */
	public void run(ImageProcessor ip) {
		imageNumber++;

		if (sl != null) {
			IJ.write("Header Property as String. Image " + String.valueOf(imageNumber) + ":");
			if (sl[imageNumber].length() != 0) {
				IJ.write(sl[imageNumber]);
			} else {
				IJ.write("<empty>");
			} 
		} 

		if (ddol != null) {
			IJ.write("Header Property as DcmDataObject. Image " + String.valueOf(imageNumber) + ":");
			if (ddol[imageNumber] != null) {
				IJ.write(ddol[imageNumber].toString());
			} else {
				IJ.write("<empty>");
			} 
		} 

	} 

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

