/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.dcm;


import java.io.*;
import java.util.*;

import rad.dicom.ima.*;


/**
 * Diese Klasse ist der Datenblock des Import-Plugins zum
 * Austausch der Daten zwischen dem eigentlichen Import-Plugin
 * und der Dialogbox <code>ImportPanel</code>, sowie deren Unter-Panels.
 * Die Felder werden zunaechst mit den Werten der Klassendefinition vorbesetzt.
 * Anschliessend wird nach der Properties-Datei <code>Util.PROPERTY_FILE_NAME</code>
 * gesucht.
 * Wird diese gefunden, dann werden die Felder
 * <ul>
 * <li> inputDir </li>
 * <li> outputDir </li>
 * <li> isIncludeStringHeader </li>
 * <li> isIncludeBinHeader </li>
 * <li> isIncludeOnlyFirstHeader </li>
 * <li> allowACRNema </li>
 * <li> imageShow </li>
 * <li> multi.idlist </li></ul>
 * mit den Eintraegen in der Datei ueberschrieben.
 * <DL><DT><B>Modifications: </B><DD>
 * Keine
 * tha 2000.05.01: "Load multiple images" als multi.idlist Property eingefgt.
 * @author   Thomas Hacklaender
 * @version  2000.05.01
 */
public class ImportData {


	/**
	 * Property: input.dir = String <br>
	 * Directory fuer alle Input-Operationen. Voreinstellung "user.dir"
	 */
	public File							inputDir = new File(System.getProperty("user.dir"));


	/**
	 * Property: output.dir = String <br>
	 * Directory fuer alle Output-Operationen. Voreinstellung "user.dir"
	 */
	public File							outputDir = new File(System.getProperty("user.dir"));


	/**
	 * Property: include.string = Erstes Zeichen 't' fuer true, sonst false <br>
	 * Gibt an, ob die Header Informationen in der String-Darstellung abgespeichert
	 * werden sollen. Voreinstellung "false"
	 */
	public boolean					isIncludeStringHeader = false;


	/**
	 * Property: include.bin = Erstes Zeichen 't' fuer true, sonst false <br>
	 * Gibt an, ob die Header Informationen als DcmDataObject abgespeichert
	 * werden sollen. Voreinstellung "false"
	 */
	public boolean					isIncludeBinHeader = false;


	/**
	 * Property: include.first = Erstes Zeichen 't' fuer true, sonst false <br>
	 * Gibt an, ob die nur die Header Informationen des ersten Bildes abgespeichert
	 * werden sollen. Voreinstellung "false"
	 */
	public boolean					isIncludeOnlyFirstHeader = false;


	/**
	 * Property: allow.acr = Erstes Zeichen 't' fuer true, sonst false <br>
	 * Gibt an, ob die die DICOM Konformitaetspuefung auch ACR Nema Bilder zulassen
	 * soll. Voreinstellung "true"
	 */
	public boolean					allowACRNema = true;


	/**
	 * Property:  image.show = Erstes Zeichen 't' fuer true, sonst false <br>
	 * Gibt an, ob die das importierte Bild/Stack angezeigt werden sollen.
	 * Voreinstellung "true"
	 */
	public boolean					imageShow = true;


	/**
	 * Property:  multi.idlist = String <br>
	 * Enthlt den String aller Bild ID'S die eingelesen werden sollen in der
	 * Darstellung der FileListPanel (z.B. "-4,6,9,11-14", alle Bilder = "-").
	 */
	public String						multiImageIDList = "";


	/**
	 * true, wenn mehr als ein File eingelesen werden soll.
	 */
	public boolean					isMultiImage = false;


	/**
	 * Der File, aus dem die aktuelle GeneralImageIOD eingelesen wurde
	 */
	public File							theFile = null;


	/**
	 * Die aktuelle GeneralImageIOD
	 */
	public GeneralImageIOD	theGI = null;


	/**
	 * Enthaelt die BildID's aller Bilder, die eingelesen werden sollen
	 */
	public Vector						multiImageList;


	/**
	 * Felder der Klasseninstanz werden mit den Werten des Property Files
	 * ueberschrieben.
	 * <ul>
	 * <li> input.dir -> inputDir </li>
	 * <li> output.dir -> outputDir </li>
	 * <li> include.string -> isIncludeStringHeader </li>
	 * <li> include.bin -> isIncludeBinHeader </li>
	 * <li> include.first -> isIncludeOnlyFirstHeader </li>
	 * <li> allow.acr -> allowACRNema </li>
	 * <li> image.show -> imageShow </li></ul>
	 */
	public void getProperties(InputStream in) {
		Properties	prop = new Properties();
		String			s;
		File				f;

		try {
			prop.load(in);

			s = prop.getProperty("input.dir");
			if (s != null) {
				f = new File(s);
				if (f != null) {
					inputDir = f;
				} 
			} 

			s = prop.getProperty("output.dir");
			if (s != null) {
				f = new File(s);
				if (f != null) {
					outputDir = f;
				} 
			} 

			s = prop.getProperty("include.string");
			if (s != null) {
				if (s.charAt(0) == 't') {
					isIncludeStringHeader = true;
				} else {
					isIncludeStringHeader = false;
				} 
			} 

			s = prop.getProperty("include.bin");
			if (s != null) {
				if (s.charAt(0) == 't') {
					isIncludeBinHeader = true;
				} else {
					isIncludeBinHeader = false;
				} 
			} 

			s = prop.getProperty("include.first");
			if (s != null) {
				if (s.charAt(0) == 't') {
					isIncludeOnlyFirstHeader = true;
				} else {
					isIncludeOnlyFirstHeader = false;
				} 
			} 

			s = prop.getProperty("allow.acr");
			if (s != null) {
				if (s.charAt(0) == 't') {
					allowACRNema = true;
				} else {
					allowACRNema = false;
				} 
			} 

			s = prop.getProperty("image.show");
			if (s != null) {
				if (s.charAt(0) == 't') {
					imageShow = true;
				} else {
					imageShow = false;
				}
			}

			s = prop.getProperty("multi.idlist");
			if (s != null) {
				multiImageIDList = s;
				isMultiImage = true;
			}

			in.close();

		} catch (Exception e) {}
	} 

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

