/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.ijplugin.dcm;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import rad.dicom.dcm.*;
import rad.dicom.ima.*;
import rad.ijplugin.util.*;


/**
 * Diese Klasse definiert ein Panel, ueber das DICOM Dateien ausgewaehlt
 * betrachtet und in ImageJ importiert werden koennen.
 * Das DICOM_Import Plugin verwendet dieses Panel als inhaltliche Basis
 * der Dialogbox. Letztere wird ueber die Hilfsklasse Util.PanelDialog
 * erzeugt.
 * <DL><DT><B>Modifications: </B><DD>
 * In dumpBtn_actionPerformed JDialog durch JOptionPane.showOptionDialog
 * ersetzt.<br>
 * Thomas Hacklaender 2000.08.22:
 * Copyright Mitteilung von der Dialogbox in dieses Panel verlagert.<br>
 * Thomas Hacklaender 2000.08.22:
 * Klasse von JPanel abgeleitet.<br>
 * </DD></DL>
 * @author   Thomas Hacklaender
 * @version  2000.08.22
 */
public class ImportPanel extends JPanel {

	/**
	 * Mit diesem Datenblock werden Daten zwischen dem Plugin und der Dialgobox
	 * sowie deren Panels ausgetauscht.
	 */
	private ImportData	imda;

	private String			workingDir = null;
	private String			aktFileName = null;


	/* Allgemeine Felder fuer das Layout */
	JTabbedPane					tabbedPane = new JTabbedPane();
	JPanel							selectPanel = new JPanel();
	JButton							selectBtn = new JButton();
	GridBagLayout				gridBagLayout3 = new GridBagLayout();
	JPanel							fileInfo = new JPanel();
	ImageBtnPanel				dcmImageBP = new ImageBtnPanel();
	JPanel							imgP = new JPanel();
	JButton							dumpBtn = new JButton();
	JPanel							patientPanel = new JPanel();
	JPanel							studyPanel = new JPanel();
	JPanel							seriesPanel = new JPanel();
	JPanel							imagePanel = new JPanel();
	JTextArea						patientInfo = new JTextArea();
	JTextArea						studyInfo = new JTextArea();
	JTextArea						seriesInfo = new JTextArea();
	JTextArea						imageInfo = new JTextArea();
	JTextArea						planePixelInfo = new JTextArea();
	JPanel							planePixelPanel = new JPanel();
	JTextArea						modalityInfo = new JTextArea();
	JPanel							modalityPanel = new JPanel();
	GridBagLayout				gridBagLayout1 = new GridBagLayout();
	GridBagLayout				gridBagLayout2 = new GridBagLayout();
	GridBagLayout				gridBagLayout4 = new GridBagLayout();
	GridBagLayout				gridBagLayout5 = new GridBagLayout();
	GridBagLayout				gridBagLayout6 = new GridBagLayout();
	GridBagLayout				gridBagLayout7 = new GridBagLayout();
	GridBagLayout				gridBagLayout8 = new GridBagLayout();
	GridBagLayout				gridBagLayout9 = new GridBagLayout();
	GridBagLayout				gridBagLayout10 = new GridBagLayout();
	GridBagLayout				gridBagLayout11 = new GridBagLayout();
	JScrollPane					fileScrollP = new JScrollPane();
	JList								fileL = new JList();
	JLabel							patNameL = new JLabel();
	JLabel							patBirthT = new JLabel();
	JLabel							patBirthL = new JLabel();
	JLabel							patNameT = new JLabel();
	JLabel							studyL = new JLabel();
	JLabel							studyT = new JLabel();
	JLabel							seriesL = new JLabel();
	JLabel							seriesT = new JLabel();
	JLabel							instanceL = new JLabel();
	JLabel							instanceT = new JLabel();
	JPanel							infoP = new JPanel();
	FileListPanel				fileListP = new FileListPanel();
	JScrollPane					modalityScrollPane = new JScrollPane();

	/**
	 * Hier kann eine Copyright Mitteilung eingesetz werden.
	 */
  public JLabel       copyrightL = new JLabel();


	/**
	 * Konstruktor. Initialisiert das Grafiklayout.
	 */
	public ImportPanel() {
		try {
			jbInit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}


	/**
	 * Die Instanz wird mit dem Datenblock des Plugins initialisiert.
	 * In dieser Methode sollten auch alle anderen Initialisierungs
	 * vorgaenge gestartet werden.
	 * Fuer den Zugriff durch aller Methoden der Instanz wird eine
	 * Referenz auf den Datenblock des Plugins als globales Instanz-
	 * feld definiert.
	 * @param d		Datenblock des Plugins.
	 */
	public void initWithDataBlock(ImportData id) {
		imda = id;
		fileListP.intWithDataBlock(imda);
	}


	/**
	 * Durch den Aufruf der Methode sollten alle Felder des Datenblocks
	 * des Plugins auf den aktuellen Wert gesetzt werden.
	 */
	public void updateDataBlock() {
		fileListP.updateDataBlock();
	}


	/**
	 * Es wird ein JFileChooser zur Auswahl des Eingabeverzeichnisses
	 * praesentiert. Die ausgewaehlte Datei wird bearbeitet (Methode open)
	 * und es werden alle DICOM dateien in dem ausgewaehlten Verzeichnis
	 * in der Liste fileL dargestellt.
	 */
	private void selectFile() {
		File						f;
		FileInputStream fis;

		JFileChooser		chooser = new JFileChooser();

		chooser.setDialogTitle("Select a DICOM file...");
		if (imda.inputDir != null) {
			chooser.setCurrentDirectory(imda.inputDir);
		}
		chooser.showOpenDialog(this);
		f = chooser.getSelectedFile();
		if (f == null) {
			return;
		}
		imda.inputDir = new File(f.getParent());

		workingDir = f.getParent() + f.separator;
		aktFileName = f.getName();
		openFile();

		String[]	fl = (new File(workingDir)).list();

		if (fl != null) {
			Util.bubbleSortStrings(fl);
			Vector	v = new Vector();

			for (int i = 0; i < fl.length; i++) {
				try {
					fis = new FileInputStream(workingDir + fl[i]);
					if (DcmInputStream.isDicomStream(new BufferedInputStream(fis))) {
						v.addElement(fl[i]);
					}
					fis.close();
				} catch (Exception ex) {}
			}
			fileL.setListData(v);
			fileL.invalidate();
			fileScrollP.invalidate();
			this.validate();
		}
	}


	/**
	 * Die im Datenblock unter theFile angegebene Datei wird geoeffnet,
	 * in ein GeneralImageIOD umgewandelt und bearbeitet (Methode
	 * processDcmImageFileObject).
	 */
	private void openFile() {
		DcmDataObject		ddo;

		try {
			imda.theFile = new File(workingDir + aktFileName);
			ddo = DcmInputStream.loadDDO(imda.theFile);
			imda.theGI = new GeneralImageIOD(ddo, imda.allowACRNema);
			processDcmImageFileObject();
		} catch (Exception err) {
			Util.showErrorDialog(err.getMessage());
		}
	}


	/**
	 * Das im Datenblock unter theGI.headerDDO angegeben DcmDataObject wird
	 * analysiert: Die Bildinformation wird ber ein rad.dicom.ima.ImageBtnPanel
	 * dagestellt. Die Patienten und Bildinformationen werden in einer Text-
	 * darstellung auf verschiedenen, nach DICOM Modules organisierten
	 * Karteikarten aufgelistet.
	 * @throws Exception
	 */
	private void processDcmImageFileObject() throws Exception {
		DcmDataObject ddo;
		String				infoStr = "";

		ddo = imda.theGI.headerDDO;
		if (ddo == null) {
			throw new Exception("processDcmImageFileObject: No DcmDataObject specified");
		}

		dcmImageBP.setImage(imda.theGI);

		if (ddo.getStorage() == DcmDataObject.PLAIN_STORAGE) {
			infoStr += "PLAIN";
		} else {
			infoStr += "META";
		}
		if (ddo.getStructure() == DcmDataObject.EXPLICITE_VR) {
			infoStr += "-EX";
		} else {
			infoStr += "-IM";
		}
		if (ddo.getEncoding() == DcmDataObject.LITTLE_ENDIAN) {
			infoStr += "-LI: ";
		} else {
			infoStr += "-BI: ";
		}
		if (imda.theFile != null) {
			infoStr += imda.theFile.getName();
		}
		setInfoBorder(infoStr);

		fillGeneralInfo(ddo);
		fillPatientInfo(ddo);
		fillStudyInfo(ddo);
		fillSeriesInfo(ddo);
		fillImageInfo(ddo);
		fillPlanePixelInfo(ddo);
		fillModalityInfo(ddo);
	}


	/**
	 * Fuellt die allgemeinen Patienten/Bild-Daten der vordersten
	 * Karteikarte mit Informationen.
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillGeneralInfo(DcmDataObject ddo) {
		patNameT.setText(ddo.getString(DcmDDE.DD_PatientsName));
		patBirthT.setText(ddo.getString(DcmDDE.DD_PatientsBirthDate));
		studyT.setText(ddo.getString(DcmDDE.DD_StudyDate) + " / " + ddo.getString(DcmDDE.DD_StudyID));
		seriesT.setText(ddo.getString(DcmDDE.DD_SeriesNumber));
		instanceT.setText(ddo.getString(DcmDDE.DD_InstanceNumber));
	}


	/**
	 * Fuellt die Karteikarte "Patient" mit Informationen.
	 * dargestellt werden. Siehe:
	 * Patient Module PS 3.3-C.7.1.1
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillPatientInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_PatientsName, 27);
		s += "\n";
		s += getDcmValueString(ddo, DcmDDE.DD_PatientID, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PatientsBirthDate, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PatientsSex, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReferencedPatientSequence, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PatientsBirthTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_OtherPatientIDs, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_OtherPatientNames, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_EthnicGroup, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PatientComments, 27);

		patientInfo.setText(s);
	}


	/**
	 * Fuellt die Karteikarte "Study" mit Informationen.
	 * dargestellt werden. Siehe:
	 * General Study Module PS 3.3-C.7.2.1
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillStudyInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_StudyInstanceUID, 27);
		s += "\n";
		s += getDcmValueString(ddo, DcmDDE.DD_StudyDate, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_StudyTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReferringPhysiciansName, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_StudyID, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AccessionNumber, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_StudyDescription, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PhysicianOfRecord, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_NameOfPhysicianReadingStudy, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReferencedStudySequence, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ProcedureCodeSequence, 27);

		studyInfo.setText(s);
	}


	/**
	 * Fuellt die Karteikarte "Series" mit Informationen.
	 * dargestellt werden. Siehe:
	 * Series Module PS 3.3-C.7.3.1
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillSeriesInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_SeriesInstanceUID, 27);
		s += "\n";
		s += getDcmValueString(ddo, DcmDDE.DD_SeriesNumber, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_Modality, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_Laterality, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SeriesDate, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SeriesTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PerformingPhysiciansName, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ProtocolName, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SeriesDescription, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_OperatorsName, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReferencedStudyComponentSequence, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_BodyPartExamined, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PatientPosition, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SmallestPixelValueInSeries, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_LargestPixelValueInSeries, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_RequestAttributesSequence, 27);

		seriesInfo.setText(s);
	}


	/**
	 * Fuellt die Karteikarte "Image" mit Informationen.
	 * dargestellt werden. Siehe:
	 * General Imgage Module PS 3.3-C.7.6.1
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillImageInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_InstanceNumber, 27);
		s += "\n";
		s += getDcmValueString(ddo, DcmDDE.DD_PatientOrientation, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImageDate, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImageTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImageType, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AcquisitionNumber, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AcquisitionDate, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AcquisitionTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReferencedImageSequence, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_DerivationDescription, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SourceImageSequence, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImagesInAcquisition, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImageComments, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_QualityControlImage, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_BurnedInAnnotation, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_LossyImageCompression, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_LossyImageCompressionRatio, 27);

		imageInfo.setText(s);
	}


	/**
	 * Fuellt die Karteikarte "Plan/Pixel" mit Informationen.
	 * dargestellt werden. Siehe:
	 * Imgage Plane Module PS 3.3-C.7.6.2
	 * Image Pixel Module PS 3.3-C.7.6.3
	 * VOI LUT Module PS 3.3-C.11.2
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillPlanePixelInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_PixelSpacing, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImageOrientationPatient, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImagePositionPatient, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SliceThickness, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SliceLocation, 27);
		s += "\n";
		s += getDcmValueString(ddo, DcmDDE.DD_SamplesPerPixel, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PhotometricInterpretation, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_Rows, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_Columns, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_BitsAllocated, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_BitsStored, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_HighBit, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PixelRepresentation, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PlanarConfiguration, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PixelAspectRatio, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SmallestImagePixelValue, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_LargestImagePixelValue, 27);
		s += "\n";
		s += getDcmValueString(ddo, DcmDDE.DD_WindowCenter, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_WindowWidth, 27);

		planePixelInfo.setText(s);
	}


	/**
	 * Fuellt die Karteikarte "Modality" mit den modalitaetsspezifischen
	 * Informationen. Zur Zeit koennen erst die CT und MR Image Modules
	 * dargestellt werden.
	 * CT Image Module PS 3.3-C.8.2.1
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private String fillCTInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_ImageType, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_RescaleIntercept, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_RescaleSlope, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_KVP, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AcquisitionNumber, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ScanOptions, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_DataCollectionDiameter, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReconstructionDiameter, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_DistanceSourceToDetector, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_DistanceSourceToPatient, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_GantryDetectorTilt, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_TableHeight, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_RotationDirection, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ExposureTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_XrayTubeCurrent, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_Exposure, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_FilterType, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_GeneratorPower, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_FocalSpot, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ConvolutionKernel, 27);

		return s;
	}


	/**
	 * Fuellt die Karteikarte "Modality" mit den modalitaetsspezifischen
	 * Informationen. Zur Zeit koennen erst die CT und MR Image Modules
	 * dargestellt werden.
	 * MR Image Module PS 3.3-C.8.3.1
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private String fillMRInfo(DcmDataObject ddo) {
		String	s = "";

		s += getDcmValueString(ddo, DcmDDE.DD_ImageType, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ScanningSequence, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SequenceVariant, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ScanOptions, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_MRAcquisitionType, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_RepetitionTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_EchoTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_EchoTrainLength, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_InversionTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_TriggerTime, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SequenceName, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AngioFlag, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_NumberOfAverages, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImagingFrequency, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ImagedNucleus, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_EchoNumber, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_MagneticFieldStrength, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SpacingBetweenSlices, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_NumberOfPhaseEncodingSteps, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PercentSampling, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PercentPhaseFieldOfView, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PixelBandwidth, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_NominalInterval, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_BeatRejectionFlag, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_LowRRValue, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_HighRRValue, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_IntervalsAcquired, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_IntervalsRejected, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PVCRejection, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SkipBeats, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_HeartRate, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_CardiacNumberOfImages, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_TriggerWindow, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReconstructionDiameter, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_ReceivingCoil, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_TransmittingCoil, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_AcquisitionMatrix, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_PhaseEncodingDirection, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_FlipAngle, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_SAR, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_VariableFlipAngleFlag, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_dBdt, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_TemporalPositionIdentifier, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_NumberOfTemporalPositions, 27);
		s += getDcmValueString(ddo, DcmDDE.DD_TemporalResolution, 27);

		return s;
	}


	/**
	 * Fuellt die Karteikarte "Modality" mit den modalitaetsspezifischen
	 * Informationen. Zur Zeit koennen erst die CT und MR Image Modules
	 * dargestellt werden.
	 * @param	ddo		Das DcmDataObject, das die Informationen enthaelt.
	 */
	private void fillModalityInfo(DcmDataObject ddo) {
		String	classUID;
		String	s = "";

		// SOP Common III.C.12.1 p.139
		s = ddo.getString(DcmDDE.DD_SOPClassUID);
		classUID = s;
		if (classUID.compareTo(DcmUID.CT_STORAGE_UID) == 0) {
			modalityInfo.setText(fillCTInfo(ddo));
			return;
		}
		if (classUID.compareTo(DcmUID.MR_STORAGE_UID) == 0) {
			modalityInfo.setText(fillMRInfo(ddo));
			return;
		}
		modalityInfo.setText("");
	}


	/**
	 * Generiert einen String Darstellung Eines Daten Elementes. Ist das
	 * Datenelement nicht definiert, dann wird der String "" zurueckgegeben.
	 * @param	ddo		Das DcmDataObject, das analysiert werden soll.
	 * @param type	Der Type des Daten Elementes, das in ddo gesucht werden soll.
	 * @param len		Die maximale Laenge, mit der der Inhalt dargestellt werden
	 * soll.
	 * @return			Die String-Darstellung des Daten Elementes
	 */
	private String getDcmValueString(DcmDataObject ddo, int type, int len) {
		DcmValue	dv = ddo.getDcmValue(type);

		if (dv == null) {
			return "";
		} else {
			return dv.toString(true, len, false, 256, false) + "\n";
		}
	}


	/**
	 * Transfer-Syntax und Filename werden als Beschriftung des Rahmens um das
	 * Panel dargestellt.
	 * @param s  Beschriftung
	 */
	private void setInfoBorder(String s) {
		fileInfo.setBorder(new TitledBorder(new LineBorder(Color.darkGray), s));
		fileInfo.repaint();
	}


	/**
	 * Von JBuilder automatisch generierte Action-Methode fuer den
	 * selectBtn. Wird der Button gedrueck, wird ein JFileChooser zur
	 * Auswahl des Eingabeverzeichnisses praesentiert.
	 * @param   e   Das Action Event.
	 */
	void selectBtn_actionPerformed(ActionEvent e) {
		selectFile();
	}


	/**
	 * Von JBuilder automatisch generierte Value Changed-Methode fuer die
	 * fileL. Wird ein Eintrag in der Liste gewaehlt, wird die entsprechende
	 * Datei geoeffnet, analysiert und angezeigt.
	 * @param   e   Das Value Changed Event.
	 */
	void fileL_valueChanged(ListSelectionEvent e) {
		int i = fileL.getAnchorSelectionIndex();

		if (i < 0) {
			return;

		}
		String	s = (String) fileL.getModel().getElementAt(i);

		if (s.compareTo(aktFileName) == 0) {
			return;

		}
		aktFileName = s;
		openFile();
	}


	/**
	 * Von JBuilder automatisch generierte Action-Mmethode fuer den
	 * dumpBtn. Wird der Button gedrueck, wird eine Dialogbox mit einem
	 * DumpPanel praesentiert.
	 * @param   e   Das Action Event.
	 */
	void dumpBtn_actionPerformed(ActionEvent e) {
		DumpPanel dp;
		JDialog		d;

		if (imda.theGI == null) {
			return;
		}

		dp = new DumpPanel(imda.outputDir);
		try {
			dp.processDcmDataObject(imda.theGI.headerDDO);
		} catch (Exception err) {}

    // Geaendert: tha 2000.8.22
    Object[] options = { "OK" };
    int diaRes = JOptionPane.showOptionDialog(null, dp, "DICOM file dump", JOptionPane.DEFAULT_OPTION, JOptionPane.PLAIN_MESSAGE, null, options, options[0]);
    if (diaRes == JOptionPane.OK_OPTION) {}
    /*
		d = new JDialog();
		d.setTitle("");
		d.setSize((dp.getPreferredSize()).width, (dp.getPreferredSize()).height);
		d.setModal(true);
		d.setLocationRelativeTo(d);		// center on screen (d is invisble!)
		d.getContentPane().add(dp, BorderLayout.CENTER);
		d.validate();
		d.setVisible(true);
		while (d.isVisible()) {}
		;
		if (d != null) {
			d.dispose();
		}
    */
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 */
	private void jbInit() throws Exception {
		DefaultListSelectionModel m = new DefaultListSelectionModel();

		m.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		fileL.setSelectionModel(m);

		this.setMinimumSize(new Dimension(620, 420));
		this.setPreferredSize(new Dimension(620, 420));

		fileInfo.setPreferredSize(new Dimension(230, 272));
		fileInfo.setBackground(SystemColor.control);
		fileInfo.setBorder(new LineBorder(Color.darkGray));
		fileInfo.setMinimumSize(new Dimension(230, 222));
		fileInfo.setLayout(gridBagLayout10);

		setInfoBorder("No file selected");

		selectPanel.setBackground(SystemColor.control);

		selectBtn.setText("Select a DICOM file");
		selectBtn.setPreferredSize(new Dimension(150, 25));
		selectBtn.setSelected(true);
		selectBtn.setMinimumSize(new Dimension(150, 25));
		selectBtn.requestDefaultFocus();

		dcmImageBP.setPreferredSize(new Dimension(175, 175));
		dcmImageBP.setMinimumSize(new Dimension(175, 175));
		dcmImageBP.setSize(new Dimension(132, 132));

		imgP.setPreferredSize(new Dimension(142, 250));
		imgP.setBackground(SystemColor.control);
		imgP.setMinimumSize(new Dimension(132, 200));


		dumpBtn.setText("Dump");
		dumpBtn.setPreferredSize(new Dimension(59, 25));
		dumpBtn.setMinimumSize(new Dimension(59, 25));
		patientPanel.setBackground(SystemColor.control);
		studyPanel.setBackground(SystemColor.control);
		seriesPanel.setBackground(SystemColor.control);
		imagePanel.setBackground(SystemColor.control);
		imagePanel.setLayout(gridBagLayout5);
		seriesPanel.setLayout(gridBagLayout4);
		studyPanel.setLayout(gridBagLayout2);
		patientPanel.setLayout(gridBagLayout1);
		patientInfo.setBackground(SystemColor.control);
		patientInfo.setEditable(false);
		patientInfo.setFont(new java.awt.Font("Monospaced", 0, 12));

		modalityPanel.setLayout(gridBagLayout7);
		modalityInfo.setBackground(SystemColor.control);
		modalityInfo.setEditable(false);
		modalityInfo.setFont(new java.awt.Font("Monospaced", 0, 12));
		modalityPanel.setBackground(SystemColor.control);
		fileScrollP.setPreferredSize(new Dimension(150, 75));
		fileScrollP.setMinimumSize(new Dimension(150, 75));
		fileL.addListSelectionListener(new ListSelectionListener() {
			/**
			 */
			public void valueChanged(ListSelectionEvent e) {
				fileL_valueChanged(e);
			}

		});
		infoP.setLayout(gridBagLayout8);
		planePixelPanel.setLayout(gridBagLayout6);
		planePixelInfo.setBackground(SystemColor.control);
		planePixelInfo.setEditable(false);
		planePixelInfo.setFont(new java.awt.Font("Monospaced", 0, 12));
		planePixelPanel.setBackground(SystemColor.control);
		imageInfo.setBackground(SystemColor.control);
		imageInfo.setEditable(false);
		imageInfo.setFont(new java.awt.Font("Monospaced", 0, 12));
		seriesInfo.setBackground(SystemColor.control);
		seriesInfo.setEditable(false);
		seriesInfo.setFont(new java.awt.Font("Monospaced", 0, 12));
		studyInfo.setBackground(SystemColor.control);
		studyInfo.setEditable(false);
		studyInfo.setFont(new java.awt.Font("Monospaced", 0, 12));
		dumpBtn.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				dumpBtn_actionPerformed(e);
			}

		});
		imgP.setLayout(gridBagLayout9);
		selectBtn.addActionListener(new java.awt.event.ActionListener() {
			/**
			 */
			public void actionPerformed(ActionEvent e) {
				selectBtn_actionPerformed(e);
			}

		});
		selectPanel.setLayout(gridBagLayout11);
		this.setLayout(gridBagLayout3);
		fileListP.setPreferredSize(new Dimension(200, 10));

		patNameL.setText("Patient\'s Name:");
		patNameT.setText("?");
		patBirthL.setText("Patient\'s Birth Date:");
		patBirthT.setText("?");
		studyL.setText("Study Date / ID:");
		studyT.setText("?");
		seriesL.setText("Series Number:");
		seriesT.setText("?");
		instanceL.setText("Instance (Image) ID:");
		instanceT.setText("?");
		modalityScrollPane.setBorder(null);

    copyrightL.setToolTipText("");
    copyrightL.setText("(c) 2000 Thomas Hacklaender, see GPL Lizense");
    this.add(tabbedPane, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 10, 5, 10), 0, 0));
		tabbedPane.addTab("Select File", selectPanel);
		selectPanel.add(selectBtn, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));
		selectPanel.add(fileInfo, new GridBagConstraints2(0, 0, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 0, 0));
		fileInfo.add(imgP, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 5), 0, 0));
		imgP.add(dcmImageBP, new GridBagConstraints2(0, 0, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
		imgP.add(dumpBtn, new GridBagConstraints2(0, 3, GridBagConstraints.REMAINDER, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(8, 4, 8, 4), 0, 0));
		fileInfo.add(infoP, new GridBagConstraints2(1, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 5, 0, 0), 0, 0));
		infoP.add(fileListP, new GridBagConstraints2(0, 5, 3, 1, 1.0, 1.0, GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		infoP.add(patNameL, new GridBagConstraints2(0, 0, 2, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 4, 0, 8), 0, 0));
		infoP.add(seriesL, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 4, 0, 8), 0, 0));
		infoP.add(patBirthL, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 4, 0, 8), 0, 0));
		infoP.add(patNameT, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		infoP.add(patBirthT, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		infoP.add(seriesT, new GridBagConstraints2(2, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		infoP.add(instanceL, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 4, 0, 8), 0, 0));
		infoP.add(studyL, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 4, 0, 8), 0, 0));
		infoP.add(studyT, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		infoP.add(instanceT, new GridBagConstraints2(2, 4, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		selectPanel.add(fileScrollP, new GridBagConstraints2(0, 1, 1, 1, 1.0, 0.5, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 10, 10, 0), 0, 0));
    fileScrollP.getViewport().add(fileL, null);
		tabbedPane.addTab("Patient", patientPanel);

		patientPanel.add(patientInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 472, 301));
		tabbedPane.addTab("Study", studyPanel);
		studyPanel.add(studyInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 471, 301));
		tabbedPane.addTab("Series", seriesPanel);
		seriesPanel.add(seriesInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 472, 301));
		tabbedPane.addTab("Image", imagePanel);
		imagePanel.add(imageInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 472, 301));
		tabbedPane.addTab("Plane / Pixel", planePixelPanel);
		planePixelPanel.add(planePixelInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 484, 316));
		tabbedPane.addTab("Modality", modalityPanel);
		modalityPanel.add(modalityScrollPane, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 0, 0));
    this.add(copyrightL, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 10, 0, 10), 0, 0));
		modalityScrollPane.getViewport().add(modalityInfo, null);
	}

}





/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

